<?php
/*********************************************************************************
 * TimeTrex is a Payroll and Time Management program developed by
 * TimeTrex Payroll Services Copyright (C) 2003 - 2010 TimeTrex Payroll Services.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY TIMETREX, TIMETREX DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along
 * with this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact TimeTrex headquarters at Unit 22 - 2475 Dobbin Rd. Suite
 * #292 Westbank, BC V4T 2E9, Canada or at email address info@timetrex.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by TimeTrex" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by TimeTrex".
 ********************************************************************************/
/*
 * $Revision: 3415 $
 * $Id: HierarchyControlList.php 3415 2010-03-12 22:31:26Z ipso $
 * $Date: 2010-03-12 14:31:26 -0800 (Fri, 12 Mar 2010) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('hierarchy','enabled')
		OR !( $permission->Check('hierarchy','view') OR $permission->Check('hierarchy','view_own') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title', TTi18n::gettext($title = 'Hierarchy List')); // See index.php
BreadCrumb::setCrumb($title);

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'page',
												'sort_column',
												'sort_order',
												'ids',
												'id'
												) ) );

URLBuilder::setURL($_SERVER['SCRIPT_NAME'],
											array(
													'sort_column' => $sort_column,
													'sort_order' => $sort_order,
													'page' => $page
												) );

$sort_array = NULL;
if ( $sort_column != '' ) {
	$sort_array = array($sort_column => $sort_order);
}


//$ppslf = new PayPeriodScheduleFactory();

Debug::Arr($ids,'Selected Objects', __FILE__, __LINE__, __METHOD__,10);

$action = Misc::findSubmitButton();
switch ($action) {
	case 'add':

		Redirect::Page( URLBuilder::getURL(NULL, 'EditHierarchyControl.php', FALSE) );

		break;
	case 'delete' OR 'undelete':
		if ( strtolower($action) == 'delete' ) {
			$delete = TRUE;
		} else {
			$delete = FALSE;
		}

		$hclf = new HierarchyControlListFactory();

		foreach ($ids as $id) {
			//$dsclf->GetByIdAndUserId($id, $current_user->getId() );
			$hclf->GetById($id);
			foreach ($hclf as $hierarchy_control) {
				$hierarchy_control->setDeleted($delete);
				$hierarchy_control->Save();
			}
		}

		Redirect::Page( URLBuilder::getURL(NULL, 'HierarchyControlList.php') );

		break;

	default:
		$hclf = new HierarchyControlListFactory();
		$hclf->getByCompanyId($current_company->getId(), $current_user_prefs->getItemsPerPage(), $page, NULL, $sort_array );

		$pager = new Pager($hclf);

		$hotf = new HierarchyObjectTypeFactory();
		$object_type_options = $hotf->getOptions('object_type');

		foreach ($hclf as $hierarchy_control) {
			$object_type_ids = $hierarchy_control->getObjectType();

			$object_types = array();
			foreach($object_type_ids as $object_type_id) {
				if ( isset($object_type_options[$object_type_id]) ) {
					$object_types[] = $object_type_options[$object_type_id];
				}
			}

			$hierarchy_controls[] = array(
				'id' => $hierarchy_control->getId(),
				'name' => $hierarchy_control->getName(),
				'description' => $hierarchy_control->getDescription(),
				'object_types' => $object_types,
				'deleted' => $hierarchy_control->getDeleted()
				);

			unset($object_types);
		}

		$smarty->assign_by_ref('hierarchy_controls', $hierarchy_controls);

		$smarty->assign_by_ref('sort_column', $sort_column );
		$smarty->assign_by_ref('sort_order', $sort_order );

		$smarty->assign_by_ref('paging_data', $pager->getPageVariables() );

		break;
}
$smarty->display('hierarchy/HierarchyControlList.tpl');
?>