#!/usr/bin/perl

####################################################################
#
#This software is released under the GPL.  Please
#see the included LICENSE file.
#
#Copyright (C) 2001  Michael Spiceland
#Copyright (C) 2001  Jay Kline
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#Use this script at your own risk!  I make no 
#warranties that it is hack proof!
#
#
# This script is part of the Fuzzymonkey Perl Script Archive at
# www.fuzzymonkey.org/perl/
#
# Edited by Jay Kline www.slushpupie.com
#
####################################################################

use CGI qw(:standard);
use Text::Wrap;
require "common.pl";
require "sitevariables.pl";

############ BEGIN MAIN PROGRAM ################################
$cur = CGI->new();
$mode = "default";
if($cur->param("mode")) {
	$mode = $cur->param("mode");
}

$content .= check_requirements();
$content .= make_eventsfile();
$content .= make_month();
$content .= make_year();

print_popup($content);


############ BEGIN SUBS ################################
sub make_month{
	my $return;

	return $return;
}

sub make_year{
	my $return;
	my ($sec,$min,$hr,$mday,$mon,$year_localtime,$wday,$yday,$isdst) = localtime(time());
	$year = $year_localtime + 1900;
	$current_month = $mon + 1;

	if($cur->param('year')){$year=$cur->param('year');}
	
	if(-e "$calendar_path/calendar_year.ps"){unlink("$calendar_path/calendar_year.ps");}
	open(CALENDAR,">>$calendar_path/calendar_year.ps")|| die_popup("Could not write out the calendar: $!");
	flock(CALENDAR,2);
	for($month=1;$month <13;$month++){
		$output = `$pscal $month $year`;
		print CALENDAR $output;
	}
	flock(CALENDAR,8);
	close(CALENDAR);
	if($ps2pdf){
		`$ps2pdf $calendar_path/calendar_year.ps $calendar_path/calendar_year.pdf`;
	}

	if(-e "$calendar_path/calendar_year.ps"){
		$return .= "<p><a href=\"$calendar_url/calendar_year.ps\">Postscript</a> - entire year of $year</p>";
	}else{
		$return .= "<p>PostScript not available.  Something must have messed up
		with pscal.</p>";
	}
	if(-e "$calendar_path/calendar_year.pdf"){
		$return .= "<p><a href=\"$calendar_url/calendar_year.pdf\">PDF</a> - entire year of $year</p>";
	}else{
		$return .= "<p>PDF not available.  Something must have messed up
		with ps2pdf.</p>";
	}
	$return .= "<hr><p><b>Windows users:</b> use <a href=\"http://www.cs.wisc.edu/~ghost/gsview/index.htm\" target=\"new\">gsview</a> to view PostScript files and <a href=\"http://www.adobe.com\" target=\"new\">Acrobat Reader</a> to view PDF files.</p>";
	$return .= "<p><b>Linux or Unix users:</b> use gv to view PostScript files and xpdf or acroread to read PDF files.</p>";

	return $return;
}

sub die_popup($){
	print_popup($_[0]);
	exit(3);
}

sub make_eventsfile{
	my $return;
	my ($date,$app,$number);
	my @text;

	open(EVENTS,"> ./Events");
	flock(EVENTS,2);
	
	if(open(APPOINTMENTS, "< ./appointments.txt")){
		while(<APPOINTMENTS>){
			chomp;
			($date,$app,$number) = split(/\t/,"$_");
			($month,$day,$year)= split(/-/,"$date");
			$Text::Wrap::columns = 21;
			$app =~ s/[\(\)]/ /gi; # get rid of ()
			@text = ("$app","");
			$app = wrap("","",@text);
			if($month eq "*"){
				# one for every month
				$count =0;
				$events="";
				while($count < 12){
					$count++;
					$events = "$count:$day:$app";
					$events =~ s/\n/\n$count:$day:/g;
					print EVENTS "$events\n";
				}
			}else{
				$app =~ s/\n/\n$month:$day:/g;
				print EVENTS "$month:$day:$app\n";
			}

		}
		close(APPOINTMENTS);
	}else{
		print_popup("could not open appointments.txt file for reading\n");
		exit(3);
	}
	flock(EVENTS,8);
	close(EVENTS);
	return $return;
}
sub check_requirements{
	my $return;
	my $error;
	

	unless($pscal){
		$error .= "<p>ERROR: pscal is not specified in the config file</p>";	
	}
	unless($ps2pdf){
		#$return.= "<p><font color=red>Warning: ps2pdf is not specified in the config file.  You will not be able to generate PDF files.</font></p>";	
	}
	if($pscal && !(-x $pscal)){
		$error .= "<p>ERROR: pscal was specified as $pscal but there is not
		an executable file at this location.  Check that it exists and that
		it is executable.</p>";	
	}
	if($ps2pdf && !(-x $ps2pdf)){
		$error .= "<p>ERROR: ps2pdf was specified as $ps2pdf but there is not
		an executable file at this location.  Check that it exists and that
		it is executable.</p>";	
	}

	if($error){
		print_popup($error);
		exit(3);
	}

	return $return;
}
sub print_popup($){
	my $return;
	
	print "Content-type: text/html\n\n
<html>
<head><title></title></head>
<body bgcolor=#FFFFFF>
$_[0]
</body>";
	return $return;
}
