# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Gernot Klimscha <gernot@fluendo.com>

"""
Models for iPod resource
"""

from elisa.core.components.model import Model
from elisa.plugins.base.models.audio import AlbumModel, TrackModel, ArtistModel

class IpodTrackModel(TrackModel):
    """
    The IpodTrackModel represents a track on the ipod

    @ivar artist:       artist name
    @type artist:       C{str}
    @ivar album:        album name
    @type album:        C{str}
    @ivar id:           song id
    @type id:           C{str}
    @ivar track_number:  ipod internal song number
    @type track_number:  C{str}
    @ivar title:         song title
    @type title:         C{str}
    @ivar path:         song path
    @type path:         L{elisa.core.media_uri.MediaUri}
    @ivar filetype:     song filetype
    @type filetype:     C{str}
    """
    def __init__(self, artist=None, album=None, song_id=None, nr=None,
                 title=None, path=None, typ=None):
        super(IpodTrackModel, self).__init__()
        self.artist = artist
        self.album = album
        self.id = song_id
        self.track_number = nr
        self.title = title
        self.path = path
        self.filetype = typ

class IpodSongModel(TrackModel):
    """
    The IpodSongModel represents a song

    @ivar name:         song name
    @type name:         C{str}
    @ivar path:         song path
    @type path:         L{elisa.core.media_uri.MediaUri}
    @ivar filetype:     song filetype
    @type filetype:     C{str}
    """
    def __init__(self, name=None, path=None, typ=None, artist=None):
        super(IpodSongModel, self).__init__()
        self.name = name
        self.path = path
        self.filetype = typ
        self.artist = artist
        
    def __cmp__(self, other):
        self_label = "%s - %s" % (self.artist, self.name)
        other_label = "%s - %s" % (other.artist, other.name)
        if self_label < other_label:
            return -1
        elif self_label > other_label:
            return 1
        else:
            return 0

"""
list models
"""
class IpodTrackListModel(Model):
    """
    List of L{elisa.plugins.ipod.models.IpodTrackModel}s

    @ivar tracks:        list of tracks
    @type tracks:        C{list} of L{elisa.plugins.ipod.models.IpodTrackModell}s
    """
    def __init__(self):
        super(IpodTrackListModel, self).__init__()
        self.tracks = []

    def __len__(self):
        return len(self.tracks)

class IpodSongListModel(Model):
    """
    List of L{elisa.plugins.ipod.models.IpodSongModel}s

    @ivar songs:        list of songs
    @type songs:        C{list} of L{elisa.plugins.ipod.models.IpodSongModel}s
    """
    def __init__(self):
        super(IpodSongListModel, self).__init__()
        self.songs = []

    def __len__(self):
        return len(self.songs)

class IpodAlbumListModel(Model):
    """
    List of L{elisa.plugins.base.models.audio.AlbumModel}s

    @ivar albums:      list of albums
    @type albums:      C{list} of L{elisa.plugins.base.models.audio.AlbumModel}s
    """
    def __init__(self):
        super(IpodAlbumListModel, self).__init__()
        self.albums = []

    def __len__(self):
        return len(self.albums)

class IpodArtistListModel(Model):
    """
    List of L{elisa.plugins.base.models.audio.ArtistModel}s

    @ivar artists:    list of artists
    @type artists:    C{list} of L{elisa.plugins.base.models.audio.ArtistModel}s
    """
    def __init__(self):
        super(IpodArtistListModel, self).__init__()
        self.artists = []

    def __len__(self):
        return len(self.artists)

