% ACOSD ACOSD Inverse Cosine Degrees Function
% 
% Usage
% 
% Computes the inverse cosine of the argument, but returns
% the argument in degrees instead of radians (as is the case
% for acos. The syntax for its use is
% 
%    y = acosd(x)
% 

% Copyright (c) 2002-2007 Samit Basu
% Licensed under the GPL

function y = acosd(x)
  if (nargin == 0 || ~isnumeric(x) || ~isreal(x))
    error('acosd expects a real numeric input');
  end
  y = rad2deg(acos(x));
