require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_MIDIIO_H_)) {
    eval 'sub _SYS_MIDIIO_H_ () {1;}' unless defined(&_SYS_MIDIIO_H_);
    require 'sys/cdefs.ph';
    require 'machine/endian.ph';
    eval 'sub MIDI_PRETIME () { &_IOWR(ord(\'m\'), 0, \'int\');}' unless defined(&MIDI_PRETIME);
    eval 'sub MIDI_MPUMODE () { &_IOWR(ord(\'m\'), 1, \'int\');}' unless defined(&MIDI_MPUMODE);
    eval 'sub MIDI_MPUCMD () { &_IOWR(ord(\'m\'), 2,  &mpu_command_rec);}' unless defined(&MIDI_MPUCMD);
    eval 'sub MIDI_ACK () {0xfe;}' unless defined(&MIDI_ACK);
    eval 'sub SEQUENCER_RESET () { &_IO (ord(\'Q\'), 0);}' unless defined(&SEQUENCER_RESET);
    eval 'sub SEQUENCER_SYNC () { &_IO (ord(\'Q\'), 1);}' unless defined(&SEQUENCER_SYNC);
    eval 'sub SEQUENCER_INFO () { &_IOWR(ord(\'Q\'), 2, \'struct synth_info\');}' unless defined(&SEQUENCER_INFO);
    eval 'sub SEQUENCER_CTRLRATE () { &_IOWR(ord(\'Q\'), 3, \'int\');}' unless defined(&SEQUENCER_CTRLRATE);
    eval 'sub SEQUENCER_GETOUTCOUNT () { &_IOR (ord(\'Q\'), 4, \'int\');}' unless defined(&SEQUENCER_GETOUTCOUNT);
    eval 'sub SEQUENCER_GETINCOUNT () { &_IOR (ord(\'Q\'), 5, \'int\');}' unless defined(&SEQUENCER_GETINCOUNT);
    eval 'sub SEQUENCER_RESETSAMPLES () { &_IOW (ord(\'Q\'), 9, \'int\');}' unless defined(&SEQUENCER_RESETSAMPLES);
    eval 'sub SEQUENCER_NRSYNTHS () { &_IOR (ord(\'Q\'),10, \'int\');}' unless defined(&SEQUENCER_NRSYNTHS);
    eval 'sub SEQUENCER_NRMIDIS () { &_IOR (ord(\'Q\'),11, \'int\');}' unless defined(&SEQUENCER_NRMIDIS);
    eval 'sub SEQUENCER_THRESHOLD () { &_IOW (ord(\'Q\'),13, \'int\');}' unless defined(&SEQUENCER_THRESHOLD);
    eval 'sub SEQUENCER_MEMAVL () { &_IOWR(ord(\'Q\'),14, \'int\');}' unless defined(&SEQUENCER_MEMAVL);
    eval 'sub SEQUENCER_PANIC () { &_IO (ord(\'Q\'),17);}' unless defined(&SEQUENCER_PANIC);
    eval 'sub SEQUENCER_OUTOFBAND () { &_IOW (ord(\'Q\'),18, \'struct seq_event_rec\');}' unless defined(&SEQUENCER_OUTOFBAND);
    eval 'sub SEQUENCER_GETTIME () { &_IOR (ord(\'Q\'),19, \'int\');}' unless defined(&SEQUENCER_GETTIME);
    if(0) {
    }
    eval 'sub CMDSIZE () {8;}' unless defined(&CMDSIZE);
    eval 'sub SYNTH_TYPE_FM () {0;}' unless defined(&SYNTH_TYPE_FM);
    eval 'sub SYNTH_TYPE_SAMPLE () {1;}' unless defined(&SYNTH_TYPE_SAMPLE);
    eval 'sub SYNTH_TYPE_MIDI () {2;}' unless defined(&SYNTH_TYPE_MIDI);
    eval 'sub SYNTH_SUB_FM_TYPE_ADLIB () {0x;}' unless defined(&SYNTH_SUB_FM_TYPE_ADLIB);
    eval 'sub SYNTH_SUB_FM_TYPE_OPL3 () {0x1;}' unless defined(&SYNTH_SUB_FM_TYPE_OPL3);
    eval 'sub SYNTH_SUB_MIDI_TYPE_MPU401 () {0x401;}' unless defined(&SYNTH_SUB_MIDI_TYPE_MPU401);
    eval 'sub SYNTH_SUB_SAMPLE_TYPE_BASIC () {0x10;}' unless defined(&SYNTH_SUB_SAMPLE_TYPE_BASIC);
    eval 'sub SYNTH_SUB_SAMPLE_TYPE_GUS () { &SAMPLE_TYPE_BASIC;}' unless defined(&SYNTH_SUB_SAMPLE_TYPE_GUS);
    eval 'sub SYNTH_CAP_OPL3 () {0x2;}' unless defined(&SYNTH_CAP_OPL3);
    eval 'sub SYNTH_CAP_INPUT () {0x4;}' unless defined(&SYNTH_CAP_INPUT);
    eval 'sub SEQUENCER_TMR_TIMEBASE () { &_IOWR(ord(\'T\'), 1, \'int\');}' unless defined(&SEQUENCER_TMR_TIMEBASE);
    eval 'sub SEQUENCER_TMR_START () { &_IO (ord(\'T\'), 2);}' unless defined(&SEQUENCER_TMR_START);
    eval 'sub SEQUENCER_TMR_STOP () { &_IO (ord(\'T\'), 3);}' unless defined(&SEQUENCER_TMR_STOP);
    eval 'sub SEQUENCER_TMR_CONTINUE () { &_IO (ord(\'T\'), 4);}' unless defined(&SEQUENCER_TMR_CONTINUE);
    eval 'sub SEQUENCER_TMR_TEMPO () { &_IOWR(ord(\'T\'), 5, \'int\');}' unless defined(&SEQUENCER_TMR_TEMPO);
    eval 'sub SEQUENCER_TMR_SOURCE () { &_IOWR(ord(\'T\'), 6, \'int\');}' unless defined(&SEQUENCER_TMR_SOURCE);
    eval 'sub SEQUENCER_TMR_INTERNAL () {0x1;}' unless defined(&SEQUENCER_TMR_INTERNAL);
    if(0) {
	eval 'sub SEQUENCER_TMR_EXTERNAL () {0x2;}' unless defined(&SEQUENCER_TMR_EXTERNAL);
	eval 'sub SEQUENCER_TMR_MODE_MIDI () {0x10;}' unless defined(&SEQUENCER_TMR_MODE_MIDI);
	eval 'sub SEQUENCER_TMR_MODE_FSK () {0x20;}' unless defined(&SEQUENCER_TMR_MODE_FSK);
	eval 'sub SEQUENCER_TMR_MODE_CLS () {0x40;}' unless defined(&SEQUENCER_TMR_MODE_CLS);
	eval 'sub SEQUENCER_TMR_MODE_SMPTE () {0x80;}' unless defined(&SEQUENCER_TMR_MODE_SMPTE);
    }
    eval 'sub SEQUENCER_TMR_METRONOME () { &_IOW (ord(\'T\'), 7, \'int\');}' unless defined(&SEQUENCER_TMR_METRONOME);
    eval 'sub SEQUENCER_TMR_SELECT () { &_IOW (ord(\'T\'), 8, \'int\');}' unless defined(&SEQUENCER_TMR_SELECT);
    eval 'sub MIDI_CTRL_ALLOFF () {123;}' unless defined(&MIDI_CTRL_ALLOFF);
    eval 'sub MIDI_CTRL_RESET () {121;}' unless defined(&MIDI_CTRL_RESET);
    eval 'sub MIDI_BEND_NEUTRAL () {(1<<13);}' unless defined(&MIDI_BEND_NEUTRAL);
    eval 'sub MIDI_NOTEOFF () {0x80;}' unless defined(&MIDI_NOTEOFF);
    eval 'sub MIDI_NOTEON () {0x90;}' unless defined(&MIDI_NOTEON);
    eval 'sub MIDI_KEY_PRESSURE () {0xa0;}' unless defined(&MIDI_KEY_PRESSURE);
    eval 'sub MIDI_CTL_CHANGE () {0xb0;}' unless defined(&MIDI_CTL_CHANGE);
    eval 'sub MIDI_PGM_CHANGE () {0xc0;}' unless defined(&MIDI_PGM_CHANGE);
    eval 'sub MIDI_CHN_PRESSURE () {0xd0;}' unless defined(&MIDI_CHN_PRESSURE);
    eval 'sub MIDI_PITCH_BEND () {0xe0;}' unless defined(&MIDI_PITCH_BEND);
    eval 'sub MIDI_SYSTEM_PREFIX () {0xf0;}' unless defined(&MIDI_SYSTEM_PREFIX);
    eval 'sub MIDI_IS_STATUS {
        my($d) = @_;
	    eval q((($d) >= 0x80));
    }' unless defined(&MIDI_IS_STATUS);
    eval 'sub MIDI_IS_COMMON {
        my($d) = @_;
	    eval q((($d) >= 0xf0));
    }' unless defined(&MIDI_IS_COMMON);
    eval 'sub MIDI_SYSEX_START () {0xf0;}' unless defined(&MIDI_SYSEX_START);
    eval 'sub MIDI_SYSEX_END () {0xf7;}' unless defined(&MIDI_SYSEX_END);
    eval 'sub MIDI_GET_STATUS {
        my($d) = @_;
	    eval q((($d) & 0xf0));
    }' unless defined(&MIDI_GET_STATUS);
    eval 'sub MIDI_GET_CHAN {
        my($d) = @_;
	    eval q((($d) & 0xf));
    }' unless defined(&MIDI_GET_CHAN);
    eval 'sub MIDI_HALF_VEL () {64;}' unless defined(&MIDI_HALF_VEL);
    eval 'sub SEQ_LOCAL () {0x80;}' unless defined(&SEQ_LOCAL);
    eval 'sub SEQ_TIMING () {0x81;}' unless defined(&SEQ_TIMING);
    eval 'sub SEQ_CHN_COMMON () {0x92;}' unless defined(&SEQ_CHN_COMMON);
    eval 'sub SEQ_CHN_VOICE () {0x93;}' unless defined(&SEQ_CHN_VOICE);
    eval 'sub SEQ_SYSEX () {0x94;}' unless defined(&SEQ_SYSEX);
    eval 'sub SEQ_FULLSIZE () {0xfd;}' unless defined(&SEQ_FULLSIZE);
    eval 'sub SEQ_MK_CHN_VOICE {
        my($e, $unit, $cmd, $chan, $key, $vel) = @_;
	    eval q(( ($e)-> $arr[0] =  &SEQ_CHN_VOICE, ($e)-> $arr[1] = ($unit), ($e)-> $arr[2] = ($cmd), ($e)-> $arr[3] = ($chan), ($e)-> $arr[4] = ($key), ($e)-> $arr[5] = ($vel), ($e)-> $arr[6] = 0, ($e)-> $arr[7] = 0));
    }' unless defined(&SEQ_MK_CHN_VOICE);
    eval 'sub SEQ_MK_CHN_COMMON {
        my($e, $unit, $cmd, $chan, $p1, $p2, $w14) = @_;
	    eval q(( ($e)-> $arr[0] =  &SEQ_CHN_COMMON, ($e)-> $arr[1] = ($unit), ($e)-> $arr[2] = ($cmd), ($e)-> $arr[3] = ($chan), ($e)-> $arr[4] = ($p1), ($e)-> $arr[5] = ($p2), *($e)-> $arr[6] = ($w14)));
    }' unless defined(&SEQ_MK_CHN_COMMON);
    if((defined(&_QUAD_LOWWORD) ? &_QUAD_LOWWORD : undef) == 1) {
	eval 'sub SEQ_PATCHKEY {
	    my($id) = @_;
    	    eval q((0xfd00|$id));
	}' unless defined(&SEQ_PATCHKEY);
    } else {
	eval 'sub SEQ_PATCHKEY {
	    my($id) = @_;
    	    eval q((($id<<8)|0xfd));
	}' unless defined(&SEQ_PATCHKEY);
    }
    eval 'sub SEQ_SYSEX_PATCH () { &SEQ_PATCHKEY(0x5);}' unless defined(&SEQ_SYSEX_PATCH);
    eval 'sub SEQ_MAUI_PATCH () { &SEQ_PATCHKEY(0x6);}' unless defined(&SEQ_MAUI_PATCH);
    eval 'sub SEQ_SYSEX_HDRSIZE () {((0)-> &data);}' unless defined(&SEQ_SYSEX_HDRSIZE);
    eval 'sub SBI_FM_PATCH () { &SEQ_PATCHKEY(0x1);}' unless defined(&SBI_FM_PATCH);
    eval 'sub SBI_OPL3_PATCH () { &SEQ_PATCHKEY(0x3);}' unless defined(&SBI_OPL3_PATCH);
    eval 'sub TMR_RESET () {0;}' unless defined(&TMR_RESET);
    eval 'sub TMR_WAIT_REL () {1;}' unless defined(&TMR_WAIT_REL);
    eval 'sub TMR_WAIT_ABS () {2;}' unless defined(&TMR_WAIT_ABS);
    eval 'sub TMR_STOP () {3;}' unless defined(&TMR_STOP);
    eval 'sub TMR_START () {4;}' unless defined(&TMR_START);
    eval 'sub TMR_CONTINUE () {5;}' unless defined(&TMR_CONTINUE);
    eval 'sub TMR_TEMPO () {6;}' unless defined(&TMR_TEMPO);
    eval 'sub TMR_ECHO () {8;}' unless defined(&TMR_ECHO);
    eval 'sub TMR_CLOCK () {9;}' unless defined(&TMR_CLOCK);
    eval 'sub TMR_SPP () {10;}' unless defined(&TMR_SPP);
    eval 'sub TMR_TIMESIG () {11;}' unless defined(&TMR_TIMESIG);
    eval 'sub SEQOLD_CMDSIZE () {4;}' unless defined(&SEQOLD_CMDSIZE);
    eval 'sub SEQOLD_NOTEOFF () {0;}' unless defined(&SEQOLD_NOTEOFF);
    eval 'sub SEQOLD_NOTEON () {1;}' unless defined(&SEQOLD_NOTEON);
    eval 'sub SEQOLD_WAIT () { &TMR_WAIT_ABS;}' unless defined(&SEQOLD_WAIT);
    eval 'sub SEQOLD_PGMCHANGE () {3;}' unless defined(&SEQOLD_PGMCHANGE);
    eval 'sub SEQOLD_SYNCTIMER () { &TMR_START;}' unless defined(&SEQOLD_SYNCTIMER);
    eval 'sub SEQOLD_MIDIPUTC () {5;}' unless defined(&SEQOLD_MIDIPUTC);
    eval 'sub SEQOLD_ECHO () { &TMR_ECHO;}' unless defined(&SEQOLD_ECHO);
    eval 'sub SEQOLD_AFTERTOUCH () {9;}' unless defined(&SEQOLD_AFTERTOUCH);
    eval 'sub SEQOLD_CONTROLLER () {10;}' unless defined(&SEQOLD_CONTROLLER);
    eval 'sub SEQOLD_PRIVATE () {0xfe;}' unless defined(&SEQOLD_PRIVATE);
    eval 'sub SEQOLD_EXTENDED () {0xff;}' unless defined(&SEQOLD_EXTENDED);
}
1;
