require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&QLI_MAXFER)) {
    sub QLI_MAXFER () {	( &MAXPHYS);}
}
unless(defined(&QLI_SOFT_RESET_RETRIES)) {
    sub QLI_SOFT_RESET_RETRIES () {	(3);}
}
unless(defined(&QLI_MBOX_SIZE)) {
    sub QLI_MBOX_SIZE () {	8;}
}
unless(defined(&QLI_REG_CTRLSTAT_SCSI_INTR_ENABLE)) {
    sub QLI_REG_CTRLSTAT_SCSI_INTR_ENABLE () {	(0x1<<2);}
}
unless(defined(&QLI_REG_CTRLSTAT_SCSI_RESET_INTR)) {
    sub QLI_REG_CTRLSTAT_SCSI_RESET_INTR () {	(0x1<<3);}
}
unless(defined(&QLI_REG_CTRLSTAT_SCSI_COMPL_INTR)) {
    sub QLI_REG_CTRLSTAT_SCSI_COMPL_INTR () {	(0x1<<4);}
}
unless(defined(&QLI_REG_CTRLSTAT_SCSI_PROC_INTR)) {
    sub QLI_REG_CTRLSTAT_SCSI_PROC_INTR () {	(0x1<<5);}
}
unless(defined(&QLI_REG_CTRLSTAT_EP_INTR)) {
    sub QLI_REG_CTRLSTAT_EP_INTR () {	(0x1<<6);}
}
unless(defined(&QLI_REG_CTRLSTAT_BOOT_ENABLE)) {
    sub QLI_REG_CTRLSTAT_BOOT_ENABLE () {	(0x1<<7);}
}
unless(defined(&QLI_REG_CTRLSTAT_FUNC_MASK)) {
    sub QLI_REG_CTRLSTAT_FUNC_MASK () {	(0x700);}
}
unless(defined(&QLI_REG_CTRLSTAT_NET_INTR_ENABLE)) {
    sub QLI_REG_CTRLSTAT_NET_INTR_ENABLE () {	(0x1<<10);}
}
unless(defined(&QLI_REG_CTRLSTAT_NET_RESET_INTR)) {
    sub QLI_REG_CTRLSTAT_NET_RESET_INTR () {	(0x1<<11);}
}
unless(defined(&QLI_REG_CTRLSTAT_NET_COMPL_INTR)) {
    sub QLI_REG_CTRLSTAT_NET_COMPL_INTR () {	(0x1<<12);}
}
unless(defined(&QLI_REG_CTRLSTAT_FORCE_SOFT_RESET)) {
    sub QLI_REG_CTRLSTAT_FORCE_SOFT_RESET () {	(0x1<<13);}
}
unless(defined(&QLI_REG_CTRLSTAT_FATAL_ERROR)) {
    sub QLI_REG_CTRLSTAT_FATAL_ERROR () {	(0x1<<14);}
}
unless(defined(&QLI_REG_CTRLSTAT_SOFT_RESET)) {
    sub QLI_REG_CTRLSTAT_SOFT_RESET () {	(0x1<<15);}
}
unless(defined(&QLI_REG_CTRLSTAT_SCSI_INTR_ENABLE_4022)) {
    sub QLI_REG_CTRLSTAT_SCSI_INTR_ENABLE_4022 () {	(0x1<<2);}
}
unless(defined(&QLI_PORT_CTRL_INITIALIZED)) {
    sub QLI_PORT_CTRL_INITIALIZED () {	(0x1<<15);}
}
unless(defined(&QLI_PORT_CTRL)) {
    sub QLI_PORT_CTRL {
	my($s) = @_;
	eval q(( ($s->{sc_ql4010}) ?  ($s->{sc_reg}->{u2}->{i$sp4010}->{q10_port_ctrl}) :  ($s->{sc_reg}->{u2}->{i$sp4022}->{q22_pr}->{qpr_port_ctrl})));
    }
}
unless(defined(&QLI_PORT_STATUS_RESET_INTR)) {
    sub QLI_PORT_STATUS_RESET_INTR () {	(0x1<<3);}
}
unless(defined(&QLI_PORT_STATUS)) {
    sub QLI_PORT_STATUS {
	my($sc) = @_;
	eval q(( ($sc->{sc_ql4010}) ?  ($sc->{sc_reg}->{u2}->{isp4010}->{q10_port_status}) :  ($sc->{sc_reg}->{u2}->{isp4022}->{q22_pr}->{qpr_port_status})));
    }
}
unless(defined(&QLI_SET_MASK)) {
    sub QLI_SET_MASK {
	my($v) = @_;
	eval q((($v & 0xffff) | ($v << 16)));
    }
}
unless(defined(&QLI_CLR_MASK)) {
    sub QLI_CLR_MASK {
	my($v) = @_;
	eval q((0| ($v << 16)));
    }
}
unless(defined(&QLI_SEM_MAX_RETRIES)) {
    sub QLI_SEM_MAX_RETRIES () {	(3);}
}
unless(defined(&QLI_SEM_4010_SCSI)) {
    sub QLI_SEM_4010_SCSI () {	(0x2);}
}
unless(defined(&QLI_SEMAPHORE)) {
    sub QLI_SEMAPHORE {
	my($s) = @_;
	eval q(( ($s->{sc_ql4010}) ?  ($s->{sc_reg}->{u1}->{i$sp4010}->{q10_nvram}) :  ($s->{sc_reg}->{u1}->{i$sp4022}->{q22_sem})));
    }
}
unless(defined(&QLI_SEM_4010_NVRAM_SHIFT)) {
    sub QLI_SEM_4010_NVRAM_SHIFT () {	(12);}
}
unless(defined(&QLI_SEM_4022_NVRAM_SHIFT)) {
    sub QLI_SEM_4022_NVRAM_SHIFT () {	(10);}
}
unless(defined(&QLI_SEM_4010_NVRAM_MASK)) {
    sub QLI_SEM_4010_NVRAM_MASK () {	(0x30000000);}
}
unless(defined(&QLI_SEM_4022_NVRAM_MASK)) {
    sub QLI_SEM_4022_NVRAM_MASK () {	(0x1c000000);}
}
unless(defined(&QLI_SEM_NVRAM)) {
    sub QLI_SEM_NVRAM {
	my($s) = @_;
	eval q(( ($s->{sc_ql4010}) ?  &QLI_SEM_4010_NVRAM_SHIFT:  &QLI_SEM_4022_NVRAM_SHIFT));
    }
}
unless(defined(&QLI_SEM_NVRAM_MASK)) {
    sub QLI_SEM_NVRAM_MASK {
	my($s) = @_;
	eval q(( ($s->{sc_ql4010}) ?  &QLI_SEM_4010_NVRAM_MASK:  &QLI_SEM_4022_NVRAM_MASK));
    }
}
unless(defined(&QLI_SEM_4010_FLASH_SHIFT)) {
    sub QLI_SEM_4010_FLASH_SHIFT () {	(14);}
}
unless(defined(&QLI_SEM_4022_FLASH_SHIFT)) {
    sub QLI_SEM_4022_FLASH_SHIFT () {	(13);}
}
unless(defined(&QLI_SEM_4010_FLASH_MASK)) {
    sub QLI_SEM_4010_FLASH_MASK () {	(0xc0000000);}
}
unless(defined(&QLI_SEM_4022_FLASH_MASK)) {
    sub QLI_SEM_4022_FLASH_MASK () {	(0xe0000000);}
}
unless(defined(&QLI_SEM_FLASH)) {
    sub QLI_SEM_FLASH {
	my($s) = @_;
	eval q(( ($s->{sc_ql4010}) ?  &QLI_SEM_4010_FLASH_SHIFT:  &QLI_SEM_4022_FLASH_SHIFT));
    }
}
unless(defined(&QLI_SEM_FLASH_MASK)) {
    sub QLI_SEM_FLASH_MASK {
	my($s) = @_;
	eval q(( ($s->{sc_ql4010}) ?  &QLI_SEM_4010_FLASH_MASK:  &QLI_SEM_4022_FLASH_MASK));
    }
}
unless(defined(&QLI_SEM_4010_MEM_SHIFT)) {
    sub QLI_SEM_4010_MEM_SHIFT () {	(8);}
}
unless(defined(&QLI_SEM_4022_MEM_SHIFT)) {
    sub QLI_SEM_4022_MEM_SHIFT () {	(4);}
}
unless(defined(&QLI_SEM_4010_MEM_MASK)) {
    sub QLI_SEM_4010_MEM_MASK () {	(0x3000000);}
}
unless(defined(&QLI_SEM_4022_MEM_MASK)) {
    sub QLI_SEM_4022_MEM_MASK () {	(0x700000);}
}
unless(defined(&QLI_SEM_MEM)) {
    sub QLI_SEM_MEM {
	my($s) = @_;
	eval q(( ($s->{sc_ql4010}) ?  &QLI_SEM_4010_MEM_SHIFT:  &QLI_SEM_4022_MEM_SHIFT));
    }
}
unless(defined(&QLI_SEM_MEM_MASK)) {
    sub QLI_SEM_MEM_MASK {
	my($s) = @_;
	eval q(( ($s->{sc_ql4010}) ?  &QLI_SEM_4010_MEM_MASK:  &QLI_SEM_4022_MEM_MASK));
    }
}
unless(defined(&QLI_SEM_4010_PHY_SHIFT)) {
    sub QLI_SEM_4010_PHY_SHIFT () {	(10);}
}
unless(defined(&QLI_SEM_4022_PHY_SHIFT)) {
    sub QLI_SEM_4022_PHY_SHIFT () {	(7);}
}
unless(defined(&QLI_SEM_4010_PHY_MASK)) {
    sub QLI_SEM_4010_PHY_MASK () {	(0xc000000);}
}
unless(defined(&QLI_SEM_4022_PHY_MASK)) {
    sub QLI_SEM_4022_PHY_MASK () {	(0x3800000);}
}
unless(defined(&QLI_SEM_PHY)) {
    sub QLI_SEM_PHY {
	my($s) = @_;
	eval q(( ($s->{sc_ql4010}) ?  &QLI_SEM_4010_PHY_SHIFT:  &QLI_SEM_4022_PHY_SHIFT));
    }
}
unless(defined(&QLI_SEM_PHY_MASK)) {
    sub QLI_SEM_PHY_MASK {
	my($s) = @_;
	eval q(( ($s->{sc_ql4010}) ?  &QLI_SEM_4010_PHY_MASK:  &QLI_SEM_4022_PHY_MASK));
    }
}
unless(defined(&QLI_SEM_4010_GPIO_SHIFT)) {
    sub QLI_SEM_4010_GPIO_SHIFT () {	(6);}
}
unless(defined(&QLI_SEM_4022_GPIO_SHIFT)) {
    sub QLI_SEM_4022_GPIO_SHIFT () {	 &QLI_SEM_4022_PHY_SHIFT;}
}
unless(defined(&QLI_SEM_4010_GPIO_MASK)) {
    sub QLI_SEM_4010_GPIO_MASK () {	(0xc00000);}
}
unless(defined(&QLI_SEM_4022_GPIO_MASK)) {
    sub QLI_SEM_4022_GPIO_MASK () {	 &QLI_SEM_4022_PHY_MASK;}
}
unless(defined(&QLI_SEM_GPIO)) {
    sub QLI_SEM_GPIO {
	my($s) = @_;
	eval q(( ($s->{sc_ql4010}) ?  &QLI_SEM_4010_GPIO_SHIFT:  &QLI_SEM_4022_GPIO_SHIFT));
    }
}
unless(defined(&QLI_SEM_GPIO_MASK)) {
    sub QLI_SEM_GPIO_MASK {
	my($s) = @_;
	eval q(( ($s->{sc_ql4010}) ?  &QLI_SEM_4010_GPIO_MASK:  &QLI_SEM_4022_GPIO_MASK));
    }
}
unless(defined(&QLI_SEM_4010_DRIVER_SHIFT)) {
    sub QLI_SEM_4010_DRIVER_SHIFT () {	(4);}
}
unless(defined(&QLI_SEM_4022_DRIVER_SHIFT)) {
    sub QLI_SEM_4022_DRIVER_SHIFT () {	(1);}
}
unless(defined(&QLI_SEM_4010_DRIVER_MASK)) {
    sub QLI_SEM_4010_DRIVER_MASK () {	(0x300000);}
}
unless(defined(&QLI_SEM_4022_DRIVER_MASK)) {
    sub QLI_SEM_4022_DRIVER_MASK () {	(0xe0000);}
}
unless(defined(&QLI_SEM_DRIVER)) {
    sub QLI_SEM_DRIVER {
	my($s) = @_;
	eval q(( ($s->{sc_ql4010}) ?  &QLI_SEM_4010_DRIVER_SHIFT:  &QLI_SEM_4022_DRIVER_SHIFT));
    }
}
unless(defined(&QLI_SEM_DRIVER_MASK)) {
    sub QLI_SEM_DRIVER_MASK {
	my($s) = @_;
	eval q(( ($s->{sc_ql4010}) ?  &QLI_SEM_4010_DRIVER_MASK:  &QLI_SEM_4022_DRIVER_MASK));
    }
}
unless(defined(&QLI_MBOX_OPC_ABOUT_FIRMWARE)) {
    sub QLI_MBOX_OPC_ABOUT_FIRMWARE () {	(0x9);}
}
unless(defined(&QLI_MBOX_OPC_GET_FW_STATUS)) {
    sub QLI_MBOX_OPC_GET_FW_STATUS () {	(0x1f);}
}
unless(defined(&QLI_MBOX_OPC_GET_INITIAL_FW_CB)) {
    sub QLI_MBOX_OPC_GET_INITIAL_FW_CB () {	(0x61);}
}
unless(defined(&QLI_MBOX_OPC_GET_FW_STATE)) {
    sub QLI_MBOX_OPC_GET_FW_STATE () {	(0x69);}
}
unless(defined(&QLI_MBOX_STATE_READY)) {
    sub QLI_MBOX_STATE_READY () {	(0x<<0);}
}
unless(defined(&QLI_MBOX_STATE_CONFIG_WAIT)) {
    sub QLI_MBOX_STATE_CONFIG_WAIT () {	(0x1<<0);}
}
unless(defined(&QLI_MBOX_STATE_WAIT_AUTOCONNECT)) {
    sub QLI_MBOX_STATE_WAIT_AUTOCONNECT () {	(0x1<<1);}
}
unless(defined(&QLI_MBOX_STATE_ERROR)) {
    sub QLI_MBOX_STATE_ERROR () {	(0x1<<2);}
}
unless(defined(&QLI_MBOX_STATE_CONFIGURING_IP)) {
    sub QLI_MBOX_STATE_CONFIGURING_IP () {	(0x1<<3);}
}
unless(defined(&QLI_MBOX_STATE_WAIT_ACTIVATE_PRI_ACB)) {
    sub QLI_MBOX_STATE_WAIT_ACTIVATE_PRI_ACB () {	(0x1<<4);}
}
unless(defined(&QLI_MBOX_STATE_WAIT_ACTIVATE_SEC_ACB)) {
    sub QLI_MBOX_STATE_WAIT_ACTIVATE_SEC_ACB () {	(0x1<<5);}
}
unless(defined(&QLI_MBOX_ASTATE_COPPER_MEDIA)) {
    sub QLI_MBOX_ASTATE_COPPER_MEDIA () {	(0x<<0);}
}
unless(defined(&QLI_MBOX_ASTATE_OPTICAL_MEDIA)) {
    sub QLI_MBOX_ASTATE_OPTICAL_MEDIA () {	(0x1<<0);}
}
unless(defined(&QLI_MBOX_ASTATE_DHCPv4_ENABLED)) {
    sub QLI_MBOX_ASTATE_DHCPv4_ENABLED () {	(0x1<<1);}
}
unless(defined(&QLI_MBOX_ASTATE_DHCPv4_LEASE_ACQUIRED)) {
    sub QLI_MBOX_ASTATE_DHCPv4_LEASE_ACQUIRED () {	(0x1<<2);}
}
unless(defined(&QLI_MBOX_ASTATE_DHCPv4_LEASE_EXPIRED)) {
    sub QLI_MBOX_ASTATE_DHCPv4_LEASE_EXPIRED () {	(0x1<<3);}
}
unless(defined(&QLI_MBOX_ASTATE_LINK_UP)) {
    sub QLI_MBOX_ASTATE_LINK_UP () {	(0x1<<4);}
}
unless(defined(&QLI_MBOX_ASTATE_ISNSv4_SVC_ENABLED)) {
    sub QLI_MBOX_ASTATE_ISNSv4_SVC_ENABLED () {	(0x1<<5);}
}
unless(defined(&QLI_MBOX_ASTATE_LINK_SPEED_10MBPS)) {
    sub QLI_MBOX_ASTATE_LINK_SPEED_10MBPS () {	(0x1<<8);}
}
unless(defined(&QLI_MBOX_ASTATE_LINK_SPEED_100MBPS)) {
    sub QLI_MBOX_ASTATE_LINK_SPEED_100MBPS () {	(0x1<<9);}
}
unless(defined(&QLI_MBOX_ASTATE_LINK_SPEED_1000MBPS)) {
    sub QLI_MBOX_ASTATE_LINK_SPEED_1000MBPS () {	(0x1<<10);}
}
unless(defined(&QLI_MBOX_ASTATE_HALF_DUPLEX)) {
    sub QLI_MBOX_ASTATE_HALF_DUPLEX () {	(0x1<<12);}
}
unless(defined(&QLI_MBOX_ASTATE_FULL_DUPLEX)) {
    sub QLI_MBOX_ASTATE_FULL_DUPLEX () {	(0x1<<13);}
}
unless(defined(&QLI_MBOX_ASTATE_FLOW_CTRL_ENABLED)) {
    sub QLI_MBOX_ASTATE_FLOW_CTRL_ENABLED () {	(0x1<<14);}
}
unless(defined(&QLI_MBOX_ASTATE_AUTONEG_ENABLED)) {
    sub QLI_MBOX_ASTATE_AUTONEG_ENABLED () {	(0x1<<15);}
}
unless(defined(&QLI_MBOX_ASTATE_FW_CTRLS_PORT_LINK)) {
    sub QLI_MBOX_ASTATE_FW_CTRLS_PORT_LINK () {	(0x1<<16);}
}
unless(defined(&QLI_MBOX_ASTATE_PAUSE_TX_ENABLED)) {
    sub QLI_MBOX_ASTATE_PAUSE_TX_ENABLED () {	(0x1<<17);}
}
unless(defined(&QLI_MBOX_ASTATE_PAUSE_RX_ENABLED)) {
    sub QLI_MBOX_ASTATE_PAUSE_RX_ENABLED () {	(0x1<<18);}
}
unless(defined(&QLI_MBOX_ASTATE_IPV4_PRI_ENABLED)) {
    sub QLI_MBOX_ASTATE_IPV4_PRI_ENABLED () {	(0x1<<19);}
}
unless(defined(&QLI_MBOX_ASTATE_IPV4_SEC_ENABLED)) {
    sub QLI_MBOX_ASTATE_IPV4_SEC_ENABLED () {	(0x1<<20);}
}
unless(defined(&QLI_MBOX_ASTATE_IPV6_PRI_ENABLED)) {
    sub QLI_MBOX_ASTATE_IPV6_PRI_ENABLED () {	(0x1<<21);}
}
unless(defined(&QLI_MBOX_ASTATE_IPV6_SEC_ENABLED)) {
    sub QLI_MBOX_ASTATE_IPV6_SEC_ENABLED () {	(0x1<<22);}
}
unless(defined(&QLI_MBOX_ASTATE_DHCPV6_ENABLED)) {
    sub QLI_MBOX_ASTATE_DHCPV6_ENABLED () {	(0x1<<23);}
}
unless(defined(&QLI_MBOX_ASTATE_IPV6_AUTOCONFIG_ENABLED)) {
    sub QLI_MBOX_ASTATE_IPV6_AUTOCONFIG_ENABLED () {	(0x1<<24);}
}
unless(defined(&QLI_MBOX_ASTATE_IPV6_ADDR0_STATE)) {
    sub QLI_MBOX_ASTATE_IPV6_ADDR0_STATE () {	(0x1<<25);}
}
unless(defined(&QLI_MBOX_ASTATE_IPV6_ADDR0_EXPIRED)) {
    sub QLI_MBOX_ASTATE_IPV6_ADDR0_EXPIRED () {	(0x1<<26);}
}
unless(defined(&QLI_MBOX_ASTATE_IPV6_ADDR1_STATE)) {
    sub QLI_MBOX_ASTATE_IPV6_ADDR1_STATE () {	(0x1<<27);}
}
unless(defined(&QLI_MBOX_ASTATE_IPV6_ADDR1_EXPIRED)) {
    sub QLI_MBOX_ASTATE_IPV6_ADDR1_EXPIRED () {	(0x1<<28);}
}
unless(defined(&QLI_MBOX_OPC_NOOP)) {
    sub QLI_MBOX_OPC_NOOP () {	(0xff);}
}
unless(defined(&QLI_MBOX_TYPE_SHIFT)) {
    sub QLI_MBOX_TYPE_SHIFT () {	(12);}
}
unless(defined(&QLI_MBOX_COMPLETION_STATUS)) {
    sub QLI_MBOX_COMPLETION_STATUS () {	(4);}
}
unless(defined(&QLI_MBOX_STATUS_BUSY)) {
    sub QLI_MBOX_STATUS_BUSY () {	(0x7);}
}
unless(defined(&QLI_MBOX_STATUS_INTERMEDIATE_COMPLETION)) {
    sub QLI_MBOX_STATUS_INTERMEDIATE_COMPLETION () {	(0x1000);}
}
unless(defined(&QLI_MBOX_STATUS_COMMAND_COMPLETE)) {
    sub QLI_MBOX_STATUS_COMMAND_COMPLETE () {	(0x4000);}
}
unless(defined(&QLI_MBOX_STATUS_INVALID_COMMAND)) {
    sub QLI_MBOX_STATUS_INVALID_COMMAND () {	(0x4001);}
}
unless(defined(&QLI_MBOX_STATUS_HOST_INTERFACE_ERROR)) {
    sub QLI_MBOX_STATUS_HOST_INTERFACE_ERROR () {	(0x4002);}
}
unless(defined(&QLI_MBOX_STATUS_TEST_FAILED)) {
    sub QLI_MBOX_STATUS_TEST_FAILED () {	(0x4003);}
}
unless(defined(&QLI_MBOX_STATUS_COMMAND_ERROR)) {
    sub QLI_MBOX_STATUS_COMMAND_ERROR () {	(0x4005);}
}
unless(defined(&QLI_MBOX_STATUS_COMMAND_PARAMETER_ERROR)) {
    sub QLI_MBOX_STATUS_COMMAND_PARAMETER_ERROR () {	(0x4006);}
}
unless(defined(&QLI_MBOX_STATUS_TARGET_MODE_INIT_FAIL)) {
    sub QLI_MBOX_STATUS_TARGET_MODE_INIT_FAIL () {	(0x4007);}
}
unless(defined(&QLI_MBOX_STATUS_INITIATOR_MODE_INIT_FAIL)) {
    sub QLI_MBOX_STATUS_INITIATOR_MODE_INIT_FAIL () {	(0x4008);}
}
unless(defined(&QLI_MBOX_ASYNC_EVENT_STATUS)) {
    sub QLI_MBOX_ASYNC_EVENT_STATUS () {	(8);}
}
unless(defined(&QLI_MBOX_AES_SYSTEM_ERROR)) {
    sub QLI_MBOX_AES_SYSTEM_ERROR () {	(0x8002);}
}
unless(defined(&QLI_MBOX_AES_REQUEST_TRANSFER_ERROR)) {
    sub QLI_MBOX_AES_REQUEST_TRANSFER_ERROR () {	(0x8003);}
}
unless(defined(&QLI_MBOX_AES_RESPONSE_TRANSFER_ERROR)) {
    sub QLI_MBOX_AES_RESPONSE_TRANSFER_ERROR () {	(0x8004);}
}
unless(defined(&QLI_MBOX_AES_PROTOCOL_STATISTIC_ALARM)) {
    sub QLI_MBOX_AES_PROTOCOL_STATISTIC_ALARM () {	(0x8005);}
}
unless(defined(&QLI_MBOX_AES_SCSI_COMMAND_PDU_REJECTED)) {
    sub QLI_MBOX_AES_SCSI_COMMAND_PDU_REJECTED () {	(0x8006);}
}
unless(defined(&QLI_MBOX_AES_LINK_UP)) {
    sub QLI_MBOX_AES_LINK_UP () {	(0x8010);}
}
unless(defined(&QLI_MBOX_AES_LINK_DOWN)) {
    sub QLI_MBOX_AES_LINK_DOWN () {	(0x8011);}
}
unless(defined(&QLI_MBOX_AES_DATABASE_CHANGED)) {
    sub QLI_MBOX_AES_DATABASE_CHANGED () {	(0x8014);}
}
unless(defined(&QLI_EXT_HW_CFG)) {
    sub QLI_EXT_HW_CFG {
	my($s) = @_;
	eval q(( ($s->{sc_ql4010}) ?  ($s->{sc_reg}->{u2}->{i$sp4010}->{q10_ext_hw_conf}) :  ($s->{sc_reg}->{u2}->{i$sp4022}->{q22_pr}->{qpr_ext_hw_conf})));
    }
}
unless(defined(&QLI_EXT_HW_CFG_DEFAULT_QL4010)) {
    sub QLI_EXT_HW_CFG_DEFAULT_QL4010 () {	(0x1912);}
}
unless(defined(&QLI_EXT_HW_CFG_DEFAULT_QL4022)) {
    sub QLI_EXT_HW_CFG_DEFAULT_QL4022 () {	(0x23);}
}
unless(defined(&QLI_EXT_HW_CFG_IGNORE_SHRINK_TCP_WINDOW)) {
    sub QLI_EXT_HW_CFG_IGNORE_SHRINK_TCP_WINDOW () {	(0x1<<0);}
}
unless(defined(&QLI_EXT_HW_CFG_SDRAM_PROTECTION_NONE)) {
    sub QLI_EXT_HW_CFG_SDRAM_PROTECTION_NONE () {	(0x);}
}
unless(defined(&QLI_EXT_HW_CFG_SDRAM_PROTECTION_BYTE)) {
    sub QLI_EXT_HW_CFG_SDRAM_PROTECTION_BYTE () {	(0x2);}
}
unless(defined(&QLI_EXT_HW_CFG_SDRAM_PROTECTION_ECC)) {
    sub QLI_EXT_HW_CFG_SDRAM_PROTECTION_ECC () {	(0x4);}
}
unless(defined(&QLI_EXT_HW_CFG_SDRAM_PROTECTION_ECC2)) {
    sub QLI_EXT_HW_CFG_SDRAM_PROTECTION_ECC2 () {	(0x6);}
}
unless(defined(&QLI_EXT_HW_CFG_BANKS)) {
    sub QLI_EXT_HW_CFG_BANKS () {	(0x1<<3);}
}
unless(defined(&QLI_EXT_HW_CFG_CHIP_WIDTH)) {
    sub QLI_EXT_HW_CFG_CHIP_WIDTH () {	(0x1<<4);}
}
unless(defined(&QLI_EXT_HW_CFG_CHIP_SIZE_64M)) {
    sub QLI_EXT_HW_CFG_CHIP_SIZE_64M () {	(0x);}
}
unless(defined(&QLI_EXT_HW_CFG_CHIP_SIZE_256M)) {
    sub QLI_EXT_HW_CFG_CHIP_SIZE_256M () {	(0x20);}
}
unless(defined(&QLI_EXT_HW_CFG_CHIP_SIZE_512M)) {
    sub QLI_EXT_HW_CFG_CHIP_SIZE_512M () {	(0x40);}
}
unless(defined(&QLI_EXT_HW_CFG_CHIP_SIZE_1G)) {
    sub QLI_EXT_HW_CFG_CHIP_SIZE_1G () {	(0x60);}
}
unless(defined(&QLI_EXT_HW_CFG_PARITY_DISABLE)) {
    sub QLI_EXT_HW_CFG_PARITY_DISABLE () {	(0x1<<7);}
}
unless(defined(&QLI_EXT_HW_CFG_EXTERNAL_MEM_TYPE)) {
    sub QLI_EXT_HW_CFG_EXTERNAL_MEM_TYPE () {	(0x1<<8);}
}
unless(defined(&QLI_EXT_HW_CFG_FLASH_BIOS_WRT_ENABLE)) {
    sub QLI_EXT_HW_CFG_FLASH_BIOS_WRT_ENABLE () {	(0x1<<9);}
}
unless(defined(&QLI_EXT_HW_CFG_FLASH_UPPER_BANK_SELECT)) {
    sub QLI_EXT_HW_CFG_FLASH_UPPER_BANK_SELECT () {	(0x1<<10);}
}
unless(defined(&QLI_EXT_HW_CFG_WRITE_BURST_9MA)) {
    sub QLI_EXT_HW_CFG_WRITE_BURST_9MA () {	(0x);}
}
unless(defined(&QLI_EXT_HW_CFG_WRITE_BURST_15MA)) {
    sub QLI_EXT_HW_CFG_WRITE_BURST_15MA () {	(0x800);}
}
unless(defined(&QLI_EXT_HW_CFG_WRITE_BURST_18MA)) {
    sub QLI_EXT_HW_CFG_WRITE_BURST_18MA () {	(0x1000);}
}
unless(defined(&QLI_EXT_HW_CFG_WRITE_BURST_24MA)) {
    sub QLI_EXT_HW_CFG_WRITE_BURST_24MA () {	(0x1800);}
}
unless(defined(&QLI_EXT_HW_CFG_DDR_DRIVE_STRENGTH_9MA)) {
    sub QLI_EXT_HW_CFG_DDR_DRIVE_STRENGTH_9MA () {	(0x);}
}
unless(defined(&QLI_EXT_HW_CFG_DDR_DRIVE_STRENGTH_15MA)) {
    sub QLI_EXT_HW_CFG_DDR_DRIVE_STRENGTH_15MA () {	(0x2000);}
}
unless(defined(&QLI_EXT_HW_CFG_DDR_DRIVE_STRENGTH_18MA)) {
    sub QLI_EXT_HW_CFG_DDR_DRIVE_STRENGTH_18MA () {	(0x4000);}
}
unless(defined(&QLI_EXT_HW_CFG_DDR_DRIVE_STRENGTH_24MA)) {
    sub QLI_EXT_HW_CFG_DDR_DRIVE_STRENGTH_24MA () {	(0x6000);}
}
unless(defined(&QLI_NVRAM_MASK)) {
    sub QLI_NVRAM_MASK () {	(0xf<<16);}
}
unless(defined(&QLI_NVRAM)) {
    sub QLI_NVRAM {
	my($s) = @_;
	eval q(( ($s->{sc_ql4010}) ?  ($s->{sc_reg}->{u1}->{i$sp4010}->{q10_nvram}) :  ($s->{sc_reg}->{u1}->{i$sp4022}->{q22_nvram})));
    }
}
unless(defined(&QLI_NVRAM_CLOCK)) {
    sub QLI_NVRAM_CLOCK () {	(0x1<<0);}
}
unless(defined(&QLI_NVRAM_SELECT)) {
    sub QLI_NVRAM_SELECT () {	(0x1<<1);}
}
unless(defined(&QLI_NVRAM_DATA_OUT)) {
    sub QLI_NVRAM_DATA_OUT () {	(0x1<<2);}
}
unless(defined(&QLI_NVRAM_DATA_IN)) {
    sub QLI_NVRAM_DATA_IN () {	(0x1<<3);}
}
unless(defined(&QLI_NVRAM_SIZE_4010)) {
    sub QLI_NVRAM_SIZE_4010 () {	(0x100);}
}
unless(defined(&QLI_NVRAM_SIZE_4022)) {
    sub QLI_NVRAM_SIZE_4022 () {	(0x400);}
}
unless(defined(&QLI_NVRAM_SIZE)) {
    sub QLI_NVRAM_SIZE {
	my($s) = @_;
	eval q(( ($s->{sc_ql4010}) ?  &QLI_NVRAM_SIZE_4010 :  &QLI_NVRAM_SIZE_4022));
    }
}
unless(defined(&QLI_NVRAM_NUM_CMD_BITS)) {
    sub QLI_NVRAM_NUM_CMD_BITS () {	(0x2);}
}
unless(defined(&QLI_NVRAM_CMD_READ)) {
    sub QLI_NVRAM_CMD_READ () {	(0x2);}
}
unless(defined(&QLI_NVRAM_NUM_ADDR_BITS_4010)) {
    sub QLI_NVRAM_NUM_ADDR_BITS_4010 () {	(0x8);}
}
unless(defined(&QLI_NVRAM_NUM_ADDR_BITS_4022)) {
    sub QLI_NVRAM_NUM_ADDR_BITS_4022 () {	(0xa);}
}
unless(defined(&QLI_NVRAM_NUM_ADDR_BITS)) {
    sub QLI_NVRAM_NUM_ADDR_BITS {
	my($s) = @_;
	eval q(( ($s->{sc_ql4010}) ?  &QLI_NVRAM_NUM_ADDR_BITS_4010 :  &QLI_NVRAM_NUM_ADDR_BITS_4022));
    }
}
unless(defined(&QLI_NVRAM_NUM_DATA_BITS)) {
    sub QLI_NVRAM_NUM_DATA_BITS () {	(0x10);}
}
unless(defined(&QLI_NVRAM_EXT_HW_CFG_4010)) {
    sub QLI_NVRAM_EXT_HW_CFG_4010 () {	(0xc);}
}
unless(defined(&QLI_NVRAM_EXT_HW_CFG_4022)) {
    sub QLI_NVRAM_EXT_HW_CFG_4022 () {	(0x14);}
}
unless(defined(&QLI_NVRAM_EXT_HW_CFG)) {
    sub QLI_NVRAM_EXT_HW_CFG {
	my($s) = @_;
	eval q(( ($s->{sc_ql4010}) ?  &QLI_NVRAM_EXT_HW_CFG_4010 :  &QLI_NVRAM_EXT_HW_CFG_4022));
    }
}
unless(defined(&QLI_FW_CTRL_BLK_SIZE)) {
    sub QLI_FW_CTRL_BLK_SIZE () {	(0x400);}
}
unless(defined(&QLI_QCB_VER_NO_ADDTIIONAL_INFO)) {
    sub QLI_QCB_VER_NO_ADDTIIONAL_INFO () {	(0x);}
}
unless(defined(&QLI_QCB_VER_MIN)) {
    sub QLI_QCB_VER_MIN () {	(0x1);}
}
unless(defined(&QLI_QCB_VER_MAX)) {
    sub QLI_QCB_VER_MAX () {	(0x2);}
}
unless(defined(&QLI_QCB_CTRL_NEW_CONN_DISABLE)) {
    sub QLI_QCB_CTRL_NEW_CONN_DISABLE () {	(0x2);}
}
unless(defined(&QLI_QCB_CTRL_SECONDARY_ACB)) {
    sub QLI_QCB_CTRL_SECONDARY_ACB () {	(0x1);}
}
unless(defined(&QLI_QCB_FWOPT_HEARTBEAT_ENABLE)) {
    sub QLI_QCB_FWOPT_HEARTBEAT_ENABLE () {	(0x1000);}
}
unless(defined(&QLI_QCB_FWOPT_MARKER_DISABLE)) {
    sub QLI_QCB_FWOPT_MARKER_DISABLE () {	(0x400);}
}
unless(defined(&QLI_QCB_FWOPT_PROT_STAT_ALARM_DISABLE)) {
    sub QLI_QCB_FWOPT_PROT_STAT_ALARM_DISABLE () {	(0x200);}
}
unless(defined(&QLI_QCB_FWOPT_TARGET_ACCEPT_AEN_ENABLE)) {
    sub QLI_QCB_FWOPT_TARGET_ACCEPT_AEN_ENABLE () {	(0x100);}
}
unless(defined(&QLI_QCB_FWOPT_ACCESS_CTRL_ENABLE)) {
    sub QLI_QCB_FWOPT_ACCESS_CTRL_ENABLE () {	(0x80);}
}
unless(defined(&QLI_QCB_FWOPT_SESSION_MODE)) {
    sub QLI_QCB_FWOPT_SESSION_MODE () {	(0x40);}
}
unless(defined(&QLI_QCB_FWOPT_INITIATOR_MODE)) {
    sub QLI_QCB_FWOPT_INITIATOR_MODE () {	(0x20);}
}
unless(defined(&QLI_QCB_FWOPT_TARGET_MODE)) {
    sub QLI_QCB_FWOPT_TARGET_MODE () {	(0x10);}
}
unless(defined(&QLI_QCB_FWOPT_FAST_POSTING)) {
    sub QLI_QCB_FWOPT_FAST_POSTING () {	(0x8);}
}
unless(defined(&QLI_QCB_FWOPT_AUTO_TARGET_INFO_DISABLE)) {
    sub QLI_QCB_FWOPT_AUTO_TARGET_INFO_DISABLE () {	(0x4);}
}
unless(defined(&QLI_QCB_FWOPT_SENSE_BUFFER_DATA_ENABLE)) {
    sub QLI_QCB_FWOPT_SENSE_BUFFER_DATA_ENABLE () {	(0x2);}
}
unless(defined(&QLI_QCB_ADDFWOPT_AUTOCONNECT_DISABLE)) {
    sub QLI_QCB_ADDFWOPT_AUTOCONNECT_DISABLE () {	(0x2);}
}
unless(defined(&QLI_QCB_ADDFWOPT_SUSPEND_ON_FW_ERROR)) {
    sub QLI_QCB_ADDFWOPT_SUSPEND_ON_FW_ERROR () {	(0x1);}
}
unless(defined(&QLI_QCB_ISCSIOPTS_RECV_MARKER_ENABLE)) {
    sub QLI_QCB_ISCSIOPTS_RECV_MARKER_ENABLE () {	(0x8000);}
}
unless(defined(&QLI_QCB_ISCSIOPTS_SEND_MARKER_ENABLE)) {
    sub QLI_QCB_ISCSIOPTS_SEND_MARKER_ENABLE () {	(0x4000);}
}
unless(defined(&QLI_QCB_ISCSIOPTS_HDR_DIGEST_ENABLE)) {
    sub QLI_QCB_ISCSIOPTS_HDR_DIGEST_ENABLE () {	(0x2000);}
}
unless(defined(&QLI_QCB_ISCSIOPTS_DATA_DIGEST_ENABLE)) {
    sub QLI_QCB_ISCSIOPTS_DATA_DIGEST_ENABLE () {	(0x1000);}
}
unless(defined(&QLI_QCB_ISCSIOPTS_IMMEDIATE_DATA_ENABLE)) {
    sub QLI_QCB_ISCSIOPTS_IMMEDIATE_DATA_ENABLE () {	(0x800);}
}
unless(defined(&QLI_QCB_ISCSIOPTS_INITIAL_R2T_ENABLE)) {
    sub QLI_QCB_ISCSIOPTS_INITIAL_R2T_ENABLE () {	(0x400);}
}
unless(defined(&QLI_QCB_ISCSIOPTS_DATA_SEQ_IN_ORDER)) {
    sub QLI_QCB_ISCSIOPTS_DATA_SEQ_IN_ORDER () {	(0x200);}
}
unless(defined(&QLI_QCB_ISCSIOPTS_DATA_PDU_IN_ORDER)) {
    sub QLI_QCB_ISCSIOPTS_DATA_PDU_IN_ORDER () {	(0x100);}
}
unless(defined(&QLI_QCB_ISCSIOPTS_CHAP_AUTH_ENABLE)) {
    sub QLI_QCB_ISCSIOPTS_CHAP_AUTH_ENABLE () {	(0x80);}
}
unless(defined(&QLI_QCB_ISCSIOPTS_SNACK_REQ_ENABLE)) {
    sub QLI_QCB_ISCSIOPTS_SNACK_REQ_ENABLE () {	(0x40);}
}
unless(defined(&QLI_QCB_ISCSIOPTS_DISCOVERY_LOGOUT_ENABLE)) {
    sub QLI_QCB_ISCSIOPTS_DISCOVERY_LOGOUT_ENABLE () {	(0x20);}
}
unless(defined(&QLI_QCB_ISCSIOPTS_BIDIR_CHAP_ENABLE)) {
    sub QLI_QCB_ISCSIOPTS_BIDIR_CHAP_ENABLE () {	(0x10);}
}
unless(defined(&QLI_QCB_TCPOPTS_ISNS_ENABLE)) {
    sub QLI_QCB_TCPOPTS_ISNS_ENABLE () {	(0x4000);}
}
unless(defined(&QLI_QCB_TCPOPTS_SLP_USE_DA_ENABLE)) {
    sub QLI_QCB_TCPOPTS_SLP_USE_DA_ENABLE () {	(0x2000);}
}
unless(defined(&QLI_QCB_TCPOPTS_AUTO_DISCOVERY_ENABLE)) {
    sub QLI_QCB_TCPOPTS_AUTO_DISCOVERY_ENABLE () {	(0x1000);}
}
unless(defined(&QLI_QCB_TCPOPTS_SLP_UA_ENABLE)) {
    sub QLI_QCB_TCPOPTS_SLP_UA_ENABLE () {	(0x800);}
}
unless(defined(&QLI_QCB_TCPOPTS_SLP_SA_ENABLE)) {
    sub QLI_QCB_TCPOPTS_SLP_SA_ENABLE () {	(0x400);}
}
unless(defined(&QLI_QCB_TCPOPTS_DHCP_ENABLE)) {
    sub QLI_QCB_TCPOPTS_DHCP_ENABLE () {	(0x200);}
}
unless(defined(&QLI_QCB_TCPOPTS_GET_DNS_VIA_DHCP_ENABLE)) {
    sub QLI_QCB_TCPOPTS_GET_DNS_VIA_DHCP_ENABLE () {	(0x100);}
}
unless(defined(&QLI_QCB_TCPOPTS_GET_SLP_VIA_DHCP_ENABLE)) {
    sub QLI_QCB_TCPOPTS_GET_SLP_VIA_DHCP_ENABLE () {	(0x80);}
}
unless(defined(&QLI_QCB_TCPOPTS_LEARN_ISNS_IPADDR_ENABLE)) {
    sub QLI_QCB_TCPOPTS_LEARN_ISNS_IPADDR_ENABLE () {	(0x40);}
}
unless(defined(&QLI_QCB_TCPOPTS_NAGLE_DISABLE)) {
    sub QLI_QCB_TCPOPTS_NAGLE_DISABLE () {	(0x20);}
}
unless(defined(&QLI_QCB_TCPOPTS_TIMER_SCALE_MASK)) {
    sub QLI_QCB_TCPOPTS_TIMER_SCALE_MASK () {	(0xe);}
}
unless(defined(&QLI_QCB_TCPOPTS_TIME_STAMP_ENABLE)) {
    sub QLI_QCB_TCPOPTS_TIME_STAMP_ENABLE () {	(0x1);}
}
unless(defined(&QLI_QCB_IPOPTS_IPV4_ENABLE)) {
    sub QLI_QCB_IPOPTS_IPV4_ENABLE () {	(0x8000);}
}
unless(defined(&QLI_QCB_IPOPTS_IPV4_TOS_ENABLE)) {
    sub QLI_QCB_IPOPTS_IPV4_TOS_ENABLE () {	(0x4000);}
}
unless(defined(&QLI_QCB_IPOPTS_VLAN_TAGGING_ENABLE)) {
    sub QLI_QCB_IPOPTS_VLAN_TAGGING_ENABLE () {	(0x2000);}
}
unless(defined(&QLI_QCB_IPOPTS_GRAT_ARP_ENABLE)) {
    sub QLI_QCB_IPOPTS_GRAT_ARP_ENABLE () {	(0x1000);}
}
unless(defined(&QLI_QCB_IPOPTS_DHCP_USE_ALT_CLIENT_ID)) {
    sub QLI_QCB_IPOPTS_DHCP_USE_ALT_CLIENT_ID () {	(0x800);}
}
unless(defined(&QLI_QCB_IPOPTS_DHCP_REQUIRE_VENDOR_ID)) {
    sub QLI_QCB_IPOPTS_DHCP_REQUIRE_VENDOR_ID () {	(0x400);}
}
unless(defined(&QLI_QCB_IPOPTS_DHCP_USE_VENDOR_ID)) {
    sub QLI_QCB_IPOPTS_DHCP_USE_VENDOR_ID () {	(0x200);}
}
unless(defined(&QLI_QCB_IPOPTS_LEARN_IQN)) {
    sub QLI_QCB_IPOPTS_LEARN_IQN () {	(0x100);}
}
unless(defined(&QLI_QCB_IPOPTS_FRAG_DISABLE)) {
    sub QLI_QCB_IPOPTS_FRAG_DISABLE () {	(0x10);}
}
unless(defined(&QLI_QCB_IPOPTS_INCOMMING_FORWARDING_ENABLE)) {
    sub QLI_QCB_IPOPTS_INCOMMING_FORWARDING_ENABLE () {	(0x8);}
}
unless(defined(&QLI_QCB_IPOPTS_ARP_REDIRECT_ENABLE)) {
    sub QLI_QCB_IPOPTS_ARP_REDIRECT_ENABLE () {	(0x4);}
}
unless(defined(&QLI_QCB_IPOPTS_PAUSE_FRAME_ENABLE)) {
    sub QLI_QCB_IPOPTS_PAUSE_FRAME_ENABLE () {	(0x2);}
}
unless(defined(&QLI_QCB_IPOPTS_IPADDR_VALID)) {
    sub QLI_QCB_IPOPTS_IPADDR_VALID () {	(0x1);}
}
unless(defined(&QLI_QCB_ACBVER_NOT_SUPPORTED)) {
    sub QLI_QCB_ACBVER_NOT_SUPPORTED () {	(0x);}
}
unless(defined(&QLI_QCB_ACBVER_SUPPORTED)) {
    sub QLI_QCB_ACBVER_SUPPORTED () {	(0x2);}
}
unless(defined(&QLI_QCB_COOKIE)) {
    sub QLI_QCB_COOKIE () {	(0x11bead5a);}
}
unless(defined(&QLI_QCB_IPV6OPTS_IPV6_ENABLE)) {
    sub QLI_QCB_IPV6OPTS_IPV6_ENABLE () {	(0x8000);}
}
unless(defined(&QLI_QCB_IPV6OPTS_VLAN_TAGGING_ENABLE)) {
    sub QLI_QCB_IPV6OPTS_VLAN_TAGGING_ENABLE () {	(0x2000);}
}
unless(defined(&QLI_QCB_IPV6OPTS_GRAT_NEIGHBOR_ENABLE)) {
    sub QLI_QCB_IPV6OPTS_GRAT_NEIGHBOR_ENABLE () {	(0x1000);}
}
unless(defined(&QLI_QCB_IPV6OPTS_INBOUND_FORW_ENABLE)) {
    sub QLI_QCB_IPV6OPTS_INBOUND_FORW_ENABLE () {	(0x8);}
}
unless(defined(&QLI_QCB_IPV6AOPTS_NEIGHB_DISC_ENABLE)) {
    sub QLI_QCB_IPV6AOPTS_NEIGHB_DISC_ENABLE () {	(0x2);}
}
unless(defined(&QLI_QCB_IPV6AOPTS_AUTOCFG_LINK_ENABLE)) {
    sub QLI_QCB_IPV6AOPTS_AUTOCFG_LINK_ENABLE () {	(0x1);}
}
unless(defined(&QLI_QCB_IPV6TCPOPTS_DELAYED_ACK_DISABLE)) {
    sub QLI_QCB_IPV6TCPOPTS_DELAYED_ACK_DISABLE () {	(0x8000);}
}
unless(defined(&QLI_QCB_IPV6TCPOPTS_ISNS_ENABLE)) {
    sub QLI_QCB_IPV6TCPOPTS_ISNS_ENABLE () {	(0x4000);}
}
unless(defined(&QLI_QCB_IPV6TCPOPTS_TCP_WINDOW_SCALE)) {
    sub QLI_QCB_IPV6TCPOPTS_TCP_WINDOW_SCALE () {	(0x400);}
}
unless(defined(&QLI_QCB_IPV6TCPOPTS_NAGLE_DISABLE)) {
    sub QLI_QCB_IPV6TCPOPTS_NAGLE_DISABLE () {	(0x20);}
}
unless(defined(&QLI_QCB_IPV6TCPOPTS_TCP_WIN_SCALE_DISA)) {
    sub QLI_QCB_IPV6TCPOPTS_TCP_WIN_SCALE_DISA () {	(0x10);}
}
unless(defined(&QLI_QCB_IPV6TCPOPTS_TIMER_SCALE_MASK)) {
    sub QLI_QCB_IPV6TCPOPTS_TIMER_SCALE_MASK () {	(0xe);}
}
unless(defined(&QLI_QCB_IPV6TCPOPTS_TIME_STAMP_ENABLE)) {
    sub QLI_QCB_IPV6TCPOPTS_TIME_STAMP_ENABLE () {	(0x1);}
}
unless(defined(&QLI_QCB_IPV6_LLAS_UNCONFIGURED)) {
    sub QLI_QCB_IPV6_LLAS_UNCONFIGURED () {	(0x);}
}
unless(defined(&QLI_QCB_IPV6_LLAS_INVALID)) {
    sub QLI_QCB_IPV6_LLAS_INVALID () {	(0x1);}
}
unless(defined(&QLI_QCB_IPV6_LLAS_ACQUIRING)) {
    sub QLI_QCB_IPV6_LLAS_ACQUIRING () {	(0x2);}
}
unless(defined(&QLI_QCB_IPV6_LLAS_TENTATIVE)) {
    sub QLI_QCB_IPV6_LLAS_TENTATIVE () {	(0x3);}
}
unless(defined(&QLI_QCB_IPV6_LLAS_DEPRECATED)) {
    sub QLI_QCB_IPV6_LLAS_DEPRECATED () {	(0x4);}
}
unless(defined(&QLI_QCB_IPV6_LLAS_PREFERRED)) {
    sub QLI_QCB_IPV6_LLAS_PREFERRED () {	(0x5);}
}
unless(defined(&QLI_QCB_IPV6_LLAS_DISABLING)) {
    sub QLI_QCB_IPV6_LLAS_DISABLING () {	(0x6);}
}
unless(defined(&QLI_REQUESTQ_DEPTH)) {
    sub QLI_REQUESTQ_DEPTH () {	(1024);}
}
unless(defined(&QLI_QUEUE_SIZE)) {
    sub QLI_QUEUE_SIZE () {	(64);}
}
unless(defined(&QLI_RESPONSEQ_DEPTH)) {
    sub QLI_RESPONSEQ_DEPTH () {	(64);}
}
1;
