require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&RT2560_TX_RING_COUNT)) {
    sub RT2560_TX_RING_COUNT () {	48;}
}
unless(defined(&RT2560_ATIM_RING_COUNT)) {
    sub RT2560_ATIM_RING_COUNT () {	4;}
}
unless(defined(&RT2560_PRIO_RING_COUNT)) {
    sub RT2560_PRIO_RING_COUNT () {	16;}
}
unless(defined(&RT2560_BEACON_RING_COUNT)) {
    sub RT2560_BEACON_RING_COUNT () {	1;}
}
unless(defined(&RT2560_RX_RING_COUNT)) {
    sub RT2560_RX_RING_COUNT () {	32;}
}
unless(defined(&RT2560_TX_DESC_SIZE)) {
    sub RT2560_TX_DESC_SIZE () {	($sizeof{'struct rt2560_tx_desc'});}
}
unless(defined(&RT2560_RX_DESC_SIZE)) {
    sub RT2560_RX_DESC_SIZE () {	($sizeof{'struct rt2560_rx_desc'});}
}
unless(defined(&RT2560_MAX_SCATTER)) {
    sub RT2560_MAX_SCATTER () {	1;}
}
unless(defined(&RT2560_CSR0)) {
    sub RT2560_CSR0 () {	0x;}
}
unless(defined(&RT2560_CSR1)) {
    sub RT2560_CSR1 () {	0x4;}
}
unless(defined(&RT2560_CSR3)) {
    sub RT2560_CSR3 () {	0xc;}
}
unless(defined(&RT2560_CSR4)) {
    sub RT2560_CSR4 () {	0x10;}
}
unless(defined(&RT2560_CSR5)) {
    sub RT2560_CSR5 () {	0x14;}
}
unless(defined(&RT2560_CSR6)) {
    sub RT2560_CSR6 () {	0x18;}
}
unless(defined(&RT2560_CSR7)) {
    sub RT2560_CSR7 () {	0x1c;}
}
unless(defined(&RT2560_CSR8)) {
    sub RT2560_CSR8 () {	0x20;}
}
unless(defined(&RT2560_CSR9)) {
    sub RT2560_CSR9 () {	0x24;}
}
unless(defined(&RT2560_SECCSR0)) {
    sub RT2560_SECCSR0 () {	0x28;}
}
unless(defined(&RT2560_CSR11)) {
    sub RT2560_CSR11 () {	0x2c;}
}
unless(defined(&RT2560_CSR12)) {
    sub RT2560_CSR12 () {	0x30;}
}
unless(defined(&RT2560_CSR13)) {
    sub RT2560_CSR13 () {	0x34;}
}
unless(defined(&RT2560_CSR14)) {
    sub RT2560_CSR14 () {	0x38;}
}
unless(defined(&RT2560_CSR15)) {
    sub RT2560_CSR15 () {	0x3c;}
}
unless(defined(&RT2560_CSR16)) {
    sub RT2560_CSR16 () {	0x40;}
}
unless(defined(&RT2560_CSR17)) {
    sub RT2560_CSR17 () {	0x44;}
}
unless(defined(&RT2560_CSR18)) {
    sub RT2560_CSR18 () {	0x48;}
}
unless(defined(&RT2560_CSR19)) {
    sub RT2560_CSR19 () {	0x4c;}
}
unless(defined(&RT2560_CSR20)) {
    sub RT2560_CSR20 () {	0x50;}
}
unless(defined(&RT2560_CSR21)) {
    sub RT2560_CSR21 () {	0x54;}
}
unless(defined(&RT2560_CSR22)) {
    sub RT2560_CSR22 () {	0x58;}
}
unless(defined(&RT2560_TXCSR0)) {
    sub RT2560_TXCSR0 () {	0x60;}
}
unless(defined(&RT2560_TXCSR1)) {
    sub RT2560_TXCSR1 () {	0x64;}
}
unless(defined(&RT2560_TXCSR2)) {
    sub RT2560_TXCSR2 () {	0x68;}
}
unless(defined(&RT2560_TXCSR3)) {
    sub RT2560_TXCSR3 () {	0x6c;}
}
unless(defined(&RT2560_TXCSR4)) {
    sub RT2560_TXCSR4 () {	0x70;}
}
unless(defined(&RT2560_TXCSR5)) {
    sub RT2560_TXCSR5 () {	0x74;}
}
unless(defined(&RT2560_TXCSR6)) {
    sub RT2560_TXCSR6 () {	0x78;}
}
unless(defined(&RT2560_TXCSR7)) {
    sub RT2560_TXCSR7 () {	0x7c;}
}
unless(defined(&RT2560_RXCSR0)) {
    sub RT2560_RXCSR0 () {	0x80;}
}
unless(defined(&RT2560_RXCSR1)) {
    sub RT2560_RXCSR1 () {	0x84;}
}
unless(defined(&RT2560_RXCSR2)) {
    sub RT2560_RXCSR2 () {	0x88;}
}
unless(defined(&RT2560_PCICSR)) {
    sub RT2560_PCICSR () {	0x8c;}
}
unless(defined(&RT2560_RXCSR3)) {
    sub RT2560_RXCSR3 () {	0x90;}
}
unless(defined(&RT2560_TXCSR9)) {
    sub RT2560_TXCSR9 () {	0x94;}
}
unless(defined(&RT2560_ARSP_PLCP_0)) {
    sub RT2560_ARSP_PLCP_0 () {	0x98;}
}
unless(defined(&RT2560_ARSP_PLCP_1)) {
    sub RT2560_ARSP_PLCP_1 () {	0x9c;}
}
unless(defined(&RT2560_CNT0)) {
    sub RT2560_CNT0 () {	0xa0;}
}
unless(defined(&RT2560_CNT1)) {
    sub RT2560_CNT1 () {	0xac;}
}
unless(defined(&RT2560_CNT2)) {
    sub RT2560_CNT2 () {	0xb0;}
}
unless(defined(&RT2560_CNT3)) {
    sub RT2560_CNT3 () {	0xb8;}
}
unless(defined(&RT2560_CNT4)) {
    sub RT2560_CNT4 () {	0xbc;}
}
unless(defined(&RT2560_CNT5)) {
    sub RT2560_CNT5 () {	0xc0;}
}
unless(defined(&RT2560_PWRCSR0)) {
    sub RT2560_PWRCSR0 () {	0xc4;}
}
unless(defined(&RT2560_PSCSR0)) {
    sub RT2560_PSCSR0 () {	0xc8;}
}
unless(defined(&RT2560_PSCSR1)) {
    sub RT2560_PSCSR1 () {	0xcc;}
}
unless(defined(&RT2560_PSCSR2)) {
    sub RT2560_PSCSR2 () {	0xd0;}
}
unless(defined(&RT2560_PSCSR3)) {
    sub RT2560_PSCSR3 () {	0xd4;}
}
unless(defined(&RT2560_PWRCSR1)) {
    sub RT2560_PWRCSR1 () {	0xd8;}
}
unless(defined(&RT2560_TIMECSR)) {
    sub RT2560_TIMECSR () {	0xdc;}
}
unless(defined(&RT2560_MACCSR0)) {
    sub RT2560_MACCSR0 () {	0xe0;}
}
unless(defined(&RT2560_MACCSR1)) {
    sub RT2560_MACCSR1 () {	0xe4;}
}
unless(defined(&RT2560_RALINKCSR)) {
    sub RT2560_RALINKCSR () {	0xe8;}
}
unless(defined(&RT2560_BCNCSR)) {
    sub RT2560_BCNCSR () {	0xec;}
}
unless(defined(&RT2560_BBPCSR)) {
    sub RT2560_BBPCSR () {	0xf0;}
}
unless(defined(&RT2560_RFCSR)) {
    sub RT2560_RFCSR () {	0xf4;}
}
unless(defined(&RT2560_LEDCSR)) {
    sub RT2560_LEDCSR () {	0xf8;}
}
unless(defined(&RT2560_SECCSR3)) {
    sub RT2560_SECCSR3 () {	0xfc;}
}
unless(defined(&RT2560_DMACSR0)) {
    sub RT2560_DMACSR0 () {	0x100;}
}
unless(defined(&RT2560_DMACSR1)) {
    sub RT2560_DMACSR1 () {	0x104;}
}
unless(defined(&RT2560_DMACSR2)) {
    sub RT2560_DMACSR2 () {	0x104;}
}
unless(defined(&RT2560_DMACSR3)) {
    sub RT2560_DMACSR3 () {	0x104;}
}
unless(defined(&RT2560_TXACKCSR0)) {
    sub RT2560_TXACKCSR0 () {	0x110;}
}
unless(defined(&RT2560_GPIOCSR)) {
    sub RT2560_GPIOCSR () {	0x120;}
}
unless(defined(&RT2560_BBBPPCSR)) {
    sub RT2560_BBBPPCSR () {	0x124;}
}
unless(defined(&RT2560_FIFOCSR0)) {
    sub RT2560_FIFOCSR0 () {	0x128;}
}
unless(defined(&RT2560_FIFOCSR1)) {
    sub RT2560_FIFOCSR1 () {	0x12c;}
}
unless(defined(&RT2560_BCNOCSR)) {
    sub RT2560_BCNOCSR () {	0x130;}
}
unless(defined(&RT2560_RLPWCSR)) {
    sub RT2560_RLPWCSR () {	0x134;}
}
unless(defined(&RT2560_TESTCSR)) {
    sub RT2560_TESTCSR () {	0x138;}
}
unless(defined(&RT2560_PLCP1MCSR)) {
    sub RT2560_PLCP1MCSR () {	0x13c;}
}
unless(defined(&RT2560_PLCP2MCSR)) {
    sub RT2560_PLCP2MCSR () {	0x140;}
}
unless(defined(&RT2560_PLCP5p5MCSR)) {
    sub RT2560_PLCP5p5MCSR () {	0x144;}
}
unless(defined(&RT2560_PLCP11MCSR)) {
    sub RT2560_PLCP11MCSR () {	0x148;}
}
unless(defined(&RT2560_ACKPCTCSR)) {
    sub RT2560_ACKPCTCSR () {	0x14c;}
}
unless(defined(&RT2560_ARTCSR1)) {
    sub RT2560_ARTCSR1 () {	0x150;}
}
unless(defined(&RT2560_ARTCSR2)) {
    sub RT2560_ARTCSR2 () {	0x154;}
}
unless(defined(&RT2560_SECCSR1)) {
    sub RT2560_SECCSR1 () {	0x158;}
}
unless(defined(&RT2560_BBPCSR1)) {
    sub RT2560_BBPCSR1 () {	0x15c;}
}
unless(defined(&RT2560_DISABLE_RX)) {
    sub RT2560_DISABLE_RX () {	(1<< 0);}
}
unless(defined(&RT2560_DROP_CRC_ERROR)) {
    sub RT2560_DROP_CRC_ERROR () {	(1<< 1);}
}
unless(defined(&RT2560_DROP_PHY_ERROR)) {
    sub RT2560_DROP_PHY_ERROR () {	(1<< 2);}
}
unless(defined(&RT2560_DROP_CTL)) {
    sub RT2560_DROP_CTL () {	(1<< 3);}
}
unless(defined(&RT2560_DROP_NOT_TO_ME)) {
    sub RT2560_DROP_NOT_TO_ME () {	(1<< 4);}
}
unless(defined(&RT2560_DROP_TODS)) {
    sub RT2560_DROP_TODS () {	(1<< 5);}
}
unless(defined(&RT2560_DROP_VERSION_ERROR)) {
    sub RT2560_DROP_VERSION_ERROR () {	(1<< 6);}
}
unless(defined(&RT2560_RESET_ASIC)) {
    sub RT2560_RESET_ASIC () {	(1<< 0);}
}
unless(defined(&RT2560_RESET_BBP)) {
    sub RT2560_RESET_BBP () {	(1<< 1);}
}
unless(defined(&RT2560_HOST_READY)) {
    sub RT2560_HOST_READY () {	(1<< 2);}
}
unless(defined(&RT2560_ENABLE_TSF)) {
    sub RT2560_ENABLE_TSF () {	(1<< 0);}
}
unless(defined(&RT2560_ENABLE_TSF_SYNC)) {
    sub RT2560_ENABLE_TSF_SYNC {
	my($x) = @_;
	eval q(((($x) & 0x3) << 1));
    }
}
unless(defined(&RT2560_ENABLE_TBCN)) {
    sub RT2560_ENABLE_TBCN () {	(1<< 3);}
}
unless(defined(&RT2560_ENABLE_BEACON_GENERATOR)) {
    sub RT2560_ENABLE_BEACON_GENERATOR () {	(1<< 6);}
}
unless(defined(&RT2560_C)) {
    sub RT2560_C () {	(1<< 1);}
}
unless(defined(&RT2560_S)) {
    sub RT2560_S () {	(1<< 2);}
}
unless(defined(&RT2560_D)) {
    sub RT2560_D () {	(1<< 3);}
}
unless(defined(&RT2560_Q)) {
    sub RT2560_Q () {	(1<< 4);}
}
unless(defined(&RT2560_93C46)) {
    sub RT2560_93C46 () {	(1<< 5);}
}
unless(defined(&RT2560_SHIFT_D)) {
    sub RT2560_SHIFT_D () {	3;}
}
unless(defined(&RT2560_SHIFT_Q)) {
    sub RT2560_SHIFT_Q () {	4;}
}
unless(defined(&RT2560_KICK_TX)) {
    sub RT2560_KICK_TX () {	(1<< 0);}
}
unless(defined(&RT2560_KICK_ATIM)) {
    sub RT2560_KICK_ATIM () {	(1<< 1);}
}
unless(defined(&RT2560_KICK_PRIO)) {
    sub RT2560_KICK_PRIO () {	(1<< 2);}
}
unless(defined(&RT2560_ABORT_TX)) {
    sub RT2560_ABORT_TX () {	(1<< 3);}
}
unless(defined(&RT2560_KICK_DECRYPT)) {
    sub RT2560_KICK_DECRYPT () {	(1<< 0);}
}
unless(defined(&RT2560_KICK_ENCRYPT)) {
    sub RT2560_KICK_ENCRYPT () {	(1<< 0);}
}
unless(defined(&RT2560_BEACON_EXPIRE)) {
    sub RT2560_BEACON_EXPIRE () {	0x1;}
}
unless(defined(&RT2560_WAKEUP_EXPIRE)) {
    sub RT2560_WAKEUP_EXPIRE () {	0x2;}
}
unless(defined(&RT2560_ATIM_EXPIRE)) {
    sub RT2560_ATIM_EXPIRE () {	0x4;}
}
unless(defined(&RT2560_TX_DONE)) {
    sub RT2560_TX_DONE () {	0x8;}
}
unless(defined(&RT2560_ATIM_DONE)) {
    sub RT2560_ATIM_DONE () {	0x10;}
}
unless(defined(&RT2560_PRIO_DONE)) {
    sub RT2560_PRIO_DONE () {	0x20;}
}
unless(defined(&RT2560_RX_DONE)) {
    sub RT2560_RX_DONE () {	0x40;}
}
unless(defined(&RT2560_DECRYPTION_DONE)) {
    sub RT2560_DECRYPTION_DONE () {	0x80;}
}
unless(defined(&RT2560_ENCRYPTION_DONE)) {
    sub RT2560_ENCRYPTION_DONE () {	0x100;}
}
unless(defined(&RT2560_INTR_MASK)) {
    sub RT2560_INTR_MASK () {	(~( &RT2560_BEACON_EXPIRE |  &RT2560_WAKEUP_EXPIRE |  &RT2560_TX_DONE |  &RT2560_PRIO_DONE |  &RT2560_RX_DONE |  &RT2560_DECRYPTION_DONE |  &RT2560_ENCRYPTION_DONE));}
}
unless(defined(&RT2560_TX_BUSY)) {
    sub RT2560_TX_BUSY () {	(1<< 0);}
}
unless(defined(&RT2560_TX_VALID)) {
    sub RT2560_TX_VALID () {	(1<< 1);}
}
unless(defined(&RT2560_TX_RESULT_MASK)) {
    sub RT2560_TX_RESULT_MASK () {	0x1c;}
}
unless(defined(&RT2560_TX_SUCCESS)) {
    sub RT2560_TX_SUCCESS () {	(0<< 2);}
}
unless(defined(&RT2560_TX_SUCCESS_RETRY)) {
    sub RT2560_TX_SUCCESS_RETRY () {	(1<< 2);}
}
unless(defined(&RT2560_TX_FAIL_RETRY)) {
    sub RT2560_TX_FAIL_RETRY () {	(2<< 2);}
}
unless(defined(&RT2560_TX_FAIL_INVALID)) {
    sub RT2560_TX_FAIL_INVALID () {	(3<< 2);}
}
unless(defined(&RT2560_TX_FAIL_OTHER)) {
    sub RT2560_TX_FAIL_OTHER () {	(4<< 2);}
}
unless(defined(&RT2560_TX_MORE_FRAG)) {
    sub RT2560_TX_MORE_FRAG () {	(1<< 8);}
}
unless(defined(&RT2560_TX_NEED_ACK)) {
    sub RT2560_TX_NEED_ACK () {	(1<< 9);}
}
unless(defined(&RT2560_TX_TIMESTAMP)) {
    sub RT2560_TX_TIMESTAMP () {	(1<< 10);}
}
unless(defined(&RT2560_TX_OFDM)) {
    sub RT2560_TX_OFDM () {	(1<< 11);}
}
unless(defined(&RT2560_TX_CIPHER_BUSY)) {
    sub RT2560_TX_CIPHER_BUSY () {	(1<< 12);}
}
unless(defined(&RT2560_TX_IFS_MASK)) {
    sub RT2560_TX_IFS_MASK () {	0x6000;}
}
unless(defined(&RT2560_TX_IFS_BACKOFF)) {
    sub RT2560_TX_IFS_BACKOFF () {	(0<< 13);}
}
unless(defined(&RT2560_TX_IFS_SIFS)) {
    sub RT2560_TX_IFS_SIFS () {	(1<< 13);}
}
unless(defined(&RT2560_TX_IFS_NEWBACKOFF)) {
    sub RT2560_TX_IFS_NEWBACKOFF () {	(2<< 13);}
}
unless(defined(&RT2560_TX_IFS_NONE)) {
    sub RT2560_TX_IFS_NONE () {	(3<< 13);}
}
unless(defined(&RT2560_TX_LONG_RETRY)) {
    sub RT2560_TX_LONG_RETRY () {	(1<< 15);}
}
unless(defined(&RT2560_TX_CIPHER_MASK)) {
    sub RT2560_TX_CIPHER_MASK () {	0xe0000000;}
}
unless(defined(&RT2560_TX_CIPHER_NONE)) {
    sub RT2560_TX_CIPHER_NONE () {	(0<< 29);}
}
unless(defined(&RT2560_TX_CIPHER_WEP40)) {
    sub RT2560_TX_CIPHER_WEP40 () {	(1<< 29);}
}
unless(defined(&RT2560_TX_CIPHER_WEP104)) {
    sub RT2560_TX_CIPHER_WEP104 () {	(2<< 29);}
}
unless(defined(&RT2560_TX_CIPHER_TKIP)) {
    sub RT2560_TX_CIPHER_TKIP () {	(3<< 29);}
}
unless(defined(&RT2560_TX_CIPHER_AES)) {
    sub RT2560_TX_CIPHER_AES () {	(4<< 29);}
}
unless(defined(&RT2560_LOGCWMAX)) {
    sub RT2560_LOGCWMAX {
	my($x) = @_;
	eval q(((($x) & 0xf) << 12));
    }
}
unless(defined(&RT2560_LOGCWMIN)) {
    sub RT2560_LOGCWMIN {
	my($x) = @_;
	eval q(((($x) & 0xf) << 8));
    }
}
unless(defined(&RT2560_AIFSN)) {
    sub RT2560_AIFSN {
	my($x) = @_;
	eval q(((($x) & 0x3) << 6));
    }
}
unless(defined(&RT2560_IVOFFSET)) {
    sub RT2560_IVOFFSET {
	my($x) = @_;
	eval q(((($x) & 0x3f)));
    }
}
unless(defined(&RT2560_PLCP_LENGEXT)) {
    sub RT2560_PLCP_LENGEXT () {	0x80;}
}
unless(defined(&RT2560_RX_BUSY)) {
    sub RT2560_RX_BUSY () {	(1<< 0);}
}
unless(defined(&RT2560_RX_CRC_ERROR)) {
    sub RT2560_RX_CRC_ERROR () {	(1<< 5);}
}
unless(defined(&RT2560_RX_OFDM)) {
    sub RT2560_RX_OFDM () {	(1<< 6);}
}
unless(defined(&RT2560_RX_PHY_ERROR)) {
    sub RT2560_RX_PHY_ERROR () {	(1<< 7);}
}
unless(defined(&RT2560_RX_CIPHER_BUSY)) {
    sub RT2560_RX_CIPHER_BUSY () {	(1<< 8);}
}
unless(defined(&RT2560_RX_ICV_ERROR)) {
    sub RT2560_RX_ICV_ERROR () {	(1<< 9);}
}
unless(defined(&RT2560_RX_CIPHER_MASK)) {
    sub RT2560_RX_CIPHER_MASK () {	0xe0000000;}
}
unless(defined(&RT2560_RX_CIPHER_NONE)) {
    sub RT2560_RX_CIPHER_NONE () {	(0<< 29);}
}
unless(defined(&RT2560_RX_CIPHER_WEP40)) {
    sub RT2560_RX_CIPHER_WEP40 () {	(1<< 29);}
}
unless(defined(&RT2560_RX_CIPHER_WEP104)) {
    sub RT2560_RX_CIPHER_WEP104 () {	(2<< 29);}
}
unless(defined(&RT2560_RX_CIPHER_TKIP)) {
    sub RT2560_RX_CIPHER_TKIP () {	(3<< 29);}
}
unless(defined(&RT2560_RX_CIPHER_AES)) {
    sub RT2560_RX_CIPHER_AES () {	(4<< 29);}
}
unless(defined(&RT2560_RF1)) {
    sub RT2560_RF1 () {	0;}
}
unless(defined(&RT2560_RF2)) {
    sub RT2560_RF2 () {	2;}
}
unless(defined(&RT2560_RF3)) {
    sub RT2560_RF3 () {	1;}
}
unless(defined(&RT2560_RF4)) {
    sub RT2560_RF4 () {	3;}
}
unless(defined(&RT2560_RF1_AUTOTUNE)) {
    sub RT2560_RF1_AUTOTUNE () {	0x8000;}
}
unless(defined(&RT2560_RF3_AUTOTUNE)) {
    sub RT2560_RF3_AUTOTUNE () {	0x40;}
}
unless(defined(&RT2560_BBP_BUSY)) {
    sub RT2560_BBP_BUSY () {	(1<< 15);}
}
unless(defined(&RT2560_BBP_WRITE)) {
    sub RT2560_BBP_WRITE () {	(1<< 16);}
}
unless(defined(&RT2560_RF_20BIT)) {
    sub RT2560_RF_20BIT () {	(20<< 24);}
}
unless(defined(&RT2560_RF_BUSY)) {
    sub RT2560_RF_BUSY () {	(1<< 31);}
}
unless(defined(&RT2560_RF_2522)) {
    sub RT2560_RF_2522 () {	0x;}
}
unless(defined(&RT2560_RF_2523)) {
    sub RT2560_RF_2523 () {	0x1;}
}
unless(defined(&RT2560_RF_2524)) {
    sub RT2560_RF_2524 () {	0x2;}
}
unless(defined(&RT2560_RF_2525)) {
    sub RT2560_RF_2525 () {	0x3;}
}
unless(defined(&RT2560_RF_2525E)) {
    sub RT2560_RF_2525E () {	0x4;}
}
unless(defined(&RT2560_RF_2526)) {
    sub RT2560_RF_2526 () {	0x5;}
}
unless(defined(&RT2560_RF_5222)) {
    sub RT2560_RF_5222 () {	0x10;}
}
unless(defined(&RT2560_BBP_VERSION)) {
    sub RT2560_BBP_VERSION () {	0;}
}
unless(defined(&RT2560_BBP_TX)) {
    sub RT2560_BBP_TX () {	2;}
}
unless(defined(&RT2560_BBP_RX)) {
    sub RT2560_BBP_RX () {	14;}
}
unless(defined(&RT2560_BBP_ANTA)) {
    sub RT2560_BBP_ANTA () {	0x;}
}
unless(defined(&RT2560_BBP_DIVERSITY)) {
    sub RT2560_BBP_DIVERSITY () {	0x1;}
}
unless(defined(&RT2560_BBP_ANTB)) {
    sub RT2560_BBP_ANTB () {	0x2;}
}
unless(defined(&RT2560_BBP_ANTMASK)) {
    sub RT2560_BBP_ANTMASK () {	0x3;}
}
unless(defined(&RT2560_BBP_FLIPIQ)) {
    sub RT2560_BBP_FLIPIQ () {	0x4;}
}
unless(defined(&RT2560_LED_MODE_DEFAULT)) {
    sub RT2560_LED_MODE_DEFAULT () {	0;}
}
unless(defined(&RT2560_LED_MODE_TXRX_ACTIVITY)) {
    sub RT2560_LED_MODE_TXRX_ACTIVITY () {	1;}
}
unless(defined(&RT2560_LED_MODE_SINGLE)) {
    sub RT2560_LED_MODE_SINGLE () {	2;}
}
unless(defined(&RT2560_LED_MODE_ASUS)) {
    sub RT2560_LED_MODE_ASUS () {	3;}
}
unless(defined(&RT2560_JAPAN_FILTER)) {
    sub RT2560_JAPAN_FILTER () {	0x8;}
}
unless(defined(&RT2560_EEPROM_CONFIG0)) {
    sub RT2560_EEPROM_CONFIG0 () {	16;}
}
unless(defined(&RT2560_EEPROM_BBP_BASE)) {
    sub RT2560_EEPROM_BBP_BASE () {	19;}
}
unless(defined(&RT2560_EEPROM_TXPOWER)) {
    sub RT2560_EEPROM_TXPOWER () {	35;}
}
unless(defined(&RT2560_EEPROM_DELAY)) {
    sub RT2560_EEPROM_DELAY () {	1;}
}
unless(defined(&RAL_READ)) {
    sub RAL_READ {
	my($sc, $reg) = @_;
	eval q( &bus_space_read_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg)));
    }
}
unless(defined(&RAL_WRITE)) {
    sub RAL_WRITE {
	my($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4(($sc)-> &sc_st, ($sc)-> &sc_sh, ($reg), ($val)));
    }
}
unless(defined(&RT2560_EEPROM_CTL)) {
    sub RT2560_EEPROM_CTL {
	my($sc, $val) = @_;
	eval q( &do {  &RAL_WRITE(($sc),  &RT2560_CSR21, ($val));  &DELAY( &RT2560_EEPROM_DELAY); }  &while ( 0));
    }
}
unless(defined(&RT2560_DEF_MAC)) {
    sub RT2560_DEF_MAC () {	{  &RT2560_PSCSR0, 0x20002 }, {  &RT2560_PSCSR1, 0x2 }, {  &RT2560_PSCSR2, 0x20002 }, {  &RT2560_PSCSR3, 0x2 }, {  &RT2560_TIMECSR, 0x3f21 }, {  &RT2560_CSR9, 0x780 }, {  &RT2560_CSR11, 0x7041483 }, {  &RT2560_CNT3, 0x }, {  &RT2560_TXCSR1, 0x7614562 }, {  &RT2560_ARSP_PLCP_0, 0x8c8d8b8a }, {  &RT2560_ACKPCTCSR, 0x7038140a }, {  &RT2560_ARTCSR1, 0x1d21252d }, {  &RT2560_ARTCSR2, 0x1919191d }, {  &RT2560_RXCSR0, 0xffffffff }, {  &RT2560_RXCSR3, 0xb3aab3af }, {  &RT2560_PCICSR, 0x3b8 }, {  &RT2560_PWRCSR0, 0x3f3b3100 }, {  &RT2560_GPIOCSR, 0xff00 }, {  &RT2560_TESTCSR, 0xf0 }, {  &RT2560_PWRCSR1, 0x1ff }, {  &RT2560_MACCSR0, 0x213223 }, {  &RT2560_MACCSR1, 0x235518 }, {  &RT2560_RLPWCSR, 0x40 }, {  &RT2560_RALINKCSR, 0x9a009a11 }, {  &RT2560_CSR7, 0xffffffff }, {  &RT2560_BBPCSR1, 0x82188200 }, {  &RT2560_TXACKCSR0, 0x20 }, {  &RT2560_SECCSR3, 0xe78f };}
}
unless(defined(&RT2560_DEF_BBP)) {
    sub RT2560_DEF_BBP () {	{ 3, 0x2 }, { 4, 0x19 }, { 14, 0x1c }, { 15, 0x30 }, { 16, 0xac }, { 17, 0x48 }, { 18, 0x18 }, { 19, 0xff }, { 20, 0x1e }, { 21, 0x8 }, { 22, 0x8 }, { 23, 0x8 }, { 24, 0x80 }, { 25, 0x50 }, { 26, 0x8 }, { 27, 0x23 }, { 30, 0x10 }, { 31, 0x2b }, { 32, 0xb9 }, { 34, 0x12 }, { 35, 0x50 }, { 39, 0xc4 }, { 40, 0x2 }, { 41, 0x60 }, { 53, 0x10 }, { 54, 0x18 }, { 56, 0x8 }, { 57, 0x10 }, { 58, 0x8 }, { 61, 0x60 }, { 62, 0x10 }, { 75, 0xff };}
}
unless(defined(&RT2560_RF2522_R2)) {
    sub RT2560_RF2522_R2 () {	{ 0x307f6, 0x307fb, 0x30800, 0x30805, 0x3080a, 0x3080f, 0x30814, 0x30819, 0x3081e, 0x30823, 0x30828, 0x3082d, 0x30832, 0x3083e };}
}
unless(defined(&RT2560_RF2523_R2)) {
    sub RT2560_RF2523_R2 () {	{ 0x327, 0x328, 0x329, 0x32a, 0x32b, 0x32c, 0x32d, 0x32e, 0x32f, 0x340, 0x341, 0x342, 0x343, 0x346 };}
}
unless(defined(&RT2560_RF2524_R2)) {
    sub RT2560_RF2524_R2 () {	{ 0x327, 0x328, 0x329, 0x32a, 0x32b, 0x32c, 0x32d, 0x32e, 0x32f, 0x340, 0x341, 0x342, 0x343, 0x346 };}
}
unless(defined(&RT2560_RF2525_R2)) {
    sub RT2560_RF2525_R2 () {	{ 0x20327, 0x20328, 0x20329, 0x2032a, 0x2032b, 0x2032c, 0x2032d, 0x2032e, 0x2032f, 0x20340, 0x20341, 0x20342, 0x20343, 0x20346 };}
}
unless(defined(&RT2560_RF2525_HI_R2)) {
    sub RT2560_RF2525_HI_R2 () {	{ 0x2032f, 0x20340, 0x20341, 0x20342, 0x20343, 0x20344, 0x20345, 0x20346, 0x20347, 0x20348, 0x20349, 0x2034a, 0x2034b, 0x2034e };}
}
unless(defined(&RT2560_RF2525E_R2)) {
    sub RT2560_RF2525E_R2 () {	{ 0x2044d, 0x2044e, 0x2044f, 0x20460, 0x20461, 0x20462, 0x20463, 0x20464, 0x20465, 0x20466, 0x20467, 0x20468, 0x20469, 0x2046b };}
}
unless(defined(&RT2560_RF2526_HI_R2)) {
    sub RT2560_RF2526_HI_R2 () {	{ 0x22a, 0x22b, 0x22b, 0x22c, 0x22c, 0x22d, 0x22d, 0x22e, 0x22e, 0x22f, 0x22d, 0x240, 0x240, 0x241 };}
}
unless(defined(&RT2560_RF2526_R2)) {
    sub RT2560_RF2526_R2 () {	{ 0x226, 0x227, 0x227, 0x228, 0x228, 0x229, 0x229, 0x22a, 0x22a, 0x22b, 0x22b, 0x22c, 0x22c, 0x22d };}
}
1;
