require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_DEV_IC_AIC6915_H_)) {
    eval 'sub _DEV_IC_AIC6915_H_ () {1;}' unless defined(&_DEV_IC_AIC6915_H_);
    require 'sys/timeout.ph';
    eval 'sub RBD_V () {(1 << 0);}' unless defined(&RBD_V);
    eval 'sub RBD_E () {(1 << 1);}' unless defined(&RBD_E);
    eval 'sub RCD_W0_ID () {(1 << 30);}' unless defined(&RCD_W0_ID);
    eval 'sub RCD_W0_Length {
        my($x) = @_;
	    eval q((($x) & 0xffff));
    }' unless defined(&RCD_W0_Length);
    eval 'sub RCD_W0_EndIndex {
        my($x) = @_;
	    eval q(((($x) >> 16) & 0x7ff));
    }' unless defined(&RCD_W0_EndIndex);
    eval 'sub RCD_W0_BufferQueue () {(1 << 27);}' unless defined(&RCD_W0_BufferQueue);
    eval 'sub RCD_W0_FifoFull () {(1 << 28);}' unless defined(&RCD_W0_FifoFull);
    eval 'sub RCD_W0_OK () {(1 << 29);}' unless defined(&RCD_W0_OK);
    eval 'sub RCD_W1_FrameType () {(7 << 16);}' unless defined(&RCD_W1_FrameType);
    eval 'sub RCD_W1_FrameType_Unknown () {(0<< 16);}' unless defined(&RCD_W1_FrameType_Unknown);
    eval 'sub RCD_W1_FrameType_IPv4 () {(1 << 16);}' unless defined(&RCD_W1_FrameType_IPv4);
    eval 'sub RCD_W1_FrameType_IPv6 () {(2 << 16);}' unless defined(&RCD_W1_FrameType_IPv6);
    eval 'sub RCD_W1_FrameType_IPX () {(3 << 16);}' unless defined(&RCD_W1_FrameType_IPX);
    eval 'sub RCD_W1_FrameType_ICMP () {(4 << 16);}' unless defined(&RCD_W1_FrameType_ICMP);
    eval 'sub RCD_W1_FrameType_Unsupported () {(5 << 16);}' unless defined(&RCD_W1_FrameType_Unsupported);
    eval 'sub RCD_W1_UdpFrame () {(1 << 19);}' unless defined(&RCD_W1_UdpFrame);
    eval 'sub RCD_W1_TcpFrame () {(1 << 20);}' unless defined(&RCD_W1_TcpFrame);
    eval 'sub RCD_W1_Fragmented () {(1 << 21);}' unless defined(&RCD_W1_Fragmented);
    eval 'sub RCD_W1_PartialChecksumValid () {(1 << 22);}' unless defined(&RCD_W1_PartialChecksumValid);
    eval 'sub RCD_W1_ChecksumBad () {(1 << 23);}' unless defined(&RCD_W1_ChecksumBad);
    eval 'sub RCD_W1_ChecksumOk () {(1 << 24);}' unless defined(&RCD_W1_ChecksumOk);
    eval 'sub RCD_W1_VlanFrame () {(1 << 25);}' unless defined(&RCD_W1_VlanFrame);
    eval 'sub RCD_W1_ReceiveCodeViolation () {(1 << 26);}' unless defined(&RCD_W1_ReceiveCodeViolation);
    eval 'sub RCD_W1_Dribble () {(1 << 27);}' unless defined(&RCD_W1_Dribble);
    eval 'sub RCD_W1_ISLCRCerror () {(1 << 28);}' unless defined(&RCD_W1_ISLCRCerror);
    eval 'sub RCD_W1_CRCerror () {(1 << 29);}' unless defined(&RCD_W1_CRCerror);
    eval 'sub RCD_W1_Hash () {(1 << 30);}' unless defined(&RCD_W1_Hash);
    eval 'sub RCD_W1_Perfect () {(1 << 31);}' unless defined(&RCD_W1_Perfect);
    eval 'sub RCD_W1_VLANID {
        my($x) = @_;
	    eval q((($x) & 0xffff));
    }' unless defined(&RCD_W1_VLANID);
    eval 'sub RCD_W1_TCP_UDP_Checksum {
        my($x) = @_;
	    eval q((($x) & 0xffff));
    }' unless defined(&RCD_W1_TCP_UDP_Checksum);
    eval 'sub RCD_W1_Trailer () {(1 << 11);}' unless defined(&RCD_W1_Trailer);
    eval 'sub RCD_W1_Header () {(1 << 12);}' unless defined(&RCD_W1_Header);
    eval 'sub RCD_W1_ControlFrame () {(1 << 13);}' unless defined(&RCD_W1_ControlFrame);
    eval 'sub RCD_W1_PauseFrame () {(1 << 14);}' unless defined(&RCD_W1_PauseFrame);
    eval 'sub RCD_W1_IslFrame () {(1 << 15);}' unless defined(&RCD_W1_IslFrame);
    eval 'sub RCD_W1_StartIndex {
        my($x) = @_;
	    eval q((($x) & 0x7ff));
    }' unless defined(&RCD_W1_StartIndex);
    eval 'sub RCD_W2_TCP_UDP_Checksum {
        my($x) = @_;
	    eval q((($x) >> 16));
    }' unless defined(&RCD_W2_TCP_UDP_Checksum);
    eval 'sub RCD_W2_VLANID {
        my($x) = @_;
	    eval q((($x) & 0xffff));
    }' unless defined(&RCD_W2_VLANID);
    eval 'sub SF_NTXFRAGS () {15;}' unless defined(&SF_NTXFRAGS);
    eval 'sub TD_W1_NTXBUFS () {(0xff << 0);}' unless defined(&TD_W1_NTXBUFS);
    eval 'sub TD_W0_ID () {(0xb << 28);}' unless defined(&TD_W0_ID);
    eval 'sub TD_W0_INTR () {(1 << 27);}' unless defined(&TD_W0_INTR);
    eval 'sub TD_W0_END () {(1 << 26);}' unless defined(&TD_W0_END);
    eval 'sub TD_W0_CALTCP () {(1 << 25);}' unless defined(&TD_W0_CALTCP);
    eval 'sub TD_W0_CRCEN () {(1 << 24);}' unless defined(&TD_W0_CRCEN);
    eval 'sub TD_W0_LEN () {(0xffff << 0);}' unless defined(&TD_W0_LEN);
    eval 'sub TD_W0_NTXBUFS () {(0xff << 16);}' unless defined(&TD_W0_NTXBUFS);
    eval 'sub TD_W0_NTXBUFS_SHIFT () {16;}' unless defined(&TD_W0_NTXBUFS_SHIFT);
    eval 'sub TCD_DMA_ID () {(0x4 << 29);}' unless defined(&TCD_DMA_ID);
    eval 'sub TCD_INDEX {
        my($x) = @_;
	    eval q((($x) & 0x7fff));
    }' unless defined(&TCD_INDEX);
    eval 'sub TCD_PR () {(1 << 15);}' unless defined(&TCD_PR);
    eval 'sub TCD_TIMESTAMP {
        my($x) = @_;
	    eval q(((($x) >> 16) & 0x1fff));
    }' unless defined(&TCD_TIMESTAMP);
    eval 'sub TCD_TX_ID () {(0x5 << 29);}' unless defined(&TCD_TX_ID);
    eval 'sub TCD_CRCerror () {(1 << 16);}' unless defined(&TCD_CRCerror);
    eval 'sub TCD_FieldLengthCkError () {(1 << 17);}' unless defined(&TCD_FieldLengthCkError);
    eval 'sub TCD_FieldLengthRngError () {(1 << 18);}' unless defined(&TCD_FieldLengthRngError);
    eval 'sub TCD_PacketTxOk () {(1 << 19);}' unless defined(&TCD_PacketTxOk);
    eval 'sub TCD_Deferred () {(1 << 20);}' unless defined(&TCD_Deferred);
    eval 'sub TCD_ExDeferral () {(1 << 21);}' unless defined(&TCD_ExDeferral);
    eval 'sub TCD_ExCollisions () {(1 << 22);}' unless defined(&TCD_ExCollisions);
    eval 'sub TCD_LateCollision () {(1 << 23);}' unless defined(&TCD_LateCollision);
    eval 'sub TCD_LongFrame () {(1 << 24);}' unless defined(&TCD_LongFrame);
    eval 'sub TCD_FIFOUnderrun () {(1 << 25);}' unless defined(&TCD_FIFOUnderrun);
    eval 'sub TCD_ControlTx () {(1 << 26);}' unless defined(&TCD_ControlTx);
    eval 'sub TCD_PauseTx () {(1 << 27);}' unless defined(&TCD_PauseTx);
    eval 'sub TCD_TxPaused () {(1 << 28);}' unless defined(&TCD_TxPaused);
    eval 'sub SF_TXDINDEX_TO_HOST {
        my($x) = @_;
	    eval q((($x) >> 4));
    }' unless defined(&SF_TXDINDEX_TO_HOST);
    eval 'sub SF_TXDINDEX_TO_CHIP {
        my($x) = @_;
	    eval q((($x) << 4));
    }' unless defined(&SF_TXDINDEX_TO_CHIP);
    eval 'sub SF_TCD_INDEX_TO_HOST {
        my($x) = @_;
	    eval q((($x) >> 7));
    }' unless defined(&SF_TCD_INDEX_TO_HOST);
    eval 'sub SF_PCI_MEMBA () {( &PCI_MAPREG_START + 0x);}' unless defined(&SF_PCI_MEMBA);
    eval 'sub SF_PCI_IOBA () {( &PCI_MAPREG_START + 0x8);}' unless defined(&SF_PCI_IOBA);
    eval 'sub SF_GENREG_OFFSET () {0x50000;}' unless defined(&SF_GENREG_OFFSET);
    eval 'sub SF_FUNCREG_SIZE () {0x100;}' unless defined(&SF_FUNCREG_SIZE);
    eval 'sub SF_PciDeviceConfig () {0x40;}' unless defined(&SF_PciDeviceConfig);
    eval 'sub PDC_EnDpeInt () {(1 << 31);}' unless defined(&PDC_EnDpeInt);
    eval 'sub PDC_EnSseInt () {(1 << 30);}' unless defined(&PDC_EnSseInt);
    eval 'sub PDC_EnRmaInt () {(1 << 29);}' unless defined(&PDC_EnRmaInt);
    eval 'sub PDC_EnRtaInt () {(1 << 28);}' unless defined(&PDC_EnRtaInt);
    eval 'sub PDC_EnStaInt () {(1 << 27);}' unless defined(&PDC_EnStaInt);
    eval 'sub PDC_EnDprInt () {(1 << 24);}' unless defined(&PDC_EnDprInt);
    eval 'sub PDC_IntEnable () {(1 << 23);}' unless defined(&PDC_IntEnable);
    eval 'sub PDC_ExternalRegCsWidth () {(7 << 20);}' unless defined(&PDC_ExternalRegCsWidth);
    eval 'sub PDC_StopMWrOnCacheLineDis () {(1 << 19);}' unless defined(&PDC_StopMWrOnCacheLineDis);
    eval 'sub PDC_EpromCsWidth () {(7 << 16);}' unless defined(&PDC_EpromCsWidth);
    eval 'sub PDC_EnBeLogic () {(1 << 15);}' unless defined(&PDC_EnBeLogic);
    eval 'sub PDC_LatencyStopOnCacheLine () {(1 << 14);}' unless defined(&PDC_LatencyStopOnCacheLine);
    eval 'sub PDC_PCIMstDmaEn () {(1 << 13);}' unless defined(&PDC_PCIMstDmaEn);
    eval 'sub PDC_StopOnCachelineEn () {(1 << 12);}' unless defined(&PDC_StopOnCachelineEn);
    eval 'sub PDC_FifoThreshold () {(0xf << 8);}' unless defined(&PDC_FifoThreshold);
    eval 'sub PDC_FifoThreshold_SHIFT () {8;}' unless defined(&PDC_FifoThreshold_SHIFT);
    eval 'sub PDC_MemRdCmdEn () {(1 << 7);}' unless defined(&PDC_MemRdCmdEn);
    eval 'sub PDC_StopOnPerr () {(1 << 6);}' unless defined(&PDC_StopOnPerr);
    eval 'sub PDC_AbortOnAddrParityErr () {(1 << 5);}' unless defined(&PDC_AbortOnAddrParityErr);
    eval 'sub PDC_EnIncrement () {(1 << 4);}' unless defined(&PDC_EnIncrement);
    eval 'sub PDC_System64 () {(1 << 2);}' unless defined(&PDC_System64);
    eval 'sub PDC_Force64 () {(1 << 1);}' unless defined(&PDC_Force64);
    eval 'sub PDC_SoftReset () {(1 << 0);}' unless defined(&PDC_SoftReset);
    eval 'sub SF_BacControl () {0x44;}' unless defined(&SF_BacControl);
    eval 'sub BC_DescSwapMode () {(0x3 << 6);}' unless defined(&BC_DescSwapMode);
    eval 'sub BC_DataSwapMode () {(0x3 << 4);}' unless defined(&BC_DataSwapMode);
    eval 'sub BC_SingleDmaMode () {(1 << 3);}' unless defined(&BC_SingleDmaMode);
    eval 'sub BC_PreferTxDmaReq () {(1 << 2);}' unless defined(&BC_PreferTxDmaReq);
    eval 'sub BC_PreferRxDmaReq () {(1 << 1);}' unless defined(&BC_PreferRxDmaReq);
    eval 'sub BC_BacDmaEn () {(1 << 0);}' unless defined(&BC_BacDmaEn);
    eval 'sub SF_PciMonitor1 () {0x48;}' unless defined(&SF_PciMonitor1);
    eval 'sub SF_PciMonitor2 () {0x4c;}' unless defined(&SF_PciMonitor2);
    eval 'sub SF_PMC () {0x50;}' unless defined(&SF_PMC);
    eval 'sub SF_PMCSR () {0x54;}' unless defined(&SF_PMCSR);
    eval 'sub SF_PMEvent () {0x58;}' unless defined(&SF_PMEvent);
    eval 'sub SF_SerialEpromControl () {0x60;}' unless defined(&SF_SerialEpromControl);
    eval 'sub SEC_InitDone () {(1 << 3);}' unless defined(&SEC_InitDone);
    eval 'sub SEC_Idle () {(1 << 2);}' unless defined(&SEC_Idle);
    eval 'sub SEC_WriteEnable () {(1 << 1);}' unless defined(&SEC_WriteEnable);
    eval 'sub SEC_WriteDisable () {(1 << 0);}' unless defined(&SEC_WriteDisable);
    eval 'sub SF_PciComplianceTesting () {0x64;}' unless defined(&SF_PciComplianceTesting);
    eval 'sub SF_IndirectIoAccess () {0x68;}' unless defined(&SF_IndirectIoAccess);
    eval 'sub SF_IndirectIoDataPort () {0x6c;}' unless defined(&SF_IndirectIoDataPort);
    eval 'sub SF_GeneralEthernetCtrl () {0x70;}' unless defined(&SF_GeneralEthernetCtrl);
    eval 'sub GEC_SetSoftInt () {(1 << 8);}' unless defined(&GEC_SetSoftInt);
    eval 'sub GEC_TxGfpEn () {(1 << 5);}' unless defined(&GEC_TxGfpEn);
    eval 'sub GEC_RxGfpEn () {(1 << 4);}' unless defined(&GEC_RxGfpEn);
    eval 'sub GEC_TxDmaEn () {(1 << 3);}' unless defined(&GEC_TxDmaEn);
    eval 'sub GEC_RxDmaEn () {(1 << 2);}' unless defined(&GEC_RxDmaEn);
    eval 'sub GEC_TransmitEn () {(1 << 1);}' unless defined(&GEC_TransmitEn);
    eval 'sub GEC_ReceiveEn () {(1 << 0);}' unless defined(&GEC_ReceiveEn);
    eval 'sub SF_TimersControl () {0x74;}' unless defined(&SF_TimersControl);
    eval 'sub TC_EarlyRxQ1IntDelayDisable () {(1 << 31);}' unless defined(&TC_EarlyRxQ1IntDelayDisable);
    eval 'sub TC_RxQ1DoneIntDelayDisable () {(1 << 30);}' unless defined(&TC_RxQ1DoneIntDelayDisable);
    eval 'sub TC_EarlyRxQ2IntDelayDisable () {(1 << 29);}' unless defined(&TC_EarlyRxQ2IntDelayDisable);
    eval 'sub TC_RxQ2DoneIntDelayDisable () {(1 << 28);}' unless defined(&TC_RxQ2DoneIntDelayDisable);
    eval 'sub TC_TimeStampResolution () {(1 << 26);}' unless defined(&TC_TimeStampResolution);
    eval 'sub TC_GeneralTimerResolution () {(1 << 25);}' unless defined(&TC_GeneralTimerResolution);
    eval 'sub TC_OneShotMode () {(1 << 24);}' unless defined(&TC_OneShotMode);
    eval 'sub TC_GeneralTimerInterval () {(0xff << 16);}' unless defined(&TC_GeneralTimerInterval);
    eval 'sub TC_GeneralTimerInterval_SHIFT () {16;}' unless defined(&TC_GeneralTimerInterval_SHIFT);
    eval 'sub TC_TxFrameCompleteIntDelayDisable () {(1 << 15);}' unless defined(&TC_TxFrameCompleteIntDelayDisable);
    eval 'sub TC_TxQueueDoneIntDelayDisable () {(1 << 14);}' unless defined(&TC_TxQueueDoneIntDelayDisable);
    eval 'sub TC_TxDmaDoneIntDelayDisable () {(1 << 13);}' unless defined(&TC_TxDmaDoneIntDelayDisable);
    eval 'sub TC_RxHiPrBypass () {(1 << 12);}' unless defined(&TC_RxHiPrBypass);
    eval 'sub TC_Timer10X () {(1 << 11);}' unless defined(&TC_Timer10X);
    eval 'sub TC_SmallRxFrame () {(3 << 9);}' unless defined(&TC_SmallRxFrame);
    eval 'sub TC_SmallFrameBypass () {(1 << 8);}' unless defined(&TC_SmallFrameBypass);
    eval 'sub TC_IntMaskMode () {(3 << 5);}' unless defined(&TC_IntMaskMode);
    eval 'sub TC_IntMaskPeriod () {(0x1f << 0);}' unless defined(&TC_IntMaskPeriod);
    eval 'sub SF_CurrentTime () {0x78;}' unless defined(&SF_CurrentTime);
    eval 'sub SF_InterruptStatus () {0x80;}' unless defined(&SF_InterruptStatus);
    eval 'sub IS_GPIO3 () {(1 << 31);}' unless defined(&IS_GPIO3);
    eval 'sub IS_GPIO2 () {(1 << 30);}' unless defined(&IS_GPIO2);
    eval 'sub IS_GPIO1 () {(1 << 29);}' unless defined(&IS_GPIO1);
    eval 'sub IS_GPIO0 () {(1 << 28);}' unless defined(&IS_GPIO0);
    eval 'sub IS_StatisticWrapInt () {(1 << 27);}' unless defined(&IS_StatisticWrapInt);
    eval 'sub IS_AbnormalInterrupt () {(1 << 25);}' unless defined(&IS_AbnormalInterrupt);
    eval 'sub IS_GeneralTimerInt () {(1 << 24);}' unless defined(&IS_GeneralTimerInt);
    eval 'sub IS_SoftInt () {(1 << 23);}' unless defined(&IS_SoftInt);
    eval 'sub IS_RxCompletionQueue1Int () {(1 << 22);}' unless defined(&IS_RxCompletionQueue1Int);
    eval 'sub IS_TxCompletionQueueInt () {(1 << 21);}' unless defined(&IS_TxCompletionQueueInt);
    eval 'sub IS_PCIInt () {(1 << 20);}' unless defined(&IS_PCIInt);
    eval 'sub IS_DmaErrInt () {(1 << 19);}' unless defined(&IS_DmaErrInt);
    eval 'sub IS_TxDataLowInt () {(1 << 18);}' unless defined(&IS_TxDataLowInt);
    eval 'sub IS_RxCompletionQueue2Int () {(1 << 17);}' unless defined(&IS_RxCompletionQueue2Int);
    eval 'sub IS_RxQ1LowBuffersInt () {(1 << 16);}' unless defined(&IS_RxQ1LowBuffersInt);
    eval 'sub IS_NormalInterrupt () {(1 << 15);}' unless defined(&IS_NormalInterrupt);
    eval 'sub IS_TxFrameCompleteInt () {(1 << 14);}' unless defined(&IS_TxFrameCompleteInt);
    eval 'sub IS_TxDmaDoneInt () {(1 << 13);}' unless defined(&IS_TxDmaDoneInt);
    eval 'sub IS_TxQueueDoneInt () {(1 << 12);}' unless defined(&IS_TxQueueDoneInt);
    eval 'sub IS_EarlyRxQ2Int () {(1 << 11);}' unless defined(&IS_EarlyRxQ2Int);
    eval 'sub IS_EarlyRxQ1Int () {(1 << 10);}' unless defined(&IS_EarlyRxQ1Int);
    eval 'sub IS_RxQ2DoneInt () {(1 << 9);}' unless defined(&IS_RxQ2DoneInt);
    eval 'sub IS_RxQ1DoneInt () {(1 << 8);}' unless defined(&IS_RxQ1DoneInt);
    eval 'sub IS_RxGfpNoResponseInt () {(1 << 7);}' unless defined(&IS_RxGfpNoResponseInt);
    eval 'sub IS_RxQ2LowBuffersInt () {(1 << 6);}' unless defined(&IS_RxQ2LowBuffersInt);
    eval 'sub IS_NoTxChecksumInt () {(1 << 5);}' unless defined(&IS_NoTxChecksumInt);
    eval 'sub IS_TxLowPrMismatchInt () {(1 << 4);}' unless defined(&IS_TxLowPrMismatchInt);
    eval 'sub IS_TxHiPrMismatchInt () {(1 << 3);}' unless defined(&IS_TxHiPrMismatchInt);
    eval 'sub IS_GfpRxInt () {(1 << 2);}' unless defined(&IS_GfpRxInt);
    eval 'sub IS_GfpTxInt () {(1 << 1);}' unless defined(&IS_GfpTxInt);
    eval 'sub IS_PCIPadInt () {(1 << 0);}' unless defined(&IS_PCIPadInt);
    eval 'sub SF_ShadowInterruptStatus () {0x84;}' unless defined(&SF_ShadowInterruptStatus);
    eval 'sub SF_InterruptEn () {0x88;}' unless defined(&SF_InterruptEn);
    eval 'sub SF_GPIO () {0x8c;}' unless defined(&SF_GPIO);
    eval 'sub GPIOCtrl {
        my($x) = @_;
	    eval q((1 << (24+ ($x))));
    }' unless defined(&GPIOCtrl);
    eval 'sub GPIOOutMode {
        my($x) = @_;
	    eval q((1 << (16+ ($x))));
    }' unless defined(&GPIOOutMode);
    eval 'sub GPIOInpMode {
        my($x, $y) = @_;
	    eval q((($y) << (8+ (($x) * 2))));
    }' unless defined(&GPIOInpMode);
    eval 'sub GPIOData {
        my($x) = @_;
	    eval q((1 << ($x)));
    }' unless defined(&GPIOData);
    eval 'sub SF_TxDescQueueCtrl () {0x90;}' unless defined(&SF_TxDescQueueCtrl);
    eval 'sub TDQC_TxHighPriorityFifoThreshold {
        my($x) = @_;
	    eval q((($x) << 24));
    }' unless defined(&TDQC_TxHighPriorityFifoThreshold);
    eval 'sub TDQC_SkipLength {
        my($x) = @_;
	    eval q((($x) << 16));
    }' unless defined(&TDQC_SkipLength);
    eval 'sub TDQC_TxDmaBurstSize {
        my($x) = @_;
	    eval q((($x) << 8));
    }' unless defined(&TDQC_TxDmaBurstSize);
    eval 'sub TDQC_TxDescQueue64bitAddr () {(1 << 7);}' unless defined(&TDQC_TxDescQueue64bitAddr);
    eval 'sub TDQC_MinFrameSpacing {
        my($x) = @_;
	    eval q((($x) << 4));
    }' unless defined(&TDQC_MinFrameSpacing);
    eval 'sub TDQC_DisableTxDmaCompletion () {(1 << 3);}' unless defined(&TDQC_DisableTxDmaCompletion);
    eval 'sub TDQC_TxDescType {
        my($x) = @_;
	    eval q((($x) << 0));
    }' unless defined(&TDQC_TxDescType);
    eval 'sub SF_HiPrTxDescQueueBaseAddr () {0x94;}' unless defined(&SF_HiPrTxDescQueueBaseAddr);
    eval 'sub SF_LoPrTxDescQueueBaseAddr () {0x98;}' unless defined(&SF_LoPrTxDescQueueBaseAddr);
    eval 'sub SF_TxDescQueueHighAddr () {0x9c;}' unless defined(&SF_TxDescQueueHighAddr);
    eval 'sub SF_TxDescQueueProducerIndex () {0xa0;}' unless defined(&SF_TxDescQueueProducerIndex);
    eval 'sub TDQPI_HiPrTxProducerIndex {
        my($x) = @_;
	    eval q((($x) << 16));
    }' unless defined(&TDQPI_HiPrTxProducerIndex);
    eval 'sub TDQPI_LoPrTxProducerIndex {
        my($x) = @_;
	    eval q((($x) << 0));
    }' unless defined(&TDQPI_LoPrTxProducerIndex);
    eval 'sub TDQPI_HiPrTxProducerIndex_get {
        my($x) = @_;
	    eval q(((($x) >> 16) & 0x7ff));
    }' unless defined(&TDQPI_HiPrTxProducerIndex_get);
    eval 'sub TDQPI_LoPrTxProducerIndex_get {
        my($x) = @_;
	    eval q(((($x) >> 0) & 0x7ff));
    }' unless defined(&TDQPI_LoPrTxProducerIndex_get);
    eval 'sub SF_TxDescQueueConsumerIndex () {0xa4;}' unless defined(&SF_TxDescQueueConsumerIndex);
    eval 'sub TDQCI_HiPrTxConsumerIndex {
        my($x) = @_;
	    eval q(((($x) >> 16) & 0x7ff));
    }' unless defined(&TDQCI_HiPrTxConsumerIndex);
    eval 'sub TDQCI_LoPrTxConsumerIndex {
        my($s) = @_;
	    eval q(((( &x) >> 0) & 0x7ff));
    }' unless defined(&TDQCI_LoPrTxConsumerIndex);
    eval 'sub SF_TxDmaStatus1 () {0xa8;}' unless defined(&SF_TxDmaStatus1);
    eval 'sub SF_TxDmaStatus2 () {0xac;}' unless defined(&SF_TxDmaStatus2);
    eval 'sub SF_TransmitFrameCSR () {0xb0;}' unless defined(&SF_TransmitFrameCSR);
    eval 'sub TFCSR_TxFrameStatus () {(0xff << 16);}' unless defined(&TFCSR_TxFrameStatus);
    eval 'sub TFCSR_TxDebugConfigBits () {(0x7f << 9);}' unless defined(&TFCSR_TxDebugConfigBits);
    eval 'sub TFCSR_DmaCompletionAfterTransmitComplete () {(1 << 8);}' unless defined(&TFCSR_DmaCompletionAfterTransmitComplete);
    eval 'sub TFCSR_TransmitThreshold {
        my($x) = @_;
	    eval q((($x) << 0));
    }' unless defined(&TFCSR_TransmitThreshold);
    eval 'sub SF_CompletionQueueHighAddr () {0xb4;}' unless defined(&SF_CompletionQueueHighAddr);
    eval 'sub SF_TxCompletionQueueCtrl () {0xb8;}' unless defined(&SF_TxCompletionQueueCtrl);
    eval 'sub TCQC_TxCompletionBaseAddress () {0xffffff00;}' unless defined(&TCQC_TxCompletionBaseAddress);
    eval 'sub TCQC_TxCompletion64bitAddress () {(1 << 7);}' unless defined(&TCQC_TxCompletion64bitAddress);
    eval 'sub TCQC_TxCompletionProducerWe () {(1 << 6);}' unless defined(&TCQC_TxCompletionProducerWe);
    eval 'sub TCQC_TxCompletionSize () {(1 << 5);}' unless defined(&TCQC_TxCompletionSize);
    eval 'sub TCQC_CommonQueueMode () {(1 << 4);}' unless defined(&TCQC_CommonQueueMode);
    eval 'sub TCQC_TxCompletionQueueThreshold () {(( &x) << 0);}' unless defined(&TCQC_TxCompletionQueueThreshold);
    eval 'sub SF_RxCompletionQueue1Ctrl () {0xbc;}' unless defined(&SF_RxCompletionQueue1Ctrl);
    eval 'sub RCQ1C_RxCompletionQ1BaseAddress () {0xffffff00;}' unless defined(&RCQ1C_RxCompletionQ1BaseAddress);
    eval 'sub RCQ1C_RxCompletionQ164bitAddress () {(1 << 7);}' unless defined(&RCQ1C_RxCompletionQ164bitAddress);
    eval 'sub RCQ1C_RxCompletionQ1ProducerWe () {(1 << 6);}' unless defined(&RCQ1C_RxCompletionQ1ProducerWe);
    eval 'sub RCQ1C_RxCompletionQ1Type {
        my($x) = @_;
	    eval q((($x) << 4));
    }' unless defined(&RCQ1C_RxCompletionQ1Type);
    eval 'sub RCQ1C_RxCompletionQ1Threshold {
        my($x) = @_;
	    eval q((($x) << 0));
    }' unless defined(&RCQ1C_RxCompletionQ1Threshold);
    eval 'sub SF_RxCompletionQueue2Ctrl () {0xc0;}' unless defined(&SF_RxCompletionQueue2Ctrl);
    eval 'sub RCQ1C_RxCompletionQ2BaseAddress () {0xffffff00;}' unless defined(&RCQ1C_RxCompletionQ2BaseAddress);
    eval 'sub RCQ1C_RxCompletionQ264bitAddress () {(1 << 7);}' unless defined(&RCQ1C_RxCompletionQ264bitAddress);
    eval 'sub RCQ1C_RxCompletionQ2ProducerWe () {(1 << 6);}' unless defined(&RCQ1C_RxCompletionQ2ProducerWe);
    eval 'sub RCQ1C_RxCompletionQ2Type {
        my($x) = @_;
	    eval q((($x) << 4));
    }' unless defined(&RCQ1C_RxCompletionQ2Type);
    eval 'sub RCQ1C_RxCompletionQ2Threshold {
        my($x) = @_;
	    eval q((($x) << 0));
    }' unless defined(&RCQ1C_RxCompletionQ2Threshold);
    eval 'sub SF_CompletionQueueConsumerIndex () {0xc4;}' unless defined(&SF_CompletionQueueConsumerIndex);
    eval 'sub CQCI_TxCompletionThresholdMode () {(1 << 31);}' unless defined(&CQCI_TxCompletionThresholdMode);
    eval 'sub CQCI_TxCompletionConsumerIndex {
        my($x) = @_;
	    eval q((($x) << 16));
    }' unless defined(&CQCI_TxCompletionConsumerIndex);
    eval 'sub CQCI_TxCompletionConsumerIndex_get {
        my($x) = @_;
	    eval q(((($x) >> 16) & 0x7ff));
    }' unless defined(&CQCI_TxCompletionConsumerIndex_get);
    eval 'sub CQCI_RxCompletionQ1ThresholdMode () {(1 << 15);}' unless defined(&CQCI_RxCompletionQ1ThresholdMode);
    eval 'sub CQCI_RxCompletionQ1ConsumerIndex {
        my($x) = @_;
	    eval q((($x) << 0));
    }' unless defined(&CQCI_RxCompletionQ1ConsumerIndex);
    eval 'sub CQCI_RxCompletionQ1ConsumerIndex_get {
        my($x) = @_;
	    eval q((($x) & 0x7ff));
    }' unless defined(&CQCI_RxCompletionQ1ConsumerIndex_get);
    eval 'sub SF_CompletionQueueProducerIndex () {0xc8;}' unless defined(&SF_CompletionQueueProducerIndex);
    eval 'sub CQPI_TxCompletionProducerIndex {
        my($x) = @_;
	    eval q((($x) << 16));
    }' unless defined(&CQPI_TxCompletionProducerIndex);
    eval 'sub CQPI_TxCompletionProducerIndex_get {
        my($x) = @_;
	    eval q(((($x) >> 16) & 0x7ff));
    }' unless defined(&CQPI_TxCompletionProducerIndex_get);
    eval 'sub CQPI_RxCompletionQ1ProducerIndex {
        my($x) = @_;
	    eval q((($x) << 0));
    }' unless defined(&CQPI_RxCompletionQ1ProducerIndex);
    eval 'sub CQPI_RxCompletionQ1ProducerIndex_get {
        my($x) = @_;
	    eval q((($x) & 0x7ff));
    }' unless defined(&CQPI_RxCompletionQ1ProducerIndex_get);
    eval 'sub SF_RxHiPrCompletionPtrs () {0xcc;}' unless defined(&SF_RxHiPrCompletionPtrs);
    eval 'sub RHPCP_RxCompletionQ2ProducerIndex {
        my($x) = @_;
	    eval q((($x) << 16));
    }' unless defined(&RHPCP_RxCompletionQ2ProducerIndex);
    eval 'sub RHPCP_RxCompletionQ2ThresholdMode () {(1 << 15);}' unless defined(&RHPCP_RxCompletionQ2ThresholdMode);
    eval 'sub RHPCP_RxCompletionQ2ConsumerIndex {
        my($x) = @_;
	    eval q((($x) << 0));
    }' unless defined(&RHPCP_RxCompletionQ2ConsumerIndex);
    eval 'sub SF_RxDmaCtrl () {0xd0;}' unless defined(&SF_RxDmaCtrl);
    eval 'sub RDC_RxReportBadFrames () {(1 << 31);}' unless defined(&RDC_RxReportBadFrames);
    eval 'sub RDC_RxDmaShortFrames () {(1 << 30);}' unless defined(&RDC_RxDmaShortFrames);
    eval 'sub RDC_RxDmaBadFrames () {(1 << 29);}' unless defined(&RDC_RxDmaBadFrames);
    eval 'sub RDC_RxDmaCrcErrorFrames () {(1 << 28);}' unless defined(&RDC_RxDmaCrcErrorFrames);
    eval 'sub RDC_RxDmaControlFrame () {(1 << 27);}' unless defined(&RDC_RxDmaControlFrame);
    eval 'sub RDC_RxDmaPauseFrame () {(1 << 26);}' unless defined(&RDC_RxDmaPauseFrame);
    eval 'sub RDC_RxChecksumMode {
        my($x) = @_;
	    eval q((($x) << 24));
    }' unless defined(&RDC_RxChecksumMode);
    eval 'sub RDC_RxCompletionQ2Enable () {(1 << 23);}' unless defined(&RDC_RxCompletionQ2Enable);
    eval 'sub RDC_RxDmaQueueMode {
        my($x) = @_;
	    eval q((($x) << 20));
    }' unless defined(&RDC_RxDmaQueueMode);
    eval 'sub RDC_RxUseBackupQueue () {(1 << 19);}' unless defined(&RDC_RxUseBackupQueue);
    eval 'sub RDC_RxDmaCrc () {(1 << 18);}' unless defined(&RDC_RxDmaCrc);
    eval 'sub RDC_RxEarlyIntThreshold {
        my($x) = @_;
	    eval q((($x) << 12));
    }' unless defined(&RDC_RxEarlyIntThreshold);
    eval 'sub RDC_RxHighPriorityThreshold {
        my($x) = @_;
	    eval q((($x) << 8));
    }' unless defined(&RDC_RxHighPriorityThreshold);
    eval 'sub RDC_RxBurstSize {
        my($x) = @_;
	    eval q((($x) << 0));
    }' unless defined(&RDC_RxBurstSize);
    eval 'sub SF_RxDescQueue1Ctrl () {0xd4;}' unless defined(&SF_RxDescQueue1Ctrl);
    eval 'sub RDQ1C_RxQ1BufferLength {
        my($x) = @_;
	    eval q((($x) << 16));
    }' unless defined(&RDQ1C_RxQ1BufferLength);
    eval 'sub RDQ1C_RxPrefetchDescriptorsMode () {(1 << 15);}' unless defined(&RDQ1C_RxPrefetchDescriptorsMode);
    eval 'sub RDQ1C_RxDescQ1Entries () {(1 << 14);}' unless defined(&RDQ1C_RxDescQ1Entries);
    eval 'sub RDQ1C_RxVariableSizeQueues () {(1 << 13);}' unless defined(&RDQ1C_RxVariableSizeQueues);
    eval 'sub RDQ1C_Rx64bitBufferAddresses () {(1 << 12);}' unless defined(&RDQ1C_Rx64bitBufferAddresses);
    eval 'sub RDQ1C_Rx64bitDescQueueAddress () {(1 << 11);}' unless defined(&RDQ1C_Rx64bitDescQueueAddress);
    eval 'sub RDQ1C_RxDescSpacing {
        my($x) = @_;
	    eval q((($x) << 8));
    }' unless defined(&RDQ1C_RxDescSpacing);
    eval 'sub RDQ1C_RxQ1ConsumerWe () {(1 << 7);}' unless defined(&RDQ1C_RxQ1ConsumerWe);
    eval 'sub RDQ1C_RxQ1MinDescriptorsThreshold {
        my($x) = @_;
	    eval q((($x) << 0));
    }' unless defined(&RDQ1C_RxQ1MinDescriptorsThreshold);
    eval 'sub SF_RxDescQueue2Ctrl () {0xd8;}' unless defined(&SF_RxDescQueue2Ctrl);
    eval 'sub RDQ2C_RxQ2BufferLength {
        my($x) = @_;
	    eval q((($x) << 16));
    }' unless defined(&RDQ2C_RxQ2BufferLength);
    eval 'sub RDQ2C_RxDescQ2Entries () {(1 << 14);}' unless defined(&RDQ2C_RxDescQ2Entries);
    eval 'sub RDQ2C_RxQ2MinDescriptorsThreshold {
        my($x) = @_;
	    eval q((($x) << 0));
    }' unless defined(&RDQ2C_RxQ2MinDescriptorsThreshold);
    eval 'sub SF_RxDescQueueHighAddress () {0xdc;}' unless defined(&SF_RxDescQueueHighAddress);
    eval 'sub SF_RxDescQueue1LowAddress () {0xe0;}' unless defined(&SF_RxDescQueue1LowAddress);
    eval 'sub SF_RxDescQueue2LowAddress () {0xe4;}' unless defined(&SF_RxDescQueue2LowAddress);
    eval 'sub SF_RxDescQueue1Ptrs () {0xe8;}' unless defined(&SF_RxDescQueue1Ptrs);
    eval 'sub RXQ1P_RxDescQ1Consumer {
        my($x) = @_;
	    eval q((($x) << 16));
    }' unless defined(&RXQ1P_RxDescQ1Consumer);
    eval 'sub RXQ1P_RxDescQ1Producer {
        my($x) = @_;
	    eval q((($x) << 0));
    }' unless defined(&RXQ1P_RxDescQ1Producer);
    eval 'sub RXQ1P_RxDescQ1Producer_get {
        my($x) = @_;
	    eval q((($x) & 0x7ff));
    }' unless defined(&RXQ1P_RxDescQ1Producer_get);
    eval 'sub SF_RxDescQueue2Ptrs () {0xec;}' unless defined(&SF_RxDescQueue2Ptrs);
    eval 'sub RXQ2P_RxDescQ2Consumer {
        my($x) = @_;
	    eval q((($x) << 16));
    }' unless defined(&RXQ2P_RxDescQ2Consumer);
    eval 'sub RXQ2P_RxDescQ2Producer {
        my($x) = @_;
	    eval q((($x) << 0));
    }' unless defined(&RXQ2P_RxDescQ2Producer);
    eval 'sub SF_RxDmaStatus () {0xf0;}' unless defined(&SF_RxDmaStatus);
    eval 'sub RDS_RxFramesLostCount {
        my($x) = @_;
	    eval q((($x) & 0xffff));
    }' unless defined(&RDS_RxFramesLostCount);
    eval 'sub SF_RxAddressFilteringCtl () {0xf4;}' unless defined(&SF_RxAddressFilteringCtl);
    eval 'sub RAFC_PerfectAddressPriority {
        my($x) = @_;
	    eval q((1 << (($x) + 16)));
    }' unless defined(&RAFC_PerfectAddressPriority);
    eval 'sub RAFC_MinVlanPriority {
        my($x) = @_;
	    eval q((($x) << 13));
    }' unless defined(&RAFC_MinVlanPriority);
    eval 'sub RAFC_PassMulticastExceptBroadcast () {(1 << 12);}' unless defined(&RAFC_PassMulticastExceptBroadcast);
    eval 'sub RAFC_WakeupMode {
        my($x) = @_;
	    eval q((($x) << 10));
    }' unless defined(&RAFC_WakeupMode);
    eval 'sub RAFC_VlanMode {
        my($x) = @_;
	    eval q((($x) << 8));
    }' unless defined(&RAFC_VlanMode);
    eval 'sub RAFC_PerfectFilteringMode {
        my($x) = @_;
	    eval q((($x) << 6));
    }' unless defined(&RAFC_PerfectFilteringMode);
    eval 'sub RAFC_HashFilteringMode {
        my($x) = @_;
	    eval q((($x) << 4));
    }' unless defined(&RAFC_HashFilteringMode);
    eval 'sub RAFC_HashPriorityEnable () {(1 << 3);}' unless defined(&RAFC_HashPriorityEnable);
    eval 'sub RAFC_PassBroadcast () {(1 << 2);}' unless defined(&RAFC_PassBroadcast);
    eval 'sub RAFC_PassMulticast () {(1 << 1);}' unless defined(&RAFC_PassMulticast);
    eval 'sub RAFC_PromiscuousMode () {(1 << 0);}' unless defined(&RAFC_PromiscuousMode);
    eval 'sub SF_RxFrameTestOut () {0xf8;}' unless defined(&SF_RxFrameTestOut);
    eval 'sub SF_PciTargetStatus () {0x100;}' unless defined(&SF_PciTargetStatus);
    eval 'sub SF_PciMasterStatus1 () {0x104;}' unless defined(&SF_PciMasterStatus1);
    eval 'sub SF_PciMasterStatus2 () {0x108;}' unless defined(&SF_PciMasterStatus2);
    eval 'sub SF_PciDmaLowHostAddr () {0x10c;}' unless defined(&SF_PciDmaLowHostAddr);
    eval 'sub SF_BacDmaDiagnostic0 () {0x110;}' unless defined(&SF_BacDmaDiagnostic0);
    eval 'sub SF_BacDmaDiagnostic1 () {0x114;}' unless defined(&SF_BacDmaDiagnostic1);
    eval 'sub SF_BacDmaDiagnostic2 () {0x118;}' unless defined(&SF_BacDmaDiagnostic2);
    eval 'sub SF_BacDmaDiagnostic3 () {0x11c;}' unless defined(&SF_BacDmaDiagnostic3);
    eval 'sub SF_MacAddr1 () {0x120;}' unless defined(&SF_MacAddr1);
    eval 'sub SF_MacAddr2 () {0x124;}' unless defined(&SF_MacAddr2);
    eval 'sub SF_FunctionEvent () {0x130;}' unless defined(&SF_FunctionEvent);
    eval 'sub SF_FunctionEventMask () {0x134;}' unless defined(&SF_FunctionEventMask);
    eval 'sub SF_FunctionPresentState () {0x138;}' unless defined(&SF_FunctionPresentState);
    eval 'sub SF_ForceFunction () {0x13c;}' unless defined(&SF_ForceFunction);
    eval 'sub SF_EEPROM_BASE () {0x1000;}' unless defined(&SF_EEPROM_BASE);
    eval 'sub SF_MII_BASE () {0x2000;}' unless defined(&SF_MII_BASE);
    eval 'sub MiiDataValid () {(1 << 31);}' unless defined(&MiiDataValid);
    eval 'sub MiiBusy () {(1 << 30);}' unless defined(&MiiBusy);
    eval 'sub MiiRegDataPort {
        my($x) = @_;
	    eval q((($x) & 0xffff));
    }' unless defined(&MiiRegDataPort);
    eval 'sub SF_MII_PHY_REG {
        my($p, $r) = @_;
	    eval q(( &SF_MII_BASE + (($p) * 32* $sizeof{ &uint32_t}) + (($r) * $sizeof{ &uint32_t})));
    }' unless defined(&SF_MII_PHY_REG);
    eval 'sub SF_TestMode () {0x4000;}' unless defined(&SF_TestMode);
    eval 'sub SF_RxFrameProcessorCtrl () {0x4004;}' unless defined(&SF_RxFrameProcessorCtrl);
    eval 'sub SF_TxFrameProcessorCtrl () {0x4008;}' unless defined(&SF_TxFrameProcessorCtrl);
    eval 'sub SF_MacConfig1 () {0x5000;}' unless defined(&SF_MacConfig1);
    eval 'sub MC1_SoftRst () {(1 << 15);}' unless defined(&MC1_SoftRst);
    eval 'sub MC1_MiiLoopBack () {(1 << 14);}' unless defined(&MC1_MiiLoopBack);
    eval 'sub MC1_TestMode {
        my($x) = @_;
	    eval q((($x) << 12));
    }' unless defined(&MC1_TestMode);
    eval 'sub MC1_TxFlowEn () {(1 << 11);}' unless defined(&MC1_TxFlowEn);
    eval 'sub MC1_RxFlowEn () {(1 << 10);}' unless defined(&MC1_RxFlowEn);
    eval 'sub MC1_PreambleDetectCount () {(1 << 9);}' unless defined(&MC1_PreambleDetectCount);
    eval 'sub MC1_PassAllRxPackets () {(1 << 8);}' unless defined(&MC1_PassAllRxPackets);
    eval 'sub MC1_PurePreamble () {(1 << 7);}' unless defined(&MC1_PurePreamble);
    eval 'sub MC1_LengthCheck () {(1 << 6);}' unless defined(&MC1_LengthCheck);
    eval 'sub MC1_NoBackoff () {(1 << 5);}' unless defined(&MC1_NoBackoff);
    eval 'sub MC1_DelayCRC () {(1 << 4);}' unless defined(&MC1_DelayCRC);
    eval 'sub MC1_TxHalfDuplexJam () {(1 << 3);}' unless defined(&MC1_TxHalfDuplexJam);
    eval 'sub MC1_PadEn () {(1 << 2);}' unless defined(&MC1_PadEn);
    eval 'sub MC1_FullDuplex () {(1 << 1);}' unless defined(&MC1_FullDuplex);
    eval 'sub MC1_HugeFrame () {(1 << 0);}' unless defined(&MC1_HugeFrame);
    eval 'sub SF_MacConfig2 () {0x5004;}' unless defined(&SF_MacConfig2);
    eval 'sub MC2_TxCRCerr () {(1 << 15);}' unless defined(&MC2_TxCRCerr);
    eval 'sub MC2_TxIslCRCerr () {(1 << 14);}' unless defined(&MC2_TxIslCRCerr);
    eval 'sub MC2_RxCRCerr () {(1 << 13);}' unless defined(&MC2_RxCRCerr);
    eval 'sub MC2_RxIslCRCerr () {(1 << 12);}' unless defined(&MC2_RxIslCRCerr);
    eval 'sub MC2_TXCF () {(1 << 11);}' unless defined(&MC2_TXCF);
    eval 'sub MC2_CtlSoftRst () {(1 << 10);}' unless defined(&MC2_CtlSoftRst);
    eval 'sub MC2_RxSoftRst () {(1 << 9);}' unless defined(&MC2_RxSoftRst);
    eval 'sub MC2_TxSoftRst () {(1 << 8);}' unless defined(&MC2_TxSoftRst);
    eval 'sub MC2_RxISLEn () {(1 << 7);}' unless defined(&MC2_RxISLEn);
    eval 'sub MC2_BackPressureNoBackOff () {(1 << 6);}' unless defined(&MC2_BackPressureNoBackOff);
    eval 'sub MC2_AutoVlanPad () {(1 << 5);}' unless defined(&MC2_AutoVlanPad);
    eval 'sub MC2_MandatoryVLANPad () {(1 << 4);}' unless defined(&MC2_MandatoryVLANPad);
    eval 'sub MC2_TxISLAppen () {(1 << 3);}' unless defined(&MC2_TxISLAppen);
    eval 'sub MC2_TxISLEn () {(1 << 2);}' unless defined(&MC2_TxISLEn);
    eval 'sub MC2_SimuRst () {(1 << 1);}' unless defined(&MC2_SimuRst);
    eval 'sub MC2_TxXmtEn () {(1 << 0);}' unless defined(&MC2_TxXmtEn);
    eval 'sub SF_BkToBkIPG () {0x5008;}' unless defined(&SF_BkToBkIPG);
    eval 'sub SF_NonBkToBkIPG () {0x500c;}' unless defined(&SF_NonBkToBkIPG);
    eval 'sub SF_ColRetry () {0x5010;}' unless defined(&SF_ColRetry);
    eval 'sub SF_MaxLength () {0x5014;}' unless defined(&SF_MaxLength);
    eval 'sub SF_TxNibbleCnt () {0x5018;}' unless defined(&SF_TxNibbleCnt);
    eval 'sub SF_TxByteCnt () {0x501c;}' unless defined(&SF_TxByteCnt);
    eval 'sub SF_ReTxCnt () {0x5020;}' unless defined(&SF_ReTxCnt);
    eval 'sub SF_RandomNumGen () {0x5024;}' unless defined(&SF_RandomNumGen);
    eval 'sub SF_MskRandomNum () {0x5028;}' unless defined(&SF_MskRandomNum);
    eval 'sub SF_TotalTxCnt () {0x5034;}' unless defined(&SF_TotalTxCnt);
    eval 'sub SF_RxByteCnt () {0x5040;}' unless defined(&SF_RxByteCnt);
    eval 'sub SF_TxPauseTimer () {0x5060;}' unless defined(&SF_TxPauseTimer);
    eval 'sub SF_VLANType () {0x5064;}' unless defined(&SF_VLANType);
    eval 'sub SF_MiiStatus () {0x5070;}' unless defined(&SF_MiiStatus);
    eval 'sub SF_PERFECT_BASE () {0x6000;}' unless defined(&SF_PERFECT_BASE);
    eval 'sub SF_PERFECT_SIZE () {0x100;}' unless defined(&SF_PERFECT_SIZE);
    eval 'sub SF_HASH_BASE () {0x6100;}' unless defined(&SF_HASH_BASE);
    eval 'sub SF_HASH_SIZE () {0x200;}' unless defined(&SF_HASH_SIZE);
    eval 'sub SF_STATS_BASE () {0x7000;}' unless defined(&SF_STATS_BASE);
    eval 'sub SF_TxGfpMem () {0x8000;}' unless defined(&SF_TxGfpMem);
    eval 'sub SF_RxGfpMem () {0xa000;}' unless defined(&SF_RxGfpMem);
    eval 'sub SF_NTXDESC () {256;}' unless defined(&SF_NTXDESC);
    eval 'sub SF_NTXDESC_MASK () {( &SF_NTXDESC - 1);}' unless defined(&SF_NTXDESC_MASK);
    eval 'sub SF_NEXTTX {
        my($x) = @_;
	    eval q((($x + 1) &  &SF_NTXDESC_MASK));
    }' unless defined(&SF_NEXTTX);
    eval 'sub SF_NTCD () {1024;}' unless defined(&SF_NTCD);
    eval 'sub SF_NTCD_MASK () {( &SF_NTCD - 1);}' unless defined(&SF_NTCD_MASK);
    eval 'sub SF_NEXTTCD {
        my($x) = @_;
	    eval q((($x + 1) &  &SF_NTCD_MASK));
    }' unless defined(&SF_NEXTTCD);
    eval 'sub SF_NRXDESC () {256;}' unless defined(&SF_NRXDESC);
    eval 'sub SF_NRXDESC_MASK () {( &SF_NRXDESC - 1);}' unless defined(&SF_NRXDESC_MASK);
    eval 'sub SF_NEXTRX {
        my($x) = @_;
	    eval q((($x + 1) &  &SF_NRXDESC_MASK));
    }' unless defined(&SF_NEXTRX);
    eval 'sub SF_NRCD () {1024;}' unless defined(&SF_NRCD);
    eval 'sub SF_NRCD_MASK () {( &SF_NRCD - 1);}' unless defined(&SF_NRCD_MASK);
    eval 'sub SF_NEXTRCD {
        my($x) = @_;
	    eval q((($x + 1) &  &SF_NRCD_MASK));
    }' unless defined(&SF_NEXTRCD);
    eval 'sub SF_CDOFF {
        my($x) = @_;
	    eval q( &offsetof(\'struct sf_control_data\', $x));
    }' unless defined(&SF_CDOFF);
    eval 'sub SF_CDTXDOFF {
        my($x) = @_;
	    eval q( &SF_CDOFF( $scd_txdescs[($x)]));
    }' unless defined(&SF_CDTXDOFF);
    eval 'sub SF_CDTXCOFF {
        my($x) = @_;
	    eval q( &SF_CDOFF( $scd_txcomp[($x)]));
    }' unless defined(&SF_CDTXCOFF);
    eval 'sub SF_CDRXDOFF {
        my($x) = @_;
	    eval q( &SF_CDOFF( $scd_rxbufdescs[($x)]));
    }' unless defined(&SF_CDRXDOFF);
    eval 'sub SF_CDRXCOFF {
        my($x) = @_;
	    eval q( &SF_CDOFF( $scd_rxcomp[($x)]));
    }' unless defined(&SF_CDRXCOFF);
    eval 'sub sc_cddma () { ($sc_cddmamap->{dm_segs[0]}->{ds_addr});}' unless defined(&sc_cddma);
    eval 'sub sc_txdescs () { ($sc_control_data->{scd_txdescs});}' unless defined(&sc_txdescs);
    eval 'sub sc_txcomp () { ($sc_control_data->{scd_txcomp});}' unless defined(&sc_txcomp);
    eval 'sub sc_rxbufdescs () { ($sc_control_data->{scd_rxbufdescs});}' unless defined(&sc_rxbufdescs);
    eval 'sub sc_rxcomp () { ($sc_control_data->{scd_rxcomp});}' unless defined(&sc_rxcomp);
    eval 'sub SF_CDTXDADDR {
        my($sc, $x) = @_;
	    eval q((($sc)-> &sc_cddma +  &SF_CDTXDOFF(($x))));
    }' unless defined(&SF_CDTXDADDR);
    eval 'sub SF_CDTXCADDR {
        my($sc, $x) = @_;
	    eval q((($sc)-> &sc_cddma +  &SF_CDTXCOFF(($x))));
    }' unless defined(&SF_CDTXCADDR);
    eval 'sub SF_CDRXDADDR {
        my($sc, $x) = @_;
	    eval q((($sc)-> &sc_cddma +  &SF_CDRXDOFF(($x))));
    }' unless defined(&SF_CDRXDADDR);
    eval 'sub SF_CDRXCADDR {
        my($sc, $x) = @_;
	    eval q((($sc)-> &sc_cddma +  &SF_CDRXCOFF(($x))));
    }' unless defined(&SF_CDRXCADDR);
    eval 'sub SF_CDTXDSYNC {
        my($sc, $x, $ops) = @_;
	    eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($sc)-> &sc_cddmamap,  &SF_CDTXDOFF(($x)), $sizeof{\'struct sf_txdesc0\'}, ($ops)));
    }' unless defined(&SF_CDTXDSYNC);
    eval 'sub SF_CDTXCSYNC {
        my($sc, $x, $ops) = @_;
	    eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($sc)-> &sc_cddmamap,  &SF_CDTXCOFF(($x)), $sizeof{\'struct sf_tcd\'}, ($ops)));
    }' unless defined(&SF_CDTXCSYNC);
    eval 'sub SF_CDRXDSYNC {
        my($sc, $x, $ops) = @_;
	    eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($sc)-> &sc_cddmamap,  &SF_CDRXDOFF(($x)), $sizeof{\'struct sf_rbd32\'}, ($ops)));
    }' unless defined(&SF_CDRXDSYNC);
    eval 'sub SF_CDRXCSYNC {
        my($sc, $x, $ops) = @_;
	    eval q( &bus_dmamap_sync(($sc)-> &sc_dmat, ($sc)-> &sc_cddmamap,  &SF_CDRXCOFF(($x)), $sizeof{\'struct sf_rcd_full\'}, ($ops)));
    }' unless defined(&SF_CDRXCSYNC);
    eval 'sub SF_INIT_RXDESC {
        my($sc, $x) = @_;
	    eval q( &do { \'struct sf_descsoft\' * &__ds =  ($sc->{sc_rxsoft[&(x)]}); ($sc)-> ($sc_rxbufdescs[&(x)]->{rbd32_addr}) =  ($__ds->{ds_dmamap}->{dm_segs[0]}->{ds_addr}) |  &RBD_V;  &SF_CDRXDSYNC(($sc), ($x),  &BUS_DMASYNC_PREWRITE); }  &while ( 0));
    }' unless defined(&SF_INIT_RXDESC);
    if(defined(&_KERNEL)) {
    }
}
1;
