require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ALPHA_PTE_H_)) {
    eval 'sub _ALPHA_PTE_H_ () {1;}' unless defined(&_ALPHA_PTE_H_);
    require 'machine/alpha_cpu.ph';
    eval 'sub PT_ENTRY_NULL () {(( &pt_entry_t *) 0);}' unless defined(&PT_ENTRY_NULL);
    eval 'sub PTESHIFT () {3;}' unless defined(&PTESHIFT);
    eval 'sub PG_V () { &ALPHA_PTE_VALID;}' unless defined(&PG_V);
    eval 'sub PG_NV () {0;}' unless defined(&PG_NV);
    eval 'sub PG_FOR () { &ALPHA_PTE_FAULT_ON_READ;}' unless defined(&PG_FOR);
    eval 'sub PG_FOW () { &ALPHA_PTE_FAULT_ON_WRITE;}' unless defined(&PG_FOW);
    eval 'sub PG_FOE () { &ALPHA_PTE_FAULT_ON_EXECUTE;}' unless defined(&PG_FOE);
    eval 'sub PG_ASM () { &ALPHA_PTE_ASM;}' unless defined(&PG_ASM);
    eval 'sub PG_GH () { &ALPHA_PTE_GRANULARITY;}' unless defined(&PG_GH);
    eval 'sub PG_KRE () { &ALPHA_PTE_KR;}' unless defined(&PG_KRE);
    eval 'sub PG_URE () { &ALPHA_PTE_UR;}' unless defined(&PG_URE);
    eval 'sub PG_KWE () { &ALPHA_PTE_KW;}' unless defined(&PG_KWE);
    eval 'sub PG_UWE () { &ALPHA_PTE_UW;}' unless defined(&PG_UWE);
    eval 'sub PG_PROT () { &ALPHA_PTE_PROT;}' unless defined(&PG_PROT);
    eval 'sub PG_RSVD () {0xcc80;}' unless defined(&PG_RSVD);
    eval 'sub PG_WIRED () {0x10000;}' unless defined(&PG_WIRED);
    eval 'sub PG_PVLIST () {0x20000;}' unless defined(&PG_PVLIST);
    eval 'sub PG_EXEC () {0x40000;}' unless defined(&PG_EXEC);
    eval 'sub PG_FRAME () { &ALPHA_PTE_RAME;}' unless defined(&PG_FRAME);
    eval 'sub PG_SHIFT () {32;}' unless defined(&PG_SHIFT);
    eval 'sub PG_PFNUM {
        my($x) = @_;
	    eval q( &ALPHA_PTE_TO_PFN($x));
    }' unless defined(&PG_PFNUM);
    eval 'sub PG_PALCODE {
        my($x) = @_;
	    eval q((($x) &  &ALPHA_PTE_PALCODE));
    }' unless defined(&PG_PALCODE);
    if(defined( &_KERNEL) || defined( &__KVM_ALPHA_PRIVATE)) {
	eval 'sub NPTEPG_SHIFT () {( &PAGE_SHIFT -  &PTESHIFT);}' unless defined(&NPTEPG_SHIFT);
	eval 'sub NPTEPG () {(1 <<  &NPTEPG_SHIFT);}' unless defined(&NPTEPG);
	eval 'sub PTEMASK () {( &NPTEPG - 1);}' unless defined(&PTEMASK);
	eval 'sub l3pte_index {
	    my($va) = @_;
    	    eval q(((( &vaddr_t)($va) >>  &PAGE_SHIFT) &  &PTEMASK));
	}' unless defined(&l3pte_index);
	eval 'sub l2pte_index {
	    my($va) = @_;
    	    eval q(((( &vaddr_t)($va) >> ( &PAGE_SHIFT +  &NPTEPG_SHIFT)) &  &PTEMASK));
	}' unless defined(&l2pte_index);
	eval 'sub l1pte_index {
	    my($va) = @_;
    	    eval q(((( &vaddr_t)($va) >> ( &PAGE_SHIFT + 2*  &NPTEPG_SHIFT)) &  &PTEMASK));
	}' unless defined(&l1pte_index);
	eval 'sub VPT_INDEX {
	    my($va) = @_;
    	    eval q(((( &vaddr_t)($va) >>  &PAGE_SHIFT) & ((1<< 3*  &NPTEPG_SHIFT) - 1)));
	}' unless defined(&VPT_INDEX);
	eval 'sub ALPHA_L1SEG_SIZE () {(1 << ((2*  &NPTEPG_SHIFT) +  &PAGE_SHIFT));}' unless defined(&ALPHA_L1SEG_SIZE);
	eval 'sub ALPHA_L2SEG_SIZE () {(1 << ( &NPTEPG_SHIFT +  &PAGE_SHIFT));}' unless defined(&ALPHA_L2SEG_SIZE);
	eval 'sub alpha_trunc_l1seg {
	    my($x) = @_;
    	    eval q(((($x)) & ~( &ALPHA_L1SEG_SIZE-1)));
	}' unless defined(&alpha_trunc_l1seg);
	eval 'sub alpha_trunc_l2seg {
	    my($x) = @_;
    	    eval q(((($x)) & ~( &ALPHA_L2SEG_SIZE-1)));
	}' unless defined(&alpha_trunc_l2seg);
    }
    if(defined(&_KERNEL)) {
    }
}
1;
