require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MIPS_DB_MACHDEP_H_)) {
    eval 'sub _MIPS_DB_MACHDEP_H_ () {1;}' unless defined(&_MIPS_DB_MACHDEP_H_);
    require 'machine/frame.ph';
    require 'machine/trap.ph';
    require 'uvm/uvm_param.ph';
    eval 'sub DB_MACHINE_COMMANDS () {1;}' unless defined(&DB_MACHINE_COMMANDS);
    eval 'sub DB_ELF_SYMBOLS () {1;}' unless defined(&DB_ELF_SYMBOLS);
    eval 'sub SOFTWARE_SSTEP () {1;}' unless defined(&SOFTWARE_SSTEP);
    eval 'sub SOFTWARE_SSTEP_EMUL () {1;}' unless defined(&SOFTWARE_SSTEP_EMUL);
    eval 'sub BKPT_SIZE () {(4);}' unless defined(&BKPT_SIZE);
    eval 'sub BKPT_SET {
        my($ins) = @_;
	    eval q(( &BREAK_DDB));
    }' unless defined(&BKPT_SET);
    eval 'sub DB_VALID_BREAKPOINT {
        my($addr) = @_;
	    eval q(((($addr) & 3) == 0));
    }' unless defined(&DB_VALID_BREAKPOINT);
    eval 'sub IS_BREAKPOINT_TRAP {
        my($type, $code) = @_;
	    eval q((($type) ==  &T_BREAK));
    }' unless defined(&IS_BREAKPOINT_TRAP);
    eval 'sub IS_WATCHPOINT_TRAP {
        my($type, $code) = @_;
	    eval q((0));
    }' unless defined(&IS_WATCHPOINT_TRAP);
    eval 'sub PC_REGS {
        my($regs) = @_;
	    eval q((( &db_addr_t)($regs)-> &pc));
    }' unless defined(&PC_REGS);
    eval 'sub SET_PC_REGS {
        my($regs, $value) = @_;
	    eval q(($regs)-> &pc = ( &register_t)($value));
    }' unless defined(&SET_PC_REGS);
    eval 'sub DDB_REGS () {( &ddb_regs);}' unless defined(&DDB_REGS);
    eval 'sub IT_CALL () {0x1;}' unless defined(&IT_CALL);
    eval 'sub IT_BRANCH () {0x2;}' unless defined(&IT_BRANCH);
    eval 'sub IT_LOAD () {0x3;}' unless defined(&IT_LOAD);
    eval 'sub IT_STORE () {0x4;}' unless defined(&IT_STORE);
    eval 'sub inst_branch {
        my($i) = @_;
	    eval q(( &db_inst_type($i) ==  &IT_BRANCH));
    }' unless defined(&inst_branch);
    eval 'sub inst_trap_return {
        my($i) = @_;
	    eval q((($i) & 0));
    }' unless defined(&inst_trap_return);
    eval 'sub inst_call {
        my($i) = @_;
	    eval q(( &db_inst_type($i) ==  &IT_CALL));
    }' unless defined(&inst_call);
    eval 'sub inst_return {
        my($i) = @_;
	    eval q((($i) == 0x3e00008));
    }' unless defined(&inst_return);
    eval 'sub inst_load {
        my($i) = @_;
	    eval q(( &db_inst_type($i) ==  &IT_LOAD));
    }' unless defined(&inst_load);
    eval 'sub inst_store {
        my($i) = @_;
	    eval q(( &db_inst_type($i) ==  &IT_STORE));
    }' unless defined(&inst_store);
}
1;
