/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import javax.sound.sampled.AudioFormat;

public class AuTool {
    public static final int AU_HEADER_MAGIC = 779316836;
    public static final int AUDIO_UNKNOWN_SIZE = -1;
    public static final int DATA_OFFSET = 24;
    public static final int SND_FORMAT_UNSPECIFIED = 0;
    public static final int SND_FORMAT_MULAW_8 = 1;
    public static final int SND_FORMAT_LINEAR_8 = 2;
    public static final int SND_FORMAT_LINEAR_16 = 3;
    public static final int SND_FORMAT_LINEAR_24 = 4;
    public static final int SND_FORMAT_LINEAR_32 = 5;
    public static final int SND_FORMAT_FLOAT = 6;
    public static final int SND_FORMAT_DOUBLE = 7;
    public static final int SND_FORMAT_ADPCM_G721 = 23;
    public static final int SND_FORMAT_ADPCM_G722 = 24;
    public static final int SND_FORMAT_ADPCM_G723_3 = 25;
    public static final int SND_FORMAT_ADPCM_G723_5 = 26;
    public static final int SND_FORMAT_ALAW_8 = 27;

    public static int getFormatCode(AudioFormat audioFormat) {
        boolean bl;
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        int n = audioFormat.getSampleSizeInBits();
        boolean bl2 = audioFormat.isBigEndian();
        boolean bl3 = false;
        if (audioFormat.getFrameSize() == -1 || audioFormat.getChannels() != -1 || audioFormat.getFrameSize() == n / 8 * audioFormat.getChannels()) {
            bl3 = bl = true;
        }
        if (encoding.equals(AudioFormat.Encoding.ULAW) && n == 8 && bl) {
            return 1;
        }
        if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED) && bl) {
            if (n == 8) {
                return 2;
            }
            if (n == 16 && bl2) {
                return 3;
            }
            if (n == 24 && bl2) {
                return 4;
            }
            if (n == 32 && bl2) {
                return 5;
            }
        } else if (encoding.equals(AudioFormat.Encoding.ALAW) && n == 8 && bl) {
            return 27;
        }
        return 0;
    }
}

