/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GapContent
implements AbstractDocument.Content,
Serializable {
    private static final long serialVersionUID = -6226052713477823730L;
    static final int DEFAULT_BUFSIZE = 10;
    char[] buffer;
    int gapStart;
    int gapEnd;
    private ArrayList positions;
    private static final /* synthetic */ boolean assert;

    protected Object allocateArray(int n) {
        return new char[n];
    }

    protected int getArrayLength() {
        return this.buffer.length;
    }

    public int length() {
        return this.buffer.length - (this.gapEnd - this.gapStart);
    }

    public UndoableEdit insertString(int n, String string) throws BadLocationException {
        int n2 = this.length();
        int n3 = string.length();
        if (n < 0) {
            throw new BadLocationException("The where argument cannot be smaller than the zero", n);
        }
        if (n >= n2) {
            throw new BadLocationException("The where argument cannot be greater than the content length", n);
        }
        this.replace(n, 0, string.toCharArray(), n3);
        return new InsertUndo(n, n3);
    }

    public UndoableEdit remove(int n, int n2) throws BadLocationException {
        int n3 = this.length();
        if (n >= n3) {
            throw new BadLocationException("the where argument cannot be greater than the content length", n);
        }
        if (n + n2 > n3) {
            throw new BadLocationException("where + nitems cannot be greater than the content length", n + n2);
        }
        String string = this.getString(n, n2);
        this.replace(n, n2, null, 0);
        return new UndoRemove(n, string);
    }

    public String getString(int n, int n2) throws BadLocationException {
        Segment segment = new Segment();
        try {
            this.getChars(n, n2, segment);
            return new String(segment.array, segment.offset, segment.count);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            int n3 = 0;
            n3 = segment.offset < 0 || segment.offset >= segment.array.length ? segment.offset : segment.offset + segment.count;
            throw new BadLocationException("Illegal location: array.length = " + segment.array.length + ", offset = " + segment.offset + ", count = " + segment.count, n3);
        }
    }

    public void getChars(int n, int n2, Segment segment) throws BadLocationException {
        int n3 = this.length();
        if (n >= n3) {
            throw new BadLocationException("the where argument cannot be greater than the content length", n);
        }
        if (n + n2 > n3) {
            throw new BadLocationException("len plus where cannot be greater than the content length", n2 + n);
        }
        if (n < this.gapStart && this.gapStart - n < n2) {
            char[] cArray = new char[n2];
            int n4 = this.gapStart - n;
            System.arraycopy(this.buffer, n, cArray, 0, n4);
            System.arraycopy(this.buffer, this.gapEnd, cArray, n4, n2 - n4);
            segment.array = cArray;
            segment.offset = 0;
            segment.count = n2;
        } else {
            segment.array = this.buffer;
            segment.offset = n < this.gapStart ? n : n + (this.gapEnd - this.gapStart);
            segment.count = n2;
        }
    }

    public Position createPosition(int n) throws BadLocationException {
        GapContentPosition gapContentPosition;
        WeakReference weakReference;
        int n2;
        if (n < 0 || n > this.length()) {
            throw new BadLocationException("The offset was out of the bounds of this buffer", n);
        }
        this.clearPositionReferences();
        int n3 = n;
        if (n >= this.gapStart) {
            n3 += this.gapEnd - this.gapStart;
        }
        if ((n2 = Collections.binarySearch(this.positions, weakReference = new WeakReference(gapContentPosition = new GapContentPosition(n3)), new WeakPositionComparator())) < 0) {
            n2 = -(n2 + 1);
        }
        this.positions.add(n2, weakReference);
        return gapContentPosition;
    }

    protected void shiftEnd(int n) {
        if (!assert && n <= this.gapEnd - this.gapStart) {
            throw new AssertionError((Object)"The new gap size must be greater than the old gap size");
        }
        int n2 = n - this.gapEnd + this.gapStart;
        this.adjustPositionsInRange(this.gapEnd, this.buffer.length - this.gapEnd, n2);
        char[] cArray = (char[])this.allocateArray(this.length() + n);
        System.arraycopy(this.buffer, 0, cArray, 0, this.gapStart);
        System.arraycopy(this.buffer, this.gapEnd, cArray, this.gapStart + n, this.buffer.length - this.gapEnd);
        this.gapEnd = this.gapStart + n;
        this.buffer = cArray;
    }

    protected void shiftGap(int n) {
        if (n == this.gapStart) {
            return;
        }
        int n2 = n + this.gapEnd - this.gapStart;
        if (n < this.gapStart) {
            this.adjustPositionsInRange(n, this.gapStart - n, this.gapEnd - this.gapStart);
            System.arraycopy(this.buffer, n, this.buffer, n2, this.gapStart - n);
            this.gapStart = n;
            this.gapEnd = n2;
        } else {
            this.adjustPositionsInRange(this.gapEnd, n2 - this.gapEnd, -(this.gapEnd - this.gapStart));
            System.arraycopy(this.buffer, this.gapEnd, this.buffer, this.gapStart, n - this.gapStart);
            this.gapStart = n;
            this.gapEnd = n2;
        }
        if (this.gapStart == 0) {
            this.resetMarksAtZero();
        }
    }

    protected void shiftGapStartDown(int n) {
        if (n == this.gapStart) {
            return;
        }
        if (!assert && n >= this.gapStart) {
            throw new AssertionError((Object)"The new gap start must be less than the old gap start.");
        }
        this.setPositionsInRange(n, this.gapStart - n, this.gapStart);
        this.gapStart = n;
    }

    protected void shiftGapEndUp(int n) {
        if (n == this.gapEnd) {
            return;
        }
        if (!assert && n <= this.gapEnd) {
            throw new AssertionError((Object)"The new gap end must be greater than the old gap end.");
        }
        this.setPositionsInRange(this.gapEnd, n - this.gapEnd, n);
        this.gapEnd = n;
    }

    protected final Object getArray() {
        return this.buffer;
    }

    protected void replace(int n, int n2, Object object, int n3) {
        if (this.gapStart != n) {
            this.shiftGap(n);
        }
        if (n2 > 0) {
            this.shiftGapEndUp(this.gapEnd + n2);
        }
        if (this.gapEnd - this.gapStart <= n3) {
            this.shiftEnd((n3 - this.gapEnd + this.gapStart + 1) * 2 + this.gapEnd + 10);
        }
        if (object != null) {
            System.arraycopy(object, 0, this.buffer, this.gapStart, n3);
            this.gapStart += n3;
        }
    }

    protected final int getGapStart() {
        return this.gapStart;
    }

    protected final int getGapEnd() {
        return this.gapEnd;
    }

    protected Vector getPositionsInRange(Vector vector, int n, int n2) {
        Object object;
        Object object2;
        Vector vector2 = vector;
        if (vector2 == null) {
            vector2 = new Vector();
        } else {
            vector2.clear();
        }
        int n3 = n + n2;
        int n4 = Collections.binarySearch(this.positions, new GapContentPosition(n), new WeakPositionComparator());
        if (n4 < 0) {
            n4 = -(n4 + 1);
        }
        while (n4 > 0) {
            object2 = (WeakReference)this.positions.get(n4 - 1);
            object = (GapContentPosition)((Reference)object2).get();
            if ((object == null || ((GapContentPosition)object).mark != n) && object != null) break;
            --n4;
        }
        object2 = this.positions.listIterator(n4);
        while (object2.hasNext()) {
            object = (WeakReference)object2.next();
            GapContentPosition gapContentPosition = (GapContentPosition)((Reference)object).get();
            if (gapContentPosition == null) continue;
            if (gapContentPosition.mark > n3) break;
            if (gapContentPosition.mark < n || gapContentPosition.mark > n3) continue;
            vector2.add(gapContentPosition);
        }
        return vector2;
    }

    private final void setPositionsInRange(int n, int n2, int n3) {
        Object object;
        Object object2;
        int n4 = n + n2;
        int n5 = Collections.binarySearch(this.positions, new GapContentPosition(n), new WeakPositionComparator());
        if (n5 < 0) {
            n5 = -(n5 + 1);
        }
        while (n5 > 0) {
            object2 = (WeakReference)this.positions.get(n5 - 1);
            object = (GapContentPosition)((Reference)object2).get();
            if ((object == null || ((GapContentPosition)object).mark != n) && object != null) break;
            --n5;
        }
        object2 = this.positions.listIterator(n5);
        while (object2.hasNext()) {
            object = (WeakReference)object2.next();
            GapContentPosition gapContentPosition = (GapContentPosition)((Reference)object).get();
            if (gapContentPosition == null) continue;
            if (gapContentPosition.mark > n4) break;
            if (gapContentPosition.mark < n || gapContentPosition.mark > n4) continue;
            gapContentPosition.mark = n3;
        }
    }

    private final void adjustPositionsInRange(int n, int n2, int n3) {
        Object object;
        Object object2;
        int n4 = n + n2;
        int n5 = Collections.binarySearch(this.positions, new GapContentPosition(n), new WeakPositionComparator());
        if (n5 < 0) {
            n5 = -(n5 + 1);
        }
        while (n5 > 0) {
            object2 = (WeakReference)this.positions.get(n5 - 1);
            object = (GapContentPosition)((Reference)object2).get();
            if ((object == null || ((GapContentPosition)object).mark != n) && object != null) break;
            --n5;
        }
        object2 = this.positions.listIterator(n5);
        while (object2.hasNext()) {
            object = (WeakReference)object2.next();
            GapContentPosition gapContentPosition = (GapContentPosition)((Reference)object).get();
            if (gapContentPosition == null) continue;
            if (gapContentPosition.mark > n4) break;
            if (gapContentPosition.mark < n || gapContentPosition.mark > n4) continue;
            gapContentPosition.mark += n3;
        }
    }

    protected void resetMarksAtZero() {
        if (this.gapStart != 0) {
            return;
        }
        this.setPositionsInRange(this.gapEnd, 0, 0);
    }

    protected void updateUndoPositions(Vector vector, int n, int n2) {
    }

    private final void dump() {
        System.err.println("GapContent debug information");
        System.err.println("buffer length: " + this.buffer.length);
        System.err.println("gap start: " + this.gapStart);
        System.err.println("gap end: " + this.gapEnd);
        int n = 0;
        while (n < this.buffer.length) {
            if (n == this.gapStart) {
                System.err.print('<');
            }
            if (n == this.gapEnd) {
                System.err.print('>');
            }
            if (!Character.isISOControl(this.buffer[n])) {
                System.err.print(this.buffer[n]);
            } else {
                System.err.print('.');
            }
            ++n;
        }
        System.err.println();
    }

    private final void dumpPositions() {
        Iterator iterator = this.positions.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            GapContentPosition gapContentPosition = (GapContentPosition)weakReference.get();
            System.err.println("position at: " + gapContentPosition.mark);
        }
    }

    private final void clearPositionReferences() {
        Iterator iterator = this.positions.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            if (weakReference.get() != null) continue;
            iterator.remove();
        }
    }

    public GapContent() {
        this(10);
    }

    public GapContent(int n) {
        this.buffer = (char[])this.allocateArray(n);
        this.gapStart = 1;
        this.gapEnd = n;
        this.buffer[0] = 10;
        this.positions = new ArrayList();
    }

    static {
        assert = Class.forName("[Ljavax.swing.text.GapContent;").getComponentType().desiredAssertionStatus() ^ true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class InsertUndo
    extends AbstractUndoableEdit {
        public int where;
        public int length;
        String text;

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                this.text = GapContent.this.getString(this.where, this.length);
                GapContent.this.remove(this.where, this.length);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotUndoException {
            super.redo();
            try {
                GapContent.this.insertString(this.where, this.text);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }

        public InsertUndo(int n, int n2) {
            this.where = n;
            this.length = n2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class UndoRemove
    extends AbstractUndoableEdit {
        public int where;
        String text;

        public void undo() throws CannotUndoException {
            super.undo();
            try {
                GapContent.this.insertString(this.where, this.text);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() throws CannotUndoException {
            super.redo();
            try {
                GapContent.this.remove(this.where, this.text.length());
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }

        public UndoRemove(int n, String string) {
            this.where = n;
            this.text = string;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class GapContentPosition
    implements Position,
    Comparable {
        int mark;
        private static final /* synthetic */ boolean assert;

        public int compareTo(Object object) {
            if (object instanceof Integer) {
                int n = (Integer)object;
                return this.mark - n;
            }
            GapContentPosition gapContentPosition = (GapContentPosition)object;
            return this.mark - gapContentPosition.mark;
        }

        public int getOffset() {
            if (!assert && this.mark > GapContent.this.gapStart && this.mark < GapContent.this.gapEnd) {
                throw new AssertionError((Object)("mark: " + this.mark + ", gapStart: " + GapContent.this.gapStart + ", gapEnd: " + GapContent.this.gapEnd));
            }
            if (this.mark <= GapContent.this.gapStart) {
                return this.mark;
            }
            return this.mark - (GapContent.this.gapEnd - GapContent.this.gapStart);
        }

        GapContentPosition(int n) {
            this.mark = n;
        }

        static {
            assert = Class.forName("[Ljavax.swing.text.GapContent;").getComponentType().desiredAssertionStatus() ^ true;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class WeakPositionComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object instanceof WeakReference) {
                object = ((WeakReference)object).get();
            }
            if (object2 instanceof WeakReference) {
                object2 = ((WeakReference)object2).get();
            }
            GapContentPosition gapContentPosition = (GapContentPosition)object;
            GapContentPosition gapContentPosition2 = (GapContentPosition)object2;
            int n = gapContentPosition == null || gapContentPosition2 == null ? -1 : gapContentPosition.compareTo(gapContentPosition2);
            return n;
        }

        private WeakPositionComparator() {
        }
    }
}

