/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class GZIPInputStream
extends InflaterInputStream {
    public static final int GZIP_MAGIC = 35615;
    static final int FTEXT = 1;
    static final int FHCRC = 2;
    static final int FEXTRA = 4;
    static final int FNAME = 8;
    static final int FCOMMENT = 16;
    protected CRC32 crc = new CRC32();
    protected boolean eos;
    private boolean readGZIPHeader;

    public void close() throws IOException {
        super.close();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.readGZIPHeader) {
            this.readHeader();
        }
        if (this.eos) {
            return -1;
        }
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.crc.update(byArray, n, n3);
        }
        if (this.inf.finished()) {
            this.readFooter();
        }
        return n3;
    }

    private final void readHeader() throws IOException {
        int n;
        CRC32 cRC32 = new CRC32();
        int n2 = this.in.read();
        if (n2 < 0) {
            this.eos = true;
            return;
        }
        int n3 = this.in.read();
        if (n2 + (n3 << 8) != 35615) {
            throw new IOException("Error in GZIP header, bad magic code");
        }
        cRC32.update(n2);
        cRC32.update(n3);
        int n4 = this.in.read();
        if (n4 != 8) {
            throw new IOException("Error in GZIP header, data not in deflate format");
        }
        cRC32.update(n4);
        int n5 = this.in.read();
        if (n5 < 0) {
            throw new EOFException("Early EOF in GZIP header");
        }
        cRC32.update(n5);
        if ((n5 & 0xD0) != 0) {
            throw new IOException("Reserved flag bits in GZIP header != 0");
        }
        int n6 = 0;
        while (n6 < 6) {
            n = this.in.read();
            if (n < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            cRC32.update(n);
            ++n6;
        }
        if ((n5 & 4) != 0) {
            n6 = 0;
            while (n6 < 2) {
                n = this.in.read();
                if (n < 0) {
                    throw new EOFException("Early EOF in GZIP header");
                }
                cRC32.update(n);
                ++n6;
            }
            if (this.in.read() < 0 || this.in.read() < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            n6 = this.in.read();
            n = this.in.read();
            if (n6 < 0 || n < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            cRC32.update(n6);
            cRC32.update(n);
            int n7 = n6 << 8 | n;
            int n8 = 0;
            while (n8 < n7) {
                int n9 = this.in.read();
                if (n9 < 0) {
                    throw new EOFException("Early EOF in GZIP header");
                }
                cRC32.update(n9);
                ++n8;
            }
        }
        if ((n5 & 8) != 0) {
            while ((n6 = this.in.read()) > 0) {
                cRC32.update(n6);
            }
            if (n6 < 0) {
                throw new EOFException("Early EOF in GZIP file name");
            }
            cRC32.update(n6);
        }
        if ((n5 & 0x10) != 0) {
            while ((n6 = this.in.read()) > 0) {
                cRC32.update(n6);
            }
            if (n6 < 0) {
                throw new EOFException("Early EOF in GZIP comment");
            }
            cRC32.update(n6);
        }
        if ((n5 & 2) != 0) {
            n = this.in.read();
            if (n < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            n6 = this.in.read();
            if (n6 < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            if ((n = n << 8 | n6) != ((int)cRC32.getValue() & (char)-1)) {
                throw new IOException("Header CRC value mismatch");
            }
        }
        this.readGZIPHeader = true;
    }

    private final void readFooter() throws IOException {
        int n;
        byte[] byArray = new byte[8];
        int n2 = this.inf.getRemaining();
        if (n2 > 8) {
            n2 = 8;
        }
        System.arraycopy(this.buf, this.len - this.inf.getRemaining(), byArray, 0, n2);
        int n3 = 8 - n2;
        while (n3 > 0) {
            n = this.in.read(byArray, 8 - n3, n3);
            if (n <= 0) {
                throw new EOFException("Early EOF in GZIP footer");
            }
            n3 -= n;
        }
        n = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | byArray[3] << 24;
        if (n != (int)this.crc.getValue()) {
            throw new IOException("GZIP crc sum mismatch, theirs \"" + Integer.toHexString(n) + "\" and ours \"" + Integer.toHexString((int)this.crc.getValue()));
        }
        int n4 = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | byArray[7] << 24;
        if (n4 != this.inf.getTotalOut()) {
            throw new IOException("Number of bytes mismatch");
        }
        this.eos = true;
    }

    public GZIPInputStream(InputStream inputStream) throws IOException {
        this(inputStream, 4096);
    }

    public GZIPInputStream(InputStream inputStream, int n) throws IOException {
        super(inputStream, new Inflater(true), n);
        this.readHeader();
    }
}

