/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.stream.UnicodeReader;
import gnu.xml.stream.XMLParser;
import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import java.io.IOException;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class NMTokenType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{1, 2, 3, 4, 5, 6};

    public final int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public final void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        try {
            int[] nArray = UnicodeReader.toCodePointArray(string);
            if (nArray.length == 0) {
                throw new DatatypeException("invalid NMTOKEN value");
            }
            int n = 0;
            while (n < nArray.length) {
                if (!XMLParser.isNameCharacter(nArray[n], false)) {
                    throw new DatatypeException(n, "invalid NMTOKEN value");
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            DatatypeException datatypeException = new DatatypeException("invalid NMTOKEN value");
            datatypeException.initCause(iOException);
            throw datatypeException;
        }
    }

    NMTokenType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "NMTOKEN"), TypeLibrary.TOKEN);
    }
}

