/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPDecoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DecodeBF32
extends BMPDecoder {
    private int[] bitmasks;
    private boolean useDefaultMasks;

    public BufferedImage decode(ImageInputStream imageInputStream) throws IOException, BMPException {
        Object object;
        if (!this.useDefaultMasks) {
            this.bitmasks = this.readBitMasks(imageInputStream);
        }
        this.skipToImage(imageInputStream);
        Dimension dimension = this.infoHeader.getSize();
        int n = (int)dimension.getHeight();
        int n2 = (int)dimension.getWidth();
        int n3 = n2 << 2;
        int[] nArray = new int[n2 * n];
        int n4 = n - 1;
        while (n4 >= 0) {
            object = new byte[n3];
            if (imageInputStream.read((byte[])object) != n3) {
                throw new IOException("Couldn't read image data.");
            }
            int n5 = 0;
            while (n5 < n2) {
                nArray[n5 + n4 * n2] = object[n5 << 2] & 0xFF | (object[(n5 << 2) + 1] & 0xFF) << 8 | (object[(n5 << 2) + 2] & 0xFF) << 16 | (object[(n5 << 2) + 3] & 0xFF) << 24;
                ++n5;
            }
            --n4;
        }
        DirectColorModel directColorModel = new DirectColorModel(32, this.bitmasks[0], this.bitmasks[1], this.bitmasks[2]);
        object = new SinglePixelPackedSampleModel(3, n2, n, this.bitmasks);
        DataBufferInt dataBufferInt = new DataBufferInt(nArray, n2 * n);
        WritableRaster writableRaster = Raster.createWritableRaster((SampleModel)object, dataBufferInt, null);
        return new BufferedImage(directColorModel, writableRaster, false, null);
    }

    public DecodeBF32(BMPFileHeader bMPFileHeader, BMPInfoHeader bMPInfoHeader, boolean bl) {
        super(bMPFileHeader, bMPInfoHeader);
        this.useDefaultMasks = bl;
        if (this.useDefaultMasks) {
            this.bitmasks = new int[]{0xFF0000, 65280, 255};
        }
    }
}

