/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig.rsa;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.sig.BaseSignature;
import gnu.java.security.sig.rsa.EMSA_PKCS1_V1_5;
import gnu.java.security.sig.rsa.RSA;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;

public class RSAPKCS1V1_5Signature
extends BaseSignature {
    private EMSA_PKCS1_V1_5 pkcs1;

    public Object clone() {
        return new RSAPKCS1V1_5Signature(this);
    }

    protected void setupForVerification(PublicKey publicKey) throws IllegalArgumentException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new IllegalArgumentException();
        }
        this.publicKey = publicKey;
    }

    protected void setupForSigning(PrivateKey privateKey) throws IllegalArgumentException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new IllegalArgumentException();
        }
        this.privateKey = privateKey;
    }

    protected Object generateSignature() throws IllegalStateException {
        int n = ((RSAPrivateKey)this.privateKey).getModulus().bitLength();
        int n2 = (n + 7) / 8;
        byte[] byArray = this.pkcs1.encode(this.md.digest(), n2);
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = RSA.sign(this.privateKey, bigInteger);
        return RSA.I2OSP(bigInteger2, n2);
    }

    protected boolean verifySignature(Object object) throws IllegalStateException {
        byte[] byArray;
        BigInteger bigInteger;
        if (this.publicKey == null) {
            throw new IllegalStateException();
        }
        byte[] byArray2 = (byte[])object;
        int n = ((RSAPublicKey)this.publicKey).getModulus().bitLength();
        int n2 = (n + 7) / 8;
        if (byArray2.length != n2) {
            return false;
        }
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        try {
            bigInteger = RSA.verify(this.publicKey, bigInteger2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        try {
            byArray = RSA.I2OSP(bigInteger, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        byte[] byArray3 = this.pkcs1.encode(this.md.digest(), n2);
        return Arrays.equals(byArray, byArray3);
    }

    public RSAPKCS1V1_5Signature() {
        this("sha-160");
    }

    public RSAPKCS1V1_5Signature(String string) {
        this(HashFactory.getInstance(string));
    }

    public RSAPKCS1V1_5Signature(IMessageDigest iMessageDigest) {
        super("rsa-pkcs1-v1.5", iMessageDigest);
        this.pkcs1 = EMSA_PKCS1_V1_5.getInstance(iMessageDigest.name());
    }

    private RSAPKCS1V1_5Signature(RSAPKCS1V1_5Signature rSAPKCS1V1_5Signature) {
        this(rSAPKCS1V1_5Signature.md.name());
        this.publicKey = rSAPKCS1V1_5Signature.publicKey;
        this.privateKey = rSAPKCS1V1_5Signature.privateKey;
        this.md = (IMessageDigest)rSAPKCS1V1_5Signature.md.clone();
        this.pkcs1 = (EMSA_PKCS1_V1_5)rSAPKCS1V1_5Signature.pkcs1.clone();
    }
}

