#
# Gramps - a GTK+/GNOME based genealogy program
#
# Copyright (C) 2007-2008  Brian G. Matherly
# Copyright (C) 2008       Gary Burton
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# $Id: _style.py 11086 2008-09-27 13:56:17Z pez4brian $

"""
Option class representing a document style.
"""

#-------------------------------------------------------------------------
#
# gramps modules
#
#-------------------------------------------------------------------------
from gen.plug.menu import EnumeratedListOption
import BaseDoc

#-------------------------------------------------------------------------
#
# StyleOption class
#
#-------------------------------------------------------------------------
class StyleOption(EnumeratedListOption):
    """
    This class describes an option that allows the use to select a style sheet.
    """
    
    def __init__(self, label, default_style, module_name):
        """
        @param label: A friendly label to be applied to this option.
            Example: "Style"
        @type label: string
        @param default_style: A BaseDoc.StyleSheet instance which provides the 
        default styles.
        @type default_style: BaseDoc.StyleSheet
        @param module_name: The name of the module the style sheets belong to.
            Example: "web_cal"
        @type module_name: string
        @return: nothing
        """
        EnumeratedListOption.__init__(self, label, "default")
        
        self.__default_style = default_style
        self.__default_style.set_name("default")
        self.__style_file = "%s_style.xml" % module_name
        style_list = BaseDoc.StyleSheetList(self.__style_file, 
                                            self.__default_style)
        for style_name in style_list.get_style_names():
            self.add_item(style_name, style_name)
            
    def get_default_style(self):
        """ Get the default style """
        return self.__default_style
    
    def get_style_file(self):
        """ Get the name of the style file """
        return self.__style_file
        
    def get_style(self):
        """ Get the selected style """
        style_list = BaseDoc.StyleSheetList(self.__style_file, 
                                            self.__default_style)
        return style_list.get_style_sheet(self.get_value())
