/*
 *  Copyright (C) 2005  Andreas Volz
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *  
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *  
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 *  File: Euler.h
 *  Andreas Volz <linux@brachttal.net>
 *   
 */

#ifndef EULER_H
#define EULER_H 1

#ifdef HAVE_CONFIG_H
  #include <config.h>
#endif

#include "Vector3.h"

namespace Animorph {

/*! Class to save various Euler notations. 
 */
class Euler : public Vector3f
{
public:
  enum Notation
  {
    XYZ
  };

private:
  Notation n;

public:
  /// constructor for Euler with all components 0.
  Euler (Notation n) : Vector3f (0,0,0), n(XYZ) {}

  /// constructor for Euler with tree components and Notation (in PI)
  /*!
   * \param x The rotation about the X-Axis (in PI).
   * \param y The rotation about the Y-Axis (in PI).
   * \param z The rotation about the Z-Axis (in PI).
   * \param n A Notation for this three rotations.
   */
  Euler (float x, float y, float z, Notation n) : Vector3f (x, y, z), n (n) {}
  
  /*!
   * \return The Notation of this Euler angle.
   */
  Notation getNotation () {return n;}
};

}

#endif  // EULER_H
