/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.codegenerator.generateproperties.edit;

import java.util.ArrayList;
import java.util.List;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.refactoring.codegenerator.generateproperties.request.GeneratePropertiesRequest;
import org.python.pydev.refactoring.codegenerator.generateproperties.request.SelectionState;
import org.python.pydev.refactoring.core.edit.AbstractInsertEdit;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyEdit
extends AbstractInsertEdit {
    private static final String SET = "set";
    private static final String DEL = "del";
    private static final String NONE = "None";
    private static final String GET = "get";
    private static final String PROPERTY = "property";
    private String attributeName;
    private SelectionState state;
    private int offsetStrategy;
    private int accessModifier;

    public PropertyEdit(GeneratePropertiesRequest req) {
        super(req);
        this.attributeName = this.nodeHelper.getPublicAttr(req.getAttributeName());
        this.state = req.getSelectionState();
        this.offsetStrategy = req.getPropertyOffsetStrategy();
        this.accessModifier = req.getAccessModifier();
    }

    @Override
    protected SimpleNode getEditNode() {
        exprType[] targets = this.initProperty();
        List<exprType> args = this.getPropertyArgs();
        Call property = new Call((exprType)new Name(PROPERTY, 1, false), args.toArray(new exprType[0]), null, null, null);
        return new Assign(targets, (exprType)property);
    }

    private exprType[] initProperty() {
        exprType[] targets = new exprType[1];
        String propertyName = this.nodeHelper.getAccessName(this.attributeName, this.accessModifier);
        targets[0] = new Name(propertyName, 2, false);
        return targets;
    }

    private List<exprType> getPropertyArgs() {
        ArrayList<exprType> args = new ArrayList<exprType>();
        String propertyName = this.getCapitalString(this.attributeName);
        if (this.state.isGetter()) {
            args.add((exprType)new Name(new StringBuffer(GET).append(propertyName).toString(), 1, false));
        } else {
            args.add((exprType)this.noneName());
        }
        if (this.state.isSetter()) {
            args.add((exprType)new Name(new StringBuffer(SET).append(propertyName).toString(), 1, false));
        } else {
            args.add((exprType)this.noneName());
        }
        if (this.state.isDelete()) {
            args.add((exprType)new Name(new StringBuffer(DEL).append(propertyName).toString(), 1, false));
        } else {
            args.add((exprType)this.noneName());
        }
        if (this.state.isDocstring()) {
            args.add((exprType)new Str(new StringBuffer(String.valueOf(propertyName)).append("'s Docstring").toString(), 4, false, false, false));
        } else {
            args.add((exprType)this.noneName());
        }
        return args;
    }

    private Name noneName() {
        return new Name(NONE, 1, false);
    }

    @Override
    public int getOffsetStrategy() {
        return this.offsetStrategy;
    }
}

