/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.outline;

import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.outline.PyOutlinePage;
import org.python.pydev.plugin.PydevPlugin;

public abstract class AbstractOutlineFilterAction
extends Action {
    protected ViewerFilter filter;
    protected WeakReference<PyOutlinePage> page;
    protected String preference;

    protected abstract ViewerFilter createFilter();

    public AbstractOutlineFilterAction(String text, PyOutlinePage page, ImageCache imageCache, String preference, String uiConstant) {
        super(text, 2);
        this.preference = preference;
        this.page = new WeakReference<PyOutlinePage>(page);
        this.setChecked(page.getStore().getBoolean(preference));
        this.setActionEnabled(this.isChecked());
        try {
            this.setImageDescriptor(imageCache.getDescriptor(uiConstant));
        }
        catch (MalformedURLException e) {
            PydevPlugin.log("Missing Icon", e);
        }
    }

    public void run() {
        this.setActionEnabled(this.isChecked());
    }

    protected void setActionEnabled(boolean enableAction) {
        PyOutlinePage p = (PyOutlinePage)((Object)this.page.get());
        if (p != null) {
            TreeViewer treeViewer;
            p.getStore().setValue(this.preference, enableAction);
            if (this.filter == null) {
                this.filter = this.createFilter();
            }
            if ((treeViewer = p.getTreeViewer()) != null) {
                if (enableAction) {
                    treeViewer.addFilter(this.filter);
                } else {
                    treeViewer.removeFilter(this.filter);
                }
            }
        }
    }
}

