/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.plugin.nature.PythonNature;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PyDevBuilderVisitor
implements Comparable<PyDevBuilderVisitor> {
    public static final int MAX_TO_VISIT_INFINITE = -1;
    public static final String MODULE_CACHE = "MODULE_CACHE";
    private static final String MODULE_NAME_CACHE = "MODULE_NAME";
    public static final int PRIORITY_DEFAULT = 5;
    public static final int PRIORITY_MAX = 0;
    public static final int PRIORITY_MIN = 10;
    public HashMap<String, Object> memo;
    public static final String IS_FULL_BUILD = "IS_FULL_BUILD";
    public static final String DOCUMENT_TIME = "DOCUMENT_TIME";

    public abstract void visitChangedResource(IResource var1, IDocument var2, IProgressMonitor var3);

    public abstract void visitRemovedResource(IResource var1, IDocument var2, IProgressMonitor var3);

    @Override
    public int compareTo(PyDevBuilderVisitor o) {
        int otherPriority;
        int priority = this.getPriority();
        if (priority < (otherPriority = o.getPriority())) {
            return -1;
        }
        if (otherPriority < priority) {
            return 1;
        }
        return 0;
    }

    protected int getPriority() {
        return 5;
    }

    protected boolean isFullBuild() {
        Boolean b = (Boolean)this.memo.get(IS_FULL_BUILD);
        if (b == null) {
            return false;
        }
        return b;
    }

    protected long getDocumentTime() {
        Long b = (Long)this.memo.get(DOCUMENT_TIME);
        if (b == null) {
            return -1L;
        }
        return b;
    }

    protected SourceModule getSourceModule(IResource resource, IDocument document, IPythonNature nature) throws MisconfigurationException {
        SourceModule module = (SourceModule)this.memo.get(MODULE_CACHE);
        if (module == null) {
            module = this.createSoureModule(resource, document, this.getModuleName(resource, nature));
            this.setModuleInCache(module);
        }
        return module;
    }

    protected SourceModule createSoureModule(IResource resource, IDocument document, String moduleName) throws MisconfigurationException {
        PythonNature nature = PythonNature.getPythonNature(resource.getProject());
        IFile f = (IFile)resource;
        String file = f.getRawLocation().toOSString();
        SourceModule module = (SourceModule)AbstractModule.createModuleFromDoc(moduleName, new File(file), document, nature, 0);
        return module;
    }

    protected void setModuleInCache(IModule module) {
        this.memo.put(MODULE_CACHE, module);
    }

    protected PythonNature getPythonNature(IResource resource) {
        PythonNature pythonNature = PythonNature.getPythonNature(resource);
        return pythonNature;
    }

    public String getModuleName(IResource resource, IPythonNature nature) throws MisconfigurationException {
        String moduleName = (String)this.memo.get(MODULE_NAME_CACHE);
        if (moduleName == null) {
            moduleName = nature.resolveModule(resource);
            if (moduleName != null) {
                this.setModuleNameInCache(moduleName);
            } else {
                throw new RuntimeException(new StringBuffer("Unable to resolve module for:").append(resource).toString());
            }
        }
        return moduleName;
    }

    protected void setModuleNameInCache(String moduleName) {
        this.memo.put(MODULE_NAME_CACHE, moduleName);
    }

    protected boolean isInitFile(IResource resource) {
        return resource.getName().startsWith("__init__.");
    }

    public static boolean isInPythonPath(IResource resource) {
        ICodeCompletionASTManager astManager;
        if (resource == null) {
            return false;
        }
        IProject project = resource.getProject();
        PythonNature nature = PythonNature.getPythonNature(project);
        if (project != null && nature != null && (astManager = nature.getAstManager()) != null) {
            IModulesManager modulesManager = astManager.getModulesManager();
            return modulesManager.isInPythonPath(resource, project);
        }
        return false;
    }

    protected IResource[] getInitDependents(IResource initResource) {
        ArrayList<IResource> toRet = new ArrayList<IResource>();
        IContainer parent = initResource.getParent();
        try {
            this.fillWithMembers(toRet, parent);
            return toRet.toArray(new IResource[0]);
        }
        catch (CoreException coreException) {
            return new IResource[0];
        }
    }

    private void fillWithMembers(List<IResource> toRet, IContainer parent) throws CoreException {
        IResource[] resources = parent.members();
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getType() == 1) {
                toRet.add(resources[i]);
            } else if (resources[i].getType() == 2) {
                this.fillWithMembers(toRet, (IContainer)((IFolder)resources[i]));
            }
            ++i;
        }
    }

    public int maxResourcesToVisit() {
        return -1;
    }

    public boolean shouldVisitInitDependency() {
        return false;
    }

    public void visitAddedResource(IResource resource, IDocument document, IProgressMonitor monitor) {
        this.visitChangedResource(resource, document, monitor);
    }

    public void visitingWillStart(IProgressMonitor monitor, boolean isFullBuild, IPythonNature nature) {
    }

    public void visitingEnded(IProgressMonitor monitor) {
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((PyDevBuilderVisitor)object);
    }
}

