/*
 * Decompiled with CFR 0.152.
 */
package org.python.copiedfromeclipsesrc;

import java.io.IOException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;

public class PythonCodeReader {
    public static final int EOF = -1;
    private boolean fForward = false;
    private IDocument fDocument;
    private int fOffset;
    private int fEnd = -1;
    private int handledLine = -1;

    public int getOffset() {
        return this.fForward ? this.fOffset - 1 : this.fOffset;
    }

    public void configureForwardReader(IDocument document, int offset, int length, boolean skipComments, boolean skipStrings) throws IOException {
        Assert.isTrue((boolean)skipComments);
        Assert.isTrue((boolean)skipStrings);
        this.fDocument = document;
        this.fOffset = offset;
        this.fForward = true;
        this.fEnd = Math.min(this.fDocument.getLength(), this.fOffset + length);
    }

    public void configureBackwardReader(IDocument document, int offset, boolean skipComments, boolean skipStrings) throws IOException {
        Assert.isTrue((boolean)skipComments);
        Assert.isTrue((boolean)skipStrings);
        this.fDocument = document;
        this.fOffset = offset;
        this.fForward = false;
    }

    public void close() throws IOException {
        this.fDocument = null;
    }

    public int read() throws IOException {
        try {
            return this.fForward ? this.readForwards() : this.readBackwards();
        }
        catch (BadLocationException x) {
            throw new RuntimeException(x);
        }
    }

    private void gotoStringStart(char delimiter) throws BadLocationException {
        boolean isMulti = false;
        if (this.fOffset >= 2 && this.fDocument.getChar(this.fOffset) == delimiter && this.fDocument.getChar(this.fOffset - 1) == delimiter) {
            isMulti = true;
            --this.fOffset;
            --this.fOffset;
        }
        while (this.fOffset > 0) {
            char current = this.fDocument.getChar(this.fOffset);
            if (current == delimiter && (this.fOffset < 0 || this.fDocument.getChar(this.fOffset - 1) != '\\')) {
                if (isMulti) {
                    if (this.fDocument.getChar(this.fOffset) == delimiter && this.fDocument.getChar(this.fOffset - 1) == delimiter) {
                        return;
                    }
                } else {
                    return;
                }
            }
            --this.fOffset;
        }
    }

    private int readForwards() throws BadLocationException {
        ParsingUtils parsingUtils = ParsingUtils.create((Object)this.fDocument);
        while (this.fOffset < this.fEnd) {
            char current = this.fDocument.getChar(this.fOffset++);
            switch (current) {
                case '#': {
                    this.fOffset = parsingUtils.eatComments(null, this.fOffset);
                    return current;
                }
                case '\"': 
                case '\'': {
                    this.fOffset = parsingUtils.eatLiterals(null, this.fOffset - 1) + 1;
                    break;
                }
                default: {
                    return current;
                }
            }
        }
        return -1;
    }

    private int readBackwards() throws BadLocationException {
        while (this.fOffset > 0) {
            --this.fOffset;
            this.handleComment();
            char current = this.fDocument.getChar(this.fOffset);
            switch (current) {
                case '\"': 
                case '\'': {
                    --this.fOffset;
                    this.gotoStringStart(current);
                    break;
                }
                default: {
                    return current;
                }
            }
        }
        return -1;
    }

    private void handleComment() throws BadLocationException {
        IRegion lineInformation;
        int offset;
        String contentType;
        int lineOfOffset = this.fDocument.getLineOfOffset(this.fOffset);
        if (this.handledLine == lineOfOffset) {
            return;
        }
        this.handledLine = lineOfOffset;
        String line = PySelection.getLine((IDocument)this.fDocument, (int)lineOfOffset);
        int i = line.indexOf(35);
        if (i != -1 && (contentType = ParsingUtils.getContentType((IDocument)this.fDocument, (int)((offset = (lineInformation = this.fDocument.getLineInformation(lineOfOffset)).getOffset() + i) + 1))).equals("__python_comment") && offset < this.fOffset) {
            this.fOffset = offset;
        }
    }
}

