/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.customizations.app_engine.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.python.pydev.core.ICallback;
import org.python.pydev.customizations.app_engine.wizards.AppEngineConfigWizardPage;
import org.python.pydev.customizations.app_engine.wizards.AppEngineTemplatePage;
import org.python.pydev.plugin.PyStructureConfigHelpers;
import org.python.pydev.ui.wizards.project.IWizardNewProjectNameAndLocationPage;
import org.python.pydev.ui.wizards.project.NewProjectNameAndLocationWizardPage;
import org.python.pydev.ui.wizards.project.PythonProjectWizard;

public class AppEngineWizard
extends PythonProjectWizard {
    private AppEngineConfigWizardPage appEngineConfigWizardPage;
    private AppEngineTemplatePage appEngineTemplatePage;

    public void addPages() {
        this.addPage((IWizardPage)this.projectPage);
        this.appEngineConfigWizardPage = new AppEngineConfigWizardPage("Goole App Engine Page");
        this.appEngineConfigWizardPage.setTitle("Google App Engine");
        this.appEngineConfigWizardPage.setDescription("Set Google App Engine Configuration");
        this.addPage((IWizardPage)this.appEngineConfigWizardPage);
        this.appEngineTemplatePage = new AppEngineTemplatePage("Initial Structure");
        this.addPage((IWizardPage)this.appEngineTemplatePage);
    }

    protected IWizardNewProjectNameAndLocationPage createProjectPage() {
        return new NewProjectNameAndLocationWizardPage("Setting project properties"){

            public void createControl(Composite parent) {
                super.createControl(parent);
                this.checkSrcFolder.setVisible(false);
            }

            public boolean shouldCreatSourceFolder() {
                return true;
            }
        };
    }

    protected void createAndConfigProject(IProject newProjectHandle, IProjectDescription description, String projectType, String projectInterpreter, IProgressMonitor monitor) throws CoreException {
        ICallback<List<IFolder>, IProject> getSourceFolderHandlesCallback = new ICallback<List<IFolder>, IProject>(){

            public List<IFolder> call(IProject projectHandle) {
                if (AppEngineWizard.this.projectPage.shouldCreatSourceFolder()) {
                    IFolder folder = projectHandle.getFolder("src");
                    ArrayList<IFolder> ret = new ArrayList<IFolder>();
                    ret.add(folder);
                    return ret;
                }
                return null;
            }

            public /* synthetic */ Object call(Object object) {
                return this.call((IProject)object);
            }
        };
        ICallback<List<String>, IProject> getExternalSourceFolderHandlesCallback = new ICallback<List<String>, IProject>(){

            public List<String> call(IProject projectHandle) {
                return AppEngineWizard.this.appEngineConfigWizardPage.getExternalSourceFolders();
            }

            public /* synthetic */ Object call(Object object) {
                return this.call((IProject)object);
            }
        };
        ICallback<Map<String, String>, IProject> getVariableSubstitutionCallback = new ICallback<Map<String, String>, IProject>(){

            public Map<String, String> call(IProject projectHandle) {
                return AppEngineWizard.this.appEngineConfigWizardPage.getVariableSubstitution();
            }

            public /* synthetic */ Object call(Object object) {
                return this.call((IProject)object);
            }
        };
        PyStructureConfigHelpers.createPydevProject((IProjectDescription)description, (IProject)newProjectHandle, (IProgressMonitor)monitor, (String)projectType, (String)projectInterpreter, (ICallback)getSourceFolderHandlesCallback, (ICallback)getExternalSourceFolderHandlesCallback, (ICallback)getVariableSubstitutionCallback);
        IFolder sourceFolder = newProjectHandle.getFolder("src");
        this.appEngineTemplatePage.fillSourceFolder(sourceFolder);
    }
}

