/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.console.IHyperlink;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.model.Location;

public class PythonConsoleLineTracker
implements IConsoleLineTracker {
    private IConsole console;
    static Pattern linePattern = Pattern.compile("\\s*File \\\"([^\\\"]*)\\\", line (\\d*).*");

    public void init(IConsole console) {
        this.console = console;
    }

    public void lineAppended(IRegion line) {
        block9: {
            int lineOffset = line.getOffset();
            int lineLength = line.getLength();
            try {
                String text = this.console.getDocument().get(lineOffset, lineLength);
                Matcher m = linePattern.matcher(text);
                String fileName = null;
                String lineNumber = null;
                int fileStart = -1;
                if (m.matches()) {
                    fileName = m.group(1);
                    lineNumber = m.group(2);
                    fileStart = 2;
                }
                if (fileName == null) break block9;
                int num = -1;
                try {
                    num = lineNumber != null ? Integer.parseInt(lineNumber) : 0;
                }
                catch (NumberFormatException numberFormatException) {
                    num = 0;
                }
                Object link = null;
                IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(fileName));
                if (files.length > 0 && files[0].exists()) {
                    link = new FileLink(files[0], null, -1, -1, num);
                } else {
                    File realFile = new File(fileName);
                    if (realFile.exists()) {
                        ItemPointer p = new ItemPointer((Object)realFile, new Location(num - 1, 0), null);
                        link = new ConsoleLink(p);
                    }
                }
                if (link != null) {
                    this.console.addLink((IHyperlink)link, lineOffset + fileStart, lineLength - fileStart);
                }
            }
            catch (BadLocationException e) {
                PydevDebugPlugin.log(4, "unexpected error", e);
            }
        }
    }

    public void dispose() {
    }

    public class ConsoleLink
    implements IHyperlink {
        ItemPointer pointer;

        public ConsoleLink(ItemPointer pointer) {
            this.pointer = pointer;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            PyOpenAction open = new PyOpenAction();
            open.run(this.pointer);
        }
    }
}

