/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;

public class ResolverExport
extends VersionSupplier {
    private ResolverBundle resolverBundle;

    ResolverExport(ResolverBundle resolverBundle, ExportPackageDescription epd) {
        super(epd);
        this.resolverBundle = resolverBundle;
    }

    public ExportPackageDescription getExportPackageDescription() {
        return (ExportPackageDescription)this.base;
    }

    public BundleDescription getBundle() {
        return this.getExportPackageDescription().getExporter();
    }

    ResolverBundle getExporter() {
        return this.resolverBundle;
    }

    ResolverExport[] getRoots() {
        ArrayList results = new ArrayList(1);
        this.addRoots(results);
        return results.toArray(new ResolverExport[results.size()]);
    }

    private void addRoots(ArrayList roots) {
        if (roots.contains(this)) {
            return;
        }
        ResolverImport ri = this.getExporter().getImport(this.getName());
        if (ri != null && ri.getMatchingExport() != null && ri.getMatchingExport() != this) {
            ri.getMatchingExport().addRoots(roots);
            return;
        }
        roots.add(0, this);
        BundleConstraint[] requires = this.getExporter().getRequires();
        int i = 0;
        while (i < requires.length) {
            ResolverExport requiredExport;
            if (requires[i].getMatchingBundle() != null && (requiredExport = requires[i].getBundle().getExport(this.getName())) != null && !requiredExport.isDropped()) {
                requiredExport.addRoots(roots);
            }
            ++i;
        }
    }
}

