/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.internal.corext.refactoring.structure.JavaMoveRefactoring;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.reorg.CreateTargetQueries;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMoveWizard;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.swt.widgets.Shell;

public class ReorgMoveStarter {
    private final JavaMoveProcessor fMoveProcessor;

    private ReorgMoveStarter(JavaMoveProcessor moveProcessor) {
        Assert.isNotNull((Object)moveProcessor);
        this.fMoveProcessor = moveProcessor;
    }

    public static ReorgMoveStarter create(IJavaElement[] javaElements, IResource[] resources, IJavaElement destination) throws JavaModelException {
        Assert.isNotNull((Object)javaElements);
        Assert.isNotNull((Object)resources);
        Assert.isNotNull((Object)destination);
        IReorgPolicy.IMovePolicy policy = ReorgPolicyFactory.createMovePolicy(resources, javaElements);
        if (!policy.canEnable()) {
            return null;
        }
        JavaMoveProcessor processor = new JavaMoveProcessor(policy);
        if (!processor.setDestination(destination).isOK()) {
            return null;
        }
        return new ReorgMoveStarter(processor);
    }

    public static ReorgMoveStarter create(IJavaElement[] javaElements, IResource[] resources, IResource destination) throws JavaModelException {
        Assert.isNotNull((Object)javaElements);
        Assert.isNotNull((Object)resources);
        Assert.isNotNull((Object)destination);
        IReorgPolicy.IMovePolicy policy = ReorgPolicyFactory.createMovePolicy(resources, javaElements);
        if (!policy.canEnable()) {
            return null;
        }
        JavaMoveProcessor processor = new JavaMoveProcessor(policy);
        if (!processor.setDestination(destination).isOK()) {
            return null;
        }
        return new ReorgMoveStarter(processor);
    }

    public void run(Shell parent) throws InterruptedException, InvocationTargetException {
        try {
            JavaMoveRefactoring ref = new JavaMoveRefactoring(this.fMoveProcessor);
            if (this.fMoveProcessor.hasAllInputSet()) {
                ProgressMonitorDialog context = new ProgressMonitorDialog(parent);
                this.fMoveProcessor.setCreateTargetQueries(new CreateTargetQueries(parent));
                this.fMoveProcessor.setReorgQueries(new ReorgQueries(parent));
                new RefactoringExecutionHelper((Refactoring)ref, RefactoringCore.getConditionCheckingFailedSeverity(), true, parent, (IRunnableContext)context).perform(false);
            } else {
                ReorgMoveWizard wizard = new ReorgMoveWizard(ref);
                this.fMoveProcessor.setCreateTargetQueries(new CreateTargetQueries((Wizard)wizard));
                this.fMoveProcessor.setReorgQueries(new ReorgQueries((Wizard)wizard));
                new RefactoringStarter().activate((Refactoring)ref, wizard, parent, RefactoringMessages.OpenRefactoringWizardAction_refactoring, true);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

