/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class RenameSourceFolderChange
extends AbstractJavaElementRenameChange {
    private static RefactoringStatus checkIfModifiable(IPackageFragmentRoot root, IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        RenameSourceFolderChange.checkExistence(result, root);
        if (result.hasFatalError()) {
            return result;
        }
        if (root.isArchive()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.RenameSourceFolderChange_rename_archive, root.getElementName()));
            return result;
        }
        if (root.isExternal()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.RenameSourceFolderChange_rename_external, root.getElementName()));
            return result;
        }
        RenameSourceFolderChange.checkExistence(result, root.getCorrespondingResource());
        if (result.hasFatalError()) {
            return result;
        }
        if (root.getCorrespondingResource().isLinked()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.RenameSourceFolderChange_rename_linked, root.getElementName()));
            return result;
        }
        return result;
    }

    public RenameSourceFolderChange(RefactoringDescriptor descriptor, IPackageFragmentRoot sourceFolder, String newName, String comment) {
        this(descriptor, sourceFolder.getPath(), sourceFolder.getElementName(), newName, comment, -1L);
        Assert.isTrue((!sourceFolder.isReadOnly() ? 1 : 0) != 0, (String)"should not be read only");
        Assert.isTrue((!sourceFolder.isArchive() ? 1 : 0) != 0, (String)"should not be an archive");
    }

    private RenameSourceFolderChange(RefactoringDescriptor descriptor, IPath resourcePath, String oldName, String newName, String comment, long stampToRestore) {
        super(descriptor, resourcePath, oldName, newName, comment);
    }

    protected IPath createNewPath() {
        return this.getResourcePath().removeLastSegments(1).append(this.getNewName());
    }

    protected Change createUndoChange(long stampToRestore) {
        return new RenameSourceFolderChange(null, this.createNewPath(), this.getNewName(), this.getOldName(), this.getComment(), stampToRestore);
    }

    protected void doRename(IProgressMonitor pm) throws CoreException {
        IPackageFragmentRoot sourceFolder = this.getSourceFolder();
        if (sourceFolder != null) {
            sourceFolder.move(this.getNewPath(), this.getCoreMoveFlags(), this.getJavaModelUpdateFlags(), null, pm);
        }
    }

    private int getCoreMoveFlags() {
        if (this.getResource().isLinked()) {
            return 32;
        }
        return 0;
    }

    private int getJavaModelUpdateFlags() {
        return 30;
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.RenameSourceFolderChange_rename, new String[]{this.getOldName(), this.getNewName()});
    }

    private IPath getNewPath() {
        return this.getResource().getFullPath().removeLastSegments(1).append(this.getNewName());
    }

    private IPackageFragmentRoot getSourceFolder() {
        return (IPackageFragmentRoot)this.getModifiedElement();
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask("", 2);
        result.merge(this.isValid((IProgressMonitor)new SubProgressMonitor(pm, 1), 2));
        if (result.hasFatalError()) {
            return result;
        }
        IPackageFragmentRoot sourceFolder = this.getSourceFolder();
        result.merge(RenameSourceFolderChange.checkIfModifiable(sourceFolder, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        return result;
    }
}

