/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;

public class RequiredDependencyManager {
    public static Set addRequiredPlugins(Object[] selected, String[] implicit, State state) {
        IPluginModelBase model;
        HashSet set = new HashSet();
        int i = 0;
        while (i < selected.length) {
            if (selected[i] instanceof IPluginModelBase) {
                model = (IPluginModelBase)selected[i];
                RequiredDependencyManager.addBundleAndDependencies(model.getBundleDescription(), set);
                IPluginExtension[] extensions = model.getPluginBase().getExtensions();
                int j = 0;
                while (j < extensions.length) {
                    int dot;
                    String point = extensions[j].getPoint();
                    if (point != null && (dot = point.lastIndexOf(46)) != -1) {
                        String id = point.substring(0, dot);
                        RequiredDependencyManager.addBundleAndDependencies(state.getBundle(id, null), set);
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < implicit.length) {
            RequiredDependencyManager.addBundleAndDependencies(state.getBundle(implicit[i], null), set);
            ++i;
        }
        i = 0;
        while (i < selected.length) {
            if (selected[i] instanceof IPluginModelBase) {
                model = (IPluginModelBase)selected[i];
                set.remove(model.getPluginBase().getId());
            }
            ++i;
        }
        return set;
    }

    private static void addBundleAndDependencies(BundleDescription desc, Set set) {
        if (desc != null && set.add(desc.getSymbolicName())) {
            BundleSpecification[] required = desc.getRequiredBundles();
            int i = 0;
            while (i < required.length) {
                RequiredDependencyManager.addBundleAndDependencies((BundleDescription)required[i].getSupplier(), set);
                ++i;
            }
            ExportPackageDescription[] exported = desc.getResolvedImports();
            int i2 = 0;
            while (i2 < exported.length) {
                RequiredDependencyManager.addBundleAndDependencies(exported[i2].getExporter(), set);
                ++i2;
            }
            BundleDescription[] fragments = desc.getFragments();
            int i3 = 0;
            while (i3 < fragments.length) {
                String id;
                if (fragments[i3].isResolved() && !"org.eclipse.ui.workbench.compatibility".equals(id = fragments[i3].getSymbolicName())) {
                    RequiredDependencyManager.addBundleAndDependencies(fragments[i3], set);
                }
                ++i3;
            }
            HostSpecification host = desc.getHost();
            if (host != null) {
                RequiredDependencyManager.addBundleAndDependencies((BundleDescription)host.getSupplier(), set);
            }
        }
    }
}

