/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal;

import org.eclipse.jface.internal.databinding.internal.BindingMessages;
import org.eclipse.jface.internal.databinding.provisional.BindSpec;
import org.eclipse.jface.internal.databinding.provisional.Binding;
import org.eclipse.jface.internal.databinding.provisional.BindingEvent;
import org.eclipse.jface.internal.databinding.provisional.BindingException;
import org.eclipse.jface.internal.databinding.provisional.DataBindingContext;
import org.eclipse.jface.internal.databinding.provisional.conversion.IConverter;
import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IObservableValue;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IValueChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IValueChangingListener;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IVetoableValue;
import org.eclipse.jface.internal.databinding.provisional.observable.value.ValueDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.value.WritableValue;
import org.eclipse.jface.internal.databinding.provisional.validation.IDomainValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.IValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.ValidationError;

public class ValueBinding
extends Binding {
    private final IObservableValue target;
    private final IObservableValue model;
    private IValidator targetValidator;
    private IConverter targetToModelConverter;
    private IConverter modelToTargetConverter;
    private IDomainValidator domainValidator;
    private boolean updating = false;
    private WritableValue partialValidationErrorObservable = new WritableValue(ValidationError.class, null);
    private WritableValue validationErrorObservable = new WritableValue(ValidationError.class, null);
    private final IValueChangingListener targetChangingListener = new IValueChangingListener(){

        public boolean handleValueChanging(IVetoableValue source, ValueDiff diff) {
            if (ValueBinding.this.updating) {
                return true;
            }
            Object value = diff.getNewValue();
            ValidationError partialValidationError = ValueBinding.this.targetValidator.isPartiallyValid(value);
            ValueBinding.this.partialValidationErrorObservable.setValue(partialValidationError);
            return partialValidationError == null;
        }
    };
    private final IValueChangeListener targetChangeListener = new IValueChangeListener(){

        public void handleValueChange(IObservableValue source, ValueDiff diff) {
            if (ValueBinding.this.updating) {
                return;
            }
            ValueBinding.this.updateModelFromTarget(diff);
        }
    };
    private IValueChangeListener modelChangeListener = new IValueChangeListener(){

        public void handleValueChange(IObservableValue source, ValueDiff diff) {
            if (ValueBinding.this.updating) {
                return;
            }
            ValueBinding.this.doUpdateTargetFromModel(diff);
        }
    };

    public ValueBinding(DataBindingContext context, IObservableValue target, IObservableValue model, BindSpec bindSpec) {
        super(context);
        this.target = target;
        this.model = model;
        if (bindSpec.updateTarget()) {
            this.modelToTargetConverter = bindSpec.getModelToTargetConverter();
            if (this.modelToTargetConverter == null) {
                throw new BindingException("Missing model to target converter from " + model.getValueType() + " to " + target.getValueType());
            }
            if (!context.isAssignableFromTo(model.getValueType(), this.modelToTargetConverter.getFromType())) {
                throw new BindingException("model to target converter does not convert from model type. Expected: " + model.getValueType() + ", actual: " + this.modelToTargetConverter.getFromType());
            }
            if (!context.isAssignableFromTo(this.modelToTargetConverter.getToType(), target.getValueType())) {
                throw new BindingException("model to target converter does convert to target type. Expected: " + target.getValueType() + ", actual: " + this.modelToTargetConverter.getToType());
            }
            model.addValueChangeListener(this.modelChangeListener);
        }
        if (bindSpec.updateModel()) {
            this.targetToModelConverter = bindSpec.getTargetToModelConverter();
            if (this.targetToModelConverter == null) {
                throw new BindingException("Missing target to model converter from " + target.getValueType() + " to " + model.getValueType());
            }
            if (!context.isAssignableFromTo(target.getValueType(), this.targetToModelConverter.getFromType())) {
                throw new BindingException("target to model converter does not convert from target type. Expected: " + target.getValueType() + ", actual: " + this.targetToModelConverter.getFromType());
            }
            if (!context.isAssignableFromTo(this.targetToModelConverter.getToType(), model.getValueType())) {
                throw new BindingException("target to model converter does convert to model type. Expected: " + model.getValueType() + ", actual: " + this.targetToModelConverter.getToType());
            }
            this.targetValidator = bindSpec.getTypeConversionValidator();
            if (this.targetValidator == null) {
                throw new BindingException("Missing validator");
            }
            this.domainValidator = bindSpec.getDomainValidator();
            target.addValueChangeListener(this.targetChangeListener);
            if (target instanceof IVetoableValue) {
                ((IVetoableValue)target).addValueChangingListener(this.targetChangingListener);
            }
        }
        this.updateTargetFromModel();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateModelFromTarget(ValueDiff diff) {
        BindingEvent e = new BindingEvent(this.model, this.target, diff, 1, 0){};
        e.originalValue = this.target.getValue();
        if (this.failure(this.errMsg(this.fireBindingEvent(e)))) {
            return;
        }
        ValidationError validationError = this.doValidate(e.originalValue);
        if (validationError != null) {
            return;
        }
        e.pipelinePosition = 1;
        if (this.failure(this.errMsg(this.fireBindingEvent(e)))) {
            return;
        }
        try {
            this.updating = true;
            e.convertedValue = this.targetToModelConverter.convert(e.originalValue);
            e.pipelinePosition = 2;
            if (this.failure(this.errMsg(this.fireBindingEvent(e)))) {
                return;
            }
        }
        catch (Exception exception) {
            ValidationError error = ValidationError.error(BindingMessages.getString("ValueBinding_ErrorWhileSettingValue"));
            this.validationErrorObservable.setValue(error);
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        {
            validationError = this.doDomainValidation(e.convertedValue);
            if (validationError != null) {
                return;
            }
            e.pipelinePosition = 3;
            if (this.failure(this.errMsg(this.fireBindingEvent(e)))) {
                return;
            }
            this.model.setValue(e.convertedValue);
            e.pipelinePosition = 4;
            this.fireBindingEvent(e);
            return;
        }
    }

    private ValidationError doDomainValidation(Object convertedValue) {
        if (this.domainValidator == null) {
            return null;
        }
        ValidationError validationError = this.domainValidator.isValid(convertedValue);
        return this.errMsg(validationError);
    }

    private ValidationError doValidate(Object value) {
        if (this.targetValidator == null) {
            return null;
        }
        ValidationError validationError = this.targetValidator.isValid(value);
        return this.errMsg(validationError);
    }

    private ValidationError errMsg(ValidationError validationError) {
        this.partialValidationErrorObservable.setValue(null);
        this.validationErrorObservable.setValue(validationError);
        return validationError;
    }

    private boolean failure(ValidationError errorMessage) {
        return errorMessage != null && errorMessage.status == 2;
    }

    public void updateTargetFromModel() {
        this.doUpdateTargetFromModel(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doUpdateTargetFromModel(ValueDiff diff) {
        try {
            this.updating = true;
            BindingEvent e = new BindingEvent(this.model, this.target, diff, 0, 0){};
            e.originalValue = this.model.getValue();
            if (this.failure(this.errMsg(this.fireBindingEvent(e)))) {
                return;
            }
            e.convertedValue = this.modelToTargetConverter.convert(e.originalValue);
            e.pipelinePosition = 2;
            if (this.failure(this.errMsg(this.fireBindingEvent(e)))) {
                return;
            }
            this.target.setValue(e.convertedValue);
            e.pipelinePosition = 4;
            if (this.failure(this.errMsg(this.fireBindingEvent(e)))) {
                return;
            }
            this.doValidate(this.target.getValue());
            e.pipelinePosition = 1;
            this.fireBindingEvent(e);
            return;
        }
        finally {
            this.updating = false;
        }
    }

    public IObservableValue getValidationError() {
        return this.validationErrorObservable;
    }

    public IObservableValue getPartialValidationError() {
        return this.partialValidationErrorObservable;
    }

    public void updateModelFromTarget() {
        this.updateModelFromTarget(Diffs.createValueDiff(this.target.getValue(), this.target.getValue()));
    }
}

