/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.filehistory;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileHistoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.client.listeners.LogEntry;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileHistory;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileRevision;
import org.eclipse.team.internal.ccvs.core.filesystem.CVSFileStore;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

public class CVSFileHistoryProvider
extends FileHistoryProvider {
    public IFileHistory getFileHistoryFor(IResource resource, int flags, IProgressMonitor monitor) {
        try {
            monitor.beginTask(null, 100);
            if (flags == 1 || flags == 2) {
                ICVSRemoteResource remoteResource = CVSWorkspaceRoot.getRemoteResourceFor(resource);
                monitor.worked(40);
                CVSFileHistory remoteFile = null;
                if (remoteResource instanceof ICVSFile) {
                    remoteFile = new CVSFileHistory((ICVSFile)((Object)remoteResource), flags);
                }
                CVSFileHistory cVSFileHistory = remoteFile;
                return cVSFileHistory;
            }
            ICVSRemoteResource remoteResource = CVSWorkspaceRoot.getRemoteResourceFor(resource);
            monitor.worked(40);
            CVSFileHistory remoteFile = null;
            if (remoteResource instanceof ICVSFile) {
                remoteFile = new CVSFileHistory((ICVSFile)((Object)remoteResource));
                remoteFile.refresh(monitor);
            }
            CVSFileHistory cVSFileHistory = remoteFile;
            return cVSFileHistory;
        }
        catch (CVSException cVSException) {
        }
        catch (TeamException teamException) {
        }
        finally {
            monitor.done();
        }
        return null;
    }

    public IFileRevision getWorkspaceFileRevision(IResource resource) {
        try {
            ICVSRemoteResource remoteResource = CVSWorkspaceRoot.getRemoteResourceFor(resource);
            if (remoteResource != null && remoteResource instanceof RemoteFile) {
                ResourceSyncInfo syncInfo = remoteResource.getSyncInfo();
                LogEntry cvsEntry = new LogEntry((RemoteFile)remoteResource, syncInfo.getRevision(), "", null, "", "", new CVSTag[0]);
                return new CVSFileRevision(cvsEntry);
            }
        }
        catch (CVSException cVSException) {}
        return null;
    }

    public IFileHistory getFileHistoryFor(IFileStore store, int flags, IProgressMonitor monitor) {
        CVSFileStore fileStore;
        ICVSRemoteFile file;
        if (store instanceof CVSFileStore && (file = (fileStore = (CVSFileStore)store).getCVSURI().toFile()) != null) {
            try {
                if (flags == 1 || flags == 2) {
                    CVSFileHistory history = new CVSFileHistory(file, flags);
                    history.refresh(monitor);
                    return history;
                }
                CVSFileHistory history = new CVSFileHistory(file);
                history.refresh(monitor);
                return history;
            }
            catch (TeamException teamException) {}
        }
        return null;
    }
}

