/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.launcher;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.internal.core.LoadpathEntry;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.debug.ui.launcher.LoadPathEntryLabelProvider;
import org.rubypeople.rdt.internal.debug.ui.preferences.EditInterpreterDialog;
import org.rubypeople.rdt.internal.launching.RubyInterpreter;
import org.rubypeople.rdt.internal.launching.RubyRuntime;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;

public class RubyEnvironmentTab
extends AbstractLaunchConfigurationTab {
    protected ListViewer loadPathListViewer;
    protected List installedInterpretersWorkingCopy;
    protected Combo interpreterCombo;
    protected Button loadPathDefaultButton;

    public void createControl(Composite composite) {
        Composite composite2 = this.createPageRoot(composite);
        TabFolder tabFolder = new TabFolder(composite2, 0);
        GridData gridData = new GridData(1808);
        tabFolder.setLayoutData((Object)gridData);
        this.addLoadPathTab(tabFolder);
        this.addInterpreterTab(tabFolder);
    }

    protected void addLoadPathTab(TabFolder tabFolder) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        this.loadPathListViewer = new ListViewer(composite, 2818);
        this.loadPathListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.loadPathListViewer.setLabelProvider((IBaseLabelProvider)new LoadPathEntryLabelProvider());
        this.loadPathListViewer.getList().setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0, 0);
        tabItem.setText(RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyEnvironment.loadPathTab.label"));
        tabItem.setControl((Control)composite);
        tabItem.setData((Object)this.loadPathListViewer);
        this.loadPathDefaultButton = new Button(composite, 32);
        this.loadPathDefaultButton.setText(RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyEnvironment.loadPathDefaultButton.label"));
        this.loadPathDefaultButton.setLayoutData((Object)new GridData(32));
        this.loadPathDefaultButton.addSelectionListener(this.getLoadPathDefaultButtonSelectionListener());
        this.loadPathDefaultButton.setEnabled(false);
    }

    protected SelectionListener getLoadPathSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                System.out.println("Loadpath list selection occurred: " + selectionEvent.getSource());
            }
        };
    }

    protected SelectionListener getLoadPathDefaultButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RubyEnvironmentTab.this.setUseLoadPathDefaults(((Button)selectionEvent.getSource()).getSelection());
            }
        };
    }

    protected void addInterpreterTab(TabFolder tabFolder) {
        Composite composite = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(768));
        this.createVerticalSpacer(composite, 2);
        this.interpreterCombo = new Combo(composite, 8);
        this.interpreterCombo.setLayoutData((Object)new GridData(768));
        this.initializeInterpreterCombo(this.interpreterCombo);
        this.interpreterCombo.addModifyListener(this.getInterpreterComboModifyListener());
        Button button = new Button(composite, 8);
        button.setText(RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyEnvironment.interpreterAddButton.label"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RubyInterpreter rubyInterpreter = new RubyInterpreter(null, null);
                EditInterpreterDialog editInterpreterDialog = new EditInterpreterDialog(RubyEnvironmentTab.this.getShell(), RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyEnvironment.editInterpreterDialog.title"));
                editInterpreterDialog.create();
                editInterpreterDialog.setInterpreterToEdit(rubyInterpreter);
                if (editInterpreterDialog.open() == 0) {
                    RubyRuntime.getDefault().addInstalledInterpreter(rubyInterpreter);
                    RubyEnvironmentTab.this.interpreterCombo.add(rubyInterpreter.getName());
                    RubyEnvironmentTab.this.interpreterCombo.select(RubyEnvironmentTab.this.interpreterCombo.indexOf(rubyInterpreter.getName()));
                }
            }
        });
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyEnvironment.interpreterTab.label"));
        tabItem.setControl((Control)composite);
    }

    protected ModifyListener getInterpreterComboModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                RubyEnvironmentTab.this.updateLaunchConfigurationDialog();
            }
        };
    }

    protected void createVerticalSpacer(Composite composite, int n) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        RubyInterpreter rubyInterpreter = RubyRuntime.getDefault().getSelectedInterpreter();
        if (rubyInterpreter != null) {
            iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.SELECTED_INTERPRETER", rubyInterpreter.getName());
        }
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.initializeLoadPath(iLaunchConfiguration);
        this.initializeInterpreterSelection(iLaunchConfiguration);
    }

    protected void initializeLoadPath(ILaunchConfiguration iLaunchConfiguration) {
        boolean bl = true;
        try {
            IRubyProject iRubyProject;
            String string;
            bl = iLaunchConfiguration.getAttribute("org.rubypeople.rdt.launching.USE_DEFAULT_LOAD_PATH", true);
            this.setUseLoadPathDefaults(bl);
            if (bl && (string = iLaunchConfiguration.getAttribute("org.rubypeople.rdt.launching.PROJECT_NAME", "")).length() != 0 && (iRubyProject = RubyModelManager.getRubyModelManager().getRubyModel().getRubyProject(string)) != null) {
                List list = iRubyProject.getLoadPathEntries();
                this.loadPathListViewer.setInput((Object)list);
            }
        }
        catch (CoreException coreException) {
            this.log(coreException);
        }
    }

    protected void setUseLoadPathDefaults(boolean bl) {
        this.loadPathListViewer.getList().setEnabled(!bl);
        this.loadPathDefaultButton.setSelection(bl);
    }

    protected void initializeInterpreterSelection(ILaunchConfiguration iLaunchConfiguration) {
        String string = null;
        try {
            string = iLaunchConfiguration.getAttribute("org.rubypeople.rdt.launching.SELECTED_INTERPRETER", "");
        }
        catch (CoreException coreException) {
            this.log(coreException);
        }
        if (string != null && !string.equals("")) {
            this.interpreterCombo.select(this.interpreterCombo.indexOf(string));
        }
    }

    protected void initializeInterpreterCombo(Combo combo) {
        this.installedInterpretersWorkingCopy = new ArrayList();
        this.installedInterpretersWorkingCopy.addAll(RubyRuntime.getDefault().getInstalledInterpreters());
        String[] stringArray = new String[this.installedInterpretersWorkingCopy.size()];
        int n = 0;
        while (n < this.installedInterpretersWorkingCopy.size()) {
            RubyInterpreter rubyInterpreter = (RubyInterpreter)this.installedInterpretersWorkingCopy.get(n);
            stringArray[n] = rubyInterpreter.getName();
            ++n;
        }
        combo.setItems(stringArray);
        RubyInterpreter rubyInterpreter = RubyRuntime.getDefault().getSelectedInterpreter();
        if (rubyInterpreter != null) {
            combo.select(combo.indexOf(rubyInterpreter.getName()));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        int n = this.interpreterCombo.getSelectionIndex();
        if (n >= 0) {
            iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.SELECTED_INTERPRETER", this.interpreterCombo.getItem(n));
        }
        iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.USE_DEFAULT_LOAD_PATH", this.loadPathDefaultButton.getSelection());
        if (!this.loadPathDefaultButton.getSelection()) {
            List list = (List)this.loadPathListViewer.getInput();
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                LoadpathEntry loadpathEntry = (LoadpathEntry)iterator.next();
                arrayList.add(loadpathEntry.getPath().toString());
            }
            iLaunchConfigurationWorkingCopy.setAttribute("org.rubypeople.rdt.launching.CUSTOM_LOAD_PATH", arrayList);
        }
    }

    protected Composite createPageRoot(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.createVerticalSpacer(composite2, 2);
        this.setControl((Control)composite2);
        return composite2;
    }

    public String getName() {
        return RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyEnvironment.name");
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        try {
            String string = iLaunchConfiguration.getAttribute("org.rubypeople.rdt.launching.SELECTED_INTERPRETER", "");
            if (string.length() == 0) {
                this.setErrorMessage(RdtDebugUiMessages.getString("LaunchConfigurationTab.RubyEnvironment.interpreter_not_selected_error_message"));
                return false;
            }
        }
        catch (CoreException coreException) {
            this.log(coreException);
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void log(Throwable throwable) {
        RdtDebugUiPlugin.log(throwable);
    }

    public Image getImage() {
        return RubyPluginImages.get((String)"org.rubypeople.rdt.ui.ruby.gif");
    }
}

