/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.util;

import fr.jayasoft.ivy.url.URLHandlerRegistry;
import fr.jayasoft.ivy.util.CopyProgressEvent;
import fr.jayasoft.ivy.util.CopyProgressListener;
import fr.jayasoft.ivy.util.Message;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class FileUtil {
    private static final int BUFFER_SIZE = 8192;

    public static void copy(File src, File dest, CopyProgressListener l) throws IOException {
        FileUtil.copy(src, dest, l, false);
    }

    public static void copy(File src, File dest, CopyProgressListener l, boolean overwrite) throws IOException {
        if (dest.exists()) {
            if (!dest.isFile()) {
                throw new IOException("impossible to copy: destination is not a file: " + dest);
            }
            if (overwrite) {
                if (!dest.canWrite()) {
                    dest.delete();
                }
            } else {
                Message.verbose(dest + " already exists, nothing done");
            }
        }
        FileUtil.copy((InputStream)new FileInputStream(src), dest, l);
        long srcLen = src.length();
        long destLen = dest.length();
        if (srcLen != destLen) {
            dest.delete();
            throw new IOException("size of source file " + src.toString() + "(" + srcLen + ") differs from size of dest file " + dest.toString() + "(" + destLen + ") - please retry");
        }
        dest.setLastModified(src.lastModified());
    }

    public static void copy(URL src, File dest, CopyProgressListener l) throws IOException {
        URLHandlerRegistry.getDefault().download(src, dest, l);
    }

    public static void copy(InputStream src, File dest, CopyProgressListener l) throws IOException {
        if (dest.getParentFile() != null) {
            dest.getParentFile().mkdirs();
        }
        FileUtil.copy(src, new FileOutputStream(dest), l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream src, OutputStream dest, CopyProgressListener l) throws IOException {
        try {
            int c;
            CopyProgressEvent evt = null;
            if (l != null) {
                evt = new CopyProgressEvent();
            }
            byte[] buffer = new byte[8192];
            long total = 0L;
            if (l != null) {
                l.start(evt);
            }
            while ((c = src.read(buffer)) != -1) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new IOException("transfer interrupted");
                }
                dest.write(buffer, 0, c);
                total += (long)c;
                if (l == null) continue;
                l.progress(evt.update(buffer, c, total));
            }
            if (l != null) {
                l.end(evt.update(buffer, 0, total));
            }
        }
        finally {
            try {
                src.close();
            }
            catch (IOException ex) {
                dest.close();
                throw ex;
            }
            dest.close();
        }
    }

    public static String readEntirely(BufferedReader in) throws IOException {
        StringBuffer buf = new StringBuffer();
        String line = in.readLine();
        while (line != null) {
            buf.append(line + "\n");
            line = in.readLine();
        }
        in.close();
        return buf.toString();
    }

    public static String concat(String dir, String file) {
        return dir + "/" + file;
    }

    public static void forceDelete(File f) {
        if (f.isDirectory()) {
            File[] sub = f.listFiles();
            for (int i = 0; i < sub.length; ++i) {
                FileUtil.forceDelete(sub[i]);
            }
        }
        f.delete();
    }

    public static List getPathFiles(File root, File file) {
        ArrayList<File> ret = new ArrayList<File>();
        while (file != null && !file.getAbsolutePath().equals(root.getAbsolutePath())) {
            ret.add(file);
            file = file.getParentFile();
        }
        if (root != null) {
            ret.add(root);
        }
        Collections.reverse(ret);
        return ret;
    }

    public static Collection listAll(File dir) {
        return FileUtil.listAll(dir, new ArrayList());
    }

    private static Collection listAll(File file, Collection list) {
        if (file.exists()) {
            list.add(file);
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileUtil.listAll(files[i], list);
            }
        }
        return list;
    }
}

