/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.resolver;

import fr.jayasoft.ivy.repository.vfs.VfsRepository;
import fr.jayasoft.ivy.resolver.RepositoryResolver;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VfsResolver
extends RepositoryResolver {
    private static Pattern URLPattern = Pattern.compile("[a-z]*://(.+):(.+)@.*");
    private static int PASSWORD_GROUP = 2;

    public VfsResolver() {
        this.setRepository(new VfsRepository());
    }

    public String getTypeName() {
        return "vfs";
    }

    public String hidePassword(String name) {
        return VfsResolver.prepareForDisplay(name);
    }

    public static String prepareForDisplay(String name) {
        StringBuffer s = new StringBuffer(name);
        Matcher m = URLPattern.matcher(s);
        if (m.matches()) {
            String password = m.group(PASSWORD_GROUP);
            int passwordposi = s.indexOf(password);
            StringBuffer stars = new StringBuffer(password);
            for (int posi = 0; posi < password.length(); ++posi) {
                stars.setCharAt(posi, '*');
            }
            String replacement = stars.toString();
            s = s.replace(passwordposi, passwordposi + password.length(), replacement);
        }
        return s.toString();
    }
}

