/*
 * Decompiled with CFR 0.152.
 */
package org.jayasoft.ivyde.eclipse.ui.console;

import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.util.MessageImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.jayasoft.ivyde.eclipse.IvyPlugin;
import org.jayasoft.ivyde.eclipse.ui.console.ConsoleDocument;
import org.jayasoft.ivyde.eclipse.ui.console.IvyConsoleFactory;

public class IvyConsole
extends MessageConsole
implements MessageImpl {
    private MessageConsoleStream[] streams = new MessageConsoleStream[5];
    private ConsoleDocument document;
    private boolean initialized;
    private boolean visible;
    private boolean showOnMessage;
    private IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();

    public IvyConsole() {
        super("Ivy", IvyPlugin.getImageDescriptor("icons/logo16x16.gif"));
        this.document = new ConsoleDocument();
        Message.init((MessageImpl)this);
    }

    public void endProgress(String msg) {
    }

    public void progress() {
    }

    public void log(String msg, int level) {
        this.appendLine(level, msg);
    }

    public void rawlog(String msg, int level) {
        this.appendLine(level, msg);
    }

    protected void init() {
        super.init();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IvyConsole.this.initializeStreams();
                IvyConsole.this.dump();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeStreams() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            if (!this.initialized) {
                int i = 0;
                while (i < 5) {
                    this.streams[i] = this.newMessageStream();
                    ++i;
                }
                Color color = this.createColor(Display.getDefault(), "org.jayasoft.ivyde.eclipse.console.color.debug");
                this.streams[4].setColor(color);
                color = this.createColor(Display.getDefault(), "org.jayasoft.ivyde.eclipse.console.color.verbose");
                this.streams[3].setColor(color);
                color = this.createColor(Display.getDefault(), "org.jayasoft.ivyde.eclipse.console.color.info");
                this.streams[2].setColor(color);
                color = this.createColor(Display.getDefault(), "org.jayasoft.ivyde.eclipse.console.color.warn");
                this.streams[1].setColor(color);
                color = this.createColor(Display.getDefault(), "org.jayasoft.ivyde.eclipse.console.color.error");
                this.streams[0].setColor(color);
                this.initialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            this.visible = true;
            ConsoleDocument.ConsoleLine[] lines = this.document.getLines();
            int i = 0;
            while (i < lines.length) {
                ConsoleDocument.ConsoleLine line = lines[i];
                this.appendLine(line.type, line.line);
                ++i;
            }
            this.document.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLine(int level, String line) {
        this.showConsole();
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            if (this.visible) {
                this.streams[level].println(line);
            } else {
                this.document.appendConsoleLine(level, line);
            }
        }
    }

    private void showConsole() {
        this.show(false);
    }

    private Color createColor(Display display, String preference) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)IvyPlugin.getDefault().getPreferenceStore(), (String)preference);
        if (rgb == PreferenceConverter.COLOR_DEFAULT_DEFAULT) {
            if ("org.jayasoft.ivyde.eclipse.console.color.debug".equals(preference)) {
                rgb = new RGB(180, 180, 255);
            } else if ("org.jayasoft.ivyde.eclipse.console.color.verbose".equals(preference)) {
                rgb = new RGB(50, 150, 50);
            } else if ("org.jayasoft.ivyde.eclipse.console.color.warn".equals(preference)) {
                rgb = new RGB(255, 80, 20);
            } else if ("org.jayasoft.ivyde.eclipse.console.color.error".equals(preference)) {
                rgb = new RGB(255, 0, 0);
            }
        }
        return new Color((Device)display, rgb);
    }

    public void show(boolean showNoMatterWhat) {
        if (showNoMatterWhat || this.showOnMessage) {
            if (!this.visible) {
                IvyConsoleFactory.showConsole();
            } else {
                this.consoleManager.showConsoleView((IConsole)this);
            }
        }
    }

    public class MyLifecycle
    implements IConsoleListener {
        public void consolesAdded(IConsole[] consoles) {
            int i = 0;
            while (i < consoles.length) {
                IConsole console = consoles[i];
                if (console == IvyConsole.this) {
                    IvyConsole.this.init();
                }
                ++i;
            }
        }

        public void consolesRemoved(IConsole[] consoles) {
            int i = 0;
            while (i < consoles.length) {
                IConsole console = consoles[i];
                if (console == IvyConsole.this) {
                    ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener((IConsoleListener)this);
                    IvyConsole.this.dispose();
                }
                ++i;
            }
        }
    }
}

