/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine;

import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.IClassAnalysisEngine;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.MissingClassException;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import edu.umd.cs.findbugs.classfile.analysis.ClassData;
import edu.umd.cs.findbugs.io.IO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ClassDataAnalysisEngine
implements IClassAnalysisEngine {
    public Object analyze(IAnalysisCache analysisCache, ClassDescriptor descriptor) throws CheckedAnalysisException {
        ICodeBaseEntry codeBaseEntry;
        String resourceName = descriptor.toResourceName();
        try {
            codeBaseEntry = analysisCache.getClassPath().lookupResource(resourceName);
        }
        catch (ResourceNotFoundException e) {
            throw new MissingClassException(descriptor, (Throwable)e);
        }
        int length = codeBaseEntry.getNumBytes();
        ByteArrayOutputStream byteSink = length >= 0 ? new ByteArrayOutputStream(length) : new ByteArrayOutputStream();
        InputStream in = null;
        try {
            in = codeBaseEntry.openResource();
            IO.copy(in, byteSink);
        }
        catch (IOException e) {
            throw new MissingClassException(descriptor, (Throwable)e);
        }
        finally {
            if (in != null) {
                IO.close(in);
            }
        }
        byte[] data = byteSink.toByteArray();
        return new ClassData(descriptor, codeBaseEntry, data);
    }

    public void registerWith(IAnalysisCache analysisCache) {
        analysisCache.registerClassAnalysisEngine(ClassData.class, this);
    }

    public boolean retainAnalysisResults() {
        return false;
    }

    public /* synthetic */ Object analyze(IAnalysisCache x0, Object x1) throws CheckedAnalysisException {
        return this.analyze(x0, (ClassDescriptor)x1);
    }
}

