/*

Copyright (C) 2000 - 2007 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_recent_h
#define __nd_recent_h

#include <gtk/gtk.h>

#define NUM_RECENT 5

/**
 * nd_recent_init - initializes recently-used-files management.
 *
 * The function initializes everything needed to keep track of the
 * trace files recently used, such as the menu items in the File
 * menu.
 */
void nd_recent_init(void);

/**
 * nd_recent_reload_entries - updates recently-used items.
 *
 * The function updates the menu items in the File menu to
 * the current preference settings.
 */
void nd_recent_reload_entries(void);

/**
 * nd_recent_add_file - adds a file to the recently-used list.
 * @filename: filename to add.
 *
 * The function adds @filename to the list of recently-used
 * files.
 */
void nd_recent_add_file(const char *filename);

/**
 * nd_recent_load - loads a recently-used trace.
 * @index: index of recently used file.
 *
 * The function takes the @index-th recent file and loads
 * it.
 */
void nd_recent_load(int index);

#endif
