'''OpenGL extension ATI.envmap_bumpmap

Overview (from the spec)
	
	This extension adds environment mapped bump mapping (EMBM) to the GL.
	The method exposed by this extension is to use a dependent texture
	read on a bumpmap (du,dv) texture to offset the texture coordinates
	read into a map on another texture unit.  This (du,dv) offset is also 
	rotated through a user-specified rotation matrix to get the texture 
	coordinates into the appropriate space.
	
	A new texture format is introduced in order for specifying the (du,dv)
	bumpmap texture.  This map represents -1 <= du,dv <= 1 offsets to
	be applied to the texture coordinates used to read into the base
	map.  Additionally, the (du,dv) offsets are transformed by a rotation
	matrix that this extension allows the user to specify.  Further, a 
	new color operation is added to EXT_texture_env_combine to specify 
	both that bumpmapping is enabled and which texture unit to apply 
	the bump offset to.  

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/ATI/envmap_bumpmap.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_ATI_envmap_bumpmap'
GL_BUMP_ROT_MATRIX_ATI = constant.Constant( 'GL_BUMP_ROT_MATRIX_ATI', 0x8775 )
GL_BUMP_ROT_MATRIX_SIZE_ATI = constant.Constant( 'GL_BUMP_ROT_MATRIX_SIZE_ATI', 0x8776 )
GL_BUMP_NUM_TEX_UNITS_ATI = constant.Constant( 'GL_BUMP_NUM_TEX_UNITS_ATI', 0x8777 )
GL_BUMP_TEX_UNITS_ATI = constant.Constant( 'GL_BUMP_TEX_UNITS_ATI', 0x8778 )
GL_DUDV_ATI = constant.Constant( 'GL_DUDV_ATI', 0x8779 )
GL_DU8DV8_ATI = constant.Constant( 'GL_DU8DV8_ATI', 0x877A )
GL_BUMP_ENVMAP_ATI = constant.Constant( 'GL_BUMP_ENVMAP_ATI', 0x877B )
GL_BUMP_TARGET_ATI = constant.Constant( 'GL_BUMP_TARGET_ATI', 0x877C )
glTexBumpParameterivATI = platform.createExtensionFunction( 
	'glTexBumpParameterivATI', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, arrays.GLintArray,),
	doc = 'glTexBumpParameterivATI( GLenum(pname), GLintArray(param) ) -> None',
	argNames = ('pname', 'param',),
)

glTexBumpParameterfvATI = platform.createExtensionFunction( 
	'glTexBumpParameterfvATI', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, arrays.GLfloatArray,),
	doc = 'glTexBumpParameterfvATI( GLenum(pname), GLfloatArray(param) ) -> None',
	argNames = ('pname', 'param',),
)

glGetTexBumpParameterivATI = platform.createExtensionFunction( 
	'glGetTexBumpParameterivATI', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, arrays.GLintArray,),
	doc = 'glGetTexBumpParameterivATI( GLenum(pname), GLintArray(param) ) -> None',
	argNames = ('pname', 'param',),
)

glGetTexBumpParameterfvATI = platform.createExtensionFunction( 
	'glGetTexBumpParameterfvATI', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLenum, arrays.GLfloatArray,),
	doc = 'glGetTexBumpParameterfvATI( GLenum(pname), GLfloatArray(param) ) -> None',
	argNames = ('pname', 'param',),
)


def glInitEnvmapBumpmapATI():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
