<?php
/*
 * Copyright 2005 - 2009  Zarafa B.V.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3, 
 * as published by the Free Software Foundation with the following additional 
 * term according to sec. 7:
 *  
 * According to sec. 7 of the GNU Affero General Public License, version
 * 3, the terms of the AGPL are supplemented with the following terms:
 * 
 * "Zarafa" is a registered trademark of Zarafa B.V. The licensing of
 * the Program under the AGPL does not imply a trademark license.
 * Therefore any rights, title and interest in our trademarks remain
 * entirely with us.
 * 
 * However, if you propagate an unmodified version of the Program you are
 * allowed to use the term "Zarafa" to indicate that you distribute the
 * Program. Furthermore you may use our trademarks where it is necessary
 * to indicate the intended purpose of a product or service provided you
 * use it in accordance with honest practices in industrial or commercial
 * matters.  If you want to propagate modified versions of the Program
 * under the name "Zarafa" or "Zarafa Server", you may only do so if you
 * have a written permission by Zarafa B.V. (to acquire a permission
 * please contact Zarafa at trademark@zarafa.com).
 * 
 * The interactive user interface of the software displays an attribution
 * notice containing the term "Zarafa" and/or the logo of Zarafa.
 * Interactive user interfaces of unmodified and modified versions must
 * display Appropriate Legal Notices according to sec. 5 of the GNU
 * Affero General Public License, version 3, when you propagate
 * unmodified or modified versions of the Program. In accordance with
 * sec. 7 b) of the GNU Affero General Public License, version 3, these
 * Appropriate Legal Notices must retain the logo of Zarafa or display
 * the words "Initial Development by Zarafa" if the display of the logo
 * is not reasonably feasible for technical reasons."
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

?>
<?php

function getDialogTitle() {
	return _("Attachments");
}

function getJavaScript_onload(){ ?>
					if(parentwindow.module) {
						var filelist = dhtml.getElementById("filelist");
						
						/**
						 * NOTE: We do not want to send attachments of original mail
						 * when we are replying to that mail. But new attachments 
						 * can be sent with that mail.
						 */						
						if (parentwindow.module && parentwindow.module.messageAction){ 
							if (parentwindow.module.messageAction == "reply" || parentwindow.module.messageAction == "replyall"){
								parentwindow.module.attachments = "";
							}
						}
						
						var deletedattachments = new Object();
						
						<?
							if(isset($_SESSION["deleteattachment"]) && isset($_SESSION["deleteattachment"][$_REQUEST["dialog_attachments"]])) {
								foreach($_SESSION["deleteattachment"][$_REQUEST["dialog_attachments"]] as $attach_num)
								{
						?>
							deletedattachments["<?=$attach_num?>"] = "deleted";
						<?
								}
							}
						?>
						
						var attachments = parentwindow.module.attachments;
						for(var i = 0; i < attachments.length; i++)
						{
							var attachment = attachments[i];
							
							if(typeof(deletedattachments[attachment["attach_num"]]) == "undefined" && !attachment["hidden"] && (typeof parentwindow.module.inlineimages[attachment["attach_num"]] == "undefined")) {
								var option = dhtml.addElement(filelist, "option");
								option.value = attachment["attach_num"];
								option.text = attachment["name"];
							}
						}

						var newattachments = new Array();
						<?
							if(isset($_SESSION["files"]) && isset($_SESSION["files"][$_REQUEST["dialog_attachments"]])) {
								foreach($_SESSION["files"][$_REQUEST["dialog_attachments"]] as $tmpname => $file)
								{
								
						?>
							var tmpname = "<?=rawurlencode($tmpname)?>";
							// Show attachment if it is not an inline attachment.
							if (typeof(parentwindow.module.inlineimages[tmpname]) == "undefined"){
								var option = dhtml.addElement(filelist, "option", "attachmentsourcetype_<?=($file['sourcetype'])?$file['sourcetype']:'default'?>");
								option.value = "<?=rawurlencode($tmpname)?>";
								option.text = "<?=windows1252_to_utf8($file["name"])?>";
								
								var attachment = new Object();
								attachment["attach_num"] = "<?=rawurlencode($tmpname)?>"
								attachment["name"] = "<?=windows1252_to_utf8($file["name"])?>";
								attachment["size"] = <?=$file["size"]?>;
								attachment["filetype"] = "<?=$file["type"]?>";
								
								newattachments.push(attachment);
							}
						<?
								}
							}
						?>
						
						/** 
						 * We cannot set the list of attachments directly into the property of the 
						 * module in the parentwindow. If we would do this we would not set a copy, 
						 * but rather set a reference to the lists in this dialog. After closing 
						 * this window the references will point to non-existing objects. Therefor 
						 * we will use the setAttachmentData function to de-reference (read: clone)
						 * the objects first before setting them in the module. This has to be done 
						 * in the module itself.
						 */
						parentwindow.module.setAttachmentData(newattachments, deletedattachments);
						parentwindow.module.setAttachments();
						// Set inline options after attachment is loaded.
						parentwindow.module.setAttachmentbarAttachmentOptions();
					}
					webclient.menu.showMenu();
<?php } // getJavaScript_onload						

function getBody(){ ?>
		<div id="attachments">
			<form id="upload" action="<?=$_SERVER["REQUEST_URI"]?>" method="POST" enctype="multipart/form-data">
<?php
	$htmloutput = '';
	$GLOBALS['PluginManager']->triggerHook("server.dialog.attachments.setup.getbody.uploadformhtml", array( "html" => &$htmloutput ));
	echo $htmloutput;
?>
				<fieldset>
					<legend><?=_("Add attachments")?></legend>
					<dl>
						<dt><label for="attachment"><?=_("Filename")?>:</label></dt>
						<dd><input type="file" id="attachment" name="attachments[]" onchange="dhtml.getElementById('upload').submit();" /></dd>
						<dd> (<?= _("max filesize") ?>: <?= getMaxUploadSize(true) ?>)</dd>
					</dl>
	
					<input type="hidden" name="MAX_FILE_SIZE" value="<?= getMaxUploadSize(false) ?>" />
					<input type="hidden" name="dialog_attachments" value="<?=$_REQUEST["dialog_attachments"]?>" />
				</fieldset>
			</form>

			<fieldset id="files">
				<legend><?=_("Files currently attached")?></legend>
				<form id="action" action="<?=$_SERVER["REQUEST_URI"]?>" method="POST">
					<div>
						<div class="filelist">
							<select id="filelist" size="10" onchange="attachmentSelect();"></select>
						</div>
						<div class="attach_buttons">
								<input id="delete" class="button_delete" type="button" value="<?=_("Delete")?>" title="<?=_("Delete selected file")?>" onclick="dhtml.getElementById('action').submit();" /><br/>
								<input id="save" class="button_save" type="button" value="<?=_("Download")?>" title="<?=_("Download selected file")?>" onclick="location.href='index.php?load=download_attachment&store=<?=htmlentities($_GET["store"])?>&entryid=<?=htmlentities($_GET["entryid"])?>&attachNum[]=' + dhtml.getElementById('filelist').options[dhtml.getElementById('filelist').selectedIndex].value + '&openType=attachment&dialog_attachments=<?=htmlentities($_REQUEST["dialog_attachments"])?>'" />
								<input type="hidden" name="dialog_attachments" value="<?=$_REQUEST["dialog_attachments"]?>" />
								<input id="deleteattachment" type="hidden" name="deleteattachment" value="" />
								<input id="type" type="hidden" name="type" value="" />
						</div>
					</div>
				</form>
			</fieldset>
			
			<?=createCloseButton("window.close();")?>
		</div>
<?php } // getBody
?>
