<?php // -*- coding:utf-8 -*-
// Parameters:

// lang=xx    : only tranlates language 'xx',
//              if not given all languages are translated

// comments   : generate all comments (equal to close&module)

// close      : look for similar strings that are already translated and
//              generate a comment if a 'match' is made

// module     : generate comments that describe in which .php and/or .tpl
//              module(s) a certain string was found (useful for checking
//              translations in context)

// patch      : looks for the file 'language.patch' in the same directory
//              as the corresponding language.php and overrides any strings
//              in language.php - good if a user does not agree with
//              some translations or if only changes are sent to the maintainer

// spelling   : generates a file 'spellcheck_me.txt' that contains the
//              words used in the translation. It is then easy to check this
//              file for spelling errors (corrections must be done in
//              'language.php, however)

// groupwrite : Sets the generated files permissions to allow the generated
//              language.php also be group writable. This is good for
//              translators if they do not have root access to tiki but
//              are in the same group as the webserver. Please remember
//              to have write access removed when translation is finished
//              for security reasons. (Run script again without this
//              parameter)

// Examples:
// http://www.neonchart.com/get_strings.php?lang=sv
// Will translate language 'sv' and (almost) avoiding comment generation

// http://www.neonchart.com/get_strings.php?lang=sv&comments
// Will translate language 'sv' and generate all possible comments.
// This is the most usefull mode when working on a translation.

// http://www.neonchart.com/get_strings.php?lang=sv&nohelp&nosections
// These options will only provide the minimal amout of comments.
// Usefull mode when preparing a translation for distribution.

// http://www.neonchart.com/get_strings.php?nohelp&nosections
// Prepare all languages for release 


$lang=Array(
// ### Start of unused words
// ### Please remove manually!
// ### N.B. Legitimate strings may be marked// ### as unused!
// ### Please see http://tikiwiki.org/tiki-index.php?page=UnusedWords for further info
"Enable Smarty Security (e.g. do not allow php code in smarty templates)" => "Smarty Sicherheit aktivieren (z.B. keinen PHP-Code in Smarty Templates erlauben)",
"Tip: hold down CTRL to select multiple categories" => "Tip: Strg halten um mehrere Kategorien auszuw&auml;hlen",
"Tip: uncheck the above checkbox to uncategorize this page/object" => "Tip: die Checkbox deaktivieren um die Kategorien dieser Seite/dieses Objekts zu entfernen",
"from\r\nthe mapfile:" => "aus\r\nder Kartendatei:",
"reply to" => "Antwort auf",
"WARNING : Old and New trackers cannot coexist. Trackers created with new library\r\nwill not work with old library and conversely" => "WARNUNG: Alte und Neue Tracker k&ouml;nnen nicht parallel existieren. Tracker die mit der neuen Bibliothek erstellt wurden, funktionieren nicht mit der alten Bibliothek und andersherum.",
"Field is public? (for use thru trackerlist plugin)" => "Feld &ouml;ffentlich? (f&uuml;r Nutzung &uuml;ber das TrackerList-PlugIn)",
"use ...page... to separate pages" => "Benutze ...page... um Seiten in mehrere zu untergliedern",
"cms" => "Artikel",
"Your message has been queued for approval, the message will be posted after\r\na moderator approves it." => "Ihre Nachricht wurde in die Warteschlange f&uuml;r Best&auml;stigungen eingereiht. Sie wird angezeigt, sobald sie ein Moderator freigegeben hat.",
"comm" => "Schnittstellen",
"community" => "Community",
"content templates" => "Inhaltsvorlagen",
"drawings" => "Zeichnungen",
"file galleries" => "Dateiarchive",
"freetags" => "Freetags",
"html pages" => "HTML-Seiten",
"image galleries" => "Bildergalerien",
"maps" => "Karten",
"messu" => "Nachrichten",
"newsletters" => "Rundbriefe",
"sheet" => "Tiki Sheets",
"shoutbox" => "Shoutbox",
"tiki" => "Tiki",
"support" => "Online-Support",
"surveys" => "Umfragen",
"workflow" => "Workflow",
"webmail" => "Webmail",
"Removed version" => "Version gel&ouml;scht",
"Renamed" => "Umbenannt",
"Updated" => "Aktualisiert",
"Viewed" => "Angesehen",
"Posted" => "Erstellt",
"Downloaded" => "Heruntergeladen",
"Admin mods" => "MODs verwalten",
"File %s uploaded successfully." => "Datei %s erfolgreich hochgeladen.",
"usernames separated with ;" => "mehrere Benutzernamen mit Semikolon ; trennen",
"uploaded by" => "hochgeladen von",
"not specified" => "nicht definiert",
"The file you are trying to upload is too big." => "Die hochgeladene Datei ist zu gro&szlig;.",
"Invalid remote file on url %s" => "Ung&uuml;tige Datei unter %s",
"%A %d of %B, %Y" => "%A %d im %B, %Y",
"%A %d of %B, %Y[%H:%M:%S %Z]" => "%A %d im %B, %Y[%H:%M:%S %Z]",
"%a %d of %b, %Y" => "%a %d im %b, %Y",
"%a %d of %b, %Y[%H:%M %Z]" => "%a %d im %b, %Y[%H:%M %Z]",
"name" => "Name",
"delete" => "l&ouml;schen",
"post" => "Eintrag",
"stop monitoring this blog" => "diesen Blog nicht mehr beobachten",
"posts" => "Eintr&auml;ge",
"visits" => "Besuche",
"show categories" => "Kategorien zeigen",
"author" => "Autor",
"user level" => "Benutzerlevel",
"send email to user" => "eMail an Benutzer schicken",
"score" => "Punkte",
"delete selected" => "markierte l&ouml;schen",
"move" => "verschieben",
"Posted messages" => "gepostete Beitr&auml;ge",
"set" => "Ok",
"replies" => "Antworten",
"new reply" => "neue Antwort",
"preview" => "Vorschau",
"cancel" => "abbrechen",
"up" => "rauf",
"down" => "runter",
"add" => "hinzuf&uuml;gen",
"hits" => "Zugriffe",
"stop monitoring this map" => "diese Karte nicht mehr beobachten",
"create" => "hinzuf&uuml;gen",
"save" => "Speichern",
"send" => "verschicken",
"Hide module contents" => "Modul auf-/zuklappen",
"remove" => "entfernen",
"Last visitors" => "Letzte Besucher",
"register" => "Registrieren",
"standard" => "Standard",
"secure" => "sicher",
"stay in ssl mode" => "In SSL-Modus bleiben",
"new messages" => "neue Nachrichten",
"new message" => "neue Nachricht",
"go" => "los",
"cache" => "Cache",
"use" => "benutzen",
"cached" => "gecached",
"refresh" => "aktualisieren",
"print" => "drucken",
"create pdf" => "PDF erstellen",
"monitor this page" => "diese Seite beobachten",
"stop monitoring this page" => "diese Seite nicht mehr beobachten",
"backlinks" => "Verweise",
"click here" => "hier klicken",
"rename" => "umbenennen",
"unlock" => "entsperren",
"lock" => "sperren",
"perms" => "Berecht.",
"history" => "Historie",
"similar" => "&auml;hnlich",
"undo" => "r&uuml;ckg&auml;ngig",
"slides" => "Dias",
"export" => "exportieren",
"discuss" => "diskutieren",
"add comment" => "kommentieren",
"attach file" => "Datei anh&auml;ngen",
"translation" => "&Uuml;bersetzung",
"last modification" => "letzte &Auml;nderung",
"attachments" => "Anh&auml;nge",
"stats" => "Statistiken",
"last changes" => "zuletzt ge&auml;ndert",
"list pages" => "Seiten auflisten",
"back to homepage" => "Zur&uuml;ck zur Startseite",
"cancel edit" => "Bearbeitung verwerfen",
"No attachments for this page" => "Keine Anh&auml;nge f&uuml;r diese Seite",
"view blog" => "Blog betrachten",
"list blogs" => "Blogs auflisten",
"save and exit" => "Speichern und verlassen",
"reads" => "Zugriffe",
"view comments" => "Kommentare ansehen",
"Click here to create it" => "Zum Anlegen hier klicken",
"wiki help" => "Wiki Hilfe",
"General preferences" => "Allgemeine Einstellungen",
"Other preferences" => "Sonstige Einstellungen",
"flag" => "Kennzeichen",
"Change information" => "Einstellungen &uuml;bernehmen",
"ok" => "OK",
"new window" => "neues Fenster",
"Best language" => "Beste Sprache",
"PodCast directory (must be web accessable):" => "PodCast Verzeichnis (mu&szlig; per Browser erreichbar sein):",
"If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload filed in that dir, either by scp, ftp, or other protocols" => "Wenn 'Batch-Upload aus Verzeichnis' aktiviert wird mu&szlig; ein vom Webserver lesbares Verzeichnis benutzt werden (am besten au&szlig;erhalb des Webspace). Dorthin m&uuml;ssen die Dateien dann mit scp, ftp o.&auml;. &uuml;bertragen werden.",
"Enable cache images to all galleries" => "Bildercache f&uuml;r alle Galerien aktivieren",
"Images cache directory" => "Bildercache-Verzeichnis",
"images" => "Bilder",
"PHP error reporting level:" => "PHP Fehler Ausgabelevel:",
"Report PHP errors only for admin" => "Alle PHP Fehler nur f&uuml;r Admin ausgeben",
"Server name (for absolute URIs)" => "Servername (f&uuml;r absolute URIs)",
"Automatic (uses HTTPS variable)" => "Automatisch (benutzt HTTPS Variable)",
"Wiki_Tiki_Title" => "Wiki_Tiki_Titel",
"path" => "Pfad",
"groups" => "Gruppen",
"Admin->Features" => "Admin->Funktionen",
"must be turned on and notification is sent to the admin's" => "mu&szlig; aktiviert sein, Nachrichten an Admin geht an seine",
"inter-user message inbox" => "Tiki Mailbox",
"Validate email address (may not work)" => "eMail-Adresse &uuml;berpr&uuml;fen (funktioniert evtl. nicht)",
"Require HTTP Basic authentication" => "HTTP-Basic-Authentication notwendig",
"HTTP server name" => "HTTP-Servername",
"HTTP URL prefix" => "HTTP-URL-Pr&auml;fix",
"HTTPS server name" => "HTTPS-Servername",
"HTTPS URL prefix" => "HTTPS-URL-Pr&auml;fix",
"Only for users" => "Nur f&uuml;r Benutzer",
"Users and admins" => "Benutzer und Admins",
"Database search" => "Datenbanksuche",
"Full Text Search" => "Volltextsuche",
"Database independant search or Tiki search" => "Unabh&auml;ngige Datenbanksuche oder Tiki Suche",
"Don't forget: to use feature you will need to enable it on" => "Hinweis: Um dieses Feature zu nutzen, aktivieren Sie es unter",
"Custom Code" => "Angepasster Code",
"Site breadcrumbs" => "Site Breadcrumbs",
"Site search bar" => "Balken f&uuml;r Site Suche",
"Site logo" => "Site-Logo",
"Site logo source" => "Site Logo Quelle",
"Site ads and banners" => "Site Werbung und Banner",
"Site Menu" => "Site Men&uuml;",
"Note: This feature also requires phplayers to be turned on in Admin->Features" => "Hinweis: Um dieses Feature verwenden zu k&ouml;nnen, m&uuml;ssen PHPLayer unter Admin->Funkionen",
"change" => "&auml;ndern",
"Manage attachment preferences" => "Einstellungen f&uuml;r Anh&auml;nge verwalten",
"HTML in Wiki Pages" => "HTML in Wiki Seiten",
"Wiki syntax used when a page contains HTML" => "Wiki Syntax benutzen wenn Seite HTML enth&auml;lt",
"full" => "voll",
"partial" => "teilweise",
"Search and replace" => "Suchen und ersetzen",
"Enable Feature" => "Funktion einschalten",
"loc" => "Ort",
"participants" => "Teilnehmer",
"cat" => "Kateg.",
"lang" => "Sprache",
"prio" => "Prio",
"subscription" => "Abonnement",
"permissions" => "Berechtigungen",
"admin categories" => "Kategorien verwalten",
"create new" => "erstelle neu",
"edit chart" => "Hitliste bearbeiten",
"update" => "aktualisieren",
"admin content templates" => "Inhaltsvorlagen verwalten",
"use in cms" => "Im CMS benutzen",
"use in wiki" => "In Wikis benutzen",
"use in newsletters" => "In Newslettern benutzen",
"use in HTML pages" => "In HTML-Seiten benutzen",
"last modif" => "letzte &Auml;nderung",
"sections" => "Bereiche",
"admin FortuneCookie" => "Spr&uuml;che verwalten",
"upload" => "Hochladen",
"dsn" => "DSN",
"Edit existing forums" => "Vorhandene Foren bearbeiten",
"avatar" => "Avatar",
"topics" => "Themen",
"coms" => "Kommentare",
"age" => "Alter",
"ppd" => "PPT",
"last post" => "Neuester Eintrag",
"admin hotwords" => "Hotwords verwalten",
"list repositories" => "Repositories auflisten",
"new repository" => "Neues Repository",
"view repository" => "Repository anschauen",
"view this repository" => "Repository ansehen",
"new rule" => "neue Regeln",
"admin featured links" => "Linktips verwalten",
"url" => "URL",
"position" => "Position",
"admin Webmail" => "Webmail verwalten",
"section" => "Bereich",
"sorted section" => "Sortierter Bereich",
"options" => "Optionen",
"admin modules" => "Module verwalten",
"assign module" => "Modul zuweisen",
"left modules" => "Module links",
"right modules" => "Module rechts",
"edit/create" => "hinzuf&uuml;gen/bearbeiten",
"clear cache" => "Cache leeren",
"assign" => "zuweisen",
"left" => "links",
"right" => "rechts",
"order" => "Reihenfolge",
"rows" => "Zeilen",
"parameters" => "Parameter",
"create/edit" => "hinzuf&uuml;gen/bearbeiten",
"use poll" => "Abstimmung benutzen",
"use gallery" => "Galerie benutzen",
"use dynamic  content" => "Dynamischen Inhaltsblock benutzen",
"use rss module" => "RSS-Modul benutzen",
"use menu" => "Men&uuml; benutzen",
"use phplayermenu" => "PHPLayerMen&uuml; benutzen",
"use banner zone" => "Bannerzone benutzen",
"list newsletters" => "Newsletter auflisten",
"admin newsletters" => "Newsletter verwalten",
"send newsletters" => "Newsletter versenden",
"editions" => "Ausgaben",
"last sent" => "zuletzt gesendet",
"send newsletter" => "Newsletter versenden",
"admin Email Notifications" => "Mail-Benachrichtigungen verwalten",
"use admin email" => "Admin eMail benutzen",
"event" => "Termin",
"admin polls" => "Abstimmungen verwalten",
"admin QuickTags" => "QuickTags verwalten",
"label" => "Beschriftung",
"admin RSS modules" => "RSS-Module verwalten",
"admin shoutbox words" => "Shoutbox Words Verwaltung",
"export pages" => "Seiten exportieren",
"dump tree" => "Baum ausgeben",
"create webhelp" => "Web-Hilfe erstellen",
"tree" => "Baum",
"create new structure" => "neue Struktur anlegen",
"survey stats" => "Umfragen-Statistik",
"edit this survey" => "Diese Umfrage bearbeiten",
"admin surveys" => "Umfragen verwalten",
"list surveys" => "Umfragen auflisten",
"questions" => "Fragen",
"files" => "Dateien",
"advanced feature" => "Funktion f&uuml;r Fortgeschrittene",
"Edit fields for tracker" => "Felder bearbeiten von Tracker",
"items" => "Eintr&auml;ge",
"The tracker needs a text field named Subject" => "Der Tracker mu&szlig; ein Eingabefeld 'Subject' besitzen (auch f&uuml;r RSS Feed n&ouml;tig)",
"version" => "Version",
"admin groups" => "Gruppen verwalten",
"assign permissions" => "Berechtigungen vergeben",
"admin" => "Verwalten",
"admin users" => "Benutzer verwalten",
"more criteria" => "Erweiterte Suchoptionen",
"assign to groups" => "zu Gruppen hinzuf&uuml;gen",
"all" => "alle",
"Assign user" => "Benutzer zuweisen",
"to groups" => "zu Gruppen",
"Available groups" => "Verf&uuml;gbare Gruppen",
"assign perms to this group" => "dieser Gruppe Rechte zuweisen",
"admin backups" => "Backups verwalten",
"List of available backups" => "Liste der verf&uuml;gbaren Backups",
"Restoring a backup" => "Einen Backup wiederherstellen",
"Warning!" => "Warnung!",
"Restoring a backup destoys all the data in your Tiki database. All your tables will be replaced with the information in the backup." => "Das Wiederherstellen eines Backups zert&ouml;rt alle bisherigen Daten in Ihrer Tiki Datenbank. Die Information in allen Tabellen wird durch das Backup ersetzt.",
"Click here to confirm restoring" => "Hier klicken, um den Start der Wiederherstellung zu best&auml;tigen",
"Create new backup" => "Neues Backup anlegen",
"Creating backups may take a long time. If the process is not completed you will see a blank screen. If so you need to increment the maximum script execution time from your php.ini file" => "Das Erstellen von Backups kann lange Zeit dauern. Falls der Prozess nicht abgeschlossen werden kann werden Sie einen blanken Bildschirm sehen. Falls dies der Fall ist m&uuml;ssen Sie den Parameter 'maximum script execution time' in Ihrer php.ini Datei erh&ouml;hen",
"If any of your forums have attachments stored in the directory you will need to backup these using FTP or SCP." => "Sollten Anh&auml;nge aus dem Forum im Verzeichnis gespeichert sein, m&uuml;ssen diese per FTP oder SCP gesichert werden.",
"Upload a backup" => "Ein Backup hochladen",
"Upload backup" => "Backup hochladen",
"remove file extension from image name" => "Dateiendung im Namensfeld entfernen",
"convert sub directories to sub galleries" => "Unterverzeichnisse in Unter-Galerien konvertieren",
"eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named screenshots will be created" => "z.B. wird bei \"misc/screenshots/digicam0001.jpg\" das Bild in die Galerie screenshots gesteckt",
"use sub directory names as description" => "Namen von Unterverzeichnissen als Beschreibung verwenden",
"eg. from \"misc/screenshots/digicam0001.jpg\" a description misc/screenshots will be created" => "z.B. wird von \"misc/screenshots/digicam0001.jpg\" der Text misc/screenshots als Beschreibung benutzt",
"admin category" => "Kategorien verwalten",
"list galleries" => "Galerien auflisten",
"edit gallery" => "Galerie bearbeiten",
"rebuild thumbnails" => "Thumbnails neu erzeugen",
"upload image" => "Bild hochladen",
"list gallery" => "Galerie als Liste zeigen",
"hit" => "Treffer",
"original size" => "Originalgr&ouml;&szlig;e",
"return to gallery" => "zur&uuml;ck zur Galerie",
"edit image" => "Bild bearbeiten",
"smaller" => "kleiner",
"bigger" => "gr&ouml;&szlig;er",
"prev image" => "vorh. Bild",
"popup window" => "Popup-Fenster",
"next image" => "n&auml;ch. Bild",
"slideshow forward" => "Diaschau vorw&auml;rts",
"stop" => "Anhalten",
"imagescale" => "Bildskalierung",
"add item" => "Eintrag hinzuf&uuml;gen",
"Subscription List" => "Empf&auml;ngerliste",
"or create a new category" => "oder neue Kategorie anlegen",
"or create a new location" => "oder neuen Ort eintragen",
"comma separated usernames" => "Usernamen durch Komma getrennt",
"comma separated username:role" => "Komma getrennte Liste 'Teilnehmer:Rolle'",
"with roles" => "mit den Rollen",
"Chair" => "Leiter",
"save_to" => "in",
"permission" => "Berechtigung",
"remove from this category &amp; all its children" => "von dieser und allen Unterkategorien entfernen",
"remove from this category only" => "nur von dieser Kategorie entfernen",
"remove page" => "Seite entf.",
"browse" => "im Verzeichnis st&ouml;bern",
"related" => "verwandt",
"validate" => "&uuml;berpr&uuml;fen",
"add a site" => "Link hinzuf&uuml;gen",
"add a category" => "Kategorie hinzuf&uuml;gen",
"search" => "Suche",
"list articles" => "Beitr&auml;ge auflisten",
"view articles" => "Beitr&auml;ge ansehen",
"create zone" => "Zone hinzuf&uuml;gen",
"save the banner" => "das Banner speichern",
"Allow trackback pings" => "Trackback-Pings erlauben",
"try" => "ausprobieren",
"display" => "anzeigen",
"admin quicktags" => "Quicktags verwalten",
"create new block" => "Neuen Block erzeugen",
"list quizzes" => "Quiz auflisten",
"quiz stats" => "Quiz-Statistik",
"edit this quiz" => "Dieses Quiz bearbeiten",
"admin quizzes" => "Quiz verwalten",
"results" => "Ergebnisse",
"create page" => "Seite erstellen",
"list submissions" => "Einreichungen auflisten",
"save only in the theme:" => "Nur f&uuml;r diesen Style speichern:",
"add to the set" => "zur Liste hinzuf&uuml;gen",
"Search " => "Suche",
"replace" => "ersetzen",
"Admin ephemerides" => "Terminkalender verwalten",
"All ephemerides" => "Alle Termine",
"new question" => "Neue Frage",
"approve" => "akzeptieren",
"configure listing" => "Liste konfigurieren",
"create new file gallery" => "neues Dateiarchiv anlegen",
"topic" => "Thema",
"save and approve" => "speichern und freigeben",
"new topic" => "neues Thema",
"accept" => "akzeptieren",
"refuse" => "ablehnen",
"add new" => "Neu hinzuf&uuml;gen",
"add role" => "Rolle hinzuf&uuml;gen",
"admin processes" => "Prozesse verwalten",
"admin activities" => "Aktivit&auml;ten verwalten",
"admin roles" => "Rollen verwalten",
"edit this process" => "Prozess bearbeiten",
"monitor" => "&Uuml;berwachen",
"create new gallery" => "neue Galerie anlegen",
"result" => "Ergebnis",
"reload" => "Aktualisieren",
"edit repository" => "Repository bearbeiten",
"source" => "Quellcode",
"edit new article" => "neuen Artikel erstellen",
"admin Banners" => "Banner verwalten",
"create new blog" => "Neuen Blog anlegen",
"admin cache" => "Cache verwalten",
"upload file" => "Datei hochladen",
"Edit a file using this form" => "Datei &uuml;ber dieses Formular bearbeiten",
"delete selected files" => "markierte Dateien l&ouml;schen",
"browse gallery" => "Galerie anzeigen",
"Flash binary (.sqf or .dcr)" => "Flash Binary (.sqf oder .dcr)",
"edit blog" => "Blog bearbeiten",
"edit new submission" => "neue Einreichung bearbeiten",
"actions" => "Aktionen",
"set as operator" => "Als Operator hinzuf&uuml;gen",
"add topic" => "Thema hinzuf&uuml;gen",
"install" => "installieren",
"back" => "zur&uuml;ck",
"Assign permissions to page" => "Berechtigungen f&uuml;r Seite vergeben",
"These permissions override any global permissions affecting this object. To edit global permissions " => "Diese Berechtigungen &uuml;berschreiben alle globalen Berechtigungen, die auf dieses Objekt wirken. Zum &Auml;ndern der globalen Berechtigungen ",
"Current permissions for this page" => "Aktuelle Berechtigungen f&uuml;r diese Seite",
"remove from this page" => "aus dieser Seite entfernen",
"remove from this structure" => "aus dieser Struktur entfernen",
"No individual permissions; category or global permissions apply" => "Keine individuellen Berechtigungen; Kategorie oder globale Berechtigungen vergeben",
"this page" => "diese Seite",
"this structure" => "diese Struktur",
"Current permissions for categories that this page belongs to" => "Diese Seite geh&ouml;rt zu den Kategorien mit folgenden Berechtigungen",
"Send email notifications when this page changes to" => "eMail-Benachrichtigung bei Seiten&auml;nderung verschicken an",
"add email" => "eMail hinzuf&uuml;gen",
"Notifications" => "Benachrichtigungen",
"clear stats" => "Statistiken zur&uuml;cksetzen",
"Edit received page" => "Empfangene Seite bearbeiten",
"last" => "letzte",
"send me my password" => "Mein Pa&szlig;wort senden",
"searched" => "gesucht",
"galleries" => "Galerien",
"blog posts" => "Blog-Eintr&auml;ge",
"articles" => "Artikel",
"wiki pages" => "Wiki-Seiten",
"site" => "Site",
"clear" => "zur&uuml;cksetzen",
"add article" => "Artikel hinzuf&uuml;gen",
"admin Tiki Shoutbox" => "Tiki-Shoutbox verwalten",
"list view" => "Listenansicht",
"send answers" => "Antworten senden",
"move to right column" => "in die rechte Spalte verschieben",
"unassign" => "Zuordnung aufheben",
"move to left column" => "in die linke Spalte verschieben",
"remove folder" => "Ordner l&ouml;schen",
"refresh cache" => "Cache aktualisieren",
"Male" => "m&auml;nnlich",
"Female" => "weiblich",
"use google map locator" => "Google Map Locator benutzen",
"admin mode" => "Verwaltungsmodus",
"trash" => "in Papierkorb",
"empty trash" => "Papierkorb l&ouml;schen",
"remove from trash" => "aus dem Papierkorb",
"use start date and time" => "Startdatum/-zeit benutzen",
"use end date and time" => "Endedatum/-zeit benutzen",
"no comments" => "keine Kommentare",
"edit items" => "Eintr&auml;ge bearbeiten",
"list charts" => "Hitlisten anzeigen",
"last chart" => "neueste Hitliste",
"item" => "Eintrag",
"view faq" => "FAQ anzeigen",
"add suggestion" => "Vorschlag hinzuf&uuml;gen",
"monitor this forum" => "Dieses Forum beobachten",
"stop monitoring this forum" => "Beobachten dieses Forums beenden",
"delete selected topics" => "Ausgew&auml;hlte Themen l&ouml;schen",
"stop monitoring this topic" => "Beobachtung dieses Themas beenden",
"Comments below your current threshold" => "Kommentar unterhalb Ihres aktuellen Schwellenwerts",
"list attachments" => "Anh&auml;nge auflisten",
"add contacts" => "Kontakte hinzuf&uuml;gen",
"DATE-of" => "im",
"You cannot edit this page because it is a user personal page" => "Sie k&ouml;nnen diese Seite nicht bearbeiten, da es sich um eine pers&ouml;nliche Benutzer-Seite handelt.",
"Permission denied you cannot assign permissions for this page" => "Zugriff verweigert. Sie k&ouml;nnen dieser Seite keine Berechtigungen zuweisen",
"You do not have permission to edit messages" => "Sie haben keine Berechtigung, diese Nachrichten zu bearbeiten",
"Cannot read file" => "Kann Datei nicht lesen",
"Permission denied you cannot upload files" => "Berechtigung zum Hochladen von Dateien nicht vorhanden",
"cannot process upload" => "Kann Upload nicht verarbeiten",
"Your email address has been removed from the list of addresses monitoring this tracker" => "Ihre Mail-Adresse wurde von der Liste der Adressen, die diesen Tracker &uuml;berwachen entfernt",
"Your email address has been added to the list of addresses monitoring this tracker" => "Ihre Mail-Adresse wurde zu der Liste der Adressen, die diesen Tracker &uuml;berwachen hinzugef&uuml;gt",
"Cancel monitoring" => "&Uuml;berwachung beenden",
"Your email address has been removed from the list of addresses monitoring this item" => "Ihre Adresse wurde aus der Liste derer entfernt, die diesen Eintrag beobachten",
"Your email address has been added to the list of addresses monitoring this item" => "Ihre Adresse wurde zu denen hinzugef&uuml;gt, die diesen Eintrag beobachten",
"new image uploaded by" => "neue Bilder hochgeladen von",
"new subscriptions" => "neue Abonnenten",
"new item in tracker" => "Neuer Eintrag im Tracker",
"show" => "zeigen",
"hide" => "verstecken",
"message" => "Nachricht",
"Include an article" => "Artikel einbinden",
"comment" => "Kommentar",
"select all" => "alle ausw&auml;hlen",
"filter" => "filtern",
"no such file" => "Datei nicht gefunden",
"downloads" => "Downloads",
"attach" => "anh&auml;ngen",
"monitor this blog" => "diesen Blog beobachten",
"hide categories" => "Kategorien verbergen",
"Admin categories" => "Kategorien verwalten",
"browse category" => "Kategorien durchst&ouml;bern",
"reply" => "antworten",
"monitor this topic" => "Thema beobachten",
"with checked" => "markierte",
"move selected files" => "markierte Dateien verschieben",
"Thank you for you registration. You may log in now." => "Vielen Dank f&uuml;r die Registrierung. Sie k&ouml;nnen sich jetzt anmelden.",
"compare" => "vergleichen",
"diff" => "Diff",
"sender" => "Absender",
"subject" => "Betreff",
"date" => "Datum",
"flagged" => "gekennzeichnet",
"mark" => "setzen",
"find replied message" => "suche beantwortete Nachricht",
"replied" => "beantwortet",
"Click the :: options in the Menu for more options." => "",
"Please, also see" => "Bitte auch",
"for more setup details." => "f&uuml;r weitere Konfigurationsdetails anschauen.",
"Note 1:" => "Hinweis 1:",
"You can remove this module in" => "Entfernen dieses Moduls &uuml;ber",
"as well as assign or edit many others." => "wo auch andere Module zugewiesen oder erstellt werden k&ouml;nnen.",
"Note 2:" => "Hinweis 2:",
"The menu module installed by default is named" => "Das Modul mit den Standard Men&uuml;s hei&szlig;t",
"it is a \"custom module\" which includes menu ID " => "es ist ein \"editierbares Modul\", es enth&auml;lt das Men&uuml; mit der ID ",
"That menu is stored in database and it can be edited from " => "Das Men&uuml; ist in der Datenbank gespeichert und kann ge&auml;ndert werden &uuml;ber ",
"Do not mix this with the original <em>application_menu</em> module" => "Bitte nicht verwechseln mit dem <em>application_menu</em> Modul",
"That one can be heavily customized to match style used but it can be currently done only by editing mod-application_menu.tpl file \"manually\"" => "Letzteres kann an eigene Styles etc. angepa&szlig;t werden, daf&uuml;r mu&szlig; aber die Datei mod-application_menu.tpl von Hand ge&auml;ndert werden.",
"del" => "l&ouml;schen",
"Create pdf" => "PDF erstellen",
"pdf" => "PDF",
"1 file attached" => "1 angeh&auml;ngte Datei",
"Click" => "Klick",
"categories" => "Kategorien",
"List pages where I am a creator" => "Seiten auflisten, die ich erstellt habe",
"by creator" => "nach Ersteller",
"by modificator" => "nach Bearbeiter",
"at tracker" => "Bei Tracker",
"posted by" => "eingetragen von",
"email this post" => "Diesen Beitrag verschicken",
"calendar view" => "Kalenderansicht",
"check / uncheck all" => "alle (ent)markieren",
"Mandatory category in the category tree" => "Pflichtkategorie im Kategorieverzeichnis",
"Tiki sections and features" => "Tiki-Bereiche und Funktionen",
"tikiwiki.org help" => "tikiwiki.org Hilfe",
"Site Logo and Identity" => "Site-Logo und Identit&auml;t",
"Use Quote plugin rather than &ldquo;>&rdquo; for quoting" => "Quote PlugIn statt festes &ldquo;>&rdquo; beim Quoten verwenden",
"Storing files in a directory" => "Speichern von Dateien in einem Verzeichnis",
"please read" => "Bitte lesen! (klick mich)",
"yes" => "ja",
"Click here for more details." => "F&uuml;r weitere Details hier klicken.",
"Best Language" => "Beste Sprache",
"Tiki preferences value field in db is set to be max. 250 characters long by default until now. That applies for the custom code content too. Check this field if you want to update your preferences database table to support more than 250 chars (although it was tested and works fine with mysql, it's recommended to backup your data manually before any database update)" => "Die Tiki Einstellungen beschr&auml;nken die max. Zeichenl&auml;nge standardm&auml;&szlig;ig auf 250. Die trifft auch auf angepassten Code zu. Um mehr Zeichen zuzulassen, setzen Sie hier den Haken (Erstellen Sie vorher ein Backup Ihrer Datenbank!).",
"Users &amp; groups" => "Benutzer &amp; Gruppen",
"Local" => "Lokal",
"private" => "privat",
"<b>Item</b>" => "<b>Eintrag</b>",
"<b>Value</b>" => "<b>Wert</b>",
"This page is to configure settings of RSS feeds generated/exported by Tiki. To read/import RSS feeds, look for \"RSS modules\" on the application menu, or" => "Auf dieser Seite werden die RSS Feeds konfiguriert, die von Tiki erstellt und exportiert werden. Zum Einlesen/Importieren von RSS Feeds \"RSS Module\" im Men&uuml; w&auml;hlen oder",
"<b>Feed</b>" => "<strong>Feed</strong>",
"<b>enable/disable</b>" => "<strong>ein/aus</strong>",
"<b>Max number of items</b>" => "<strong>Max. Anzahl<br>Eintr&auml;ge</strong>",
"Feed for Articles" => "Feed f&uuml;r Artikel",
"Feed for Weblogs" => "Feed f&uuml;r Blogs",
"Feed for Image Galleries" => "Feed f&uuml;r Bildergalerien",
"Feed for File Galleries" => "Feed f&uuml;r Dateiarchive",
"Feed for the Wiki" => "Feed f&uuml;r Wiki-Seiten",
"Feed for individual Image Galleries" => "Feed f&uuml;r einzelne Bildergalerie",
"Feed for individual File Galleries" => "Feed f&uuml;r einzelnes Dateiarchiv",
"Feed for individual weblogs" => "Feed f&uuml;r einzelnen Blog",
"Feed for individual forums" => "Feed f&uuml;r einzelnes Forum",
"Feed for mapfiles" => "Feed f&uuml;r Kartendateien",
"Feed for directories" => "Feed f&uuml;r Verzeichnisse",
"Feed for individual tracker items" => "Feed f&uuml;r einzelne Tracker-Eintr&auml;ge",
"Feed for tracker items" => "Feed f&uuml;r Tracker-Eintr&auml;ge",
"Feed for upcoming calendar events" => "Feed f&uuml;r zuk&uuml;nftige Events",
"Caching time :" => "RSS Daten im Cache halten",
"Only enable caching if all syndicated content is public (visible to everyone) or private documents might leak out. Cache ignores existing permissions." => "Caching sollte nur f&uuml;r Inhalte aktiviert werden, die vollst&auml;ndig freigegeben sind, es k&ouml;nnten sonst private Dokumente verteilt werden. Bei Nutzung des Cache greifen die Rechteabfragen nicht.",
"Prefix breadcrumbs with 'Location:' label?" => "Pr&auml;fixe Breadcrumbs mit 'Position:'?",
"Site Search" => "Site Suche",
"Change style only" => "nur Style &auml;ndern",
"Tag name" => "Tag Name",
"Enable wiki 3D browser" => "Wiki 3D Browser aktivieren",
"Load page on navigation" => "Seite beim navigieren laden",
"Existing page node color" => "Farbe existierender Knoten",
"Missing page node color" => "Farbe fehlender Knoten",
"Anonymous editors must input anti-bot code" => "Anonyme Autoren m&uuml;ssen Anti-Robot Code eingeben",
"View source" => "Quelltext ansehen",
"MultiPrint" => "Mehrfachdruck",
"PDF generation" => "PDF-Erstellung",
"Warn on edit conflict" => "Bei Bearbeiten-Konflikt warnen",
"Edit idle timeout" => "Bearbeiten Idle-Timeout",
"Pictures" => "Bilder",
"Use page description" => "Seitenbeschreibung benutzen",
"Show page title" => "Seitentitel anzeigen",
"Show page ID" => "Seiten-ID anzeigen",
"Cache wiki pages (global)" => "Wikiseiten cachen (global)",
"Individual cache" => "Individuelle Cache",
"Footnotes" => "Fu&szlig;noten",
"Users can lock pages (if perm)" => "Benutzer kann Seiten sperren (falls berechtigt)",
"Use WikiWords" => "WikiWords benutzen",
"Accept dashes and underscores in WikiWords" => "Binde- und Unterstriche in WikiWords erlauben",
"Link plural WikiWords to their singular forms" => "Mehrzahl-WikiWords auf ihre Einzahl-Variante verlinken",
"Use Wiki paragraph formatting" => "Wiki Absatzformatierung benutzen",
"Automonospaced text" => "Blockschrift durch Einr&uuml;cken",
"Tables syntax" => "Tabellensyntax",
"Open page as structure" => "Seite als Struktur &ouml;ffnen",
"Use external link icons" => "Symbole f&uuml;r externe Links benutzen",
"User's Page" => "Benutzerseite 'UserPageNAME'",
"UserPage prefix" => "UserPage Prefix",
"Page creators are admin of their pages" => "Ersteller sind auch Verwalter ihrer Seiten",
"List authors" => "Autoren aufz&auml;hlen",
"Protect email against spam" => "eMail-Adressen vor Spam sch&uuml;tzen",
"When viewing a page, if it doesn't exist and has one like page, automatic redirection to this like page" => "Beim betrachten einer Seite, welche nicht existiert aber eine &auml;hnliche existiert, automatisch dahin umleiten",
"Show/hide heading icon displayed before the heading" => "Zeige/Verberge &Uuml;berschriftsicon vor der &Uuml;berschrift",
"Print Page" => "Seite ausdrucken",
"Maximum number of versions for history" => "Maximale Anzahl der Versionen in Historie",
"Never delete versions younger than days" => "Niemals l&ouml;schen: Versionen j&uuml;nger als",
"IP not displayed in history" => "IP nicht in der History anzeigen",
"Diff style" => "Vergleichs-Typ",
"Create watch for author on page creation" => "Beobachtungspunkt f&uuml;r Seite beim Erstellen setzen",
"Enable watch events when I am the editor" => "Beobachtungspunkt f&uuml;r Seite beim &Auml;ndern setzen",
"Enable watches on comments" => "Beobachtungspunkte auf Kommentare aktivieren",
"Statistic" => "Statistik",
"Use in CMS" => "Im CMS benutzen",
"Use in Wiki" => "In Wikis benutzen",
"Use in newsletters" => "In Newslettern benutzen",
"Use in HTML pages" => "In HTML-Seiten benutzen",
"Edit Existing Forums" => "Vorhandene Foren bearbeiten",
"Refresh rate (if dynamic) [secs]" => "Aktualisierungsrate (falls dynamisch) [Sek.]",
"configure repositories" => "Repositories konfigurieren",
"configure this repository" => "dieses Repository konfigurieren",
"copy rules" => "Regeln kopieren",
"Create/edit newsletters" => "Newsletters hinzuf&uuml;gen/bearbeiten",
"subscriptions" => "Abonnements",
"archives" => "Archive",
"Use Admin Email" => "Admin eMail benutzen",
"Edit or add poll options" => "Abstimmungsoptionen hinzuf&uuml;gen/bearbeiten",
"Create/edit Polls" => "Abstimmungen hinzuf&uuml;gen/bearbeiten",
"Rss channels" => "RSS Kan&auml;le",
"show pubdate" => "Datum anzeigen",
"activate" => "Aktivieren",
"Admin tracker" => "Tracker verwalten",
"Edit this tracker" => "Diesen Tracker bearbeiten",
"View this tracker items" => "Eintr&auml;ge dieses Trackers ansehen",
"Edit tracker fields" => "Tracker-Felder bearbeiten",
"Import/export trackers fields" => "Tracker-Felder importieren/exportieren",
"Create trackers" => "Tracker anlegen",
"Import/export" => "Import/Export",
"fields" => "Felder",
"Create/edit trackers" => "Tracker hinzuf&uuml;gen/bearbeiten",
"filename" => "Dateiname",
"filesize" => "Dateigr&ouml;&szlig;e",
"filetype" => "Dateityp",
"longdesc" => "Beschreibung",
"Add a new group" => "Eine neue Gruppe hinzuf&uuml;gen",
"Edit item" => "Punkt bearbeiten",
"List all members" => "Alle Mitglieder auflisten",
"Add a new user" => "Neuen Benutzer hinzuf&uuml;gen",
"manage group assignments" => "Gruppenzuordnungen bearbeiten",
"set default groups" => "Standardgruppen setzen",
"watch only this category" => "Nur diese Kategorie beobachten",
"watch this category and their descendants" => "Diese Kategorien und deren Nachfolger beobachten",
"stop watching only this category" => "Nur diese Kategorie nicht mehr beobachten",
"stop watching this category and their descendants" => "Diese Kategorie und deren Nachfolger nicht mehr beobachten",
"Popup Window" => "Popup-Fenster",
"details" => "Details",
"zoom" => "Zoomen",
"change focus" => "hierher wechseln",
"quarter" => "Vierteljahr",
"semester" => "Halbjahr",
"No individual permissions global permissions apply" => "Keine individuellen Berechtigungen, globale Berechtigungen gelten",
"Welcome to the Tiki Chat Rooms" => "Willkommen bei den Tiki Chatr&auml;umen",
"Please select a chat channel" => "Bitte einen Chatraum ausw&auml;hlen",
"enter chat room" => "Chatraum betreten",
"There are no channels setup, please contact a site admin" => "Es sind keine Chatr&auml;ume eingerichtet, bitte den Admin kontaktieren.",
"Chatroom" => "Chatraum",
"Active Channels" => "Aktive ",
"Users in this channel" => "Benutzer in diesem Kanal",
"Channel Information" => "Channel-Informationen",
"Use :nickname:message for private messages" => "Benutzen Sie :nickname:Nachricht f&uuml;r private Nachrichten",
"Use [URL|description] or [URL] for links" => "Benutzen Sie [URL|Beschreibung] oder [URL] f&uuml;r Links",
"Use (:smileyname:) for smileys" => "(:smileyname:) f&uuml;r Smileys",
"Create PDF" => "PDF erstellen",
"PDF Settings" => "PDF Einstellungen",
"Keep screen pixel/point ratio" => "Pixel und Punkt Verh&auml;ltnis nicht &auml;ndern",
"Render images" => "Bilder rendern",
"Render hyperlinks" => "Hyperlinks rendern",
"Left Margin (mm)" => "Linker Abstand (mm)",
"Right Margin (mm)" => "Rechter Abstand (mm)",
"Top Margin (mm)" => "Oberer Abstand (mm)",
"Bottom Margin (mm)" => "Unterer Abstand (mm)",
"Show page border" => "Seitenrand anzeigen",
"Encoding" => "Formatierung",
"Output" => "Ausgabe",
"PDF compatilbility level" => "PDF Kompatibilit&auml;t",
"Select Wiki Pages" => "Wiki-Seiten ausw&auml;hlen",
"Remove Page" => "Seite entf.",
"click here to send us an email" => "Hier klicken um uns eine eMail zu schicken",
"Add or edit a site" => "Link hinzuf&uuml;gen/bearbeiten",
"sites" => "Links",
"cool sites" => "Coole Links",
"Use ...page... to separate pages in a multi-page article" => "Benutze ...page... um Seiten in einen mehrseitigen Artikel aufzuteilen",
"Create Zone" => "Zone hinzuf&uuml;gen",
"browse image" => "Bild betrachten",
"translate" => "&uuml;bersetzen",
"Create or edit content" => "Inhalt hinzuf&uuml;gen/bearbeiten",
"this quiz stats" => "Statistik f&uuml;r dieses Quiz",
"answer" => "Antwort",
"Edit Translation:" => "&Uuml;bersetzungs-Einstellungen:",
"Set of Translations" => "Vorhandene &Uuml;bersetzungen",
"Select the article for which the current article is the translation." => "Artikel ausw&auml;hlen, vom dem dieser hier die &Uuml;bersetzung ist",
"Translation of:" => "&Uuml;bersetzung von:",
"Add to the Set" => "Zur Liste hinzuf&uuml;gen",
"graph" => "Graph",
"Edit FAQ questions" => "FAQ-Fragen bearbeiten",
"Edit this file gallery:" => "Dieses Dateiarchiv bearbeiten:",
"icon" => "Symbol",
"Other users can upload files to this gallery" => "Andere Benutzer k&ouml;nnen Dateien hochladen",
"Available File Galleries" => "Verf&uuml;gbare Dateiarchive",
"start" => "Beginn",
"end" => "Ende",
"roles" => "Rollen",
"Add role" => "Rolle hinzuf&uuml;gen",
"active process" => "aktiver Prozess",
"invalid" => "ung&uuml;ltig",
"invalid process" => "ung&uuml;ltiger Prozess",
"valid process" => "g&uuml;ltiger Prozess",
"activities" => "Aktivit&auml;ten",
"aborted" => "abgebrochen",
"value" => "Wert",
"proc" => "Prozesse",
"exceptions" => "Fehler",
"rollback" => "Rollback",
"Create or edit content block" => "Content-Block hinzuf&uuml;gen/bearbeiten",
"Old vers" => "Alte Version",
"Listing Gallery" => "Liste Galerie auf",
"Gallery Files" => "Archiv-Dateien",
"Last ver" => "letzte Ver.",
"Com" => "Kommentar",
"Vers" => "Ver.",
"Add or edit event" => "Termin hinzuf&uuml;gen/bearbeiten",
"Subscribe to newsletter" => "Newsletter abonnieren",
"Add or edit a news server" => "Newsserver hinzuf&uuml;gen/bearbeiten",
"merge selected notes into" => "Notizen verschmelzen mit",
"Print Wiki Pages" => "Wiki-Seiten drucken",
"add page" => "Seite hinzuf&uuml;gen",
"entire site" => "Ganze Site",
"click to navigate" => "zum Navigieren anklicken",
"Total threads" => "Threads gesamt",
"Average threads per topic" => "Durchschn. Threads pro Thema",
"Faq Stats" => "FAQ-Statistik",
"clean" => "l&ouml;schen",
"You can include the file in an HTML/Tiki page using" => "Sie k&ouml;nnen die Datei in eine HTML-/Tiki-Seite einf&uuml;gen mit",
"Now enter the file URL" => "Nun Datei-URL eingeben",
" or upload a local file from your disk" => " oder Datei von lokaler Disk hochladen",
"Add or edit folder" => "Ordner hinzuf&uuml;gen/bearbeiten",
"Add or edit a URL" => "URL hinzuf&uuml;gen/bearbeiten",
"received" => "erhalten",
"submitted" => "zugewiesen",
"shared" => "geteilt",
"move into trash" => "in den Papierkorb",
"waiting / not started" => "wartend / noch nicht begonnen",
"waiting" => "wartend",
"shared for group" => "wird geteilt von Gruppe",
"accepted by user" => "akzeptiert von Benutzer",
"no / rejected" => "nein / zur&uuml;ckgewiesen",
"accepted by creator" => "vom Ersteller akzeptiert",
"priority" => "Priorit&auml;t",
"select one" => "Status",
"undo trash" => "aus Papierkorb",
"show:" => "anzeigen:",
"all shared tasks" => "alle geteilten Aufgaben",
"previous chart" => "vorherige Hitliste",
"next chart" => "n&auml;chste Hitliste",
"pos" => "Position",
"pre" => "letzte",
"avg" => "Durchschnitt",
"post new comment" => "Neuen Kommentar posten",
"Post New Comment" => "Neuen Kommentar posten",
"HTML tags are not allowed inside comments" => "HTML-Tags innerhalb von Kommentaren nicht erlaubt",
"moderator actions" => "Moderator-Aktionen",
"move selected topics" => "Ausgew&auml;hlte Themen verschieben",
"unlock selected topics" => "Ausgew&auml;hlte Themen entsperren",
"lock selected topics" => "Ausgew&auml;hlte Themen sperren",
"merge" => "zusammenf&uuml;hren",
"merge selected topics" => "Ausgew&auml;hlte Themen zusammenf&uuml;hren",
"reported messages:" => "Gemeldete Nachrichten:",
"queued messages:" => "Aufgelaufene Nachrichten:",
"emot" => "Stimmung",
"Edit fields" => "Felder bearbeiten",
"Insert new item" => "Neuen Eintrag hinzuf&uuml;gen",
"View item" => "Eintrag ansehen",
"Add a comment" => "Kommentar hinzuf&uuml;gen",
"settings" => "Einstellungen",
"mailbox" => "Mailbox",
"compose" => "Erstellen",
"contacts" => "Kontakte",
"account" => "Account",
"pop" => "POP",
"back to mailbox" => "Zur&uuml;ck zum Briefkasten",
"full headers" => "Alle Header",
"normal headers" => "Normale Header",
"reply all" => "allen antworten",
"forward" => "weiterleiten",
"select from address book" => "Aus Adressbuch ausw&auml;hlen",
"cc" => "CC",
"bcc" => "BCC",
"Projects" => "Projekte",
"Projects configuration" => "Projekte Einstellungen",
"Site Identity features" => "Site Identit&auml;ts Features",
"Click here to delete this category" => "Zum L&ouml;schen der Kategorie hier klicken",
"Group doesnt exist" => "Gruppe existiert nicht",
"User doesnt exist" => "Benutzer existiert nicht",
"Please login" => "Bitte anmelden",
"Event without Name" => "Ereignis ohne Name",
"Invalid old password" => "Ung&uuml;ltiges altes Pa&szlig;wort",
"No channel indicated" => "Kein Kanal angegeben",
"No nickname indicated" => "Kein Nickname angegeben",
"No permission to view the page" => "Keine Berechtigung zum Betrachten dieser Seite",
"Please create a directory named \$map_path to hold your map files." => "Bitte ein Verzeichnis \$map_path f&uuml;r die Kartendaten anlegen.",
"Permision denied" => "Zugriff verweigert",
// ### end of unused words

// ### start of untranslated words
// ### uncomment value pairs as you translate
// "Your post has not been posted" => "Your post has not been posted",
// "Cookies must be allowed to vote" => "Cookies must be allowed to vote",
// "You have mistyped the anti-bot verification code; please try again." => "You have mistyped the anti-bot verification code; please try again.",
// "This forum is flat and doesn't allow replies to other replies" => "This forum is flat and doesn't allow replies to other replies",
// "Copyright management" => "Copyright management",
// "ID" => "ID",
// "Name" => "Name",
// "Last editor" => "Last editor",
// "Explorer" => "Explorer",
// "Afghanistan" => "Afghanistan",
// "Aland Islands" => "Aland Islands",
// "Albania" => "Albania",
// "Algeria" => "Algeria",
// "American Samoa" => "American Samoa",
// "Andorra" => "Andorra",
// "Angola" => "Angola",
// "Anguilla" => "Anguilla",
// "Antarctica" => "Antarctica",
// "Antigua" => "Antigua",
// "Argentina" => "Argentina",
// "Armenia" => "Armenia",
// "Aruba" => "Aruba",
// "Australia" => "Australia",
// "Austria" => "Austria",
// "Azerbaijan" => "Azerbaijan",
// "Bahamas" => "Bahamas",
// "Bahrain" => "Bahrain",
// "Bangladesh" => "Bangladesh",
// "Barbados" => "Barbados",
// "Belarus" => "Belarus",
// "Belgium" => "Belgium",
// "Belize" => "Belize",
// "Benin" => "Benin",
// "Bermuda" => "Bermuda",
// "Bhutan" => "Bhutan",
// "Bolivia" => "Bolivia",
// "Bosnia and Herzegovina" => "Bosnia and Herzegovina",
// "Botswana" => "Botswana",
// "Bouvet Island" => "Bouvet Island",
// "Brazil" => "Brazil",
// "British Indian Ocean Territory" => "British Indian Ocean Territory",
// "British Virgin Islands" => "British Virgin Islands",
// "Brunei" => "Brunei",
// "Bulgaria" => "Bulgaria",
// "Burkina Faso" => "Burkina Faso",
// "Burundi" => "Burundi",
// "Cambodia" => "Cambodia",
// "Cameroon" => "Cameroon",
// "Canada" => "Canada",
// "Cape Verde" => "Cape Verde",
// "Catalan Countries" => "Catalan Countries",
// "Cayman Islands" => "Cayman Islands",
// "Central African Republic" => "Central African Republic",
// "Chad" => "Chad",
// "Chile" => "Chile",
// "China" => "China",
// "Christmas Island" => "Christmas Island",
// "Cocos Islands" => "Cocos Islands",
// "Colombia" => "Colombia",
// "Comoros" => "Comoros",
// "Congo" => "Congo",
// "Congo Democratic" => "Congo Democratic",
// "Cook Islands" => "Cook Islands",
// "Costa Rica" => "Costa Rica",
// "Croatia" => "Croatia",
// "Cuba" => "Cuba",
// "Cyprus" => "Cyprus",
// "Czech Republic" => "Czech Republic",
// "Denmark" => "Denmark",
// "Djibouti" => "Djibouti",
// "Dominica" => "Dominica",
// "Dominican Republic" => "Dominican Republic",
// "Ecuador" => "Ecuador",
// "Egypt" => "Egypt",
// "El Salvador" => "El Salvador",
// "Equatorial Guinea" => "Equatorial Guinea",
// "Eritrea" => "Eritrea",
// "Estonia" => "Estonia",
// "Ethiopia" => "Ethiopia",
// "Europe" => "Europe",
// "Falkland Islands" => "Falkland Islands",
// "Faroe Islands" => "Faroe Islands",
// "Federated States of Micronesia" => "Federated States of Micronesia",
// "Fiji" => "Fiji",
// "Finland" => "Finland",
// "France" => "France",
// "French Guiana" => "French Guiana",
// "French Polynesia" => "French Polynesia",
// "French Southern Territories" => "French Southern Territories",
// "Gabon" => "Gabon",
// "Gambia" => "Gambia",
// "Georgia" => "Georgia",
// "Germany" => "Germany",
// "Ghana" => "Ghana",
// "Gibraltar" => "Gibraltar",
// "Greece" => "Greece",
// "Greenland" => "Greenland",
// "Grenada" => "Grenada",
// "Guadeloupe" => "Guadeloupe",
// "Guam" => "Guam",
// "Guatemala" => "Guatemala",
// "Guernsey" => "Guernsey",
// "Guinea" => "Guinea",
// "Guinea Bissau" => "Guinea Bissau",
// "Guyana" => "Guyana",
// "Haiti" => "Haiti",
// "Heard Island and McDonald Islands" => "Heard Island and McDonald Islands",
// "Honduras" => "Honduras",
// "Hong Kong" => "Hong Kong",
// "Hungary" => "Hungary",
// "Iceland" => "Iceland",
// "India" => "India",
// "Indonesia" => "Indonesia",
// "Iran" => "Iran",
// "Iraq" => "Iraq",
// "Ireland" => "Ireland",
// "Isle of Man" => "Isle of Man",
// "Israel" => "Israel",
// "Italy" => "Italy",
// "Ivory Coast" => "Ivory Coast",
// "Jamaica" => "Jamaica",
// "Japan" => "Japan",
// "Jersey" => "Jersey",
// "Jordan" => "Jordan",
// "Kazakstan" => "Kazakstan",
// "Kenya" => "Kenya",
// "Kiribati" => "Kiribati",
// "Kuwait" => "Kuwait",
// "Kyrgyzstan" => "Kyrgyzstan",
// "Laos" => "Laos",
// "Latvia" => "Latvia",
// "Lebanon" => "Lebanon",
// "Lesotho" => "Lesotho",
// "Liberia" => "Liberia",
// "Libya" => "Libya",
// "Liechtenstein" => "Liechtenstein",
// "Lithuania" => "Lithuania",
// "Luxemburg" => "Luxemburg",
// "Macao" => "Macao",
// "Macedonia" => "Macedonia",
// "Madagascar" => "Madagascar",
// "Malawi" => "Malawi",
// "Malaysia" => "Malaysia",
// "Maldives" => "Maldives",
// "Mali" => "Mali",
// "Malta" => "Malta",
// "Marshall Islands" => "Marshall Islands",
// "Martinique" => "Martinique",
// "Mauritania" => "Mauritania",
// "Mauritius" => "Mauritius",
// "Mayotte" => "Mayotte",
// "Mexico" => "Mexico",
// "Moldova" => "Moldova",
// "Monaco" => "Monaco",
// "Mongolia" => "Mongolia",
// "Montenegro" => "Montenegro",
// "Montserrat" => "Montserrat",
// "Morocco" => "Morocco",
// "Mozambique" => "Mozambique",
// "Myanmar" => "Myanmar",
// "Namibia" => "Namibia",
// "Nauru" => "Nauru",
// "Nepal" => "Nepal",
// "Netherlands" => "Netherlands",
// "Netherlands Antilles" => "Netherlands Antilles",
// "New Caledonia" => "New Caledonia",
// "New Zealand" => "New Zealand",
// "Nicaragua" => "Nicaragua",
// "Niger" => "Niger",
// "Nigeria" => "Nigeria",
// "Niue" => "Niue",
// "Norfolk Island" => "Norfolk Island",
// "Northern Mariana Islands" => "Northern Mariana Islands",
// "North Korea" => "North Korea",
// "Norway" => "Norway",
// "Oman" => "Oman",
// "Pakistan" => "Pakistan",
// "Palau" => "Palau",
// "Palestine" => "Palestine",
// "Panama" => "Panama",
// "Papua New Guinea" => "Papua New Guinea",
// "Paraguay" => "Paraguay",
// "Peru" => "Peru",
// "Philippines" => "Philippines",
// "Pitcairn" => "Pitcairn",
// "Poland" => "Poland",
// "Portugal" => "Portugal",
// "Puerto Rico" => "Puerto Rico",
// "Quatar" => "Quatar",
// "Republic of Macedonia" => "Republic of Macedonia",
// "Reunion" => "Reunion",
// "Romania" => "Romania",
// "Russia" => "Russia",
// "Rwanda" => "Rwanda",
// "Saint Helena" => "Saint Helena",
// "Saint Kitts and Nevis" => "Saint Kitts and Nevis",
// "Saint Lucia" => "Saint Lucia",
// "Saint Pierre and Miquelon" => "Saint Pierre and Miquelon",
// "Samoa" => "Samoa",
// "San Marino" => "San Marino",
// "Sao Tome and Principe" => "Sao Tome and Principe",
// "Saudi Arabia" => "Saudi Arabia",
// "Senegal" => "Senegal",
// "Serbia" => "Serbia",
// "Seychelles" => "Seychelles",
// "Sierra Leone" => "Sierra Leone",
// "Singapore" => "Singapore",
// "Slovakia" => "Slovakia",
// "Slovenia" => "Slovenia",
// "Solomon Islands" => "Solomon Islands",
// "Somalia" => "Somalia",
// "South Africa" => "South Africa",
// "South Georgia and South Sandwich Islands" => "South Georgia and South Sandwich Islands",
// "South Korea" => "South Korea",
// "Spain" => "Spain",
// "Sri Lanka" => "Sri Lanka",
// "St Vincent Grenadines" => "St Vincent Grenadines",
// "Sudan" => "Sudan",
// "Surinam" => "Surinam",
// "Svalbard and Jan Mayen" => "Svalbard and Jan Mayen",
// "Swaziland" => "Swaziland",
// "Sweden" => "Sweden",
// "Switzerland" => "Switzerland",
// "Syria" => "Syria",
// "Taiwan" => "Taiwan",
// "Tajikistan" => "Tajikistan",
// "Tanzania" => "Tanzania",
// "Thailand" => "Thailand",
// "Timor-Leste" => "Timor-Leste",
// "Togo" => "Togo",
// "Tokelau" => "Tokelau",
// "Tonga" => "Tonga",
// "Trinidad Tobago" => "Trinidad Tobago",
// "Tunisia" => "Tunisia",
// "Turkey" => "Turkey",
// "Turkmenistan" => "Turkmenistan",
// "Turks and Caicos Islands" => "Turks and Caicos Islands",
// "Tuvalu" => "Tuvalu",
// "Uganda" => "Uganda",
// "Ukraine" => "Ukraine",
// "United Arab Emirates" => "United Arab Emirates",
// "United Kingdom" => "United Kingdom",
// "United Nations Organization" => "United Nations Organization",
// "United States" => "United States",
// "United States Minor Outlying Islands" => "United States Minor Outlying Islands",
// "Uruguay" => "Uruguay",
// "US Virgin Islands" => "US Virgin Islands",
// "Uzbekistan" => "Uzbekistan",
// "Vanuatu" => "Vanuatu",
// "Vatican" => "Vatican",
// "Venezuela" => "Venezuela",
// "Viet Nam" => "Viet Nam",
// "Wales" => "Wales",
// "Wallis and Futuna" => "Wallis and Futuna",
// "Western Sahara" => "Western Sahara",
// "World" => "World",
// "Yemen" => "Yemen",
// "Yugoslavia" => "Yugoslavia",
// "Zambia" => "Zambia",
// "Zimbabwe" => "Zimbabwe",
// "Arabic" => "Arabic",
// "Catalan" => "Catalan",
// "Simplified Chinese" => "Simplified Chinese",
// "English British" => "English British",
// "Farsi" => "Farsi",
// "Finnish" => "Finnish",
// "Fijian" => "Fijian",
// "French" => "French",
// "Galician" => "Galician",
// "Hebrew" => "Hebrew",
// "Croatian" => "Croatian",
// "Korean" => "Korean",
// "Hungarian" => "Hungarian",
// "Português" => "Português",
// "Brazilian Portuguese" => "Brazilian Portuguese",
// "Pijin Solomon" => "Pijin Solomon",
// "Slovak" => "Slovak",
// "Serbian" => "Serbian",
// "Serbian Latin" => "Serbian Latin",
// "Tuvaluan" => "Tuvaluan",
// "Traditional Chinese" => "Traditional Chinese",
// "Ukrainian" => "Ukrainian",
// "This instance of activity is already complete" => "This instance of activity is already complete",
// "Fatal error: nextActivity does not match any candidate in autorouting switch activity" => "Fatal error: nextActivity does not match any candidate in autorouting switch activity",
// "Fatal error: non-deterministic decision for autorouting activity" => "Fatal error: non-deterministic decision for autorouting activity",
// "Cannot add transition only split activities can have more than one outbound transition" => "Cannot add transition only split activities can have more than one outbound transition",
// "Circular reference found some activity has a transition leading to itself" => "Circular reference found some activity has a transition leading to itself",
// " is non-interactive and non-autorouted but has no role assigned" => " is non-interactive and non-autorouted but has no role assigned",
// " is not mapped" => " is not mapped",
// "Activity '.\$res['name'].' is standalone and is using the \$instance object" => "Activity '.\$res['name'].' is standalone and is using the \$instance object",
// "Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method" => "Activity '.\$res['name'].' is interactive so it must use the \$instance->complete() method",
// "Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method" => "Activity '.\$res['name'].' is non-interactive so it must not use the \$instance->complete() method",
// "Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method" => "Activity '.\$res['name'].' is switch so it must use \$instance->setNextActivity(\$actname) method",
// "Template %s not registered" => "Template %s not registered",
// "Error line: %d" => "Error line: %d",
// "Administration:" => "Administration:",
// "in" => "in",
// "Wiki" => "Wiki",
// "Blogs" => "Blogs",
// "FAQs" => "FAQs",
// "Newsletter" => "Newsletter",
// "survey" => "survey",
// "Cannot write to this file: " => "Cannot write to this file: ",
// "(not registered)" => "(not registered)",
// "Use this thread to discuss the %s page." => "Use this thread to discuss the %s page.",
// "WikiDiff::apply: line count mismatch: %s != %s" => "WikiDiff::apply: line count mismatch: %s != %s",
// "WikiDiff::_check: failed" => "WikiDiff::_check: failed",
// "WikiDiff::_check: edit sequence is non-optimal" => "WikiDiff::_check: edit sequence is non-optimal",
// "WikiDiff Okay: LCS = %s" => "WikiDiff Okay: LCS = %s",
// "Tiki Link - Insert internal link" => "Tiki Link - Insert internal link",
// "Select a Wiki page to link to:" => "Select a Wiki page to link to:",
// "Link" => "Link",
// "Cannot open this file:" => "Cannot open this file:",
// "Blog" => "Blog",
// "Continue" => "Continue",
// "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>" => "unknown destination directory. Please set it up in <a href='tiki-admin.php?page=galleries'>tiki-admin.php?page=galleries</a>",
// "unlink failed" => "unlink failed",
// "Contributions" => "Contributions",
// "Query point:" => "Query point:",
// "layer:" => "layer:",
// "Record:" => "Record:",
// "No valid ogr2ogr executable" => "No valid ogr2ogr executable",
// "Could not create \$tdo.mif in data directory" => "Could not create \$tdo.mif in data directory",
// "Could not create \$tdo.mid in data directory" => "Could not create \$tdo.mid in data directory",
// "User Map Generated in:" => "User Map Generated in:",
// "Image Map Generated in:" => "Image Map Generated in:",
// "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it." => "You can only use optionId = 0 to create a new option or optionId equal an id that already belongs to the menu to update it.",
// "menu" => "menu",
// "File %s not found" => "File %s not found",
// "File %s is not a valid archive" => "File %s is not a valid archive",
// "Impossible to open %s : %s" => "Impossible to open %s : %s",
// "The content retrieved at %s is not a list of mods" => "The content retrieved at %s is not a list of mods",
// "Can't chdir to '%s'" => "Can't chdir to '%s'",
// "%s impossible to remove" => "%s impossible to remove",
// "section edit" => "section edit",
// "This poll is closed." => "This poll is closed.",
// "Forums last posts" => "Forums last posts",
// "Downloads" => "Downloads",
// "The passwords do not match" => "The passwords do not match",
// "The registration mail can't be sent. Contact the administrator" => "The registration mail can't be sent. Contact the administrator",
// "Feed provided by %s. Click to visit." => "Feed provided by %s. Click to visit.",
// "Tracker" => "Tracker",
// "Trackeritem" => "Trackeritem",
// "FAQ" => "FAQ",
// "Forum" => "Forum",
// "Tracker item" => "Tracker item",
// "Simple" => "Simple",
// "Advanced" => "Advanced",
// "Fast Next" => "Fast Next",
// "Fast Prev" => "Fast Prev",
// "First {\$params['itemname']}" => "First {\$params['itemname']}",
// "Last {\$params['itemname']}" => "Last {\$params['itemname']}",
// "Next {\$params['itemname']}" => "Next {\$params['itemname']}",
// "Prev {\$params['itemname']}" => "Prev {\$params['itemname']}",
// "Help page:" => "Help page:",
// "View tpl:" => "View tpl:",
// "Edit Template" => "Edit Template",
// "Admin Feature" => "Admin Feature",
// "The text is" => "The text is",
// "Date Selector" => "Date Selector",
// "phplayers are not available on this site" => "phplayers are not available on this site",
// "Invert Sort" => "Invert Sort",
// "sec" => "sec",
// "Text cut here" => "Text cut here",
// "km" => "km",
// "cannot be found" => "cannot be found",
// "An error occured in a database query!" => "An error occured in a database query!",
// "Edit Section" => "Edit Section",
// "index" => "index",
// "You are not allowed to upload this type of file." => "You are not allowed to upload this type of file.",
// "The file you are trying upload was only partially uploaded." => "The file you are trying upload was only partially uploaded.",
// "You must select a file." => "You must select a file.",
// "Altering database table failed" => "Altering database table failed",
// "__WARNING__: No such module \$plugin! " => "__WARNING__: No such module \$plugin! ",
// "Sea Surfing (CSRF) detected. Operation blocked." => "Sea Surfing (CSRF) detected. Operation blocked.",
// "Status:" => "Status:",
// "Upload was not successful. Duplicate file content ?" => "Upload was not successful. Duplicate file content ?",
// "(unchanged)" => "(unchanged)",
// "Item Modification" => "Item Modification",
// "Item creation" => "Item creation",
// "Field is not numeric" => "Field is not numeric",
// "Field is not a link to mp3 in the gallery" => "Field is not a link to mp3 in the gallery",
// "Field is not a link to FLV in the gallery" => "Field is not a link to FLV in the gallery",
// "Field is not a link to FLV or MP3 in the gallery" => "Field is not a link to FLV or MP3 in the gallery",
// "half column" => "half column",
// "prepend" => "prepend",
// "append" => "append",
// "max" => "max",
// "Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Text options: 1,size,prepend,append,max with size in chars, prepend will be displayed before the field append will be displayed just after, max is the maximum number of characters that can be saved, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too.",
// "Textarea options: quicktags,width,height,max,listmax,wordmax - Use Quicktags is 1 or 0, width is indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax is the maximum number of characters that are displayed in list mode, wordmax>0 alert if word count exceeded, wordmax<0 display word count." => "Textarea options: quicktags,width,height,max,listmax,wordmax - Use Quicktags is 1 or 0, width is indicated in chars, height is indicated in lines, max is the maximum number of characters that can be saved, listmax is the maximum number of characters that are displayed in list mode, wordmax>0 alert if word count exceeded, wordmax<0 display word count.",
// "Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too." => "Numeric options: 1,size,prepend,append with size in chars, prepend will be displayed before the field append will be displayed just after, and initial 1 to make that next text field or checkbox is in same row. If you indicate only 1 it means next field is in same row too.",
// "Dropdown options: list of items separated with commas." => "Dropdown options: list of items separated with commas.",
// "Default value is specified by having the value indicated twice consecutively" => "Default value is specified by having the value indicated twice consecutively",
// "drop down with other textfield" => "drop down with other textfield",
// "radio buttons" => "radio buttons",
// "Radio buttons options: list of items separated with commas." => "Radio buttons options: list of items separated with commas.",
// "User Selector options: automatic field feeding,email - feeding=1 for author login or feeding=2 for modificator login - email=1 to send an email to the user if the tracker is modified" => "User Selector options: automatic field feeding,email - feeding=1 for author login or feeding=2 for modificator login - email=1 to send an email to the user if the tracker is modified",
// "Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered." => "Group Selector: use options for automatic field feeding : you can use 1 for group of creation and 2 for group where modification come from. The default group has to be set, or the first group that come is chosen for a user, or the default group is Registered.",
// "IP selector" => "IP selector",
// "IP Selector: use options for automatic field feeding : you can use 1 for author IP or 2 for modificator IP." => "IP Selector: use options for automatic field feeding : you can use 1 for author IP or 2 for modificator IP.",
// "country selector" => "country selector",
// "Country Selector options: name/flag, sortorder - name/flag is 0,1 or 2 where 1 shows only country name, 2 shows only country flag, 0 shows both (default). sortorder is 0 or 1 where 0 sorts according to translated text (default) and 1 sorts according to english country names even if country names are translated" => "Country Selector options: name/flag, sortorder - name/flag is 0,1 or 2 where 1 shows only country name, 2 shows only country flag, 0 shows both (default). sortorder is 0 or 1 where 0 sorts according to translated text (default) and 1 sorts according to english country names even if country names are translated",
// "Date Time options: date_time,year0,year1 where date_time=d|dt(default), d displays only date, year0 is the first year, year1 the last" => "Date Time options: date_time,year0,year1 where date_time=d|dt(default), d displays only date, year0 is the first year, year1 the last",
// "Jscalendar options: date_time where date_time=d|dt(default), d displays only date" => "Jscalendar options: date_time where date_time=d|dt(default), d displays only date",
// "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels." => "Image options: xListSize,yListSize,xDetailsSize,yDetailsSize,uploadLimitScale indicated in pixels.",
// "Action options: Label,post,tiki-index.php,page:fieldname,highlight=test" => "Action options: Label,post,tiki-index.php,page:fieldname,highlight=test",
// "static text" => "static text",
// "Static text options: Wikisyntax,listmax - Use Wikisyntax is 1 or 0, listmax is the maximum number of characters that are displayed in list mode." => "Static text options: Wikisyntax,listmax - Use Wikisyntax is 1 or 0, listmax is the maximum number of characters that are displayed in list mode.",
// "Category options: parentId,d|m|radio|checkbox(default),1|0(default) to have a select all button, d for dropdown, m for multiple drop down" => "Category options: parentId,d|m|radio|checkbox(default),1|0(default) to have a select all button, d for dropdown, m for multiple drop down",
// "item link" => "item link",
// "Item Link options: trackerId,fieldId,linkToItem,displayedfieldslist links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing.  Display displayedfieldslist(separate with |) instead of the target item" => "Item Link options: trackerId,fieldId,linkToItem,displayedfieldslist links to item from trackerId which fieldId matches the content of that field. linkToItem 1|0 to create a link to the item in view mode and listing.  Display displayedfieldslist(separate with |) instead of the target item",
// "items list" => "items list",
// "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing" => "Items list options: trackerId,fieldIdThere, fieldIdHere, displayFieldIdThere, linkToItems displays the list of displayFieldIdThere from item in tracker trackerId where fieldIdThere matches fieldIdHere. linkToItems 1|0 to create a link to items in view mode and listing",
// "dynamic items list" => "dynamic items list",
// "dynamic items list options: trackerId, filterFieldIdThere, filterFieldIdHere, listFieldIdThere, statusThere insert the list of listFieldIdThere from item in tracker trackerId where filterFieldIdThere matches filterFieldIdHere where status is statusThere." => "dynamic items list options: trackerId, filterFieldIdThere, filterFieldIdHere, listFieldIdThere, statusThere insert the list of listFieldIdThere from item in tracker trackerId where filterFieldIdThere matches filterFieldIdHere where status is statusThere.",
// "Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto." => "Email address options: 0|1|2 where 0 puts the address as plain text, 1 does a hex encoded mailto link (more difficult for web spiders to pick it up and spam) and 2 does the normal href mailto.",
// "multimedia" => "multimedia",
// " 0|1|2|3|4|5 0,xsize,ysize. First record :0 for URL in file gal of MP3 only, 1 for URL of FLV in file gal video only , 2 for URL of MP3 or Video in file gal, 3 donwload MP3 only, 4 donwload FLV video only, 5 download FLV or MP3 (default is 0). Second record : X size of flash applet(default is 200) , Y size of flash applet (default is 100) " => " 0|1|2|3|4|5 0,xsize,ysize. First record :0 for URL in file gal of MP3 only, 1 for URL of FLV in file gal video only , 2 for URL of MP3 or Video in file gal, 3 donwload MP3 only, 4 donwload FLV video only, 5 download FLV or MP3 (default is 0). Second record : X size of flash applet(default is 200) , Y size of flash applet (default is 100) ",
// "auto-increment" => "auto-increment",
// "Sequential auto-increment number:initial_value,prepend,append,itemId: initial_value default is 1, prepend will be displayed before the field, append will be displayed just after, itemId will use the item Id" => "Sequential auto-increment number:initial_value,prepend,append,itemId: initial_value default is 1, prepend will be displayed before the field, append will be displayed just after, itemId will use the item Id",
// "user subscription" => "user subscription",
// "Allow registered user to subscribe to an item. They can add a number of friends." => "Allow registered user to subscribe to an item. They can add a number of friends.",
// "Google Maps" => "Google Maps",
// "Use Google Maps." => "Use Google Maps.",
// "computed field" => "computed field",
// "Formula for computation, using # for indicating fields and +,*,/,- and parenthesis for operations." => "Formula for computation, using # for indicating fields and +,*,/,- and parenthesis for operations.",
// "user preference" => "user preference",
// "listview=nst, n to see name/t to see type/s to see type/u to see user in list mode" => "listview=nst, n to see name/t to see type/s to see type/u to see user in list mode",
// "Added:" => "Added:",
// "Removed:" => "Removed:",
// "Remaining:" => "Remaining:",
// "Old:" => "Old:",
// "New:" => "New:",
// "No extra information for that attached file. " => "No extra information for that attached file. ",
// "(AT)" => "(AT)",
// "(DOT)" => "(DOT)",
// "The administrator has not yet validated your account. Please wait." => "The administrator has not yet validated your account. Please wait.",
// "You must validate your account first. An email has been sent to you" => "You must validate your account first. An email has been sent to you",
// "The registration mail can't be sent because there is no server email address set, and this feature is disabled" => "The registration mail can't be sent because there is no server email address set, and this feature is disabled",
// "The user email confirmation can't be sent. Contact the administrator" => "The user email confirmation can't be sent. Contact the administrator",
// "Personal Phone" => "Personal Phone",
// "Personal Mobile" => "Personal Mobile",
// "Personal Fax" => "Personal Fax",
// "Work Phone" => "Work Phone",
// "Work Mobile" => "Work Mobile",
// "Work Fax" => "Work Fax",
// "Company" => "Company",
// "Organization" => "Organization",
// "Department" => "Department",
// "Division" => "Division",
// "Job Title" => "Job Title",
// "Street Address" => "Street Address",
// "City" => "City",
// "Zip Code" => "Zip Code",
// "Use BLOGLIST to include posts from a blog. Syntax is" => "Use BLOGLIST to include posts from a blog. Syntax is",
// " where Id is the blog Id and Items is the max number of posts to display" => " where Id is the blog Id and Items is the max number of posts to display",
// "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~" => "Ex: ~np~{BLOGLIST(Id=2, Items=15)}{BLOGLIST}~/np~",
// "Lists files in a directory" => "Lists files in a directory",
// "could not be opened because it doesn't exist or permission was denied" => "could not be opened because it doesn't exist or permission was denied",
// "Takes regex expressions and parses the content between the REGEX tags and replaces the text." => "Takes regex expressions and parses the content between the REGEX tags and replaces the text.",
// "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace." => "The SNARF plugin replaces itself with the HTML body of a URL.  Arbitrary regex replacement can be done on this content using regex and regexres, the latter being used as the second argument to preg_replace.",
// "This data is put in a CODE caption." => "This data is put in a CODE caption.",
// "Missing url parameter for SNARF plugin." => "Missing url parameter for SNARF plugin.",
// "Displays a list of registered users" => "Displays a list of registered users",
// "Displays browser client info" => "Displays browser client info",
// "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor" => "Puts a link to an anchor in a wiki page. Use in conjunction with the ANAME plugin, which sets the location and name of the anchor",
// "linktext" => "linktext",
// "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor" => "Puts an anchor into a wiki page. Use in conjunction with the ALINK plugin, which makes links to the anchor",
// "Save changes to annotations" => "Save changes to annotations",
// "Creates an annotation block for an image." => "Creates an annotation block for an image.",
// "Includes an article" => "Includes an article",
// "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~" => "~np~{ARTICLE(Field=>[,Id=>])}{ARTICLE}~/np~",
// "Id is optional. If not given, last article is used. Default field is heading." => "Id is optional. If not given, last article is used. Default field is heading.",
// "Includes articles listing into a wiki page" => "Includes articles listing into a wiki page",
// "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc)}{ARTICLES}~/np~" => "~np~{ARTICLES(max=>3, topic=>topicName, topicId=>id, type=>type, categId=>Category parent ID, lang=>en, sort=>columnName_asc|columnName_desc)}{ARTICLES}~/np~",
// "No such attachment on this page" => "No such attachment on this page",
// "Displays an attachment or a list of them" => "Displays an attachment or a list of them",
// "Gives the name of the attached file to link to" => "Gives the name of the attached file to link to",
// "Same as name" => "Same as name",
// "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages" => "Gives the name of another page the attached file is on. The file on that page is linked to instead. Only works with wiki pages",
// "Shows the description as the link text instead of the file name" => "Shows the description as the link text instead of the file name",
// "Makes the list of attachments a bulleted list" => "Makes the list of attachments a bulleted list",
// "Says that this file is an image, and should be displayed inline using the img tag" => "Says that this file is an image, and should be displayed inline using the img tag",
// "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description" => "Puts the stuff between {ATTACH} tags as the link text instead of the file name or description",
// "Shows all attachments from the whole wiki" => "Shows all attachments from the whole wiki",
// "Gives the number, in the list of attachments, of the attachment to link to" => "Gives the number, in the list of attachments, of the attachment to link to",
// "Gives the actual id of the attachment to link in. You probably should never use this" => "Gives the actual id of the attachment to link in. You probably should never use this",
// "Puts the number of downloads in the alt comment" => "Puts the number of downloads in the alt comment",
// "Shows a file icon" => "Shows a file icon",
// "List all pages which link to specific pages" => "List all pages which link to specific pages",
// "Chart as PDF" => "Chart as PDF",
// "Chart as PostScript" => "Chart as PostScript",
// "note: colors and ln are exclusive" => "note: colors and ln are exclusive",
// "Insert a division block on wiki page" => "Insert a division block on wiki page",
// "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size" => "Renders an equation written in LaTeX syntax as a png.  Optional parameter size defaults to 100 and is the percentage of the normal size, i.e., size=200 indicates an equation 2x the normal size",
// "equation" => "equation",
// "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage" => "~np~{~/np~EVENTS(calendarid=1|2,maxdays=365,max=-1,datetime=1,desc=1)}{EVENTS} Insert rss feed output into a wikipage",
// "Missing parameter movie to the plugin flash" => "Missing parameter movie to the plugin flash",
// "Displays a SWF on the wiki page" => "Displays a SWF on the wiki page",
// "Formula" => "Formula",
// "No formula specified." => "No formula specified.",
// "Impossible to render the graphic." => "Impossible to render the graphic.",
// "View graphic" => "View graphic",
// "Displays a graphical GAUGE" => "Displays a graphical GAUGE",
// "Display wiki text if user is in one of listed groups" => "Display wiki text if user is in one of listed groups",
// "Runs a Java applet to access a local Jabber service" => "Runs a Java applet to access a local Jabber service",
// "Displays the text only if the language matchs" => "Displays the text only if the language matchs",
// "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given" => "The last_mod plugin replaces itself with last modification time of the named wiki page, or the current page if no name given",
// "List wiki pages." => "List wiki pages.",
// "Displays a map" => "Displays a map",
// "Displays an miniquiz" => "Displays an miniquiz",
// "Displays a SWF myspace mp3 playlist on the wiki page" => "Displays a SWF myspace mp3 playlist on the wiki page",
// "Displays object hit info by object and days" => "Displays object hit info by object and days",
// "Provides a list of plugins on this wiki." => "Provides a list of plugins on this wiki.",
// "Displays the output of a poll, fields are indicated with numeric ids." => "Displays the output of a poll, fields are indicated with numeric ids.",
// "missing poll ID for plugin POLL" => "missing poll ID for plugin POLL",
// "blogId is mandatory" => "blogId is mandatory",
// "Includes blog posts listing into a wiki page" => "Includes blog posts listing into a wiki page",
// "~np~{POSTS(max=>5, blogId=>id)}{POSTS}~/np~" => "~np~{POSTS(max=>5, blogId=>id)}{POSTS}~/np~",
// " wrote:" => " wrote:",
// "Quote:" => "Quote:",
// "Quote text by surrounding the text with a box, like the [QUOTE] BBCode" => "Quote text by surrounding the text with a box, like the [QUOTE] BBCode",
// "Displays a comment, tip, note or warning box" => "Displays a comment, tip, note or warning box",
// "remarks text" => "remarks text",
// "You need to specify a RSS Id" => "You need to specify a RSS Id",
// "RSS Id incorrect:" => "RSS Id incorrect:",
// "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage" => "~np~{~/np~RSS(id=>feedId:feedId2,max=>3,date=>1,desc=>1,author=>1)}{RSS} Insert rss feed output into a wikipage",
// "TikiSheet" => "TikiSheet",
// "Sheet Heading" => "Sheet Heading",
// "Edit Sheet" => "Edit Sheet",
// "Clickable Skype link" => "Clickable Skype link",
// "row1col1" => "row1col1",
// "row1col2" => "row1col2",
// "row2col1" => "row2col1",
// "row2col2" => "row2col2",
// "Displays text in subscript." => "Displays text in subscript.",
// "Subscribe or unsubscribe to a group" => "Subscribe or unsubscribe to a group",
// "Missing parameter" => "Missing parameter",
// "Incorrect param" => "Incorrect param",
// "Displays text in superscript." => "Displays text in superscript.",
// "Displays text between an html tag" => "Displays text between an html tag",
// "Displays the thumbnail for an image" => "Displays the thumbnail for an image",
// "Search the titles of all pages in this wiki" => "Search the titles of all pages in this wiki",
// "List top scoring users" => "List top scoring users",
// "Translate a string" => "Translate a string",
// "Incorrect fieldId:" => "Incorrect fieldId:",
// "Following mandatory fields are missing" => "Following mandatory fields are missing",
// "Following fields are incorrect" => "Following fields are incorrect",
// "Other:" => "Other:",
// "Displays an input form for tracker submit" => "Displays an input form for tracker submit",
// "You do not have permission to insert an item" => "You do not have permission to insert an item",
// "You do not have permission to modify an item" => "You do not have permission to modify an item",
// "Fields marked with a * are mandatory." => "Fields marked with a * are mandatory.",
// "Filter" => "Filter",
// "Filters the items of a tracker, fields are indicated with numeric ids." => "Filters the items of a tracker, fields are indicated with numeric ids.",
// "missing parameters" => "missing parameters",
// "tracker field type not processed yet" => "tracker field type not processed yet",
// "Wiki text" => "Wiki text",
// "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker)." => "Displays the value of a tracker item field or the wiki text if the value of the field is set or has a value(if itemId not specified, use the itemId of the url or the user tracker).",
// "incorrect filterfield" => "incorrect filterfield",
// "Displays the output of a tracker content, fields are indicated with numeric ids." => "Displays the output of a tracker content, fields are indicated with numeric ids.",
// "Error in tracker ID" => "Error in tracker ID",
// "Displays a button to link to a page with a tracker plugin with prefilled tracker fields." => "Displays a button to link to a page with a tracker plugin with prefilled tracker fields.",
// "Displays some stat of a tracker content, fields are indicated with numeric ids." => "Displays some stat of a tracker content, fields are indicated with numeric ids.",
// "incorrect fieldId" => "incorrect fieldId",
// "Displays the number of registered users" => "Displays the number of registered users",
// "Split the text in parts visible only under some conditions" => "Split the text in parts visible only under some conditions",
// "This is the default text" => "This is the default text",
// "(version 3)" => "(version 3)",
// "This is version 3 info" => "This is version 3 info",
// "(version 2)" => "(version 2)",
// "This is version 2 info" => "This is version 2 info",
// "(version 1)" => "(version 1)",
// "This is version 1 info" => "This is version 1 info",
// "Lists ''wanted'' Wiki pages: " => "Lists ''wanted'' Wiki pages: ",
// "Page-Pattern" => "Page-Pattern",
// "Custom-Level-Regex" => "Custom-Level-Regex",
// "^Parameters: key=>value,...\n" => "^Parameters: key=>value,...\n",
// "__key__ | __default__ | __comments__\n" => "__key__ | __default__ | __comments__\n",
// "empty string" => "empty string",
// "A wildcard pattern of originating pages to be ignored." => "A wildcard pattern of originating pages to be ignored.",
// "(refer to PHP function fnmatch() for details)\n" => "(refer to PHP function fnmatch() for details)\n",
// "The character, by which ignored patterns are separated." => "The character, by which ignored patterns are separated.",
// "possible values: characters\n" => "possible values: characters\n",
// "Whether to include external wikis in the list." => "Whether to include external wikis in the list.",
// "possible values: " => "possible values: ",
// "Collect either originating or wanted pages in a cell and display them in the second column." => "Collect either originating or wanted pages in a cell and display them in the second column.",
// "Switch-on debug output with details about the items." => "Switch-on debug output with details about the items.",
// "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell." => "Multiple collected items are separated in distinct table rows, or by comma or line break in one cell.",
// "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex." => "Filter the list of wanted pages according to page_regex or custom filter. The default value is the site's __current__ page_regex.",
// "A custom filter for wanted pages to be listed (only used when level=>custom)." => "A custom filter for wanted pages to be listed (only used when level=>custom).",
// "a valid regex-expression (PCRE)" => "a valid regex-expression (PCRE)",
// "non-valid custom regex" => "non-valid custom regex",
// ", " => ", ",
// "ignored" => "ignored",
// "dash-WikiWord" => "dash-WikiWord",
// "WikiWord" => "WikiWord",
// "not in level" => "not in level",
// "End of debug output." => "End of debug output.",
// "Wanted Page" => "Wanted Page",
// "Referenced By Page" => "Referenced By Page",
// "Missing parameter movie to the youtube plugin" => "Missing parameter movie to the youtube plugin",
// "Display youtube video in a wiki page" => "Display youtube video in a wiki page",
// "Removed version \$version" => "Removed version \$version",
// "rollback version " => "rollback version ",
// "Changed actual version to \$version" => "Changed actual version to \$version",
// "Page locked" => "Page locked",
// "Page unlocked" => "Page unlocked",
// "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'" => "You have to be able to receive messages in order to send them. Goto your user preferences and enable 'Allow messages from other users'",
// "list topics with links to the articles" => "list topics with links to the articles",
// "Article Topics" => "Article Topics",
// "Categorize %s in %s" => "Categorize %s in %s",
// "Please provide an Id" => "Please provide an Id",
// "no object here yet" => "no object here yet",
// "This module requires parameters trackerId and name set" => "This module requires parameters trackerId and name set",
// "new posts" => "new posts",
// "new submissions" => "new submissions",
// "new FAQs" => "new FAQs",
// "new blogs" => "new blogs",
// "new blog posts" => "new blog posts",
// "new image galleries" => "new image galleries",
// "new file galleries" => "new file galleries",
// "new polls" => "new polls",
// "new tracker items" => "new tracker items",
// "new calendar events" => "new calendar events",
// "The task title must have at least 3 characters" => "The task title must have at least 3 characters",
// "Invalid server key" => "Invalid server key",
// "Cookie not found" => "Cookie not found",
// "Admin live support system" => "Admin live support system",
// "Administrator, can admin banners" => "Administrator, can admin banners",
// "Administrator, can create channels remove channels etc" => "Administrator, can create channels remove channels etc",
// "Administrator, can manage users groups and permissions, Hotwords and all the weblog features" => "Administrator, can manage users groups and permissions, Hotwords and all the weblog features",
// "Auto approve forum posts" => "Auto approve forum posts",
// "Autovalidate suggestions" => "Autovalidate suggestions",
// "Can  receive tasks from other users" => "Can  receive tasks from other users",
// "Can abort a process instance" => "Can abort a process instance",
// "Can access site when closed" => "Can access site when closed",
// "Can add and change ratings on wiki pages" => "Can add and change ratings on wiki pages",
// "Can add events in the calendar" => "Can add events in the calendar",
// "Can admin any mypage" => "Can admin any mypage",
// "Can admin attachments to wiki pages" => "Can admin attachments to wiki pages",
// "Can admin blogs" => "Can admin blogs",
// "Can admin categories" => "Can admin categories",
// "Can admin charts" => "Can admin charts",
// "Can admin contributions" => "Can admin contributions",
// "Can admin cookies" => "Can admin cookies",
// "Can admin directory categories" => "Can admin directory categories",
// "Can admin directory sites" => "Can admin directory sites",
// "Can admin drawings" => "Can admin drawings",
// "Can admin faqs" => "Can admin faqs",
// "Can admin file galleries" => "Can admin file galleries",
// "Can admin forums" => "Can admin forums",
// "Can admin freetags" => "Can admin freetags",
// "Can admin games" => "Can admin games",
// "Can admin Image Galleries" => "Can admin Image Galleries",
// "Can admin integrator repositories and rules" => "Can admin integrator repositories and rules",
// "Can admin mail-in accounts" => "Can admin mail-in accounts",
// "Can admin newsletters" => "Can admin newsletters",
// "Can admin polls" => "Can admin polls",
// "Can admin public tasks" => "Can admin public tasks",
// "Can admin quicktags" => "Can admin quicktags",
// "Can admin quizzes" => "Can admin quizzes",
// "Can admin received articles" => "Can admin received articles",
// "Can admin received pages" => "Can admin received pages",
// "Can admin rss modules" => "Can admin rss modules",
// "Can admin sheet" => "Can admin sheet",
// "Can admin shoutbox (Edit/remove msgs)" => "Can admin shoutbox (Edit/remove msgs)",
// "Can admin surveys" => "Can admin surveys",
// "Can admin the cms" => "Can admin the cms",
// "Can admin the directory" => "Can admin the directory",
// "Can admin the dynamic content system" => "Can admin the dynamic content system",
// "Can admin the TikiTests" => "Can admin the TikiTests",
// "Can admin the wiki" => "Can admin the wiki",
// "Can admin trackers" => "Can admin trackers",
// "Can admin users" => "Can admin users",
// "Can admin workflow processes" => "Can admin workflow processes",
// "Can approve submissions" => "Can approve submissions",
// "Can assign perms to blog" => "Can assign perms to blog",
// "Can assign perms to file gallery" => "Can assign perms to file gallery",
// "Can assign perms to image gallery" => "Can assign perms to image gallery",
// "Can assign perms to mypage" => "Can assign perms to mypage",
// "Can assign perms to wiki pages" => "Can assign perms to wiki pages",
// "Can attach files to tracker items" => "Can attach files to tracker items",
// "Can attach files to wiki pages" => "Can attach files to wiki pages",
// "Can attach to forum posts" => "Can attach to forum posts",
// "Can ban users or ips" => "Can ban users or ips",
// "Can broadcast messages to all user" => "Can broadcast messages to all user",
// "Can broadcast messages to groups" => "Can broadcast messages to groups",
// "Can browse freetags" => "Can browse freetags",
// "Can browse the calendar" => "Can browse the calendar",
// "Can cache user bookmarks" => "Can cache user bookmarks",
// "Can change events in the calendar" => "Can change events in the calendar",
// "Can change tracker items" => "Can change tracker items",
// "Can clean cache" => "Can clean cache",
// "Can configure modules" => "Can configure modules",
// "Can create a blog" => "Can create a blog",
// "Can create and edit sheets" => "Can create and edit sheets",
// "Can create and edit structures" => "Can create and edit structures",
// "Can create file galleries" => "Can create file galleries",
// "Can create image galleries" => "Can create image galleries",
// "Can create items in personal menu" => "Can create items in personal menu",
// "Can create new css suffixed with -user" => "Can create new css suffixed with -user",
// "Can create new items for trackers" => "Can create new items for trackers",
// "Can create new mapfile" => "Can create new mapfile",
// "Can create user bookmarks" => "Can create user bookmarks",
// "Can create/admin calendars" => "Can create/admin calendars",
// "Can declare an instance as exception" => "Can declare an instance as exception",
// "Can delete comments" => "Can delete comments",
// "Can delete mapfiles" => "Can delete mapfiles",
// "Can download files" => "Can download files",
// "Can edit a gallery file" => "Can edit a gallery file",
// "Can edit all comments" => "Can edit all comments",
// "Can edit any mypage" => "Can edit any mypage",
// "Can edit articles" => "Can edit articles",
// "Can edit content templates" => "Can edit content templates",
// "Can edit copyright notices" => "Can edit copyright notices",
// "Can edit drawings" => "Can edit drawings",
// "Can edit dynamic variables" => "Can edit dynamic variables",
// "Can edit HTML pages" => "Can edit HTML pages",
// "Can edit items in categories" => "Can edit items in categories",
// "Can edit mapfiles" => "Can edit mapfiles",
// "Can edit menu" => "Can edit menu",
// "Can edit menu option" => "Can edit menu option",
// "Can edit object permissions" => "Can edit object permissions",
// "Can edit own forum posts" => "Can edit own forum posts",
// "Can edit pages" => "Can edit pages",
// "Can edit site templates" => "Can edit site templates",
// "Can edit submissions" => "Can edit submissions",
// "Can edit TikiTests" => "Can edit TikiTests",
// "Can edit translations and create new languages" => "Can edit translations and create new languages",
// "Can execute workflow activities" => "Can execute workflow activities",
// "Can export wiki pages using the export feature" => "Can export wiki pages using the export feature",
// "Can insert comments for tracker items" => "Can insert comments for tracker items",
// "Can list file galleries" => "Can list file galleries",
// "Can list image galleries" => "Can list image galleries",
// "Can list mypages" => "Can list mypages",
// "Can list registered users" => "Can list registered users",
// "Can list trackers" => "Can list trackers",
// "Can lock pages" => "Can lock pages",
// "Can participate to rating of wiki pages" => "Can participate to rating of wiki pages",
// "Can play games" => "Can play games",
// "Can post in forums" => "Can post in forums",
// "Can post messages in shoutbox" => "Can post messages in shoutbox",
// "Can post new comments" => "Can post new comments",
// "Can post to a blog" => "Can post to a blog",
// "Can read a topic (Applies only to individual topic perms)" => "Can read a topic (Applies only to individual topic perms)",
// "Can read article headings" => "Can read article headings",
// "Can read articles" => "Can read articles",
// "Can read blogs" => "Can read blogs",
// "Can read comments" => "Can read comments",
// "Can read forums" => "Can read forums",
// "Can remove" => "Can remove",
// "Can remove articles" => "Can remove articles",
// "Can remove association between two pages in a translation set" => "Can remove association between two pages in a translation set",
// "Can remove submissions" => "Can remove submissions",
// "Can rename pages" => "Can rename pages",
// "Can replay the TikiTests" => "Can replay the TikiTests",
// "Can report a link to the webmaster" => "Can report a link to the webmaster",
// "Can report msgs to moderator" => "Can report msgs to moderator",
// "Can rollback pages" => "Can rollback pages",
// "Can save as minor edit" => "Can save as minor edit",
// "Can search" => "Can search",
// "Can send a link to a friend" => "Can send a link to a friend",
// "Can send articles to other sites" => "Can send articles to other sites",
// "Can send articles to this site" => "Can send articles to this site",
// "Can send instances after completion" => "Can send instances after completion",
// "Can send newsletters" => "Can send newsletters",
// "Can send pages to other sites" => "Can send pages to other sites",
// "Can send pages to this site" => "Can send pages to this site",
// "Can send tasks to other users" => "Can send tasks to other users",
// "Can start threads in forums" => "Can start threads in forums",
// "Can submit articles" => "Can submit articles",
// "Can submit sites to the directory" => "Can submit sites to the directory",
// "Can subscribe any email to newsletters" => "Can subscribe any email to newsletters",
// "Can subscribe many e-mails at once (requires tiki_p_subscribe email)" => "Can subscribe many e-mails at once (requires tiki_p_subscribe email)",
// "Can subscribe to groups" => "Can subscribe to groups",
// "Can subscribe to newsletters" => "Can subscribe to newsletters",
// "Can suggest faq questions" => "Can suggest faq questions",
// "Can suggest items" => "Can suggest items",
// "Can tag objects" => "Can tag objects",
// "Can take quizzes" => "Can take quizzes",
// "Can take surveys" => "Can take surveys",
// "Can unassign tags from an object" => "Can unassign tags from an object",
// "Can upload files" => "Can upload files",
// "Can upload images" => "Can upload images",
// "Can upload personal files" => "Can upload personal files",
// "Can upload pictures to wiki pages" => "Can upload pictures to wiki pages",
// "Can upload zip files with files" => "Can upload zip files with files",
// "Can upload zip files with images" => "Can upload zip files with images",
// "Can use content templates" => "Can use content templates",
// "Can use Directory Batch Load" => "Can use Directory Batch Load",
// "Can use Directoy Batch Load" => "Can use Directoy Batch Load",
// "Can use HTML in pages" => "Can use HTML in pages",
// "Can use live support system" => "Can use live support system",
// "Can use tasks" => "Can use tasks",
// "Can use the chat system" => "Can use the chat system",
// "Can use the directory" => "Can use the directory",
// "Can use the messaging system" => "Can use the messaging system",
// "Can use the mini event calendar" => "Can use the mini event calendar",
// "Can use the newsreader" => "Can use the newsreader",
// "Can use the notepad" => "Can use the notepad",
// "Can use the page as a tracker template" => "Can use the page as a tracker template",
// "Can use webmail" => "Can use webmail",
// "Can validate submited links" => "Can validate submited links",
// "Can view action log" => "Can view action log",
// "Can view action log for users of his own groups" => "Can view action log for users of his own groups",
// "Can view any mypage" => "Can view any mypage",
// "Can view categories" => "Can view categories",
// "Can view categorized items" => "Can view categorized items",
// "Can view charts" => "Can view charts",
// "Can view contents of mapfiles" => "Can view contents of mapfiles",
// "Can view events details" => "Can view events details",
// "Can view faqs" => "Can view faqs",
// "Can view file galleries" => "Can view file galleries",
// "Can view file galleries explorer" => "Can view file galleries explorer",
// "Can view file galleries path" => "Can view file galleries path",
// "Can view HTML pages" => "Can view HTML pages",
// "Can view image galleries" => "Can view image galleries",
// "Can view integrated repositories" => "Can view integrated repositories",
// "Can view mapfiles" => "Can view mapfiles",
// "Can view page/pages" => "Can view page/pages",
// "Can view poll results" => "Can view poll results",
// "Can view quiz stats" => "Can view quiz stats",
// "Can view rating of wiki pages" => "Can view rating of wiki pages",
// "Can view rating result for tracker items" => "Can view rating result for tracker items",
// "Can view referer stats" => "Can view referer stats",
// "Can view sheet" => "Can view sheet",
// "Can view sheet history" => "Can view sheet history",
// "Can view shoutbox" => "Can view shoutbox",
// "Can view site stats" => "Can view site stats",
// "Can view site templates" => "Can view site templates",
// "Can view source of wiki pages" => "Can view source of wiki pages",
// "Can view survey stats" => "Can view survey stats",
// "Can view Tikiwiki tools calendar" => "Can view Tikiwiki tools calendar",
// "Can view trackers" => "Can view trackers",
// "Can view trackers closed items" => "Can view trackers closed items",
// "Can view trackers pending items" => "Can view trackers pending items",
// "Can view user quiz results" => "Can view user quiz results",
// "Can view wiki attachments and download" => "Can view wiki attachments and download",
// "Can view wiki comments" => "Can view wiki comments",
// "Can view wiki history" => "Can view wiki history",
// "Can view/edit only one's own mypages" => "Can view/edit only one's own mypages",
// "Can vote" => "Can vote",
// "Can vote a rating for tracker items" => "Can vote a rating for tracker items",
// "Can vote comments" => "Can vote comments",
// "Can vote comments in forums" => "Can vote comments in forums",
// "Can vote polls" => "Can vote polls",
// "Can watch structure" => "Can watch structure",
// "Can watch tracker" => "Can watch tracker",
// "Submited articles automatically approved" => "Submited articles automatically approved",
// "Submited links are valid" => "Submited links are valid",
// "Anti-Bot verification code" => "Anti-Bot verification code",
// "Enter the code you see above" => "Enter the code you see above",
// "Version" => "Version",
// "more info" => "more info",
// "Properties" => "Properties",
// "Tip" => "Tip",
// "posts:" => "posts:",
// "top of page" => "top of page",
// "Report this post" => "Report this post",
// "Style" => "Style",
// "Threaded" => "Threaded",
// "Reply to the selected post" => "Reply to the selected post",
// "Smileys" => "Smileys",
// "Quicktags" => "Quicktags",
// "Reply to parent post" => "Reply to parent post",
// "Enter your name" => "Enter your name",
// "Post as Anonymous" => "Post as Anonymous",
// "Contributors" => "Contributors",
// "Copyrights" => "Copyrights",
// "Syntax" => "Syntax",
// "Duplicate File Gallery" => "Duplicate File Gallery",
// "Duplicate categories" => "Duplicate categories",
// "Duplicate perms" => "Duplicate perms",
// "View inserted gallery" => "View inserted gallery",
// "Display Properties" => "Display Properties",
// "This Gallery is Public" => "This Gallery is Public",
// "The files can be locked at download:" => "The files can be locked at download:",
// "Maximum number of archives for each file" => "Maximum number of archives for each file",
// "Perhaps you were looking for:" => "Perhaps you were looking for:",
// "There are no wiki pages similar to '{\$page}'" => "There are no wiki pages similar to '{\$page}'",
// "You are not logged in." => "You are not logged in.",
// "Go to Login Page" => "Go to Login Page",
// "(page will be orphaned)" => "(page will be orphaned)",
// "Close Window" => "Close Window",
// "Go to" => "Go to",
// "Private Gallery" => "Private Gallery",
// "Active Perms" => "Active Perms",
// "Display" => "Display",
// "Archives" => "Archives",
// "Upload New Version" => "Upload New Version",
// "Download and lock" => "Download and lock",
// "Show as a column" => "Show as a column",
// "Show in popup box" => "Show in popup box",
// "Both" => "Both",
// "Show an icon in a column" => "Show an icon in a column",
// "Exact&nbsp;match" => "Exact&nbsp;match",
// "any type" => "any type",
// "all topic" => "all topic",
// "any language" => "any language",
// "any category" => "any category",
// "Show php error messages" => "Show php error messages",
// "Last update from SVN" => "Last update from SVN",
// "Folksonomy Tags" => "Folksonomy Tags",
// "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together." => "Put tags separated by spaces. For tags with more than one word, use no spaces and put words together.",
// "Tags" => "Tags",
// "Translate tags" => "Translate tags",
// "Images Galleries" => "Images Galleries",
// "Edit this page!" => "Edit this page!",
// "RSS Wiki" => "RSS Wiki",
// "RSS Blogs" => "RSS Blogs",
// "RSS Articles" => "RSS Articles",
// "RSS Image Galleries" => "RSS Image Galleries",
// "RSS File Galleries" => "RSS File Galleries",
// "RSS Forums" => "RSS Forums",
// "RSS Maps" => "RSS Maps",
// "RSS Directories" => "RSS Directories",
// "RSS Calendars" => "RSS Calendars",
// "Loading" => "Loading",
// "\\074span class=\"shortcut\"\\076C\\074/span\\076lose" => "\\074span class=\"shortcut\"\\076C\\074/span\\076lose",
// "\\074span class=\"shortcut\"\\076N\\074/span\\076ext" => "\\074span class=\"shortcut\"\\076N\\074/span\\076ext",
// "\\074span class=\"shortcut\"\\076P\\074/span\\076revious" => "\\074span class=\"shortcut\"\\076P\\074/span\\076revious",
// "Cancel Fullscreen" => "Cancel Fullscreen",
// "Fullscreen" => "Fullscreen",
// "Information" => "Information",
// "Show Tree" => "Show Tree",
// "Hide Tree" => "Hide Tree",
// "Are you sure you want to delete the selected files?" => "Are you sure you want to delete the selected files?",
// "Other Sorts" => "Other Sorts",
// "No Additionnal Sort" => "No Additionnal Sort",
// "No information" => "No information",
// "To validate your account and login to the site, please click on the following link:" => "To validate your account and login to the site, please click on the following link:",
// "The administrator approved your account." => "The administrator approved your account.",
// "Confirm your email at %s" => "Confirm your email at %s",
// "Author:" => "Author:",
// "New topic:" => "New topic:",
// "Topic:" => "Topic:",
// "Contribution" => "Contribution",
// "You sent a request with the subject:" => "You sent a request with the subject:",
// "Use the subject to indicate the operation to apply:" => "Use the subject to indicate the operation to apply:",
// "GET:WikiName to get a wiki page" => "GET:WikiName to get a wiki page",
// "PUT:WikiName to update/create a wiki page (use the body for the page data)" => "PUT:WikiName to update/create a wiki page (use the body for the page data)",
// "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)" => "APPEND:WikiName to append data to a Wiki page (use the body for the data to add)",
// "PREPEND:WikiName to append the data at the top" => "PREPEND:WikiName to append the data at the top",
// "Tiki mail-in auto-reply." => "Tiki mail-in auto-reply.",
// "New message arrived from %s" => "New message arrived from %s",
// "Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now." => "Your Tiki account registration request for {\$mail_site} was validated by the site admin and your account is active now.",
// "To login with your username and password, please follow this link:" => "To login with your username and password, please follow this link:",
// "Tiki User Account Activated" => "Tiki User Account Activated",
// "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first" => "{\$mail_user} <{\$mail_email}> has requested a new password on {\$mail_site}, but you need to validate his account first",
// "Go to your friendship network to accept or refuse this request" => "Go to your friendship network to accept or refuse this request",
// "You're invited to join my network of friends!" => "You're invited to join my network of friends!",
// "Newsletter:" => "Newsletter:",
// "Bye bye from %s at %s" => "Bye bye from %s at %s",
// "Welcome to %s at %s" => "Welcome to %s at %s",
// "Someone coming from IP Address" => "Someone coming from IP Address",
// "requested a reminder of the password for your account" => "requested a reminder of the password for your account",
// "requested password reset for your account" => "requested password reset for your account",
// "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-change_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in." => "Please click on the following link to confirm you wish to reset your password and go to the screen where you must enter a new \"permanent\" password. Please pick a password only you will know, and don't share it with anyone else.\n{\$mail_machine}/tiki-change_password.php?user={\$mail_user|escape:'url'}&actpass={\$mail_apass}\n\nDone! You should be logged in.",
// "Important: Username & password are CaSe SenSitiVe" => "Important: Username & password are CaSe SenSitiVe",
// "Important: The old password remains active if you don't click the link above." => "Important: The old password remains active if you don't click the link above.",
// "New article submitted at %s" => "New article submitted at %s",
// "Look at this link:" => "Look at this link:",
// "A friend sends you a link from: " => "A friend sends you a link from: ",
// "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}" => "ItemID {\$mail_itemId} was deleted in the tracker {\$mail_trackerName}",
// "View the tracker item at:" => "View the tracker item at:",
// "Download the file at:" => "Download the file at:",
// "Tracker was modified at" => "Tracker was modified at",
// "Please visit this link before login again:" => "Please visit this link before login again:",
// "Confirm your account at %s" => "Confirm your account at %s",
// "You'll receive email notification once your account is activated." => "You'll receive email notification once your account is activated.",
// "Please do not attempt to login until you receive the email notification." => "Please do not attempt to login until you receive the email notification.",
// "New article post at %s" => "New article post at %s",
// "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "New blog post: {\$mail_title}, \"{\$mail_post_title}\", by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "New blog post at %s" => "New blog post at %s",
// "View item calendar at:" => "View item calendar at:",
// "Modified calendar item" => "Modified calendar item",
// "New calendar item" => "New calendar item",
// "changed" => "changed",
// "removed" => "removed",
// "Old" => "Old",
// "updated" => "updated",
// "File Gallery %s changed" => "File Gallery %s changed",
// "A file was removed from the file gallery" => "A file was removed from the file gallery",
// "File Name" => "File Name",
// "A new file was posted to file gallery" => "A new file was posted to file gallery",
// "Posted by" => "Posted by",
// "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}:" => "New forum post in <{\$mail_forum|truncate:20:\"...\"}> by {\$mail_author}:",
// "Image Gallery {\$galleryName} changed" => "Image Gallery {\$galleryName} changed",
// "A new file was posted to image gallery" => "A new file was posted to image gallery",
// "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The map {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "You can view the updated map following this link:" => "You can view the updated map following this link:",
// "You can edit the map following this link:" => "You can edit the map following this link:",
// "A page has been added to your watched sub-structure:" => "A page has been added to your watched sub-structure:",
// "A page has been removed from your watched sub-structure:" => "A page has been removed from your watched sub-structure:",
// "A page has been promoted out your watched sub-structure:" => "A page has been promoted out your watched sub-structure:",
// "A page has been demoted to your watched structure:" => "A page has been demoted to your watched structure:",
// "Structure modified" => "Structure modified",
// "A new file have been attached to page" => "A new file have been attached to page",
// "File name" => "File name",
// "New attachment on %s, page" => "New attachment on %s, page",
// "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was created by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "The page {\$mail_page} was commented by {\$mail_user} at {\$mail_date|tiki_short_datetime}",
// "Wiki page %s was commented on by" => "Wiki page %s was commented on by",
// "an anonymous user" => "an anonymous user",
// "Wiki page renamed" => "Wiki page renamed",
// "Old name" => "Old name",
// "Thank you for your registration. You may log in now." => "Thank you for your registration. You may log in now.",
// "click on the map to zoom or pan, do not drag" => "click on the map to zoom or pan, do not drag",
// "Query Results" => "Query Results",
// "Querying" => "Querying",
// "Scroll Up" => "Scroll Up",
// "Scroll Down" => "Scroll Down",
// "Zoom out" => "Zoom out",
// "Pan" => "Pan",
// "Zoom in" => "Zoom in",
// "select zoom/pan/query and image size" => "select zoom/pan/query and image size",
// "Go" => "Go",
// "View the Map Only" => "View the Map Only",
// "Reset Map" => "Reset Map",
// "Layer" => "Layer",
// "This layer has been set by the maps administrator to not be downloadable" => "This layer has been set by the maps administrator to not be downloadable",
// "from the mapfile:" => "from the mapfile:",
// "hits last 7 days" => "hits last 7 days",
// "Zoom out x2" => "Zoom out x2",
// "Zoom in x2" => "Zoom in x2",
// "Mapfile History" => "Mapfile History",
// "Version:" => "Version:",
// "c=compare" => "c=compare",
// "d=diff" => "d=diff",
// "Older Version" => "Older Version",
// "back to" => "back to",
// "1" => "1",
// "2" => "2",
// "3" => "3",
// "4" => "4",
// "5" => "5",
// "Message Broadcast" => "Message Broadcast",
// "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences." => "If you want people to be able to reply to you, enable <a href='tiki-user_preferences.php'>Allow messages from other users</a> in your preferences.",
// "ERROR" => "ERROR",
// "Separate multiple usernames with a comma (&nbsp;,&nbsp;)." => "Separate multiple usernames with a comma (&nbsp;,&nbsp;).",
// "CC" => "CC",
// "BCC" => "BCC",
// "No messages to download" => "No messages to download",
// "Unflag" => "Unflag",
// "Cc" => "Cc",
// "'name' parameter for tikimodule missed" => "'name' parameter for tikimodule missed",
// "opp side" => "opp side",
// "Unassign this module" => "Unassign this module",
// "Are you sure you want to unassign this module?" => "Are you sure you want to unassign this module?",
// "Toggle module contents" => "Toggle module contents",
// "toggle" => "toggle",
// "\$tpl_module_title" => "\$tpl_module_title",
// "Cache" => "Cache",
// "Links" => "Links",
// "Hotwords" => "Hotwords",
// "QuickTags" => "QuickTags",
// "Chat" => "Chat",
// "Cookies" => "Cookies",
// "Mail-in" => "Mail-in",
// "Shoutbox" => "Shoutbox",
// "Shoutbox Words" => "Shoutbox Words",
// "Display type unknown, you have to enter the banner type" => "Display type unknown, you have to enter the banner type",
// "Newsreader" => "Newsreader",
// "Webmail" => "Webmail",
// "WfMenu" => "WfMenu",
// "Workflow" => "Workflow",
// "FriendsMenu" => "FriendsMenu",
// "Community" => "Community",
// "WikiMenu" => "WikiMenu",
// "Sandbox" => "Sandbox",
// "GalMenu" => "GalMenu",
"New article" => "Neuer Artikel",
// "ForMenu" => "ForMenu",
// "DirMenu" => "DirMenu",
// "FileGalMenu" => "FileGalMenu",
// "QuizMenu" => "QuizMenu",
// "ShtMenu" => "ShtMenu",
// "TrkMenu" => "TrkMenu",
// "SrvMenu" => "SrvMenu",
// "Send events" => "Send events",
// "Admin events" => "Admin events",
// "EphMenu" => "EphMenu",
// "ChartMenu" => "ChartMenu",
// "AdmMenu" => "AdmMenu",
// "Admin" => "Admin",
// "Integrator" => "Integrator",
// "DSN" => "DSN",
// "\$module_title" => "\$module_title",
// "More..." => "More...",
// "To configure your Tiki" => "To configure your Tiki",
// "Admin Home" => "Admin Home",
// "from the menu" => "from the menu",
// "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>" => "Read the <a class=\"link\" href=\"http://doc.tikiwiki.org/Configuration\" title=\"Tikiwiki Documentation\" target=\"_blank\">configuration documentation</a>",
// "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies" => "Watch the <a class=\"link\" href=\"http://tikiwiki.org/TikiMovies\" title=\"Demos\" target=\"_blank\">demo movies",
// "To remove this module" => "To remove this module",
// "and remove the assistant module" => "and remove the assistant module",
// "You can also add other modules" => "You can also add other modules",
// "To customize the menu" => "To customize the menu",
// "and edit menu ID 42" => "and edit menu ID 42",
// "Or, create your own menu and add it to a module" => "Or, create your own menu and add it to a module",
// "To begin configuring Tiki, please" => "To begin configuring Tiki, please",
// "as the Admin" => "as the Admin",
// "The Tikiwiki Community" => "The Tikiwiki Community",
// "To learn more, visit: <a href=\"http://www.tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://www.tikiwiki.org</a>" => "To learn more, visit: <a href=\"http://www.tikiwiki.org\" title=\"The Tikiwiki Community\" target=\"_blank\">http://www.tikiwiki.org</a>",
// "Tikiwiki Documentation" => "Tikiwiki Documentation",
// "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>" => "For help, visit <a href=\"http://doc.tikiwiki.org\" title=\"Tikiwiki Documentation\" target=\"_blank\">http://doc.tikiwiki.org</a>",
// "Last `\$module_rows` blog comments" => "Last `\$module_rows` blog comments",
// "Last blog comments" => "Last blog comments",
// " on blogpost " => " on blogpost ",
// "April" => "April",
// "August" => "August",
// "September" => "September",
// "November" => "November",
// "\$modcattitle" => "\$modcattitle",
// "Top `\$module_rows` topics" => "Top `\$module_rows` topics",
// "Folksonomy" => "Folksonomy",
// "Tags This Page Has" => "Tags This Page Has",
// "Add tags" => "Add tags",
// "More Like This" => "More Like This",
// "Most popular tags" => "Most popular tags",
// "List everything tagged" => "List everything tagged",
// "My prefered tags" => "My prefered tags",
// "\$type" => "\$type",
// "Last `\$module_rows` Images" => "Last `\$module_rows` Images",
// "insert original" => "insert original",
// "insert thumbnail" => "insert thumbnail",
// "Last `\$module_rows` modified events" => "Last `\$module_rows` modified events",
// "more" => "more",
// "Last `\$module_rows` Modified Comments" => "Last `\$module_rows` Modified Comments",
// "Last Modified Comments" => "Last Modified Comments",
// "Last `\$module_rows` visitors" => "Last `\$module_rows` visitors",
// "No avatar." => "No avatar.",
// "You" => "You",
"Logged in as" => "Angemeldet als",
"Switch User" => "Benutzer wechseln",
// "applicable for this item" => "applicable for this item",
"Switch" => "Wechseln",
"Switch user" => "Benutzer wechseln",
// "Login through CAS" => "Login through CAS",
// "Login through Shibboleth" => "Login through Shibboleth",
"Login as" => "Anmelden als",
// "Click here to register" => "Click here to register",
// "Click here if you've forgotten your password" => "Click here if you've forgotten your password",
// "Click here to login using the default security protocol" => "Click here to login using the default security protocol",
// "Click here to login using a secure protocol" => "Click here to login using a secure protocol",
// "local account" => "local account",
// "OpenID Login" => "OpenID Login",
// "What is OpenID?" => "What is OpenID?",
// "Tiki Logo" => "Tiki Logo",
// "Send a message" => "Send a message",
// "Random Images" => "Random Images",
// "Your email could not be validated; make sure you email is correct and click register below." => "Your email could not be validated; make sure you email is correct and click register below.",
// "RSS Feeds" => "RSS Feeds",
// "Wiki RSS" => "Wiki RSS",
// "Blogs RSS" => "Blogs RSS",
// "Calendars" => "Calendars",
// "in:" => "in:",
// "New Tracker Items" => "New Tracker Items",
// "New Calendar Events" => "New Calendar Events",
// "`\$slvn_info.label`" => "`\$slvn_info.label`",
"Nothing has changed" => "Keine &Auml;nderungen",
// "click to show/hide" => "click to show/hide",
"Site Language:" => "Site-Sprache:",
"Site default" => "Site-Default",
"TikiTests Menu" => "TikiTests Men&uuml;",
"List Tests" => "Tests auflisten",
"Create Test" => "Test erstellen",
// "Top `\$module_rows` Forum Posters" => "Top `\$module_rows` Forum Posters",
// "Top Forum Posters" => "Top Forum Posters",
// "Top `\$module_rows` Objects" => "Top `\$module_rows` Objects",
// "Top Objects" => "Top Objects",
// "Page translation" => "Page translation",
// "There are no translations of this page." => "There are no translations of this page.",
// "Up-to-date-ness" => "Up-to-date-ness",
// "Better translations" => "Better translations",
// "update from it" => "update from it",
// "None match your" => "None match your",
"Set your preferred languages." => "Bevorzuge Sprachen einstellen.",
"preferred languages" => "Bevorzugte Sprachen",
// "Equivalent translations" => "Equivalent translations",
"Translations that need improvement" => "Verbesserungsw&uuml;rdige &Uuml;bersetzungen",
// "update it" => "update it",
// "Upcoming `\$module_rows` events" => "Upcoming `\$module_rows` events",
// "The Next Event" => "The Next Event",
// "No Upcoming Events" => "No Upcoming Events",
// "click to view" => "click to view",
// "Public tasks" => "Public tasks",
// "select" => "select",
// "You need to activate user and/or group trackers" => "You need to activate user and/or group trackers",
// "Top users" => "Top users",
// "More" => "More",
// "on host" => "on host",
// " on page " => " on page ",
// "Changes that need to be reproduced are highlighted below." => "Changes that need to be reproduced are highlighted below.",
// "Click to see the ratings" => "Click to see the ratings",
// "[-]" => "[-]",
"Errors" => "Fehler",
// "Insert/Edit an internal wiki link" => "Insert/Edit an internal wiki link",
// "Wiki Link insert" => "Wiki Link insert",
// "Please make a selection of text in order to create a link" => "Please make a selection of text in order to create a link",
// "Insert an image" => "Insert an image",
// "Tiki Image - Insert an image" => "Tiki Image - Insert an image",
// "Are you sure you want to remove this module?" => "Are you sure you want to remove this module?",
// "Powered by" => "Powered by",
// "Backlinks" => "Backlinks",
// "Parent page" => "Parent page",
// "Last edited by" => "Last edited by",
// "based on work by" => "based on work by",
// "Created by:" => "Created by:",
// "Last Modification:" => "Last Modification:",
// "For" => "For",
// "Jump to Content" => "Jump to Content",
// "Report to Webmaster" => "Report to Webmaster",
// "database queries used in " => "database queries used in ",
// "star" => "star",
// "half star" => "half star",
// "Send a link" => "Send a link",
// "Location : " => "Location : ",
// "Show/Hide Left Menus" => "Show/Hide Left Menus",
// "Show/Hide Right Menus" => "Show/Hide Right Menus",
// "Email this page" => "Email this page",
// "Backups" => "Backups",
// "{|} Files Attached" => "{|} Files Attached",
// "Copyright" => "Copyright",
// "RSS Trackers" => "RSS Trackers",
// "Note: if you want to use images please save the post first and you\n\twill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\n\tor use the image URL to include images using the WYSIWYG editor. " => "Note: if you want to use images please save the post first and you\n\twill be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor\n\tor use the image URL to include images using the WYSIWYG editor. ",
// "Permalink" => "Permalink",
// "Trackback pings" => "Trackback pings",
// "URI" => "URI",
// "Show/Hide Left Modules" => "Show/Hide Left Modules",
// "Show/Hide Right Modules" => "Show/Hide Right Modules",
// "Last update from CVS" => "Last update from CVS",
// "Translate in" => "Translate in",
// "babelfish it" => "babelfish it",
// "Welcome to" => "Welcome to",
// "Design by" => "Design by",
// "Do not group by item" => "Do not group by item",
// "Group by item" => "Group by item",
// "Tiki Action Calendar" => "Tiki Action Calendar",
"Apply" => "&Uuml;bernehmen",
"Reset" => "Zur&uuml;cksetzen",
// "Test" => "Test",
// "RSS" => "RSS",
// "Intertiki" => "Intertiki",
// "InterTiki" => "InterTiki",
// "Freetags" => "Freetags",
// "i18n" => "i18n",
// "Customize look and feel of your Tiki" => "Customize look and feel of your Tiki",
// "Look &amp; Feel" => "Look &amp; Feel",
// "Text area" => "Text area",
// "Multimedia" => "Multimedia",
// "Trackbacks Pings" => "Trackbacks Pings",
// "Not Installed" => "Not Installed",
// "Blogs have a custom heading" => "Blogs have a custom heading",
// "Force and limit categorization to within subtree of" => "Force and limit categorization to within subtree of",
// "Title length" => "Title length",
// "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or" => "To add/remove calendars, look for \"Calendar\" under \"Admin\" on the application menu, or",
// "Quarter" => "Quarter",
// "Semester" => "Semester",
// "JsCalendar" => "JsCalendar",
// "First day of the week" => "First day of the week",
// "Depends user language" => "Depends user language",
// "Split hours in periods of" => "Split hours in periods of",
// "1 minute" => "1 minute",
// "10 minutes" => "10 minutes",
// "15 minutes" => "15 minutes",
// "30 minutes" => "30 minutes",
// "First year in the dropdown, either year number, or relative to current year (+/- N)" => "First year in the dropdown, either year number, or relative to current year (+/- N)",
// "if no jscalendar" => "if no jscalendar",
// "Last year in the dropdown, either year number, or relative to current year (+/- N)" => "Last year in the dropdown, either year number, or relative to current year (+/- N)",
// "Use categories to regroup various Tiki objects" => "Use categories to regroup various Tiki objects",
// "Link to" => "Link to",
// "Browse categories" => "Browse categories",
// "Administer categories" => "Administer categories",
// "Exclude These Category IDs from Path (comma delimited)" => "Exclude These Category IDs from Path (comma delimited)",
// "Search may show forbidden results. Much better performance though." => "Search may show forbidden results. Much better performance though.",
// "Permission to all (not just any) of an object's categories is required for access" => "Permission to all (not just any) of an object's categories is required for access",
// "Categories browse uses PhpLayers" => "Categories browse uses PhpLayers",
// "The feature must be activated" => "The feature must be activated",
// "Can specify notification emails when creating an article" => "Can specify notification emails when creating an article",
// "Batch upload (CSV file):" => "Batch upload (CSV file):",
// "Users sort order" => "Users sort order",
// "Score ascending" => "Score ascending",
// "Score descending" => "Score descending",
// "Name ascending" => "Name ascending",
// "Name descending" => "Name descending",
// "Login ascending" => "Login ascending",
// "Login descending" => "Login descending",
// "Copyright allows to determine a copyright for all the objects of tikiwiki" => "Copyright allows to determine a copyright for all the objects of tikiwiki",
// "Copyright Management" => "Copyright Management",
// "Enable Feature for Wiki" => "Enable Feature for Wiki",
// "Enable Feature for Articles" => "Enable Feature for Articles",
// "Enable Feature for Blogues" => "Enable Feature for Blogues",
// "Enable Feature for Faqs" => "Enable Feature for Faqs",
// "Show Country Flag" => "Show Country Flag",
// "Question and Answer prefix on Answers" => "Question and Answer prefix on Answers",
// "Q and A" => "Q and A",
// "Question ID" => "Question ID",
"Please see the <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>evaluation of each feature</a> on Tiki's developer site." => "Bitte die <a class='rbox-link' target='tikihelp' href='http://doc.tikiwiki.org/Features'>Bewertung der Funktionen</a> auf der Tiki Dokumentationsseite beachten.",
"No tabs" => "Tabs abschalten",
"Main" => "Aktivierung der Hauptkomponenten",
"Global Features" => "&Uuml;bergreifende Einstellungen",
"More Functionality" => "Aktivierung weiterer Komponenten",
"Technology" => "Technisches Brimborium",
"UI Enhancements" => "Darstellungsoptimierungen",
// "Extra Stuff &amp; Fun" => "Extra Stuff &amp; Fun",
"Content Related" => "Inhaltsbezogen",
"Main Features" => "Hauptkomponenten",
// "Site Global Features" => "Site Global Features",
"Feature documentation links" => "Doku-Links zu Komponenten",
"Help System (Feature documentation links)" => "Hilfesystem (Doku-Links zu Komponenten)",
// "Additional Features" => "Additional Features",
// "Featured Help" => "Featured Help",
// "Spreadsheet" => "Spreadsheet",
// "Tiki Sheet" => "Tiki Sheet",
"Copyright System" => "Copyrightsystem",
"Copyright system" => "Copyrightsystem",
"Tell a Friend" => "Erz&auml;hle dies weiter",
"Allow to post comments as Anonymous" => "Unbekannte Benutzer d&uuml;rfen kommentieren",
"Technical Features" => "Technisches Brimborium",
"Search engine friendly url" => "Suchmaschinen-freundliche URLs",
// "Swffix" => "Swffix",
// "Ajax" => "Ajax",
// "HTML Purifier" => "HTML Purifier",
"HTML Purifier (Content is cleaned to XHTML 1.1 Strict on each save)" => "HTML Purifier (Inhalte werden beim Speichern auf XHTML 1.1 ges&auml;ubert)",
"User interface enhancement features" => "Darstellungsoptimierungen",
"JavaScript popup date selector" => "JavaScript-Aufwahlbox f&uuml;r Datum",
// "PHPLayers" => "PHPLayers",
"Allow users to activate fullscreen mode" => "Benutzer darf Fullscreen-Anzeige aktivieren",
// "Css Menus (suckerfish)" => "Css Menus (suckerfish)",
// "Shadowbox" => "Shadowbox",
"required" => "erforderlich",
// "Mootools" => "Mootools",
"Experimental Features" => "Experimentelles",
"Friendship" => "Freundschaft",
"Use File Galleries for images inclusion" => "Bildergalerien f&uuml;r Bildeinbindung in Seiten erlauben",
"Use Quote plugin rather than &ldquo;&gt;&rdquo; for quoting" => "Quote-PlugIn statt &ldquo;&gt;&rdquo; Zitierung verwenden",
// "Action Calendar" => "Action Calendar",
"Tiki action calendar" => "Tiki-Aktionskalender",
// "TikiTests" => "TikiTests",
"Display 'MyTiki' in the application menu" => "'MeinTiki' im Anwendungsmen&uuml; anzeigen",
"User Contacts" => "Benutzerkontakte",
"User Levels" => "Benutzerlevel",
"Allow download limit per file" => "Dateiweise Download-Begrenzung erlauben",
"Prevent download if score becomes negative" => "Downloads bei negativem Score verbieten",
// "File author" => "File author",
// "For not registered author" => "For not registered author",
// "Yes, even in the same gallery" => "Yes, even in the same gallery",
// "Only in different galleries" => "Only in different galleries",
// "The server must be able to read/write the directory." => "The server must be able to read/write the directory.",
// "The directory can be outside the web space." => "The directory can be outside the web space.",
// "PodCast directory (must be web accessible):" => "PodCast directory (must be web accessible):",
// "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols" => "If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload files in that dir, either by scp, ftp, or other protocols",
// "The server must be able to read the directory." => "The server must be able to read the directory.",
// "MIME Type" => "MIME Type",
// "Enable topics archiving" => "Enable topics archiving",
// "Allow first posts of a thread to have an empty body (will be a thread title)" => "Allow first posts of a thread to have an empty body (will be a thread title)",
// "Reply posts are empty" => "Reply posts are empty",
// "Creation Date (asc)" => "Creation Date (asc)",
// "Search some forums by name (on \"forum list\")" => "Search some forums by name (on \"forum list\")",
// "Search some forums by content on \"forum list\" (needs feature_search activated)" => "Search some forums by content on \"forum list\" (needs feature_search activated)",
// "Search in topics content on forum page (needs feature_search activated)" => "Search in topics content on forum page (needs feature_search activated)",
// "Search method when searching in content: Tiki search local to a forum" => "Search method when searching in content: Tiki search local to a forum",
// "Search method when searching in content: Non-Tiki search local to a forum" => "Search method when searching in content: Non-Tiki search local to a forum",
// "Do not prefix messages titles by 'Re: '" => "Do not prefix messages titles by 'Re: '",
// "Threads default preferences" => "Threads default preferences",
// "Allow to manage thread defaults in each forum configuration" => "Allow to manage thread defaults in each forum configuration",
// "Display thread configuration bar to override defaults" => "Display thread configuration bar to override defaults",
// "Configuration bar settings are kept for all forums during the user session:" => "Configuration bar settings are kept for all forums during the user session:",
// "Default thread style" => "Default thread style",
// "Default thread sort mode" => "Default thread sort mode",
// "Freetags rock!" => "Freetags rock!",
// "Freetag Browsing" => "Freetag Browsing",
// "Show Tag Cloud" => "Show Tag Cloud",
// "Random tag cloud colors (separated by comma)" => "Random tag cloud colors (separated by comma)",
// "Preload freetag random search when arriving on <a href=\"tiki-browse_freetags.php\">freetag search grid</a>" => "Preload freetag random search when arriving on <a href=\"tiki-browse_freetags.php\">freetag search grid</a>",
// "Number of Tags to show in Cloud" => "Number of Tags to show in Cloud",
// "Number of Tags to show in Tag Suggestions" => "Number of Tags to show in Tag Suggestions",
// "Valid characters pattern" => "Valid characters pattern",
// "Only accept alphanumeric ASCII freetags (no accents or special chars)" => "Only accept alphanumeric ASCII freetags (no accents or special chars)",
// "Accept all" => "Accept all",
// "Only accept lowercase freetags" => "Only accept lowercase freetags",
// "Handle multilingual freetags" => "Handle multilingual freetags",
// "Tag Management" => "Tag Management",
// "Cleanup unused tags" => "Cleanup unused tags",
// "cleanup" => "cleanup",
// "More Like This/Get Similar Module" => "More Like This/Get Similar Module",
// "More Like This algorithm" => "More Like This algorithm",
// "basic" => "basic",
// "weighted" => "weighted",
// "Basic algorithm - Minimum amount of tags in common" => "Basic algorithm - Minimum amount of tags in common",
// "6" => "6",
// "7" => "7",
// "8" => "8",
// "9" => "9",
// "Freetag 3D Browser Configuration" => "Freetag 3D Browser Configuration",
// "Enable freetags 3D browser" => "Enable freetags 3D browser",
// "Graph appearance" => "Graph appearance",
// "Node color" => "Node color",
// "Camera settings" => "Camera settings",
// "Physics engine" => "Physics engine",
// "Display image informations in a mouseover box" => "Display image informations in a mouseover box",
// "yes, and don't display those informations under the image" => "yes, and don't display those informations under the image",
// "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)" => "Use default max rows, images per row, thumbnails size and scale size for all galleries (set values below)",
// "Default scale size" => "Default scale size",
// "Exterminator" => "Exterminator",
// "Move images from database storage to filesystem storage" => "Move images from database storage to filesystem storage",
// "Move images from old filesystem store to new directory" => "Move images from old filesystem store to new directory",
// "Moved" => "Moved",
"Tikiwiki version" => "Tikiwiki Version",
// "Unix" => "Unix",
// "Windows" => "Windows",
"visible to admin only" => "nur f&uuml;r Admin sichtbar",
"smarty notice reporting" => "Smarty 'notice' Berichterstattung",
"Log Mail in Tiki Logs:" => "eMails im Log protokollieren:",
"Log SQL:" => "SQL protokollieren:",
// "(standard)" => "(standard)",
"Release check" => "Auf neue Version pr&uuml;fen",
"Check frequency" => "Pr&uuml;fh&auml;ufigkeit",
"Each day" => "t&auml;glich",
"Each week" => "w&ouml;chentlich",
"Each month" => "monatlich",
"Release checks are made when you browse admin main page only" => "Die &Uuml;berpr&uuml;fung wird beim Aufruf der Admin-Hauptseite durchgef&uuml;hrt",
"Force immediate check" => "Jetzt pr&uuml;fen",
"Default timezone" => "Standard Zeitzone",
"Fields display order" => "Darstellungsreihenfolge der Felder",
"When possible, show the real user name instead of login:" => "Zeige vollen Namen statt Benutzerkennen (sofern vorhanden):",
// "Preference syntax" => "Preference syntax",
// "Google Map setup" => "Google Map setup",
// "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :" => "You need to request a Google Maps Key for this web site. You can easily generate a key for your domain at :",
// "Google Map Key" => "Google Map Key",
// "Default x for map center" => "Default x for map center",
// "Default y from map center" => "Default y from map center",
// "Default zoom level" => "Default zoom level",
// "whole earth" => "whole earth",
// "country size" => "country size",
// "city size" => "city size",
// "max zoom" => "max zoom",
// "Default Language" => "Default Language",
// "Multilingual structures" => "Multilingual structures",
// "Show pages in user's preferred language" => "Show pages in user's preferred language",
// "Restrict supported languages" => "Restrict supported languages",
// "Available languages (Ctrl+Click to select multiple languages):" => "Available languages (Ctrl+Click to select multiple languages):",
// "Quantify change size" => "Quantify change size",
// "Intertiki exchange feature" => "Intertiki exchange feature",
// "Import user preferences" => "Import user preferences",
// "Import user groups" => "Import user groups",
// "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)" => "Limit group import (comma-separated list of imported groups, leave empty to avoid limitation)",
// "Intertiki shared cookie for sliding auth under same domain" => "Intertiki shared cookie for sliding auth under same domain",
// "InterTiki Server" => "InterTiki Server",
// "host" => "host",
// "Errors Log file" => "Errors Log file",
// "IP" => "IP",
// "Wysiwyg" => "Wysiwyg",
// "Text Area" => "Text Area",
// "CAS (Central Authentication Service)" => "CAS (Central Authentication Service)",
// "Shibboleth" => "Shibboleth",
// "OpenID and Tiki" => "OpenID and Tiki",
"You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a>" => "Die <a href=\"tiki-admin.php?page=general\">Sendeadresse</a> mu&szlig; gesetzt sein",
" - Php GD library required" => " - Php GD Bibliothek erforderlich",
"Use login as email" => "Login als eMail-Adresse benutzen",
"Validate user email server" => "Mailserver des Benutzers validieren",
"Available languages:" => "Verf&uuml;gbare Sprachen:",
"-1 for never" => "-1 f&uuml;r niemals",
"Re-validate user by email after days" => "Tage bis der Benutzer erneut per eMail validiert wird",
"Re-validate user by email after unsuccessful logins" => "Fehlgeschlagene Anmeldungen, nach denen der Benutzer erneut per eMail validiert wird",
"Generate a password option" => "Option zum automatischen Passwort-Erstellen anzeigen",
"HTTPS login" => "HTTPS-Login",
"Encourage secure (https) login" => "Schlage sicheren Login (https) vor",
"Consider we are in always in HTTPS, but do not check" => "Gehe von HTTPS aus, aber pr&uuml;fe nicht nach",
"Users can choose to stay in SSL mode after an HTTPS login" => "Benutzer darf nach HTTPS Login wahlweise mit SSL fortfahren",
"Users can switch between secured or standard mode at login" => "Benutzer darf zwischen HTTPS und normalem Login w&auml;hlen",
"User's choice" => "Benutzer-Wahl",
"Always" => "Immer",
"Specify the fields that will be asked in admin->groups" => "Definiere die zus&auml;tzlicen Felder in Admin->Gruppen",
"Displays UserTracker information in user information page. Format: trackerId, fieldId1, fieldId2, …" => "Zeige diese UserTracker-Infos auf der Benutzerseite an. Format: trackerId, fieldId1, fieldId2, ...",
"Deactivate login autocomplete (do not remember login and password)" => "Automatisches Vervollst&auml;ndigen beim Login abschalten (Kennung und Passwort nicht merken)",
"On permission denied, display login box for anonymous:" => "Bei Zugriffsfehlermeldung f&uuml;r anonyme Benutzer die Loginbox anzeigen:",
"On permission denied, send to this url:" => "Bei Zugriffsfehlermeldung auf diese Seite springen:",
// "PEAR::Auth" => "PEAR::Auth",
// "LDAP" => "LDAP",
// "LDAP Host" => "LDAP Host",
// "LDAP Port" => "LDAP Port",
// "LDAP Scope" => "LDAP Scope",
// "LDAP Base DN" => "LDAP Base DN",
// "LDAP Member Is DN" => "LDAP Member Is DN",
// "LDAP Version" => "LDAP Version",
// "LDAP Realname Attribute" => "LDAP Realname Attribute",
// "PAM" => "PAM",
// "Version 1.0" => "Version 1.0",
// "Version 2.0" => "Version 2.0",
// "Shibboleth Authentication " => "Shibboleth Authentication ",
"Users Default Preferences" => "Benutzer-Standardeinstellungen",
// "Theme" => "Theme",
"Detect user timezone if browser allows, otherwise site default" => "Versuche Zeitzone zu erkennen, ansonsten Site-Default benutzen",
"My forum topics" => "Meine Foren-Themen",
"My forum replies" => "Meine Foren-Antworten",
// "General Layout" => "General Layout",
// "Use transition style sheet from version" => "Use transition style sheet from version",
// "Never use transition css" => "Never use transition css",
// "Use @version:x.x specified in theme css or none if not specified" => "Use @version:x.x specified in theme css or none if not specified",
// "Use @version:x.x specified in theme css or 1.8 if not specified" => "Use @version:x.x specified in theme css or 1.8 if not specified",
// "Use @version:x.x specified in theme css or 1.9 if not specified" => "Use @version:x.x specified in theme css or 1.9 if not specified",
// "Template Viewing" => "Template Viewing",
// "Required for all the following features" => "Required for all the following features",
// "Custom Site Header" => "Custom Site Header",
// "Site Logo" => "Site Logo",
// "Site logo source (image path)" => "Site logo source (image path)",
// "Site logo background style" => "Site logo background style",
// "Site logo alignment" => "Site logo alignment",
// "on left side" => "on left side",
// "on center" => "on center",
// "on right side" => "on right side",
// "Site Search Bar" => "Site Search Bar",
// "Site Login Bar" => "Site Login Bar",
// "Top Bar" => "Top Bar",
// "Note: This feature also requires PHPLayers to be turned on in " => "Note: This feature also requires PHPLayers to be turned on in ",
// "Menu ID" => "Menu ID",
// "Current Version" => "Current Version",
// "Users can Flip Columns" => "Users can Flip Columns",
// "Site Breadcrumbs" => "Site Breadcrumbs",
// "Prefix breadcrumbs with 'Location : ' " => "Prefix breadcrumbs with 'Location : ' ",
// "Site Report Bar" => "Site Report Bar",
// "Webmaster Report" => "Webmaster Report",
// "Webmaster Email" => "Webmaster Email",
// "Left blank to use the default sender email" => "Left blank to use the default sender email",
// "Custom Site Footer" => "Custom Site Footer",
// "Pagination links" => "Pagination links",
// "Use relative (next / previous) pagination links" => "Use relative (next / previous) pagination links",
// "Max. number of links around the current item:" => "Max. number of links around the current item:",
// "Max. number of links after the first or before the last item:" => "Max. number of links after the first or before the last item:",
// "Display 'First' and 'Last' links" => "Display 'First' and 'Last' links",
// "Display fast move links (by 10 percent of the total number of pages) " => "Display fast move links (by 10 percent of the total number of pages) ",
// "Use Icons" => "Use Icons",
// "Other options" => "Other options",
// "Use context menus for actions (icons) (only in file galleries yet)" => "Use context menus for actions (icons) (only in file galleries yet)",
// "Use context menus for actions (text) (only in file galleries yet)" => "Use context menus for actions (text) (only in file galleries yet)",
// "image/png" => "image/png",
// "image/bmp" => "image/bmp",
// "image/x-icon" => "image/x-icon",
// "Map Zone" => "Map Zone",
// "Insert freetags in keyword list" => "Insert freetags in keyword list",
// "Use the thread title in Forum pages instead" => "Use the thread title in Forum pages instead",
// "Use the image title in Image gallery pages instead" => "Use the image title in Image gallery pages instead",
// "Geourl" => "Geourl",
// "Robots" => "Robots",
// "Right &amp; left boxes" => "Right &amp; left boxes",
// "Administer modules" => "Administer modules",
// "ProgressBarPlay Color" => "ProgressBarPlay Color",
// "ProgressBarLoad Color" => "ProgressBarLoad Color",
// "ProgressBarButton Color" => "ProgressBarButton Color",
// "ProgressBar Color" => "ProgressBar Color",
// "Volume On Color" => "Volume On Color",
// "Volume Off Color" => "Volume Off Color",
// "Volume Button Color" => "Volume Button Color",
// "Button Color" => "Button Color",
// "Button Pressed Color" => "Button Pressed Color",
// "Button Over Color" => "Button Over Color",
// "Button Info Color" => "Button Info Color",
// "Button Info Pressed Color" => "Button Info Pressed Color",
// "Button Info Over Color" => "Button Info Over Color",
// "Button Info Text Color" => "Button Info Text Color",
// "ID3 Tag Color" => "ID3 Tag Color",
// "Play Time Color" => "Play Time Color",
// "Total Time Color" => "Total Time Color",
// "Panel Display Color" => "Panel Display Color",
// "Alert Message Color" => "Alert Message Color",
// "Flash Lenght" => "Flash Lenght",
// "Flash Heigth" => "Flash Heigth",
// "Video Lenght" => "Video Lenght",
// "Video Heigth" => "Video Heigth",
// "Preload Delay" => "Preload Delay",
// "Max Play time" => "Max Play time",
// "URL Append" => "URL Append",
// "Message after limited time" => "Message after limited time",
// "ID of System File Galleries to upload multimedia files" => "ID of System File Galleries to upload multimedia files",
// "Show categories" => "Show categories",
// "Show objects" => "Show objects",
// "Tikiwiki Profiles" => "Tikiwiki Profiles",
// "Configuration" => "Configuration",
// "Profile repositories" => "Profile repositories",
// "Profiles can be installed from multiple repositories. Enter one repository URL per line." => "Profiles can be installed from multiple repositories. Enter one repository URL per line.",
// "Profile repository status" => "Profile repository status",
// "Profile list" => "Profile list",
// "Repository" => "Repository",
// "Profile" => "Profile",
// "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS modules</strong> menu option, or" => "Use this page to configure the RSS feeds generated by Tiki. To syndicate RSS feeds from other sites, use the <strong>Admin</strong> &gt; <strong>RSS modules</strong> menu option, or",
// "Feed for articles" => "Feed for articles",
// "Feature is disabled." => "Feature is disabled.",
// "Enable now" => "Enable now",
// "Maximum number of items to display" => "Maximum number of items to display",
// "Feed for blogs" => "Feed for blogs",
// "Individual blogs" => "Individual blogs",
// "Feed for image galleries" => "Feed for image galleries",
// "Individual image galleries" => "Individual image galleries",
// "Feed for file galleries" => "Feed for file galleries",
// "Individual file galleries" => "Individual file galleries",
// "Feed for wiki" => "Feed for wiki",
// "Individual forums" => "Individual forums",
// "Individual trackers items" => "Individual trackers items",
// "Calendar events" => "Calendar events",
// "Feed for directory" => "Feed for directory",
// "Feed for maps" => "Feed for maps",
// "Map files" => "Map files",
// "Defaults" => "Defaults",
// "Editor" => "Editor",
// "Webmaster" => "Webmaster",
// "Image Path" => "Image Path",
// "Caching time:" => "Caching time:",
// "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public." => "Enabling caching will override existing permissions - all content will be public. Enable this option <strong>only</strong> if your syndicated content should be public.",
// "can be seen on page" => "can be seen on page",
// "in Admin menu" => "in Admin menu",
// "Parse the result (can be slow)" => "Parse the result (can be slow)",
// "Database Search using MySQL 'Full-Text' Feature" => "Database Search using MySQL 'Full-Text' Feature",
// "Activate MySQL Full-Text feature" => "Activate MySQL Full-Text feature",
// "Activate MySQL 'Full-Text' feature" => "Activate MySQL 'Full-Text' feature",
// "Database Independent Full Text Search or Tiki Search" => "Database Independent Full Text Search or Tiki Search",
// "This is activated by default if MySQL 'Full-Text' feature is not activated above" => "This is activated by default if MySQL 'Full-Text' feature is not activated above",
// "Refresh trackers search index now" => "Refresh trackers search index now",
// "Refresh tracker search index now" => "Refresh tracker search index now",
// "Refresh files search index now" => "Refresh files search index now",
// "Search refresh mode" => "Search refresh mode",
// "Text area (that apply throughout many features)" => "Text area (that apply throughout many features)",
// "Show quicktags over textareas (instead on left side)" => "Show quicktags over textareas (instead on left side)",
// "Default number of rows (wiki)" => "Default number of rows (wiki)",
// "Default number of rows (comments)" => "Default number of rows (comments)",
// "Default number of rows (forum)" => "Default number of rows (forum)",
// "Default number of rows (forum replies)" => "Default number of rows (forum replies)",
// "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely" => "WARNING : Old and New trackers cannot coexist. Trackers created with new library will not work with old library and conversely",
// "Change" => "Change",
// "No records" => "No records",
// "Tag name:" => "Tag name:",
// "Default number of comments per page:" => "Default number of comments per page:",
// "List displayed by default" => "List displayed by default",
// "Wiki attachments:" => "Wiki attachments:",
// "Use database to store files:" => "Use database to store files:",
// "Use a directory to store files:" => "Use a directory to store files:",
// "Path:" => "Path:",
// "Manage attachments" => "Manage attachments",
// "Wiki Administration" => "Wiki Administration",
// "Forums are disabled." => "Forums are disabled.",
// "Forum for discussion:" => "Forum for discussion:",
// "No forums" => "No forums",
// "latin" => "latin",
// "Page name display stripper: choose a character that will be used as a delimiter to strip a final part of the page name (only concerns display)" => "Page name display stripper: choose a character that will be used as a delimiter to strip a final part of the page name (only concerns display)",
// "Wiki Page Staging and Approval" => "Wiki Page Staging and Approval",
// "Use wiki page staging and approval:" => "Use wiki page staging and approval:",
// "Unique page name prefix to indicate staging copy:" => "Unique page name prefix to indicate staging copy:",
// "Hide page name prefix:" => "Hide page name prefix:",
// "Category for staging pages:" => "Category for staging pages:",
// "Category for approved pages:" => "Category for approved pages:",
// "Category for pages out of sync:" => "Category for pages out of sync:",
// "Force bounce of editing of approved pages to staging:" => "Force bounce of editing of approved pages to staging:",
// "Categorize approved pages with categories of staging copy on approval:" => "Categorize approved pages with categories of staging copy on approval:",
// "Replace freetags with that of staging pages on approval:" => "Replace freetags with that of staging pages on approval:",
// "Add new freetags of approved copy (into tags field) when editing staging pages:" => "Add new freetags of approved copy (into tags field) when editing staging pages:",
// "Delete staging pages at approval:" => "Delete staging pages at approval:",
// "If not in the group, edit is always redirected to the staging page edit:" => "If not in the group, edit is always redirected to the staging page edit:",
// "Id" => "Id",
// "Name length:" => "Name length:",
// "Comment length:" => "Comment length:",
// "Description length:" => "Description length:",
// "Status" => "Status",
// "Categories path" => "Categories path",
// "Default sort order:" => "Default sort order:",
// "Enable wiki 3D browser:" => "Enable wiki 3D browser:",
// "Load page on navigation:" => "Load page on navigation:",
// "Browser width:" => "Browser width:",
// "Browser height:" => "Browser height:",
// "Navigation depth:" => "Navigation depth:",
// "Node size:" => "Node size:",
// "Text size:" => "Text size:",
// "Spring (connection) size:" => "Spring (connection) size:",
// "Existing page node color:" => "Existing page node color:",
// "Missing page node color:" => "Missing page node color:",
// "Camera distance adjusted relative to nearest node:" => "Camera distance adjusted relative to nearest node:",
// "Camera distance:" => "Camera distance:",
// "Field of view:" => "Field of view:",
// "Feed animation interval (milisecs):" => "Feed animation interval (milisecs):",
// "Friction constant:" => "Friction constant:",
// "Elastic constant:" => "Elastic constant:",
// "Eletrostatic constant:" => "Eletrostatic constant:",
// "Node mass:" => "Node mass:",
// "Node charge:" => "Node charge:",
// "Sandbox:" => "Sandbox:",
// "Anonymous editors must input anti-bot code:" => "Anonymous editors must input anti-bot code:",
// "Last changes:" => "Last changes:",
// "Dump:" => "Dump:",
// "Export:" => "Export:",
// "Rating:" => "Rating:",
// "History:" => "History:",
// "View source:" => "View source:",
// "List pages:" => "List pages:",
// "Backlinks:" => "Backlinks:",
// "Similar:" => "Similar:",
// "Rankings:" => "Rankings:",
// "Undo:" => "Undo:",
// "Save Draft:" => "Save Draft:",
// "MultiPrint:" => "MultiPrint:",
// "Comments:" => "Comments:",
// "Spellchecking:" => "Spellchecking:",
// "Use templates:" => "Use templates:",
// "Warn on edit conflict:" => "Warn on edit conflict:",
// "Edit idle timeout:" => "Edit idle timeout:",
// "Pictures:" => "Pictures:",
// "Show page title:" => "Show page title:",
// "Show page ID:" => "Show page ID:",
// "Cache wiki pages (global):" => "Cache wiki pages (global):",
// "Individual cache:" => "Individual cache:",
// "Footnotes:" => "Footnotes:",
// "Users can lock pages (if perm):" => "Users can lock pages (if perm):",
// "Use WikiWords:" => "Use WikiWords:",
// "Accept dashes and underscores in WikiWords:" => "Accept dashes and underscores in WikiWords:",
// "Link plural WikiWords to their singular forms:" => "Link plural WikiWords to their singular forms:",
// "Use Wiki paragraph formatting:" => "Use Wiki paragraph formatting:",
// "But still create line breaks within paragraphs:" => "But still create line breaks within paragraphs:",
// "Automonospaced text:" => "Automonospaced text:",
// "Tables syntax:" => "Tables syntax:",
// "Uses Slideshow:" => "Uses Slideshow:",
// "Open page as structure:" => "Open page as structure:",
// "Make structure from page:" => "Make structure from page:",
// "Categorize structure pages together:" => "Categorize structure pages together:",
// "Create webhelp from structure:" => "Create webhelp from structure:",
// "Use external link icons:" => "Use external link icons:",
// "User's Page:" => "User's Page:",
// "UserPage prefix:" => "UserPage prefix:",
// "Page creators are admin of their pages:" => "Page creators are admin of their pages:",
// "Import HTML:" => "Import HTML:",
// "Import Page:" => "Import Page:",
// "Protect email against spam:" => "Protect email against spam:",
// "When viewing a page, if it doesn't exist and has one like page, automatic redirection to this like page:" => "When viewing a page, if it doesn't exist and has one like page, automatic redirection to this like page:",
// "Show/hide heading icon displayed before the heading:" => "Show/hide heading icon displayed before the heading:",
// "Force and limit categorization to within subtree of:" => "Force and limit categorization to within subtree of:",
"Print Page:" => "Seite drucken:",
"Allow HTML:" => "HTML erlauben:",
"Show page version:" => "Seitenversion anzeigen:",
// "Page navigation bar position (displayed when page break '...page...' are used):" => "Page navigation bar position (displayed when page break '...page...' are used):",
// "Wiki actions bar position (e.g. Save, Preview, Cancel, ...):" => "Wiki actions bar position (e.g. Save, Preview, Cancel, ...):",
"Regex search and replace:" => "Regex Suchen und Ersetzen:",
// "Edit section:" => "Edit section:",
// "Log bytes changes (+/-) in Action Logs (slows each page modifications)" => "Log bytes changes (+/-) in Action Logs (slows each page modifications)",
// "Maximum number of versions for history:" => "Maximum number of versions for history:",
// "Never delete versions younger than days:" => "Never delete versions younger than days:",
// "IP address displayed in history:" => "IP address displayed in history:",
// "Diff style:" => "Diff style:",
// "History only for data, description, comment change" => "History only for data, description, comment change",
// "Create watch for author on page creation:" => "Create watch for author on page creation:",
// "Enable watch events when I am the editor:" => "Enable watch events when I am the editor:",
"Enable watches on comments:" => "Beobachtungspunkte auf Kommentaren aktivieren:",
"Watch minor:" => "Geringf&uuml;gige &Auml;nderungen beobachten:",
// "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>" => "Wysiwyg means What You See Is What You Get, and is handled in Tikiwiki by <a href=\"http://fckeditor.net\">FCKeditor</a>",
// "Wysiwyg Editor Features" => "Wysiwyg Editor Features",
// "Wysiwyg Editor is optional" => "Wysiwyg Editor is optional",
// "... and is displayed by default" => "... and is displayed by default",
// "Reopen with the same editor" => "Reopen with the same editor",
// "Content is parsed like wiki page" => "Content is parsed like wiki page",
// "Content is partially parsed" => "Content is partially parsed",
// "Toolbar skin" => "Toolbar skin",
// "Toolbar content" => "Toolbar content",
// "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>." => "A new version of Tikiwiki, <b>{\$tiki_release}</b>, is available. You are currently running <b>{\$tiki_version}</b>. Please visit <a href=\"http://tikiwiki.org/Download\">http://tikiwiki.org/Download</a>.",
// "disabled" => "disabled",
// "enabled" => "enabled",
"More Links" => "Weitere Links",
"Security" => "Sicherheit",
// "System" => "System",
// "SysLogs" => "SysLogs",
// "Mods" => "Mods",
// "View tpl" => "View tpl",
// "Admin Groups Template" => "Admin Groups Template",
// "Please select some actions to view." => "Please select some actions to view.",
// "kb" => "kb",
// "Graph Contributions" => "Graph Contributions",
// "Group Bar Plot:" => "Group Bar Plot:",
// "Accumulated Bar Plot:" => "Accumulated Bar Plot:",
// "Background color:" => "Background color:",
// "Legend background color:" => "Legend background color:",
// "Save graphs to image gallery:" => "Save graphs to image gallery:",
// "contributor" => "contributor",
// "Edit Contribution" => "Edit Contribution",
// "Edit Action" => "Edit Action",
// "Save Action" => "Save Action",
// "Volumes are equally distributed on each contributors/author" => "Volumes are equally distributed on each contributors/author",
// "connection time" => "connection time",
// "connection seconds" => "connection seconds",
// "mns" => "mns",
// "Volumn per category" => "Volumn per category",
// "Volumn per category and per user" => "Volumn per category and per user",
// "Number of actions per user" => "Number of actions per user",
// "Total number of users" => "Total number of users",
// "Number of actions per object" => "Number of actions per object",
// "Total number of objects" => "Total number of objects",
// "Number of actions per category" => "Number of actions per category",
// "Number of actions per category and per user" => "Number of actions per category and per user",
// "Volumn per the users'group and per contribution" => "Volumn per the users'group and per contribution",
// "Volumn per group and per contribution" => "Volumn per group and per contribution",
// "Volumn per user and per contribution" => "Volumn per user and per contribution",
// "Volumn per users'contribution and time" => "Volumn per users'contribution and time",
// "Volumn per contribution and time" => "Volumn per contribution and time",
// "Help on Banning System" => "Help on Banning System",
// "Admin banning tpl" => "Admin banning tpl",
// "Configure/Options" => "Configure/Options",
// "Perso" => "Perso",
// "Custom URL" => "Custom URL",
// "Start of day" => "Start of day",
// "h" => "h",
// "End of day" => "End of day",
// "Custom foreground color" => "Custom foreground color",
// "Custom background color" => "Custom background color",
// "Delete events older than:" => "Delete events older than:",
// "Admin Categories tpl" => "Admin Categories tpl",
// "browse the category system" => "browse the category system",
// "Top" => "Top",
// "Current Category ID:" => "Current Category ID:",
// "Perms inherited from closest parent if possible or from global perms" => "Perms inherited from closest parent if possible or from global perms",
// "Remove from this Category" => "Remove from this Category",
// "URL" => "URL",
// "Admin Charts Template" => "Admin Charts Template",
// "Chat Admin tpl" => "Chat Admin tpl",
// "Admin Content Templates Template" => "Admin Content Templates Template",
// "Use in" => "Use in",
// "No features are configured to use templates." => "No features are configured to use templates.",
// "Edit the contribution:" => "Edit the contribution:",
// "Cookie" => "Cookie",
// "Admin FortuneCookie tpl" => "Admin FortuneCookie tpl",
// "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}." => "To use cookie in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{cookie}{/literal}.",
// "Help on Drawings" => "Help on Drawings",
// "Admin Drawings tpl" => "Admin Drawings tpl",
// "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link." => "To create a drawing in a Wiki page, use {literal}{draw name=foo}{/literal}, where foo is the name of the drawing. After saving, click on the drawing link.",
// "Ver" => "Ver",
// "tiki-admin_dsn tpl" => "tiki-admin_dsn tpl",
// "Use Admin DSN to define the database to be used by the SQL plugin." => "Use Admin DSN to define the database to be used by the SQL plugin.",
// "Admin External Wikis" => "Admin External Wikis",
// "tiki admin external wikis template" => "tiki admin external wikis template",
// "ExtWiki" => "ExtWiki",
// "Admin Forums Template" => "Admin Forums Template",
// "Duplicate forum" => "Duplicate forum",
// "View this forum" => "View this forum",
// "Import forums" => "Import forums",
// "Only allow replies to the first message (flat forum)" => "Only allow replies to the first message (flat forum)",
// "Avatar" => "Avatar",
// "Online" => "Online",
// "Max:" => "Max:",
// "Set topics preferences" => "Set topics preferences",
// "Show topics preferences" => "Show topics preferences",
// "hide topics preferences" => "hide topics preferences",
// "Set thread preferences" => "Set thread preferences",
// "show threads preferences" => "show threads preferences",
// "hide threads preferences" => "hide threads preferences",
// "Default style for threads" => "Default style for threads",
// "Duplicate Forum" => "Duplicate Forum",
// "Duplicate" => "Duplicate",
// "List Forums" => "List Forums",
// "..." => "...",
// "Admin Hotwords Template" => "Admin Hotwords Template",
// "Admin HTML Page Dynamic Zones" => "Admin HTML Page Dynamic Zones",
// "Admin Html Pages" => "Admin Html Pages",
// "Admin Html Pages Template" => "Admin Html Pages Template",
// "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones" => "Use {literal}{ed id=name}{/literal} or {literal}{ted id=name}{/literal} to insert dynamic zones",
// "Refresh rate (if dynamic)" => "Refresh rate (if dynamic)",
// "Admin dynamic zones" => "Admin dynamic zones",
// "Tiki integrator" => "Tiki integrator",
// "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature." => "An easier way to integrate content from another site into Tiki is via iframed links using Tiki's <a class=\"rbox-link\" href=\"tiki-admin_links.php\">featured links</a> feature.",
// "Human readable repository name" => "Human readable repository name",
// "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')" => "Path to repository (local filesystem: relative/absolute web root, remote: prefixed with 'http://')",
// "File name of start page" => "File name of start page",
// "CSS file to load when browse this repository" => "CSS file to load when browse this repository",
// "Is repository visible to users" => "Is repository visible to users",
// "Can files from repository be cached" => "Can files from repository be cached",
// "Are files from repository can be cached" => "Are files from repository can be cached",
// "Clear all cached pages of this repository" => "Clear all cached pages of this repository",
// "Seconds count 'till cached page will be expired" => "Seconds count 'till cached page will be expired",
// "Human readable text description of repository" => "Human readable text description of repository",
// "Start" => "Start",
// "view/hide copy rules dialog" => "view/hide copy rules dialog",
// "Source repository" => "Source repository",
// "According this order rules will be applied ('0' or empty = auto)" => "According this order rules will be applied ('0' or empty = auto)",
// "Is this regular expression or simple search/replacer" => "Is this regular expression or simple search/replacer",
// "Regex" => "Regex",
// "Is case sensitive (for simple replacer)" => "Is case sensitive (for simple replacer)",
// "Case sensitive" => "Case sensitive",
// "subset of chars: imsxeADSXUu, which is regex modifiers" => "subset of chars: imsxeADSXUu, which is regex modifiers",
// "Regex modifiers" => "Regex modifiers",
// "Human readable text description of rule" => "Human readable text description of rule",
// "Check to enable this rule" => "Check to enable this rule",
// "Apply all rules or just this to generate preview" => "Apply all rules or just this to generate preview",
// "View source code after rules applied" => "View source code after rules applied",
// "Test file from repository to generate preview for (empty = configured start page)" => "Test file from repository to generate preview for (empty = configured start page)",
// "Case" => "Case",
// "Admin Featured Links Template" => "Admin Featured Links Template",
// "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>." => "To use these links, you must assign the featured_links <a class=\"rbox-link\" href=\"tiki-admin_modules.php\"> module</a>.",
// "Position" => "Position",
// "Admin Mailing Template" => "Admin Mailing Template",
// "Account" => "Account",
// "Port" => "Port",
// "article-put" => "article-put",
// "wiki-get" => "wiki-get",
// "wiki-put" => "wiki-put",
// "wiki-append" => "wiki-append",
// "Discard to the end from" => "Discard to the end from",
// "mn" => "mn",
// "For wiki page, use ((PageName))." => "For wiki page, use ((PageName)).",
// "Separate multiple sections with a comma ( , )." => "Separate multiple sections with a comma ( , ).",
// "Separate multiple permissions with a comma ( , )." => "Separate multiple permissions with a comma ( , ).",
// "Use Ctrl+Click to select multiple groups." => "Use Ctrl+Click to select multiple groups.",
// "Level" => "Level",
// "section level 0" => "section level 0",
// "section level 1" => "section level 1",
// "section level 2" => "section level 2",
// "section level 3" => "section level 3",
// "sorted section level 0" => "sorted section level 0",
// "Number of lines" => "Number of lines",
// "switch with previous option" => "switch with previous option",
// "switch with next option" => "switch with next option",
// "Export CSV data" => "Export CSV data",
// "Import CSV data" => "Import CSV data",
// "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'." => "To add new options to the menu set the optionId field to 0. To remove an option set the remove field to 'y'.",
// "Admin Menu Builder" => "Admin Menu Builder",
// "Admin Menus Template" => "Admin Menus Template",
// "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu." => "To use menus in a <a href=\"tiki-admin_modules.php\">module</a>, <a href=\"tiki-admin.php?page=siteid\">Site identity</a> or a template, use {literal}{menu id=x}{/literal}, where x is the ID of the menu.",
// "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:" => "To use <a target=\"tikihelp\" href=\"http://phplayersmenu.sourceforge.net/\">phplayersmenu</a>, you can use one of the three following syntaxes:",
// "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>" => "This will work well (or not!) depending on your theme. To learn more about <a target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>",
// "To use a menu in a tiki format: " => "To use a menu in a tiki format: ",
// "To use menu in a css/suckerfish format: " => "To use menu in a css/suckerfish format: ",
// "Path to the folder icon for close sections" => "Path to the folder icon for close sections",
// "Example:" => "Example:",
// "Provide also a folder icon for open sections with the same name with the letter 'o' before in the same directory (ex: folder.png and ofolder.png)" => "Provide also a folder icon for open sections with the same name with the letter 'o' before in the same directory (ex: folder.png and ofolder.png)",
// "Default:" => "Default:",
// "Admin Modules Template" => "Admin Modules Template",
// "Left" => "Left",
// "Right" => "Right",
// "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme'). Separator between params:'&'. E.g. maxlen=15&nonums=y." => "Params: specific params to the module and/or general params ('lang', 'flip', 'title', 'decorations', 'section', 'overflow', 'page', 'nobox', 'bgcolor', 'color', 'theme'). Separator between params:'&'. E.g. maxlen=15&nonums=y.",
// "The" => "The",
// "Display Modules to All Groups" => "Display Modules to All Groups",
// "setting will override your selection of specific groups." => "setting will override your selection of specific groups.",
// "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either" => "Because <a class=\"rbox-link\" href=\"tiki-admin.php?page=module\">Users can Configure Modules</a>, select either",
// " or " => " or ",
// "to make sure users will notice any newly assigned modules." => "to make sure users will notice any newly assigned modules.",
// "Move Up" => "Move Up",
// "Move Down" => "Move Down",
// "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site." => "Create your new custom module below. Make sure to preview first and make sure all is OK before <a href=\"#assign\">assigning it</a>. Using html, you will be fine. However, if you improperly use wiki syntax or Smarty code, you could lock yourself out of the site.",
// "Use Wiki Structure" => "Use Wiki Structure",
// "You can add several email addresses by separating them with commas." => "You can add several email addresses by separating them with commas.",
// "Group users" => "Group users",
// "Group subscription also subscribes included groups" => "Group subscription also subscribes included groups",
// "Don't send confirmation mail" => "Don't send confirmation mail",
// "The user email will be refreshed at each newsletter sending" => "The user email will be refreshed at each newsletter sending",
// "Batch e-mail subscribe" => "Batch e-mail subscribe",
// "txt file, one e-mail per line" => "txt file, one e-mail per line",
// "Export Subscriber Emails" => "Export Subscriber Emails",
// "Subscribe group" => "Subscribe group",
// "Included group, group users and emails will be refreshed at each newsletter sending" => "Included group, group users and emails will be refreshed at each newsletter sending",
// "Add subscribers of another newsletter" => "Add subscribers of another newsletter",
// "Admin Newsletters Template" => "Admin Newsletters Template",
// "Allow customized text message to be sent with the html version" => "Allow customized text message to be sent with the html version",
// "Drafts" => "Drafts",
// "Admin Email Notifications" => "Admin Email Notifications",
// "Admin Notifications Template" => "Admin Notifications Template",
// "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications." => "You need to set <a href=\"tiki-admin.php?page=general\">Sender Email</a> before creating email notifications.",
// "Alert" => "Alert",
// "Preload Admin Account" => "Preload Admin Account",
// "Add poll option" => "Add poll option",
// "Edit poll option" => "Edit poll option",
// "Option" => "Option",
// "Admin Polls Template" => "Admin Polls Template",
// "Configure Polls" => "Configure Polls",
// "Create poll" => "Create poll",
// "Edit poll" => "Edit poll",
// "Add poll to pages" => "Add poll to pages",
// "Use Ctrl+Click to select multiple pages." => "Use Ctrl+Click to select multiple pages.",
// "Lock the pages" => "Lock the pages",
// "tiki admin quicktags template" => "tiki admin quicktags template",
// "Quicktags category filter" => "Quicktags category filter",
// "Admin RSS Modules" => "Admin RSS Modules",
// "Admin RSSmodules Template" => "Admin RSSmodules Template",
// "Tips" => "Tips",
// "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed." => "To use RSS feeds in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{rss id=x}{/literal}, where x is the ID of the RSS feed.",
// "RSS channels" => "RSS channels",
// "Show Title?" => "Show Title?",
// "Show Date?" => "Show Date?",
// "View feed" => "View feed",
// "security admin" => "security admin",
// "security admin tpl" => "security admin tpl",
// "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>." => "To <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://security.tikiwiki.org/tiki-contact.php\">report any security issues</a>.",
// "Security checks" => "Security checks",
// "Check file permissions" => "Check file permissions",
// "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments." => "This check tries to find files with problematic file permissions. Some file permissions that are shown here as problematic may be unproblematic or unavoidable in some environments.",
// "See end of table for detailed explanations." => "See end of table for detailed explanations.",
// "owner" => "owner",
// "special" => "special",
// "other" => "other",
// "uid" => "uid",
// "gid" => "gid",
// "suid" => "suid",
// "sgid" => "sgid",
// "sticky" => "sticky",
// "r" => "r",
// "w" => "w",
// "Set User ID (suid) files" => "Set User ID (suid) files",
// "World writable files or directories" => "World writable files or directories",
// "Files or directories the Webserver can write to" => "Files or directories the Webserver can write to",
// "Strange Inodes (not file, not link, not directory)" => "Strange Inodes (not file, not link, not directory)",
// "Executable files" => "Executable files",
// "What to do with these check results?" => "What to do with these check results?",
// "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\"." => "Suid files are not part of tiki and there is no need for suid files in a webspace. Sometimes intruders that gain elevated privileges leave suid files to \"keep the door open\".",
// "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content." => "In some environments where you cannot get root or have no other possibilities, it is unavoidable to let your webserver write to some tiki directories like \"templates_c\" or \"temp\". In any other case this is not needed. A bug in a script or other users could easily put malicious scripts on your webspace or upload illegal content.",
// "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information." => "The risk is almost the same in shared hosting environments without proper privilege separation (suexec wrappers). The webserver has to be able to write to some directories like \"templates_c\" or \"temp\". Review the tiki install guide for further information.",
// "Inodes that are not files or directories are not part of tiki. Review these Inodes!" => "Inodes that are not files or directories are not part of tiki. Review these Inodes!",
// "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod." => "Setting the executable bit can be dangerous if the webserver is configured to execute cgi scripts from that directories. If you use the usual php module (for apache) then php scripts and other files in tiki do not need to have the executable bit. You can safely remove the executable bit with chmod.",
// "Admin Shoutbox Words Template" => "Admin Shoutbox Words Template",
// "Add Banned Word" => "Add Banned Word",
// "Admin structures template" => "Admin structures template",
// "The structure" => "The structure",
// "has just been created." => "has just been created.",
// "You will remove structure" => "You will remove structure",
// "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict:" => "Note that the following pages are also part of another structure. Make sure that access permissions (if any) do not conflict:",
// "The following pages have automatically been categorized with the same categories as the structure:" => "The following pages have automatically been categorized with the same categories as the structure:",
// "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent:" => "The following pages have categories but the structure has none. You may wish to uncategorize them to be consistent:",
// "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent:" => "The following pages are in categories that the structure is not in. You may wish to recategorize them in order to be consistent:",
// "Edit structure" => "Edit structure",
// "PDF" => "PDF",
// "Create WebHelp" => "Create WebHelp",
// "View WebHelp" => "View WebHelp",
// "Alias" => "Alias",
// "Note" => "Note",
// "Wiki textaera" => "Wiki textaera",
// "For a rate, you can give the maximum value." => "For a rate, you can give the maximum value.",
// "administer surveys template" => "administer surveys template",
// "system admin" => "system admin",
// "system admin tpl" => "system admin tpl",
// "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed)." => "If your Tiki is acting weird, first thing to try is to clear your cache below. Also very important is to clear your cache after an upgrade (by FTP/SSH when needed).",
// "Exterminator of cached content" => "Exterminator of cached content",
// "All user prefs sessions" => "All user prefs sessions",
// "Directories to save:" => "Directories to save:",
// "UTF-8 Errors fixed" => "UTF-8 Errors fixed",
// "Admin Topics Template" => "Admin Topics Template",
// "Inactive - Click to Activate" => "Inactive - Click to Activate",
// "Active - Click to Deactivate" => "Active - Click to Deactivate",
// "Active Permissions" => "Active Permissions",
// "admin Tracker fields tpl" => "admin Tracker fields tpl",
// "New tracker field" => "New tracker field",
// "Select list items that will be displayed:" => "Select list items that will be displayed:",
// "Multilingual content" => "Multilingual content",
// "Field is public? (viewed in trackerlist plugin)" => "Field is public? (viewed in trackerlist plugin)",
// "Field is hidden?" => "Field is hidden?",
// "not hidden" => "not hidden",
// "editable by admin only" => "editable by admin only",
// "visible by creator &amp; admin only" => "visible by creator &amp; admin only",
// "The option creator needs a field of type user selector and option 1" => "The option creator needs a field of type user selector and option 1",
// "Visible by:" => "Visible by:",
// "Editable by:" => "Editable by:",
// "Error message:" => "Error message:",
// "Export fieldId also" => "Export fieldId also",
// "Admin Trackers tpl" => "Admin Trackers tpl",
// "Edit This Tracker's Fields" => "Edit This Tracker's Fields",
// "Edit Tracker" => "Edit Tracker",
// "Duplicate Tracker" => "Duplicate Tracker",
// "with" => "with",
// "Description text is tiki-parsed:" => "Description text is tiki-parsed:",
// "Use Ratings:" => "Use Ratings:",
// "Auto create corresponding categories" => "Auto create corresponding categories",
// "Use \"explicit\" names in the mirror table" => "Use \"explicit\" names in the mirror table",
// "tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL" => "tracker name must be unique, field names must be unique \nfor a tracker and they must be valid in SQL",
// "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender" => "The tracker will use the text field named Subject if any as subject and will use the user email or for anonymous the email field if any as sender",
// "Only one item per user or IP" => "Only one item per user or IP",
// "The tracker needs a user or IP field with the option 1" => "The tracker needs a user or IP field with the option 1",
// "Format if not the default short one:" => "Format if not the default short one:",
// "Show creation date when viewing tracker item?" => "Show creation date when viewing tracker item?",
// "Show lastModif date when viewing tracker item?" => "Show lastModif date when viewing tracker item?",
// "LastModif" => "LastModif",
// "ItemId" => "ItemId",
// "Items can be created only during a certain time" => "Items can be created only during a certain time",
// "After:" => "After:",
// "Before:" => "Before:",
// "Do not show empty fields in item view?" => "Do not show empty fields in item view?",
// "Show these fields (ID comma separated) in a popup on item link when listing tracker items?" => "Show these fields (ID comma separated) in a popup on item link when listing tracker items?",
// "Charset encoding" => "Charset encoding",
// "UTF-8" => "UTF-8",
// "ISO-8859-1" => "ISO-8859-1",
// "Separator" => "Separator",
// "Delimitors" => "Delimitors",
// "Carriage Return inside Field Value" => "Carriage Return inside Field Value",
// "Parse" => "Parse",
// "Fields visible in items list" => "Fields visible in items list",
// "Fields searchable or visible in items list" => "Fields searchable or visible in items list",
// "Fields visible in an item view" => "Fields visible in an item view",
// "All fields" => "All fields",
// "or list of fields separated by comma" => "or list of fields separated by comma",
// "Date Format" => "Date Format",
// "timestamp" => "timestamp",
// "Members" => "Members",
// "User Choice" => "User Choice",
// "Only directly included" => "Only directly included",
// "will have all the permissions of the included groups" => "will have all the permissions of the included groups",
// "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>)." => "For other Tiki features, use relative links (such as <em>http:tiki-forums.php</em>).",
// "Enable now." => "Enable now.",
// "Default category assigned to uncategorized objects edited by a user with this default group" => "Default category assigned to uncategorized objects edited by a user with this default group",
// "Group Theme" => "Group Theme",
// "Use site default" => "Use site default",
// "Group Information Tracker" => "Group Information Tracker",
// "choose a group tracker ..." => "choose a group tracker ...",
// "choose a field ..." => "choose a field ...",
// "Users Information Tracker" => "Users Information Tracker",
// "choose a users tracker ..." => "choose a users tracker ...",
// "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)" => "Users Information Tracker Fields Asked at Registration Time<br />(fieldIds separated with :)",
// "User can assign to the group himself" => "User can assign to the group himself",
// "Group tracker item : {\$groupitemid}" => "Group tracker item : {\$groupitemid}",
// "Group tracker item not found" => "Group tracker item not found",
// "Create item" => "Create item",
// "Remove from Group" => "Remove from Group",
// "users in group" => "users in group",
// "Download CSV export" => "Download CSV export",
// "Charset encoding:" => "Charset encoding:",
// "Assign users to group:" => "Assign users to group:",
// "User must already exist." => "User must already exist.",
// "To create users and assign them to groups, got to admin->users" => "To create users and assign them to groups, got to admin->users",
// "Admin Users Template" => "Admin Users Template",
// "Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions" => "Warning: since this tiki site is in slave mode, all user information you enter manually will be automatically overriden by other site's data, including users permissions",
// "Updated users" => "Updated users",
// "Change user preferences" => "Change user preferences",
// "Edit Account Settings" => "Edit Account Settings",
// "Need to validate email" => "Need to validate email",
// "Assign Group" => "Assign Group",
// "Edit Included Group" => "Edit Included Group",
// "Remove Users and their Userpages" => "Remove Users and their Userpages",
// "Tip: Hold down CTRL to select multiple" => "Tip: Hold down CTRL to select multiple",
// "Use the email as username" => "Use the email as username",
// "Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master" => "Warning: changing the username will require the user to change his password and will mess with slave intertiki sites that use this one as master",
// "Warning: changing the username will require the user to change his password" => "Warning: changing the username will require the user to change his password",
// "No password is required" => "No password is required",
// "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth." => "Tikiwiki is configured to delegate the password managment to LDAP through PEAR Auth.",
// "User must change his password at first login" => "User must change his password at first login",
// "Registration" => "Registration",
// "User tracker item : {\$usersitemid}" => "User tracker item : {\$usersitemid}",
// "Loading..." => "Loading...",
// "Approve page changes in staging" => "Approve page changes in staging",
// "Page has been approved" => "Page has been approved",
// "New attachments" => "New attachments",
// "Old attachments" => "Old attachments",
// "Changes from the following versions under staging have been merged into the approved version" => "Changes from the following versions under staging have been merged into the approved version",
// "Article Types tpl" => "Article Types tpl",
// "Show link to source after article body" => "Show link to source after article body",
// "Show Language" => "Show Language",
// "Help for Assigning Permissions" => "Help for Assigning Permissions",
// "Edit Article Tpl" => "Edit Article Tpl",
// "Assign User {\$assign_user} to Groups" => "Assign User {\$assign_user} to Groups",
// "Assign User to Group" => "Assign User to Group",
// "backlinks to" => "backlinks to",
// "No backlinks to this page" => "No backlinks to this page",
// "convert the last sub directory to a sub gallery" => "convert the last sub directory to a sub gallery",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a gallery named \"screenshots\" will be created",
// "Use the last sub directory name as description" => "Use the last sub directory name as description",
// "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created" => "eg. from \"misc/screenshots/digicam0001.jpg\" a description \"screenshots\" will be created",
// "The TikiWiki community" => "The TikiWiki community",
// "TikiWiki CMS/Groupware" => "TikiWiki CMS/Groupware",
// "Admin the Category System" => "Admin the Category System",
// "Trackers Items" => "Trackers Items",
// "Sheets" => "Sheets",
// "Upper level" => "Upper level",
// "Browse related tags" => "Browse related tags",
// "Network of Tags related to" => "Network of Tags related to",
// "With all selected tags" => "With all selected tags",
// "With one selected tag" => "With one selected tag",
// "With last selected tag" => "With last selected tag",
// "More Popular Tags" => "More Popular Tags",
// "Sort:" => "Sort:",
// "Alphabetically" => "Alphabetically",
// "By Size" => "By Size",
// "Cloud" => "Cloud",
// "results found" => "results found",
// "All Images" => "All Images",
// "Monitor this Gallery" => "Monitor this Gallery",
// "Stop Monitoring this Gallery" => "Stop Monitoring this Gallery",
// "Details" => "Details",
// "Cyclic" => "Cyclic",
// "Click to zoom" => "Click to zoom",
// "Add Event" => "Add Event",
// "Click to select visible calendars" => "Click to select visible calendars",
// "Visible Calendars" => "Visible Calendars",
// "+" => "+",
// "Calendar Item" => "Calendar Item",
// "Config Calendars" => "Config Calendars",
// "Edit Calendar" => "Edit Calendar",
// "View event" => "View event",
// "Edit event" => "Edit event",
// "New event" => "New event",
// "Date and time of end" => "Date and time of end",
// "or new" => "or new",
// "chair" => "chair",
// "default role" => "default role",
// "required participant" => "required participant",
// "optional participant" => "optional participant",
// "non participant" => "non participant",
// "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in:" => "Give participant list separated by commas. Roles have to be given in a prefix separated by a column like in:",
// "role:login_or_email,login_or_email" => "role:login_or_email,login_or_email",
// "If no role is provided, default role will be \"Chair participant\"." => "If no role is provided, default role will be \"Chair participant\".",
// "Duplicate to" => "Duplicate to",
// "Categories checking is not done in the database search." => "Categories checking is not done in the database search.",
// "Group View" => "Group View",
// "Publish this contact to groups" => "Publish this contact to groups",
// "Nickname" => "Nickname",
// "You can browse the generated WebHelp here" => "You can browse the generated WebHelp here",
// "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>." => "<a href=\"tiki-directory_admin_categories.php\">Add a category now</a>.",
// "The following site was added, but may require validation by the admin before appearing on the lists." => "The following site was added, but may require validation by the admin before appearing on the lists.",
// "Edit a site" => "Edit a site",
// "Add a site" => "Add a site",
// "URL:" => "URL:",
// "Use Ctrl+Click to select multiple categories." => "Use Ctrl+Click to select multiple categories.",
// "Admin Directory tpl" => "Admin Directory tpl",
// "Edit Tpl" => "Edit Tpl",
// "Admin Directory Categories tpl" => "Admin Directory Categories tpl",
// "cType" => "cType",
// "allow" => "allow",
// "count" => "count",
// "editor" => "editor",
// "relate" => "relate",
// "directory admin related tpl" => "directory admin related tpl",
// "Mutual" => "Mutual",
// "Admin Directory Sites tpl" => "Admin Directory Sites tpl",
// "Perform action with selected:" => "Perform action with selected:",
// "No records." => "No records.",
// "directory validate sites tpl" => "directory validate sites tpl",
// "One of the email addresses you typed is invalid" => "One of the email addresses you typed is invalid",
// "Emails to be notified (separated with commas)" => "Emails to be notified (separated with commas)",
// "-1 for unlimited" => "-1 for unlimited",
// "Or, create a new zone" => "Or, create a new zone",
// "Use Flash" => "Use Flash",
// "Movie URL" => "Movie URL",
// "Movie Size" => "Movie Size",
// "Pixels" => "Pixels",
// "FlashPlugin min version" => "FlashPlugin min version",
// "ex" => "ex",
// "Text" => "Text",
// "Remove Zones (you lose entered info for the banner)" => "Remove Zones (you lose entered info for the banner)",
// "Edit Blog Tpl" => "Edit Blog Tpl",
// "A category is mandatory" => "A category is mandatory",
// "For more information, please see <a href=\"{\$prefs.helpurl}Wiki Page Editor\">Wiki Page Editor</a>" => "For more information, please see <a href=\"{\$prefs.helpurl}Wiki Page Editor\">Wiki Page Editor</a>",
// "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines." => "Because the Wiki paragraph formatting feature is on, all groups of non-blank lines are collected into paragraphs.  Lines can be of any length, and will be wrapped together with the next line.  Paragraphs are separated by blank lines.",
// "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line." => "Because the Wiki paragraph formatting feature is off, each line will be presented as you write it.  This means that if you want paragraphs to be wrapped properly, a paragraph should be all together on one line.",
// "Quicktag" => "Quicktag",
// "Wiki Syntax" => "Wiki Syntax",
// "Format" => "Format",
// "Bold text" => "Bold text",
// "underscores" => "underscores",
// "Italic text" => "Italic text",
// "single quotes" => "single quotes",
// "Centered text" => "Centered text",
// "colons" => "colons",
// "Underlined text" => "Underlined text",
// "equals" => "equals",
// "Text box" => "Text box",
// "One carat" => "One carat",
// "Will display using the indicated HTML color or color name" => "Will display using the indicated HTML color or color name",
// "Indentation" => "Indentation",
// "Creates an indentation for each plus(useful in list to continue at the same level)" => "Creates an indentation for each plus(useful in list to continue at the same level)",
// "make headings" => "make headings",
// "show/hide heading section. + (shown) or - (hidden) by default" => "show/hide heading section. + (shown) or - (hidden) by default",
// "Autonumbered Headings" => "Autonumbered Headings",
// "make autonumbered headings" => "make autonumbered headings",
// "row" => "row",
// "col" => "col",
// "Horizontal rule" => "Horizontal rule",
// "page|#anchor" => "page|#anchor",
// "page|#anchor|desc" => "page|#anchor|desc",
// "for wiki heading/anchor references" => "for wiki heading/anchor references",
// "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox)." => "use square brackets for an external link: [URL], [URL|link_description],[URL|link_description|relation] or [URL|description|relation|nocache] (that last prevents the local Wiki from caching the linked page; relation can be used to insert rel attribute for the link - useful e.g. for shadowbox).",
// "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))" => "For an external Wiki, use ExternalWikiName:PageName or ((External Wiki Name: Page Name))",
// "imalign, height, width, desc, link, rel, title, usemap, class and align are optional" => "imalign, height, width, desc, link, rel, title, usemap, class and align are optional",
// "Line break" => "Line break",
// "(very useful especially in tables)" => "(very useful especially in tables)",
// "to separate pages" => "to separate pages",
// "Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated." => "Creates a link to the named file.  If page is not given, the file must be attached to the current page.  If desc is not given, the file name is used for the link text, unless showdesc is used, which makes the file description be used for the link text.  If image=1 is given, the attachment is treated as an image and is displayed directly on the page; no link is generated.",
// "Inserts an editable variable" => "Inserts an editable variable",
// "Prevents wiki parsing of the enclosed data." => "Prevents wiki parsing of the enclosed data.",
// "\"~pp~ data ~/pp~\" Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  \"~pre~ data ~/pre~\" also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text." => "\"~pp~ data ~/pp~\" Displays preformated text/code; no Wiki processing is done inside these sections (as with np), and the spacing is fixed (no word wrapping is done).  \"~pre~ data ~/pre~\" also displayes preformatted text with fixed spacing, but wiki processing still occurs on the text.",
// "\"~tc~ Tiki Comment ~/tc~\" makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  \"~hc~ HTML Comment ~/hc~\" makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar." => "\"~tc~ Tiki Comment ~/tc~\" makes a Tiki comment.  It will be completely removed from the display, but saved in the file for future reference.  \"~hc~ HTML Comment ~/hc~\" makes an HTML comment.  It will be inserted as a comment in the output HTML; these are not normally displayed in browsers, but can be seen using \"View Source\" or similar.",
// "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that." => "Indent text with any number of spaces to turn it into a monospaced block that still follows other Wiki formatting instructions. It will be indended with the same number of spaces that you used.  Note that this mode does not preserve exact spacing and line breaks; use ~pp~...~/pp~ for that.",
// "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew." => "Insert resp. right-to-left and left-to-right text direction DIV (up to end of text) and markers for langages as arabic or hebrew.",
// "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)" => "\"{literal}{toc}{/literal}\", \"{literal}{maketoc}{/literal}\" prints out a table of contents for the current page based on structures (toc) or ! headings (maketoc)",
// "Plugins" => "Plugins",
// "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt;" => "Note that plugin arguments can be enclosed with double quotes (&quot;); this allows them to contain , or = or &gt;",
// "Plugin" => "Plugin",
// "table new" => "table new",
// "wiki link'" => "wiki link'",
// "hr" => "hr",
// "New wms Metadata" => "New wms Metadata",
// "New Class" => "New Class",
// "New Projection" => "New Projection",
// "New Query" => "New Query",
// "New Scalebar" => "New Scalebar",
// "New Layer" => "New Layer",
// "New Label" => "New Label",
// "New Reference" => "New Reference",
// "New Legend" => "New Legend",
// "New Web" => "New Web",
// "New Outputformat" => "New Outputformat",
// "New Mapfile" => "New Mapfile",
// "Add another image" => "Add another image",
// "Leave Fullscreen Edit" => "Leave Fullscreen Edit",
// "Fullscreen Edit" => "Fullscreen Edit",
// "Upload from disk to change the image:" => "Upload from disk to change the image:",
// "Save and Go Next" => "Save and Go Next",
// "Toggle interactive translation off" => "Toggle interactive translation off",
// "Toggle interactive translation on" => "Toggle interactive translation on",
// "Original" => "Original",
// "Edit question options" => "Edit question options",
// "Admin Quizzes tpl" => "Admin Quizzes tpl",
// "Immediate feedback" => "Immediate feedback",
// "Show correct answers" => "Show correct answers",
// "Shuffle questions" => "Shuffle questions",
// "Shuffle answers" => "Shuffle answers",
// "Passing Percentage" => "Passing Percentage",
// "%" => "%",
// "Edit Quiz Questions" => "Edit Quiz Questions",
// "Edit Quiz Questions Tpl" => "Edit Quiz Questions Tpl",
// "Question Type" => "Question Type",
// "Import questions from text" => "Import questions from text",
// "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character." => "Instructions: Type, or paste, your multiple choice questions below.  One line for the question, then start answer choices on subsequent lines.  Separate additional questions with a blank line.  Indicate correct answers by starting them with a \"*\" (without the quotes) character.",
// "Input" => "Input",
// "You will remove" => "You will remove",
// "and its subpages from the structure, now you have two options:" => "and its subpages from the structure, now you have two options:",
// "and its subpages from the structure" => "and its subpages from the structure",
// "The page already exists. The page that has been added to the structure is the existing one." => "The page already exists. The page that has been added to the structure is the existing one.",
// "The following pages added have automatically been categorized with the same categories as the structure:" => "The following pages added have automatically been categorized with the same categories as the structure:",
// "Monitor the Sub-Structure" => "Monitor the Sub-Structure",
// "Stop Monitoring the Sub-Structure" => "Stop Monitoring the Sub-Structure",
// "Promote" => "Promote",
// "Demote" => "Demote",
// "Move in this structure" => "Move in this structure",
// "Move to another structure" => "Move to another structure",
// "at the beginning" => "at the beginning",
// "at the end" => "at the end",
// "Categorize all pages in structure together" => "Categorize all pages in structure together",
// "Remove existing categories from ALL pages before recategorizing" => "Remove existing categories from ALL pages before recategorizing",
// "Help on Articles" => "Help on Articles",
// "Edit Submissions Tpl" => "Edit Submissions Tpl",
// "<b>*</b>=optional" => "<b>*</b>=optional",
// "<b>Topline</b>=small line above Title" => "<b>Topline</b>=small line above Title",
// "<b>Subtitle</b>=small line below Title" => "<b>Subtitle</b>=small line below Title",
// "<b>Source</b>=URL to article source" => "<b>Source</b>=URL to article source",
// "Submit Article" => "Submit Article",
// "Auto-Approve Article" => "Auto-Approve Article",
// "EditTemplates tpl" => "EditTemplates tpl",
// "Delete the copy in the theme:" => "Delete the copy in the theme:",
// "Add Notification Email" => "Add Notification Email",
// "Admin notifications" => "Admin notifications",
// "Translate:" => "Translate:",
// "Edit Translations" => "Edit Translations",
// "Edit Translations Template" => "Edit Translations Template",
// "You must specify the object language" => "You must specify the object language",
// "The object doesn't exist" => "The object doesn't exist",
// "The object doesn't have a language" => "The object doesn't have a language",
// "The object has already a translation for this language" => "The object has already a translation for this language",
// "Language of newly translated page" => "Language of newly translated page",
// "Name of newly translated page" => "Name of newly translated page",
// "Create translation" => "Create translation",
// "Or" => "Or",
// "Add existing page as a translation of this page" => "Add existing page as a translation of this page",
// "Manage existing translations of this page" => "Manage existing translations of this page",
// "detach" => "detach",
// "Change language for this page" => "Change language for this page",
// "Select from available options..." => "Select from available options...",
// "Change Language" => "Change Language",
// "No language is assigned to this page." => "No language is assigned to this page.",
// "Please select a language before performing translation." => "Please select a language before performing translation.",
// "Set Current Page's Language" => "Set Current Page's Language",
// "Edit Section:" => "Edit Section:",
// "View object" => "View object",
// "Preview your changes." => "Preview your changes.",
// "Save the page." => "Save the page.",
// "Cancel the edit, you will lose your changes." => "Cancel the edit, you will lose your changes.",
// "Your edit session will expire in" => "Your edit session will expire in",
// "Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits." => "Your edit session will expire in 1 minute. You must PREVIEW or SAVE your work now, to avoid losing your edits.",
// "Update '{\$page}' based on '{\$source_page}'" => "Update '{\$page}' based on '{\$source_page}'",
// "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval." => "You are editing the staging copy of the approved version of this page. Changes will be merged in after approval.",
// "This is a new staging page that has not been approved before." => "This is a new staging page that has not been approved before.",
// "The current staging copy may contain changes that have yet to be approved." => "The current staging copy may contain changes that have yet to be approved.",
// "View changes since last approval." => "View changes since last approval.",
// "You are editing the approved copy of this page." => "You are editing the approved copy of this page.",
// "There are currently changes in the staging copy that have yet to be approved." => "There are currently changes in the staging copy that have yet to be approved.",
// "Are you sure you do not want to edit" => "Are you sure you do not want to edit",
// "the staging copy" => "the staging copy",
// "instead?" => "instead?",
// "Draft written on" => "Draft written on",
// "Warning: new versions of this page have been made after this draft" => "Warning: new versions of this page have been made after this draft",
// "Perhaps you are looking for:" => "Perhaps you are looking for:",
// "This edit session will expire in {\$edittimeout} minutes" => "This edit session will expire in {\$edittimeout} minutes",
// "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer." => "<strong>Preview</strong> or <strong>Save</strong> your work to restart the edit session timer.",
// "Categories will be inherited from the structure top page" => "Categories will be inherited from the structure top page",
// "disable" => "disable",
// "or use" => "or use",
// "an existing poll" => "an existing poll",
// "Regex search " => "Regex search ",
// "Translation request" => "Translation request",
// "Send urgent translation request." => "Send urgent translation request.",
// "List Sheets" => "List Sheets",
// "Graph" => "Graph",
// "Export to file" => "Export to file",
// "Autodetect" => "Autodetect",
// "Edit FAQ question" => "Edit FAQ question",
// "Add FAQ question" => "Add FAQ question",
// "File Archive" => "File Archive",
// "File Galleries tpl" => "File Galleries tpl",
// "Be carefull to set the right permissions on the files you link to" => "Be carefull to set the right permissions on the files you link to",
// "Size (width x height)" => "Size (width x height)",
// "Forum Importer" => "Forum Importer",
// "Import from a Local SQL File" => "Import from a Local SQL File",
// "Forum Type" => "Forum Type",
// "DB Prefix" => "DB Prefix",
// "Local SQL Filename on Server (path will be stripped)" => "Local SQL Filename on Server (path will be stripped)",
// "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up" => "Must be in tikiroot/{\$tmpdir} or tikiroot/img/wiki_up",
// "Verification" => "Verification",
// "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>." => "File must be an SQL file and exist in either <i>\$tikiroot/temp</i> or <i>\$tikiroot/img/wiki_up</i>.",
// "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred." => "File was not specified, or could not be found in either location.  Please put the file in either directory and Go Back.  If the file exists in both locations, the \$tikiroot/{\$filecheck} location will be preferred.",
// "Select a Forum You Wish to Move (ONE at a time!)" => "Select a Forum You Wish to Move (ONE at a time!)",
// "Which Forum Do You Wish to Import this Into?" => "Which Forum Do You Wish to Import this Into?",
// "normal" => "normal",
// "hot" => "hot",
// "neutral" => "neutral",
// "Reject" => "Reject",
// "Search by name" => "Search by name",
// "Search in content" => "Search in content",
// "Configure Forum" => "Configure Forum",
// "No records to display" => "No records to display",
// "Perfom action with checked:" => "Perfom action with checked:",
// "Un-report" => "Un-report",
// "Tag translation" => "Tag translation",
// "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag." => "Note that tags that were created on pages with no language set will remain\n\tuniversal (i.e. is the same tag in all languages) until a language has been set for the tag.",
// "Until then, they cannot be translated." => "Until then, they cannot be translated.",
// "Show checkboxes to clear language information on tags" => "Show checkboxes to clear language information on tags",
// "There are no tags on this page in your preferred languages" => "There are no tags on this page in your preferred languages",
// "Set language" => "Set language",
// "Universal" => "Universal",
// "Show the following languages" => "Show the following languages",
// "friends tpl" => "friends tpl",
// "Pending requests" => "Pending requests",
// "Cancel friendship request" => "Cancel friendship request",
// "break friendship" => "break friendship",
// "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>" => "To learn more about the <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://workflow.tikiwiki.org\">Galaxia workflow engine</a>",
// "split" => "split",
// "join" => "join",
// "standalone" => "standalone",
// "auto routed" => "auto routed",
// "Expiration Time" => "Expiration Time",
// "Int" => "Int",
// "Routing" => "Routing",
// "Auto routed" => "Auto routed",
// "#" => "#",
// "route" => "route",
// "Origin" => "Origin",
// "Process Graph" => "Process Graph",
// "Galaxia Admin Graph" => "Galaxia Admin Graph",
// "Galaxia Admin Graph tpl" => "Galaxia Admin Graph tpl",
// "Process Graph for" => "Process Graph for",
// "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed." => "No process graph is available. Either the process still contains errors, the graph is not generated yet, or <a href=\"http://www.research.att.com/sw/tools/graphviz/\">GraphViz</a> is not properly installed.",
// "New Minor" => "New Minor",
// "New Major" => "New Major",
// "Workitems" => "Workitems",
// "Send all to" => "Send all to",
// "Not Defined" => "Not Defined",
// "Not Interactive" => "Not Interactive",
// "Not Ended" => "Not Ended",
// "Property" => "Property",
// "Add property" => "Add property",
// "Executed" => "Executed",
// "Pop-up" => "Pop-up",
// "erase" => "erase",
// "Galaxia Admin Processes" => "Galaxia Admin Processes",
// "Galaxia Admin Processes tpl" => "Galaxia Admin Processes tpl",
// "Operation" => "Operation",
// "Shared code" => "Shared code",
// "Get property" => "Get property",
// "Set property" => "Set property",
// "Complete" => "Complete",
// "Process form" => "Process form",
// "Set Next act" => "Set Next act",
// "If:SetNextact" => "If:SetNextact",
// "Switch construct" => "Switch construct",
// "Galaxia Monitor Activities" => "Galaxia Monitor Activities",
// "Galaxia Monitor Activities tpl" => "Galaxia Monitor Activities tpl",
// "Enter the name of this instance" => "Enter the name of this instance",
// "The name is not valid. Please, enter the name again" => "The name is not valid. Please, enter the name again",
// "Galaxia Monitor Instances" => "Galaxia Monitor Instances",
// "Galaxia Monitor Instances tpl" => "Galaxia Monitor Instances tpl",
// "Not ended" => "Not ended",
// "Galaxia Monitor Processes" => "Galaxia Monitor Processes",
// "Galaxia Monitor Processes tpl" => "Galaxia Monitor Processes tpl",
// "Monitor workitems" => "Monitor workitems",
// "List of workitems" => "List of workitems",
// "Instance Id" => "Instance Id",
// "Instance Name" => "Instance Name",
// "Instance Status" => "Instance Status",
// "Elapsed time" => "Elapsed time",
// "exception instance" => "exception instance",
// "exceptions instance" => "exceptions instance",
// "Send Instance" => "Send Instance",
// "grab instance" => "grab instance",
// "Galaxia User Activities" => "Galaxia User Activities",
// "Galaxia User Activities tpl" => "Galaxia User Activities tpl",
// "No processes defined or activated yet" => "No processes defined or activated yet",
// "Galaxia User Instances" => "Galaxia User Instances",
// "Galaxia User Instances tpl" => "Galaxia User Instances tpl",
// "Inst Status" => "Inst Status",
// "Not defined" => "Not defined",
// "Galaxia User Processes" => "Galaxia User Processes",
// "Galaxia User Processes tpl" => "Galaxia User Processes tpl",
// "Browsing Workitem" => "Browsing Workitem",
// "Workitem information" => "Workitem information",
// "galleries tpl" => "galleries tpl",
// "XY-Size" => "XY-Size",
// "Global default" => "Global default",
// "Bounding box" => "Bounding box",
// "default scale" => "default scale",
// "Make Map" => "Make Map",
// "Save clicked point" => "Save clicked point",
// "Save current view as default" => "Save current view as default",
// "Reset view to site-wide default" => "Reset view to site-wide default",
// "Users Map" => "Users Map",
// "Select Graphic Type" => "Select Graphic Type",
// "Pie Chart" => "Pie Chart",
// "Multiline" => "Multiline",
// "Multibar" => "Multibar",
// "Bar Stack" => "Bar Stack",
// "Portrait" => "Portrait",
// "Independant Scale" => "Independant Scale",
// "Horizontal" => "Horizontal",
// "Vertical" => "Vertical",
// "Horizontal Scale" => "Horizontal Scale",
// "Bottom" => "Bottom",
// "Vertical Scale" => "Vertical Scale",
// "Series" => "Series",
// "Wiki plug-in" => "Wiki plug-in",
// "Ical import / Export" => "Ical import / Export",
// "Select The calendar to export" => "Select The calendar to export",
// " To " => " To ",
// "Calendar Import" => "Calendar Import",
// "ICal File" => "ICal File",
// "Modify String in Source Language" => "Modify String in Source Language",
// "Original String" => "Original String",
// "New String" => "New String",
// "Import From File" => "Import From File",
// "Grab Wiki Tables" => "Grab Wiki Tables",
// "Import pages from a Structured Text Dump" => "Import pages from a Structured Text Dump",
// "ImportingPagesPhpWikiPageAdmin" => "ImportingPagesPhpWikiPageAdmin",
// "tiki-import_phpwiki tpl" => "tiki-import_phpwiki tpl",
// "Name of the dump file (it has to be in dump/)" => "Name of the dump file (it has to be in dump/)",
// "body" => "body",
// "Tiki installer" => "Tiki installer",
// "Success" => "Success",
// "MultiTiki setup" => "MultiTiki setup",
// "To add a new virtual host" => "To add a new virtual host",
// "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter" => "To add a new virtual host run the setup.sh with the domain name of the new host as a last parameter",
// "MultiTiki" => "MultiTiki",
// "Tiki cannot find a database connection" => "Tiki cannot find a database connection",
// "Please enter your database connection information" => "Please enter your database connection information",
// "Database type" => "Database type",
// "Select the type of database to use with Tiki." => "Select the type of database to use with Tiki.",
// "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension." => "Only databases supported by your PHP installation are listed here. If your database is not in the list, try to install the appropriate PHP extension.",
// "Host:" => "Host:",
// "Enter the hostname or IP for your database. Use <strong>localhost</strong> if the database is running on the same machine as Tiki" => "Enter the hostname or IP for your database. Use <strong>localhost</strong> if the database is running on the same machine as Tiki",
// "For SQLite, enter the path and filename to your database file" => "For SQLite, enter the path and filename to your database file",
// "Database name" => "Database name",
// "Enter the name of the database that Tiki will use." => "Enter the name of the database that Tiki will use.",
// "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your\nhosting provider.  Normally Tiki tables won't conflict with other product names" => "The database must already exist. You can create the database using mysqladmin, PHPMyAdmin, cPanel, or ask your\nhosting provider.  Normally Tiki tables won't conflict with other product names",
// "For Oracle" => "For Oracle",
// "Enter your TNS Name here and leave Host empty" => "Enter your TNS Name here and leave Host empty",
// "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field" => "Override tnsnames.ora and put your SID here and enter your hostname:port in the Host field",
// "Database User" => "Database User",
// "Enter the database user with administrator permission for the Database" => "Enter the database user with administrator permission for the Database",
// "Enter the password for the database user" => "Enter the password for the database user",
// "Connect" => "Connect",
// "Welcome to the installation{if \$tikidb_created} &amp; upgrade{/if} script!" => "Welcome to the installation{if \$tikidb_created} &amp; upgrade{/if} script!",
// "Reinstall database." => "Reinstall database.",
// "This will destroy your current database" => "This will destroy your current database",
// "Create a new database (clean install) with profile" => "Create a new database (clean install) with profile",
// "No profiles available." => "No profiles available.",
// "See the documentation for <a target=\"_blank\" href=\"http://doc.tikiwiki.org/Profiles\" class=\"link\" title=\"{tr}Description of available profiles." => "See the documentation for <a target=\"_blank\" href=\"http://doc.tikiwiki.org/Profiles\" class=\"link\" title=\"{tr}Description of available profiles.",
// "Upgrade" => "Upgrade",
// "Backup your database with mysqldump, phpmyadmin, or other before upgrading." => "Backup your database with mysqldump, phpmyadmin, or other before upgrading.",
// "Update database using script" => "Update database using script",
// "No scripts available." => "No scripts available.",
// "To upgrade from" => "To upgrade from",
// "Use this script" => "Use this script",
// "Then rerun the installer using tiki_1.9to2.0." => "Then rerun the installer using tiki_1.9to2.0.",
// "See <a target=\"help\" class=\"link\" href=\"http://doc.tikiwiki.org/Upgrade+1.7+to+1.8\">Tiki database 1.7.x to 1.8x instructions" => "See <a target=\"help\" class=\"link\" href=\"http://doc.tikiwiki.org/Upgrade+1.7+to+1.8\">Tiki database 1.7.x to 1.8x instructions",
// "For information about <strong>tiki-secdb_*.sql</strong> files, please see <a target=\"help\" class=\"link\" href=\"http://doc.tikiwiki.org/Security+Admin\">http://doc.tikiwiki.org/Security+Admin" => "For information about <strong>tiki-secdb_*.sql</strong> files, please see <a target=\"help\" class=\"link\" href=\"http://doc.tikiwiki.org/Security+Admin\">http://doc.tikiwiki.org/Security+Admin",
// "Other Options" => "Other Options",
// "Do nothing and enter Tiki" => "Do nothing and enter Tiki",
// "Reset database connection settings" => "Reset database connection settings",
// "This site has an admin account configured" => "This site has an admin account configured",
// "Please login with your admin password to continue" => "Please login with your admin password to continue",
// "Installation" => "Installation",
// "Your database has been configured and Tikiwiki is ready to run!" => "Your database has been configured and Tikiwiki is ready to run!",
// "If this is your first install, your admin password is <strong>admin</strong>." => "If this is your first install, your admin password is <strong>admin</strong>.",
// "You can now log in into Tikiwiki as user <strong>admin</strong> and start configuring the application." => "You can now log in into Tikiwiki as user <strong>admin</strong> and start configuring the application.",
// "operations executed successfully" => "operations executed successfully",
// "SQL queries" => "SQL queries",
// "Failed" => "Failed",
// "Operations failed" => "Operations failed",
// "Display details" => "Display details",
// "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages." => "During an upgrade, it is normal to have SQL failures resulting with <strong>Table already exists</strong> messages.",
// "Important Information" => "Important Information",
// "Please read the following notes before entering Tikiwiki." => "Please read the following notes before entering Tikiwiki.",
// "Memory" => "Memory",
// "TikiWiki requires <strong>at least</strong> 16MB of PHP memory for script execution. Use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 16M) and restart your webserver" => "TikiWiki requires <strong>at least</strong> 16MB of PHP memory for script execution. Use the <strong>memory_limit</strong> key in your <strong>php.ini </strong> file (for example: memory_limit = 16M) and restart your webserver",
// "Allocating too little memory will cause TikiWiki to display blank pages" => "Allocating too little memory will cause TikiWiki to display blank pages",
// "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)" => "Tiki has not detected your PHP memory_limit. This probably means you have no set limit (all is well)",
// "Tiki has detected your PHP memory limit at" => "Tiki has detected your PHP memory limit at",
// "Tiki has detected your PHP memory_limit at" => "Tiki has detected your PHP memory_limit at",
// "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation" => "If this is a first time installation, go to <strong>tiki-admin.php</strong> after login to start configuring your new Tiki installation",
// "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu." => "If this is an upgrade, clean the Tiki caches manually (the <strong>templates_c</strong> directory) or by using the <strong>Admin &gt; System</strong> option from the Admin menu.",
// "Entering TikiWiki" => "Entering TikiWiki",
// "Change the administrator password" => "Change the administrator password",
// "Continue in installer" => "Continue in installer",
// "Go back and run another install/upgrade script" => "Go back and run another install/upgrade script",
// "Do not use your browser's Back button." => "Do not use your browser's Back button.",
// "Interactive translator" => "Interactive translator",
// "has been updated" => "has been updated",
// "Close this window" => "Close this window",
// "Go Back" => "Go Back",
// "Clicking 'Close this window' will reload the main window from where it was opened" => "Clicking 'Close this window' will reload the main window from where it was opened",
// "weeks" => "weeks",
// "hist" => "hist",
// "v" => "v",
// "List Articles Tpl" => "List Articles Tpl",
// "Admin Banners" => "Admin Banners",
// "Admin Banners tpl" => "Admin Banners tpl",
// "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone." => "To use a banner in a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{banner zone=ABC}{/literal}, where ABC is the name of the zone.",
// "Admin Cache tpl" => "Admin Cache tpl",
// "The cache is used by:" => "The cache is used by:",
// "Orphan" => "Orphan",
// "Help on Dynamic Content" => "Help on Dynamic Content",
// "Admin DynamicContent tpl" => "Admin DynamicContent tpl",
// "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block." => "To use content blocks in a text area (Wiki page, etc), a <a class=\"rbox-link\" href=\"tiki-admin_modules.php\">module</a> or a template, use {literal}{content id=x}{/literal}, where x is the ID of the content block.",
// "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block." => "You can also use {literal}{content label=x}{/literal}, where x is the label of the content block.",
// "Edit content block" => "Edit content block",
// "Create content block" => "Create content block",
// "Current Value" => "Current Value",
// "Future vers" => "Future vers",
// "List FAQs Tpl" => "List FAQs Tpl",
// "SlideShow" => "SlideShow",
// "Your comment" => "Your comment",
// "optional" => "optional",
// "Modifications" => "Modifications",
// "Property <b>{\$fgp_name}</b> Changed" => "Property <b>{\$fgp_name}</b> Changed",
// "games tpl" => "games tpl",
// "/" => "/",
// "Flash binary (.swf or .dcr)" => "Flash binary (.swf or .dcr)",
// "List Posts Tpl" => "List Posts Tpl",
// "List Quizzes Tpl" => "List Quizzes Tpl",
// "Edit Quiz Stats Tpl" => "Edit Quiz Stats Tpl",
// "Take Survey" => "Take Survey",
// "List Trackers Tpl" => "List Trackers Tpl",
// "Last modification" => "Last modification",
// "Page creator" => "Page creator",
// "Last ver." => "Last ver.",
// "Status of the page" => "Status of the page",
// "Vers." => "Vers.",
// "Links to other items in page" => "Links to other items in page",
// "Links to this page in other pages" => "Links to this page in other pages",
// "Backl." => "Backl.",
// "Page size" => "Page size",
// "Lang." => "Lang.",
// "Perform action with checked" => "Perform action with checked",
// "Admin Live Support tpl" => "Admin Live Support tpl",
// "Operator" => "Operator",
// "offline" => "offline",
// "Operator:" => "Operator:",
// "Requested" => "Requested",
// "operator" => "operator",
// "msgs" => "msgs",
// "For security purposes we must periodically validate your email address to allow continued access to this site." => "For security purposes we must periodically validate your email address to allow continued access to this site.",
// "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site." => "A validation email has been sent to you. Please open that email and follow the instructions to once again gain access to the site.",
// "Thank you" => "Thank you",
// "Mail-in feature" => "Mail-in feature",
// "User Calendar" => "User Calendar",
// "User Calendar Doc tpl" => "User Calendar Doc tpl",
// "Add event" => "Add event",
// "User Calendar Doc" => "User Calendar Doc",
// "User Calendar Preferences Doc tpl" => "User Calendar Preferences Doc tpl",
// "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>." => "Tiki \"mods\" are additional features not included in the public release. Learn more at <a target=\"tikihelp\" href=\"http://mods.tikiwiki.org\">mods.tikiwiki.org</a>.",
// "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"./fixperms fix\" for example)." => "Apache has the right to write in your file tree, which enables the installation, removal or upgrade of packages. When you are done with those operations, think to fix those permissions back to a safe state (by using \"./fixperms fix\" for example).",
// "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that permission (using \"./fixperms fix\")." => "To install, remove or upgrade packages you need to give the apache user the right to write files in your web tree (you can use \"./fixperms.sh open\" to set it up). After installation you need to remove that permission (using \"./fixperms fix\").",
// "Display only this type" => "Display only this type",
// "Unpublish" => "Unpublish",
// "Republish" => "Republish",
// "licence" => "licence",
// "Mods Install/uninstall" => "Mods Install/uninstall",
// "Package Config" => "Package Config",
// "my tiki tpl" => "my tiki tpl",
// "User forum topics" => "User forum topics",
// "Forum topics" => "Forum topics",
// "Date of post" => "Date of post",
// "User forum replies" => "User forum replies",
// "Forum replies" => "Forum replies",
// "To display the objects you participate:" => "To display the objects you participate:",
// "Contacts Preferences" => "Contacts Preferences",
// "My Infos" => "My Infos",
// "My Contacts" => "My Contacts",
// "My Wiki Pages" => "My Wiki Pages",
// "My Galleries" => "My Galleries",
// "My Tracker Items" => "My Tracker Items",
// "My Messages" => "My Messages",
// "My Tasks" => "My Tasks",
// "Sent Edition" => "Sent Edition",
// "HTML version" => "HTML version",
// "Text version" => "Text version",
// "Errors:" => "Errors:",
// "Delete errors" => "Delete errors",
// "Not sent" => "Not sent",
// "News from" => "News from",
// "Newsgroup" => "Newsgroup",
// "configure newsreader server tpl" => "configure newsreader server tpl",
// "Read the news" => "Read the news",
// "Add a news server" => "Add a news server",
// "Edit news server" => "Edit news server",
// "Wiki Create" => "Wiki Create",
// "Wiki Overwrite" => "Wiki Overwrite",
// "View Permissions" => "View Permissions",
// "Edit Permissions" => "Edit Permissions",
// "These permissions override any global permissions or category permissions affecting this object." => "These permissions override any global permissions or category permissions affecting this object.",
// "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>." => "To edit global permissions <a class=\"rbox-link\" href=\"tiki-admingroups.php\">click here</a>.",
// "No individual permissions, category permissions apply" => "No individual permissions, category permissions apply",
// "Current permissions for categories that this object belongs to" => "Current permissions for categories that this object belongs to",
// "These permissions do not apply. Special permissions apply." => "These permissions do not apply. Special permissions apply.",
// "No category permissions; special permissions apply" => "No category permissions; special permissions apply",
// "and also to all pages of the sub-structure:" => "and also to all pages of the sub-structure:",
// "Perms Help" => "Perms Help",
// "Your OpenID identity is valid" => "Your OpenID identity is valid",
// "However, no account is associated to the OpenID identifier." => "However, no account is associated to the OpenID identifier.",
// "Create a new Tikiwiki account from OpenID" => "Create a new Tikiwiki account from OpenID",
// "Associate OpenID with an existing Tikiwiki account" => "Associate OpenID with an existing Tikiwiki account",
// "Your identity gives you access to multiple user accounts." => "Your identity gives you access to multiple user accounts.",
// "Select account" => "Select account",
// "Make Structure" => "Make Structure",
// "{\$atts|@count} files attached" => "{\$atts|@count} files attached",
// "Preview of version" => "Preview of version",
// "(current)" => "(current)",
// "Rollback to this version" => "Rollback to this version",
// "Source of version" => "Source of version",
// "HTML diff" => "HTML diff",
// "Updated from" => "Updated from",
// "Used to update" => "Used to update",
// "Update Translation" => "Update Translation",
// "Hide translation history" => "Hide translation history",
// "Show translation history" => "Show translation history",
// "Avatar:" => "Avatar:",
// "(Only .gif images, and aproximately 45px x 45px)" => "(Only .gif images, and aproximately 45px x 45px)",
// "Any" => "Any",
// "Items found:" => "Items found:",
// "Vote poll" => "Vote poll",
// "Poll Results" => "Poll Results",
// "Top Voted Polls" => "Top Voted Polls",
// "Number of top voted polls to show" => "Number of top voted polls to show",
// "Average:" => "Average:",
// "List Votes" => "List Votes",
// "Permission denied. You do not have permission to read complete articles." => "Permission denied. You do not have permission to read complete articles.",
// "Selected Structures" => "Selected Structures",
// "Add Structure" => "Add Structure",
// "No structures" => "No structures",
// "Add Pages" => "Add Pages",
// "No pages" => "No pages",
// "Use Ctrl+Click to select multiple pages" => "Use Ctrl+Click to select multiple pages",
// "Add Pages from Structures" => "Add Pages from Structures",
// "Add Structure Pages" => "Add Structure Pages",
// "Selected Pages" => "Selected Pages",
// "No pages selected." => "No pages selected.",
// "Edit quiz" => "Edit quiz",
// "General Options" => "General Options",
// "Name:" => "Name:",
// "Publication Date" => "Publication Date",
// "at " => "at ",
// "Use " => "Use ",
// "randomly selected questions." => "randomly selected questions.",
// "Test-time Options" => "Test-time Options",
// "Limit questions displayed per page to " => "Limit questions displayed per page to ",
// "&nbsp question(s)." => "&nbsp question(s).",
// "Impose a time limit of " => "Impose a time limit of ",
// "Allow students to store partial results and return to quiz." => "Allow students to store partial results and return to quiz.",
// "Allow students to retake this quiz " => "Allow students to retake this quiz ",
// "Grading and Feedback" => "Grading and Feedback",
// "Grading method " => "Grading method ",
// "Show students their score " => "Show students their score ",
// "Show students the correct answers " => "Show students the correct answers ",
// "Publish statistics " => "Publish statistics ",
// "Extra Options" => "Extra Options",
// "Solicit additional questions from students" => "Solicit additional questions from students",
// "Link quiz to forum named: " => "Link quiz to forum named: ",
// "Prologue:" => "Prologue:",
// "Epilogue:" => "Epilogue:",
// "Quiz" => "Quiz",
// "time taken" => "time taken",
// "P/F" => "P/F",
// "Passed" => "Passed",
// "Question:" => "Question:",
// "Top 10" => "Top 10",
// "Top 20" => "Top 20",
// "Top 50" => "Top 50",
// "Top 100" => "Top 100",
// "received articles tpl" => "received articles tpl",
// "Received Pages" => "Received Pages",
// "Help on Communication Center" => "Help on Communication Center",
// "received pages tpl" => "received pages tpl",
// "Edit Received Page" => "Edit Received Page",
// "The highlight pages already exist." => "The highlight pages already exist.",
// "Please, change the name if you want the page to be uploaded." => "Please, change the name if you want the page to be uploaded.",
// "Received Structures" => "Received Structures",
// "Prefix the checked:" => "Prefix the checked:",
// "Postfix the checked:" => "Postfix the checked:",
// "Admin Referer Stats" => "Admin Referer Stats",
// "Admin Referer Stats tpl" => "Admin Referer Stats tpl",
// "Use your email as login" => "Use your email as login",
// "Lowercase only" => "Lowercase only",
// "Minimum {\$prefs.min_pass_length} characters long" => "Minimum {\$prefs.min_pass_length} characters long",
// "Select your group" => "Select your group",
// "NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter!" => "NOTE: Make sure to whitelist this domain to prevent registration emails being canned by your spam filter!",
// "Please register." => "Please register.",
// "tikiwiki.org" => "tikiwiki.org",
// "Enter your username or email." => "Enter your username or email.",
// "Request Password Reset" => "Request Password Reset",
// "return to wikipage" => "return to wikipage",
// "Replicate" => "Replicate",
// "Slave" => "Slave",
// "Master" => "Master",
// "Operations" => "Operations",
// "Operations Log" => "Operations Log",
// "search stats tpl" => "search stats tpl",
// "Faqs" => "Faqs",
// "Please Confirm" => "Please Confirm",
// "Apply content template" => "Apply content template",
// "Data HTML" => "Data HTML",
// "Data Txt" => "Data Txt",
// "Save as Draft" => "Save as Draft",
// "Admin Send Objects tpl" => "Admin Send Objects tpl",
// "Send a structure" => "Send a structure",
// "Ex: http://tikiwiki.org or localhost" => "Ex: http://tikiwiki.org or localhost",
// "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need" => "Use /commxmlrpc.php if your tikiwiki site is installed at the root, otherwise adapt /tiki to your need",
// "Debug" => "Debug",
// "sheets tpl" => "sheets tpl",
// "Create a sheet" => "Create a sheet",
// "Edit this sheet:" => "Edit this sheet:",
// "Create New Sheet" => "Create New Sheet",
// "There are individual permissions set for this sheet" => "There are individual permissions set for this sheet",
// "Class Name" => "Class Name",
// "Header Rows" => "Header Rows",
// "Footer Rows" => "Footer Rows",
// "Create new Sheet" => "Create new Sheet",
// "You can access the sheet using the following URL" => "You can access the sheet using the following URL",
// "Available Sheets" => "Available Sheets",
// "Admin Tiki Shoutbox" => "Admin Tiki Shoutbox",
// "Admin Tiki Shoutbox tpl" => "Admin Tiki Shoutbox tpl",
// "This is the staging copy of" => "This is the staging copy of",
// "the approved version of this page." => "the approved version of this page.",
// "Viewing of changes since last approval is possible only after first approval." => "Viewing of changes since last approval is possible only after first approval.",
// "Approve changes." => "Approve changes.",
// "Latest changes will be synchronized after approval." => "Latest changes will be synchronized after approval.",
// "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time." => "This is a new staging page that has not been approved before. Edit and manually move it to the category for approved pages to approve it for the first time.",
// "{icon _id=information.png style=\"vertical-align:middle\"} Content may be out of date" => "{icon _id=information.png style=\"vertical-align:middle\"} Content may be out of date",
// "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages:" => "An urgent request for translation has been sent. Until this page is updated, you can see a corrected version in the following pages:",
// "TOC" => "TOC",
// "cool" => "cool",
// "mr green" => "mr green",
// "razz" => "razz",
// "redface" => "redface",
// "rolleyes" => "rolleyes",
// "twisted" => "twisted",
// "santa" => "santa",
// "Total replies" => "Total replies",
// "Average number of replies per topic" => "Average number of replies per topic",
// "FAQ Stats" => "FAQ Stats",
// "SysLog" => "SysLog",
// "System log help" => "System log help",
// "system logs" => "system logs",
// "system logs tpl" => "system logs tpl",
// "Thank you for your submission" => "Thank you for your submission",
// "Send a link to a friend" => "Send a link to a friend",
// "The link was sent to the following addresses:" => "The link was sent to the following addresses:",
// "Friend's email" => "Friend's email",
// "Separate multiple email addresses with a comma." => "Separate multiple email addresses with a comma.",
// "Your name" => "Your name",
// "Your email" => "Your email",
// "I found an interesting page that I thought you would like." => "I found an interesting page that I thought you would like.",
// "Summary mode" => "Summary mode",
// "Show Page Differences" => "Show Page Differences",
// "Show Tidy Errors and Warnings" => "Show Tidy Errors and Warnings",
// "Show POST Data" => "Show POST Data",
// "Use Current Session/Logout" => "Use Current Session/Logout",
// "Recorded Links" => "Recorded Links",
// "Request:" => "Request:",
// "Element to compare (Xpath expression):" => "Element to compare (Xpath expression):",
// "Test Xpath Expression" => "Test Xpath Expression",
// "Post Variables" => "Post Variables",
// "Tidy Results" => "Tidy Results",
// "Delete this link" => "Delete this link",
// "Config" => "Config",
// "Replay" => "Replay",
// "Tidy extension not present" => "Tidy extension not present",
// "Notice" => "Notice",
// "PECL HTPP extension present" => "PECL HTPP extension present",
// "cURL extension present" => "cURL extension present",
// "PECL HTPP and cURL extension not present. Replay of the TikiTest will not be possible." => "PECL HTPP and cURL extension not present. Replay of the TikiTest will not be possible.",
// "List TikiTests" => "List TikiTests",
// "Create a TikiTest" => "Create a TikiTest",
// "Replay the TikiTest" => "Replay the TikiTest",
// "Edit the TikiTest" => "Edit the TikiTest",
// "File Name:" => "File Name:",
// "Start Recording Test" => "Start Recording Test",
// "Failure" => "Failure",
// "Reference" => "Reference",
// "The pages are different" => "The pages are different",
// "The pages are identical" => "The pages are identical",
// "Recording to pause press the pause button" => "Recording to pause press the pause button",
// "Pause the recording" => "Pause the recording",
// "Paused to resume press the play button" => "Paused to resume press the play button",
// "Resume the recording" => "Resume the recording",
// "Stop the recording" => "Stop the recording",
// "ThemeControl tpl" => "ThemeControl tpl",
// "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>." => "To learn more about <a class=\"rbox-link\" target=\"tikihelp\" href=\"http://themes.tikiwiki.org\">themes</a>.",
// "theme control objects tpl" => "theme control objects tpl",
// "theme control sections tpl" => "theme control sections tpl",
// "The following files have been successfully uploaded" => "The following files have been successfully uploaded",
// "Additional Info" => "Additional Info",
// "You can link to the file from a Wiki page using" => "You can link to the file from a Wiki page using",
// "You can display an image in a Wiki page using" => "You can display an image in a Wiki page using",
// "You can link to the file from an HTML page using" => "You can link to the file from an HTML page using",
// "You locked the file" => "You locked the file",
// "The file is locked by {\$fileInfo.lockedby}" => "The file is locked by {\$fileInfo.lockedby}",
// "Unzip all zip files" => "Unzip all zip files",
// "Maximum amount of downloads" => "Maximum amount of downloads",
// "0 for no limit" => "0 for no limit",
// "Author if not the file creator" => "Author if not the file creator",
// "No gallery available." => "No gallery available.",
// "You have to create a gallery first!" => "You have to create a gallery first!",
// "Image Gallery tpl" => "Image Gallery tpl",
// "Image ID thumb" => "Image ID thumb",
// "You can include the image in an Wiki page using" => "You can include the image in an Wiki page using",
// "User Assigned Modules tpl" => "User Assigned Modules tpl",
// "User Bookmarks tpl" => "User Bookmarks tpl",
// "a folder" => "a folder",
// "a URL" => "a URL",
// "User Contacts Preferences" => "User Contacts Preferences",
// "Edit User Contacts Preferences" => "Edit User Contacts Preferences",
// "Manage Fields" => "Manage Fields",
// "Default view" => "Default view",
// "Homepage" => "Homepage",
// "The user requested friendship with you" => "The user requested friendship with you",
// "Accept friendship from this user" => "Accept friendship from this user",
// "Refuse friendship from this user" => "Refuse friendship from this user",
// "Currently waiting for user approval" => "Currently waiting for user approval",
// "Cancel friendship request towards this user" => "Cancel friendship request towards this user",
// "Forum comments" => "Forum comments",
// "Toggle options" => "Toggle options",
// "Toggle" => "Toggle",
// "UserPreferences tpl" => "UserPreferences tpl",
// "Your personal tracker information" => "Your personal tracker information",
// "View extra information" => "View extra information",
// "Your preferred language" => "Your preferred language",
// "Can you read more languages?" => "Can you read more languages?",
// "Other languages you can read (select on the left to add to the list on the right)" => "Other languages you can read (select on the left to add to the list on the right)",
// "Select language..." => "Select language...",
// "My level" => "My level",
// "User Tasks tpl" => "User Tasks tpl",
// "Received task" => "Received task",
// "You received this task, please read and execute it" => "You received this task, please read and execute it",
// "Send task" => "Send task",
// "You send this task to a other user" => "You send this task to a other user",
// "Shared task" => "Shared task",
// "This task is public to a special group" => "This task is public to a special group",
// "Accepted by Task User and Creator" => "Accepted by Task User and Creator",
// "Accepted User and Creator" => "Accepted User and Creator",
// "Task is accepted by user and creator" => "Task is accepted by user and creator",
// "Not Accepted by One User" => "Not Accepted by One User",
// "Not Accepted User" => "Not Accepted User",
// "Task is rejected by one user" => "Task is rejected by one user",
// "Waiting for Me" => "Waiting for Me",
// "Task is not accepted by you, read the task and accept or reject it" => "Task is not accepted by you, read the task and accept or reject it",
// "Waiting for Other User" => "Waiting for Other User",
// "Task is not accepted/rejected by other user" => "Task is not accepted/rejected by other user",
// "Red" => "Red",
// "NOT accept" => "NOT accept",
// "This message will be send to users if you are makeing changes of assigned tasks" => "This message will be send to users if you are makeing changes of assigned tasks",
// "Marked as deleted" => "Marked as deleted",
// "You can only view this task" => "You can only view this task",
// "Public for group" => "Public for group",
// "User Watches tpl" => "User Watches tpl",
// "Use \"watches\" to monitor wiki pages or other objects." => "Use \"watches\" to monitor wiki pages or other objects.",
// "Watch new items by clicking the {icon _id=eye} button on specific pages." => "Watch new items by clicking the {icon _id=eye} button on specific pages.",
// "watched events" => "watched events",
// "A user submits a blog post" => "A user submits a blog post",
// "A user posts a forum thread" => "A user posts a forum thread",
// "A user posts a forum topic" => "A user posts a forum topic",
// "A user created a wiki page in a language" => "A user created a wiki page in a language",
// "Watch language wiki page creations" => "Watch language wiki page creations",
// "Add watch" => "Add watch",
// "Used space:" => "Used space:",
// "up to" => "up to",
// "no limit for admin" => "no limit for admin",
// "Insert Row" => "Insert Row",
// "Insert Column" => "Insert Column",
// "Remove Row" => "Remove Row",
// "Remove Column" => "Remove Column",
// "Merge Cells" => "Merge Cells",
// "Restore Cells" => "Restore Cells",
// "Copy Calculation" => "Copy Calculation",
// "Format Cell" => "Format Cell",
// "Before" => "Before",
// "After" => "After",
// "No articles." => "No articles.",
// "Permanency" => "Permanency",
// "info/vote" => "info/vote",
// "View FAQ Tpl" => "View FAQ Tpl",
// "Admin Menus tpl" => "Admin Menus tpl",
// "There are no questions in this FAQ." => "There are no questions in this FAQ.",
// "A" => "A",
// "Manage Message Queue" => "Manage Message Queue",
// "Manage Reported Messages" => "Manage Reported Messages",
// "Monitor Topics of this Forum" => "Monitor Topics of this Forum",
// "Stop Monitoring Topics of this Forum" => "Stop Monitoring Topics of this Forum",
// "Monitor Topics and Threads of this Forum" => "Monitor Topics and Threads of this Forum",
// "Stop Monitoring Topics and Threads of this Forum" => "Stop Monitoring Topics and Threads of this Forum",
// "You have {\$unread} unread private messages" => "You have {\$unread} unread private messages",
// "Your message has been queued for approval, the message will be posted after a moderator approves it." => "Your message has been queued for approval, the message will be posted after a moderator approves it.",
// "Another post with the same title and content already exists." => "Another post with the same title and content already exists.",
// "Please change your title or content then click Post." => "Please change your title or content then click Post.",
// "Editing" => "Editing",
// "Post New" => "Post New",
// "Watch for replies" => "Watch for replies",
// "Send me an e-mail when someone replies to my topic" => "Send me an e-mail when someone replies to my topic",
// "Don't send me any e-mails" => "Don't send me any e-mails",
// "Editing posts" => "Editing posts",
// "Hot" => "Hot",
// "Sticky" => "Sticky",
// "Unarchive" => "Unarchive",
// "posts in this forum" => "posts in this forum",
// "Show archived posts" => "Show archived posts",
// "Archived" => "Archived",
// "The post has been reported and will be reviewed by a moderator." => "The post has been reported and will be reviewed by a moderator.",
// "Print this page only" => "Print this page only",
// "Print all pages" => "Print all pages",
// "Tracker:" => "Tracker:",
// "Stop Monitor" => "Stop Monitor",
// "Tracker Items for" => "Tracker Items for",
// "Format : x,y,zoom - You can use Google Map Locator in the item view script." => "Format : x,y,zoom - You can use Google Map Locator in the item view script.",
// "Tracker Item:" => "Tracker Item:",
// "Edit/Delete" => "Edit/Delete",
// "Items list" => "Items list",
// "Remove Image" => "Remove Image",
// "Google Map Locator" => "Google Map Locator",
// "Special Operations" => "Special Operations",
// "fields marked with a * are mandatory" => "fields marked with a * are mandatory",
// "Edit mail account" => "Edit mail account",
// "Clip" => "Clip",
// "Word Limit Exceeded" => "Word Limit Exceeded",
// "Word Count:" => "Word Count:",
// "Number of voices" => "Number of voices",
// "You have ever subscribed" => "You have ever subscribed",
// "You have not yet subscribed" => "You have not yet subscribed",
// "friends" => "friends",
// "Unsubscribe" => "Unsubscribe",
// "Google Maps is not enabled." => "Google Maps is not enabled.",
// "Use this thread to discuss the page:" => "Use this thread to discuss the page:",
// "Missing or incorrect trackerId parameter for the plugin." => "Missing or incorrect trackerId parameter for the plugin.",
// "Subscribe to a group" => "Subscribe to a group",
// "Show Filters" => "Show Filters",
// "Toggle display" => "Toggle display",
// "Start:" => "Start:",
// "Close:" => "Close:",
// "List authors:" => "List authors:",
// "Save the page as a partial translation." => "Save the page as a partial translation.",
// "Partial Translation" => "Partial Translation",
// "Save the page as a completed translation." => "Save the page as a completed translation.",
// "Complete Translation" => "Complete Translation",
// "Save the page, but do not send notifications and do not count it as new content to be translated." => "Save the page, but do not send notifications and do not count it as new content to be translated.",
// "Save the page as a draft." => "Save the page as a draft.",
// "Save Draft" => "Save Draft",
// "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>" => "If you want people to be able to reply to you, you have to check <a href='tiki-user_preferences.php'>Allow messages from other users</a>",
// "Permission denied you cannot view the Tiki calendar" => "Permission denied you cannot view the Tiki calendar",
// "Administration" => "Administration",
// "Help on Configuration Sections" => "Help on Configuration Sections",
// "Wiki Attachments" => "Wiki Attachments",
// "Intertiki settings" => "Intertiki settings",
// "Freetags settings" => "Freetags settings",
// "Configure Site Ads and Banners" => "Configure Site Ads and Banners",
// "Help on \$admintitle Config" => "Help on \$admintitle Config",
// "Current version is up to date : <b>%s</b>" => "Current version is up to date : <b>%s</b>",
// "A new %s  major release branch is available." => "A new %s  major release branch is available.",
// "Must specify actionId" => "Must specify actionId",
// "Users Contributions: Addition" => "Users Contributions: Addition",
// "%s Contributions: Addition" => "%s Contributions: Addition",
// "Users Contributions: Suppression" => "Users Contributions: Suppression",
// "%s Contributions: Suppression" => "%s Contributions: Suppression",
// "Total Contributions Addition per Day" => "Total Contributions Addition per Day",
// "Total Contributions Addition per Week" => "Total Contributions Addition per Week",
// "Total Contributions Suppression per Day" => "Total Contributions Suppression per Day",
// "Total Contributions Suppression per Week" => "Total Contributions Suppression per Week",
// "Total Contributions: Addition" => "Total Contributions: Addition",
// "Total Contributions: Suppression" => "Total Contributions: Suppression",
// "Groups Contributions: Addition" => "Groups Contributions: Addition",
// "Groups Contributions: Suppression" => "Groups Contributions: Suppression",
// "white" => "white",
// "gray" => "gray",
// "silver" => "silver",
// "ivory" => "ivory",
// "whitesmoke" => "whitesmoke",
// "beige" => "beige",
// "darkgrey" => "darkgrey",
// "Click here to delete the category:" => "Click here to delete the category:",
// "You can not create a category with a name already existing at this level" => "You can not create a category with a name already existing at this level",
// "The file does not have the required header:" => "The file does not have the required header:",
// "Category can`t be parent of itself" => "Category can`t be parent of itself",
// "You have to provide a hotword and a URL" => "You have to provide a hotword and a URL",
// "moved %d images, %d errors occured." => "moved %d images, %d errors occured.",
// "a timeout occured. Hit the reload button to move the rest" => "a timeout occured. Hit the reload button to move the rest",
// "You cannot have a blank password" => "You cannot have a blank password",
// "Path to mapfiles is invalid" => "Path to mapfiles is invalid",
// "No valid gdaltindex executable" => "No valid gdaltindex executable",
// "You cannot mix old and new trackers" => "You cannot mix old and new trackers",
// "Requested action is not supported on repository" => "Requested action is not supported on repository",
// "Requested action in not supported on repository" => "Requested action in not supported on repository",
// "Mail-in account %s incorrect" => "Mail-in account %s incorrect",
// "Mail-in account %s saved" => "Mail-in account %s saved",
// "Frequency should be a positive integer!" => "Frequency should be a positive integer!",
// "Mail-in accounts set to be checked every %s minutes" => "Mail-in accounts set to be checked every %s minutes",
// "Automatic Mail-in accounts checking disabled" => "Automatic Mail-in accounts checking disabled",
// "Cannot create or update module: You need to specify a name to the module" => "Cannot create or update module: You need to specify a name to the module",
// "Cannot create or update module: You cannot leave the data field empty" => "Cannot create or update module: You cannot leave the data field empty",
// "Error opening uploaded file" => "Error opening uploaded file",
// "Invalid email" => "Invalid email",
// "You need to provide a username or an email" => "You need to provide a username or an email",
// "The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory." => "The \"Lsdir Wikiplugin\" is installed. It can be used by wiki editors to view the contents of any directory.",
// "The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts." => "The \"Bloglist Wikiplugin\" is installed. It can be used by wiki editors to disclose private blog posts.",
// "Path disclosure" => "Path disclosure",
// "Path disclosure through error message" => "Path disclosure through error message",
// "SQL injection" => "SQL injection",
// "SQL injection by authenticated user" => "SQL injection by authenticated user",
// "SQL injection by authenticated user with special privileges" => "SQL injection by authenticated user with special privileges",
// "SQL injection without authentication" => "SQL injection without authentication",
// "PHP command injection" => "PHP command injection",
// "PHP command injection by authenticated user" => "PHP command injection by authenticated user",
// "PHP command injection by authenticated user with special privileges" => "PHP command injection by authenticated user with special privileges",
// "PHP command injection without authentication" => "PHP command injection without authentication",
// "File upload" => "File upload",
// "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous." => "This is not a Tikiwiki file. Check if this file was uploaded and if it is dangerous.",
// "This is a modified File. Cannot check version. Check if it is dangerous." => "This is a modified File. Cannot check version. Check if it is dangerous.",
// "This file is from another Tikiwiki version: " => "This file is from another Tikiwiki version: ",
// "Remove group: " => "Remove group: ",
// "Remove permission: %s on %s" => "Remove permission: %s on %s",
// "User login or email is required" => "User login or email is required",
// "User does not exist on master" => "User does not exist on master",
// "User login contains invalid characters" => "User login contains invalid characters",
// "Impossible to create new %s with %s %s." => "Impossible to create new %s with %s %s.",
// "Deleted account %s" => "Deleted account %s",
// "%s <b>%s</b> assigned to %s <b>%s</b>." => "%s <b>%s</b> assigned to %s <b>%s</b>.",
// "%s <b>%s</b> removed from %s <b>%s</b>." => "%s <b>%s</b> removed from %s <b>%s</b>.",
// "group <b>%s</b> set as the default group of user <b>%s</b>." => "group <b>%s</b> set as the default group of user <b>%s</b>.",
// "%s changed from %s to %s" => "%s changed from %s to %s",
// "Impossible to change %s from %s to %s" => "Impossible to change %s from %s to %s",
// "Login contains invalid characters" => "Login contains invalid characters",
// "Image annotations changed." => "Image annotations changed.",
// "approved by " => "approved by ",
// "This function is only for staging pages" => "This function is only for staging pages",
// "Permission denied you cannot approve staging pages" => "Permission denied you cannot approve staging pages",
// "Approved page was last saved after most recent staging edit" => "Approved page was last saved after most recent staging edit",
// "Unassign perm %s from group %s" => "Unassign perm %s from group %s",
// "You have to indicate a group" => "You have to indicate a group",
// "This group is invalid" => "This group is invalid",
// "Permission denied you cannot view backlinks for this page" => "Permission denied you cannot view backlinks for this page",
// "Image %s upload failed." => "Image %s upload failed.",
// "Image %s uploaded successfully." => "Image %s uploaded successfully.",
// "Image %s removed from Batch directory." => "Image %s removed from Batch directory.",
// "Impossible to remove image %s from Batch directory." => "Impossible to remove image %s from Batch directory.",
// "Permission denied you cannot use the batch directory loading" => "Permission denied you cannot use the batch directory loading",
// "Please contact the website administrator." => "Please contact the website administrator.",
// "Upload was successful" => "Upload was successful",
// "Last modifications to the blog." => "Last modifications to the blog.",
// "TOP" => "TOP",
// "Nothing tagged yet" => "Nothing tagged yet",
// "You must clear your browser cache." => "You must clear your browser cache.",
// "Permission denied you can not view this page" => "Permission denied you can not view this page",
// "%m/%d" => "%m/%d",
// "%H:%M %Z" => "%H:%M %Z",
// "Tiki RSS feed for calendars" => "Tiki RSS feed for calendars",
// "Upcoming events." => "Upcoming events.",
// "End:" => "End:",
// "Permission denied; you cannot assign permissions for this category" => "Permission denied; you cannot assign permissions for this category",
// "Invalid username or activation code. Maybe this code has already been used." => "Invalid username or activation code. Maybe this code has already been used.",
// "Invalid old password or unknown user" => "Invalid old password or unknown user",
// "Problem. Try to log in again to receive new confirmation instructions." => "Problem. Try to log in again to receive new confirmation instructions.",
// "ERROR: you must include a subject or a message at least" => "ERROR: you must include a subject or a message at least",
// "You need to change chmod 'whelp' manually to 777" => "You need to change chmod 'whelp' manually to 777",
// "You have mistyped the anti-bot verification code; please try again. " => "You have mistyped the anti-bot verification code; please try again. ",
// "No parent specified" => "No parent specified",
// "Last sites of directory \".\$rc[\"name\"].\" ." => "Last sites of directory \".\$rc[\"name\"].\" .",
// "You cannot download this file right now. Your score is low or file limit was reached." => "You cannot download this file right now. Your score is low or file limit was reached.",
// "Error : The file %s doesn't exist." => "Error : The file %s doesn't exist.",
// "Invalid email:" => "Invalid email:",
// "The language can't be changed as its set of translations has already this language" => "The language can't be changed as its set of translations has already this language",
// "Invalid structure_id or page_ref_id" => "Invalid structure_id or page_ref_id",
// "You do not have permission to write the template:" => "You do not have permission to write the template:",
// "Translation in progress." => "Translation in progress.",
// "Page is a staging copy. Translation must begin from the approved copy." => "Page is a staging copy. Translation must begin from the approved copy.",
// "Not enable for this type of object" => "Not enable for this type of object",
// "Override lock and carry on with edit" => "Override lock and carry on with edit",
// "Page is currently being edited" => "Page is currently being edited",
// "This page is being edited by " => "This page is being edited by ",
// "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. " => "Please check with the user before editing the page,\n\t\t\totherwise the changes will be stored as two separate versions in the history and\n\t\t\tyou will have to manually merge them later. ",
// "Page already exists. Go back and choose a different name." => "Page already exists. Go back and choose a different name.",
// "The translation set already contains a page in this language." => "The translation set already contains a page in this language.",
// "No questions group indicated" => "No questions group indicated",
// "Remove archive: " => "Remove archive: ",
// "Remove file gallery: " => "Remove file gallery: ",
// "Form error - no import method selected for some reason." => "Form error - no import method selected for some reason.",
// "Form error - no server-side filename entered for selected import method." => "Form error - no server-side filename entered for selected import method.",
// "Last replied forum topics" => "Last replied forum topics",
// "Not supported yet." => "Not supported yet.",
// "Accepted friendship request from %s" => "Accepted friendship request from %s",
// "Refused friendship request from %s" => "Refused friendship request from %s",
// "Canceled friendship request with %s" => "Canceled friendship request with %s",
// "Broke friendship with %s" => "Broke friendship with %s",
// "I have broken our friendship!" => "I have broken our friendship!",
// "You must be logged in to use this feature" => "You must be logged in to use this feature",
// "Friendship request sent to %s" => "Friendship request sent to %s",
// "You're already friend of %s" => "You're already friend of %s",
// "I have accepted your friendship request!" => "I have accepted your friendship request!",
// "I have refused your friendship request." => "I have refused your friendship request.",
// "I have canceled my friendship request." => "I have canceled my friendship request.",
// "Role name cannot be empty" => "Role name cannot be empty",
// "Activity name cannot be empty" => "Activity name cannot be empty",
// "Invalid source path" => "Invalid source path",
// "A start activity requires a name for the instance" => "A start activity requires a name for the instance",
// "You couldn't abort a instance" => "You couldn't abort a instance",
// "You couldn't exception a instance" => "You couldn't exception a instance",
// "Permission denied you cannot make the map of this gallery" => "Permission denied you cannot make the map of this gallery",
// "Back to preferences" => "Back to preferences",
// "Back to item" => "Back to item",
// "No valid renderer found. GD or PDFLib required." => "No valid renderer found. GD or PDFLib required.",
// "No sheet specified." => "No sheet specified.",
// "You must select a renderer." => "You must select a renderer.",
// "Invalid Series for current graphic." => "Invalid Series for current graphic.",
// "Last images uploaded to the image galleries." => "Last images uploaded to the image galleries.",
// "Only the administrator can upload language files." => "Only the administrator can upload language files.",
// "updated from structured text import" => "updated from structured text import",
// "created from structured text import" => "created from structured text import",
// "%s - Version %d of this page has been saved by %s." => "%s - Version %d of this page has been saved by %s.",
// "Error writing in the databse: \$query" => "Error writing in the databse: \$query",
// "The file is already locked by %s" => "The file is already locked by %s",
// "Remove file: " => "Remove file: ",
// "Warning: Empty file:" => "Warning: Empty file:",
// "Please re-upload your file" => "Please re-upload your file",
// "Permission denied you can edit this file" => "Permission denied you can edit this file",
// "Cannot read file:" => "Cannot read file:",
// "Cannot read the file:" => "Cannot read the file:",
// "Upload was not successful. Duplicate file content" => "Upload was not successful. Duplicate file content",
// "This gallery does not exist" => "This gallery does not exist",
// "The game file must have .swf or .dcr extension" => "The game file must have .swf or .dcr extension",
// "Please supply both files" => "Please supply both files",
// "Delete those pages:" => "Delete those pages:",
// "Unable to contact remote server." => "Unable to contact remote server.",
// "XMLRPC Error: " => "XMLRPC Error: ",
// "Unable to create login" => "Unable to create login",
// "More than %d unsuccessful login attempts have been made." => "More than %d unsuccessful login attempts have been made.",
// "An email has been sent to you with the instructions to follow." => "An email has been sent to you with the instructions to follow.",
// "Invalid password" => "Invalid password",
// "Account disabled" => "Account disabled",
// "You must use the right case for your user name" => "You must use the right case for your user name",
// "You are not yet validated" => "You are not yet validated",
// "Your default nickname is already in use. A new one has to be selected." => "Your default nickname is already in use. A new one has to be selected.",
// "The selected account is not associated with your identity." => "The selected account is not associated with your identity.",
// "unknown action" => "unknown action",
// "Authentication method is not OpenID" => "Authentication method is not OpenID",
// "Tiki mail-in auto-reply" => "Tiki mail-in auto-reply",
// "Feature Ajax Disabled. Please ask your site administrator to enable" => "Feature Ajax Disabled. Please ask your site administrator to enable",
// "You must first setup MapServer" => "You must first setup MapServer",
// "invalid mapfile name" => "invalid mapfile name",
// "An error as occured with the mapfile: " => "An error as occured with the mapfile: ",
// "Please create a directory named '.\$prefs['map_path'].' to hold your map files." => "Please create a directory named '.\$prefs['map_path'].' to hold your map files.",
// "Maps feature is not correctly setup : Maps path is missing." => "Maps feature is not correctly setup : Maps path is missing.",
// "map edit" => "map edit",
// "I do not know where is gdaltindex. Set correctly the Map feature" => "I do not know where is gdaltindex. Set correctly the Map feature",
// "This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more." => "This Tikiwiki site is prepared for access from a lot of mobile devices, e.g. WAP phones, PDA's, i-mode devices and much more.",
// "You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:" => "You can browse this site on your mobile device by directing your device's browser towards the following URL here on this site:",
// "tiki-mobile.php" => "tiki-mobile.php",
// "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody" => "You need to run setup.sh :<br />./setup.sh \$APACHEUSER all<br />Common Apache users are www-data, apache or nobody",
// "merged note:" => "merged note:",
// "Permission denied you cannot assign permissions for this object" => "Permission denied you cannot assign permissions for this object",
// "Permission denied you cannot view the source of this page" => "Permission denied you cannot view the source of this page",
// "Pageviews" => "Pageviews",
// "You don't have permission to edit quizzes." => "You don't have permission to edit quizzes.",
// "Registered" => "Registered",
// "You must choose a group" => "You must choose a group",
// "Username cannot contain uppercase letters" => "Username cannot contain uppercase letters",
// "Username must be at least" => "Username must be at least",
// "Username cannot contain more than" => "Username cannot contain more than",
// "characters" => "characters",
// "Please enter a valid %s.  No spaces, more than %d characters and contain %s" => "Please enter a valid %s.  No spaces, more than %d characters and contain %s",
// "This is not a valid mail adress" => "This is not a valid mail adress",
// "mail adress" => "mail adress",
// "Unable to send mail. User has not configured email" => "Unable to send mail. User has not configured email",
// "Invalid or unknown email" => "Invalid or unknown email",
// "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password." => "Please contact the Administrator if you do not get the email, or if there is an issue with resetting the password.",
// "The mail can't be sent. Contact the administrator" => "The mail can't be sent. Contact the administrator",
// "An email with a link to reset your password has been sent " => "An email with a link to reset your password has been sent ",
// "to the email " => "to the email ",
// "You cannot rename staging pages. Please rename the approved page instead." => "You cannot rename staging pages. Please rename the approved page instead.",
// "Permission denied you cannot rename this page" => "Permission denied you cannot rename this page",
// "Cannot rename page because the new name begins with reserved prefix" => "Cannot rename page because the new name begins with reserved prefix",
// "Cannot rename page because maybe new staging page name already exists" => "Cannot rename page because maybe new staging page name already exists",
// "changed '%s' from '%s' to '%s'" => "changed '%s' from '%s' to '%s'",
// "Error Message" => "Error Message",
// "Tiki RSS Feed Error Message: \$errmsg" => "Tiki RSS Feed Error Message: \$errmsg",
// "Post recommendation at" => "Post recommendation at",
// "Notice: this variable may not be empty:" => "Notice: this variable may not be empty:",
// "Notice: invalid variable value:" => "Notice: invalid variable value:",
// "Permission denied you cannot remove this sheet" => "Permission denied you cannot remove this sheet",
// "You do not have permission to edit messages \$owner" => "You do not have permission to edit messages \$owner",
// "Report to the webmaster" => "Report to the webmaster",
// "Tracker item:" => "Tracker item:",
// "No trackerId specified" => "No trackerId specified",
// "You must lock the file before editing it" => "You must lock the file before editing it",
// "Password has been changed" => "Password has been changed",
// "Invalid password.  Your current password is required to change administrative information" => "Invalid password.  Your current password is required to change administrative information",
// "was moved into trash" => "was moved into trash",
// "trashed by" => "trashed by",
// "Rights by creator" => "Rights by creator",
// "END" => "END",
// "Percentage" => "Percentage",
// "Task accepted by creator" => "Task accepted by creator",
// "Task accepted by task user" => "Task accepted by task user",
// "Task NOT accepted by creator" => "Task NOT accepted by creator",
// "Task NOT accepted by task user" => "Task NOT accepted by task user",
// "Sorry this task does not exist or you have no rights to view this task" => "Sorry this task does not exist or you have no rights to view this task",
// "Task entries:" => "Task entries:",
// "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!" => "Sorry you are not allowed to send tasks to other users, or the user is not allowed to receive tasks!",
// "You've to start your work at least on" => "You've to start your work at least on",
// "You've to finish your work on" => "You've to finish your work on",
// "Login and click the link below" => "Login and click the link below",
// "Please read the task and work on it!" => "Please read the task and work on it!",
// "Sorry, there was an error while trying to write data into the database" => "Sorry, there was an error while trying to write data into the database",
// "Language watch" => "Language watch",
// "Permission denied: you cannot view this blog post while it is marked private" => "Permission denied: you cannot view this blog post while it is marked private",
// "You must suggest a question; please try again." => "You must suggest a question; please try again.",
// "Incorrect thread" => "Incorrect thread",
// "That tracker don't use extras." => "That tracker don't use extras.",
// "Tidy Extension not present" => "Tidy Extension not present",
// "The TikiTests Replay File is Empty" => "The TikiTests Replay File is Empty",
// "TikiTests Edit" => "TikiTests Edit",
// "You are about to delete a TikiTest file, do you want to continue ?" => "You are about to delete a TikiTest file, do you want to continue ?",
// "Error deleting the file" => "Error deleting the file",
// "TikiTest List" => "TikiTest List",
// "TikiTest Record" => "TikiTest Record",
// "You need one of the extension pecl HTTP or Curl to replay the TikiTest" => "You need one of the extension pecl HTTP or Curl to replay the TikiTest",
// "The TikiTest Replay File is Empty" => "The TikiTest Replay File is Empty",
// "TikiTest Replay" => "TikiTest Replay",
// "The page is empty" => "The page is empty",
// ### end of untranslated words
// ###

// ###
// ### start of possibly untranslated words
// ###

"Diff" => "Diff",
"OK" => "OK",
"Standard" => "Standard",
"Prio" => "Prio",
"Import/Export" => "Import/Export",
// ###
// ### end of possibly untranslated words
// ###

"This feature is disabled" => "Diese Funktion ist deaktiviert",
"Permission denied you cannot view pages" => "Zugriff verweigert. Sie k&ouml;nnen keine Seiten ansehen",
"Cannot write to this file:" => "Kann diese Datei nicht schreiben:",
"Cannot upload this file maximum upload size exceeded" => "Datei &uuml;berschreitet maximale Gr&ouml;&szlig; f&uuml;r das Hochladen",
"Re:" => "Aw:",
"Missing title or body when trying to post a comment" => "Fehlender Titel oder Textk&ouml;rper beim Posten eines Kommentars",
"A contribution is mandatory" => "Die Art der Beteiligung mu&szlig; angegeben werden",
"You do not have permission to use this feature" => "Sie haben keine Berechtigung, diese Funktion zu nutzen",
"This script cannot be called directly" => "Dieses Script kann nicht direkt aufgerufen werden",
"The copyright management feature is not enabled." => "Das Copyright Management ist nicht aktiviert.",
"No page indicated" => "Keine Seite angegeben",
"You must supply all the information, including title and year." => "Sie m&uuml;ssen alle Daten angeben, inkl. Titel und Jahr.",
"This feature is for admins only" => "Zugriff nur f&uuml;r Admin m&ouml;glich",
"Type" => "Typ",
"Description" => "Beschreibung",
"Size" => "Gr&ouml;&szlig;e",
"Created" => "Erstellt",
"Uploaded" => "Hochgeladen",
"Last Modified" => "Zuletzt modifiziert",
"Creator" => "Ersteller",
"Author" => "Autor",
"Comment" => "Kommentar",
"Files" => "Dateien",
"Hits" => "Zugriffe",
"Locked by" => "Gesperrt von",
"Path" => "Pfad",
"The text in RED is" => "Der Text in ROT ist",
"character(s) too long - please edit it." => "Zeichen zu lang. Bitte anpassen.",
"None" => "Keine",
"Other" => "Sonstige",
"Chinese" => "Chinesisch",
"Czech" => "Tschechisch",
"Danish" => "D&auml;nisch",
"German" => "Deutsch",
"English" => "Englisch",
"Spanish" => "Spanisch",
"Greek" => "Griechisch",
"Italian" => "Italienisch",
"Japanese" => "Japanisch",
"Dutch" => "Holl&auml;dnisch",
"Norwegian" => "Norwegisch",
"Polish" => "Polnisch",
"Russian" => "Russisch",
"Swedish" => "Schwedisch",
"Fatal error: cannot execute automatic activity \$activityId" => "Fataler Fehler: Kann automatische Aktivit&auml; \$activityId nicht ausf&uuml;hren",
"Fatal error: setting next activity to an unexisting activity" => "Fataler Fehler: Folgeaktivit&auml;t wurde auf einen ung&uuml;ltigen Eintrag gesetzt",
"Fatal error: trying to send an instance to an activity but no transition found" => "Fataler Fehler: Versuch, eine Instanz an eine Aktivit&auml;t zu schicken, jedoch ist kein &Uuml;bergang definiert",
"Process does not have a start activity" => "Prozess besitzt keine Start-Aktivit&auml;t",
"Process does not have exactly one end activity" => "Prozess besitzt nicht genau eine End-Aktivit&auml;t",
"End activity is not reachable from start activity" => "End-Aktivit&auml; von der Start-Aktivit&auml;t aus nicht erreichbar",
"Activity" => "Aktivit&auml;t",
" is interactive but has no role assigned" => " ist interaktiv, besitzt aber keine zugeordnete Rolle",
" is standalone but has transitions" => " ist standalone, besitzt aber &Uuml;berg&auml;nge",
"Role" => "Rolle",
"Process %d has been activated" => "Prozess %d wurde aktiviert",
"Process %d has been deactivated" => "Prozess %d wurde deaktiviert",
"Process %s %s imported" => "Prozess %s %s importiert",
"Process %s removed" => "Prozess %s entfernt",
"Process %s has been updated" => "Prozess %s wurde aktualisiert",
"Process %s has been created" => "Prozess %s wurde erstellt",
"Permission denied" => "Zugriff verweigert",
"The file is not a CSV file or has not a correct syntax" => "Diese Datei ist keine CSV Datei oder hat nicht die erforderliche Syntax",
"locked" => "gesperrt",
"locked by" => "gesperrt von",
"continued" => "weiter",
"New Image Uploaded by" => "Neue Bilder hochgeladen von",
"New Subscriptions" => "Neue Abonnenten",
"New Item in Tracker" => "Neuer Eintrag im Tracker",
"tracker" => "Tracker",
"by" => "von",
"Image Gallery" => "Bildergalerie",
"Articles" => "Artikel",
"Forums" => "Foren",
"Directory" => "Linkverzeichnis",
"File Gallery" => "Dateiarchiv",
"Quizzes" => "Quiz",
"Trackers" => "Tracker",
"Survey" => "Umfrage",
"Charts" => "Hitlisten",
"article" => "Artikel",
"blog" => "Blog",
"directory" => "Linkverzeichnis",
"faq" => "FAQ",
"file gallery" => "Dateiarchiv",
"forum" => "Forum",
"image gallery" => "Bildergalerie",
"newsletter" => "Newsletter",
"poll" => "Abstimmung",
"quiz" => "Quiz",
"wiki page" => "Wiki-Seite",
"image" => "Bild",
"calendar" => "Kalender",
"Anonymous" => "Unbekannt",
"Line:" => "Zeile:",
"Lines:" => "Zeilen:",
"Newsletter subscription information at " => "Newsletter Registrierungsinfos auf ",
"Find" => "Suchen",
"find" => "Suchen",
"prev" => "vorh.",
"Page" => "Seite",
"next" => "n&auml;chstes",
"Page name" => "Seitenname",
"Wiki Home" => "Wiki-Home",
"Home" => "Startseite",
"previous page" => "vorherige Seite",
"next page" => "n&auml;chste Seite",
"posted on" => "aufgegeben am",
"By:" => "Von:",
"Read" => "Lesen",
"List articles" => "Artikel auflisten",
"Last post" => "Neuester Eintrag",
"Invalid imagename (using filters for filenames)" => "Ung&uuml;ltiger Dateiname (using filters for filenames)",
"Errors detected" => "Fehler entdeckt",
"Upload was not successful" => "Hochladen war nicht erfolgreich",
"No image yet, sorry." => "Leider noch keine Bilder vorhanden.",
"unknown" => "unbekannt",
"NONE" => "KEINES",
"Wiki top pages" => "Wiki-Top-Seiten",
"Most relevant pages" => "Relevanteste Seiten",
"Relevance" => "Relevanz",
"Wiki last pages" => "Neueste Wiki-Seiten",
"Modified" => "Ge&auml;ndert",
"Forums last topics" => "Neueste Forenthemen",
"Topic date" => "Themendatum",
"Forums most read topics" => "Foren mit den meistgelesenen Themen",
"Reads" => "Zugriffe",
"Forums best topics" => "Foren mit den beliebtesten Themen",
"Score" => "Punkte",
"Forums most visited forums" => "Meistbesuchte Foren",
"Visits" => "Besuche",
"Forums with most posts" => "Foren mit den meisten Beitr&auml;gen",
"Posts" => "Eintr&auml;ge",
"Wiki top galleries" => "Wiki Top Galerien",
"Wiki top file galleries" => "Wiki Top Dateiarchive",
"Wiki top images" => "Wiki Top Bilder",
"Wiki top files" => "Wiki Top Dateien",
"Wiki last images" => "Wiki neueste Bilder",
"Upload date" => "Hochlade-Datum",
"Wiki last files" => "Wiki neueste Dateien",
"Wiki top articles" => "Meistgelesene Artikel",
"Most visited blogs" => "Meistbesuchte Blogs",
"Most active blogs" => "Aktivste Blogs",
"Blogs last posts" => "Neueste Blog-Eintr&auml;ge",
"Post date" => "Eintragsdatum",
"Wiki top authors" => "Wiki Top Autoren",
"Pages" => "Seiten",
"Top article authors" => "Top Artikel-Autoren",
"User already exists" => "Benutzer existiert bereits",
"Wrong registration code" => "Falscher Registrierungscode",
"Invalid username" => "Benutzername ung&uuml;ltig",
"Username is too long" => "Benutzername zu lang",
"Username cannot contain whitespace" => "Benutzername darf keine Leerzeichen enthalten",
"Wrong passcode you need to know the passcode to register in this site" => "Falscher Passcode. Sie m&uuml;ssen Ihren Passcode kennen, um sich an dieser Site zu registrieren",
"Invalid email address. You must enter a valid email address" => "eMail-Adresse ung&uuml;ltig. Eine g&uuml;ltige Adresse ist zwingend",
"Login" => "Anmeldung",
"See other user's profile" => "Profil eines anderen Benutzers ansehen",
"Have your profile seen" => "Benutzer sieht sich Ihr Profil an",
"Make friends" => "Freundschaft schlie&szlig;en",
"Receive message" => "Nachricht empfangen",
"Send message" => "Nachricht schicken",
"Read an article" => "Artikel lesen",
"Publish an article" => "Artikel ver&ouml;ffentlichen",
"Have your article read" => "Benutzer liest Ihren Artikel",
"Create new file gallery" => "Neues Dateiarchiv anlegen",
"Upload new file to gallery" => "Datei in Archiv hochladen",
"Download other user's file" => "Datei eines anderen Benutzers herunterladen",
"Have your file downloaded" => "Benutzer l&auml;d eine Ihrer Dateien herunter",
"Create a new image gallery" => "Neue Bildgalerie anlegen",
"Upload new image to gallery" => "Bild in Galerie hochladen",
"See other user's gallery" => "Galerie eines anderen Benutzers anschauen",
"See other user's image" => "Bild eines anderen Benutzers betrachten",
"Have your gallery seen by other user" => "Benutzer betrachtet Ihre Galerie",
"Have your image seen" => "Benutzer betrachtet eines Ihrer Bilder",
"Create new blog" => "Neuen Blog erstellen",
"Post in a blog" => "Eintrag in Blog vornehmen",
"Read other user's blog" => "Blog eines anderen Benutzers lesen",
"Have your blog read" => "Benutzer liest Ihren Blog",
"Create a new wiki page" => "Neue Wiki-Seite erstellen",
"Edit an existing page" => "Vorhandene Wiki-Seite bearbeiten",
"Attach file" => "Datei anh&auml;ngen",
"Unknown" => "Unbekannt",
"Image" => "Bild",
"Article" => "Artikel",
"Directory category" => "Verzeichniskategorie",
"Gallery" => "Galerie",
"File" => "Datei",
"Blog post" => "Blog-Eintrag",
"Prev" => "Vorher.",
"Next" => "N&auml;chst.",
"help" => "Hilfe",
"All" => "Alle",
"days" => "Tage",
"day" => "Tag",
"hours" => "Stunden",
"hour" => "Stunde",
"mins" => "Min.",
"min" => "Min.",
"secs" => "Sek.",
"done" => "fertig",
"Task" => "Aufgabe",
"from" => "von",
"for" => "f&uuml;r",
"Priority" => "Priorit&auml;t",
"Start date:" => "Anfangsdatum",
"End date:" => "Enddatum",
"Friend" => "Freund",
"Last seen on " => "Zuletzt online am",
"(idle for %s seconds)" => "(unt&auml;tig f&uuml;r %s Sekunden)",
"User information - Click for more info" => "Benutzer Information - Klick f&uuml;r weitere Details",
"More info about \$other_user" => "Mehr Info &uuml;ber \$other_user",
"(idle for \$idletime seconds)" => "(nicht am Rechner seit \$idletime Sekunden)",
"Use this tree to copy the structure" => "Diesen Baum benutzen zum Erstellen der Struktur",
"created from structure" => "aus Struktur erstellt",
"Table of contents" => "Inhaltsverzeichnis",
"unknown error" => "Unbekannter Fehler",
"You are not logged in" => "Sie sind nicht angemeldet",
"Page cannot be found" => "Seite nicht gefunden",
"Help" => "Hilfe",
"You are banned from" => "Sie wurden verbannt von",
"wiki" => "Wiki",
"img-g" => "Bildergalerien",
"file-g" => "Dateiarchive",
"faqs" => "FAQs",
"quizzes" => "Quiz",
"arts" => "Artikel",
"blogs" => "Blogs",
"forums" => "Foren",
"games" => "Spiele",
"picture not found" => "Bild nicht gefunden",
"drawing not found" => "Zeichnung nicht gefunden",
"Click to edit dynamic variable" => "Klicken zum Bearbeiten der dynamischen Variable",
"Update variables" => "Variablen aktualisieren",
"Show" => "Zeigen",
"Hide" => "Verbergen",
"%d points" => "%d Punkte",
"Removed" => "Gel&ouml;scht",
"at" => "um",
"new" => "neu",
"Create page:" => "Seite erstellen:",
"Unknown language" => "unbekannte Sprache",
"Click here to confirm your action" => "Zur Best&auml;tigung hier klicken",
"Item" => "Eintrag",
"Tracker was modified at " => "Tracker wurde ver&auml;ndert auf ",
"text field" => "Eingabefeld",
"size" => "Gr&ouml;&szlig;e",
"textarea" => "Textbereich",
"checkbox" => "Schalter",
"Checkbox options: put 1 if you need that next field is on the same row." => "Auswahlfeld-Optionen: 1 eintragen, falls das n&auml;chste Feld in derselben Spalte sein soll",
"numeric field" => "Zahl",
"drop down" => "Auswahlliste",
"user selector" => "Nutzerauswahl",
"group selector" => "Gruppenauswahl",
"date and time" => "Datum und Zeit",
"jscalendar" => "JSKalender",
"action" => "Aktion",
"header" => "&Uuml;berschrift einf&uuml;gen",
"category" => "Kategorie",
"email" => "eMail",
"system" => "System",
"attachment" => "Anhang",
"open" => "offen",
"pending" => "anstehend",
"closed" => "geschlossen",
"Message" => "Nachricht",
"child categories" => "Unterkategorien",
"objects in category" => "Objekte in Kategorie",
"Password should be at least" => "Pa&szlig;wort sollte mindestens",
"characters long" => "Zeichen lang sein",
"Password must contain both letters and numbers" => "Pa&szlig;wort muss sowohl Buchstaben als auch Zahlen enthalten",
"State" => "Status",
"Country" => "Land",
"Date" => "Datum",
"Title" => "Titel",
"data" => "Daten",
"one data per line" => "ein Eintrag pro Zeile",
"users" => "Benutzer",
"Displays the user Avatar" => "Zeigt den Benutzer-Avatar an.",
"username" => "Benutzername",
"No pages links to" => "Keine Seitenverweise auf",
"One page links to" => "Ein Seitenverweis auf",
"pages link to" => "Seitenverweise auf",
"Insert theme styled box on wiki page" => "Box im Theme-Layout in Wiki-Seite einf&uuml;gen",
"text" => "Text",
"Calendar" => "Kalender",
"Insert list of items for the current/given category into wiki page" => "Alle Eintr&auml;ge der aktuellen/angegebenen Kategorie in die Wiki-Seite einf&uuml;gen",
"Categories are disabled" => "Kategorien sind nicht aktiviert",
"Display Tiki objects that have not been categorized" => "Noch nicht kategorisierte Tiki-Objekte anzeigen",
"Insert the full category path for each category that this wiki page belongs to" => "F&uuml;gt den Kategorienbaum f&uuml;r jede Kategorie an, zu der diese Seite geh&ouml;rt",
"Centers the plugin content in the wiki page" => "Zentriert den PlugIn-Inhalt innerhalb der Wiki-Seite.",
"Chart" => "Hitliste",
"title" => "Titel",
"Displays a snippet of code" => "Zeigt einen Quellcode-Ausschnitt an",
"code" => "Quellcode",
"Insert copyright notices" => "F&uuml;gt Copyright-Notizen ein.",
"Example" => "Beispiel",
"minutes" => "Minuten",
"and" => "und",
"seconds" => "Sekunden",
"Creates a definition list" => "Legt eine Definitionsliste an",
"term" => "Term",
"definition" => "Definition",
"one definition per line" => "eine Definition pro Zeile",
"Upcoming events" => "n&auml;chste Termine",
"Displays the data using the Tikiwiki odd/even table style" => "Daten im Tiki gerade/ungerade Stil anzeigen",
"cells" => "Zellen",
"heads and cells separated by ~|~" => "Kopfzellen und sonstige Felder werden getrennt durch ~|~",
"description" => "Beschreibung",
"Include a page" => "Eine Seite einbinden",
"Feature disabled" => "Funktion deaktiviert",
"Please choose a module" => "Bitte ein Modul w&auml;hlen",
"to be used as argument" => "als Argument zu verwenden",
"Displays a module inlined in page" => "Zeigt ein Modul innerhalb einer Wiki-Seite an.",
"Sorry no such module" => "Kein solches Modul vorhanden",
"Displays the data using a monospace font" => "Zeigt den PlugIn-Inhalt in einer MonoSpace-Schrift an",
"No version indicated" => "Keine Version angegeben",
"No arguments indicated" => "Es wurden keine Argumente angegeben",
"Automatically creates a link to the appropriate SourceForge object" => "Erstellt automatisch einen Link zum passenden SourceForge Objekt",
"List wiki pages" => "Wiki-Seiten auflisten",
"Last modified by" => "Zuletzt bearbeitet von",
"Sorts the plugin content in the wiki page" => "Sortiert den PlugIn-Inhalt innerhalb einer Wiki-Seite",
"Edit" => "Bearbeiten",
"Split a page into rows and columns" => "Seite in Spalten und Zeilen aufteilen",
"Missing db param" => "Datenbank-Parameter fehlt",
"Run a sql query" => "SQL-Abfrage ausf&uuml;hren",
"sql query" => "SQL-Abfrage",
"No pages found for title search" => "Titelsuche hat keine Seiten gefunden",
"One page found for title search" => "Titelsuche hat eine Seite gefunden",
" pages found for title search" => " Seiten bei Titelsuche gefunden",
"Error" => "Fehler",
"Rating" => "Wertung",
"Select All" => "Alle ausw&auml;hlen",
"No field indicated" => "Kein Feld angegeben",
"Links to a translated content" => "Verweist auf einen &uuml;bersetzten Inhalt",
"External Wiki" => "Externes Wiki",
"valid" => "g&uuml;ltig",
"Plugin " => "PlugIn ",
"failed" => "fehlgeschlagen",
"Removed last version" => "L&ouml;schte letzte Version",
"ERROR: Either the subject or body must be non-empty" => "FEHLER: Text und Betreff d&uuml;rfen nicht leer sein.",
"ERROR: No valid users to send the message" => "FEHLER: Keine g&uuml;ltigen Benutzer zum Verschicken der Nachricht.",
"Invalid user" => "Ungueltiger Benutzer",
"Message sent to" => "Nachricht gesandt an",
"Sent box is full. Archive or delete some sent messages first if you want to send more messages." => "Ausgangsordner ist voll. Bitte ein paar verschickte Nachrichten archivieren oder l&ouml;schen, damit weitere verschickt werden k&ouml;nnen.",
"User %s can not receive messages, mailbox is full" => "Benutzer %s kann keine Nachrichten empfangen, Briefkasten ist voll.",
"User %s can not receive messages" => "Benutzer %s kann keine Nachrichten empfangen.",
"Invalid user: %s" => "Ung&uuml;ltiger Benutzer: %s.",
"Message will be sent to: " => "Die Nachricht wird versandt an: ",
"Archive is full. Delete some messages from archive first." => "Archiv ist voll! Bitte erst ein paar Nachrichten aus dem Archiv l&ouml;schen.",
"No more messages" => "Keine weiteren Nachrichten",
"Tiki Calendar" => "Tiki Kalender",
"Create/Edit" => "Hinzuf&uuml;gen/bearbeiten",
"Quick Edit a Wiki Page" => "Schnellbearbeitung einer Wiki-Seite",
"new users" => "Neue Benutzer",
"Since your last visit" => "Was ist neu?",
"Changes" => "&Auml;nderungen",
"since" => "seit",
"Changes since" => "&Auml;nderungen seit",
"new comments" => "Neue Kommentare",
"wiki pages changed" => "Wiki-Seiten ge&auml;ndert",
"new articles" => "neue Artikel",
"new sites" => "Neue Links",
"new images" => "Neue Bilder",
"new files" => "Neue Dateien",
"Invalid username or password" => "Ung&uuml;ltiger Benutzername oder Pa&szlig;wort",
"Random Image" => "Zuf&auml;lliges Bild",
"List of attached files" => "Liste aller angeh&auml;ngten Dateien",
"id" => "ID",
"desc" => "Beschreibung",
"uploaded" => "hochgeladen",
"View" => "Betrachten",
"Download" => "Herunterladen",
"Delete" => "L&ouml;schen",
"Remove" => "Entfernen",
"Upload file" => "Datei hochladen",
"Attach" => "Anh&auml;ngen",
"Attach a file to this item" => "Datei an diesen Eintrag anh&auml;ngen",
"Attachments" => "Anh&auml;nge",
"No attachments for this item" => "Keine Anh&auml;nge f&uuml;r diesen Eintrag",
"debug" => "Debug",
"Fatal error" => "Fataler Fehler",
"Description:" => "Beschreibung:",
"Created by" => "Erstellt von",
" on " => " am ",
"Post" => "Eintrag",
"RSS feed" => "RSS Feed",
"Edit blog" => "Blog bearbeiten",
"Monitor this Blog" => "Diesen Blog beobachten",
"Stop Monitoring this Blog" => "Diesen Blog nicht mehr beobachten",
"Activity=" => "Aktivit&auml;t=",
"Watched by categories" => "Beobachtet durch die Kategorien",
"Actions" => "Aktionen",
"No records found" => "Keine Datens&auml;tze gefunden",
"Category" => "Kategorie",
"Categorize" => "Kategorisieren",
"Show Categories" => "Kategorien zeigen",
"Hide Categories" => "Kategorien verbergen",
"Hold down CTRL to select multiple categories" => "Zum Markieren mehrerer Kategorien STRG gedr&uuml;ckt halten",
"categorize this object" => "Dieses Objekt kategorisieren",
"Uncheck the above checkbox to uncategorize this page/object" => "Die Checkboxmarkierung l&ouml;schen um die Kategorien von dieser Seite/diesem Objekt zu entfernen",
"No categories defined" => "Keine Kategorien definiert",
"Admin Categories" => "Kategorien verwalten",
"Browse Category" => "Kategorien durchst&ouml;bern",
"on" => "am",
"stars" => "Sterne",
"User Level" => "Benutzerlevel",
"private message" => "private Nachricht",
"Send eMail to User" => "EMail an Benutzer schicken",
"user online" => "Benutzer online",
"user offline" => "Benutzer offline",
"Attachment" => "Anhang",
"Vote" => "Stimme",
"Reply" => "Antwort",
"Save to notepad" => "Im Notizblock speichern",
"Monitor this Topic" => "Thema beobachten",
"Stop Monitoring this Topic" => "Beobachtung dieses Themas beenden",
"Moderator actions" => "Moderator-Aktionen",
"reported:" => "gemeldet:",
"queued:" => "aufgelaufen:",
"Move to topic:" => "Verschiebe zu Thema:",
"Move" => "Verschieben",
"Delete Selected" => "Markierte l&ouml;schen",
"Messages" => "Nachrichten",
"Plain" => "flach",
"Headers Only" => "nur K&ouml;pfe",
"Sort" => "Sortieren",
"Newest first" => "Neueste zuerst",
"Oldest first" => "&Auml;lteste zuerst",
"Title (desc)" => "Titel (abst.)",
"Title (asc)" => "Titel (aufst.)",
"Threshold" => "Schwellenwert",
"Search" => "Suche",
"Set" => "Ok",
"Replies" => "Antworten",
"below your current threshold" => "unterhalb Ihres aktuellen Schwellenwerts",
"New Reply" => "Neue Antwort",
"Editing reply" => "Antwort bearbeiten",
"Preview" => "Vorschau",
"Post new message" => "Neuen Beitrag erstellen",
"Editing comment" => "Bearbeitungskommentar",
"Comment on the selected post" => "Diesen Beitrag kommentieren",
"Post new comment" => "Neuen Kommentar posten",
"Required" => "Erforderlich",
"Post new reply" => "Neue Anwort schreiben",
"Cancel" => "Abbrechen",
"Posting replies" => "Post-Antworten",
"Posting comments" => "Posting-Kommentare",
"Use" => "Benutze",
"or" => "oder",
"for links" => "f&uuml;r Links",
"HTML tags are not allowed inside posts" => "HTML-Tags sind in Posts nicht erlaubt",
"Go back" => "zur&uuml;ck",
"Return to home page" => "Zur Home-Seite zur&uuml;ckkehren",
"Type of contribution:" => "Art der Beteiligung:",
"Year" => "Jahr",
"Authors" => "Autoren",
"Add" => "Hinzuf&uuml;gen",
"Page generation debugging log" => "Debug-Log der Seitengenerierung",
"Features state" => "Status der Funktion",
"Total" => "Gesamt",
"features matched" => "Features gefunden",
"Watchlist" => "Beobachtungsliste",
"duplicate" => "Kopie",
"There are individual permissions set for this file gallery" => "F&uuml;r dieses Dateiarchiv sind individuelle Berechtigungen gesetzt",
"Save" => "Speichern",
"required field for podcasts" => "bei PodCasts erforderlich",
"any file" => "beliebige Dateien",
"podcast (audio)" => "PodCast (Audio)",
"podcast (video)" => "PodCast (Video)",
"Gallery is visible to non-admin users?" => "Galerie sichtbar f&uuml;r Nicht-Admins?",
"unlimited" => "unbegrenzt",
"none" => "nichts",
"Parent gallery" => "Mutter-Galerie",
"Owner of the gallery" => "Besitzer der Gallerie",
"Default sort order" => "Standard-Sortierreihenfolge",
"descending" => "absteigend",
"ascending" => "aufsteigend",
"Max description display size" => "Maximale Anzeigebreite der Beschreibung",
"Max Rows per page" => "Max. Zeilen pro Seite",
"Listing configuration" => "Listen-Konfiguration",
"Create this page" => "Diese Seite anlegen",
"Perms" => "Berecht.",
"Unlock" => "Entsperren",
"Lock" => "Sperren",
"Name-filename" => "Name-Dateiname",
"Filename only" => "nur Dateiname",
"Number of displayed rows" => "Angezeigte Spaltenanzahl",
"Perform action with checked:" => "Aktion auf alle markierten ausf&uuml;hren",
"Move Selected Files" => "Markierte Dateien verschieben",
"Move to" => "Verschieben nach",
"Filename" => "Dateiname",
"Hi {\$mail_user} has sent you this link:" => "Hallo, {\$mail_user} hat Ihnen diesen Link zugesandt:",
"Blog post:" => "Blog-Eintrag:",
"at:" => "auf:",
"Somebody or you tried to subscribe this email address at our site:" => "Sie oder jemand anders hat versucht, diese eMail-Adresse einzutragen bei:",
"To the newsletter:" => "Zum Newsletter:",
"In order to confirm your subscription you must access the following URL:" => "Zur Best&auml;tigung der Newsletter-Registrierung m&uuml;ssen Sie diesem Link folgen:",
"A new message was posted to forum" => "Ein neuer Beitrag wurde gepostet ins Forum",
"Tiki mail-in instructions" => "Tiki Mail-in Anweisungen",
"Page not found:" => "Seite nicht gefunden:",
"Hi," => "Hallo,",
"A new message was posted to you at {\$mail_machine}" => "Eine neue Nachricht f&uuml;r Sie auf {\$mail_machine}",
"From" => "Von",
"Subject" => "Betreff",
"Hi" => "Hallo",
"Enjoy the site!" => "Viel Spass auf der Site!",
"has requested an account on" => "hat einen Zugang beantragt f&uuml;r",
"To validate that account, please follow the link:" => "Zum Best&auml;tigen des Account-Antrags den folgenden Link klicken:",
"best regards" => "Gruss",
"your Tikiwiki" => "Ihr Tiki",
"Tiki User Registration Request" => "Anfrage Tiki Benutzerregistrierung",
"The user" => "Der Benutzer",
"registered at your site" => "hat sich auf Ihrer Tiki-Site registriert",
"New user registration" => "Neue User-Anmeldung",
"Bye bye!" => "Auf Wiedersehen!",
"This email address has been removed to the list of subscriptors of:" => "Diese eMail-Adresse wurde aus die Liste der Adressaten gel&ouml;scht von:",
"You can unsubscribe from this newsletter following this link" => "Abbestellen dieses Newsletters durch Klick auf den Link m&ouml;glich",
"Welcome to our newsletter!" => "Willkommen bei diesem Newsletter!",
"This email address has been added to the list of subscriptors of:" => "Diese eMail-Adresse wurde in die Liste der Adressaten aufgenommen von:",
"You can always cancel your subscription using:" => "Sie k&ouml;nnen die Newsletter-Registrierung jederzeit r&uuml;ckg&auml;ngig machen &uuml;ber:",
"Tiki email notification" => "Tiki eMail-Benachrichtigung",
"Since this is your registered email address we inform that the password for this account is" => "Da dies Ihre registrierte eMail-Adresse ist, informieren wir Sie dar&uuml;ber, dass das Passwort f&uuml;r diesen Account wie folgt lautet:",
"Your Tiki account information for %s" => "Ihre Tiki-Accountinformationen f&uuml;r %s",
"A new article was submitted by {\$mail_user} to {\$mail_site} at {\$mail_date|tiki_short_datetime}" => "Es wurde ein neuer Artikel von {\$mail_user} auf {\$mail_site} um {\$mail_date|tiki_short_datetime} erstellt",
"You can edit the submission following this link:" => "Sie k&ouml;nnen diesen Beitrag bearbeiten, wenn Sie hier klicken:",
"Title:" => "Titel:",
"Heading:" => "Kopfbereich:",
"Body:" => "Hauptteil:",
"you or someone registered this email address at" => "Sie oder jemand anderes hat Ihre eMail-Adresse bei",
"If you want to be a registered user in this site you will have to use the following link to login for the first time:" => "Falls Sie sich f&uuml;r diese Site registrieren m&ouml;chten, m&uuml;ssen Sie sich f&uuml;r das erste Login &uuml;ber diesen Link anmelden:",
"Your Tiki information registration" => "Ihre Tiki Registrierungsinformationen",
"You will receive an email with information to login for the first time into this site" => "Sie erhalten in K&uuml;rze eine Mail, die Informationen enthalten, wie Sie sich zum ersten mal anmelden.",
"Your account request have been stored and will be activated by the admin as soon as possible." => "Die Anfrage wurde gespeichert und wird vom Administrator schnellst m&ouml;glich bearbeitet.",
"New article post: {\$mail_title} by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Neuer Artikel erschienen: {\$mail_title} von {\$mail_user} am {\$mail_date|tiki_short_datetime}",
"View the article at:" => "Klicken Sie hier um zu dem Artikel zu gelangen:",
"If you don't want to receive these notifications follow this link:" => "Falls Sie diese Benachrichtigungen nicht mehr bekommen m�chten, klicken sie hier:",
"View the blog at:" => "Zeige den Blog auf:",
"A new category was created in" => "Eine neue Kategorie wurde erstellt in",
"created" => "erstellt",
"A category was removed in" => "Eine Kategorie wurde gel&ouml;scht in",
"Removed by" => "Gel&ouml;scht von",
"A category was updated" => "Eine Kategorie wurde aktualisiert",
"Updated by" => "Aktualisiert von",
"New" => "Neu",
"File Description" => "Dateibeschreibung",
"An object was added to category" => "Ein Objekt wurde hinzugef&uuml;gt zur Kategorie",
"Added by" => "Hinzugef&uuml;gt durch",
"Object" => "Objekt",
"Object type" => "Objekttyp",
"An object was removed from category" => "Ein Objekt wurde entfernt aus der Kategorie",
"The page {\$mail_page} was changed by {\$mail_user} at {\$mail_date|tiki_short_datetime}" => "Die Seite {\$mail_page} wurde von {\$mail_user} um {\$mail_date|tiki_short_datetime} ge&auml;ndert",
"Comment:" => "Kommentar:",
"You can view the page by following this link:" => "Sie k&ouml;nnen die Seite betrachten in dem Sie diesem Link folgen:",
"You can view a diff back to the previous version by following this link:" => "Sie k&ouml;nnen einen Blick auf die vorherige Version werfen, indem Sie diesem Link folgen:",
"The changes in this version follow below, followed after by the current full page text." => "Die &Auml;nderungen dieser Version folgen unten, gefolgt von dem aktuellen komplette Seiteninhalt.",
"-Lines: {\$oldd} changed to +Lines: {\$newd}" => "-Zeilen: {\$oldd} ge&auml;ndert zu +Zeilen: {\$newd}",
"The new page content follows below." => "Der neue Seiteninhalt folgt unten.",
"Wiki page %s changed" => "Die Wiki Seite %s wurde ge&auml;ndert",
"New name" => "Neuer Name",
"Scale" => "Skalieren",
"Query" => "Abfrage",
"Redraw" => "Neu zeichnen",
"Click on the map or click redraw" => "Karte oder 'Neu zeichnen' anklicken",
"Comments" => "Kommentare",
"Last modification date" => "Datum der letzten Modifikation",
"Overview" => "&Uuml;bersicht",
"Legend" => "Legende",
"Layer Manager" => "Layer-Manager",
"On" => "Am",
"Label" => "Beschriftung",
"Download Layer" => "Layer herunterladen",
"you have requested to download the layer:" => "Sie haben das Herunterladen des Layers angefordert:",
"Here are the files to download, do not forget to rename them:" => "Heie sind die herunterladbaren Dateien, bitte nicht vergessen, sie umzubenennen:",
"Mapfiles" => "Kartendateien",
"Mapfile" => "Kartendatei",
"Available mapfiles" => "Verf&uuml;gbare Kartendateien",
"monitor this map" => "diese Karte beobachten",
"Stop Monitoring this Map" => "Diese Karte nicht mehr beobachten",
"Create a new mapfile" => "Neue Kartendatei anlegen",
"Create" => "Erstellen",
"Mapfile listing" => "Liste Kartendateien",
"Reload" => "Aktualisieren",
"History" => "Historie",
"You can view this map in your browser using" => "Sie k&ouml;nnen diese Karte in Ihrem Browser betrachten",
"of" => "von",
"Compare" => "Vergleichen",
"Comparing version {\$old.version} with version {\$new.version}" => "Vergleiche Version {\$old.version} mit Version {\$new.version}",
"Current" => "Aktuell",
"Versions are identical" => "Versionen sind identisch",
"Legend:" => "Legende:",
"v=view" => "v=betrachten",
"Full side-by-side diff" => "Kompletter Side-By-Side Vergleich",
"Unified diff" => "Einheitlicher Vergleich",
"Side-by-side view" => "Side-By-Side Ansicht",
"User" => "Benutzer",
"Ip" => "IP",
"Action" => "Aktion",
"Directories" => "Links",
"Upload From Disk:" => "Von Platte hochladen:",
"Upload Files" => "Dateien hochladen",
"Bytes maximum" => "Bytes maximal",
"Create Directory:" => "Verzeichnis anlegen:",
"index file (.shp):" => "Index-Datei (.shp):",
"files to index (regexp):" => "zu indizierende Dateien (regexp):",
"Message Archive" => "Nachrichten-Archiv",
"Edit template" => "Vorlage bearbeiten",
"messages" => "Nachrichten",
"Archive is full!" => "Archiv ist voll!",
"Unread" => "Ungelesen",
"Flagged" => "Gekennzeichnet",
"Unflagged" => "Nicht gekennzeichnet",
"Containing" => "die enthalten",
"Sender" => "Absender",
"No messages to display" => "Keine Nachrichten anzuzeigen",
"Broadcast message" => "Nachricht an Verteiler",
"Group" => "Gruppe",
"All users" => "Alle Benutzer",
"Lowest" => "sehr niedrig",
"Low" => "niedrig",
"Normal" => "normal",
"High" => "hoch",
"Very High" => "sehr hoch",
"Send" => "Verschicken",
"Compose message" => "Nachricht erstellen",
"Compose Message" => "Nachricht erstellen",
"Invalid" => "Ung&uuml;ltig",
"To" => "An",
"Mailbox is full! Delete or archive some messages if you want to receive more messages." => "Mailbox ist voll! Bitte ein paar Nachrichten archivieren oder l&ouml;schen, damit weitere empfangen werden k&ouml;nnen.",
"is reply to" => "ist Antwort auf",
"Find replied message" => "suche beantwortete Nachricht",
"Archive" => "Archiv",
"Mark as read" => "auf gelesen ...",
"Mark as unread" => "auf ungelesen ...",
"Mark as flagged" => "Kennzeichnung nicht ...",
"Mark as unflagged" => "Kennzeichnung ...",
"Mark" => "setzen",
"Mailbox" => "Briefkasten",
"Compose" => "Erstellen",
"Broadcast" => "Verteiler",
"Sent" => "Ausgang",
"Auto-archive age for read messages:" => "Mindestalter gelesener Nachrichten f&uuml;r Auto-Archivierung:",
"Read message" => "Nachricht lesen",
"Return to mailbox" => "zur&uuml;ck zum Briefkasten",
"replyall" => "allen antworten",
"Flag this message" => "Nachricht kennzeichnen",
"Return to archive" => "Zur&uuml;ck zum Archiv",
"Return to outbox" => "Zur&uuml;ck zum Ausgang",
"Sent Messages" => "Ausgegangene Nachrichten",
"Replied" => "Beantwortet",
"Not replied" => "Nicht beantwortet",
"move to archive" => "archivieren",
"receiver" => "Empf&auml;nger",
"No" => "Nein",
"Move module up" => "Modul nach oben verschieben",
"Up" => "Rauf",
"Move module down" => "Modul nach unten verschieben",
"Down" => "Runter",
"Move module to opposite side" => "Modul zur anderen Seite verschieben",
"Admin Menu" => "Men&uuml; verwalten",
"Live support" => "Onlinesupport",
"Banning" => "Benutzer aussperren",
"Users" => "Benutzer",
"Groups" => "Gruppen",
"Modules" => "Module",
"RSS modules" => "RSS-Module",
"Menus" => "Men&uuml;s",
"Polls" => "Abstimmungen",
"Mail notifications" => "eMail-Benachrichtigungen",
"Search stats" => "Such-Statistik",
"Categories" => "Kategorien",
"Banners" => "Banner",
"Edit templates" => "Vorlagen bearbeiten",
"Admin drawings" => "Zeichnungen verwalten",
"Dynamic content" => "Dynamischer Inhalt",
"Content templates" => "Inhaltsvorlagen",
"HTML pages" => "HTML-Seiten",
"Referer stats" => "Referer-Statistik",
"Import PHPWiki Dump" => "PHPWiki Dump importieren",
"phpinfo" => "PHPInfo",
"Admin dsn" => "DSN verwalten",
"External wikis" => "Externe Wikis",
"System Admin" => "System Verwaltung",
"Security Admin" => "Sicherheit",
"Syntax highlighting" => "Syntax-Highlighting",
"You forgot your Google ad_client number !" => "Es wurde keine Google ad_client Nummer angegeben!",
"Menu" => "Men&uuml;",
"Contact us" => "Kontaktiere uns",
"Stats" => "Statistiken",
"Games" => "Spiele",
"MyMenu" => "Mein Men&uuml;",
"MyTiki" => "Mein Tiki",
"MyTiki home" => "Mein Tiki-Startseite",
"Preferences" => "Einstellungen",
"Tasks" => "Aufgaben",
"Bookmarks" => "Lesezeichen",
"Notepad" => "Notizblock",
"My files" => "Meine Dateien",
"User menu" => "Benutzer-Men&uuml;",
"Mini calendar" => "Mini-Kalender",
"My watches" => "Meine Beobachtungspunkte",
"Admin processes" => "Prozesse verwalten",
"Monitor processes" => "Prozesse &uuml;berwachen",
"Monitor activities" => "Aktivit&auml;ten &uuml;berwachen",
"Monitor instances" => "Instanzen &uuml;berwachen",
"User processes" => "Benutzer-Prozesse",
"User activities" => "Benutzer-Aktivit&auml;ten",
"User instances" => "Benutzer-Instanzen",
"User list" => "Benutzerliste",
"Friendship Network" => "Freundschafts-Netzwerk",
"Last changes" => "Neueste &Auml;nderungen",
"Dump" => "Datenbankabzug",
"Rankings" => "Bewertungen",
"List pages" => "Seiten auflisten",
"Orphan pages" => "Verwaiste Seiten",
"Print" => "Drucken",
"Send pages" => "Seiten verschicken",
"Received pages" => "Erhaltene Seiten",
"Structures" => "Strukturen",
"Image Galleries" => "Bildergalerien",
"Galleries" => "Galerien",
"Upload image" => "Bild hochladen",
"System gallery" => "Systemgalerie",
"Articles home" => "Artikel-Home",
"Submit article" => "Artikel einreichen",
"View submissions" => "Einreichungen ansehen",
"Send articles" => "Artikel senden",
"Received articles" => "Empfangene Artikel",
"Admin topics" => "Themen verwalten",
"Admin types" => "Typen verwalten",
"List blogs" => "Blogs auflisten",
"Create/Edit blog" => "Blog hinzuf&uuml;gen/bearbeiten",
"Admin posts" => "Eintr&auml;ge verwalten",
"List forums" => "Foren auflisten",
"Admin forums" => "Foren verwalten",
"Submit a new link" => "Neuen Link eintragen",
"Browse directory" => "Verzeichnis durchst&ouml;bern",
"Admin directory" => "Linkverzeichnis verwalten",
"File Galleries" => "Dateiarchive",
"List galleries" => "Galerien auflisten",
"List FAQs" => "FAQs auflisten",
"Admin FAQs" => "FAQs verwalten",
"Maps" => "Karten",
"Layer management" => "Layer Management",
"List quizzes" => "Quiz auflisten",
"Quiz stats" => "Quiz-Statistik",
"Admin quiz" => "Quiz verwalten",
"List trackers" => "Tracker auflisten",
"Admin trackers" => "Tracker verwalten",
"Surveys" => "Umfragen",
"List surveys" => "Umfragen auflisten",
"Admin surveys" => "Umfragen verwalten",
"Newsletters" => "Newsletter",
"Send newsletters" => "Newsletter versenden",
"Admin newsletters" => "Newsletter verwalten",
"Events" => "Ereignisse",
"Ephemerides" => "Terminkalender",
"Ephemerides Admin" => "Terminkalender verwalten",
"Charts Admin" => "Hitlisten verwalten",
"Admin home" => "Verwaltung Hauptseite",
"Debugger console" => "Debug-Konsole",
"Theme control" => "Theme-Konfiguration",
"Drawings" => "Zeichnungen",
"Edit languages" => "Sprachen bearbeiten",
"Mods Admin" => "MODs verwalten",
"UsrMenu" => "Benutzer-Men&uuml;",
"Click here to manage your personal menu" => "Klicken Sie hier zum &Auml;dern ihres pers&ouml;nlichen Men&uuml;s",
"User Menu" => "Benutzer-Men&uuml;",
"Tikiwiki Assistant" => "Tiki Assistent",
"Thank you for installing Tikiwiki" => "Vielen Dank f&uuml;r die Nutzung von Tiki",
"Select" => "Ausw&auml;hlen",
"Admin Modules" => "Module verwalten",
"Admin Menus" => "Men&uuml;s verwalten",
"login" => "Anmeldung",
"Recently visited pages" => "Zuletzt besuchte Seiten",
"January" => "Januar",
"February" => "Februar",
"March" => "M&auml;rz",
"May" => "Mai",
"June" => "Juni",
"July" => "Juli",
"October" => "Oktober",
"December" => "Dezember",
"Monday" => "Montag",
"Tuesday" => "Dienstag",
"Wednesday" => "Mittwoch",
"Thursday" => "Donnerstag",
"Friday" => "Freitag",
"Saturday" => "Samstag",
"Sunday" => "Sonntag",
"Today" => "Heute",
"Received objects" => "Empfangene Objekte",
"Pages:" => "Seiten:",
"Last `\$module_rows` Sites" => "Die letzten `\$module_rows` Links",
"Last Sites" => "Neueste Links",
"Directory Stats" => "Verzeichnis-Statistik",
"Sites" => "Links",
"Sites to validate" => "Zu &uuml;berpr&uuml;fende Links",
"Searches" => "Suchanfragen",
"Visited links" => "Besuchte Links",
"Top \$module_rows Sites" => "Die \$module_rows Top-Links",
"Top Sites" => "Beliebteste Links",
"Current events" => "Aktuelle Termine",
"Featured links" => "Linktips",
"Top topics" => "Top Themen",
"Last `\$module_rows` forum posts" => "`\$module_rows` neueste Forenbeitr&auml;ge",
"Last forum posts" => "Neueste Forenbeitr&auml;ge",
"Last `\$module_rows` forum topics" => "Die letzten `\$module_rows` Forenthemen",
"Last forum topics" => "Neueste Forenthemen",
"Most commented forums" => "Meistkommentierte Foren",
"Most read topics" => "Meistgelesene Themen",
"Most visited forums" => "Meistbesuchte Foren",
"Google Search" => "Google-Suche",
"Last `\$module_rows` actions" => "Letzte `\$module_rows` Aktionen",
"Last actions" => "Letzte Aktionen",
"Last `\$module_rows` articles" => "Die letzten `\$module_rows` Artikel",
"Last articles" => "Neueste Beitr&auml;ge",
"Last `\$module_rows` blog posts" => "Die letzten `\$module_rows` Blog-Eintr&auml;ge",
"Last blog posts" => "Neueste Blog-Eintr&auml;ge",
"Last" => "letzte",
"Last `\$module_rows` Created blogs" => "Die letzten `\$module_rows` angelegten Blogs",
"Last Created blogs" => "Neueste Blogs",
"Last `\$module_rows` Created FAQs" => "Die letzten `\$module_rows` angelegten FAQs",
"Last Created FAQs" => "Neueste FAQs",
"Last `\$module_rows` Created Quizzes" => "Die letzten `\$module_rows` angelegte Quiz",
"Last Created Quizzes" => "Neueste Quiz",
"Last `\$module_rows` modified file galleries" => "Die letzten `\$module_rows` ge&auml;nderten Dateiarchive",
"Last modified file galleries" => "Zuletzt modifizierte Dateiarchive",
"Last `\$module_rows` Files" => "Die letzten `\$module_rows` Dateien",
"Last Files" => "Neueste Dateien",
"Last `\$module_rows` galleries" => "Die letzten `\$module_rows` Galerien",
"Last galleries" => "Neueste Galerien",
"Last Images" => "Neueste Bilder",
"Last modifed events" => "Neueste Termine",
"Last `\$module_rows` changes" => "Die letzten `\$module_rows` &Auml;nderungen",
"Last `\$module_rows` Modified Items" => "Die letzten `\$module_rows` ge&auml;nderten Eintr&auml;ge",
"Last Modified Items" => "Zuletzt ge&auml;nderte Eintr&auml;ge",
"Last `\$module_rows` Modified blogs" => "Die letzten `\$module_rows` ge&auml;nderten Blogs",
"Last Modified blogs" => "Zuletzt ge&auml;nderte Blogs",
"Last `\$module_rows` submissions" => "Die letzten `\$module_rows` Einreichungen",
"Last submissions" => "Neueste Einreichungen",
"Last `\$module_rows` Items" => "Die letzten `\$module_rows` Eintr&auml;ge",
"Last Items" => "Neueste Eintr&auml;ge",
"Last Visitors" => "Letzte Besucher",
"Register" => "Registrieren",
"Open operator console" => "Operatorkonsole &ouml;ffnen",
"Online users" => "Benutzer online",
"We have" => "Wir haben",
"online users" => "Benutzer online",
"Logout" => "Abmelden",
"Paramaters" => "Parameter",
"Login as admin" => "Als Admin anmelden",
"Email" => "eMail",
"eMail" => "EMail",
"Password" => "Pa&szlig;wort",
"Remember me" => "Merken",
"I forgot my pass" => "Ich habe mein Pa&szlig;wort vergessen",
"I forgot my password" => "Ich habe mein Pa&szlig;wort vergessen",
"Secure" => "Sicher",
"Stay in ssl Mode" => "In SSL-Modus bleiben",
"You have" => "Du hast",
"New Messages" => "Neue Nachrichten",
"New Message" => "Neue Nachricht",
"You have 0 new messages" => "Sie haben keine neuen Nachrichten",
"Waiting Submissions" => "Wartende Einreichungen",
"submissions waiting to be examined" => "Einreichungen, die auf Sichtung warten",
"Old articles" => "Alte Artikel",
"Send a message to" => "Schicke eine Nachricht an",
"Random Pages" => "Zuf&auml;llige Seiten",
"Register as a new user" => "Als neuer Benutzer registrieren",
"Your registration code:" => "Ihr Registrierungscode:",
"Username" => "Benutzername",
"Passcode to register (not your user password)" => "Passcode zum Registrieren (nicht Ihr Benutzerpa&szlig;wort)",
"Registration code" => "Registrierungscode",
"Repeat password" => "Pa&szlig;wort wiederholen",
"Generate a password" => "Pa&szlig;wort vorschlagen",
"Articles RSS" => "Artikel RSS",
"Image Galleries RSS" => "Bilder-Galerien RSS",
"File Galleries RSS" => "Datei-Archive RSS",
"Forums RSS" => "Foren RSS",
"Maps RSS" => "Karten RSS",
"Entire Site" => "Ganze Site",
"Wiki Pages" => "Wiki-Seiten",
"Image Gals" => "Bildergalerien",
"Images" => "Bilder",
"Blog Posts" => "Blog-Eintr&auml;ge",
"Search Wiki PageName" => "Suche Wiki-Seitennamen",
"Read More" => "Weiterlesen",
"Since your last visit on" => "Letzter Besuch",
"New Images" => "Neue Bilder",
"Wiki Pages Changed" => "Wiki-Seiten ge&auml;ndert",
"New Files" => "Neue Dateien",
"New Comments" => "Neue Kommentare",
"New Users" => "Neue Benutzer",
"click to edit" => "Bearbeiten mit Klick",
"Most Active blogs" => "Aktivste Blogs",
"Top `\$module_rows` articles" => "Die `\$module_rows` Top-Artikel",
"Top articles" => "Top Artikel",
"Top `\$module_rows` File Galleries" => "Die `\$module_rows` Top-Dateiarchive",
"Top File Galleries" => "Top-Dateiarchive",
"Top `\$module_rows` files" => "Die `\$module_rows` Top-Dateien",
"Top files" => "Top-Dateien",
"Top `\$module_rows` games" => "Die `\$module_rows` Top-Spiele",
"Top games" => "Top-Spiele",
"Top `\$module_rows` galleries" => "Die `\$module_rows` Top-Galerien",
"Top galleries" => "Top Galerien",
"Top `\$module_rows` Images" => "Die `\$module_rows` Top-Bilder",
"Top Images" => "Top-Bilder",
"Top `\$module_rows` Pages" => "Die `\$module_rows` Top-Seiten",
"Top Pages" => "Top-Seiten",
"Top `\$module_rows` Quizzes" => "Die `\$module_rows` Top-Quiz",
"Top Quizzes" => "Top-Quiz",
"Most `\$module_rows` visited blogs" => "Die `\$module_rows` meistbesuchten Blogs",
"Top `\$module_rows` Visited FAQs" => "Die `\$module_rows` meistbesuchten FAQs",
"Top Visited FAQs" => "Meistbesuchte FAQs",
"view" => "betrachten",
"My blogs" => "Meine Blogs",
"My galleries" => "Meine Galerien",
"My Pages" => "Meine Seiten",
"User tasks" => "Benutzer-Aufgaben",
"Done" => "fertig",
"Del" => "L&ouml;schen",
"User informations" => "Benutzer-Infos",
"Group informations" => "Gruppen-Infos",
"Whats related" => "Verwandte Objekte",
"online user" => "Benutzer online",
"Last `\$module_rows` wiki comments" => "Die letzten `\$module_rows` Wiki-Kommentare",
"Last wiki comments" => "Die letzten Wiki-Kommentare",
"Real Name" => "Tats&auml;chlicher Name",
"vote" => "Abstimmen",
"Structures:" => "Strukturen:",
"show structures" => "Strukturen anzeigen",
"hide structures" => "Strukturen ausblenden",
"Manage structures" => "Strukturen verwalten",
"Execution time" => "Ausf&uuml;hrungszeit",
"Memory usage" => "Speicherverbrauch",
"database queries used" => "durchgef&uuml;hrte Datenbankabfragen",
"Server load" => "Serverlast",
"Locked" => "Gesperrt",
"page id" => "Seiten-ID",
"Cached" => "gecached",
"3d browser" => "3D-Browser",
"Refresh" => "Aktualisieren",
"Monitor this Page" => "Diese Seite beobachten",
"Stop Monitoring this Page" => "Diese Seite nicht mehr beobachten",
"Previous page" => "Vorherige Seite",
"Next page" => "N&auml;chste Seite",
"Child" => "neue Sub-Seite",
"Add Page" => "Seite hinzuf&uuml;gen",
"First page" => "Erste Seite",
"page" => "Seite",
"Last page" => "Letzte Seite",
"Page last modified on" => "Seite zuletzt ge&auml;ndert am",
"Contributors to this page" => "Zu dieser Seite haben beigesteuert",
"To edit the copyright notices" => "Zum Editieren der Copyright-Hinweise",
"Click Here" => "Hier klicken",
"The content on this page is licensed under the terms of the" => "Der Inhalt dieser Seite unterliegt folgenden Lizenzbestimmungen:",
"The original document is available at" => "Das Originaldokument ist zu finden unter",
"Made with" => "Erstellt mit",
"powered by" => "Powered by",
"on:" => "Am:",
"Translation" => "&Uuml;bersetzung",
"Article image" => "Artikellogo",
"Topic image" => "Themenlogo",
"Source" => "Quelle",
"Add Comment" => "Kommentieren",
"1 comment" => "1 Kommentar",
"comments" => "Kommentare",
"close" => "schlie&szlig;",
"Rename" => "Umbenennen",
"Similar" => "&auml;hnlich",
"Undo" => "R&uuml;ckg&auml;ngig",
"Slides" => "Dias",
"Export" => "Exportieren",
"Discuss" => "Diskutieren",
"Attach File" => "Datei anh&auml;ngen",
"1 File Attached" => "1 angeh&auml;ngte Datei",
"{\$atts_cnt} files attached" => "{\$atts_cnt} angeh&auml;ngte Dateien",
"Last Modification" => "Letzte &Auml;nderung",
"logged as" => "angemeldet",
"pass" => "Pa&szlig;wort",
"Page generated in" => "Seite erzeugt in",
"The newsletter was sent to {\$sent} email addresses" => "Der Newsletter wurde an {\$sent} eMail-Adressen verschickt",
"This newsletter will be sent to {\$subscribers} email addresses." => "Der Newsletter wird an {\$subscribers} eMail-Adressen verschickt.",
"Prepare a newsletter to be sent" => "Newsletter auf Versand vorbereiten",
"Apply template" => "Vorlage anwenden",
"Data" => "Daten",
"Send Newsletters" => "Newsletter versenden",
"Sent editions" => "Gesendete Ausgaben",
"sent" => "Gesendet",
"User List" => "Benutzerliste",
"Homework" => "Hausaufgaben",
"Assignments" => "Aufgaben",
"Last Changes" => "Neueste &Auml;nderungen",
"Edit article" => "Artikel erstellen/bearbeiten",
"User files" => "Benutzer-Dateien",
"Favorites" => "Favoriten",
"Watches" => "Beobachtungspunkte",
"home" => "Hauptseite",
"chat" => "Chat",
"contact us" => "Kontaktiere uns",
"Member list" => "Mitgliederliste",
"dump" => "Datenbankabzug",
"rankings" => "Bewertungen",
"List Pages" => "Seiten auflisten",
"orphan pages" => "Verwaiste Seiten",
"sandbox" => "Sandbox",
"received pages" => "Empfangene Seiten",
"structures" => "Strukturen",
"Articles Home" => "Artikel Hauptseite",
"Create/Edit Blog" => "Blog hinzuf&uuml;gen/bearbeiten",
"Browse Directory" => "Verzeichnis durchst&ouml;bern",
"List Quizzes" => "Quiz auflisten",
"List Trackers" => "Tracker auflisten",
"List Surveys" => "Umfragen auflisten",
"Back to Homepage" => "Zur&uuml;ck zur Startseite",
"This page is being edited by" => "Diese Seite wird gerade bearbeitet von",
"Proceed at your own peril" => "Weiter auf eigene Gefahr",
"The SandBox is a page where you can practice your editing skills, use the preview feature to preview the appearance of the page, no versions are stored for this page." => "Die SandBox ist eine Seite, an der Sie Ihre Editierf&auml;higkeiten &uuml;ben k&ouml;nnen. Benutzen Sie die Vorschau-Funktion, um sich das Resultat Ihrer Seite anzusehen. Keine Version dieser Seite wird gespeichert.",
"My Footnotes" => "Fu&szlig;noten",
"Edit Summary" => "Zusammenfassung bearbeiten",
"Year:" => "Jahr:",
"Authors:" => "Autoren:",
"Allow HTML" => "HTML erlauben",
"Spellcheck" => "Rechtschreibpr&uuml;fung",
"Import page" => "Seite importieren",
"export all versions" => "alle Versionen exportieren",
"Upload picture" => "Bild hochladen",
"no cache" => "kein Cache",
"minute" => "Minute",
"License" => "Lizenz",
"Important" => "Wichtig",
"Minor" => "geringf&uuml;gig",
"Cancel Edit" => "Bearbeitung verwerfen",
"left/right" => "links/rechts",
"Unassign module" => "Modul wegnehmen",
"debugger console" => "Debug-Konsole",
"Mini Calendar" => "Mini-Kalender",
"Edit mapfiles" => "Kartendateien bearbeiten",
"Quick edit a Wiki page" => "Schnellbearbeitung einer Wiki-Seite",
"Language: " => "Sprache: ",
"Language" => "Sprache",
"Edit Post" => "Eintrag bearbeiten",
"Use wysiwyg editor" => "WYSIWYG Editor benutzen",
"Use normal editor" => "Standardeditor benutzen",
"View Blog" => "Blog betrachten",
"List Blogs" => "Blogs auflisten",
"Use ...page... to separate pages in a multi-page post" => "Benutze ...page... um den Eintrag in mehrere Seiten zu untergliedern",
"Upload image for this post" => "Bild f&uuml;r diesen Beitrag hochladen",
"Trash" => "M&uuml;ll",
"Mark entry as private:" => "Eintrag als privat kennzeichnen:",
"Send trackback pings to:" => "Trackback pings senden an:",
"(comma separated list of URIs)" => "(kommagetrennte URI-Liste)",
"Save and Exit" => "Speichern und verlassen",
"This is" => "Dies ist",
"by the" => "von der",
"Tiki community" => "Tiki Community",
"Find:" => "Suche:",
"Sort posts by:" => "Eintr&auml;ge sortieren nach:",
"read more" => "mehr lesen",
"pages" => "Seiten",
"View Comments" => "Kommentare ansehen",
"Email This Post" => "Diesen Beitrag verschicken",
"Viewing blog post" => "Betrachte Blog-Eintrag",
"Return to blog" => "Zur&uuml;ck zum Blog",
"Blog name" => "Blog Name",
"Enlarge area height" => "H&ouml;he vergr&ouml;&szlig;ern",
"Reduce area height" => "H&ouml;he verringern",
"Calendar View" => "Kalenderansicht",
"List View" => "Listenansicht",
"Tools Calendars" => "Kalendereintr&auml;ge",
"Check / Uncheck All" => "Alle (ent)markieren",
"Site Ads and Banners" => "Site Werbung und Banner",
"Activate" => "Aktivieren",
"Content" => "Inhalt",
"Publish" => "Ver&ouml;ffentlichen",
"General" => "Allgemein",
"Features" => "Funktionen",
"Meta Tags" => "Meta-Tags",
"Wysiwyg editor" => "WYSIWYG Editor",
"Module" => "Modul",
"To add/remove blogs, go to \"Create/Edit blog\" under \"Blogs\" on the application menu, or" => "Blogs hinzuf&uuml;gen/l&ouml;schen &uuml;ber Men&uuml;punkt 'Blogs' im Men&uuml; im Seitenbalken oder",
"Home Blog" => "Home-Blog",
"Home Blog (main blog)" => "Home-Blog (Haupt-Blog)",
"Blog features" => "Blog-Funktionen",
"Blog level comments" => "Kommentare auf Blog-Ebene",
"Post level comments" => "Kommentare auf Blogeintrag-Ebene",
"Post level trackback pings" => "Trackback Pings auf Blogeintrag-Ebene",
"Spellchecking" => "Rechtschreibpr&uuml;fung",
"Default ordering for blog listing" => "Standardsortierung f&uuml;r Blog-Listen",
"Creation date (desc)" => "Erstellungsdatum (abst.)",
"Last modification date (desc)" => "Datum letzte &Auml;nderung (abst.)",
"Blog title (asc)" => "Blog-Titel (aufst.)",
"Number of posts (desc)" => "Anzahl Posts (abst.)",
"Visits (desc)" => "Besuchszahlen (abst.)",
"Activity (desc)" => "Aktivit&auml;t (abst.)",
"Change preferences" => "Einstellungen &uuml;bernehmen",
"Blog listing configuration (when listing available blogs)" => "Einstellungen Blog-Liste (f&uuml;r Liste der verf&uuml;gbaren Blogs)",
"Creation date" => "Erstelldatum",
"Last modification time" => "&Auml;nderungszeit",
"Disabled" => "deaktiviert",
"Plain text" => "Klartext",
"Link to user information" => "Link auf Benutzer-Informationen",
"User avatar" => "Benutzer Avatar",
"Blog comments settings" => "Blog-Kommentareinstellungen",
"Default number of comments per page" => "Standardanzahl von Kommentaren pro Seite",
"Comments default ordering" => "Standardsortierung f&uuml;r Kommentare",
"Points" => "Punkte",
"Group calendar sticky popup" => "Sticky PopUp f&uuml;r Gruppenkalender",
"Group calendar item view tab" => "Elementanzeigespalte f&uuml;r Gruppenkalender",
"Default view mode" => "Standardansicht",
"Day" => "Tag",
"Week" => "Woche",
"Month" => "Monat",
"Calendar manual selection of time/date" => "manuelle Auswahl von Zeit/Datum im Kalender",
"5 minutes" => "5 Minuten",
"Change settings" => "Einstellungen &uuml;bernehmen",
"Show Category Path" => "Kategorie-Pfad zeigen",
"Show Category Objects" => "Kategorie-Objekte anzeigen",
"Ignore category viewing restrictions" => "Kategorie-Sichteinschr&auml;ngkungen ignorieren",
"Look under \"Articles\" on the application menu for links to" => "Unter Men&uuml;punkt 'Artikel' im Seitenbalken kann man",
"CMS features" => "Artikel-Funktionen",
"Submissions" => "Einreichungen",
"Use templates" => "Vorlagen benutzen",
"Print article" => "Artikel drucken",
"Settings for page articles home" => "Einstellungen f&uuml;r die Artikel-Startseite",
"Maximum number of articles in home" => "Maximale Anzahl von Artikeln auf der Artikel-Startseite",
"Topic" => "Thema",
"Article comments settings" => "Artikelkommentareinstellungen",
"Fields to display on page" => "Folgende Felder anzeigen auf der Seite",
"Publish Date" => "Ver&ouml;ffentlichungsdatum",
"Expire Date" => "Ablaufdatum",
"Visible" => "Sichtbar",
"Img" => "Bild",
"Import CSV file" => "CSV-Datei importieren",
"Import" => "Importieren",
"User identity features" => "Benutzeridentit&auml;ts-Einstellungen",
"Show user's info on mouseover" => "Benutzer-Info bei Mouseover anzeigen",
"Picture" => "Bild",
"Number of friends" => "Anzahl der Freunde",
"E-mail" => "eMail",
"Last login" => "Letzte Anmeldung",
"Distance" => "Distanz",
"Set features" => "Einstellungen &uuml;bernehmen",
"License Page" => "Lizenzseite",
"Submit Notice" => "Nachricht einstellen",
"To configure your directory, find \"Admin directory\" under \"Directory\" on the application menu, or" => "Verzeichnisse konfigurieren &uuml;ber Men&uuml; 'Verzeichnisse verwalten' unter 'Linkverzeichnis' im Seitenbalken oder",
"Number of columns per page when listing categories" => "Spalten pro Seite in Kategorienliste",
"Links per page" => "Links pro Seite",
"Validate URLs" => "URLs &uuml;berpr&uuml;fen",
"enable cool sites" => "'Coole Links' aktivieren",
"Method to open directory links" => "Art und Weise Links zu &ouml;ffnen",
"replace current window" => "Fenster ersetzen",
"New Window" => "Neues Fenster",
"inline frame" => "Frame innerhalb der Seite",
"To add/remove FAQs, look for \"Admin FAQs\" under \"FAQs\" on the application menu, or" => "FAQs hinzuf&uuml;gen/l&ouml;schen &uuml;ber Men&uuml;punkt 'FAQs auflisten' unter 'FAQs' im Men&uuml; im Seitenbalken oder",
"Action Log" => "Aktionslog",
"Action log setting" => "Action Log Einstellungen",
"Live Support" => "Onlinesupport",
"Live support system" => "Onlinesupport-System",
"XMLRPC API" => "XMLRPC-API",
"PhpLayers Dynamic menus" => "Dynamische PHPLayer Men&uuml;s",
"Workflow engine" => "Workflow Engine",
"Mobile" => "Tiki Mobil",
"Morcego 3D browser" => "Morcego-3D-Browser",
"Content Features" => "Inhalts-Einstellungen",
"Edit Templates" => "Vorlagen bearbeiten",
"Hotwords in New Windows" => "Hotwords in neuem Fenster",
"Custom Home" => "Angepasstes Home",
"HTML Pages" => "HTML-Seiten",
"Dynamic Content System" => "Dynamischer Inhalt",
"Administration Features" => "Administrative Einstellungen",
"Banning System" => "Benutzer-Sperrsystem",
"Banning system" => "Benutzer-Sperrsystem",
"Debugger Console" => "Debug-Konsole",
"Referer Stats" => "Referer-Statistik",
"Contact Us" => "Kontaktiere uns",
"Contact Us (Anonymous)" => "Kontaktiere uns (anonym)",
"Redirect On Error" => "Bei Fehler wiederverbinden",
"Communications (send/receive objects)" => "Kommunikation (Objekte senden/empfangen)",
"User Features" => "Benutzer-Einstellungen",
"User Preferences Screen" => "Benutzer-Einstellungsseite",
"User Notepad" => "Benutzer-Notizblock",
"User Bookmarks" => "Benutzer-Lesezeichen",
"User Watches" => "Benutzer Beobachtungspunkte",
"User Watches Translations" => "Beobachtungspunkte beobachten auch &Uuml;bersetzungen",
"User Tasks" => "Benutzer-Aufgaben",
"User Messages" => "Benutzer-Nachrichten",
"User Files" => "Benutzer-Dateien",
"To add/remove file galleries, go to \"File Galleries\" on the application menu, or" => "Dateiarchive hinzuf&uuml;gen/l&ouml;schen &uuml;ber Men&uuml;punkt 'Dateiarchive' im Men&uuml; im Seitenbalken oder",
"If you decide to store files in a directory you must ensure that the user cannot access directly to the directory." => "Wenn Dateien in einem Verzeichnis (statt in der Datenbank) gespeichert werden sollen, sollte das Verzeichnis nicht direkt zugreifbar sein.",
"You have two options to accomplish this:<br /><ul><li>Use a directory outside your document root, make sure your php script can read and write to that directory</li><li>Use a directory inside the document root and use .htaccess to prevent the user from listing the directory contents</li></ul>" => "Daf&uuml;r gibt es zwei M&ouml;glichkeiten:<br /><ul><li>Das Verzeichnis liegt au&szlig;erhalb des Document-Roots. Achtung: evtl. mu&szlig; es dann noch f&uuml;r PHP lesbar gemacht werden.</li><li>Das Verzeichnis liegt im Document-Root. Achtung: es sollte dann &uuml;ber eine .htaccess Datei gesch&uuml;tzt werden.</li></ul>",
"To configure the directory path use UNIX like paths for example files/ or c:/foo/files or /www/files/" => "Das Verzeichnis sollte in Unix-Notation angegeben werden, z.B. files/ oder c:/foo/files oder /www/files/",
"Home Gallery" => "Hauptarchiv",
"Home Gallery (main gallery)" => "Home-Galerie (Hauptgalerie)",
"Galleries features" => "Galerieeigenschaften",
"Allow same file to be uploaded more than once" => "Selbe Datei darf mehrfach hochgeladen werden",
"Never" => "Nie",
"Use database to store files" => "Datenbank zum Speichern von Dateien benutzen",
"Use a directory to store files" => "Ein Verzeichnis zur Dateiablage benutzen",
"Directory path" => "Verzeichnis",
"Directory Batch Loading" => "Aus Verzeichnis einlesen",
"Enable directory batch loading" => "Batch-Upload aus Verzeichnis erlauben",
"Batch loading directory" => "Batch-Upload Verzeichnis",
"Uploaded filenames must match regex" => "Hochgeladene Dateinamen m&uuml;ssen diese RegEx erf&uuml;llen",
"Uploaded filenames cannot match regex" => "Hochgeladene Dateinamen d&uuml;rfen dieser RegEx nicht entsprechen",
"Gallery listing configuration" => "Einstellungen Galerie-Liste",
"Change configuration" => "Einstellungen &uuml;bernehmen",
"File galleries comments settings" => "Dateiarchiv-Kommentareinstellungen",
"File galleries search indexing" => "Dateiarchiv Suchindex",
"Leave command blank to delete handler" => "'Systembefehl' leer lassen, damit keine Aktion ausgef&uuml;hrt wird.",
"Use %1 for where internal file name should be substituted (example: \"strings %1\" to convert the document to text using the unix strings command)" => "Platzhalter %1 benutzen, wo der Dateiname eingesetzt werden soll (Beispiel: 'strings %1' benutzen um das Dokument &uuml;ber den Unix-Befehl strings in reinen Text zu konvertieren.)",
"Enable auto indexing on file upload or change" => "Indizierung bei Dateiupload oder &Auml;nderung automatisch aktivieren",
"System command" => "Systembefehl",
"Reindex all files for search" => "Dateien f&uuml;r Suche neu indizieren",
"To add/remove forums, look for \"Admin forums\" under \"Forums\" on the application menu, or" => "Foren hinzuf&uuml;gen/l&ouml;schen &uuml;ber Men&uuml;punkt 'Foren verwalten' im Men&uuml; im Seitenbalken oder",
"Home Forum" => "Hauptforum",
"Home Forum (main forum)" => "Home-Forum (Hauptforum)",
"Forums features" => "Foren-Einstellungen",
"Accept wiki syntax" => "Wiki-Syntax erlauben",
"Forum quick jumps" => "Foren Schnellspr&uuml;nge",
"Ordering for forums in the forum listing" => "Sortierung der Foren in Forenliste",
"Creation Date (desc)" => "Erstellungsdatum (abst.)",
"Topics (desc)" => "Themen (abst.)",
"Threads (desc)" => "Threads (abst.)",
"Last post (desc)" => "Neueste Eintr&auml;ge (abst.)",
"Name (desc)" => "Name (abst.)",
"Name (asc)" => "Name (aufst.)",
"Forum listing configuration" => "Konfiguration Forenliste",
"Topics" => "Themen",
"Posts per day" => "Eintr&auml;ge pro Tag",
"Browser width" => "Browser-H&ouml;he",
"Browser height" => "Browser-Breite",
"Navigation depth" => "Navigationstiefe",
"Node size" => "Knotengr&ouml;sse",
"Text size" => "Textgr&ouml;sse",
"Spring (connection) size" => "Quellengr&ouml;sse (Verbindung)",
"Camera distance adjusted relative to nearest node" => "Kamera Entfernung einstellen, relativ zum nahsten Knoten",
"Camera distance" => "Kamera Entfernung",
"Field of view" => "Sichtbares Feld",
"Feed animation interval (milisecs)" => "Feed Animationsintervall (Millisek.)",
"Friction constant" => "Reibungskostante",
"Elastic constant" => "Elastizit&auml;tskonstante",
"Eletrostatic constant" => "Elektrostatischekonstante",
"Node mass" => "Knotengewicht",
"Node charge" => "Knotenladung",
"To add/remove image galleries, go to \"Image Galleries\" on the application menu, or" => "Bildgalerien hinzuf&uuml;gen/l&ouml;schen &uuml;ber Men&uuml;punkt 'Bildgalerien' im Men&uuml; im Seitenbalken oder",
"You can upload images of a size of " => "Maximale Gr&ouml;sse zum uploaden von Bildern: ",
"Alter the php.ini variables file_uploads, upload_max_filesize, post_max_size and database variables (max_allowed_packet for mysql) to change this value" => "&Auml;ndern Sie in der php.ini die Parameter file_uploads, upload_max_filesize, post_max_size und die Datenbankparameter (max_allowed_packet f&uuml;r MySQL) um diesen Gr&ouml;sse zu &auml;ndern",
"Uses Slideshow" => "Diaschau verwenden",
"Use database to store images" => "Datanbank zum Speichern von Bildern benutzen",
"Use a directory to store images" => "Ein Verzeichnis zum Speichern von Bildern benutzen",
"Note: if you change this directory, you have to move the contents to the new directory. You can also use the 'Mover' below." => "Hinweis: wenn das Verzeichnis ge&auml;ndert wird, mu&szlig; auch der Inhalt im Filesystem entsprechend manuell verschoben werden. Oder Sie k&ouml;nnen die Dateien in die Datenbank verlagern (s.u.)",
"Library to use for processing images" => "Bibliothek zur Bildbearbeitung",
"Uploaded image names must match regex" => "Hochgeladene Bildnamen m&uuml;ssen diese RegEx erf&uuml;llen",
"Uploaded image names cannot match regex" => "Hochgeladene Bildnamen d&uuml;rfen dieser RegEx nicht entsprechen",
"If you enable Directory Batch Loading, you need to setup a web-readable directory (outside of your web space is better). Then setup a way to upload images in that dir, either by scp, ftp, or other protocols" => "Wenn 'Batch-Upload aus Verzeichnis' aktiviert wird mu&szlig; ein vom Webserver lesbares Verzeichnis benutzt werden (am besten au&szlig;erhalb des Webspace). Dorthin m&uuml;ssen die Bilder dann mit scp, ftp o.&auml;. &uuml;bertragen werden.",
"Yes" => "Ja",
"Images per row" => "Bilder pro Zeile",
"Thumbnails size X" => "Thumbnails Breite",
"Thumbnails size Y" => "Thumbnails H&ouml;he",
"pixels" => "Pixel",
"Remove images in the system gallery not being used in Wiki pages, articles or blog posts" => "Bilder aus der Systemgalerie entfernen, die nicht auf Wiki-Seiten, in Artikeln oder Blog-Eintr&auml;gen genutzt werden",
"Mover" => "Dateien verlagern",
"Move images from filesystem storage to database storage" => "Verschiebe alle Bilder aus dem Dateisystem in die Datenbank",
"All galleries" => "Alle Galerien",
"Parent" => "Oberkategorie",
"Last modified" => "Zuletzt modifiziert",
"Image galleries comments settings" => "Bildergalerie-Kommentareinstellungen",
"General Preferences" => "Verschiedene Einstellungen I",
"Use group homepages" => "Gruppen-Homepages benutzen",
"Go to group homepage only if login from default homepage" => "Sprung zur Gruppen-Homepage nur bei Login &uuml;ber die Default-Homepage",
"Use URI as Home Page" => "URI als Home-Seite benutzen",
"Home page" => "Startseite",
"Custom home" => "Angepasstes Home",
"OS" => "Betriebssystem",
"Unknown/Other" => "unbekannt/anderes",
"No error reporting" => "Keine Fehlerausgabe",
"Report all PHP errors" => "Alle PHP Fehler ausgeben",
"Report all errors except notices" => "Alle Fehler au&szlig;er Hinweisen ausgeben",
"Default charset for sending mail:" => "Standard-Kodierung ausgehender eMails:",
"Mail end of line:" => "Zeilenende in eMails:",
"(some Unix MTA)" => "(Unix)",
"General Settings" => "Verschiedene Einstellungen II",
"Disallow access to the site (except for those with permission)" => "Zugriff auf den Server verbieten (au&szlig;er f&uuml;r Personen mit Berechtigung)",
"Message to display when site is closed" => "Angezeigte Meldung, wenn der Server geschlossen ist",
"Disallow access when load is above the threshold (except for those with permission)" => "Zugriff auf den Server bei &Uuml;berschreiben der eingestellten Maximallast verbieten (au&szlig;er f&uuml;r Personen mit Berechtigung)",
"Max average server load threshold in the last minute" => "H&ouml;chste Durchschnittslast in der letzten Minute",
"Message to display when server is too busy" => "Angezeigte Meldung, wenn der Server &uuml;berlastet ist",
"Use cache for external pages" => "Cache f&uuml;r externe Seiten benutzen",
"Use cache for external images" => "Cache f&uuml;r externe Bilder benutzen",
"Tikiwiki.org help" => "Tikiwiki.org Hilfe",
"Use gzipped output" => "Ausgabe durch gzip",
"output compression is active." => "Ausgabe-Komprimierung ist aktiv.",
"compression is handled by" => "Komprimierung erfolgt durch",
"Count admin pageviews" => "Seitenaufrufe durch Admin mitz&auml;hlen",
"Browser title" => "Browsertitel",
"Temporary directory" => "Tempor&auml;rverzeichnis",
"Sender Email" => "eMail-Absender",
"Contact user" => "Kontaktperson",
"Allow anonymous users to \"Contact Us\"" => "\"Kontaktiere uns\" Feature f&uuml;r Anonym erlauben",
"contact feature disabled" => "Kontakt-Funktion deaktiviert",
"Store session data in database" => "Session-Daten in Datenbank speichern",
"Session lifetime in minutes" => "Session-Lebenszeit in Minuten",
"Use proxy" => "Proxy benutzen",
"Proxy Host" => "Proxy Server",
"Proxy port" => "Proxy Port",
"Maximum number of records in listings" => "Maximale Anzahl der Datens&auml;tze in Listen",
"Help System" => "Hilfe-System",
"Help URL" => "Hilfe URL",
"Please expect not found help-pages with the default-URL." => "Teilweise fehlen die Hilfeseiten noch.",
"Any help with the documentation is welcome." => "Hilfe bei der Dokumentation ist willkommen.",
"Date and Time Formats" => "Datums- und Zeitformate",
"Long date format" => "Langes Datumsformat",
"Short date format" => "Kurzes Datumsformat",
"Long time format" => "Langes Zeitformat",
"Short time format" => "Kurzes Zeitformat",
"Date and Time Format Help" => "Hilfe zum Datums- und Zeitformat",
"Locations separator" => "Trennzeichen zwischen Locations",
"Examples" => "Beispiele",
"Choices separator" => "Auswahl Abgrenzer",
"Change admin password" => "Admin-Pa&szlig;wort &auml;ndern",
"New password" => "Neues Pa&szlig;wort",
"Change password" => "Pa&szlig;wort &auml;ndern",
"Internationalization" => "Internationalisierung",
"I18n setup" => "I18n Konfiguration (Mehrsprachigkeit)",
"Multilingual" => "Mehrsprachig",
"Detect browser language" => "Sprache des Clients abfragen",
"Use database for translation" => "f&uuml;r &Uuml;bersetzung Datenbank benutzen",
"Edit or ex/import Languages" => "Sprachen erstellen oder im/exportieren",
"Record untranslated" => "Eintrag nicht &uuml;bersetzt",
"Show Babelfish Translation URLs" => "Babelfish &Uuml;bersetzungslink zeigen",
"Show Babelfish Translation Logo" => "Babelfish &Uuml;bersetzungs-Logo zeigen",
"Intertiki client" => "Intertiki Client",
"Tiki Unique key" => "Eindeutiger Tiki Schl&uuml;ssel",
"InterTiki Slave mode" => "InterTiki Slave Modus",
"Warning: overrides manually registered local users" => "Warnung: &Uuml;berschreibt Nutzer die sich manuell registriert haben",
" as master" => " als Master",
"port" => "Port",
"Add new server" => "Neuen Server hinzuf&uuml;gen",
"Intertiki server" => "Intertiki Server",
"Intertiki Server enabled" => "Intertiki Server aktiviert",
"Access Log file" => "Verbindungs-Log-Datei",
"Known hosts" => "Bekannte Hosts",
"Key" => "Schl&uuml;ssel",
"Contact" => "Kontakt",
"Enable/disable Tiki features in " => "Tiki-Features ein/ausschalten in ",
", but configure them elsewhere" => ", konfiguriert werden sie dann an anderen Stellen.",
"Admin Groups" => "Gruppen verwalten",
"Admin Users" => "Benutzer verwalten",
"User registration and login" => "Benutzerregistrierung und -login",
"Authentication method" => "Authentifizierungsmethode",
"Just Tiki" => "Nur &uuml;ber Tiki",
"Web Server" => "Webserver",
"Tiki and PEAR::Auth" => "Tiki und PEAR::Auth",
"Tiki and PAM" => "Tiki und PAM",
"Tiki and HTTP Auth" => "Tiki und HTTP Auth",
"Use WebServer authentication for Tiki" => "Webserver-Authentifizierung f&uuml;r Tiki benutzen",
"Users can register" => "Benutzer k&ouml;nnen sich registrieren",
"... but need admin validation" => "... ben&ouml;tigen aber Best&auml;tigung durch den Admin",
"Create a group for each user <br />(with the same name as the user)" => "F&uuml;r jeden Benutzer eine eigene<br />Gruppe anlegen (Gruppenname = Benutzername)",
"Use tracker for more user information" => "Tracker f&uuml;r weitere Benutzer-Informationen benutzen",
"Use tracker for more group information" => "Tracker f&uuml;r weitere Gruppen-Informationen benutzen",
"Request passcode to register" => "Passcode zur Registrierung abfragen",
"Prevent automatic/robot registration" => "Batch-Registrierung (z.B. per Script) unterbinden",
"Validate users by email" => "Benutzer per eMail validieren",
"Remind passwords by email (if \"Store plaintext passwords\" is activated.) Else, Reset passwords by email" => "Pa&szlig;worterinnerungen per eMail (wenn \"Pa&szlig;w&ouml;rter im Klartext speichern\" aktiviert ist.) Sonst, Pa&szlig;w&ouml;rter per eMail zur&uuml;cksetzen",
"Store plaintext passwords" => "Speichere Klartext-Pa&szlig;w&ouml;rter",
"Crypt passwords method" => "Pa&szlig;wort-Verschl&uuml;sselung",
"tikihash (old)" => "tikihash (alt)",
"Reg users can change password" => "Reg. Benutzer k&ouml;nnen Pa&szlig;wort &auml;ndern",
"Reg users can change theme" => "Reg. Benutzer k&ouml;nnen Theme &auml;ndern",
"Restrict available themes" => "Verf&uuml;gbare Themes einschr&auml;nken",
"Available styles:" => "Verf&uuml;gbare Styles:",
"Reg users can change language" => "Reg. Benutzer k&ouml;nnen Sprache &auml;ndern",
"Restrict available languages" => "Verf&uuml;gbare Sprachen einschr&auml;nken",
"Minimum username length" => "Minimall&auml;nge Benutzername",
"Maximum username length" => "Maximall&auml;nge Benutzername",
"Force lowercase username" => "Nur Kleinbuchstaben im Benutzernamen",
"Use challenge/response authentication" => "Benutze Challenge-/Response-Authentifizierung",
"Force to use chars and nums in passwords" => "Erzwinge Benutzung von Buchstaben und Zahlen in Pa&szlig;w&ouml;rtern",
"Minimum password length" => "Minimale Pa&szlig;wortl&auml;nge",
"Password invalid after days" => "Tage bis zur Ung&uuml;ltigkeit des Pa&szlig;wortes",
"Allow secure (https) login" => "Erlaube sicheren Login (https)",
"Require secure (https) login" => "Sicherer Login (https) notwendig",
"HTTP port" => "HTTP-Port",
"HTTPS port" => "HTTPS-Port",
"Remember me feature" => "Erkenne mich-Funktion",
"Duration:" => "Dauer:",
"week" => "Woche",
"month" => "Monat",
"year" => "Jahr",
"Remember me name" => "Erkenne mich-Name",
"Remember me domain" => "Erkenne mich-Domain",
"Remember me path" => "Erkenne mich-Pfad",
"Protect against CSRF with a confirmation step" => "Durch Best&auml;tigungs-Schritt gegen CSRF sch&uuml;tzen",
"Protect against CSRF with a ticket" => "Durch Ticket gegen CSRF sch&uuml;tzen",
"Highlight Group" => "Gruppe hervorheben",
"choose a group ..." => "Gruppe ausw&auml;hlen ...",
"User can choose beyond these groups at registration time" => "Benutzer kann beim Registrieren zwischen diesen Gruppen w&auml;hlen",
"Displays user's contribution in the user information page" => "Zeigt die Nutzeraktivit&auml;t auf der Benutzer-Infoseite an",
"Create user if not in Tiki?" => "Benutzer anlegen falls im Tiki nicht vorhanden?",
"Create user if not in Auth?" => "Benutzer anlegen falls in Auth nicht vorhanden?",
"Just use Tiki auth for admin?" => "Nur Tiki-Authentifizierung f&uuml;r Administrator?",
"LDAP URL<br />(if set, this will override the Host and Port below)" => "LDAP URL<br />(wenn gesetzt werden Host und Port (s.u.) nicht benutzt)",
"LDAP User DN" => "LDAP Benutzer DN",
"LDAP User Attribute" => "LDAP Benutzer Attribut",
"LDAP User OC" => "LDAP Benutzer OC",
"LDAP Group DN" => "LDAP Gruppen DN",
"LDAP Group Attribute" => "LDAP Gruppen Attribut",
"LDAP Group OC" => "LDAP Gruppen OC",
"LDAP Member Attribute" => "LDAP Member Attribut",
"LDAP Admin User" => "LDAP Admin Benutzername",
"LDAP Admin Pwd" => "LDAP Admin Passwort",
"PAM service" => "PAM Dienst",
"Currently unused" => "momentan unbenutzt",
"You also need to upload the <a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> separately to lib/phpcas/." => "<a target=\"_blank\" href=\"http://esup-phpcas.sourceforge.net/\">phpCAS library</a> mu&szlig; zuvor nach lib/phpcas/ installiert werden.",
"CAS server version" => "CAS Serverversion",
"CAS server hostname" => "CAS Server Hostname",
"CAS server port" => "CAS Server Port",
"CAS server path" => "CAS Server Pfad",
"Change CAS preferences" => "Einstellungen &uuml;bernehmen",
"Valid Affiliations (separated by commas)" => "G&uuml;ltige Zugeh&ouml;rigkeiten (kommagetrennt)",
"Create with default group?" => "Standardgruppe erstellen?",
"Default group: " => "Standardgruppe",
"Change Shibboleth preferences" => "Einstellungen &uuml;bernehmen",
"Users Defaults" => "Standardeinstellungen der Benutzer",
"Does your mail reader need a special charset" => "Ben&ouml;tigt der Mailreader einen speziellen Zeichensatz?",
"default" => "standard",
"Number of visited pages to remember" => "Anzahl besuchter Seiten zum Vorhalten",
"Displayed time zone" => "Angezeigte Zeitzone",
"User information" => "Benutzerangaben",
"Private" => "Privat",
"public" => "&ouml;ffentlich",
"Use double-click to edit pages" => "Doppelklick zum &Auml;ndern von Seiten benutzen",
"Messages per page" => "Nachrichten pro Seite",
"Allow messages from other users" => "Nachrichten von anderen Anwendern erlauben",
"Note author when reading his mail" => "Lesebest&auml;tigung an den Autor einer Nachricht &uuml;bermitteln",
"Send me an email for messages with priority equal or greater than" => "Schicke mir eine eMail beim Eintreffen von Nachrichten mit Priorit&auml;t gr&ouml;&szlig;er gleich",
"Auto-archive read messages after x days" => "Gelesene Nachrichten nach x Tagen automatisch archivieren",
"never" => "niemals",
"Tasks per page" => "Aufgaben pro Seite",
"My Tiki" => "Mein Tiki",
"My pages" => "Meine Seiten",
"My messages" => "Meine Nachrichten",
"My tasks" => "Meine Aufgaben",
"My items" => "Meine Eintr&auml;ge",
"My workflow" => "Mein Workflow",
"Change users defaults" => "Einstellungen &uuml;bernehmen",
"Slideshows theme" => "Diaschau-Theme",
"Edit CSS" => "CSS bearbeiten",
"Theme Control" => "Theme-Konfiguration",
"Tiki Template Viewing" => "Tiki Templates betrachten",
"Site Identity" => "Site Identit&auml;t",
"General Layout options" => "Allgemeine Layout-Einstellungen",
"Site logo background color" => "Logo-Hintergrundfarbe",
"Site logo title (on mouse over)" => "Mouseover-Titel des Logos",
"Alt. description (e.g. for text browsers)" => "Logo ALT-Text",
"Site menu bar" => "Balken f&uuml;r Site Men&uuml;",
"Custom code" => "Angepasster Code",
"Left column" => "Linke Spalte",
"always" => "immer",
"user decides" => "Benutzer entscheidet",
"Site location bar" => "Position des Breadcrumb Balkens",
"at top of page" => "am Seitenanfang",
"at top of center column" => "am Anfang der Mittelspalte",
"Larger font for" => "Gr&ouml;&szlig;ere Schrift f&uuml;r",
"entire location" => "komplette Position",
"page name" => "Seitenname",
"Use page description:" => "Seitenbeschreibung benutzen:",
"Right column" => "Rechte Spalte",
"Bottom bar" => "Unterer Balken",
"Bottom bar icons" => "Icons im unteren Balken anzeigen",
"Bottom bar debug" => "Server-Info im unteren Balken anzeigen",
"Use direct pagination links" => "Seitennavigation &uuml;ber Seitenzahlen",
"Display menus as folders" => "Men&uuml;s als Ordner darstellen",
"Use Tabs" => "Tabs benutzen",
"Layout per section" => "Layout pro Bereich",
"Admin layout per section" => "Layout pro Bereich verwalten",
"Favicon icon file name:" => "Favicon Dateiname:",
"Favicon icon MIME type:" => "Favicon MIME-Type:",
"full path to mapfiles" => "Kompletter Pfad zu Kartendateien",
"default mapfile" => "Standard-Kartendatei",
"Wiki Page for Help" => "Wikiseite f&uuml;r Hilfe",
"Wiki Page for Comments" => "Wikiseite f&uuml;r Kommentare",
"Full path to gdaltindex" => "Kompletter Pfad zu gdaltindex",
"Full path to ogr2ogr" => "Kompletter Pfad zu ogr2ogr",
"Generate User Map" => "Benutzerkarte erstellen",
"Users can opt-out internal messages" => "Benutzer k&ouml;nnen Empfang interne Nachrichten deaktivieren",
"Users accept internal messages by default" => "Standardm&auml;ssig interne Nachrichten empfangen",
"Maximum mailbox size (messages, 0=unlimited)" => "Mailbox-Gr&ouml;&szlig;e (in Nachrichten, 0=unbegrenzt)",
"Maximum mail archive size (messages, 0=unlimited)" => "Mailboxarchiv-Gr&ouml;&szlig;e (in Nachrichten, 0=unbegrenzt)",
"Maximum sent box size (messages, 0=unlimited)" => "Ausgangsordner-Gr&ouml;&szlig;e (in Nachrichten, 0=unbegrenzt)",
"Value" => "Wert",
"Meta Keywords" => "Schl&uuml;sselw&ouml;rter",
"Meta Description" => "Beschreibung",
"Meta Author" => "Autor",
"geo.position" => "Geo Position",
"geo.region" => "Geo Region",
"geo.placename" => "Geo Ort",
"meta robots" => "Meta Robots",
"revisit after" => "erneut besuchen nach",
"Show Module Controls" => "Modul-Verschiebebuttons zeigen",
"Users can Configure Modules" => "Benutzer k&ouml;nnen Module konfigurieren",
"Users can Shade Modules" => "Benutzer kann Module minimieren",
"module decides" => "Modul entscheidet",
"Display modules to all groups always" => "Module immer in allen Gruppen anzeigen",
"Hide anonymous-only modules from registered users" => "Module f&uuml;r Anonym bei registrierten Benutzern verstecken",
"To add/remove polls, look for \"Polls\" under \"Admin\" on the application menu, or" => "Umfragen hinzuf&uuml;gen/l&ouml;schen &uuml;ber Men&uuml;punkt 'Abstimmungen' unter 'Admin' im Men&uuml; im Seitenbalken oder",
"Allow Anonymous Poll Voting" => "Anonyme Teilnehmer bei Umfragen erlauben",
"List" => "Liste",
"Image galleries" => "Bildergalerien",
"Feed for forums" => "Feed f&uuml;r Foren",
"Default RDF version" => "Welchs Protokoll benutzen",
"Specification" => "Spezifikation",
"Documentation" => "Dokumentation",
"seconds (0 = cache inactive)" => "Sekunden (0 = Cache deaktiviert)",
"You can see users rank by score in the module users_rank, for that go to" => "Den Benutzerrang nach Punkten kann man dem Modul user_rank entnehmen, einschaltbar unter",
"Admin modules" => "Module",
"Expiration" => "Verfallszeit",
"Referer Search Highlighting" => "Hervorhebung der Suchbegriffe auf den gefundenen Seiten",
"Performance issues" => "Performance-Einstellungen",
"Ignore individual object permissions" => "Individuelle Objekt-Berechtigungen ignorieren",
"Refresh wiki search index now" => "Wiki Suchindex jetzt aktualisieren",
"Search features" => "Suche Einstellungen",
"SearchStats" => "Such-Statistik",
"Settings for searching content" => "Einstellung f&uuml;r die Suche in Inhalten",
"random" => "zuf&auml;llig",
"Search refresh rate" => "Suche Refreshrate",
"0 for no refresh" => "0 f&uuml;r nicht aktualisieren",
"Minimum length of search word" => "Mindestl&auml;nge des Suchwortes",
"Max. number of words containing a syllable" => "Maximalzahl einsilbiger W&ouml;rter",
"Max. age in hours of syllable search cache" => "Maximales Alter in Stunden im Cache f&uuml;r Silbensuche",
"LRU list purging rate" => "L&ouml;schrate der LRU Liste",
"LRU list length" => "L&auml;nge der LRU Liste",
"Allow Smileys" => "Smileys erlauben",
"AutoLinks" => "URLs in Links verwandeln",
"Open external links in new window" => "Externe Links in neuem Fenster &ouml;ffnen",
"To configure your trackers, look for \"Admin trackers\" under \"Trackers\" on the application menu, or" => "Tracker konfigurieren &uuml;ber Men&uuml;punkt 'Tracker verwalten' unter 'Tracker' im Seitenbalken oder",
"Trackers attachments preferences" => "Einstellungen f&uuml;r Tracker Anh&auml;nge",
"Trackers with mirror tables" => "Tracker mit Mirror Tabellen",
"Use trackers with mirror tables" => "Tracker mit Mirror Tabellen benutzen",
"Values are stored in a dedicated table for each tracker, then you can easily manipulate them outside Tikiwiki" => "Die Werte f&uuml;r jeden Tracker werden in der separaten Tabelle gespeichert, diese k&ouml;nnen ausserhalb von Tiki angepasst werden.",
"Validate choice" => "Auswahl &uuml;berpr&uuml;fen",
"Trackers attachments" => "Tracker Anh&auml;nge",
"dls" => "DLs",
"Storage" => "Speicher",
"Change all to db" => "Alle auf Datenbank umstellen",
"Change all to file" => "Alle auf Datei umstellen",
"Quota (Mb)" => "Quota (MB)",
"Use database to store userfiles" => "Benutzer-Dateien in Datenbank speichern",
"Use a directory to store userfiles" => "Benutzer-Daten in Verzeichnis ablegen",
"Allow viewing HTML mails?" => "Anzeigen von HTML Mails erlauben?",
"Maximum size for each attachment" => "Maximale Gr&ouml;&szlig;e pro Anlage",
"Unlimited" => "unbegrenzt",
"To add/edit wiki pages easily, add the module quick_edit via \"Modules\" on the application menu, or" => "Zum einfachen Erstellen/Bearbeiten von Wikiseiten das Modul quick_edit hinzuf&uuml;gen &uuml;ber Men&uuml;punkt \"Module\" im Seitenbalken oder",
"Dumps" => "Datenbankabz&uuml;ge",
"Generate dump" => "Datenbankabzug erzeugen",
"Download last dump" => "Letzten Datenbankabzug downloaden",
"Create a Tag for the Current Wiki" => "Tag f&uuml;r die aktuelle Wikiseite erstellen",
"Restore the Wiki" => "Wikiseiter wiederherstellen",
"restore" => "wiederherstellen",
"Remove a Tag" => "Tag entfernen",
"Wiki Comments Settings" => "Einstellungen f&uuml;r Wiki-Kommentare",
"Export Wiki Pages" => "Exportiere Wiki-Seiten",
"Wiki attachments" => "Wiki-Anh&auml;nge",
"Remove unused pictures" => "Entferne unbenutzte Bilder",
"Wiki Home Page" => "Wiki-Home-Page",
"Wiki Discussion" => "Wiki Diskussion",
"Discuss pages on forums" => "Seiten im Forum diskutieren",
"Wiki Link Format" => "Wiki Link Erkennung",
"Controls recognition of Wiki links using the two parenthesis Wiki link syntax <i>((page name))</i>." => "Definiert, welche <i>((Strings))</i> in Wiki Links umgewandelt werden",
"complete" => "vollst&auml;ndig",
"english" => "englisch",
"Wiki Page List Configuration" => "Einstellungen f&uuml;r Wikiliste",
"Last version" => "Neueste Version",
"Versions" => "Versionen",
"Wiki 3D Browser Configuration" => "Wiki 3D Browser Konfiguration",
"Wiki Features" => "Wiki-Funktionen",
"|| for rows" => "|| f&uuml;r Spalten",
"\\n for rows" => "\\n f&uuml;r Spalten",
"Top bar" => "Oberer Balken",
"Wiki History" => "Wiki Historie",
"Only with last version" => "nur mit letzter Version",
"Any 2 versions" => "zwei beliebige Versionen",
"Wiki Watch" => "Wiki Beobachtung",
"Restore defaults" => "Standardeinstellungen wiederherstellen",
"Crosslinks to other features and settings" => "Querverweise zu anderen Einstellungen",
"Other sections" => "Andere Bereiche",
"Administration features" => "Grundlegende Konfiguration",
"Transversal features" => "&Uuml;bergeordnete Einstellungen",
"which apply to more than one section" => "die sich auf mehr als einen Bereich auswirken",
"Navigation features" => "Navigation",
"Look &amp; feel" => "Look &amp; Feel",
"themes" => "Themes",
"Text area features" => "Einstellungen f&uuml;r Inhalte",
"features you can use in all text areas, like wiki pages, blogs, articles, forums, etc" => "Einstellungen, die f&uuml;r Wikiseiten, Blogs, Artikeln, Foren etc. gelten",
"Stats &amp; banners" => "Statistiken &amp; Banner",
"Report" => "Protokoll",
"Setting" => "Einstellung",
"User:" => "Benutzer:",
"Group:" => "Gruppe",
"Category:" => "Kategorie",
"bytes" => "Bytes",
"contribution" => "Mitwirkung",
"Statistics" => "Statistiken",
"Days" => "Tage",
"Weeks" => "Wochen",
"recorded" => "gespeichert",
"viewed" => "angesehen",
"Wiki page actions except viewed will always be recorded but can be not reported" => "Wiki Seiten &Auml;nderungen werden bis auf 'betrachtet' gespeichert, k&ouml;nnen aber nicht protokolliert werden.",
"Add or edit a rule" => "Regel hinzuf&uuml;gen/bearbeiten",
"Rule title" => "Regelbezeichnung",
"Username regex matching" => "Benutzername-basiert (regex)",
"IP regex matching" => "IP-basiert (regex)",
"Banned from sections" => "Aus diesen Bereichen bannen",
"Rule activated by dates" => "Sperrung &uuml;ber Zeitraum",
"Rule active from" => "Regel g&uuml;ltig von",
"Rule active until" => "Regel g&uuml;ltig bis",
"Custom message to the user" => "Spezielle Nachricht f&uuml;r den Benutzer",
"Rules" => "Regeln",
"x" => "X",
"User/IP" => "Benutzername/IP",
"Sections" => "Bereiche",
"Admin Calendars" => "Kalender verwalten",
"List of Calendars" => "Liste der Kalender",
"Loc" => "Ort",
"Participants" => "Teilnehmer",
"Cat" => "Kateg.",
"Lang" => "Sprache",
"Url" => "URL",
"Subscription" => "Abonnement",
"Permissions" => "Berechtigungen",
"Create/edit Calendars" => "Kalender hinzuf&uuml;gen/bearbeiten",
"Custom Locations" => "Pers&ouml;nliche &Ouml;rtlichkeiten",
"Custom Participants" => "Pers&ouml;nliche Teinehmer",
"Custom Categories" => "Pers&ouml;nliche Kategorien",
"Custom Languages" => "Pers&ouml;nliche Sprache",
"Custom Subscription List" => "Pers&ouml;nliche Abo-Liste",
"Custom Priorities" => "Pers&ouml;nliche Priorit&auml;ten",
"Personal Calendar" => "Pers&ouml;nlicher Kalender",
"Current category" => "Aktuelle Kategorie",
"Child categories" => "Unterkategorien",
"Edit permissions for this category" => "Berechtigungen dieser Kategorie &auml;ndern",
"Assign Permissions" => "Berechtigungen vergeben",
"Edit this category:" => "Diese Kategorie bearbeiten:",
"Create New" => "Erstelle neu",
"Add new category" => "Neue Kategorie hinzuf&uuml;gen",
"Assign permissions automatically" => "Berechtigungen automatisch vergeben",
"recommended for best performance" => "empfohlen f&uuml;r beste Performance",
"Objects in category" => "Objekte in Kategorie",
"No records found." => "Keine Eintr&auml;ge gefunden.",
"Add objects to category" => "Objekte zu Kategorie hinzuf&uuml;gen",
"image gal" => "Bildergalerie",
"file gal" => "Dateiarchiv",
"Poll" => "Abstimmung",
"Admin chart items" => "Eintr&auml;ge in Hitlisten verwalten",
"charts" => "Hitlisten",
"Edit Chart" => "Hitliste bearbeiten",
"Add or edit an item" => "Eintrag hinzuf&uuml;gen/bearbeiten",
"Update" => "Aktualisieren",
"Chart items" => "Eintr&auml;ge in Hitlisten",
"No items defined yet" => "Noch keine Eintr&auml;ge vorhanden",
"Admin charts" => "Hitlisten verwalten",
"View template" => "Vorlage betrachten",
"Add or edit a chart" => "Hitliste hinzuf&uuml;gen/bearbeiten",
"Active" => "aktiv",
"Users can vote for only one item from this chart per period" => "Benutzer k&ouml;nnen nur f&uuml;r einen Eintrag pro Abstimmungszeitraum stimmen",
"Prevent users from voting for the same item more than once" => "Benutzer k&ouml;nnen nur einmal &uuml;berhaupt pro Hitliste abstimmen",
"Users can suggest new items" => "Benutzer k&ouml;nnen neue Eintr&auml;ge vorschlagen",
"Auto validate user suggestions" => "Vorschl&auml;ge der Benutzer automatisch validieren",
"Ranking shows" => "Rangliste zeigt",
"All items" => "Alle Eintr&auml;ge",
"Top 10 items" => "Top 10 Eintr&auml;ge",
"Top 20 items" => "Top 20 Eintr&auml;ge",
"Top 40 items" => "Top 40 Eintr&auml;ge",
"Top 50 items" => "Top 50 Eintr&auml;ge",
"Top 100 items" => "Top 100 Eintr&auml;ge",
"Top 250 items" => "Top 250 Eintr&auml;ge",
"Voting system" => "Wahlsystem",
"Vote items" => "Eintr&auml;ge w&auml;hlen",
"Rank 1..5" => "Rang 1..5 vergeben",
"Rank 1..10" => "Rang 1..10 vergeben",
"Ranking frequency" => "Wahlh&auml;ufigkeit",
"Realtime" => "Echtzeit",
"Each 5 minutes" => "alle 5 Minuten",
"Daily" => "t&auml;glich",
"Weekly" => "w&ouml;chentlich",
"Monthly" => "monatlich",
"Show Average" => "Zeige Durchschnitt",
"Show Votes" => "Zeige Stimmen",
"Use Cookies for unregistered users" => "Bei nicht angemeldeten Benutzern Cookies verwenden",
"Users can vote again after" => "Benutzer k&ouml;nnen erneut abstimmen nach",
"Anytime" => "jederzeit",
"1 day" => "1 Tag",
"1 week" => "1 Woche",
"1 month" => "1 Monat",
"Items" => "Eintr&auml;ge",
"Ranks" => "R&auml;nge",
"No charts defined yet" => "Noch keine Hitlisten definiert",
"Chat Administration" => "Chat-Verwaltung",
"Chat Admin" => "Chat verwalten",
"Create/edit channel" => "Chatraum hinzuf&uuml;gen/bearbeiten",
"Refresh rate" => "Refresh-Rate",
"Half a second" => "halbe Sekunde",
"second" => "Sekunde",
"Chat channels" => "Chatr&auml;ume",
"Admin templates" => "Vorlagen verwalten",
"Admin Content Templates" => "Inhaltsvorlagen verwalten",
"Edit this template:" => "Dieses Template bearbeiten:",
"Create new template" => "Neue Vorlage erstellen",
"CMS" => "Artikel",
"Template" => "Vorlage",
"Templates" => "Vorlagen",
"Last Modif" => "Letzte &Auml;nderung",
"Admin Contributions" => "Beteiligungslisten verwalten",
"Settings" => "Einstellungen",
"Contributions are mandatory in wiki pages" => "Auswahl bei Wikiseiten verbindlich",
"Contributions are mandatory in forums" => "Auswahl bei Foreneintr&auml;gen verbindlich",
"Contributions are mandatory in comments" => "Auswahl bei Kommentaren verbindlich",
"Contributions are mandatory in blogs" => "Auswahl bei Blogeintr&auml;gen verbindlich",
"Contributions are displayed in the comment/post" => "Beteiligung wird in Kommentar/Beitrag angezeigt",
"Create a new contribution" => "Neue Beteiligungsliste erstellen",
"List of contributions" => "&Uuml;bersicht der Beteiligungslisten",
"Admin cookies" => "Cookies verwalten",
"Create/edit cookies" => "Cookies hinzuf&uuml;gen/bearbeiten",
"Upload Cookies from textfile" => "Cookies aus Textdatei hochladen",
"Upload from disk:" => "Hochladen von Disk:",
"Upload" => "Hochladen",
"Remove all cookies" => "Alle Cookies l&ouml;schen",
"cookie" => "Cookie",
"Available drawings" => "Verf&uuml;gbare Zeichnungen",
"Admin DSN" => "DSN verwalten",
"Create/edit dsn" => "DSN hinzuf&uuml;gen/bearbeiten",
"Admin external wikis" => "Externe Wikis verwalten",
"Create/Edit External Wiki" => "Externes Wiki erstellen/bearbeiten",
"URL (use \$page to be replaced by the page name in the URL example: http://www.example.com/tiki-index.php?page=\$page)" => "URL (\$page benutzen und mit dem Wiki Seitennamen ersetzen, z.B.: http://qum74.mms-dresden.telekom.de/tiki/tiki-index.php?page=\$page)",
"Admin Forums" => "Foren verwalten",
"Create new forum" => "Neues Forum anlegen",
"Edit this Forum:" => "Dieses Forum bearbeiten:",
"Create New Forum" => "Neues Forum erstellen",
"There are individual permissions set for this forum" => "F&uuml;r dieses Forum sind individuelle Rechte gesetzt",
"Show description" => "Beschreibung zeigen",
"Prevent flooding" => "Flooding verhindern",
"Minimum time between posts" => "Minimale Zeit zwischen Posts",
"Section" => "Bereich",
"Create new" => "Erstelle neu",
"Moderator user" => "Moderator",
"Moderator group" => "Moderator-Gruppe",
"Password protected" => "mit Passwort gesichert",
"Topics only" => "nur Themen",
"All posts" => "Alle Postings",
"Forum password" => "Foren-Passwort",
"Send this forums posts to this email" => "Postings in dieses Forum an eMail-Adresse weiterleiten",
"Prune unreplied messages after" => "Nicht beantwortete Nachrichten l&ouml;schen nach",
"Prune old messages after" => "Alte Nachrichten l&ouml;schen nach",
"Topic list configuration" => "Einstellungen Themenliste",
"Posts can be rated" => "Eintr&auml;ge d&uuml;rfen bewertet werden",
"Display last post titles" => "Neueste Beitragstitel anzeigen",
"no display" => "keine Anzeige",
"Forward messages to this forum to this e-mail address, in a format that can be used for sending back to the inbound forum e-mail address" => "Nachrichten in dieses Forum an die angegebene eMail-Adresse weiterleiten in einem Format, das R&uuml;ckantworten ins Forum erlaubt",
"Send mails even when the post is generated by inbound mail" => "Nachrichten auch schicken, wenn das Posting per eMail get&auml;tigt wurde",
"Append a reply link to outbound mails" => "Antwort-Link an ausgehende Nachrichten anh&auml;ngen",
"Originating e-mail address for mails from this forum" => "Absenderadresse f&uuml;r Nachrichten aus diesem Forum",
"Add messages from this email to the forum" => "Nachrichten von dieser eMail-Adresse in das Forum weiterleiten",
"POP3 server" => "POP3 Server",
"Use topic smileys" => "Smilies f&uuml;r Themen benutzen",
"Show topic summary" => "Themenzusammenfassung anzeigen",
"User information display" => "Benutzer-Informationen anzeigen",
"Flag" => "Kennzeichen",
"Approval type" => "Best&auml;tigung n&ouml;tig f&uuml;r",
"All posted" => "keine Nachricht",
"Queue anonymous posts" => "anonyme Nachrichten",
"Queue all posts" => "alle Nachrichten",
"No attachments" => "keine Anh&auml;nge",
"Everybody can attach" => "jeder darf Dateien anh&auml;ngen",
"Only users with attach permission" => "nur Benutzer mit Anhangserlaubnis",
"Moderators and admin can attach" => "nur Moderatoren und Admins",
"Store attachments in:" => "Anh&auml;nge speichern in:",
"Database" => "Datenbank",
"Max attachment size (bytes)" => "Maximale Gr&ouml;&szlig;e (Bytes)",
"Default ordering for topics" => "Standardsortierung f&uuml;r Themen",
"Date (desc)" => "Datum (abst.)",
"Date (asc)" => "Datum (aufst.)",
"Score (desc)" => "Score (abst.)",
"Replies (desc)" => "Antworten (abst.)",
"Reads (desc)" => "Zugriffe (abst.)",
"Topics per page" => "Themen pro Seite",
"Default ordering for threads" => "Standardsortierung f&uuml;r Threads",
"Coms" => "Kommentare",
"Age" => "Alter",
"PPD" => "PPT",
"Last Post" => "Neuester Eintrag",
"Admin Hotwords" => "Hotwords verwalten",
"Add Hotword" => "Hotword hinzuf&uuml;gen",
"Word" => "Wort",
"Admin HTML pages" => "HTML-Seiten verwalten",
"Edit this page" => "&Auml;ndere diese Seite",
"View page" => "Seite anzeigen",
"Edit zone" => "Bereiche bearbeiten",
"Zone" => "Bereich",
"Dynamic zones" => "Dynamische Bereiche",
"zone" => "Bereich",
"content" => "Inhalt",
"Mass update" => "Massenaktualisierung",
"Create new HTML page" => "Neue HTML-Seite erstellen",
"Edit this HTML page:" => "Diese HTML-Seite bearbeiten:",
"Dynamic" => "Dynamisch",
"Static" => "Statisch",
"Edit Repository:" => "Repository bearbeiten:",
"Create New Repository" => "Neues Repository erstellen",
"List Repositories" => "Repositories auflisten",
"New Repository" => "Neues Repository",
"View Repository" => "Repository anschauen",
"Start page" => "Startseite",
"CSS file" => "CSS-Datei",
"Cacheable" => "cachebar",
"Clear cache" => "Cache leeren",
"Cache expiration" => "Cache Verfallszeit",
"Available Repositories" => "Vorhandene Repositories",
"CSS File" => "CSS-Datei",
"Edit rules" => "Regeln bearbeiten",
"Edit Rules for Repository:" => "Regeln &auml;ndern f&uuml;r Repository:",
"Configure Repositories" => "Repositories konfigurieren",
"Configure this Repository" => "Dieses Repository konfigurieren",
"View this Repository" => "Repository ansehen",
"Add new rule" => "Neue Regel hinzuf&uuml;gen",
"New Rule" => "Neue Regeln",
"Copy Rules" => "Regeln kopieren",
"Copy" => "Kopieren",
"Rule order" => "Reihenfolge der Regeln",
"Text to search for" => "Zu suchender Text",
"Text to replace" => "Zu ersetzender Text",
"Replace" => "Ersetzen",
"Enabled" => "Aktiviert",
"Preview options" => "Vorschau-Einstellungen",
"Apply all rules" => "Alle Regeln anwenden",
"Code preview" => "Code-Vorschau",
"Generate HTML preview" => "HTML-Vorschau erstellen",
"HTML preview" => "HTML-Vorschau",
"Preview Results" => "Vorschau der Ergebnisse",
"Rules List" => "Regelliste",
"Admin layout" => "Layout verwalten",
"layout options" => "Layout Optionen",
"Admin Featured Links" => "Linktips verwalten",
"Generate positions by hits" => "Positionen nach Zugriffen vergeben",
"List of featured links" => "Liste vorhandener Linktips",
"Add Featured Link" => "Linktip hinzuf&uuml;gen",
"Edit this Featured Link:" => "Diesen Linktip bearbeiten:",
"Create new Featured Link" => "Neuen Linktip anlegen",
"disables the link" => "deaktiviert den Link",
"Link type" => "Linktyp",
"replace current page" => "Aktuelle Seite ersetzen",
"framed" => "umrahmt",
"open new window" => "Neues Fenster &ouml;ffnen",
"Mail-in accounts" => "Mail-in Accounts",
"Admin Webmail" => "Webmail verwalten",
"Add new Mail-in account" => "Mail-in Account erstellen",
"Edit Mail-in account" => "Mail-in Account bearbeiten",
"Account name" => "Account-Name",
"POP server" => "POP-Server",
"SMTP server" => "SMTP-Server",
"SMTP requires authentication" => "SMTP ben&ouml;tigt Authentifizierung",
"Article Topic" => "Artikel-Thema",
"Article Type" => "Artikel-Typ",
"Allow anonymous acces" => "Anonymen Zugriff erlauben",
"Allow attachments" => "Anh&auml;nge erlauben",
"Check Mail-in accounts" => "Mail-in Accounts &uuml;berpr&uuml;fen",
"Check automatically" => "Automatisch &uuml;berpr&uuml;fen",
"Frequency" => "Frequenz",
"List menus" => "Men&uuml;s auflisten",
"Edit this menu" => "Dieses Men&uuml; bearbeiten",
"Edit menu options" => "Men&uuml;optionen bearbeiten",
"Show Quick Urls" => "Quick URLs anzeigen",
"Some useful URLs" => "Einige n&uuml;tzliche URLs",
"Hide Quick Urls" => "Quick URLs verstecken",
"option" => "Option",
"separator" => "Trennlinie",
"Choose" => "Ausw&auml;hlen",
"Home Page" => "Startseite",
"Home Image Gal" => "Home-BilderGal",
"Home Image Gallery" => "Home-Bildergalerie",
"Home File Gal" => "Home-Dateiarchiv",
"Home File Gallery" => "Home-Dateiarchiv",
"User preferences" => "Benutzereinstellungen",
"User prefs" => "Benutzereinstellungen",
"List image galleries" => "Bildergalerien auflisten",
"Gallery Rankings" => "Galerie-Bewertungen",
"Browse a gallery" => "Galerie ansehen",
"All articles" => "Alle Artikel",
"Submit" => "Abschicken",
"Create blog" => "Blog erstellen",
"File galleries" => "Dateiarchive",
"View a forum" => "Forum ansehen",
"View a thread" => "Thread ansehen",
"View a FAQ" => "Eine FAQ ansehen",
"Take a quiz" => "Ein Quiz durchf&uuml;hren",
"Stats for a Quiz" => "Statistik f&uuml;r ein Quiz",
"Preview menu" => "Vorschau des Men&uuml;s",
"Menu options" => "Men&uuml;optionen",
"Edit this Menu:" => "Dieses Men&uuml; bearbeiten:",
"Create new Menu" => "Neues Men&uuml; erstellen",
"dynamic collapsed" => "Dynamisch eingeklappt",
"dynamic extended" => "Dynamisch ausgeklappt",
"fixed" => "fest",
"Options" => "Optionen",
"Assign Module" => "Modul zuweisen",
"Left Modules" => "Module links",
"Right Modules" => "Module rechts",
"Edit/Create" => "hinzuf&uuml;gen/bearbeiten",
"Clear Cache" => "Cache leeren",
"User Modules" => "Benutzer-Module",
"Assign" => "Zuweisen",
"Assign new module" => "Neues Modul hinzuf&uuml;gen",
"Edit this assigned module:" => "Dieses zugewiesene Modul bearbeiten:",
"Module Name" => "Modulname",
"Order" => "Reihenfolge",
"Cache Time" => "Cache-Zeit",
"Rows" => "Zeilen",
"Parameters" => "Parameter",
"Visibility" => "Sichtbarkeit",
"Displayed now for all eligible users even with personal assigned modules" => "Sichtbar f&uuml;r alle Benutzer, auch die mit pers&ouml;nlicher Modul-Konfiguration",
"Displayed for the eligible users with no personal assigned modules" => "Sichtbar f&uuml;r Benutzer ohne pers&ouml;nliche Modul-Konfiguration",
"Displayed now, can't be unassigned" => "Immer anzeigen, kann nicht wegkonfiguriert werden",
"Not displayed until a user chooses it" => "Nicht anzeigen bis der Benutzer es hinzukonfiguriert",
"Assigned Modules" => "Zugewiesene Module",
"Move to Right Column" => "In die rechte Spalte verschieben",
"Unassign" => "Zuordnung aufheben",
"Move to Left Column" => "In die linke Spalte verschieben",
"Create new user module" => "Neues Benutzer-Modul erstellen",
"Edit this user module:" => "Dieses Benutzer-Modul bearbeiten:",
"Must be wiki parsed" => "Wiki Parser anwenden",
"Objects that can be included" => "Objekte, die eingebunden werden k&ouml;nnen",
"Available polls" => "Verf&uuml;gbare Abstimmungen",
"Random active poll" => "Zuf&auml;llige aktive Umfrage",
"Random current poll" => "Zuf&auml;llige aktuelle Umfrage",
"Use Poll" => "Abstimmung benutzen",
"Random image from" => "Zuf&auml;lliges Bild aus",
"Use Gallery" => "Galerie benutzen",
"Dynamic content blocks" => "Dynamische Inhaltsbl&ouml;cke",
"Use Dynamic Content" => "Dynamischen Inhaltsblock benutzen",
"Use RSS Module" => "RSS-Modul benutzen",
"Use Menu" => "Men&uuml; benutzen",
"phpLayersMenus" => "phpLayerMen&uuml;s",
"Use phplayermenu" => "PHPLayerMen&uuml; benutzen",
"Banner zones" => "Bannerzonen",
"Use Banner Zone" => "Bannerzone benutzen",
"Admin newsletter subscriptions" => "Newsletter-Abonnenten verwalten",
"List Newsletters" => "Newsletter auflisten",
"Admin Newsletters" => "Newsletter verwalten",
"Add a subscription newsletters" => "Abo f&uuml;r Newsletter hinzuf&uuml;gen",
"Add email:" => "eMail hinzuf&uuml;gen:",
"Add user:" => "Benutzer hinzuf&uuml;gen:",
"Subscriptions" => "Registrierungen",
"Valid" => "G&uuml;ltig",
"subscribed" => "abonniert",
"Create/Edit Newsletters" => "Newsletters hinzuf&uuml;gen/bearbeiten",
"There are individual permissions set for this newsletter" => "Es existieren individuelle Berechtigungen f&uuml;r diesen Newsletter",
"Users can subscribe/unsubscribe to this list" => "Benutzer k&ouml;nnen sich f&uuml;r diese Liste an/abmelden",
"Users can subscribe any email address" => "Benutzer k&ouml;nnen beliebige eMail-Adressen eintragen",
"Add unsubscribe instructions to each newsletter" => "Hinweise zur Abmeldung von der Liste an jeden Newsletter anh&auml;ngen",
"Validate email addresses" => "eMail-Adressen &uuml;berpr&uuml;fen",
"Editions" => "Ausgaben",
"Last Sent" => "Zuletzt gesendet",
"Send Newsletter" => "Newsletter versenden",
"EMail notifications" => "eMail-Benachrichtigungen",
"Add notification" => "Benachrichtigung hinzuf&uuml;gen",
"Event" => "Ereignis",
"A user registers" => "Ein Benutzer registriert sich",
"A user submits an article" => "Ein Benutzer reicht einen Artikel ein",
"Any wiki page is changed" => "Eine Wiki-Seite hat sich ge&auml;ndert",
"Any wiki page is changed, even minor changes" => "Eine Wiki-Seite hat sich ge&auml;ndert, auch kleine &Auml;nderungen",
"A comment in a wiki page is posted or edited" => "Kommentar zu einer Wikiseite wird erstellt oder ge&auml;ndert",
"PHP error" => "PHP Fehler",
"Email:" => "eMail:",
"Admin Polls" => "Abstimmungen verwalten",
"List polls" => "Abstimmungen auflisten",
"Edit this poll" => "Diese Abstimmung bearbeiten",
"Preview poll" => "Vorschau der Abstimmung",
"Poll options" => "Abstimmungs-Optionen",
"Votes" => "Stimmen",
"Set last poll as current" => "Letzte Abstimmung als aktuelle Abstimmung setzen",
"Close all polls but last" => "Alle bis auf die letzte Abstimmung schlie&szlig;en",
"Activate all polls" => "Alle Abstimmungen aktivieren",
"active" => "aktiv",
"current" => "aktuell",
"template" => "Vorlage",
"object" => "Objekt",
"PublishDate" => "DatumVer&ouml;ff.",
"Objects" => "Objekte",
"Wiki pages" => "Wiki-Seiten",
"Admin Quicktags" => "Quicktags verwalten",
"Create/Edit QuickTags" => "QuickTags hinzuf&uuml;gen/bearbeiten",
"Insert (use 'text' for figuring the selection)" => "Einf&uuml;gen ('text' um die Auswahl zu markieren)",
"Path to the tag icon" => "Icon-Pfad",
"Admin RSS modules" => "RSS-Module verwalten",
"This page is to configure settings of RSS feeds read/imported by Tiki. To generate/export RSS feeds, look for \"RSS feeds\" on the admin panel, or" => "Auf dieser Seite werden die RSS Feeds konfiguriert, die von Tiki gelesen und importiert werden. Zum generieren/exportieren von RSS Feeds \"RSS Feeds\" im Men&uuml; w&auml;hlen oder",
"Content for the feed" => "Inhalt f&uuml;r den Feed",
"Edit this RSS module:" => "Dieses RSS-Modul bearbeiten:",
"Create new RSS module" => "Neues RSS-Modul erstellen",
"show feed title" => "Feed-Titel anzeigen",
"show publish date" => "Ver&ouml;ffentlichungsdatum anzeigen",
"Last update" => "Letzte Aktualisierung",
"Score System" => "Punkte-System",
"PHP settings" => "PHP Einstellungen",
"PHP variable" => "PHP Variable",
"Risk Factor" => "Risikofaktor",
"Explanation" => "Erkl&auml;rung",
"Tikiwiki settings" => "Tiki Einstellungen",
"Tiki variable" => "Tiki Variable",
"Check all tiki files" => "Alle Tiki-Dateien &uuml;berpr&uuml;fen",
"Note, that this can take a very long time. You should check your max_execution_time setting in php.ini." => "Achtung, dies kann viel Zeit in Anspruch nehmen. Der Parameter max_execution_time setting in der php.ini sollte entsprechend hoch sein, damit das Script nicht abbricht.",
"Note: You have to import security data via installation process (<a href=\"tiki-install.php\">tiki-install.php</a>). Import the *secdb* update files in your database." => "Bemerkung: Sicherheitsdaten werden nur &uuml;ber den Installationsvorgang importiert (<a href=\"tiki-install.php\">tiki-install.php</a>). Importieren Sie die *secdb* Update Dateien in Ihre Datenbank.",
"File checks" => "Datei-Checks",
"type" => "Typ",
"user" => "Benutzer",
"group" => "Gruppe",
"Admin Shoutbox Words" => "Shoutbox Words Verwaltung",
"Are you sure you want to delete this word?" => "Soll das Wort wirklich gel&ouml;scht werden?",
"Destroy the structure leaving the wiki pages" => "Nur Struktur entfernen",
"Destroy the structure and remove the pages" => "Struktur und Seiten entfernen",
"Structure ID" => "Struktur-ID",
"Export Pages" => "Seiten exportieren",
"Dump Tree" => "Baum ausgeben",
"Create new structure" => "Neue Struktur anlegen",
"Tree" => "Baum",
"Use single spaces to indent structure levels" => "Strukturelevel durch Einr&uuml;cken (einzelne Leerzeichen) definieren",
"Create New Structure" => "Neue Struktur anlegen",
"Edit survey questions" => "Umfrage bearbeiten",
"Survey Stats" => "Umfragen-Statistik",
"this survey stats" => "Statistik dieser Umfrage",
"Edit this Survey" => "Diese Umfrage bearbeiten",
"Admin Surveys" => "Umfragen verwalten",
"Create/edit questions for survey" => "Fragen f&uuml;r Umfrage erstellen/bearbeiten",
"Question" => "Frage",
"One choice" => "Eine Auswahl",
"Multiple choices" => "Multiple Auswahlen",
"Short text" => "Kurzbeschreibung",
"Rate (1..5)" => "Bewerte (1..5)",
"Rate (1..10)" => "Bewerte (1..10)",
"Rate" => "Bewerten",
"For a multiple answer question put the answers into the following field, separated by a comma. Example: one,two,many,lots" => "Bei Fragen mit mehreren m&ouml;glichen Antworten diese im folgenden Feld kommagetrennt eingeben",
"Options (if apply)" => "Optionen (falls n&ouml;tig)",
"Questions" => "Fragen",
"question" => "Frage",
"Edit this Survey:" => "Diese Umfrage bearbeiten:",
"Create New Survey" => "Neue Unfrage erstellen",
"There are individual permissions set for this survey" => "F&uuml;r diese Umfrage sind individuelle Berechtigungen gesetzt",
"Open" => "Offen",
"Empty" => "Leeren",
"Templates compiler" => "Template Compiler",
"Compile" => "Kompilieren",
"Advanced feature" => "Funktion f&uuml;r Fortgeschrittene",
"Fix UTF-8 Errors in Tables" => "UTF-8 Fehler in Tabellen korrigieren",
"Warning: Make a backup of your Database before using this function!" => "Warnung: Erstellen Sie ein Datenbank Backup bevor Sie diese Funktion benutzen!",
"Warning: If you try to convert large tables, raise the maximum execution time in your php.ini!" => "Warnung: Wenn Sie grosse Tabellen konvertieren wollen, erh&ouml;hen Sie die maximum execution time in Ihrer php.ini!",
"This function converts ISO-8859-1 encoded strings in your tables to UTF-8" => "Diese Funktion konvertiert ISO-8859-1 codierte Strings in UTF-8",
"This may be necessary if you created content with tiki &lt; 1.8.4 and Default Charset settings in apache set to ISO-8859-1" => "Notwendig, wenn Sie mit Tiki &lt; v1.8.4 und ISO-8859-1 Codierung gearbeitet haben.",
"Table" => "Tabelle",
"Field" => "Feld",
"Investigate" => "Untersuchen",
"Fix it" => "Korrigieren",
"Admin Topics" => "Themen verwalten",
"Create a new topic" => "Neues Thema erstellen",
"Topic Name" => "Themenname",
"Upload Image" => "Bild hochladen",
"List of topics" => "Themenliste",
"Active?" => "Aktiv?",
"Articles (subs)" => "Artikel (eingereicht)",
"topic image" => "Themenlogo",
"Remove with articles" => "Typ und zugeh&ouml;rige Artikel l&ouml;schen",
"Deactivate" => "Deaktivieren",
"Admin Tracker" => "Tracker verwalten",
"edit" => "bearbeiten",
"Admin Trackers" => "Tracker verwalten",
"Edit This Tracker" => "Diesen Tracker bearbeiten",
"View This Tracker's Items" => "Eintr&auml;ge dieses Trackers ansehen",
"Edit tracker field" => "Tracker-Felder bearbeiten",
"Is column visible when listing tracker items?" => "Ist Spalte beim Auflisten von Tracker-Eintr&auml;gen sichtbar?",
"Column links to edit/view item?" => "Links in Spalten zum Editiere/Betrachten von Eintr&auml;gen?",
"Column is searchable?" => "Spalte durchsuchbar?",
"Field is mandatory?" => "Pflichtfeld?",
"Tracker fields" => "Tracker-Felder",
"isMain" => "Hauptfeld",
"Tbl vis" => "in Liste",
"Searchable" => "Durchsuchbar",
"Public" => "&Ouml;ffentlich",
"Hidden" => "Versteckt",
"Mandatory" => "Pflicht",
"Import/Export Trackers Fields" => "Tracker-Felder importieren/exportieren",
"Create Trackers" => "Tracker anlegen",
"Found" => "Fand",
"trackers" => "Tracker",
"Fields" => "Felder",
"Create/Edit Trackers" => "Tracker hinzuf&uuml;gen/bearbeiten",
"There are individual permissions set for this tracker" => "F&uuml;r diesen Tracker sind individuelle Berechtigungen gesetzt",
"No individual permissions. Global permissions apply." => "Keine individuellen Berechtigungen, globale Berechtigungen gelten",
"with values" => "mit den Werten",
"and display rating results in listing?" => "und Bewertungsergebnisse in Liste anzeigen?",
"Show status" => "Zeige Status",
"Default status displayed in list mode" => "Stati, die in der Listenanzeige ausgegeben werden sollen",
"Show status to tracker admin only" => "Status nur dem Tracker-Admin zeigen",
"Send copies of all activity in this tracker to this e-mail address" => "Kopien aller Aktivit&auml;ten dieses Trackers an diese eMail-Adresse schicken",
"Use simplified e-mail format" => "Vereinfachtes eMail-Format benutzen",
"New items are created with status" => "Status neuer Eintr&auml;ge",
"Authoritative status for modified items" => "Authoritiver Status des Trackers wird beim &Auml;ndern des Trackers gesetzt auf",
"No change" => "keine &Auml;nderung",
"Item creator can modify his items?" => "Ersteller kann Eintr&auml;ge &auml;ndern?",
"The tracker needs a user field with the option 1" => "Der Tracker mu&szlig; ein Benutzerfeld mit der Option 1 besitzen",
"Member of the default group of creator can modify items?" => "Mitglieder aus der Standardgruppe des Erstellers d&uuml;rfen Eintr&auml;ge &auml;ndern?",
"The tracker needs a group field with the option 1" => "Der Tracker mu&szlig; ein Gruppenfeld mit der Option 1 besitzen",
"Show creation date when listing tracker items?" => "Erstellungsdatum beim Auflisten von Tracker-Eintr&auml;gen anzeigen?",
"Show lastModif date when listing tracker items?" => "&Auml;nderungsdatum beim Auflisten von Tracker-Eintr&auml;gen anzeigen?",
"What field is used for default sort?" => "Standardfeld f&uuml;r Sortierung",
"What is default sort order in list?" => "Standardsortierung",
"Tracker items allow ratings?" => "Bewertung von Tracker-Eintr&auml;gen erlauben?",
"Tracker items allow comments?" => "Kommentare zu Tracker-Eintr&auml;gen zulassen?",
"and display comments in listing?" => "und Kommentare in Liste anzeigen?",
"Tracker items allow attachments?" => "Anlagen zu Tracker-Eintr&auml;gen zulassen?",
"and display attachments in listing?" => "und Anh&auml;nge in Liste anzeigen?",
"Attachment display options (Use numbers to order items, 0 will not be displayed, and negative values display in popups)" => "Darstellungsoptionen f&uuml;r Anh&auml;nge (Nummern zur Sortierung eintragen, 0 versteckt Felder, bei negativen Eintr&auml;gen erscheinen Popups)",
"Filesize" => "Dateigr&ouml;&szlig;e",
"Filetype" => "Dateityp",
"LongDesc" => "Beschreibung",
"Import/export trackers" => "Tracker im-/exportieren",
"Info" => "Information",
"status" => "Status",
"lastModif" => "&Auml;nderung",
"Admin groups" => "Gruppen verwalten",
"Admin users" => "Benutzer verwalten",
"Add new group" => "Neue Gruppe hinzuf&uuml;gen",
"Edit group" => "Bearbeite Gruppe",
"Add a New Group" => "Eine neue Gruppe hinzuf&uuml;gen",
"List of existing groups" => "Liste vorhandener Gruppen",
"Includes" => "Beinhaltet",
"Include" => "Aufnehmen",
"Group Homepage" => "Gruppen-Homepage",
"Use wiki page name or full URL" => "Wiki-Seitennamen oder volle URL benutzen",
"Edit Item" => "Punkt bearbeiten",
"Members List" => "Mitgliederliste",
"CSV File" => "CSV Datei",
"Add a New User" => "Neuen Benutzer hinzuf&uuml;gen",
"Batch Upload Results" => "Ergebnis Batchupload",
"Rejected users" => "Abgelehnte Benutzer",
"Reason" => "Grund",
"Edit user" => "Benutzerdaten bearbeiten",
"More Criteria" => "Erweiterte Suchoptionen",
"Group (direct)" => "Gruppe (direkt)",
"User Information" => "Benutzer-Information",
"Validate" => "&uuml;berpr&uuml;fen",
"Manage Group Assignments" => "Gruppenzuordnungen bearbeiten",
"Set Default Groups" => "Standardgruppen setzen",
"Assign selected to" => "Markierte hinzuf&uuml;gen zu",
"Remove selected from" => "Markierte l&ouml;schen aus",
"the following groups:" => "den folgenden Gruppen:",
"Set the default group of the selected users to" => "Setzt die Standardgruppe der markierten Benutzer auf",
"Assign to Groups" => "Zu Gruppen hinzuf&uuml;gen",
"Pass" => "Pa&szlig;wort",
"Again" => "Wiederholung",
"Overwrite" => "&Uuml;berschreiben",
"Overwrite but keep the previous login if the login exists in another case" => "&Uuml;berschreibe, aber behalte den vorhergehenden Login wenn der Login in anderer Schreibweise bereits existiert",
"Don't overwrite" => "Nicht &uuml;berschreiben",
"Overwrite groups:" => "Gruppen &uuml;berschreiben:",
"Admin Article Types" => "Artikeltypen verwalten",
"show help" => "Hilfe zeigen",
"Shows up in the drop down list of article types" => "In der Auswahlliste der Typen anzeigen",
"Allow ratings by the author" => "Bewertungen des Autors erlauben",
"Show before publish date" => "Vor dem Ver&ouml;ffentlichungsdatum anzeigen",
"non-admins can view before the publish date" => "Nicht-Admins sehen den Artikel vor dem Ver&ouml;ffentlichungsdatum",
"Show after expire date" => "Nach dem Auslaufdatum anzeigen",
"non-admins can view after the expire date" => "Nicht-Admins sehen den Artikel nach dem Ablaufdatum",
"Heading only" => "nur Kopfteil",
"No article body, heading only" => "Nur den Header ohne den Artikelbody anzeigen",
"Allow comments for this type" => "Kommentare f&uuml;r diesen Typ erlauben",
"Comment Can Rate Article" => "Kommentar darf Artikel bewerten",
"Allow comments to include a rating value" => "Kommentare inklusive Bewertung erlauben",
"Show image" => "Zeige Bild",
"Show topic or own image" => "Thema oder eigenes Bild anzeigen",
"Show avatar" => "Zeige Avatar",
"Show author's avatar" => "Avatar des Autors anzeigen",
"Show author" => "Zeige Autor",
"Show author name" => "Namen des Autors anzeigen",
"Show publish date" => "Zeige Ver&ouml;ffentlichungsdatum",
"Show expire date" => "Zeige Ablaufdatum",
"Show reads" => "Zeige Zugriffe",
"Show the number of times the article was read" => "Anzeigen wie oft der Artikel gelesen wurde",
"Show size" => "Zeige Gr&ouml;&szlig;e",
"Show the size of the article" => "Gr&ouml;&szlig;e des Artikels anzeigen",
"Show topline" => "Introzeile anzeigen",
"Show a small title over the title" => "Kleine Introzeile &uuml;ber der &Uuml;berschrift anzeigen",
"Show subtitle" => "Untertitel anzeigen",
"Show the subtitle" => "Untertitel anzeigen",
"Show source" => "Zeige Quelle",
"Show Image Caption" => "Bildbeschreibung anzeigen",
"Show a legend under the image" => "Legende unter dem Bild anzeigen",
"Show the language" => "Sprache anzeigen",
"Creator can edit" => "Ersteller kann bearbeiten",
"The person who submits an article of this type can edit it" => "Einreicher dieses Artikeltyps d&uuml;rfen diese Artikel &auml;ndern",
"Delete this type" => "Diesen Typ l&ouml;schen (nur wenn keine Artikel dieses Typs vorhanden sind)",
"List of types" => "Liste vorhandener Typen",
"Show lang" => "Sprache anzeigen",
"Review" => "Rezension",
"Classified" => "Vertraulich",
"Create a new type" => "Neuen Typ anlegen",
"Assign permissions to group" => "Gruppenberechtigungen vergeben",
"Group Information" => "Gruppeninformationen",
"Desc" => "Beschreibung",
"level configuration" => "Level-Konfiguration",
"Create level" => "Neue Berechtigungsstufe",
"all permissions in level" => "alle Rechte auf Stufe",
"level" => "Stufe",
"inherited from" => "geeerbt von",
"inherited" => "geerbt",
"Default Group" => "Standardgruppe",
"Assign Perms to this Group" => "Dieser Gruppe Rechte zuweisen",
"Directory batch upload" => "Aus Verzeichnis einlesen",
"Browse gallery" => "Galerie durchsehen",
"Upload from disk" => "Hochladen von Disk",
"available images" => "Bilder vorhanden",
"width" => "Breite",
"height" => "H&ouml;he",
"Remove File Extension from Image Name" => "Dateiendung im Namensfeld entfernen",
"eg. from \"digicam0001.jpg\" then name digicam0001 will be used for the name field" => "z.B. wird von \"digicam0001.jpg\" der Name digicam0001 im Namensfeld benutzt",
"Select a Gallery" => "Ziel-Galerie ausw&auml;hlen",
"Process" => "Prozess",
"Browse file gallery" => "Dateiarchiv durchsehen",
"Please do not use this feature to upload data into the database." => "Mit dieser Funktion bitte keine Daten in die Datenbank laden.",
"available files" => "verf&uuml;gbare Dateien",
"Select a File Gallery" => "Dateiarchiv ausw&auml;hlen",
"Process files" => "Dateien verarbeiten",
"If you want to use images please save the post first and you will be able to edit/post images. Use the &lt;img&gt; snippet to include uploaded images in the textarea editor or use the image URL to include images using the WYSIWYG editor. " => "Falls Sie Bilder benutzen m&ouml;chten speichern Sie bitte den Beitrag und h&auml;ngen Sie dann erst Bilder an. Benutzen Sie das &lt;img&gt; Schnipsel um hochgeladene Bilder einzubinden oder benutzen Sie die Bilder-URL im WYSIWYG-Editor. ",
"Wiki Help" => "Wiki Hilfe",
"Admin Category" => "Kategorien verwalten",
"Watch Only This Category" => "Nur diese Kategorie beobachten",
"Watch This Category and Their Descendants" => "Diese Kategorien und deren Nachfolger beobachten",
"Stop Watching Only This Category" => "Nur diese Kategorie nicht mehr beobachten",
"Stop Watching This Category and Their Descendants" => "Diese Kategorie und deren Nachfolger nicht mehr beobachten",
"Browse in" => "St&ouml;bern in",
"in the current category - and its subcategories: " => "in der aktuellen Kategorie - und in allen Unterkategorien: ",
"Hide subcategories objects" => "Eintr&auml;ge von Unterkategorien verstecken",
"Show subcategories objects" => "Eintr&auml;ge von Unterkategorien anzeigen",
"Clear" => "Zur&uuml;cksetzen",
"Browsing Gallery" => "Galerie ansehen",
"List Galleries" => "Galerien auflisten",
"Edit Gallery" => "Galerie bearbeiten",
"Rebuild Thumbnails" => "Thumbnails neu erzeugen",
"Directory batch" => "Aus Verzeichnis einlesen",
"List Gallery" => "Galerie als Liste zeigen",
"Sort Images by" => "Bilder sortieren nach",
"subgallery" => "Unter-Galerie",
"Subgallery" => "Unter-Galerie",
"Hit" => "Treffer",
"Original Size" => "Originalgr&ouml;&szlig;e",
"rotate right" => "rechts drehen",
"rotate" => "drehen",
"popup" => "Popup",
"Browsing Image" => "Bild ansehen",
"Return to Gallery" => "Zur&uuml;ck zur Galerie",
"Edit Image" => "Bild bearbeiten",
"First Image" => "Erstes Bild",
"Prev Image" => "Vorh. Bild",
"Smaller" => "Kleiner",
"Bigger" => "Gr&ouml;&szlig;er",
"Popup window" => "Popup-Fenser",
"Next Image" => "N&auml;ch. Bild",
"Slideshow Forward" => "Diaschau vorw&auml;rts",
"Last Image" => "Neuestes Bild",
"Stop" => "Anhalten",
"Direction" => "Schreibrichtung",
"Image Name" => "Bildname",
"Image size" => "Bildgr&ouml;sse",
"Image Scale" => "Bildskalierung",
"Latitude (WGS84/decimal degrees)" => "Breitengrad (WGS84/Grad)",
"Longitude (WGS84/decimal degrees)" => "L&auml;ngengrad (WGS84/Grad)",
"Move image" => "Bild verschieben",
"You can view this image in your browser using" => "Sie k&ouml;nnen dieses Bild in Ihrem Browser betrachten",
"You can include the image in an HTML page using one of these lines" => "Das Bild kann wie folgt in eine HTML-Seite eingebunden werden",
"You can include the image in a tiki page using one of these lines" => "Das Bild kann mit den folgenden Zeilen in eine Wikiseite eingebunden werden",
"Group Calendars" => "Gruppenkalender",
"Zoom" => "Zoomen",
"Change Focus" => "Hierher wechseln",
"Hours" => "Stunden",
"Edit Calendar Item" => "Kalendereintrag bearbeiten",
"New Calendar Item" => "Neuer Kalender-Eintrag",
"End" => "Ende",
"Duration" => "Dauer",
"Tentative" => "Unter Vorbehalt",
"Confirmed" => "Zugesagt",
"Cancelled" => "Abgelehnt",
"Location" => "Ort",
"Organized by" => "Organisiert von",
"Roles" => "Rollen",
"Calendar import" => "Kalender importieren",
"Calendar has been updated" => "Kalender wurde aktualisiert",
"import" => "Import",
"Focus:" => "Fokus:",
"Assign permissions to category" => "Berechtigungen zuweisen f&uuml;r Kategorie",
"Current permissions for this category" => "Aktuelle Berechtigungen f&uuml;r diese Kategorie",
"Permission" => "Berechtigung",
"Remove from this Category Only" => "Nur von dieser Kategorie entfernen",
"Remove from this Category &amp; all its Children" => "Von dieser und allen Unterkategorien entfernen",
"Assign permissions" => "Berechtigungen vergeben",
"to group" => "zu Gruppe",
"this category &amp; all its children" => "diese und alle Unterkategorien",
"this category only" => "nur f&uuml;r diese Kategorie",
"Assigning permissions for <b>all children</b> is recommended for best performance." => "f&uuml;r beste Performance werden Berechtigungen f&uuml;r <b>diese und alle Unterkategorien</b> empfohlen",
"Change password enforced" => "Pa&szlig;wortwechsel erzwungen",
"Old password" => "Altes Pa&szlig;wort",
"Again please" => "Bitte nochmal",
"Send a message to us" => "Schick uns eine Nachricht",
"Contact us by email" => "Kontaktiere uns per eMail",
"Click here to send us an email" => "Hier klicken um uns eine eMail zu schicken",
"Contacts" => "Kontakte",
"Create/edit contacts" => "Kontakte hinzuf&uuml;gen/bearbeiten",
"First Name" => "Vorname",
"Last Name" => "Nachname",
"Structure" => "Struktur",
"Top page" => "Top-Seite",
"Tiki Debugger Console" => "Tiki Debug-Konsole",
"Close" => "Schlie&szlig;en",
"Current URL" => "Aktuelle URL",
"Command" => "Befehle",
"exec" => "Ausf&uuml;hren",
"Type <code>help</code> to get list of available commands" => "<code>help</code> f&uuml;r eine Befehls&uuml;bersicht eingeben",
"Add a new site" => "F&uuml;ge neuen Link hinzu",
"You cannot add sites until Directory Categories are setup." => "Links k&ouml;nnen erst hinzugef&uuml;gt werden, wenn Kategorien daf&uuml;r eingerichtet wurden.",
"Please contact the Site Administrator" => "Bitte kontaktieren sie den Administrator der Site.",
"Site added" => "Link hinzugef&uuml;gt",
"Categories:" => "Kategorien:",
"Is valid" => "Ist g&uuml;ltig",
"Directory Administration" => "Linkverzeichnis verwalten",
"There are" => "Es gibt",
"invalid sites" => "ung&uuml;ltige Links",
"valid sites" => "g&uuml;ltige Links",
"Users have visited" => "Benutzer besuchten",
"sites from the directory" => "Links aus dem Verzeichnis",
"Users have searched" => "Benutzer suchten",
"times from the directory" => "mal im Linkverzeichnis",
"Admin sites" => "Links verwalten",
"Admin category relationships" => "Beziehungen zwischen Kategorien verwalten",
"Validate links" => "Links &uuml;berpr&uuml;fen",
"Browse" => "Ansehen",
"Related" => "Verwandt",
"Admin directory categories" => "Verzeichniskategorien verwalten",
"Parent category" => "&Uuml;bergeordnete Kategorie",
"Add a directory category" => "Verzeichniskategorie hinzuf&uuml;gen",
"Edit this directory category" => "Diese Verzeichniskategorie bearbeiten",
"Children type" => "Kind-Typ",
"Most visited sub-categories" => "Meistbesuchte Unterkategorien",
"Category description" => "Kategorie-Beschreibung",
"Random sub-categories" => "Zuf&auml;llige Unterkategorien",
"Maximum number of children to show" => "Maximalzahl der angezeigten Kinder",
"Allow sites in this category" => "Links in dieser Kategorie erlauben",
"Show number of sites in this category" => "Anzahl der Links in dieser Kategorie anzeigen",
"Editor group" => "Editor-Gruppe",
"Subcategories" => "Unterkategorien",
"Admin related categories" => "Verwandte Kategorien verwalten",
"Admin Directory Related " => "Verwandte Kategorien verwalten ",
"Add a related category" => "Verwandte Kategorie hinzuf&uuml;gen",
"Related categories" => "Verwandte Kategorien",
"Admin Directory Sites" => "Links verwalten",
"New Sites" => "Neue Links",
"Cool Sites" => "Coole Links",
"Add a Site" => "Link hinzuf&uuml;gen",
"Add a Category" => "Kategorie hinzuf&uuml;gen",
"any" => "irgendeines",
"in entire directory" => "im gesamten Linkverzeichnis",
"in current category" => "in der ausgew&auml;hlten Kategorie",
"Sort by" => "Sortiere nach",
"name (desc)" => "Name (abst.)",
"name (asc)" => "Name (aufst.)",
"hits (desc)" => "Zugriffen (abst.)",
"hits (asc)" => "Zugriffen (aufst.)",
"creation date (desc)" => "Erstelldatum (abst.)",
"creation date (asc)" => "Erstelldatum (aufst.)",
"last updated (desc)" => "letzte &Auml;nderung (abst.)",
"last updated (asc)" => "letzte &Auml;nderung (aufst.)",
"sort" => "sortieren",
"Added" => "Hinzugef&uuml;gt",
"Last updated" => "Zuletzt aktualisiert",
"Total categories" => "Themen gesamt",
"Total links" => "Links gesamt",
"Links to validate" => "Zu &uuml;berpr&uuml;fende Links",
"Searches performed" => "Durchgef&uuml;hrte Suchauftr&auml;ge",
"Total links visited" => "Besuchte Links gesamt",
"Directory ranking" => "Rang im Verzeichnis",
"Search results" => "Suchergebnisse",
"Validate sites" => "Links &uuml;berpr&uuml;fen",
"Validate Sites" => "Links &uuml;berpr&uuml;fen",
"country" => "Land",
"Edit Article" => "Artikel erstellen/bearbeiten",
"List Articles" => "Artikel auflisten",
"View Articles" => "Beitr&auml;ge ansehen",
"Topline" => "Introzeile",
"Subtitle" => "Untertitel",
"Author Name" => "Autor",
"Own Image" => "Eigenes Bild",
"Use own image" => "Eigenes Bild benutzen",
"Float text around image" => "Text flie&szlig;t um Bilder herum",
"Own image size x" => "Eigene Bildbreite",
"Own image size y" => "Eigene Bildh&ouml;he",
"Image caption" => "Bildbeschreibung",
"Heading" => "Aufmacher",
"Body" => "Text",
"Expiration Date" => "Ablaufdatum",
"Edit or create banners" => "Banner hinzuf&uuml;gen/bearbeiten",
"List banners" => "Banner anzeigen",
"URL to link the banner" => "URL, die mit dem Banner verkn&uuml;pft wird",
"Client" => "Agent",
"Max impressions" => "Max. Aufrufe",
"Show the banner only between these dates" => "Banner nur w&auml;hrend dieser Tage zeigen",
"From date" => "Von Datum",
"To date" => "Bis Datum",
"Use dates" => "Datum benutzen",
"Show the banner only in this hours" => "Banner nur w&auml;hrend dieser Stunden zeigen",
"to" => "bis",
"Show the banner only on" => "Zeige das Banner nur auf",
"Mon" => "Mo",
"Tue" => "Di",
"Wed" => "Mi",
"Thu" => "Do",
"Fri" => "Fr",
"Sat" => "Sa",
"Sun" => "So",
"Select ONE method for the banner" => "EINE Methode f&uuml;r das Banner ausw&auml;hlen",
"Use HTML" => "HTML benutzen",
"HTML code" => "HTML-Code",
"Use image" => "Bild benutzen",
"Image:" => "Bild:",
"Current Image" => "Aktuelles Bild",
"Use image generated by URL (the image will be requested at the URL for each impression)" => "Bild benutzen, das durch die URL erzeugt wird (das Bild wird bei jedem Aufruf der URL angefordert)",
"Use text" => "Text benutzen",
"Save the Banner" => "Das Banner speichern",
"Edit Blog" => "Blog bearbeiten",
"Create Blog" => "Blog erstellen",
"Current heading" => "Aktueller Kopfbereich",
"There are individual permissions set for this blog" => "Es gibt individuelle Berechtigungen f&uuml;r dieses Blog",
"Number of posts to show" => "Anzahl der anzuzeigenden Eintr&auml;ge",
"Allow other user to post in this blog" => "Anderer Benutzer darf in dieses Blog eintragen",
"Use titles in blog posts" => "&Uuml;berschriften in Blog-Eintr&auml;gen verwenden",
"Allow search" => "Suchen erlauben",
"Allow comments" => "Kommentare erlauben",
"Show user avatar" => "Zeige Benutzer-Avatar",
"Blog heading" => "Blog Kopfbereich",
"Edit Style Sheet" => "Stylesheet bearbeiten",
"Style Sheet" => "Stylesheet",
"choose a stylesheet" => "Stylesheet ausw&auml;hlen",
"Try" => "Ausprobieren",
"File with names appended by -{\$user} are modifiable, others are only duplicable and be used as model." => "Dateien mit angeh&auml;ngtem -{\$user} sind editierbar, andere sind schreibgesch&uuml;tzt, aber als Vorlage verwendbar.",
"Show Plugins Help" => "Zeige PlugIn Hilfe",
"some text" => "Ein Text",
"Creates a box with the data" => "Erzeugt eine Box mit den Daten",
"Box content" => "Box-Inhalt",
"Title bar" => "Titelbalken",
"creates a title bar" => "erzeugt einen Titelbalken",
"Colored text" => "Farbiger Text",
"Lists" => "Listen",
"for bullet lists" => "f&uuml;r einfache Listen",
"for numbered lists" => "f&uuml;r numerierte Listen",
"for definiton lists" => "f&uuml;r Definitionslisten",
"Headings" => "&Uuml;berschriften",
"Show/Hide" => "Ein-/Ausblenden",
"Tables" => "Tabellen",
"creates a table" => "erzeugt eine Tabelle",
"makes a horizontal rule" => "erzeugt einen horizontalen Balken",
"Wiki References" => "Wiki-Referenzen",
"JoinCapitalizedWords or use" => "ZusammenGrossKleinSchreibung oder benutzen Sie",
"page|desc" => "Seite|Beschr.",
"for wiki references" => "f&uuml;r Wiki-Referenzen",
"SomeName" => "EinName",
"prevents referencing" => "verhindert Referenzierung",
"External links" => "Externe Links",
"displays an image" => "zeigt ein Bild an",
"Non cacheable images" => "Ungecachte Bilder",
"height width desc link and align are optional" => "height width desc link und align sind optional",
"creates the editable drawing foo" => "erzeugt die bearbeitbare Zeichnung foo",
"Multi-page pages" => "Mehrseitige Seiten",
"Wiki File Attachments" => "Wiki Dateianh&auml;nge",
"RSS feeds" => "RSS-Feeds",
"displays rss feed with id=n maximum=m items" => "RSS-Feed mit id=n maximum=m Eintr&auml;gen",
"Will be replaced by the actual value of the dynamic content block with id=n" => "Wird mit dem tats&auml;chlichen Wert des dynamischen Inhaltsblocks mit id=n ersetzt",
"Dynamic variables" => "Dynamische Variablen",
"Non parsed sections" => "Nicht geparste Bereiche",
"Preformated sections" => "Vorformatierte Bereiche",
"Square Brackets" => "Eckige Klammern",
"Use [[foo] to show [foo]." => "[[foo] benutzen, damit [foo] ausgegeben wird.",
"Block Preformatting" => "Block Vorformatierung",
"Misc" => "Verschiedenes",
"Show Text Formatting Rules" => "Zeige Textformatierungs-Regeln",
"No description available" => "Keine Beschreibung vorhanden.",
"bold" => "fett",
"italic" => "kursiv",
"underline" => "unterstreichen",
"table" => "Tabelle",
"external link" => "externen Verweis",
"heading1" => "&Uuml;berschrift1",
"title bar" => "Titelbalken",
"box" => "Box",
"rss feed" => "RSS-Feed",
"dynamic content" => "Dynamischer Inhalt",
"tagline" => "Tagline",
"center text" => "Text zentrieren",
"colored text" => "Farbiger Text",
"dynamic variable" => "dynamische Variable",
"special chars" => "Sonderzeichen",
"special characters" => "Sonderzeichen",
"Browse Images" => "Bild betrachten",
"Edit successful!" => "Bearbeitung erfolgreich!",
"The following image was successfully edited" => "Das folgende Bild wurde erfolgreich bearbeitet",
"Image Description" => "Bildbeschreibung",
"Edit and create Languages" => "Sprachen erstellen/bearbeiten",
"Im- Export Languages" => "Sprachen im/exportieren",
"Edit and create languages" => "Sprachen erstellen/bearbeiten",
"Create Language" => "Sprache erstellen",
"Shortname" => "Kurzname",
"like" => "wie",
"Longname" => "Voller Name",
"Select the language to edit" => "Zu bearbeitende Sprache ausw&auml;hlen",
"Add a translation" => "&Uuml;bersetzung hinzuf&uuml;gen",
"Edit translations" => "&Uuml;bersetzungen bearbeiten",
"Translate recorded" => "Aufgezeichnetes &uuml;bersetzen",
"Translate" => "&uuml;bersetzen",
"reset table" => "Tabelle zur&uuml;cksetzen",
"Program dynamic content for block" => "Dynamischen Inhalt f&uuml;r den Block programmieren",
"Create New Block" => "Neuen Block erzeugen",
"Return to block listing" => "Zur&uuml;ck zur Block-Auflistung",
"Block description: " => "Blockbeschreibung: ",
"You are editing block:" => "Sie bearbeiten Block:",
"Publishing date" => "Ver&ouml;ffentlichungsdatum",
"Publishing Date" => "Ver&ouml;ffentlichungsdatum",
"Quiz Stats" => "Quiz-Statistik",
"This Quiz Stats" => "Statistik f&uuml;r dieses Quiz",
"Edit this Quiz" => "Dieses Quiz bearbeiten",
"Admin Quizzes" => "Quiz verwalten",
"Create/edit options for question" => "Optionen f&uuml;r Frage erstellen/bearbeiten",
"points" => "Punkte",
"Admin quizzes" => "Quiz verwalten",
"Create/edit quizzes" => "Quiz hinzuf&uuml;gen/bearbeiten",
"There are individual permissions set for this quiz" => "F&uuml;r dieses Quiz gibt es individuelle Berechtigungen",
"Quiz can be repeated" => "Quiz kann wiederholt werden",
"Store quiz results" => "Quiz-Ergebnisse abspeichern",
"Questions per page" => "Fragen pro Seite",
"Quiz is time limited" => "Ratezeit ist limitiert",
"Maximum time" => "Maximale Zeit",
"canRepeat" => "wiederholbar",
"timeLimit" => "ZeitLimit",
"Results" => "Ergebnisse",
"Edit quiz questions" => "Quiz-Fragen bearbeiten",
"Create/edit questions for quiz" => "Fragen f&uuml;r Quiz erstellen/bearbeiten",
"maxScore" => "maxPunktzahl",
"From Points" => "von Punkten",
"To Points" => "zu Punkten",
"Answer" => "Antwort",
"Modify Structure" => "Struktur ver&auml;ndern",
"Remove only from structure" => "Nur aus Struktur entfernen",
"Remove from structure and remove page too" => "Aus Struktur und von Seite entfernen",
"Structure Layout" => "Struktur Layout",
"Previous" => "Vorherige",
"Current Node" => "Aktueller Knoten",
"Page alias" => "Seitenalias",
"Add pages to current node" => "Seiten zu aktuellem Knoten hinzuf&uuml;gen",
"After page" => "Nach Seite",
"Create Page" => "Seite erstellen",
"Use pre-existing page" => "Vorhandene Seite verwenden",
"List Submissions" => "Einreichungen auflisten",
"EditTemplates" => "Vorlagen bearbeiten",
"Template listing" => "Vorlagenliste",
"Available templates" => "Verf&uuml;gbare Templates",
"Save Only in the Theme:" => "Nur f&uuml;r diesen Style speichern:",
"Edit a topic" => "Thema bearbeiten",
"The object is already in the set of translations" => "Das Objekt ist bereits als &Uuml;bersetzung gespeichert",
"Use rating" => "Bewertung erlauben",
"There is no available poll template." => "Kein Bewertungstemplate vorhanden.",
"You should ask an admin to create them." => "Du solltest den Admin bitten, eines anzulegen",
"votes" => "Stimmen",
"Replace to" => "Ersetzen mit",
"Case Insensitivity" => "Gro&szlig;- und Kleinschreibung nicht beachten",
"Import HTML" => "HTML importieren",
"Try to convert HTML to wiki" => "Versuche HTML in Wiki zu konvertieren",
"Lock this page" => "Diese Seite sperren:",
"Admin FAQ" => "FAQ verwalten",
"View FAQ" => "FAQ anzeigen",
"Edit this FAQ" => "Diese FAQ bearbeiten",
"New Question" => "Neue Frage",
"Use a question from another FAQ" => "Eine Frage aus einer anderen FAQ benutzen",
"FAQ questions" => "FAQ-Fragen",
"Suggested questions" => "Vorgeschlagene Fragen",
"Approve" => "Freigeben",
"No suggested questions" => "Keine vorgeschlagenen Fragen",
"Upload File" => "Datei hochladen",
"Browse Gallery" => "Galerie anzeigen",
"Create New File Gallery" => "Neues Dateiarchiv anlegen",
"You can access the file gallery using the following URL" => "Sie k&ouml;nnen das Dateiarchiv unter der folgenden URL erreichen",
"Message queue for" => "Nachrichten-Liste f&uuml;r",
"back to forum" => "zur&uum;ck zum Forum",
"Edit queued message" => "Nachrichten-Liste bearbeiten",
"make this a thread of" => "Hieraus einen Thread machen von",
"None, this is a thread message" => "nichts, dies ist eine Thread-Nachricht",
"summary" => "Zusammenfassung",
"announce" => "Annoncieren",
"no feeling" => "gleichg&uuml;ltig",
"frown" => "verdutzt",
"exclaim" => "ausrufend",
"idea" => "Idee",
"mad" => "sauer",
"sad" => "traurig",
"happy" => "fr&ouml;hlich",
"wink" => "winkend",
"Save and Approve" => "Speichern und freigeben",
"convert to topic" => "in Thema konvertieren",
"List of messages" => "Nachrichtenliste",
"New Topic" => "Neues Thema",
"no summary" => "keine Zusammenfassung",
"No messages queued yet" => "Es stehen keine Nachrichten an",
"Reported messages for" => "Gemeldete Beitr&auml;ge f&uuml;r",
"Reported by" => "Gemeldet von",
"Request Time" => "Anfrage vom",
"Accept" => "Annehmen",
"Refuse" => "Ablehnen",
"Waiting requests" => "Laufende Anfragen",
"Your friends" => "Ihre Freunde",
"Activity completed" => "Aktivit&auml;t erfolgreich beendet",
"Admin process activities" => "Prozessaktivit&auml;ten verwalten",
"Add or edit an activity" => "Aktivit&auml;t hinzuf&uuml;gen/bearbeiten",
"activity" => "Aktivit&auml;t",
"interactive" => "interaktiv",
"Years" => "Jahre",
"Months" => "Monate",
"Minutes" => "Minuten",
"Add transitions" => "&Uuml;berg&auml;nge hinzuf&uuml;gen",
"Add transition from:" => "&Uuml;bergang hinzuf&uuml;gen von:",
"Add transition to:" => "&Uuml;bergang hinzuf&uuml;gen nach:",
"No roles associated to this activity" => "Keine Rollen mit dieser Aktivit&auml;t verbunden",
"Add Role" => "Rolle hinzuf&uuml;gen",
"Add New" => "Neu hinzuf&uuml;gen",
"Process activities" => "Prozessaktivit&auml;ten",
"Interactive" => "Interaktiv",
"Automatic" => "Automatisch",
"Manual" => "Manuell",
"inter" => "Interaktiv",
"(no roles)" => "(keine Rollen)",
"Code" => "Quellcode",
"No activities defined yet" => "Noch keine Aktivit&auml;ten definiert",
"Process Transitions" => "Prozess&uuml;berg&auml;nge",
"List of transitions" => "&Uuml;bergangsliste",
"From:" => "Von:",
"No transitions defined yet" => "Keine &Uuml;berg&auml;nge definiert",
"Add a transition" => "&Uuml;bergang hinzuf&uuml;gen",
"This process is invalid" => "Dieser Prozess ist ung&uuml;ltig",
"List of processes" => "Prozessliste",
"Inactive" => "inaktiv",
"act" => "Aktion",
"val" => "aktiv",
"Active Process" => "Aktiver Prozess",
"Invalid Process" => "Ung&uuml;ltiger Prozess",
"Valid Process" => "G&uuml;ltiger Prozess",
"Activities" => "Aktivit&auml;ten",
"No processes defined yet" => "Noch keine Prozesse definiert.",
"Admin instance" => "Instanzen verwalten",
"Process:" => "Prozess:",
"Instance" => "Instanz",
"exception" => "Fehler",
"completed" => "erledigt",
"Aborted" => "Abgebrochen",
"Owner" => "Besitzer",
"Don't move" => "Nicht verschieben",
"Started" => "Gestartet",
"Act status" => "Act Status",
"Ended" => "Beendet",
"run instance" => "Instanz starten",
"Add or edit a process" => "Prozess hinzuf&uuml;gen/bearbeiten",
"Process Name" => "Prozessname",
"ver:" => "Version:",
"is active?" => "ist aktiv?",
"Or upload a process using this form" => "Oder Prozess &uuml;ber dieses Formular hochladen",
"Admin process roles" => "Prozess-Rollen verwalten",
"Add or edit a role" => "Rolle hinzuf&uuml;gen/bearbeiten",
"Process roles" => "Prozess-Rollen",
"No roles defined yet" => "Keine Rollen definiert",
"Map users to roles" => "User zu Rollen zuordnen",
"Map" => "Karte",
"map" => "zuordnen",
"Map groups to roles" => "Gruppen zu Rollen zuordnen",
"Warning" => "Warnung",
"No roles are defined yet so no roles can be mapped" => "Keine Rollen definiert, daher keine Zuordnungen m&ouml;glich",
"List of mappings" => "Zuordnungen",
"No mappings defined yet" => "Keine Zuordnungen definiert",
"Admin process sources" => "Prozess-Quellcode verwalten",
"select source" => "Quellcode ausw&auml;hlen",
"Set next user" => "Setze n&auml;chsten Benutzer",
"Map process roles" => "Prozess-Rollen zuordnen",
"Admin Processes" => "Prozesse verwalten",
"Admin Activities" => "Aktivit&auml;ten verwalten",
"Admin Roles" => "Rollen verwalten",
"Edit this Process" => "Prozess bearbeiten",
"List of activities" => "Aktivit&auml;tsliste",
"Proc" => "Prozesse",
"auto" => "Automatisch",
"int" => "Interaktiv",
"routing" => "Routing",
"Instances" => "Instanzen",
"run" => "starten",
"run activity" => "Aktivit&auml;t starten",
"Monitor" => "&Uuml;berwachen",
"monitor processes" => "Prozesse &uuml;berwachen",
"monitor activities" => "Aktivit&auml;ten &uuml;berwachen",
"monitor instances" => "Instanzen &uuml;berwachen",
"monitor workitems" => "Workitems &uuml;berwachen",
"List of instances" => "Instanzliste",
"No instances created yet" => "noch keine Instanzen erstellt",
"processes" => "Prozesse",
"being run" => "ausgef&uuml;hrt",
"Completed" => "Erledigt",
"Exceptions" => "Fehler",
"instance" => "Instanz",
"My activities" => "Meine Aktivit&auml;ten",
"Current Activity" => "Aktuelle Aktivit&auml;t",
"Assigned To" => "Zugewiesen zu Benutzer",
"abort instance" => "Instanz abbrechen",
"release instance" => "Instanz freigeben",
"No activities found" => "Keine Aktivit&auml;ten gefunden",
"My instances" => "Meine Instanzen",
"No instances found" => "Keine Instanzen gefunden",
"User Activities" => "Benutzeraktivit&auml;ten",
"process" => "Prozess",
"user processes" => "Benutzer-Prozesse",
"user activities" => "Benutzer-Aktivit&auml;ten",
"user instances" => "Benutzer-Instanzen",
"No instances defined yet" => "Noch keine Instanzen definiert.",
"Create New Gallery" => "Neue Galerie anlegen",
"Create a gallery" => "Neue Galerie anlegen",
"Edit this gallery:" => "Diese Galerie bearbeiten:",
"There are individual permissions set for this gallery" => "F&uuml;r diese Galerie gibt es individuelle Berechtigungen",
"Geographic" => "Geographisch",
"Fields to show during browsing the gallery" => "Angezeigte Felder beim Durchst&ouml;bern der Galerie",
"Image ID" => "Bild-ID",
"Creation Date" => "Erstelldatum",
"Gallery Image" => "Galerie Logo",
"Available scales" => "Verf&uuml;gbare Skalierungen",
"No scales available" => "Keine Skalierungen verf&uuml;gbar",
"Original image is default scale" => "Originalbild ist die Standard-Skalierung",
"Add scaled images with bounding box of square size" => "Skalierte Bilder in Box anzeigen, Kantenl&auml;nge",
"Other users can upload images to this gallery" => "Andere Benutzer k&ouml;nnen Bilder in diese Galerie hochladen",
"You can access the gallery using the following URL" => "Sie k&ouml;nnen die Galerie &uuml;ber folgende URL erreichen",
"Available Galleries" => "Verf&uuml;gbare Galerien",
"Choose a filter" => "Filter w&auml;hlen",
"Imgs" => "Bilder",
"Landscape" => "Gestalten",
"Im- Export languages" => "Sprachen im/exportieren",
"Select the language to Import" => "Sprache f&uuml;r Import w&auml;hlen",
"Select the language to Export" => "Sprache f&uuml;r Export w&auml;hlen",
"Overwrite existing pages if the name is the same" => "&Uuml;berschreibe vorhandene Seiten, falls der Name gleich ist",
"Previously remove existing page versions" => "Zuvor vorhandene Seitenversionen entfernen",
"excerpt" => "Auszug",
"Result" => "Ergebnis",
"Install" => "Installieren",
"Clear cached version and refresh cache" => "Cache aktualisieren",
"configure rules" => "Regeln konfigurieren",
"Edit Repository" => "Repository bearbeiten",
"Search by Date" => "Suche nach Datum",
"LastChanges" => "Letzte&Auml;nderungen",
"Rollback" => "Zur&uuml;ckgerollt",
"Pages like" => "&Auml;hnliche Seiten",
"No pages found" => "Keine Seiten gefunden",
"Edit New Article" => "Neuen Artikel erstellen",
"ExpireDate" => "Ablaufdatum",
"AuthorName" => "Autor",
"Create banner" => "Banner erstellen",
"Method" => "Methode",
"Use Dates?" => "Datum benutzen?",
"Max Impressions" => "Max Aufrufe",
"Impressions" => "Aufrufe",
"Clicks" => "Klicks",
"Create New Blog" => "Neuen Blog anlegen",
"Admin Cache" => "Cache verwalten",
"Dynamic content system" => "Dynamischer Inhalt",
"Available content blocks" => "Verf&uuml;gbare Inhaltsbl&ouml;cke",
"Current ver" => "Aktuelle Ver.",
"Next ver" => "N&auml;chste Ver.",
"Program" => "Programm",
"Edit this FAQ:" => "Diese FAQ bearbeiten:",
"Create new FAQ" => "Neue FAQ erstellen",
"Create New FAQ:" => "Neue FAQ erstellen:",
"Users can suggest questions" => "Benutzer k&ouml;nnen Fragen vorschlagen",
"Available FAQs" => "Verf&uuml;gbare FAQs",
"Create a file gallery" => "Dateiarchiv anlegen",
"Gallery Images" => "Galerie-Bilder",
"All games are from" => "Alle Spiele von",
"visit the site for more games and fun" => "Besuchen Sie die Site f&uuml;r weitere Spiele und Unterhaltung.",
"Upload a game" => "Ein Spiel hochladen",
"Upload a new game" => "Ein neues Spiel hochladen",
"Thumbnail (if the game is foo.swf the thumbnail must be named foo.swf.gif or foo.swf.png or foo.swf.jpg)" => "Thumbnail (Wenn das Spiel foo.swf hei&szlig;t, muss der Thumbnail foo.swf.gif, foo.swf.png oder foo.swf.jpg hei&szlig;en)",
"Edit game" => "Spiel bearbeiten",
"Played" => "Gespielt",
"times" => "mal",
"If you can't see the game then you need a flash plugin for your browser" => "Wenn Sie das Spiel nicht sehen k&ouml;nnen, ben&ouml;tigen Sie ein Flash-Plugin f&uuml;r Ihren Browser.",
"Blog Title" => "Blog-Titel",
"Edit New Submission" => "Neue Einreichung bearbeiten",
"Survey stats" => "Umfragen-Statistik",
"users registered" => "registrierte Benutzer",
"Distance (km)" => "Entfernung (km)",
"List Movies" => "Filme auflisten",
"Choose a movie" => "Film ausw&auml;hlen",
"Last mod" => "letzte Mod.",
"Last author" => "Letzter Autor",
"unlocked" => "entsperrt",
"Open client window" => "Clientfenster &ouml;ffnen",
"Generate HTML" => "",
"Transcripts" => "Logb&uuml;cher",
"Support tickets" => "Support-Ticket",
"Online operators" => "Operatoren online",
"Accepted requests" => "Bearbeitete Anfragen",
"transcripts" => "Logs",
"Offline operators" => "Abwesende Operatoren",
"Add an operator to the system" => "Neuen Operator hinzuf&uuml;gen",
"Operators must be tiki users" => "Operatoren m&uuml;ssen Tiki Benutzer sein",
"Set as Operator" => "Als Operator hinzuf&uuml;gen",
"Chat started" => "Chat begonnen",
"Live support:User window" => "Online-Support: Benutzerfenster",
"Request live support" => "Live Support-Anfrage stellen",
"Request support" => "Supportanfrage stellen",
"Open a support ticket instead" => "Stattdessen ein Support-Ticket erstellen",
"Your request is being processed" => "Ihre Anfrage wird bearbeitet",
"cancel request and exit" => "Anfrage abbrechen und verlassen",
"cancel request and leave a message" => "Anfrage abbrechen und Nachricht hinterlassen",
"Live support:Console" => "Live Support: Konsole",
"be online" => "online gehen",
"be offline" => "offline gehen",
"Support requests" => "Support-Anfragen",
"Join" => "Beitreten",
"Support chat transcripts" => "Support Chat-Logb&uuml;cher",
"back to admin" => "zur&uuml;ck zur Verwaltung",
"started" => "gestartet",
"reason" => "Grund",
"Transcript" => "Logbuch",
"Prefs" => "Konfig.",
"Remove old events" => "Alte Termine l&ouml;schen",
"duration" => "Dauer",
"Mini Calendar: Preferences" => "Mini-Kalender: Einstellungen",
"Calendar Interval in daily view" => "Kalender Intervall in Tagesansicht",
"Start hour for days" => "Tag beginnt um",
"End hour for days" => "Tag endet um",
"Reminders" => "Erinnerungen",
"no reminders" => "keine Erinnerungen",
"Or enter path or URL" => "Oder Pfad oder URL eingeben",
"Add Topic" => "Thema hinzuf&uuml;gen",
"Tikiwiki Mods" => "Tiki Mods",
"Mods Configuration" => "Mod Konfiguration",
"Update remote index" => "Remote Index aktualisieren",
"Rebuild local list" => "Lokale Liste aktualisieren",
"Republish all" => "alle wiederver&ouml;ffentlichen",
"Publish all" => "alle ver&ouml;ffentlichen",
"Unpublish all" => "alle nicht ver&ouml;ffentlichen",
"Attention" => "Achtung",
"all types" => "alle Typen",
"Tikiwiki Mods Configuration" => "Tiki Mod Konfiguration",
"Enable Mods providing" => "Mod Verteilung aktivieren",
"Mods local directory" => "Lokales Mod Verzeichnis",
"Mods remote server" => "Mod Remote Server",
"User Pages" => "Benutzer-Seiten",
"y" => "j",
"User Galleries" => "Benutzer-Galerien",
"Assigned items" => "Zugewiesene Eintr&auml;ge",
"Unread Messages" => "Ungelesene Nachrichten",
"User Blogs" => "Benutzer-Blogs",
"MyFiles" => "MeineDateien",
"Subscribe" => "Abonnieren",
"Thanks for your subscription. You will receive an email soon to confirm your subscription. No newsletters will be sent to you until the subscription is confirmed." => "Vielen Dank f&uuml;r Ihr Abonnenment. Sie werden in K&uuml;rze eine eMail zur Best&auml;tigung Ihres Abonnements erhalten. Vor einer Best&auml;tigung Ihres Abonnements wird Ihnen kein Newsletter zugesandt.",
"Your email address was removed from the list of subscriptors." => "Ihre Mail-Adresse wurde von der Liste der Abonnementen entfernt.",
"Subscription confirmed!" => "Abonnement best&auml;tigt!",
"Subscribe to Newsletter" => "Newsletter abonnieren",
"Subscribe to This Newsletter" => "Abonnieren",
"Available Newsletters" => "Verf&uuml;gbare Newsletter",
"Select news group" => "Newsgroup ausw&auml;hlen",
"Back to servers" => "Zur&uuml;ck zur Server&uuml;bersicht",
"Msgs" => "Nachrichten",
"Back to groups" => "Zur&uuml;ck zu Gruppen",
"Save position" => "Position speichern",
"Reading article from" => "Artikel lesen aus",
"Back to list of articles" => "Zur&uuml;ck zur Artikel&uuml;bersicht",
"First" => "Erste",
"Configure news servers" => "Newsserver-Konfiguration",
"Configure Newsreader" => "Newsreader konfigurieren",
"Select a news server to browse" => "Auswahl des Newsservers",
"server" => "Server",
"News server" => "Newsserver",
"Notes" => "Notizen",
"Write a note" => "Notiz schreiben",
"quota" => "Quota",
"No notes yet" => "Noch keine Notizen vorhanden.",
"Merge selected notes into" => "Notizen verschmelzen mit",
"Reading note:" => "Lese Notiz:",
"List notes" => "Notizen auflisten",
"Write note" => "Notiz schreiben",
"Assign permissions to " => "Berechtigungen vergeben f&uuml;r ",
"Back" => "Zur&uuml;ck",
"Current permissions for this object" => "Aktuelle Berechtigungen f&uuml;r dieses Objekt",
"No category permissions; global permissions apply" => "Keine Kategorieberechtigungen vergeben; Globale Berechtigungen greifen",
"Assign permissions to this object" => "Diesem Objekt Berechtigungen zuweisen",
"Published" => "Ver&ouml;ffentlicht",
"Orphan Pages" => "Verwaiste Seiten",
"Browser not supported" => "Browser wird nicht unterst&uuml;tzt",
"s=source" => "s=Quellcode",
"b=rollback" => "b=Rollback",
"Side-by-side diff" => "Side-By-Side Vergleich",
"Side-by-side diff by characters" => "Side-By-Side Vergleich nach Zeichen",
"Inline diff" => "Zeilenvergleich",
"Inline diff by characters" => "Zeilenvergleich nach Zeichen",
"Full side-by-side diff by characters" => "Kompletter Side-By-Side Vergleich nach Zeichen",
"Full inline diff" => "Kompletter Zeilenvergleich",
"Full inline diff by characters" => "Kompletter Zeilenvergleich nach Zeichen",
"Pick your avatar" => "W&auml;hlen Sie Ihren Avatar",
"User Preferences" => "Benutzer-Einstellungen",
"Your current avatar" => "Ihr momentaner Avatar",
"no avatar" => "keinen Avatar benutzen",
"reset" => "zur&uuml;cksetzen",
"Pick avatar from the library" => "W&auml;hle Avatar aus der Bibliothek",
"Pick user Avatar" => "Nutzer-Avatar ausw&auml;hlen",
"Hide all" => "Alles verbergen",
"icons" => "Icons",
"Show all" => "Zeige alles",
"Avatar Image" => "Avatar Bild",
"Upload your own avatar" => "Eigenen Avatar hochladen",
"atts" => "Anh&auml;nge",
"List Attachments" => "Anh&auml;nge auflisten",
"View Results" => "Ergebnisse anschauen",
"Other Polls" => "Andere Abstimmungen",
"Note: Remember that this is only a preview, and has not yet been saved!" => "Hinweis: Dies ist nur eine Vorschau und wurde noch nicht gespeichert!",
"Print multiple pages" => "Mehrere Seiten drucken",
"Quiz result stats" => "Quiz-Ergebnis-Statistik",
"Time" => "Zeit",
"User answers" => "Benutzerantworten",
"Stats for quizzes" => "Statistik f&uuml;r die Quiz",
"taken" => "teilgenommen",
"Av score" => "durchschn. Punktzahl",
"Av time" => "durchschn. Zeit",
"Stats for quiz" => "Statistik f&uuml;r das Quiz",
"Clear Stats" => "Statistiken zur&uuml;cksetzen",
"Stats for this quiz Questions " => "Statistik f&uuml;r die Fragen in diesem Quiz ",
"Average" => "Durchschnitt",
"Received Articles" => "Erhaltene Artikel",
"Edit received article" => "Empfangenen Artikel bearbeiten",
"Use Image" => "Bild benutzen",
"Image x size" => "Bildbreite",
"Image y size" => "Bildh&ouml;he",
"Image name" => "Bildname",
"Accept Article" => "Artikel annehmen",
"Site" => "Link",
"A valid email is mandatory to register" => "Zum Registrieren ist eine g&uuml;ltige eMail-Adresse n&ouml;tig.",
"Tiki site registered" => "Tiki Site registriert",
"The following site was added and validation by admin may be needed before appearing on the lists" => "Folgende Site wurde hinzugef&uuml;gt. Der Link erscheint erst nach &Uuml;berpr&uuml;fung des Administrators in der Liste",
"You don't have permission to use this feature." => "Keine Berechtigung zur Nutzung dieser Funktion vorhanden.",
"Register this site at tikiwiki.org" => "Diese Site auf tikiwiki.org registrieren",
"Read this first!" => "Bitte lesen!",
"On this page you can make your tiki site known to tikiwiki.org. It will get shown there in a list of known tiki sites." => "Hier k&ouml;nnen Sie Ihre Site bei tikiwiki.org bekanntmachen. Dort wird sie in die Liste der bekannten Tiki-Sites eingetragen.",
"Registering is voluntary." => "Die Registrierung ist freiwillig.",
"Registering does not give you any benefits except one more link to your site." => "Eine Registrierung bringt keine Vorteile au&szlig;er einen zus&auml;tzlichen Link auf die Site.",
"You don't get any emails, we don't sell the data about your site." => "Sie bekommen keine eMails und wir verkaufen auch keine Daten. :)",
"Registering is just for us to get an overview of Tiki's usage." => "Die Registrierung hilft uns einen kleinen &Uuml;berblick &uuml;ber die Nutzung von Tiki zu gewinnen.",
"If your site is private or inside your intranet, you should not register!" => "Wenn ihre Tiki Site rein privat oder nur in ihrem Intranet zu erreichen ist, tragen sie ihre Site bitte nicht ein!",
"Information about your site" => "Informationen zu Ihrer Site",
"Send me my Password" => "Mein Pa&szlig;wort senden",
"Return to HomePage" => "Zur&uuml;ck zur Hauptseite",
"Remove page" => "Seite entfernen",
"Last Version" => "Neueste Version",
"You are about to remove the page" => "Sie dabei, die Seite zu entfernen",
"permanently" => "permanent",
"Remove all versions of this page" => "Alle Versionen dieser Seite entfernen",
"Rename page" => "Seite umbenennen",
"Rollback page" => "Rollback-Seite",
"to_version" => "zu_Version",
"Search Stats" => "Suchstatistik",
"Searched" => "Gesucht",
"Search in" => "Suche in",
"Simple search" => "Einfache Suche",
"No pages matched the search criteria" => "Keine passenden Seiten zum Suchkriterium",
"Send blog post" => "Sende Blog-Eintrag",
"A link to this post was sent to the following addresses:" => "Ein Link auf diesen Eintrag wurde an folgende Adressen verschickt:",
"Send post to this addresses" => "Eintrag an diese Adressen verschicken",
"List of email addresses separated by commas" => "Liste der eMail-Adressen (kommagetrennt)",
"referenced by" => "Referenzen",
"references" => "Verweise",
"Send objects" => "Objekte senden",
"Transmission results" => "&Uuml;bertragungsergebnisse",
"Send Wiki Pages" => "Wiki-Seiten senden",
"Send Articles" => "Artikel senden",
"Add Article" => "Artikel hinzuf&uuml;gen",
"Send objects to this site" => "Objekte an diese Site senden",
"Tiki Shoutbox" => "Tiki-Shoutbox",
"Change shoutbox general settings" => "Shoutbox-Einstellungen &auml;ndern",
"auto-link urls" => "autom. URLs in Links wandeln",
"Post or edit a message" => "Eine Nachricht posten oder bearbeiten",
"Click to Navigate" => "Zum Navigieren anklicken",
"big grin" => "grinsend",
"confused" => "verwirrt",
"cry" => "weinend",
"eek" => "erschrocken",
"evil" => "b&ouml;se",
"lol" => "lachend",
"smile" => "l&auml;chelnd",
"surprised" => "&uuml;berrascht",
"arrow" => "Pfeil",
"Most viewed objects" => "Meist besuchte Objekte (gesamt)",
"Most viewed objects in the last 7 days" => "Meist besuchte Objekte der letzten 7 Tage",
"Site Stats" => "Site-Statistik",
"Days online" => "Tage online",
"Total pageviews" => "Besuche gesamt",
"Average pageviews per day" => "Durchschn. Besuche pro Tag",
"pvs" => "Besuche",
"Best day" => "Bester Tag",
"Worst day" => "Schlechtester Tag",
"Wiki Stats" => "Wiki-Statistik",
"Size of Wiki Pages" => "Gr&ouml;sse der Wiki-Seiten",
"Mb" => "MB",
"Average page length" => "Durchschn. Seitenl&auml;nge",
"Average versions per page" => "Durchschn. Versionen pro Seite",
"Visits to wiki pages" => "Besuche auf Wiki-Seiten",
"Average links per page" => "Durchschn. Links pro Seite",
"Image galleries Stats" => "Bildergalerie-Statistik",
"Average images per gallery" => "Durchschn. Bilder pro Galerie",
"Total size of images" => "Gr&ouml;&szlig;e der Bilder gesamt",
"Average image size" => "Durchschn. Bildgr&ouml;&szlig;e",
"Visits to image galleries" => "Besuche in Bildergalerien",
"File galleries Stats" => "Dateiarchiv-Statistik",
"Average files per gallery" => "Durchschn. Dateien pro Archiv",
"Total size of files" => "Gr&ouml;&szlig;e der Dateien gesamt",
"Average file size" => "Durchschn. Dategr&ouml;&szlig;e",
"Visits to file galleries" => "Besuche in Dateiarchiven",
"CMS Stats" => "CMS-Statistik",
"Total reads" => "Zugriffe insgesamt",
"Average reads per article" => "Durchschn. Zugriffe pro Artikel",
"Total articles size" => "Artikel Gr&ouml;&szlig;e gesamt",
"Average article size" => "Durchschn. Artikelgr&ouml;&szlig;e",
"Forum Stats" => "Foren-Statistik",
"Total topics" => "Themen gesamt",
"Average topics per forums" => "Durchschn. Themen pro Forum",
"Visits to forums" => "Besuche in Foren",
"Blog Stats" => "Blog-Statistik",
"Weblogs" => "Blogs",
"Total posts" => "Posts gesamt",
"Average posts per weblog" => "Durchschn. Eintr&auml;ge pro Blog",
"Total size of blog posts" => "Gesamtgr&ouml;&szlig;e der Blog-Posts",
"Average posts size" => "Durchschn. Post Gr&ouml;&szlig;e",
"Visits to weblogs" => "Besuche auf Blogs",
"Poll Stats" => "Abstimmungs-Statistik",
"Total votes" => "Stimmen gesamt",
"Average votes per poll" => "Durchschn. Stimmen pro Abstimmung",
"Total questions" => "Fragen gesamt",
"Average questions per FAQ" => "Durchschn. Fragen pro FAQ",
"User Stats" => "Benutzer-Statistik",
"User bookmarks" => "Benutzer-Lesezeichen",
"Average bookmarks per user" => "Durchschn. Lesezeichen pro Benutzer",
"Average questions per quiz" => "Durchschn. Fragen pro Quiz",
"Quizzes taken" => "Quiz durchgef&uuml;hrt",
"Average quiz score" => "Durchschn. Quiz-Punktzahl",
"Average time per quiz" => "Durchschn. Zeit pro Quiz",
"Usage chart" => "Benutzungsdiagramm",
"Usage chart image" => "Grafik der Nutzungsstatistik",
"Daily Usage" => "Zugriffe / Tag",
"Stats for surveys" => "Statistik f&uuml;r Umfrage",
"Last taken" => "Zuletzt teilgenommen",
"Stats for survey" => "Statistik f&uuml;r Umfrage",
"Stats for this survey Questions " => "Statistik f&uuml;r diese Umfrage-Frage ",
"Clean logs older than" => "L&ouml;sche Logs die &auml;lter sind als",
"months" => "Monate",
"Clean" => "L&ouml;schen",
"Time Left" => "Zeit &uuml;brig",
"Send Answers" => "Antworten senden",
"Your email was sent" => "Ihre Mail wurde verschickt",
"Theme Control Center: categories" => "Theme Kontrollcenter: Kategorien",
"ThemeControl" => "Theme-Konfiguration",
"Theme is selected as follows" => "Die Theme wird folgenderma&szlig;en gew&auml;hlt",
"If a theme is assigned to the individual object that theme is used." => "Wenn eine Theme einem individuellem Objekt zugewiesen ist, wird diese verwendet",
"If not then if a theme is assigned to the object's category that theme is used" => "Wenn nicht, dann wird die Theme, die der Kategorie des Objekts zugewiesen ist gew&auml;hlt",
"If not then a theme for the section is used" => "Wenn nicht, dann wird die Theme des Bereichs gew&auml;hlt",
"If none of the above was selected the user theme is used" => "Wenn nicht, dann wird die Theme des Benutzers gew&auml;hlt",
"Finally if the user didn't select a theme the default theme is used" => "Trifft keiner der obenstehenden Punkte zu, dann wird die Default-Theme benutzt",
"Control by Objects" => "Kontrolle anhand der Objekte",
"Control by Sections" => "Theme Bereiche",
"Assign themes to categories" => "Kategorien Themes zuweisen",
"Assigned categories" => "Zugeordnete Kategorien",
"theme" => "Theme",
"Theme Control Center: Objects" => "Theme Kontrollcenter: Objekte",
"ThemeControl Objects" => "Objekte Theme-Konfiguration",
"Control by Categories" => "Theme Kategorien",
"Assign themes to objects" => "Objekten Themen zuordnen",
"Assigned objects" => "Zugeordnete Objekte",
"Theme Control Center: sections" => "Theme Kontrollcenter: Bereiche",
"Assign themes to sections" => "Bereichen Themen zuweisen",
"Assigned sections" => "Zugeordnete Bereiche",
"Edit File:" => "Datei bearbeiten:",
"The following file was successfully uploaded" => "Folgende Datei erfolgreich hochgeladen",
"You can download this file using" => "Sie k&ouml;nnen diese Datei herunterladen mit",
"Upload big files (e.g. PodCast files) here:" => "Gro&szlig;e Dateien (z.B. PodCasts) hier hochladen:",
"File Title" => "Dateititel",
"Batch upload" => "Batch hochladen",
"Upload successful!" => "Upload erfolgreich!",
"The following image was successfully uploaded" => "Das folgende Bild wurde erfolgreich hochgeladen",
"Thumbnail" => "Vorschau",
"or use filename" => "oder Dateinamen verwenden",
"Now enter the image URL" => "Nun Bild-URL eingeben",
" or upload a local image from your disk" => " oder lokales Bild von Ihrer Disk hochladen",
"Thumbnail (optional, overrides automatic thumbnail generation)" => "Thumbnail (optional, &uuml;berschreibt automatische Thumbnail-Erzeugung)",
"Note: Maximum image size is limited to" => "Hinweis: Die Uploadgr&ouml;sse ist beschr&auml;nkt auf",
"User assigned modules" => "Vom Benutzer zugewiesene Module",
"User Assigned Modules" => "Vom Benutzer zugewiesene Module",
"Assign module" => "Modul zuweisen",
"Column" => "Spalte",
"top" => "Top",
"Current folder" => "Aktueller Ordner",
"Folders" => "Ordner",
"Folder in" => "Ordner in",
"Remove Folder" => "Ordner l&ouml;schen",
"Refresh Cache" => "Cache aktualisieren",
"Admin folders and bookmarks" => "Ordner und Lesezeichen verwalten",
"Send me a message" => "Schick mir eine Nachricht",
"Gender" => "Geschlecht",
"Users HomePage" => "Benutzer Homepage",
"Personal Wiki Page" => "Private Wiki-Seite",
"Create page" => "Seite erstellen",
"This user is your friend" => "Dieser Benutzer ist Ihr Freund",
"Request friendship from this user" => "Diesen Benutzer um Freundschaft bitten",
"Personal Information" => "Pers&ouml;nliche Informationen",
"Use Google Map locator" => "Google Map Locator benutzen",
"Your personal Wiki Page" => "Ihre pers&ouml;nliche Wiki-Seite",
"Is email public? (uses scrambling to prevent spam)" => "eMail-Adresse &ouml;ffentlich? (es wird Verschl&uuml;sselung gegen Spam benutzt)",
"Unavailable - please set your e-mail below" => "Nicht verf&uuml;gbar - bitte zuerst eMail-Adresse eingeben",
"Account Information" => "Kontoinformationen",
"Leave \"New password\" and \"Confirm new password\" fields blank to keep current password" => "Felder \"Neues Pa&szlig;wort\" und \"Pa&szlig;wort best&auml;tigen\" frei lassen um das alte Pa&szlig;wort zu behalten",
"Email address" => "eMail-Adresse",
"Confirm new password" => "Pa&szlig;wort best&auml;tigen",
"Current password (required)" => "aktuelles Pa&szlig;wort (erforderlich)",
"Change administrative info" => "Einstellungen &uuml;bernehmen",
"New task" => "Neue Aufgabe",
"Task list" => "Aufgaben-&Uuml;bersicht",
"Admin mode off" => "Verwaltungsmodus aus",
"Admin mode on" => "Verwaltungsmodus an",
"Task help" => "Hilfe",
"Empty Trash" => "Papierkorb l&ouml;schen",
"Admin Mode" => "Verwaltungsmodus",
"Edit task" => "Aufgabe bearbeiten",
"Remove from Trash" => "Aus dem Papierkorb",
"Move into Trash" => "In den Papierkorb",
"Task saved" => "Aufgabe gespeichert",
"Edit Task" => "Aufgabe bearbeiten",
"View Task" => "Aufgabe ansehen",
"Open a new task" => "Neue Aufgabe hinzuf&uuml;gen",
"taskId" => "Aufgaben-Nummer",
"Task user" => "ist zu bearbeiten von",
"Only the creator can delete this task" => "Nur Ersteller kann die Aufgabe l&ouml;schen",
"Use start date and time" => "Startdatum/-zeit benutzen",
"Use end date and time" => "Endedatum/-zeit benutzen",
"Open / In Process" => "Offen / in Bearbeitung",
"Waiting / Not Started" => "Wartend / noch nicht begonnen",
"Percentage completed" => "Prozent erledigt",
"Waiting" => "Wartend",
"Shared for Group" => "Wird geteilt von Gruppe",
"Accepted by User" => "Akzeptiert von Benutzer",
"No / Rejected" => "Nein / zur&uuml;ckgewiesen",
"Accepted by Creator" => "Vom Ersteller akzeptiert",
"Send message with changes" => "Nachricht mit &Auml;nderungen verschicken",
"Modified by" => "Ge&auml;ndert von",
"Inform task user by email" => "Bearbeiter per eMail informieren",
"%m/%d/%Y [%H:%M]" => "%d.%m.%Y [%H:%M]",
"No tasks entered" => "Keine Aufgaben vorhanden",
"Select One" => "Status",
"Undo Trash" => "Aus Papierkorb",
"Show:" => "Anzeigen:",
"Received" => "Erhalten",
"Submitted" => "Zugewiesen",
"Shared" => "Geteilt",
"All Shared Tasks" => "Alle geteilten Aufgaben",
"completed (100%)" => "erledigt (100%)",
"Add Watch" => "Beobachtungspunkt hinzuf&uuml;gen",
"A user edited a wiki page" => "Jemand hat eine Wikiseite bearbeitet",
"May need to refresh twice to see changes" => "Evtl. zweimal Refresh n&ouml;tig, damit die &Auml;nderungen sichtbar werden",
"Add top level bookmarks to menu" => "Lesezeichen der obersten Ebene ins Men&uuml; &uuml;bernehmen",
"Pos" => "Position",
"Mode" => "Modus",
"replace window" => "Fenster ersetzen",
"User_versions_for" => "Benutzer_Versionen_f&uuml;r",
"expires:" => "l&auml;uft aus:",
"Banner stats" => "Banner-Statistik",
"Create new banner" => "Neues Banner erzeugen",
"Banner Information" => "Banner-Information",
"Click ratio" => "Click-Ratio",
"Weekdays" => "Wochentage",
"mon" => "Mo",
"tue" => "Di",
"wed" => "Mi",
"thu" => "Do",
"fri" => "Fr",
"sat" => "Sa",
"sun" => "So",
"Banner raw data" => "Banner Rohdaten",
"This is a cached version of the page." => "Dies ist eine gecachte Version der Seite.",
"Click here to view the Google cache of the page instead." => "Zum Betrachten der Seite im Google-Cache hier klicken.",
"Edit Items" => "Eintr&auml;ge bearbeiten",
"List Charts" => "Hitlisten anzeigen",
"Last Chart" => "Neueste Hitliste",
"Previous Chart" => "Vorherige Hitliste",
"Chart created" => "Hitliste erstellt",
"Next Chart" => "N&auml;chste Hitliste",
"Pre" => "Letzte",
"chg" => "&Auml;nderung",
"Avg" => "Durchschnitt",
"Next chart will be generated on" => "N&auml;chste Hitliste wird erstellt am",
"View or vote items not listed in the chart" => "Eintr&auml;ge anzeigen oder f&uuml;r welche stimmen, die nicht in dieser Hitliste vorhanden sind",
"Select something to vote on" => "Etwas ausw&auml;hlen, f&uuml;r das Sie stimmen wollen",
"Item information" => "Info &uuml;ber Eintrag",
"Dif" => "Diff",
"Best Position" => "Beste Position",
"Vote this item" => "F&uuml;r diesen Eintrag stimmen",
"Highest" => "H&ouml;chste",
"Answers" => "Antworten",
"Q" => "Frage",
"Add Suggestion" => "Vorschlag hinzuf&uuml;gen",
"1 suggestion" => "1 Vorschlag",
"suggestions" => "Vorschl&auml;ge",
"Forum List" => "Forenliste",
"Edit Forum" => "Forum Bearbeiten",
"You have to enter a title and text" => "Sie m&uuml;ssen Titel und Text eingeben",
"Summary" => "Zusammenfassung",
"Moderator Actions" => "Moderator-Aktionen",
"Move Selected Topics" => "Ausgew&auml;hlte Themen verschieben",
"Unlock Selected Topics" => "Ausgew&auml;hlte Themen entsperren",
"Lock Selected Topics" => "Ausgew&auml;hlte Themen sperren",
"Delete Selected Topics" => "Ausgew&auml;hlte Themen l&ouml;schen",
"Merge" => "Zusammenf&uuml;hren",
"Merge Selected Topics" => "Ausgew&auml;hlte Themen zusammenf&uuml;hren",
"Reported Messages:" => "Gemeldete Nachrichten:",
"Queued Messages:" => "Aufgelaufene Nachrichten:",
"Merge into topic" => "Zusammenf&uuml;hren mit Thema",
"Emot" => "Stimmung",
"pts" => "Punkte",
"Announce" => "Annoncieren",
"No topics yet" => "Noch keine Themen",
"Show posts" => "Zeige Postings",
"Last hour" => "Letzte Stunde",
"Last 24 hours" => "Letzte 24 Stunden",
"Last 48 hours" => "Letzte 48 Stunden",
"Jump to forum" => "Sprung in Forum",
" unread private messages" => " ungelesene pers&ouml;nliche Nachrichten",
"prev topic" => "vorheriges Thema",
"next topic" => "n&auml;chstes Thema",
"IRC log" => "IRC Log",
"Show All" => "Zeige alle",
"Insert New Item" => "Neuen Eintrag hinzuf&uuml;gen",
"Edit Fields" => "Felder bearbeiten",
"View inserted item" => "eingef&uuml;gten Eintrag anschauen",
"View Item" => "Eintrag ansehen",
"Filter Tracker Items" => "Tracker-Eintr&auml;ge filtern",
"Add a Comment" => "Kommentar hinzuf&uuml;gen",
"Add new mail account" => "Neuen eMail-Account hinzuf&uuml;gen",
"User accounts" => "Benutzer-Accounts",
"View All" => "Alle ansehen",
"Msg" => "Nachricht",
"Back To Mailbox" => "Zur&uuml;ck zum Briefkasten",
"Full Headers" => "Alle Header",
"Normal Headers" => "Normale Header",
"Reply To All" => "allen antworten",
"Forward" => "weiterleiten",
"Select from address book" => "Aus Adressbuch ausw&auml;hlen",
"Use HTML mail" => "HTML-Mail verwenden",
"The following addresses are not in your address book" => "Die folgenden Adressen sind nicht in Ihrem Adressbuch",
"Add Contacts" => "Kontakte hinzuf&uuml;gen",
"Attachment 1" => "Anlage 1",
"Attachment 2" => "Anlage 2",
"Attachment 3" => "Anlage 3",
"Address book" => "Adressbuch",
"as Creator &amp; Last Editor" => "als Ersteller &amp; letzter Bearbeiter",
"Business style" => "gesch&auml;ftlich",
"Collaborative style" => "kollaborativ",
"no (disabled)" => "keine (deaktiviert)",
"Minor Edit" => "geringf&uuml;gig",
"%s enabled" => "%s aktiviert",
"%s disabled" => "%s deaktiviert",
"Enable/disable Tiki features here, but configure them elsewhere" => "Tiki-Features hier ein/ausschalten, konfiguriert werden sie dann an anderen Stellen.",
"General preferences and settings" => "Allgemeine Einstellungen",
"User registration, login and authentication" => "Benutzer-Registrierung, Login und Authentifizierung",
"Wiki settings" => "Wiki-Einstellungen",
"Article/CMS settings" => "Artikel Konfiguration",
"Poll comments settings" => "Einstellungen Abstimmungskommentare",
"Configuration options for all blogs on your site" => "Globale Blog-Einstellungen",
"Forums settings" => "Foreneinstellungen",
"FAQ comments settings" => "FAQ Kommentar-Einstellungen",
"Trackers settings" => "Tracker Konfiguration",
"RSS settings" => "RSS-Feed Einstellungen",
"Directory settings" => "Linkverzeichnis Konfiguration",
"Maps configuration" => "Karten Konfiguration",
"Meta Tags settings" => "Meta-Tag Konfiguration",
"Search settings" => "Suche-Einstellungen",
"Score settings" => "Punkte Konfiguration",
"Community settings" => "Community Einstellungen",
"Calendar settings" => "Kalender Einstellungen",
"No chart indicated" => "Keine Hitliste angegeben",
"Upload failed" => "Hochladen fehlgeschlagen",
"Detected, Version:" => "Gefunden, Version:",
"Not detected." => "Nicht gefunden.",
"Your admin password has been changed" => "Das Administrator-Pa&szlig;wort wurde ge&auml;ndert",
"All Fields except gdaltindex must be filled" => "Alle Felder au&szlig;er gdaltindex m&uuml;ssen ausgef&uuml;llt werden",
"Tag already exists" => "Marke existiert bereits",
"Tag not found" => "Marke nicht gefunden",
"Repository name can't be an empty" => "Repository-Name mu&szlig; angegeben werden",
"No repository" => "Kein Repository",
"Search is mandatory field" => "Suche ist ein erforderliches Feld",
"File not found " => "Datei nicht gefunden ",
"Non-existent link" => "Nicht existierender Link",
"No menu indicated" => "Kein Men&uuml; angegeben",
"No newsletter indicated" => "Kein Newsletter angegeben",
"No poll indicated" => "Keine Abstimmung angegeben",
"Insert" => "Einf&uuml;gen",
"Icon" => "Symbol",
"unsafe" => "unsicher",
"register_globals should be off by default. See the php manual for details." => "register_globals sollte ausgeschaltet sein. Details bitte der PHP Anleitung entnehmen.",
"safe" => "sicher",
"session.use_trans_sid should be off by default. See the php manual for details." => "session.use_trans_sid sollte ausgeschaltet sein. Details bitte der PHP Anleitung entnehmen.",
"upload_tmp_dir is probably within your Tikiwiki directory. There is a risk that someone can upload any file to this directory and access them via web browser" => "upload_tmp_dir liegt vermutlich innerhalb des Tiki Verzeichnisses. Es besteht das Risiko, da&szlig; jemand dorthin Dateien l&auml;d und versucht, sie dort auszuf&uuml;hren.",
"cannot check if the upload_tmp_dir is accessible via web browser. To be sure you should check your webserver config." => "Kann nicht &uuml;berpr&uuml;fen, ob upload_tmp_dir per Browser lesbar ist. Bitte die Webservereinstellungen &uuml;berpr&uuml;fen.",
"setting the xbithack option is unsafe. Depending on the file handling of your webserver and your tiki settings, it may be possible that a attacker can upload scripts to file gallery and execute them" => "Setzen der xbithack Option ist unsicher. Abh&auml;ngig vom Dateihandling des Webservers und der Tiki-Einstellungen ist es unter Umst&auml;nden m&ouml;glich, da&szlig; jemand Scripte ins Dateiarchiv hochl&auml;d und dort ausf&uuml;hrt.",
"risky" => "gef&auml;hrlich",
"allow_url_fopen may potentially be used to upload remote data or scripts. If you dont use the blog feature, you can switch it off." => "allow_url_fopen kann benutzt werden um schadhafte Skripts zu uploaden. Wenn Sie die Blog Funktion nicht benutzen, kann es deaktiviert werden.",
"The Path to store files in the filegallery should be outside the tiki root directory" => "Der Pfad des Dateiarchivs sollte au&szlig;erhalb des Tiki-Verzeichnisses liegen.",
"The Path to store files in the imagegallery should be outside the tiki root directory" => "Der Pfad der Bildergalerien sollte au&szlig;erhalb des Tiki-Verzeichnisses liegen.",
"The feature \"Edit Templates\" is switched on. Do not allow anyone you cannot trust to use this feature. It can easily be used to inject php code." => "Die Funktion \"Vorlagen bearbeiten\" ist aktiviert. Diese Funktion sollte von keinem nicht-Administrator benutzt werden. Sie kann verwendet werden um schadhaften Code einzuschleusen.",
"installed" => "installiert",
"The \"Snarf Wikiplugin\" is installed. It can be used by wiki editors to include pages from the local network and via regex replacement create any html." => "Das \"Snarf Wikiplugin\" ist installiert. Es kann verwendet werden um Seiten aus dem lokalen Netzwerk via RegEx in HTML ausdr&uuml;cken.",
"The \"Regex Wikiplugin\" is installed. It can be used by wiki editors to create any html via regex replacement." => "Das \"Regex Wikiplugin\" ist installiert. Es kann verwendet werden um HTML Code durch RegEx zu ersetzen.",
"File is not readable. Unable to check." => "Diese Datei ist lesegesch&uuml;tzt und konnte nicht &uuml;berpr&uuml;ft werden.",
"You have to provide a word" => "Es mu&szlig; ein Wort angegeben werden",
"Permission denied you cannot view this page" => "Zugriff verweigert. Sie k&ouml;nnen diese Seite nicht betrachten.",
"Permission denied you cannot edit this page" => "Zugriff verweigert. Sie k&ouml;nnen diese Seite nicht bearbeiten",
"You must specify a page name, it will be created if it doesn't exist." => "Ein Seitenname mu&szlig; angegeben werden. Die Seite wird neu angelegt, wenn sie noch nicht vorhanden ist",
"page not added (Exists)" => "Seite nicht hinzugef&uuml;gt (existiert schon)",
"No survey indicated" => "Keine Umfrage angegeben",
"You don't have permission to use this feature" => "Keine Berechtigung zur Nutzung dieses Features",
"No Errors detected" => "Keine Fehler gefunden",
"No tracker indicated" => "Kein Tracker angegeben",
"Group already exists" => "Gruppe existiert bereits",
"User doesn't exist" => "Benutzer existiert nicht",
"No records were found. Check the file please!" => "Keine Eintr&auml;ge gefunden. Bitte die Datei &uuml;berpr&uuml;fen!",
"User login is required" => "Benutzerlogin ist erforderlich",
"Password is required" => "Passwort ist erforderlich",
"Email is required" => "eMail ist erforderlich",
"User is duplicated" => "Benutzer ist erforderlich",
"Created account %s <%s>" => "Account %s <%s> angelegt",
"Assigned %s in group %s" => "%s zu Gruppe %s hinzugef&uuml;gt",
"User %s already exists" => "Benutzer %s schon vorhanden",
"New %s created with %s %s." => "%s neu erstellt mit %s %s.",
"%s %s successfully deleted." => "%s %s erfolgreich gel&ouml;scht.",
"%s %s removed from %s %s." => "%s %s wurde aus %s %s entfernt.",
"%s <b>%s</b> successfully deleted." => "%s <b>%s</b> erfolgreich gel&ouml;scht.",
"%s modified successfully." => "%s erfolgreich ge&auml;ndert.",
"password" => "Pa&szlig;wort",
"%s modification failed." => "%s &Auml;nderung fehlgeschlagen.",
"rss feed disabled" => "RSS Feed nicht aktiv",
"Permission denied you cannot view this section" => "Zugriff verweigert. Sie k&ouml;nnen diesen Bereich nicht betrachten",
"Tiki RSS feed for articles" => "Tiki RSS Artikel Feed",
"Last articles." => "Neueste Artikel.",
"Unknown group" => "Unbekannte Gruppe",
"Group doesn't exist" => "Gruppe existiert nicht",
"The page cannot be found" => "Die Seite kann nicht gefunden werden",
"Image Galleries Admin Panel" => "Bildergalerien-Adminseite",
"Could not read image %s." => "Konnte Bilddatei %s nicht lesen.",
"Incorrect directory chosen for batch upload of images." => "Kein g&uuml;ltiges Bilder-Uploadverzeichnis ausgew&auml;hlt.",
"Please setup that dir on " => "Bitte dieses Verzeichnis einstellen auf der ",
"Invalid directory name" => "Ung&uuml;ltiger Verzeichnisname",
"File Galleries Admin Panel" => "Dateiarchiv-Adminseite",
"Could not read file %s." => "Konnte Datei %s nicht lesen.",
"Could not write to file %s." => "Konnte die Datei %s nicht schreiben.",
"File %s upload failed." => "Hochladen der Datei %s fehlgeschalgen.",
"File %s removed from Batch directory." => "Datei %s wurde aus dem Batchupload-Verzeichnis gel&ouml;scht.",
"Impossible to remove file %s from Batch directory." => "Konnt Datei %s nicht aus dem Batchupload-Verzeichnis l&ouml;schen.",
"Incorrect directory chosen for batch upload of files." => "Kein g&uuml;ltiges Datei-Uploadverzeichnis ausgew&auml;hlt.",
"Permission denied you cannot post" => "Zugriff verweigert. Sie k&ouml;nnen nicht posten",
"Permission denied you cannot edit this post" => "Zugriff verweigert. Sie k&ouml;nnen diesen Eintrag nicht bearbeiten",
"You can't post in any blog maybe you have to create a blog first" => "Sie k&ouml;nnen in keinen Blog eintragen. M&ouml;glicherweise m&uuml;ssen Sie zuerst ein Blog anlegen.",
"Top visited blogs" => "Meistbesuchte Blogs",
"Last posts" => "neueste Beitr&auml;ge",
"Top active blogs" => "aktivste Blogs",
"Tiki RSS feed for blog: " => "Tiki RSS Feed von Weblog: ",
"No blogId specified" => "Keine blogId angegeben",
"Tiki RSS feed for weblogs" => "Tiki RSS Weblog Feed",
"Last posts to weblogs." => "Neueste Weblog-Eintr&auml;ge.",
"Permission denied you cannot access this gallery" => "Zugriff verweigert. Sie k&ouml;nnen auf diese Galerie nicht zugreifen.",
"No gallery indicated" => "Keine Galerie angegeben",
"Permission denied you can not view this section" => "Zugriff verweigert. Sie k&ouml;nnen diesen Bereich nicht betrachten",
"Permission denied you cannot remove images from this gallery" => "Zugriff verweigert. Sie k&ouml;nnen keine Bilder aus dieser Galerie entfernen",
"Permission denied you cannot rebuild thumbnails in this gallery" => "Neuerstellung der Thumbnails in dieser Galerie nicht gestattet",
"Permission denied you cannot rotate images in this gallery" => "Rotation der Bilder in dieser Galerie nicht gestattet",
"No image indicated" => "Kein Bild angegeben",
"Permission denied you cannot move images from this gallery" => "Zugriff verweigert. Sie k&ouml;nnen keine Bilder dieser Galerie verschieben",
"Permission denied you cannot view the calendar" => "Berechtigung f&uuml;r den Zugriff auf den Kalender nicht vorhanden",
"event without name" => "Ereignis ohne Name",
"Access Denied" => "Zugriff verweigert",
"First day of week: Sunday (its ID is 0) - translators you need to localize this string!" => "1",
"No category indicated" => "Keine Kategorie angegeben",
"You can not use the same password again" => "Dasselbe Pa&szlig;wort noch einmal ist nicht erlaubt",
"Top authors" => "Top Autoren",
"This feature has been disabled" => "Diese Funktion wurde deaktiviert",
"Tiki RSS feed for directory sites" => "Tiki RSS Feed von Linkverzeichnis",
"Last sites." => "Neueste Sites.",
"Must enter a name to add a site. " => "Ein Seitenname mu&szlig; angegeben werden. ",
"Must enter a url to add a site. " => "Eine URL mu&szlig; angegeben werden. ",
"URL already added to the directory. Duplicate site? " => "URL schon im Verzeichnis vorhanden. Doppelter Eintrag? ",
"URL cannot be accessed wrong URL or site is offline and cannot be added to the directory. " => "Auf die URL kann nicht zugegriffen werden: fehlerhafte URL oder die Site ist nicht verf&uuml;gbar und kann daher nicht zum Linkverzeichnis hinzugef&uuml;gt werden. ",
"Must select a category. " => "Eine Kategorie mu&szlig; ausgew&auml;hlt werden. ",
"Must enter a name to add a site" => "Zum Hinzuf&uuml;gen mu&szlig der Name der Site angegeben werden",
"Must enter a url to add a site" => "Die URL der Site mu&szlig; angegeben werden",
"URL already added to the directory. Duplicate site?" => "URL im Verzeichnis schon vorhanden. Doppelter Eintrag?",
"URL cannot be accessed: wrong URL or site is offline and cannot be added to the directory" => "Auf die URL kann nicht zugegriffen werden: fehlerhafte URL oder die Site ist nicht verf&uuml;gbar und kann daher nicht zum Linkverzeichnis hinzugef&uuml;gt werden",
"Must select a category" => "Eine Kategorie mu&szlig; ausgew&auml;hlt werden",
"No site indicated" => "Kein Site angegeben",
"You can not download files" => "Du darst keine Dateien herunterladen",
"Article not found" => "Artikel nicht gefunden",
"Permission denied you cannot edit this article" => "Zugriff verweigert. Sie k&ouml;nnen diesen Artikel nicht bearbeiten",
"You do not have permissions to edit banners" => "Sie haben keine Berechtigung, Banner zu bearbeiten",
"Banner not found" => "Banner nicht gefunden",
"You do not have permission to edit this banner" => "Sie haben keine Berechtigung dieses Banner zu bearbeiten",
"Permission denied you cannot create or edit blogs" => "Zugriff verweigert. Sie k&ouml;nnen Blogs nicht erstellen oder bearbeiten",
"Permission denied you cannot edit this blog" => "Zugriff verweigert. Sie k&ouml;nnen dieses Blog nicht bearbeiten",
"You do not have permission to write the style sheet" => "Berechtigung zum Ver&auml;ndern des Stylesheets nicht vorhanden",
"Invalid request to edit an image" => "Ung&uuml;ltige Anforderung zur Bearbeitung eines Bildes",
"Permission denied you cannot edit images" => "Zugriff verweigert. Sie k&ouml;nnen keine Bilder bearbeiten",
"Permission denied you can edit images but not in this gallery" => "Zugriff verweigert. Sie k&ouml;nnen Bilder bearbeiten, jedoch nicht in dieser Galerie",
"Failed to edit the image" => "Bearbeitung des Bildes fehlgeschlagen",
"Permission denied to use this feature" => "Keine Berechtigung zur Nutzung dieser Funktion",
"Shortname must be 2 Characters" => "Kurzname mu&szlig; zwei Zeichen lang sein",
"You must provide a longname" => "Langer Name mu&szlig; angegeben werden",
"Language created" => "Sprache erstellt",
"No content id indicated" => "Keine Inhalts-ID angegeben",
"No question indicated" => "Keine Frage angegeben",
"No quiz indicated" => "Kein Quiz angegeben",
"No structure indicated" => "Keine Struktur angegeben",
"Permission denied you cannot send submissions" => "Zugriff verweigert. Sie k&ouml;nnen Einreichungen nicht senden",
"Permission denied you cannot edit submissions" => "Zugriff verweigert. Sie k&ouml;nnen Einreichungen nicht bearbeiten",
"You have to create a topic first" => "Sie m&uuml;ssen zuerst ein Thema erstellen",
"You do not have permission to do that" => "Sie haben nicht die Berechtigung, das zu tun",
"You do not have permission to read the template" => "Sie haben keine Berechtigung, die Vorlage zu lesen",
"No topic id specified" => "Keine Themen-ID angegeben",
"Invalid topic id specified" => "Ung&uuml;ltige Themen-ID angegeben",
"No object indicated" => "Kein Objekt angegeben",
"No type indicated" => "Kein Typ angegeben",
"page imported" => "Seite importiert",
"created from import" => "aus Import erstellt",
"Can't import remote HTML page" => "Kann externe HTML-Seite nicht importieren",
"Can't parse remote HTML page" => "Kann externe HTML-Seite nicht verarbeiten",
"The SandBox is disabled" => "Die SandBox ist deaktiviert",
"Cannot edit page because it is locked" => "Seite kann wegen Sperrung nicht bearbeitet werden",
"Permission denied you cannot edit this file" => "Berechtigung zum Bearbeiten dieser Datei nicht vorhanden",
"Permission denied you cannot remove files from this gallery" => "Zugriff Verweigert. Sie k&ouml;nnen keine Dateien aus dieser Galerie entfernen",
"Top visited file galleries" => "Meistbesuchte Dateiarchive",
"Most downloaded files" => "H&auml;ufigste Downloads",
"Last files" => "Neueste Dateien",
"Tiki RSS feed for file galleries" => "Tiki RSS Dateiarchiv Feed",
"Last files uploaded to the file galleries." => "Neueste Dateien in den Dateiarchiven.",
"No galleryId specified" => "Keine galleryId angegeben.",
"Tiki RSS feed for the file gallery: " => "Tiki RSS Feed von Dateiarchiv: ",
"No forum indicated" => "Kein Forum angegeben",
"Forum posts" => "Zahl der Eintr&auml;ge",
"No forumId specified" => "Keine forumId angegeben",
"Tiki RSS feed for forum: " => "Tiki RSS Feed von Forum: ",
"Tiki RSS feed for forums" => "Tiki RSS Foren Feed",
"Last topics in forums." => "Neueste Forenthemen.",
"No process indicated" => "Kein Prozess angegeben",
"Activity name already exists" => "Aktivit&auml;t mit diesem Namen existiert bereits",
"indicates if the process is active. Invalid processes cant be active" => "zeigt an ob der Prozess aktiv ist. Ung&uuml;ltige Prozesse k&ouml;nnen nicht aktiviert werden",
"No instance indicated" => "Keine Instanz angegeben",
"No activity indicated" => "Keine Aktivit&auml;t angegeben",
"The process name already exists" => "Dieser Prozessname ist bereits vergeben",
"Process already exists" => "Dieser Prozess existiert schon",
"You cant execute this activity" => "Sie k&ouml;nnen diese Aktivit&auml;t nicht ausf&uuml;hren",
"No user indicated" => "Kein Benutzer angegeben",
"No title indicated" => "Kein Titel angegeben",
"No comment indicated" => "Kein Kommentar angegeben",
"No date indicated" => "Kein Datum angegeben",
"No item indicated" => "Kein Objekt angegeben",
"first uploaded image" => "erstes hochgeladenes Bild",
"last uploaded image" => "neustes Bild",
"first image" => "erstes Bild",
"last image" => "neuestes Bild",
"random image" => "zuf&auml;lliges Bild",
"Permission denied you cannot create galleries and so you cant edit them" => "Zugriff verweigert. Sie k&ouml;nnen Galerien nicht erzeugen, also auch nicht bearbeiten",
"Permission denied you cannot edit this gallery" => "Zugriff verweigert. Sie k&ouml;nnen diese Galerie nicht bearbeiten",
"Permission denied you cannot remove this gallery" => "Zugriff verweigert. Sie k&ouml;nnen diese Galerie nicht l&ouml;schen",
"Top images" => "Top Bilder",
"Last images" => "Neueste Bilder",
"Tiki RSS feed for image galleries" => "Tiki RSS Feed von Bildergalerien",
"Tiki RSS feed for the image gallery: " => "Tiki RSS Feed von Bildergalerie: ",
"overwriting old page" => "&uuml;berschreibe alte Seite",
"page created" => "Seite erstellt",
"No name indicated for wiki page" => "Kein Name f&uuml;r die Wiki-Seite angegeben",
"No repository given" => "Kein Repository angegeben",
"Permission denied you cannot view pages like this page" => "Zugriff verweigert. Sie k&ouml;nnen Seiten wie diese nicht ansehen",
"Permission denied you cannot remove articles" => "Zugriff verweigert. Sie k&ouml;nnen Artikel nicht entfernen",
"Permission denied you cannot remove banners" => "Zugriff verweigert. Sie k&ouml;nnen keine Banner entfernen",
"Permission denied you cannot remove this blog" => "Zugriff verweigert. Sie k&ouml;nnen dieses Blog nicht entfernen",
"Non-existent gallery" => "Nicht existierende Galerie",
"Permission denied you can upload files but not to this file gallery" => "Zugriff verweigert. Sie k&ouml;nnen Dateien hochladen, jedoch nicht in dieses Archiv",
"Could not upload the file" => "Konntr Datei nicht hochladen",
"Invalid filename (using filters for filenames)" => "Ung&uuml;ltiger Dateiname (verwende Filter)",
"Could not find the file requested" => "Konnte die angegebene Datei nicht finden",
"File update was successful" => "Datei erfolgreich aktualisiert",
"Permission denied you can't upload files so you can't edit them" => "Berechtigung zum Hochladen und damit auch zum &Auml;ndern nicht vorhanden",
"The thumbnail name must be" => "Der Thumbnail-Name muss sein",
"You cannot admin blogs" => "Sie k&ouml;nnen Blogs nicht administrieren",
"Permission denied you cannot remove submissions" => "Zugriff verweigert. Sie k&ouml;nnen Einreichungen nicht entfernen",
"Permission denied you cannot approve submissions" => "Zugriff verweigert. Sie k&ouml;nnen Einreichungen nicht freigeben",
"Permission denied you cannot remove pages" => "Berechtigung zum Entfernen von Seiten nicht vorhanden",
"You have to enable cookies to be able to login to this site" => "Aktivieren Sie 'Cookies akzeptieren' um sich einloggen zu k&ouml;nnen",
"Account validated successfully." => "Account erfolgreich best&auml;tigt.",
"Sorry, you can't use this feature." => "Keine Berechtigung zur Nutzung dieser Funktion",
"You do not have permissions to view the maps" => "Keine Berechtigung zum Betrachten von Karten",
"mapfile name incorrect" => "Name der Kartendatei nicht korrekt",
"This mapfile already exists" => "Diese Kartendatei existiert schon",
"You do not have permission to write to the mapfile" => "Keine Berechtigung zum Schreiben von Kartendateien",
"You do not have permission to delete the mapfile" => "Keine Berechtigung zum L&ouml;schen der Kartendatei",
"I could not make a copy" => "Es konnte keine Kopie erstellt werden",
"You do not have permission to read the mapfile" => "Keine Berechtigung zum Lesen der Kartendatei",
"You dont have permission to do that" => "Keine Berechtigung vorhanden",
"Tiki RSS feed for maps" => "Tiki RSS Karten Feed",
"List of maps available." => "Neueste Karten.",
"You do not have permissions to view the layers" => "Keine Berechtigung zum Betrachten der Layer",
"You do not have permissions to delete a file" => "Keine Berechtigung zum L&ouml;schen einer Datei",
"File not found" => "Datei nicht gefunden",
"You do not have permissions to create a directory" => "Keine Berechtigung zum Erstellen eines Verzeichnisses",
"The Directory is not empty" => "Das Verzeichnis ist nicht leer",
"You do not have permissions to delete a directory" => "Keine Berechtigung zum L&ouml;schen eines Verzeichnisses",
"You do not have permissions to create an index file" => "Keine Berechtigung zum Anlegen einer Indexdatei",
"Invalid file name" => "Ung&uuml;ltiger Dateiname",
"Invalid files to index" => "&Uuml;ng&uuml;ltige Seiten, die indiziert werden sollen",
"I could not create the index file" => "Indexdatei konnte nicht angelegt werden",
"Must be logged to use this feature" => "F&uuml;r diese Funktion m&uuml;ssen Sie angemeldet sein",
"Welcome at Hawiki" => "Willkommen bei Hawiki",
"About" => "&Uuml;ber",
"Your PHP installation does not have zlib enabled." => "Die PHP Installation enth&auml;lt keine zlib Bibliothek.",
"You must log in to use this feature" => "Sie m&uuml;ssen sich anmelden, um diese Funktion zu nutzen",
"You do not have permission to view other users data" => "Sie haben keine Berechtigung, die Daten anderer Benutzer einzusehen",
"You must be logged in to subscribe to newsletters" => "Sie m&uuml;ssen eingeloggt sein, um Newsletter abonnieren zu k&ouml;nnen",
"No server indicated" => "Kein Server angegeben",
"Cannot connect to" => "Konnte Verbindung nicht herstellen zu",
"Missing information to read news (server,port,username,password,group) required" => "Zum Lesen von News fehlen Daten (Server,Port,Username,Pa&szlig;wort,Gruppe)",
"Cannot get messages" => "Kann keine Nachrichten abholen",
"No note indicated" => "Keine Notiz angegeben",
"File is too big" => "Datei ist zu gro&szlig;",
"created from notepad" => "Aus dem Notitzblock erstellt",
"Page already exists" => "Seite existiert schon",
"Not enough information to display this page" => "Nicht genug Informationen, um diese Seite anzuzeigen",
"Permission denied you cannot browse this page history" => "Zugriff verweigert. Sie k&ouml;nnen diese Seitenhistorie nicht ansehen",
"No article indicated" => "Kein Artikel angegeben",
"Article is not published yet" => "Artikel ist noch nicht ver&ouml;ffentlicht",
"No post indicated" => "Kein Posting angegeben",
"Blog not found" => "Blog nicht gefunden",
"No pages indicated" => "Keine Seiten angegeben",
"No result indicated" => "Kein Ergebnis angegeben",
"The passwords don't match" => "Die Passw&ouml;rter stimmen nicht &uuml;berein",
"empty" => "leer",
"Invalid or unknown username" => "Ung&uuml;ltiger oder unbekannter Benutzername",
"A password and your IP address reminder email has been sent " => "Eine Erinnerungsnachricht mit dem Passwort (und Ihrer IP Adresse) wurde verschickt ",
"to the registered email address for" => "an die registrierte eMail-Adresse f&uuml;r",
"last version" => "neueste Version",
"Permission denied you cannot remove versions from this page" => "Zugriff verweigert. Sie k&ouml;nnen Versionen dieser Seite nicht entfernen",
"Cannot rename page maybe new page already exists" => "Kann die Seite nicht umbenennen, evtl. existiert der Name schon",
"Non-existent version" => "Nicht existierende Version",
"Permission denied you cannot rollback this page" => "Zugriff verweigert. Rollback f&uuml;r diese Seite nicht erlaubt.",
"No newsletters available." => "Keine Newsletter vorhanden.",
" successfully sent" => " erfolgreich verschickt",
" not sent" => " nicht verschickt",
"Error: " => "Fehler: ",
"Page must be defined inside a structure to use this feature" => "F&uuml;r diese Funktion mu&szlig; die Seite innerhalb einer Struktur angelegt werden",
"You cannot take this quiz twice" => "Sie k&ouml;nnen dieses Quiz nicht zweimal durchf&uuml;hren",
"Quiz time limit exceeded quiz cannot be computed" => "Quizzeit &uuml;berschritten. Quiz kann nicht gewertet werden",
"You cannot take this survey twice" => "Sie k&ouml;nnen nicht zweimal an dieser Umfrage teilnehmen",
"Please create a category first" => "Bitte erst eine Kategorie anlegen",
"Tiki RSS feed for individual trackers: " => "Tiki RSS Feed von Tracker: ",
"No permission to upload zipped file packages" => "Berechtigung zum Hochladen gepackter Dateien nicht vorhanden",
"Error processing zipped image package" => "Fehler beim Verarbeiten der gepackten Bilddateien",
"No permission to upload zipped image packages" => "Berechtigung zum Hochladen gepackter Bildarchive nicht vorhanden",
"The uploaded file ist not recognized as a image" => "Die hochgeladene Datei konnte nicht als Bild identifiziert werden",
"Permission denied you cannot upload images" => "Zugriff verweigert. Sie k&ouml;nnen keine Bilder hochladen",
"Permission denied you can upload images but not to this gallery" => "Zugriff verweigert. Sie k&ouml;nnen Bilder hochladen, aber nicht in diese Galerie",
"Cannot get image from URL" => "Kann Bild nicht von URL beziehen",
"That is not an image (or you have php < 4.0.5)" => "Dies ist kein Bild (Oder die PHP Version ist kleiner als 4.0.5)",
"Usage" => "Zugriffe",
"No url indicated" => "Keine URL angegeben",
"Unknown user" => "Unbekannter Benutzer",
"You are not logged in and no user indicated" => "Du bist nicht eingeloggt und es wurde auch kein Benutzer angegeben",
"The user has chosen to make his information private" => "Der Benutzer hat diese Information als privat deklariert",
"Email is set to %s" => "eMail-Adresse ist jetzt %s",
"The passwords did not match" => "Die Pa&szlig;w&ouml;rter stimmen nicht &uuml;berein",
"no" => "nein",
"unicode" => "Unicode",
"open / in process" => "offen / in Bearbeitung",
"Changes:" => "&Auml;nderungen:",
"Info message" => "Benachrichtigung",
"NEW Task" => "Neue Aufgabe",
"Changes on Task" => "&Auml;nderungen an Aufgabe",
"You received a new task" => "Neue Aufgabe erhalten",
"The priority is" => "Die Priorit&auml;t ist",
"very low" => "sehr niedrig",
"low" => "niedrig",
"high" => "hoch",
"very high" => "sehr hoch",
"Cannot upload this file not enough quota" => "Hochladen w&uuml;rde Quota &uuml;berschreiten",
"Non-existent user" => "Nicht existierender Benutzer",
"No banner indicated" => "Kein Banner angegeben",
"No blog indicated" => "Kein Blog angegeben",
"Permission denied you cannot remove the post" => "Zugriff verweigert. Sie k&ouml;nnen den Eintrag nicht entfernen",
"No cache information available" => "Keine Cache-Informationen verf&uuml;gbar",
"No faq indicated" => "Keine FAQ angegeben",
"You are not permitted to remove someone else\\'s post!" => "Keine Erlaubnis zum L&ouml;schen von Postings anderer Benutzer!",
"Wrong password. Cannot post comment" => "Falsches Passwort. Kommentar kann nicht gespeichert werden",
"Please wait 2 minutes between posts" => "Bitte zwei Minuten zwischen Posts warten",
"No thread indicated" => "Kein Thread angegeben",
"A SheetId is required." => "Eine SheetId mu&szlig; angegeben werden.",
"No subject" => "Kein Betreff vorhanden",
"Top pages" => "Top-Seiten",
"Last pages" => "Letzte Seiten",
"Tiki RSS feed for the wiki pages" => "Tiki RSS Wiki Feed",
"Last modifications to the Wiki." => "Zuletzt ge&auml;nderte Wikiseiten.",
"###end###"=>"###end###");
?>
