/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphModel;
import org.jgraph.pad.GPGraph;

public class GPGraphTools {
    public CostFunction createDefaultCostFunction() {
        return new DefaultCostFunction();
    }

    public int getComponentCount(GPGraph gPGraph) {
        UnionFind unionFind = new UnionFind();
        Object[] objectArray = gPGraph.getAll();
        Object[] objectArray2 = gPGraph.getVertices(objectArray);
        int n = 0;
        while (n < objectArray2.length) {
            unionFind.find(objectArray2[n]);
            ++n;
        }
        Object[] objectArray3 = gPGraph.getEdges(objectArray);
        int n2 = 0;
        while (n2 < objectArray3.length) {
            Object object = gPGraph.getSourceVertex(objectArray3[n2]);
            Object object2 = gPGraph.getTargetVertex(objectArray3[n2]);
            unionFind.union(unionFind.find(object), unionFind.find(object2));
            ++n2;
        }
        return unionFind.getSetCount();
    }

    public Object[] getShortestPath(GPGraph gPGraph, Object object, Object object2, CostFunction costFunction) {
        Object object3;
        if (costFunction == null) {
            costFunction = this.createDefaultCostFunction();
        }
        GraphModel graphModel = gPGraph.getModel();
        PriorityQueue priorityQueue = new PriorityQueue();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        priorityQueue.setPrio(object, 0.0);
        Object[] objectArray = gPGraph.getAll();
        int n = gPGraph.getVertices(objectArray).length;
        int n2 = 0;
        while (n2 < n) {
            double d = priorityQueue.getPrio();
            object3 = priorityQueue.pop();
            if (object3 == object2) break;
            Object[] objectArray2 = new Object[]{object3};
            Object[] objectArray3 = DefaultGraphModel.getEdges(graphModel, objectArray2).toArray();
            if (objectArray3 != null) {
                int n3 = 0;
                while (n3 < objectArray3.length) {
                    Object object4 = gPGraph.getNeighbour(objectArray3[n3], object3);
                    double d2 = d + costFunction.getCost(gPGraph, objectArray3[n3]);
                    if (object4 != null && object4 != object3 && d2 < priorityQueue.getPrio(object4)) {
                        hashtable.put(object4, objectArray3[n3]);
                        priorityQueue.setPrio(object4, d2);
                    }
                    ++n3;
                }
            }
            if (priorityQueue.isEmpty()) break;
            ++n2;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object5 = object2;
        while (object5 != null) {
            arrayList.add(object5);
            object3 = hashtable.get(object5);
            if (object3 != null) {
                arrayList.add(object3);
                object5 = gPGraph.getNeighbour(object3, object5);
                continue;
            }
            object5 = null;
        }
        return arrayList.toArray();
    }

    public Object[] getSpanningTree(GPGraph gPGraph, CostFunction costFunction) {
        Object object;
        Object object2;
        Object object3;
        if (costFunction == null) {
            costFunction = this.createDefaultCostFunction();
        }
        Object[] objectArray = gPGraph.getAll();
        SortedSet sortedSet = this.sort(gPGraph, gPGraph.getEdges(objectArray), costFunction);
        UnionFind unionFind = new UnionFind();
        HashSet<Object> hashSet = new HashSet<Object>();
        while (!sortedSet.isEmpty()) {
            object3 = sortedSet.first();
            sortedSet.remove(object3);
            object2 = unionFind.find(gPGraph.getSourceVertex(object3));
            object = unionFind.find(gPGraph.getTargetVertex(object3));
            if (object2 != null && object != null && object2 == object) continue;
            unionFind.union(object2, object);
            hashSet.add(object3);
        }
        object3 = new HashSet();
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            Object object4 = gPGraph.getSourceVertex(object);
            Object object5 = gPGraph.getTargetVertex(object);
            if (object4 != null) {
                ((HashSet)object3).add(object4);
            }
            if (object5 == null) continue;
            ((HashSet)object3).add(object5);
        }
        object = new Object[hashSet.size() + ((HashSet)object3).size()];
        System.arraycopy(hashSet.toArray(), 0, object, 0, hashSet.size());
        System.arraycopy(((HashSet)object3).toArray(), 0, object, hashSet.size(), ((HashSet)object3).size());
        return object;
    }

    public SortedSet sort(final JGraph jGraph, Object[] objectArray, final CostFunction costFunction) {
        TreeSet<Object> treeSet = new TreeSet<Object>(new Comparator(){

            public int compare(Object object, Object object2) {
                Double d = new Double(costFunction.getCost(jGraph, object));
                Double d2 = new Double(costFunction.getCost(jGraph, object2));
                return d.compareTo(d2);
            }
        });
        int n = 0;
        while (n < objectArray.length) {
            treeSet.add(objectArray[n]);
            ++n;
        }
        return treeSet;
    }

    public static double getLength(CellView cellView) {
        double d = 1.0;
        if (cellView instanceof EdgeView) {
            EdgeView edgeView = (EdgeView)cellView;
            Point point = null;
            Point point2 = null;
            int n = 0;
            while (n < edgeView.getPointCount()) {
                point2 = edgeView.getPoint(n);
                if (point != null) {
                    d += point.distance(point2);
                }
                point = point2;
                ++n;
            }
        }
        return d;
    }

    public class PriorityQueue {
        protected Hashtable prio = new Hashtable();
        protected HashSet data = new HashSet();
        protected double minPrio = Double.MAX_VALUE;
        protected Object minElt = null;

        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        public Object pop() {
            Object object = this.minElt;
            this.data.remove(object);
            this.update();
            return object;
        }

        public double getPrio() {
            return this.minPrio;
        }

        public double getPrio(Object object) {
            Double d;
            if (object != null && (d = (Double)this.prio.get(object)) != null) {
                return d;
            }
            return Double.MAX_VALUE;
        }

        protected void update() {
            Iterator iterator = this.data.iterator();
            this.minElt = null;
            this.minPrio = Double.MAX_VALUE;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                double d = this.getPrio(e);
                if (!(d < this.minPrio)) continue;
                this.minPrio = d;
                this.minElt = e;
            }
        }

        public void setPrio(Object object, double d) {
            Double d2 = new Double(d);
            this.prio.put(object, d2);
            this.data.add(object);
            if (d < this.minPrio) {
                this.minPrio = d;
                this.minElt = object;
            }
        }
    }

    public class UnionFind {
        protected Hashtable sets = new Hashtable();
        protected Hashtable cells = new Hashtable();

        public int getSetCount() {
            return this.sets.size();
        }

        public Object find(Object object) {
            Object object2 = null;
            if (object != null && (object2 = (Object)this.cells.get(object)) == null) {
                object2 = object;
                this.cells.put(object, object2);
                HashSet<Object> hashSet = new HashSet<Object>();
                hashSet.add(object);
                this.sets.put(object2, hashSet);
            }
            return object2;
        }

        public Object union(Object object, Object iterator) {
            if (object != null && iterator != null && object != iterator) {
                HashSet hashSet = (HashSet)this.sets.get(object);
                HashSet hashSet2 = (HashSet)this.sets.get(iterator);
                if (hashSet != null && hashSet2 != null) {
                    Iterator iterator2;
                    if (hashSet.size() < hashSet2.size()) {
                        iterator2 = hashSet;
                        hashSet = hashSet2;
                        hashSet2 = iterator2;
                        iterator2 = object;
                        object = iterator;
                        iterator = iterator2;
                    }
                    hashSet.addAll(hashSet2);
                    this.sets.remove(iterator);
                    iterator2 = hashSet2.iterator();
                    while (iterator2.hasNext()) {
                        this.cells.put(iterator2.next(), object);
                    }
                }
            }
            return object;
        }
    }

    public class DefaultCostFunction
    implements CostFunction {
        public double getCost(JGraph jGraph, Object object) {
            CellView cellView = jGraph.getGraphLayoutCache().getMapping(object, false);
            return GPGraphTools.getLength(cellView);
        }
    }

    public static interface CostFunction {
        public double getCost(JGraph var1, Object var2);
    }
}

