/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.layout;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexView;
import org.jgraph.layout.LayoutAlgorithm;
import org.jgraph.layout.ProgressDialog;
import org.jgraph.utils.MathExtensions;

public class AnnealingLayoutAlgorithm
implements LayoutAlgorithm,
GraphModelListener {
    public static final String KEY_CAPTION = "Annealing Layoutalgorithm Attributes";
    public static final String KEY_POSITION = "Position";
    public static final String KEY_RELATIVES = "Relatives";
    public static final String CF_KEY_EDGE_DISTANCE_RELEVANT_EDGES = "costfunction edge distance key for relevant edges";
    public static final String KEY_CLUSTERED_VERTICES = "Clustered Vertices";
    public static final String KEY_CLUSTER = "Cluster";
    public static final String KEY_IS_CLUSTER = "is Cluster";
    public static final String KEY_CLUSTER_INIT_POSITION = "initial Position of the Cluster";
    protected static final int CONFIG_KEY_RUN = 0;
    protected static final int CONFIG_KEY_LAYOUT_UPDATE = 1;
    private double temperature;
    private double initTemperature;
    private double minTemperature;
    private double minDistance;
    private double tempScaleFactor;
    private int maxRounds;
    protected double[] lambdaList;
    private Rectangle bounds;
    private boolean computePermutation;
    private boolean uphillMovesAllowed;
    private boolean isLayoutUpdateEnabled;
    private int costFunctionConfig;
    private int round;
    private int triesPerCell;
    protected ArrayList cellList;
    protected ArrayList edgeList;
    protected ArrayList applyCellList;
    private JGraph jgraph;
    private int initProgressValue = 0;
    protected Properties presetConfig;
    private long time = 0L;
    private ProgressDialog dlgProgress = new ProgressDialog((Frame)null, "Progress:", false);
    private boolean isDebugging = false;
    private boolean isRunning = false;
    private int luRecursionDepth;
    private double luPerimeterRadius;
    private double luPerimeterRadiusInc;
    private String luMethod;
    private double equalsNull = 0.05;
    private boolean isClusteringEnabled;
    private double clusterMoveScaleFactor;
    private double clusteringFactor;

    public void perform(JGraph jGraph, boolean bl, Properties properties) {
        this.isRunning = true;
        this.jgraph = jGraph;
        this.presetConfig = properties;
        this.cellList = new ArrayList();
        this.edgeList = new ArrayList();
        this.applyCellList = new ArrayList();
        this.loadConfiguration(0);
        this.getNodes(this.jgraph, bl);
        if (this.applyCellList.size() == 0) {
            return;
        }
        if (this.isLayoutUpdateEnabled) {
            this.jgraph.getModel().addGraphModelListener(this);
        }
        this.initProgressValue = 0;
        this.dlgProgress.setValue(this.initProgressValue);
        this.dlgProgress.setVisible(true);
        this.init(true);
        boolean bl2 = this.run();
        if (!bl2) {
            this.moveGraphToNW();
            this.applyChanges();
            this.removeTemporaryData();
        }
        this.dlgProgress.setVisible(false);
        this.isRunning = false;
    }

    public boolean performOptimization(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, Properties properties, ProgressDialog progressDialog) {
        this.cellList = arrayList2;
        this.applyCellList = arrayList;
        this.edgeList = arrayList3;
        this.presetConfig = properties;
        this.dlgProgress = progressDialog;
        this.initProgressValue = progressDialog.getValue();
        this.loadConfiguration(0);
        this.init(false);
        boolean bl = this.run();
        return bl;
    }

    private void loadConfiguration(int n) {
        this.isLayoutUpdateEnabled = this.isTrue((String)this.presetConfig.get("Layout Update enabled"));
        if (n == 0) {
            this.initTemperature = Double.parseDouble((String)this.presetConfig.get("Start Temperature"));
            this.minTemperature = Double.parseDouble((String)this.presetConfig.get("min. Temperature"));
            this.minDistance = Double.parseDouble((String)this.presetConfig.get("min. Distance"));
            this.tempScaleFactor = Double.parseDouble((String)this.presetConfig.get("Temperature Scalefactor"));
            this.maxRounds = Integer.parseInt((String)this.presetConfig.get("max. Rounds"));
            this.triesPerCell = Integer.parseInt((String)this.presetConfig.get("tries per cell"));
            ArrayList arrayList = (ArrayList)this.presetConfig.get("Lambda");
            this.lambdaList = new double[6];
            int n2 = 0;
            while (n2 < this.lambdaList.length) {
                this.lambdaList[n2] = (Double)arrayList.get(n2);
                ++n2;
            }
            this.bounds = (Rectangle)this.presetConfig.get("Bounds of resulting graph");
            this.costFunctionConfig = Integer.parseInt((String)this.presetConfig.get("Costfunction Config"), 2);
            this.computePermutation = this.isTrue((String)this.presetConfig.get("should compute per Permutation"));
            this.uphillMovesAllowed = this.isTrue((String)this.presetConfig.get("are Uphill-Moves allowed"));
        } else if (n == 1) {
            this.initTemperature = Double.parseDouble((String)this.presetConfig.get("Layout Update Start Temperature"));
            this.minTemperature = Double.parseDouble((String)this.presetConfig.get("Layout Update min. Temperature"));
            this.minDistance = Double.parseDouble((String)this.presetConfig.get("Layout Update min. Distance"));
            this.tempScaleFactor = Double.parseDouble((String)this.presetConfig.get("Layout Update Temperature Scalefactor"));
            this.maxRounds = Integer.parseInt((String)this.presetConfig.get("Layout Update max. Rounds"));
            this.triesPerCell = Integer.parseInt((String)this.presetConfig.get("Layout Update tries per cell"));
            ArrayList arrayList = (ArrayList)this.presetConfig.get("Layout Update Lambda");
            this.lambdaList = new double[6];
            int n3 = 0;
            while (n3 < this.lambdaList.length) {
                this.lambdaList[n3] = (Double)arrayList.get(n3);
                ++n3;
            }
            this.bounds = (Rectangle)this.presetConfig.get("Layout Update Bounds of resulting graph");
            this.costFunctionConfig = Integer.parseInt((String)this.presetConfig.get("Layout Update Costfunction Config"), 2);
            this.computePermutation = this.isTrue((String)this.presetConfig.get("Layout Update should compute per Permutation"));
            this.uphillMovesAllowed = this.isTrue((String)this.presetConfig.get("Layout Update are Uphill-Moves allowed"));
            this.luRecursionDepth = Integer.parseInt((String)this.presetConfig.get("Layout Update Method Neighbors depth"));
            this.luPerimeterRadius = Double.parseDouble((String)this.presetConfig.get("Layout Update Method Perimeter radius"));
            this.luPerimeterRadiusInc = Double.parseDouble((String)this.presetConfig.get("Layout Update Method Perimeter radius increase"));
            this.luMethod = (String)this.presetConfig.get("Layout Update Method");
            this.isClusteringEnabled = this.isTrue((String)this.presetConfig.get("Layout Update clustering enabled"));
            this.clusteringFactor = Double.parseDouble((String)this.presetConfig.get("Layout Update clustering factor"));
            this.clusterMoveScaleFactor = Double.parseDouble((String)this.presetConfig.get("Layout Update clustering move scaling factor"));
        }
        this.loadAdditionalConfiguration(n);
    }

    protected void loadAdditionalConfiguration(int n) {
    }

    private boolean isTrue(String string) {
        if (string != null) {
            if ("TRUE".equals(string.toUpperCase())) {
                return true;
            }
            if ("FALSE".equals(string.toUpperCase())) {
                return false;
            }
        }
        return false;
    }

    private void getNodes(JGraph jGraph, boolean bl) {
        Object[] objectArray = jGraph.getRoots();
        Object[] objectArray2 = jGraph.getSelectionCells();
        CellView[] cellViewArray = jGraph.getGraphLayoutCache().getMapping(objectArray, false);
        CellView[] cellViewArray2 = jGraph.getGraphLayoutCache().getMapping(objectArray2, false);
        int n = 0;
        while (n < cellViewArray.length) {
            if (cellViewArray[n] instanceof VertexView) {
                if (!this.cellList.contains(cellViewArray[n])) {
                    this.cellList.add(cellViewArray[n]);
                }
                if (bl && !this.applyCellList.contains(cellViewArray)) {
                    this.applyCellList.add(cellViewArray[n]);
                }
            } else if (cellViewArray[n] instanceof EdgeView && cellViewArray[n] != null && !this.edgeList.contains(cellViewArray[n])) {
                this.edgeList.add(cellViewArray[n]);
            }
            ++n;
        }
        if (!bl) {
            int n2 = 0;
            while (n2 < cellViewArray2.length) {
                if (cellViewArray[n2] instanceof VertexView && !this.applyCellList.contains(cellViewArray2[n2])) {
                    this.applyCellList.add(cellViewArray2[n2]);
                }
                ++n2;
            }
        }
    }

    private void applyChanges() {
        Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
        int n = 0;
        while (n < this.applyCellList.size()) {
            CellView cellView = (CellView)this.applyCellList.get(n);
            Point2D.Double double_ = this.getPosition(cellView);
            Rectangle rectangle = cellView.getBounds();
            rectangle.x = (int)(double_.getX() - rectangle.getWidth() / 2.0);
            rectangle.y = (int)(double_.getY() - rectangle.getHeight() / 2.0);
            Object object = ((CellView)this.applyCellList.get(n)).getCell();
            Map map = GraphConstants.createMap();
            GraphConstants.setBounds(map, rectangle);
            hashtable.put(object, map);
            ++n;
        }
        this.jgraph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    private void removeTemporaryData() {
        int n = 0;
        while (n < this.applyCellList.size()) {
            ((CellView)this.applyCellList.get(n)).getAttributes().clear();
            ++n;
        }
    }

    private void init(boolean bl) {
        if (bl) {
            int n = 0;
            while (n < this.applyCellList.size()) {
                if (!((CellView)this.applyCellList.get(n)).getAttributes().containsKey(KEY_POSITION)) {
                    this.setPosition(n, Math.random() * this.bounds.getWidth() + this.bounds.getX(), Math.random() * this.bounds.getHeight() + this.bounds.getY());
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this.cellList.size()) {
                if (!((CellView)this.cellList.get(n2)).getAttributes().containsKey(KEY_POSITION)) {
                    this.setPosition((CellView)this.cellList.get(n2), Math.random() * this.bounds.getWidth() + this.bounds.getX(), Math.random() * this.bounds.getHeight() + this.bounds.getY());
                }
                ++n2;
            }
        }
        this.temperature = this.initTemperature;
        this.maxRounds = Math.min(100 * this.applyCellList.size(), this.getMaxRoundsByTemperature(this.temperature));
        this.round = 0;
    }

    private boolean run() {
        boolean bl = false;
        while (this.round <= this.maxRounds && !bl) {
            bl = this.performRound();
        }
        return bl;
    }

    private boolean performRound() {
        double d;
        Point2D.Double[] doubleArray = this.getConfig();
        double d2 = d = this.getGlobalCosts(this.lambdaList);
        double d3 = d2 * 1.1;
        int[] nArray = new int[this.applyCellList.size()];
        if (!this.computePermutation) {
            int n = 0;
            while (n < this.applyCellList.size()) {
                nArray[n] = n;
                ++n;
            }
        }
        int n = 0;
        while (n < this.applyCellList.size()) {
            if (this.computePermutation) {
                nArray = this.createPermutation(this.applyCellList.size());
            }
            double d4 = Math.random() * 2.0 * Math.PI;
            int n2 = 0;
            while (n2 < this.triesPerCell) {
                double d5 = (double)n2 * (Math.PI * 2 / (double)this.triesPerCell);
                Point2D.Double double_ = null;
                double_ = this.isCluster((CellView)this.applyCellList.get(n)) ? new Point2D.Double(this.clusterMoveScaleFactor * this.temperature * Math.cos(d5), this.clusterMoveScaleFactor * this.temperature * Math.sin(d5)) : new Point2D.Double(this.temperature * Math.cos(d5 += d4), this.temperature * Math.sin(d5));
                this.setPosition(nArray[n], doubleArray[nArray[n]].x + double_.x, doubleArray[nArray[n]].y + double_.y);
                d3 = this.getGlobalCosts(this.lambdaList);
                if (d3 < d2 || this.getBolzmanBreak(d2, d3) && this.uphillMovesAllowed) {
                    d2 = d3;
                    doubleArray[nArray[n]] = new Point2D.Double(doubleArray[nArray[n]].x + double_.x, doubleArray[nArray[n]].y + double_.y);
                    break;
                }
                this.setPosition(nArray[n], doubleArray[nArray[n]].x, doubleArray[nArray[n]].y);
                this.dlgProgress.setValue(this.initProgressValue + (int)((double)(this.round * this.applyCellList.size() * this.triesPerCell + n * this.triesPerCell + n2) / (double)(this.maxRounds * this.applyCellList.size() * this.triesPerCell) * (100.0 - (double)this.initProgressValue)));
                if (this.dlgProgress.isCanceled()) break;
                ++n2;
            }
            if (d2 == d * 0.05 || this.dlgProgress.isCanceled()) break;
            ++n;
        }
        this.temperature *= this.tempScaleFactor;
        ++this.round;
        return this.dlgProgress.isCanceled();
    }

    private Point2D.Double[] getConfig() {
        Point2D.Double[] doubleArray = new Point2D.Double[this.applyCellList.size()];
        int n = 0;
        while (n < this.applyCellList.size()) {
            Point2D.Double double_ = this.getPosition((CellView)this.applyCellList.get(n));
            doubleArray[n] = new Point2D.Double(double_.x, double_.y);
            ++n;
        }
        return doubleArray;
    }

    private double getGlobalCosts(double[] dArray) {
        double d = 0.0;
        if ((this.costFunctionConfig & 0x20) != 0) {
            d += this.getNodeDistance(dArray[5]);
        }
        if ((this.costFunctionConfig & 0x10) != 0) {
            d += this.getNodeDistribution(dArray[0]);
        }
        if ((this.costFunctionConfig & 8) != 0) {
            d += this.getBorderline(dArray[1]);
        }
        if ((this.costFunctionConfig & 4) != 0) {
            d += this.getEdgeLength(dArray[2]);
        }
        if ((this.costFunctionConfig & 2) != 0) {
            d += this.getEdgeCrossing(1.0, dArray[3]);
        }
        if ((this.costFunctionConfig & 1) != 0) {
            d += this.getEdgeDistance(dArray[4]);
        }
        return d += this.getAdditionalCosts(this.costFunctionConfig, dArray);
    }

    protected double getAdditionalCosts(int n, double[] dArray) {
        return 0.0;
    }

    public int[] createPermutation(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = (int)(Math.random() * (double)n);
            int n4 = 0;
            while (n4 < n2) {
                if (n3 == nArray[n4]) {
                    n3 = (int)(Math.random() * (double)n);
                    n4 = -1;
                }
                ++n4;
            }
            nArray[n2] = n3;
            ++n2;
        }
        return nArray;
    }

    private boolean getBolzmanBreak(double d, double d2) {
        return Math.random() < Math.pow(Math.E, (d - d2) / this.temperature);
    }

    private int getMaxRoundsByTemperature(double d) {
        return (int)Math.ceil(Math.log(this.minTemperature / d) / Math.log(this.tempScaleFactor));
    }

    private double getNodeDistribution(double d) {
        double d2 = 0.0;
        int n = 0;
        while (n < this.applyCellList.size()) {
            int n2 = 0;
            while (n2 < this.cellList.size()) {
                if (this.applyCellList.get(n) != this.cellList.get(n2)) {
                    double d3 = MathExtensions.getEuclideanDistance(this.getPosition((CellView)this.applyCellList.get(n)), this.getPosition((CellView)this.cellList.get(n2)));
                    if (Math.abs(d3) < this.equalsNull) {
                        d3 = this.equalsNull;
                    }
                    d2 += d / (d3 * d3);
                }
                ++n2;
            }
            ++n;
        }
        return d2;
    }

    private double getBorderline(double d) {
        double d2 = 0.0;
        int n = 0;
        while (n < this.applyCellList.size()) {
            Point2D.Double double_ = this.getPosition((CellView)this.applyCellList.get(n));
            double d3 = double_.y - (double)this.bounds.y;
            double d4 = double_.x - (double)this.bounds.x;
            double d5 = (double)(this.bounds.y + this.bounds.height) - double_.y;
            double d6 = (double)(this.bounds.x + this.bounds.width) - double_.x;
            d2 += d * (1.0 / (d3 * d3) + 1.0 / (d4 * d4) + 1.0 / (d5 * d5) + 1.0 / (d6 * d6));
            ++n;
        }
        return d2;
    }

    private double getEdgeLength(double d) {
        double d2 = 0.0;
        Line2D.Double[] doubleArray = this.getEdgeLines(this.edgeList);
        int n = 0;
        while (n < doubleArray.length) {
            Point2D point2D = doubleArray[n].getP1();
            Point2D point2D2 = doubleArray[n].getP2();
            double d3 = point2D.distance(point2D2);
            d2 += d * d3 * d3;
            ++n;
        }
        return d2;
    }

    private double getEdgeCrossing(double d, double d2) {
        int n = 0;
        Line2D.Double[] doubleArray = this.getEdgeLines(this.edgeList);
        int n2 = 0;
        while (n2 < doubleArray.length) {
            int n3 = n2;
            while (n3 < doubleArray.length) {
                if (n3 != n2 && doubleArray[n2].intersectsLine(doubleArray[n3]) && doubleArray[n2].getP1().getX() != doubleArray[n3].getP1().getX() && doubleArray[n2].getP1().getY() != doubleArray[n3].getP1().getY() && doubleArray[n2].getP1().getX() != doubleArray[n3].getP2().getX() && doubleArray[n2].getP1().getY() != doubleArray[n3].getP2().getY() && doubleArray[n2].getP2().getX() != doubleArray[n3].getP1().getX() && doubleArray[n2].getP2().getY() != doubleArray[n3].getP1().getY() && doubleArray[n2].getP2().getX() != doubleArray[n3].getP2().getX() && doubleArray[n2].getP2().getY() != doubleArray[n3].getP2().getY()) {
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        return d2 * d * (double)n;
    }

    private double getEdgeDistance(double d) {
        double d2 = 0.0;
        int n = 0;
        while (n < this.applyCellList.size()) {
            double d3 = 0.0;
            CellView cellView = (CellView)this.applyCellList.get(n);
            ArrayList arrayList = null;
            if (cellView.getAttributes().containsKey(CF_KEY_EDGE_DISTANCE_RELEVANT_EDGES)) {
                arrayList = (ArrayList)cellView.getAttributes().get(CF_KEY_EDGE_DISTANCE_RELEVANT_EDGES);
            } else {
                arrayList = this.getRelevantEdges(cellView);
                cellView.getAttributes().put(CF_KEY_EDGE_DISTANCE_RELEVANT_EDGES, arrayList);
            }
            Line2D.Double[] doubleArray = this.getEdgeLines(this.getRelevantEdges(cellView));
            int n2 = 0;
            while (n2 < doubleArray.length) {
                double d4 = doubleArray[n2].ptSegDist(this.getPosition(cellView));
                if (Math.abs(d4) < this.equalsNull) {
                    d4 = this.equalsNull;
                }
                if (d4 != 0.0) {
                    d3 += d / (d4 * d4);
                }
                if (d4 < this.minDistance) {
                    d3 += d / (this.minDistance * this.minDistance);
                }
                ++n2;
            }
            d2 += d3;
            ++n;
        }
        return d2;
    }

    private double getNodeDistance(double d) {
        double d2 = 0.0;
        double d3 = 30.0;
        int n = 0;
        int n2 = 0;
        while (n2 < this.applyCellList.size()) {
            Point2D.Double double_ = (Point2D.Double)((CellView)this.applyCellList.get(n2)).getAttributes().get(KEY_POSITION);
            Rectangle rectangle = ((CellView)this.applyCellList.get(n2)).getBounds();
            int n3 = 0;
            while (n3 < this.cellList.size()) {
                if (this.applyCellList.get(n2) != this.cellList.get(n3)) {
                    Point2D.Double double_2 = (Point2D.Double)((CellView)this.cellList.get(n3)).getAttributes().get(KEY_POSITION);
                    Rectangle rectangle2 = ((CellView)this.cellList.get(n3)).getBounds();
                    double d4 = Math.max(2.0 * d3 + Math.max(rectangle.getWidth(), rectangle.getHeight()) / 2.0 + Math.max(rectangle2.getWidth(), rectangle2.getHeight()) / 2.0, this.minDistance);
                    double d5 = Math.abs(double_.distance(double_2));
                    if (Math.abs(d5) < this.equalsNull) {
                        d5 = this.equalsNull;
                    }
                    if (d5 < d4) {
                        d2 += d / (d5 * d5);
                        ++n;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        return d2;
    }

    private Line2D.Double[] getEdgeLines(ArrayList arrayList) {
        Line2D.Double[] doubleArray = new Line2D.Double[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            EdgeView edgeView = (EdgeView)arrayList.get(n);
            GraphModel graphModel = edgeView.getModel();
            CellMapper cellMapper = edgeView.getMapper();
            CellView cellView = edgeView.getSource().getParentView();
            CellView cellView2 = edgeView.getTarget().getParentView();
            doubleArray[n] = new Line2D.Double(this.getPosition(cellView), this.getPosition(cellView2));
            ++n;
        }
        return doubleArray;
    }

    private ArrayList getRelevantEdges(CellView cellView) {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.edgeList.size()) {
            CellView cellView2 = ((EdgeView)this.edgeList.get(n)).getSource().getParentView();
            if (cellView2 != cellView && this.applyCellList.contains(cellView2)) {
                arrayList.add(this.edgeList.get(n));
            } else {
                cellView2 = ((EdgeView)this.edgeList.get(n)).getTarget().getParentView();
                if (cellView2 != cellView && this.applyCellList.contains(cellView2)) {
                    arrayList.add(this.edgeList.get(n));
                }
            }
            ++n;
        }
        return arrayList;
    }

    public Point2D.Double getRandomVector(double d) {
        double d2 = Math.random() * Math.PI * 2.0;
        double d3 = Math.random() * d;
        return new Point2D.Double(d3 * Math.cos(d2), d3 * Math.sin(d2));
    }

    private void setPosition(CellView cellView, Point2D.Double double_) {
        this.setAttribute(cellView, KEY_POSITION, double_);
    }

    private void setPosition(int n, double d, double d2) {
        this.setPosition((CellView)this.applyCellList.get(n), d, d2);
    }

    private void setPosition(CellView cellView, double d, double d2) {
        this.setPosition(cellView, new Point2D.Double(d, d2));
    }

    private Point2D.Double getPosition(CellView cellView) {
        return (Point2D.Double)this.getAttribute(cellView, KEY_POSITION);
    }

    private void setAttribute(CellView cellView, String string, Object object) {
        if (cellView.getAttributes() == null) {
            cellView.setAttributes(new Hashtable());
        }
        Map map = cellView.getAttributes();
        map.put(string, object);
    }

    private Object getAttribute(CellView cellView, String string) {
        return cellView.getAttributes().get(string);
    }

    private void moveGraphToNW() {
        Cloneable cloneable;
        Object object;
        Point2D.Double double_ = this.getPosition((CellView)this.cellList.get(0));
        double d = double_.x;
        double d2 = double_.y;
        double d3 = d;
        double d4 = d2;
        int n = 0;
        while (n < this.cellList.size()) {
            CellView cellView = (CellView)this.cellList.get(n);
            object = this.getPosition((CellView)this.cellList.get(n));
            cloneable = new Rectangle(cellView.getBounds());
            if (((Point2D.Double)object).getX() < d) {
                d = ((Point2D.Double)object).getX();
            } else if (((Point2D.Double)object).getX() + ((Rectangle)cloneable).getWidth() > d3) {
                d3 = ((Point2D.Double)object).getX() + ((Rectangle)cloneable).getWidth();
            }
            if (((Point2D.Double)object).getY() < d2) {
                d2 = ((Point2D.Double)object).getY();
            } else if (((Point2D.Double)object).getY() + ((Rectangle)cloneable).getHeight() > d4) {
                d4 = ((Point2D.Double)object).getY() + ((Rectangle)cloneable).getHeight();
            }
            ++n;
        }
        d -= 50.0;
        d2 -= 50.0;
        int n2 = 0;
        while (n2 < this.cellList.size()) {
            object = (CellView)this.cellList.get(n2);
            cloneable = this.getPosition((CellView)object);
            this.setPosition((CellView)object, new Point2D.Double(((Point2D.Double)cloneable).x - d, ((Point2D.Double)cloneable).y - d2));
            ++n2;
        }
    }

    protected ArrayList getRelativesFrom(ArrayList arrayList, CellView cellView) {
        ArrayList arrayList2 = this.getRelatives(cellView);
        ArrayList arrayList3 = new ArrayList();
        int n = 0;
        while (n < arrayList2.size()) {
            if (arrayList.contains(arrayList2.get(n))) {
                arrayList3.add(arrayList2.get(n));
            }
            ++n;
        }
        return arrayList3;
    }

    protected ArrayList getRelatives(CellView cellView) {
        if (cellView.getAttributes().containsKey(KEY_RELATIVES)) {
            return (ArrayList)cellView.getAttributes().get(KEY_RELATIVES);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        VertexView vertexView = (VertexView)cellView;
        if (this.isCluster(cellView)) {
            ArrayList arrayList3 = (ArrayList)vertexView.getAttributes().get(KEY_CLUSTERED_VERTICES);
            int n = 0;
            while (n < arrayList3.size()) {
                ArrayList arrayList4 = this.getRelatives((CellView)arrayList3.get(n));
                int n2 = 0;
                while (n2 < arrayList4.size()) {
                    if (!arrayList.contains(arrayList4.get(n2)) && !arrayList3.contains(arrayList4.get(n2))) {
                        arrayList.add(arrayList4.get(n2));
                    }
                    ++n2;
                }
                ++n;
            }
        } else {
            GraphModel graphModel = vertexView.getModel();
            CellMapper cellMapper = vertexView.getMapper();
            Object object = vertexView.getCell();
            int n = 0;
            while (n < graphModel.getChildCount(object)) {
                Object object2 = graphModel.getChild(object, n);
                arrayList2.add(object2);
                ++n;
            }
            int n3 = 0;
            while (n3 < arrayList2.size()) {
                Object e = arrayList2.get(n3);
                Iterator iterator = graphModel.edges(e);
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    Object object3 = null;
                    object3 = graphModel.getSource(e2) != e ? graphModel.getSource(e2) : graphModel.getTarget(e2);
                    CellView cellView2 = cellMapper.getMapping(graphModel.getParent(object3), false);
                    arrayList.add(cellView2);
                }
                ++n3;
            }
        }
        cellView.getAttributes().put(KEY_RELATIVES, arrayList);
        return arrayList;
    }

    private void arrangeLayoutUpdateInsertPlacement(CellView[] cellViewArray) {
        Object object;
        int n = 0;
        while (n < this.cellList.size()) {
            object = (CellView)this.cellList.get(n);
            if (!object.getAttributes().containsKey(KEY_POSITION)) {
                Point2D.Double double_ = new Point2D.Double(object.getBounds().getCenterX(), object.getBounds().getCenterY());
                object.getAttributes().put(KEY_POSITION, double_);
            }
            ++n;
        }
        object = new ArrayList();
        int n2 = 0;
        while (n2 < cellViewArray.length) {
            ((ArrayList)object).add(cellViewArray[n2]);
            ++n2;
        }
        this.arrangeLayoutUpdateInsertedCellsPlacement((ArrayList)object);
    }

    private void arrangeLayoutUpdateInsertedCellsPlacement(ArrayList arrayList) {
        ArrayList<CellView> arrayList2 = new ArrayList<CellView>();
        int n = 0;
        while (n < arrayList.size()) {
            CellView cellView = (CellView)arrayList.get(n);
            if (cellView instanceof VertexView) {
                ArrayList arrayList3 = this.getRelativesFrom(this.cellList, cellView);
                if (arrayList3.size() != 0) {
                    Point2D.Double double_;
                    double d = 0.0;
                    double d2 = 0.0;
                    int n2 = 0;
                    while (n2 < arrayList3.size()) {
                        double_ = (Point2D.Double)((CellView)arrayList3.get(n2)).getAttributes().get(KEY_POSITION);
                        d += double_.x;
                        d2 += double_.y;
                        ++n2;
                    }
                    double_ = new Point2D.Double(Math.cos(Math.random() * 2.0 * Math.PI) * 10.0, Math.sin(Math.random() * 2.0 * Math.PI) * 10.0);
                    cellView.getAttributes().put(KEY_POSITION, new Point2D.Double(d / (double)arrayList3.size() + double_.x, d2 / (double)arrayList3.size() + double_.y));
                } else {
                    arrayList2.add(cellView);
                }
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < arrayList.size()) {
            if (arrayList.get(n3) != null && ((CellView)arrayList.get(n3)).getAttributes() != null && ((CellView)arrayList.get(n3)).getAttributes().containsKey(KEY_POSITION)) {
                this.cellList.add(arrayList.get(n3));
            }
            ++n3;
        }
        if (arrayList2.size() != arrayList.size()) {
            this.arrangeLayoutUpdateInsertedCellsPlacement(arrayList2);
        } else {
            int n4 = 0;
            while (n4 < arrayList2.size()) {
                CellView cellView = (CellView)arrayList2.get(n4);
                if (!cellView.getAttributes().containsKey(KEY_POSITION)) {
                    cellView.getAttributes().put(KEY_POSITION, new Point2D.Double(0.0, 0.0));
                }
                ++n4;
            }
        }
        int n5 = 0;
        while (n5 < this.cellList.size()) {
            if (((CellView)this.cellList.get(n5)).getAttributes().get(KEY_POSITION) == null) {
                System.err.println("WHATCH OUT!!! NODE " + n5 + " == NULL");
            }
            ++n5;
        }
    }

    private void getLayoutUpdateCells(CellView[] cellViewArray) {
        int n;
        int n2 = 0;
        while (n2 < cellViewArray.length) {
            if (cellViewArray[n2] instanceof VertexView) {
                if (!this.applyCellList.contains(cellViewArray[n2])) {
                    this.applyCellList.add(cellViewArray[n2]);
                }
                if (!this.cellList.contains(cellViewArray[n2])) {
                    this.cellList.add(cellViewArray[n2]);
                }
            } else if (cellViewArray[n2] instanceof EdgeView && cellViewArray[n2] != null && !this.edgeList.contains(cellViewArray[n2])) {
                this.edgeList.add(cellViewArray[n2]);
                System.out.println("edge added");
            }
            ++n2;
        }
        if ("Layout Update Method Perimeter".equals(this.luMethod)) {
            Serializable serializable;
            Point2D.Double double_;
            int n3;
            Serializable serializable2;
            ArrayList<Ellipse2D.Double> arrayList = new ArrayList<Ellipse2D.Double>();
            n = 0;
            while (n < this.applyCellList.size()) {
                VertexView vertexView = (VertexView)this.applyCellList.get(n);
                serializable2 = (Point2D.Double)vertexView.getAttributes().get(KEY_POSITION);
                int n4 = 0;
                n3 = 0;
                while (n3 < this.applyCellList.size()) {
                    if (n != n3 && ((Point2D)((Object)serializable2)).distance(double_ = (Point2D.Double)((AbstractCellView)(serializable = (VertexView)this.applyCellList.get(n3))).getAttributes().get(KEY_POSITION)) < this.luPerimeterRadius) {
                        ++n4;
                    }
                    ++n3;
                }
                arrayList.add(new Ellipse2D.Double(((Point2D.Double)serializable2).x - (this.luPerimeterRadius + (double)n4 * this.luPerimeterRadiusInc), ((Point2D.Double)serializable2).y - (this.luPerimeterRadius + (double)n4 * this.luPerimeterRadiusInc), 2.0 * (this.luPerimeterRadius + (double)n4 * this.luPerimeterRadiusInc), 2.0 * (this.luPerimeterRadius + (double)n4 * this.luPerimeterRadiusInc)));
                ++n;
            }
            int n5 = 0;
            while (n5 < this.cellList.size()) {
                serializable2 = (VertexView)this.cellList.get(n5);
                Point2D.Double double_2 = (Point2D.Double)((AbstractCellView)serializable2).getAttributes().get(KEY_POSITION);
                n3 = 0;
                while (n3 < arrayList.size()) {
                    serializable = (Ellipse2D.Double)arrayList.get(n3);
                    double_ = new Point2D.Double(((RectangularShape)((Object)serializable)).getCenterX(), ((RectangularShape)((Object)serializable)).getCenterY());
                    double d = ((RectangularShape)((Object)serializable)).getCenterX() - ((Ellipse2D.Double)serializable).getX();
                    if (double_.distance(double_2) < d && !this.applyCellList.contains(serializable2)) {
                        this.applyCellList.add(serializable2);
                    }
                    ++n3;
                }
                ++n5;
            }
        }
        if (this.luRecursionDepth > 0) {
            int n6 = 0;
            n = 0;
            while (n < cellViewArray.length) {
                if (cellViewArray[n] instanceof VertexView) {
                    ++n6;
                }
                ++n;
            }
            VertexView[] vertexViewArray = new VertexView[n6];
            n6 = 0;
            int n7 = 0;
            while (n7 < cellViewArray.length) {
                if (cellViewArray[n7] instanceof VertexView) {
                    vertexViewArray[n6++] = (VertexView)cellViewArray[n7];
                }
                ++n7;
            }
            this.addRelativesToList(vertexViewArray, this.luRecursionDepth);
        }
    }

    private void addRelativesToList(VertexView[] vertexViewArray, int n) {
        if (vertexViewArray == null) {
            return;
        }
        if (vertexViewArray.length == 0) {
            return;
        }
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < vertexViewArray.length) {
            ArrayList arrayList = this.getRelatives(vertexViewArray[n2]);
            VertexView[] vertexViewArray2 = new VertexView[arrayList.size()];
            int n3 = 0;
            while (n3 < arrayList.size()) {
                if (!this.applyCellList.contains(arrayList.get(n3))) {
                    this.applyCellList.add(arrayList.get(n3));
                }
                if (!this.cellList.contains(arrayList.get(n3))) {
                    this.cellList.add(arrayList.get(n3));
                }
                vertexViewArray2[n3] = (VertexView)arrayList.get(n3);
                ++n3;
            }
            this.addRelativesToList(vertexViewArray2, n - 1);
            ++n2;
        }
    }

    public void graphChanged(GraphModelEvent graphModelEvent) {
        if (!this.isRunning) {
            this.isRunning = true;
            Object[] objectArray = graphModelEvent.getChange().getInserted();
            Object[] objectArray2 = graphModelEvent.getChange().getRemoved();
            if (objectArray != null && objectArray2 == null) {
                if (objectArray.length == 0) {
                    this.isRunning = false;
                    return;
                }
                CellView[] cellViewArray = this.jgraph.getGraphLayoutCache().getMapping(objectArray, false);
                if (cellViewArray.length == 0) {
                    this.isRunning = false;
                    return;
                }
                this.applyCellList.clear();
                this.loadConfiguration(1);
                boolean bl = false;
                int n = 0;
                while (n < cellViewArray.length) {
                    if (cellViewArray[n] == null) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (bl) {
                    this.getAllEdges();
                }
                this.arrangeLayoutUpdateInsertPlacement(cellViewArray);
                this.getLayoutUpdateCells(cellViewArray);
                if (this.applyCellList.size() == 0) {
                    this.isRunning = false;
                    return;
                }
                this.round = 0;
                this.initProgressValue = 0;
                this.dlgProgress.setValue(this.initProgressValue);
                this.dlgProgress.setVisible(true);
                if (this.isClusteringEnabled) {
                    this.clusterGraph();
                }
                this.init(false);
                boolean bl2 = this.run();
                if (this.isClusteringEnabled) {
                    this.declusterGraph();
                }
                if (!bl2) {
                    this.applyChanges();
                }
                this.removeTemporaryData();
                this.dlgProgress.setVisible(false);
            } else if (objectArray == null && objectArray2 != null) {
                this.isRunning = true;
                CellView[] cellViewArray = this.jgraph.getGraphLayoutCache().getMapping(objectArray2, false);
                int n = 0;
                while (n < cellViewArray.length) {
                    if (cellViewArray[n] instanceof VertexView) {
                        if (this.applyCellList.contains(cellViewArray[n])) {
                            this.applyCellList.remove(cellViewArray[n]);
                        }
                        if (this.cellList.contains(cellViewArray[n])) {
                            this.cellList.remove(cellViewArray[n]);
                        }
                    } else if (cellViewArray[n] instanceof EdgeView) {
                        // empty if block
                    }
                    ++n;
                }
            }
            this.isRunning = false;
        }
    }

    private void showCell(CellView cellView, Color color) {
        Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
        Point2D.Double double_ = this.getPosition(cellView);
        Rectangle rectangle = cellView.getBounds();
        rectangle.x = (int)(double_.getX() - rectangle.getWidth() / 2.0);
        rectangle.y = (int)(double_.getY() - rectangle.getHeight() / 2.0);
        Object object = cellView.getCell();
        Map map = GraphConstants.createMap();
        GraphConstants.setBackground(map, color);
        GraphConstants.setBounds(map, rectangle);
        hashtable.put(object, map);
        this.jgraph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    private void colorizeClusters(ArrayList arrayList) {
        Color[] colorArray = new Color[]{Color.black, Color.magenta, Color.yellow, Color.blue, Color.green, Color.gray, Color.cyan, Color.red, Color.darkGray, Color.lightGray, Color.orange, Color.pink};
        int n = 0;
        while (n < arrayList.size()) {
            if (n >= colorArray.length) break;
            ArrayList arrayList2 = (ArrayList)((VertexView)arrayList.get(n)).getAttributes().get(KEY_CLUSTERED_VERTICES);
            this.showCellList(arrayList2, colorArray[n]);
            ++n;
        }
    }

    private void showCellList(ArrayList arrayList, Color color) {
        Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
        int n = 0;
        while (n < arrayList.size()) {
            CellView cellView = (CellView)arrayList.get(n);
            Point2D.Double double_ = this.getPosition(cellView);
            Rectangle rectangle = cellView.getBounds();
            rectangle.x = (int)(double_.getX() - rectangle.getWidth() / 2.0);
            rectangle.y = (int)(double_.getY() - rectangle.getHeight() / 2.0);
            Object object = cellView.getCell();
            Map map = GraphConstants.createMap();
            GraphConstants.setBackground(map, color);
            GraphConstants.setBounds(map, rectangle);
            hashtable.put(object, map);
            ++n;
        }
        this.jgraph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    private void getAllEdges() {
        Object[] objectArray = this.jgraph.getRoots();
        CellView[] cellViewArray = this.jgraph.getGraphLayoutCache().getMapping(objectArray, false);
        int n = 0;
        while (n < cellViewArray.length) {
            if (cellViewArray[n] instanceof VertexView) {
                VertexView vertexView = (VertexView)cellViewArray[n];
                GraphModel graphModel = vertexView.getModel();
                CellMapper cellMapper = vertexView.getMapper();
                Object object = vertexView.getCell();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int n2 = 0;
                while (n2 < graphModel.getChildCount(object)) {
                    Object object2 = graphModel.getChild(object, n2);
                    arrayList.add(object2);
                    ++n2;
                }
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    Object e = arrayList.get(n3);
                    Iterator iterator = graphModel.edges(e);
                    while (iterator.hasNext()) {
                        Object e2 = iterator.next();
                        CellView cellView = cellMapper.getMapping(e2, false);
                        if (this.edgeList.contains(cellView) || cellView == null) continue;
                        this.edgeList.add(cellView);
                    }
                    ++n3;
                }
            } else if (cellViewArray[n] instanceof EdgeView && !this.edgeList.contains(cellViewArray[n]) && cellViewArray[n] != null) {
                this.edgeList.add(cellViewArray[n]);
            }
            ++n;
        }
    }

    private synchronized void stop(long l) {
        try {
            this.wait(l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void clusterGraph() {
        Serializable serializable;
        int n;
        Serializable serializable2;
        Serializable serializable3;
        int n2 = Math.max((int)((double)(this.cellList.size() - this.applyCellList.size()) / this.clusteringFactor), 2);
        if (this.cellList.size() <= 1) {
            System.out.println("cellList.size() <= 1");
            return;
        }
        ArrayList<VertexView> arrayList = new ArrayList<VertexView>();
        ArrayList arrayList2 = new ArrayList();
        int n3 = 0;
        while (n3 < this.cellList.size()) {
            if (!this.applyCellList.contains(this.cellList.get(n3))) {
                arrayList2.add(this.cellList.get(n3));
            }
            ++n3;
        }
        VertexView[] vertexViewArray = new VertexView[n2];
        CellMapper cellMapper = ((VertexView)this.cellList.get(0)).getMapper();
        Rectangle rectangle = this.getBoundingBox();
        int n4 = 0;
        while (n4 < vertexViewArray.length) {
            vertexViewArray[n4] = new VertexView(null, this.jgraph, cellMapper);
            Map map = vertexViewArray[n4].getAttributes();
            map.put(KEY_IS_CLUSTER, "true");
            map.put(KEY_POSITION, new Point2D.Double(Math.random() * (double)rectangle.width, Math.random() * (double)rectangle.height));
            arrayList.add(vertexViewArray[n4]);
            ++n4;
        }
        int n5 = 0;
        while (n5 < arrayList2.size()) {
            VertexView vertexView = (VertexView)arrayList2.get(n5);
            Point2D.Double double_ = this.getPosition(vertexView);
            int n6 = 0;
            serializable3 = this.getPosition((CellView)arrayList.get(0));
            double d = MathExtensions.getEuclideanDistance(double_, serializable3);
            int n7 = 1;
            while (n7 < arrayList.size()) {
                serializable3 = this.getPosition((VertexView)arrayList.get(n7));
                double d2 = MathExtensions.getEuclideanDistance(double_, serializable3);
                if (d > d2) {
                    d = d2;
                    n6 = n7;
                }
                ++n7;
            }
            serializable2 = (VertexView)arrayList.get(n6);
            this.moveVerticeToCluster(vertexView, (VertexView)serializable2);
            ++n5;
        }
        boolean bl = false;
        do {
            bl = false;
            n = 0;
            while (n < arrayList2.size()) {
                VertexView vertexView = (VertexView)arrayList2.get(n);
                serializable3 = (VertexView)vertexView.getAttributes().get(KEY_CLUSTER);
                Point2D.Double double_ = this.getPosition(vertexView);
                serializable = this.getPosition((CellView)((Object)serializable3));
                double d = MathExtensions.getEuclideanDistance(double_, (Point2D.Double)serializable);
                int n8 = 0;
                while (n8 < arrayList.size()) {
                    double d3;
                    VertexView vertexView2 = (VertexView)arrayList.get(n8);
                    if (vertexView2 != serializable3 && (d3 = MathExtensions.getEuclideanDistance(double_, (Point2D.Double)(serializable = this.getPosition(vertexView2)))) < d) {
                        this.moveVerticeToCluster(vertexView, vertexView2);
                        bl = true;
                        break;
                    }
                    ++n8;
                }
                ++n;
            }
        } while (bl);
        n = 0;
        while (n < arrayList.size()) {
            if (!((VertexView)arrayList.get(n)).getAttributes().containsKey(KEY_CLUSTERED_VERTICES)) {
                arrayList.remove(n--);
            } else if (((ArrayList)((VertexView)arrayList.get(n)).getAttributes().get(KEY_CLUSTERED_VERTICES)).size() == 0) {
                arrayList.remove(n--);
            }
            ++n;
        }
        int n9 = 0;
        while (n9 < arrayList2.size()) {
            this.cellList.remove(arrayList2.get(n9));
            ++n9;
        }
        int n10 = 0;
        while (n10 < arrayList.size()) {
            this.applyCellList.add(arrayList.get(n10));
            this.cellList.add(arrayList.get(n10));
            ++n10;
        }
        int n11 = 0;
        while (n11 < arrayList.size()) {
            serializable = (VertexView)arrayList.get(n11);
            Map map = ((AbstractCellView)serializable).getAttributes();
            serializable2 = (Point2D.Double)map.get(KEY_POSITION);
            map.put(KEY_CLUSTER_INIT_POSITION, new Point2D.Double(((Point2D.Double)serializable2).x, ((Point2D.Double)serializable2).y));
            ++n11;
        }
        int n12 = 0;
        while (n12 < arrayList.size()) {
            VertexView vertexView = (VertexView)arrayList.get(n12);
            vertexView.setCachedBounds(this.getBoundingBox((ArrayList)vertexView.getAttributes().get(KEY_CLUSTERED_VERTICES)));
            ++n12;
        }
    }

    protected void moveVerticeToCluster(VertexView vertexView, VertexView vertexView2) {
        if (!vertexView2.getAttributes().containsKey(KEY_CLUSTERED_VERTICES)) {
            vertexView2.getAttributes().put(KEY_CLUSTERED_VERTICES, new ArrayList());
        }
        ArrayList arrayList = (ArrayList)vertexView2.getAttributes().get(KEY_CLUSTERED_VERTICES);
        arrayList.add(vertexView);
        if (vertexView.getAttributes().containsKey(KEY_CLUSTER)) {
            VertexView vertexView3 = (VertexView)vertexView.getAttributes().get(KEY_CLUSTER);
            ArrayList arrayList2 = (ArrayList)vertexView3.getAttributes().get(KEY_CLUSTERED_VERTICES);
            arrayList2.remove(vertexView);
            this.computeClusterPosition(vertexView3);
        }
        vertexView.getAttributes().put(KEY_CLUSTER, vertexView2);
        this.computeClusterPosition(vertexView2);
    }

    protected void computeClusterPosition(VertexView vertexView) {
        ArrayList arrayList = (ArrayList)vertexView.getAttributes().get(KEY_CLUSTERED_VERTICES);
        Point2D.Double double_ = this.computeBarycenter(arrayList);
        vertexView.getAttributes().put(KEY_POSITION, double_);
    }

    protected void declusterGraph() {
        if (this.cellList.size() <= 1) {
            return;
        }
        ArrayList<VertexView> arrayList = new ArrayList<VertexView>();
        int n = 0;
        while (n < this.cellList.size()) {
            VertexView vertexView = (VertexView)this.cellList.get(n);
            if (this.isCluster(vertexView)) {
                arrayList.add(vertexView);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            this.cellList.remove(arrayList.get(n2));
            this.applyCellList.remove(arrayList.get(n2));
            ++n2;
        }
        int n3 = 0;
        while (n3 < arrayList.size()) {
            VertexView vertexView = (VertexView)arrayList.get(n3);
            Map map = vertexView.getAttributes();
            Point2D.Double double_ = this.getPosition(vertexView);
            Point2D.Double double_2 = (Point2D.Double)map.get(KEY_CLUSTER_INIT_POSITION);
            Point2D.Double double_3 = new Point2D.Double(double_.x - double_2.x, double_.y - double_2.y);
            ArrayList arrayList2 = (ArrayList)map.get(KEY_CLUSTERED_VERTICES);
            int n4 = 0;
            while (n4 < arrayList2.size()) {
                VertexView vertexView2 = (VertexView)arrayList2.get(n4);
                Point2D.Double double_4 = this.getPosition(vertexView2);
                Point2D.Double double_5 = new Point2D.Double(double_4.x + double_3.x, double_4.y + double_3.y);
                vertexView2.getAttributes().put(KEY_POSITION, double_5);
                this.cellList.add(vertexView2);
                ++n4;
            }
            ++n3;
        }
    }

    protected boolean isCluster(CellView cellView) {
        if (cellView.getAttributes().containsKey(KEY_IS_CLUSTER)) {
            if (this.isTrue((String)cellView.getAttributes().get(KEY_IS_CLUSTER))) {
                return true;
            }
            System.err.println("FATAL ERROR: CELL CANNOT CLEARLY BE IDENTIFIED AS A CLUSTER!!!");
            return false;
        }
        return false;
    }

    private Point2D.Double computeBarycenter(ArrayList arrayList) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < arrayList.size()) {
            CellView cellView = (CellView)arrayList.get(n);
            Point2D.Double double_ = this.getPosition(cellView);
            d += double_.x;
            d2 += double_.y;
            ++n;
        }
        return new Point2D.Double(d / (double)arrayList.size(), d2 / (double)arrayList.size());
    }

    private Rectangle getBoundingBox(ArrayList arrayList) {
        if (arrayList.size() > 0) {
            Point2D.Double double_ = this.getPosition((VertexView)arrayList.get(0));
            Dimension dimension = ((CellView)arrayList.get(0)).getBounds().getSize();
            double d = double_.getX();
            double d2 = double_.getX();
            double d3 = double_.getX() + dimension.getWidth();
            double d4 = double_.getX() + dimension.getHeight();
            int n = 1;
            while (n < arrayList.size()) {
                double_ = this.getPosition((VertexView)arrayList.get(n));
                dimension = ((CellView)arrayList.get(n)).getBounds().getSize();
                if (d > double_.getX()) {
                    d = double_.getX();
                }
                if (d2 > double_.getY()) {
                    d2 = double_.getY();
                }
                if (d3 < double_.getX() + dimension.getWidth()) {
                    d3 = double_.getX() + dimension.getWidth();
                }
                if (d4 < double_.getY() + dimension.getHeight()) {
                    d4 = double_.getY() + dimension.getHeight();
                }
                ++n;
            }
            Rectangle rectangle = new Rectangle((int)d, (int)d2, (int)(d3 - d), (int)(d4 - d2));
            return rectangle;
        }
        return null;
    }

    private Rectangle getBoundingBox() {
        return this.getBoundingBox(this.cellList);
    }
}

