/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites.templates;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class TemplatesPanel
extends TopComponent
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private TemplateTreeView view;
    private JTree tree;
    private static Set newlyCreatedFolders;
    private static FileObject templatesRoot;
    private JButton addButton;
    private JPanel buttonsPanel;
    private JButton deleteButton;
    private JButton duplicateButton;
    private JLabel jLabel1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton newFolderButton;
    private JButton renameButton;
    private JLabel templatesLabel;
    private JPanel treePanel;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$netbeans$modules$favorites$templates$TemplatesPanel$AddAction;
    static /* synthetic */ Class class$org$netbeans$modules$favorites$templates$TemplatesPanel$NewFolderAction;

    public TemplatesPanel() {
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.getExplorerManager()));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.getExplorerManager()));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.getExplorerManager()));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.getExplorerManager(), (boolean)true));
        this.initComponents();
        this.createTemplateView();
        this.treePanel.add((Component)((Object)this.view), "Center");
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.getExplorerManager(), (ActionMap)map));
        this.initialize();
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
        }
        return this.manager;
    }

    private void createTemplateView() {
        if (this.view == null) {
            this.view = new TemplateTreeView();
        }
        this.view.setRootVisible(false);
        this.view.setPopupAllowed(true);
        this.view.setDefaultActionAllowed(false);
    }

    private void initialize() {
        this.getExplorerManager().setRootContext(TemplatesPanel.getTemplateRootNode());
        this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)new SelectionListener());
        this.deleteButton.setEnabled(false);
        this.renameButton.setEnabled(false);
        this.duplicateButton.setEnabled(false);
        this.moveUpButton.setEnabled(false);
        this.moveDownButton.setEnabled(false);
        this.addButton.setEnabled(true);
    }

    static Node getTemplateRootNode() {
        DataFolder df = DataFolder.findFolder((FileObject)TemplatesPanel.getTemplatesRoot());
        return new TemplateNode((Node)new FilterNode(df.getNodeDelegate(), df.createNodeChildren((DataFilter)new TemplateFilter())));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.templatesLabel = new JLabel();
        this.treePanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.addButton = new JButton();
        this.newFolderButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.duplicateButton = new JButton();
        this.renameButton = new JButton();
        this.jSeparator2 = new JSeparator();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.jSeparator3 = new JSeparator();
        this.deleteButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)"jLabel1");
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(500, 300));
        Mnemonics.setLocalizedText((JLabel)this.templatesLabel, (String)NbBundle.getBundle((Class)TemplatesPanel.class).getString("LBL_TemplatesPanel_TemplatesLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add(this.templatesLabel, gridBagConstraints);
        this.treePanel.setLayout(new BorderLayout());
        this.treePanel.setBorder(new EtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 11, 0);
        this.add(this.treePanel, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getBundle((Class)TemplatesPanel.class).getString("BTN_TemplatesPanel_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TemplatesPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.newFolderButton, (String)NbBundle.getBundle((Class)TemplatesPanel.class).getString("BTN_TemplatesPanel_NewFolder"));
        this.newFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TemplatesPanel.this.newFolderButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.newFolderButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        this.buttonsPanel.add((Component)this.jSeparator1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.duplicateButton, (String)NbBundle.getBundle((Class)TemplatesPanel.class).getString("BTN_TemplatesPanel_DuplicateButton"));
        this.duplicateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TemplatesPanel.this.duplicateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.duplicateButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.renameButton, (String)NbBundle.getBundle((Class)TemplatesPanel.class).getString("BTN_TemplatesPanel_RenameButton"));
        this.renameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TemplatesPanel.this.renameButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.renameButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        this.buttonsPanel.add((Component)this.jSeparator2, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)NbBundle.getBundle((Class)TemplatesPanel.class).getString("BTN_TemplatesPanel_MoveUp"));
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TemplatesPanel.this.moveUpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.moveUpButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)NbBundle.getBundle((Class)TemplatesPanel.class).getString("BTN_TemplatesPanel_MoveDown"));
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TemplatesPanel.this.moveDownButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.moveDownButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        this.buttonsPanel.add((Component)this.jSeparator3, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)NbBundle.getBundle((Class)TemplatesPanel.class).getString("BTN_TemplatesPanel_Delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TemplatesPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.deleteButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 11, 11, 8);
        this.add(this.buttonsPanel, gridBagConstraints);
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        this.moveDown(this.manager.getSelectedNodes());
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        this.moveUp(this.manager.getSelectedNodes());
    }

    private void newFolderButtonActionPerformed(ActionEvent evt) {
        DataFolder df = TemplatesPanel.doNewFolder(this.manager.getSelectedNodes());
        if (!$assertionsDisabled && df == null) {
            throw new AssertionError((Object)"New DataFolder has been created.");
        }
        try {
            Node[] nodes = this.manager.getSelectedNodes();
            Node targerNode = null;
            targerNode = nodes == null || nodes.length == 0 ? this.manager.getRootContext() : (nodes[0].isLeaf() ? nodes[0].getParentNode() : nodes[0]);
            targerNode.getChildren().getNodes(true);
            Node newSubfolder = targerNode.getChildren().findChild(df.getName());
            if (!$assertionsDisabled && newSubfolder == null) {
                throw new AssertionError((Object)("Node for subfolder found in nodes: " + Arrays.asList(targerNode.getChildren().getNodes())));
            }
            this.manager.setSelectedNodes(new Node[]{newSubfolder});
            this.view.invokeInplaceEditing();
        }
        catch (PropertyVetoException pve) {
            ErrorManager.getDefault().notify(1, (Throwable)pve);
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        Node[] nodes = this.manager.getSelectedNodes();
        for (int i = 0; i < nodes.length; ++i) {
            try {
                nodes[i].destroy();
                continue;
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(1, (Throwable)ioe);
            }
        }
    }

    private void duplicateButtonActionPerformed(ActionEvent evt) {
        Node[] nodes = this.manager.getSelectedNodes();
        if (!$assertionsDisabled && nodes == null) {
            throw new AssertionError((Object)"Selected Nodes cannot be null.");
        }
        if (!$assertionsDisabled && nodes.length != 1) {
            throw new AssertionError((Object)("One one node can be selected, but was " + Arrays.asList(nodes)));
        }
        TemplatesPanel.createDuplicateFromNode(nodes[0]);
    }

    private void renameButtonActionPerformed(ActionEvent evt) {
        Node[] nodes = this.manager.getSelectedNodes();
        if (!$assertionsDisabled && nodes == null) {
            throw new AssertionError((Object)"Selected Nodes cannot be null.");
        }
        if (!$assertionsDisabled && nodes.length != 1) {
            throw new AssertionError((Object)("One one node can be selected, but was " + Arrays.asList(nodes)));
        }
        this.view.invokeInplaceEditing();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        TemplatesPanel.doAdd(this.manager.getSelectedNodes());
    }

    private static DataObject getDOFromNode(Node n) {
        DataObject dobj = (DataObject)n.getLookup().lookup(DataObject.class);
        if (!$assertionsDisabled && dobj == null) {
            throw new AssertionError((Object)("DataObject for node " + n));
        }
        return dobj;
    }

    private static DataFolder getTargetFolder(Node[] nodes) {
        DataFolder folder = null;
        if (nodes == null || nodes.length == 0) {
            folder = DataFolder.findFolder((FileObject)TemplatesPanel.getTemplatesRoot());
        } else {
            folder = (DataFolder)nodes[0].getLookup().lookup(DataFolder.class);
            if (folder == null && nodes[0].isLeaf()) {
                Node parent = nodes[0].getParentNode();
                folder = (DataFolder)parent.getLookup().lookup(DataFolder.class);
            }
        }
        return folder;
    }

    static DataObject createTemplateFromFile(File file, DataFolder preferred) {
        if (file == null) {
            throw new IllegalArgumentException("Argument file cannot be null!");
        }
        FileObject sourceFO = FileUtil.toFileObject((File)file);
        if (!$assertionsDisabled && sourceFO == null) {
            throw new AssertionError((Object)("FileObject found for file " + file));
        }
        DataObject sourceDO = null;
        try {
            sourceDO = DataObject.find((FileObject)sourceFO);
        }
        catch (DataObjectNotFoundException donfe) {
            ErrorManager.getDefault().notify(1, (Throwable)donfe);
        }
        if (!$assertionsDisabled && sourceDO == null) {
            throw new AssertionError((Object)("DataObject found for FileObject " + sourceFO));
        }
        DataFolder folder = preferred == null ? DataFolder.findFolder((FileObject)TemplatesPanel.getTemplatesRoot()) : preferred;
        DataObject template = null;
        try {
            template = sourceDO.copy(folder);
            template.setTemplate(true);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        return template;
    }

    private static void doAdd(Node[] nodes) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getBundle((Class)TemplatesPanel.class).getString("LBL_TemplatesPanel_JFileChooser_Title"));
        chooser.setApproveButtonText(NbBundle.getBundle((Class)TemplatesPanel.class).getString("BTN_TemplatesPanel_JFileChooser_AddButtonName"));
        chooser.setFileHidingEnabled(false);
        chooser.setMultiSelectionEnabled(false);
        int result = chooser.showOpenDialog(null);
        if (0 == result) {
            File f = chooser.getSelectedFile();
            if (!$assertionsDisabled && f == null) {
                throw new AssertionError();
            }
            DataObject newDO = TemplatesPanel.createTemplateFromFile(f, TemplatesPanel.getTargetFolder(nodes));
        }
    }

    private static DataFolder doNewFolder(Node[] nodes) {
        DataFolder df = null;
        DataFolder pref = TemplatesPanel.getTargetFolder(nodes);
        if (pref == null) {
            pref = DataFolder.findFolder((FileObject)TemplatesPanel.getTemplatesRoot());
            if (!$assertionsDisabled && pref == null) {
                throw new AssertionError((Object)("DataFolder found for FO " + TemplatesPanel.getTemplatesRoot()));
            }
        }
        try {
            df = DataFolder.create((DataFolder)pref, (String)NbBundle.getBundle((Class)TemplatesPanel.class).getString("TXT_TemplatesPanel_NewFolderName"));
            if (!$assertionsDisabled && df == null) {
                throw new AssertionError((Object)("New subfolder found in folder " + pref));
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        return df;
    }

    static DataObject createDuplicateFromNode(Node n) {
        DataObject source = TemplatesPanel.getDOFromNode(n);
        try {
            return source.copy(source.getFolder());
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
            return null;
        }
    }

    static FileObject getTemplatesRoot() {
        if (templatesRoot == null) {
            templatesRoot = Repository.getDefault().getDefaultFileSystem().findResource("Templates");
        }
        return templatesRoot;
    }

    private boolean isMoveUpEnabled(Node[] nodes) {
        if (nodes == null || nodes.length != 1 || !nodes[0].isLeaf()) {
            return false;
        }
        int pos = this.getNodePosition(nodes[0]);
        return pos != -1 && pos > 0;
    }

    private boolean isMoveDownEnabled(Node[] nodes) {
        if (nodes == null || nodes.length != 1 || !nodes[0].isLeaf()) {
            return false;
        }
        int count = nodes[0].getParentNode().getChildren().getNodesCount();
        int pos = this.getNodePosition(nodes[0]);
        return pos != -1 && pos < count - 1;
    }

    private int getNodePosition(Node n) {
        Index supp = this.getIndexSupport(n);
        DataFolder df = (DataFolder)n.getParentNode().getLookup().lookup(DataFolder.class);
        df.getNodeDelegate().getChildren().getNodes(true);
        int pos = supp.indexOf(n);
        if (!$assertionsDisabled && pos == -1) {
            throw new AssertionError((Object)("Node " + n + " has position " + pos + " in children " + Arrays.asList(n.getParentNode().getChildren().getNodes())));
        }
        return pos;
    }

    private Index getIndexSupport(Node n) {
        Node parent = n.getParentNode();
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError((Object)("Node " + n + " has a parent."));
        }
        Index index = (Index)parent.getLookup().lookup(Index.class);
        if (!$assertionsDisabled && index == null) {
            throw new AssertionError((Object)("Node " + parent + " has Index cookie."));
        }
        return index;
    }

    private void moveUp(Node[] nodes) {
        if (!$assertionsDisabled && nodes == null) {
            throw new AssertionError((Object)"Nodes to moveUp cannot be null.");
        }
        if (!$assertionsDisabled && nodes.length != 1) {
            throw new AssertionError((Object)("Only one node can be moveUp, not " + Arrays.asList(nodes)));
        }
        if (!$assertionsDisabled && !nodes[0].isLeaf()) {
            throw new AssertionError((Object)("Only leaf node can be moveUp, not " + nodes[0]));
        }
        Node n = nodes[0];
        Index supp = this.getIndexSupport(n);
        int origPos = this.getNodePosition(n);
        if (origPos == -1) {
            return;
        }
        supp.moveUp(origPos);
        if (!$assertionsDisabled && origPos - 1 != this.getNodePosition(n)) {
            throw new AssertionError((Object)("Node " + n + " has been moved from " + origPos + " to pos " + this.getNodePosition(n)));
        }
    }

    private void moveDown(Node[] nodes) {
        if (!$assertionsDisabled && nodes == null) {
            throw new AssertionError((Object)"Nodes to moveDown cannot be null.");
        }
        if (!$assertionsDisabled && nodes.length != 1) {
            throw new AssertionError((Object)("Only one node can be moveDown, not " + Arrays.asList(nodes)));
        }
        if (!$assertionsDisabled && !nodes[0].isLeaf()) {
            throw new AssertionError((Object)("Only leaf node can be moveDown, not " + nodes[0]));
        }
        Node n = nodes[0];
        Index supp = this.getIndexSupport(n);
        int origPos = this.getNodePosition(n);
        if (origPos == -1) {
            return;
        }
        supp.moveDown(origPos);
        if (!$assertionsDisabled && origPos + 1 != this.getNodePosition(n)) {
            throw new AssertionError((Object)("Node " + n + " has been moved from " + origPos + " to pos " + this.getNodePosition(n)));
        }
    }

    static {
        $assertionsDisabled = !TemplatesPanel.class.desiredAssertionStatus();
    }

    private static class NewFolderAction
    extends NodeAction {
        private NewFolderAction() {
        }

        protected void performAction(Node[] activatedNodes) {
            TemplatesPanel.doNewFolder(activatedNodes);
        }

        protected boolean enable(Node[] activatedNodes) {
            return activatedNodes != null && activatedNodes.length == 1;
        }

        public String getName() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$favorites$templates$TemplatesPanel == null ? (class$org$netbeans$modules$favorites$templates$TemplatesPanel = TemplatesPanel.class$("org.netbeans.modules.favorites.templates.TemplatesPanel")) : class$org$netbeans$modules$favorites$templates$TemplatesPanel)).getString("BTN_TemplatesPanel_NewFolder");
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected boolean asynchronous() {
            return true;
        }
    }

    private static class AddAction
    extends NodeAction {
        private AddAction() {
        }

        protected void performAction(Node[] activatedNodes) {
            TemplatesPanel.doAdd(activatedNodes);
        }

        protected boolean enable(Node[] activatedNodes) {
            return activatedNodes != null && activatedNodes.length == 1;
        }

        public String getName() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$favorites$templates$TemplatesPanel == null ? (class$org$netbeans$modules$favorites$templates$TemplatesPanel = TemplatesPanel.class$("org.netbeans.modules.favorites.templates.TemplatesPanel")) : class$org$netbeans$modules$favorites$templates$TemplatesPanel)).getString("BTN_TemplatesPanel_Add");
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected boolean asynchronous() {
            return true;
        }
    }

    private static class DataFolderFilterChildren
    extends FilterNode.Children {
        public DataFolderFilterChildren(Node n) {
            super(n);
        }

        protected Node[] createNodes(Object key) {
            Node n = (Node)key;
            Node[] orig = super.createNodes(key);
            Node[] filtered = new Node[orig.length];
            for (int i = 0; i < orig.length; ++i) {
                DataObject dobj = TemplatesPanel.getDOFromNode(orig[i]);
                filtered[i] = dobj.isTemplate() ? new TemplateNode(orig[i], Children.LEAF) : new TemplateNode(orig[i]);
            }
            return filtered;
        }
    }

    private static class TemplateNode
    extends FilterNode {
        private static Action[] ACTIONS_ON_LEAF = new Action[]{SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = TemplatesPanel.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = TemplatesPanel.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = TemplatesPanel.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = TemplatesPanel.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = TemplatesPanel.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction))};
        private static Action[] ACTIONS_ON_FOLDER = new Action[]{SystemAction.get((Class)(class$org$netbeans$modules$favorites$templates$TemplatesPanel$AddAction == null ? (class$org$netbeans$modules$favorites$templates$TemplatesPanel$AddAction = TemplatesPanel.class$("org.netbeans.modules.favorites.templates.TemplatesPanel$AddAction")) : class$org$netbeans$modules$favorites$templates$TemplatesPanel$AddAction)), SystemAction.get((Class)(class$org$netbeans$modules$favorites$templates$TemplatesPanel$NewFolderAction == null ? (class$org$netbeans$modules$favorites$templates$TemplatesPanel$NewFolderAction = TemplatesPanel.class$("org.netbeans.modules.favorites.templates.TemplatesPanel$NewFolderAction")) : class$org$netbeans$modules$favorites$templates$TemplatesPanel$NewFolderAction)), null, SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = TemplatesPanel.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = TemplatesPanel.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = TemplatesPanel.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = TemplatesPanel.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = TemplatesPanel.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction))};

        public TemplateNode(Node n) {
            this(n, (Children)new DataFolderFilterChildren(n), new InstanceContent());
        }

        public TemplateNode(Node n, Children ch) {
            this(n, ch, new InstanceContent());
        }

        private TemplateNode(Node originalNode, Children ch, InstanceContent content) {
            super(originalNode, ch, (Lookup)new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)content), originalNode.getLookup()}));
            DataObject dobj = TemplatesPanel.getDOFromNode(originalNode);
            if (dobj.isValid()) {
                DataFolder folder = null;
                if (dobj instanceof DataFolder) {
                    folder = (DataFolder)dobj;
                } else if (dobj.getPrimaryFile().getParent() != null && dobj.getPrimaryFile().getParent().isValid()) {
                    folder = dobj.getFolder();
                }
                if (folder != null) {
                    content.add((Object)new DataFolder.Index(folder, (Node)this));
                }
            }
            content.add((Object)this);
        }

        public Action[] getActions(boolean context) {
            return this.isLeaf() ? ACTIONS_ON_LEAF : ACTIONS_ON_FOLDER;
        }

        public Action getPreferredAction() {
            return null;
        }
    }

    private static final class TemplateFilter
    implements DataFilter {
        private TemplateFilter() {
        }

        public boolean acceptDataObject(DataObject obj) {
            return this.acceptTemplate(obj);
        }

        private boolean acceptTemplate(DataObject d) {
            if (d.isTemplate()) {
                return true;
            }
            if (d instanceof DataFolder) {
                Object o = d.getPrimaryFile().getAttribute("simple");
                return o == null || Boolean.TRUE.equals(o);
            }
            return false;
        }
    }

    private class SelectionListener
    implements PropertyChangeListener {
        private SelectionListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                final Node[] nodes = (Node[])evt.getNewValue();
                TemplatesPanel.this.deleteButton.setEnabled(nodes != null && nodes.length > 0);
                TemplatesPanel.this.renameButton.setEnabled(nodes != null && nodes.length == 1);
                TemplatesPanel.this.duplicateButton.setEnabled(nodes != null && nodes.length == 1 && nodes[0].isLeaf());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TemplatesPanel.this.moveUpButton.setEnabled(TemplatesPanel.this.isMoveUpEnabled(nodes));
                        TemplatesPanel.this.moveDownButton.setEnabled(TemplatesPanel.this.isMoveDownEnabled(nodes));
                    }
                });
            }
        }
    }

    private static class TemplateTreeView
    extends BeanTreeView {
        private Action startEditing;
        static final /* synthetic */ boolean $assertionsDisabled;

        private TemplateTreeView() {
        }

        private void invokeInplaceEditing() {
            Action o;
            if (this.startEditing == null && (o = this.tree.getActionMap().get("startEditing")) != null && o instanceof Action) {
                this.startEditing = o;
            }
            if (!$assertionsDisabled && this.startEditing == null) {
                throw new AssertionError((Object)("startEditing is on tree ActionMap " + Arrays.asList(this.tree.getActionMap().keys())));
            }
            this.startEditing.actionPerformed(new ActionEvent(this.tree, 0, "startEditing"));
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$favorites$templates$TemplatesPanel == null ? (class$org$netbeans$modules$favorites$templates$TemplatesPanel = TemplatesPanel.class$("org.netbeans.modules.favorites.templates.TemplatesPanel")) : class$org$netbeans$modules$favorites$templates$TemplatesPanel).desiredAssertionStatus();
        }
    }
}

