/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.project.ui.PhysicalView;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.NbBundle;

public class BrowseFolders
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private SourceGroup[] folders;
    private BeanTreeView btv;
    private Project project;
    private static JScrollPane SAMPLE_SCROLL_PANE = new JScrollPane();
    private JPanel folderPanel;
    private JLabel jLabel1;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public BrowseFolders(SourceGroup[] folders, Project project, String preselectedFileName) {
        this.initComponents();
        this.folders = folders;
        this.project = project;
        this.manager = new ExplorerManager();
        AbstractNode rootNode = new AbstractNode((Children)new SourceGroupsChildren(folders, project));
        this.manager.setRootContext((Node)rootNode);
        this.btv = new BeanTreeView();
        this.btv.setRootVisible(false);
        this.btv.setSelectionMode(1);
        this.btv.setBorder(SAMPLE_SCROLL_PANE.getBorder());
        this.btv.setPopupAllowed(false);
        this.btv.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)BrowseFolders.class, (String)"ACSN_BrowseFolders_folderPanel"));
        this.btv.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BrowseFolders.class, (String)"ACSD_BrowseFolders_folderPanel"));
        this.expandSelection(preselectedFileName);
        this.folderPanel.add((Component)this.btv, "Center");
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.folderPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 12, 12)));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)BrowseFolders.class, (String)"ACSN_BrowseFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BrowseFolders.class, (String)"ACSN_BrowseFolders"));
        this.jLabel1.setDisplayedMnemonic(NbBundle.getMessage((Class)BrowseFolders.class, (String)"MNE_BrowseFolders_jLabel1").charAt(0));
        this.jLabel1.setLabelFor(this.folderPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage((Class)BrowseFolders.class, (String)"LBL_BrowseFolders_jLabel1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)BrowseFolders.class, (String)"ACSN_BrowseFolders_jLabel1"));
        this.folderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.folderPanel, gridBagConstraints);
    }

    public static FileObject showDialog(SourceGroup[] folders, Project project, String preselectedFileName) {
        BrowseFolders bf = new BrowseFolders(folders, project, preselectedFileName);
        Object[] options = new JButton[]{new JButton(NbBundle.getMessage((Class)BrowseFolders.class, (String)"BTN_BrowseFolders_Select_Option")), new JButton(NbBundle.getMessage((Class)BrowseFolders.class, (String)"BTN_BrowseFolders_Cancel_Option"))};
        OptionsListener optionsListener = new OptionsListener(bf);
        options[0].setActionCommand("SELECT");
        options[0].addActionListener(optionsListener);
        options[0].setMnemonic(NbBundle.getMessage((Class)BrowseFolders.class, (String)"MNE_BrowseFolders_Select_Option").charAt(0));
        options[0].getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)BrowseFolders.class, (String)"ACSN_BrowseFolders_Select_Option"));
        options[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BrowseFolders.class, (String)"ACSD_BrowseFolders_Select_Option"));
        options[1].setActionCommand("CANCEL");
        options[1].addActionListener(optionsListener);
        options[1].getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)BrowseFolders.class, (String)"ACSN_BrowseFolders_Cancel_Option"));
        options[1].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)BrowseFolders.class, (String)"ACSD_BrowseFolders_Cancel_Option"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)bf, NbBundle.getMessage((Class)BrowseFolders.class, (String)"LBL_BrowseFolders_Dialog"), true, options, (Object)options[0], 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[]{options[0], options[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.show();
        return optionsListener.getResult();
    }

    private void expandSelection(String preselectedFileName) {
        int i;
        Node root = this.manager.getRootContext();
        Children ch = root.getChildren();
        if (ch == Children.LEAF) {
            return;
        }
        Node[] nodes = ch.getNodes(true);
        Node sel = null;
        if (preselectedFileName != null && preselectedFileName.length() > 0) {
            for (i = 0; i < nodes.length; ++i) {
                try {
                    sel = NodeOp.findPath((Node)nodes[i], (Enumeration)new StringTokenizer(preselectedFileName, "/"));
                    break;
                }
                catch (NodeNotFoundException e) {
                    System.out.println(e.getMissingChildName());
                    continue;
                }
            }
        }
        if (sel == null) {
            this.btv.expandNode(root);
            for (i = 0; i < nodes.length; ++i) {
                this.btv.expandNode(nodes[i]);
                if (i != 0) continue;
                sel = nodes[i];
            }
        }
        if (sel != null) {
            try {
                this.manager.setSelectedNodes(new Node[]{sel});
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
    }

    private static final class OptionsListener
    implements ActionListener {
        public static final String COMMAND_SELECT = "SELECT";
        public static final String COMMAND_CANCEL = "CANCEL";
        private BrowseFolders browsePanel;
        private FileObject result;

        public OptionsListener(BrowseFolders browsePanel) {
            this.browsePanel = browsePanel;
        }

        public void actionPerformed(ActionEvent e) {
            FileObject fo;
            DataObject dobj;
            Node[] selection;
            String command = e.getActionCommand();
            if (COMMAND_SELECT.equals(command) && (selection = this.browsePanel.getExplorerManager().getSelectedNodes()) != null && selection.length > 0 && (dobj = (DataObject)selection[0].getLookup().lookup(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = BrowseFolders.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject)) != null && (fo = dobj.getPrimaryFile()).isFolder()) {
                this.result = fo;
            }
        }

        public FileObject getResult() {
            return this.result;
        }
    }

    private static final class SourceGroupsChildren
    extends Children.Keys {
        private SourceGroup[] groups;
        private SourceGroup group;
        private FileObject fo;
        private Project project;

        public SourceGroupsChildren(SourceGroup[] groups, Project project) {
            this.groups = groups;
            this.project = project;
        }

        public SourceGroupsChildren(FileObject fo, SourceGroup group) {
            this.fo = fo;
            this.group = group;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            FileObject folder = null;
            SourceGroup group = null;
            if (key instanceof SourceGroup) {
                folder = ((SourceGroup)key).getRootFolder();
                group = (SourceGroup)key;
                FilterNode fn = new FilterNode((Node)new PhysicalView.GroupNode(this.project, group, folder.equals(this.project.getProjectDirectory()), DataFolder.findFolder((FileObject)folder)), (Children)new SourceGroupsChildren(folder, group));
                return new Node[]{fn};
            }
            if (key instanceof Key) {
                folder = ((Key)key).folder;
                group = ((Key)key).group;
                FilterNode fn = new FilterNode(DataFolder.findFolder((FileObject)folder).getNodeDelegate(), (Children)new SourceGroupsChildren(folder, group));
                return new Node[]{fn};
            }
            return new Node[0];
        }

        private Collection getKeys() {
            if (this.groups != null) {
                return Arrays.asList(this.groups);
            }
            FileObject[] files = this.fo.getChildren();
            ArrayList<Key> children = new ArrayList<Key>(files.length);
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFolder() || !this.group.contains(files[i]) || !VisibilityQuery.getDefault().isVisible(files[i])) continue;
                children.add(new Key(files[i], this.group));
            }
            return children;
        }

        private static class Key {
            private FileObject folder;
            private SourceGroup group;

            private Key(FileObject folder, SourceGroup group) {
                this.folder = folder;
                this.group = group;
            }
        }
    }
}

