/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.docscan;

import org.netbeans.modules.tasklist.client.SuggestionPriority;
import org.netbeans.modules.tasklist.docscan.TaskTag;
import org.netbeans.modules.tasklist.docscan.TaskTags;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class Settings
extends SystemOption {
    static final long serialVersionUID = -29424677132370773L;
    public static final String PROP_SCAN_SKIP = "skipComments";
    public static final String PROP_SCAN_TAGS = "taskTags";
    static final String PROP_MODIFICATION_TIME = "modificationTime";
    public static final String PROP_USABILITY_LIMIT = "usabilityLimit";
    private static final int DEFAULT_USABILITY_LIMIT = 300;
    private TaskTags tags = null;

    public static Settings getDefault() {
        return (Settings)Settings.findObject((Class)Settings.class, (boolean)true);
    }

    public String displayName() {
        return NbBundle.getMessage((Class)Settings.class, (String)"OPTION_TASK_SETTINGS_NAME");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(Settings.class);
    }

    public boolean getSkipComments() {
        Boolean b = (Boolean)this.getProperty(PROP_SCAN_SKIP);
        return b == Boolean.TRUE;
    }

    public void setSkipComments(boolean doSkip) {
        Boolean b = doSkip ? Boolean.TRUE : Boolean.FALSE;
        this.putProperty(PROP_SCAN_SKIP, b, true);
        this.modified();
    }

    public void setUsabilityLimit(int limit) {
        if (limit > 1000) {
            limit = 1000;
        }
        if (limit <= 0) {
            limit = 300;
        }
        this.putProperty(PROP_USABILITY_LIMIT, new Integer(limit));
    }

    public int getUsabilityLimit() {
        Integer limit = (Integer)this.getProperty(PROP_USABILITY_LIMIT);
        if (limit == null) {
            return 300;
        }
        return limit;
    }

    public TaskTags getTaskTags() {
        if (this.tags == null) {
            TaskTags d = (TaskTags)this.getProperty(PROP_SCAN_TAGS);
            if (d != null) {
                this.tags = d;
            } else {
                this.tags = new TaskTags();
                this.tags.setTags(new TaskTag[]{new TaskTag("@todo", SuggestionPriority.MEDIUM), new TaskTag("TODO", SuggestionPriority.MEDIUM), new TaskTag("FIXME", SuggestionPriority.MEDIUM), new TaskTag("XXX", SuggestionPriority.MEDIUM), new TaskTag("PENDING", SuggestionPriority.MEDIUM), new TaskTag("<<<<<<<", SuggestionPriority.HIGH)});
            }
        }
        return this.tags;
    }

    public void setTaskTags(TaskTags scanTasks) {
        this.tags = scanTasks;
        this.putProperty(PROP_SCAN_TAGS, this.tags, true);
        this.modified();
    }

    public long getModificationTime() {
        Long time = (Long)this.getProperty(PROP_MODIFICATION_TIME);
        if (time == null) {
            return 0L;
        }
        return time;
    }

    public void setModificationTime(long time) {
        this.putProperty(PROP_MODIFICATION_TIME, new Long(time));
    }

    private void modified() {
        if (!this.isReadExternal()) {
            this.putProperty(PROP_MODIFICATION_TIME, new Long(System.currentTimeMillis()));
        }
    }
}

