/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.junit.output.RegexpUtils;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.ResultDisplayHandler;
import org.netbeans.modules.junit.output.ResultTreeView;
import org.netbeans.modules.junit.output.RootNode;
import org.netbeans.modules.junit.output.TestsuiteNode;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class ResultPanelTree
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
ItemListener {
    private final ExplorerManager explorerManager;
    private final RootNode rootNode;
    private final ResultTreeView treeView;
    private AbstractButton btnFilter;
    private boolean filtered = false;
    private ChangeListener changeListener;
    private ChangeEvent changeEvent;
    private final RegexpUtils regexpUtils = RegexpUtils.getInstance();
    private final ResultDisplayHandler displayHandler;

    ResultPanelTree(ResultDisplayHandler displayHandler) {
        super(new BorderLayout());
        this.treeView = new ResultTreeView();
        this.add((Component)((Object)this.treeView), "Center");
        this.explorerManager = new ExplorerManager();
        this.rootNode = new RootNode(this.filtered);
        this.explorerManager.setRootContext((Node)this.rootNode);
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.initFilter();
        this.initAccessibility();
        this.displayHandler = displayHandler;
    }

    private void initFilter() {
        this.btnFilter = new JToggleButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/junit/output/res/filter.png", (boolean)true)));
        this.btnFilter.getAccessibleContext().setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_FilterButton"));
        this.btnFilter.addItemListener(this);
        this.updateBtnFilterLabel();
    }

    private void initAccessibility() {
        AccessibleContext accessCtx = this.getAccessibleContext();
        accessCtx.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_ResultPanelTree"));
        accessCtx.setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACSD_ResultPanelTree"));
        accessCtx = this.treeView.getHorizontalScrollBar().getAccessibleContext();
        accessCtx.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_HorizontalScrollbar"));
        accessCtx = this.treeView.getVerticalScrollBar().getAccessibleContext();
        accessCtx.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_HorizontalScrollbar"));
    }

    AbstractButton getFilterButton() {
        return this.btnFilter;
    }

    private void updateBtnFilterLabel() {
        String key = this.filtered ? "MultiviewPanel.btnFilter.showAll.tooltip" : "MultiviewPanel.btnFilter.showFailures.tooltip";
        this.btnFilter.setToolTipText(NbBundle.getMessage(this.getClass(), (String)key));
    }

    public void itemStateChanged(ItemEvent e) {
        this.setFiltered(this.btnFilter.isSelected());
        this.updateBtnFilterLabel();
    }

    void displayMsg(String msg) {
        assert (EventQueue.isDispatchThread());
        this.rootNode.displayMessage(msg);
    }

    public void addNotify() {
        super.addNotify();
        this.displayHandler.setTreePanel(this);
    }

    void displaySuiteRunning(String suiteName) {
        assert (EventQueue.isDispatchThread());
        this.rootNode.displaySuiteRunning(suiteName);
    }

    void displayReport(Report report) {
        assert (EventQueue.isDispatchThread());
        TestsuiteNode node = this.rootNode.displayReport(report);
        if (node != null && report.containsFailed()) {
            this.treeView.expandReportNode(node);
        }
        this.btnFilter.setEnabled(this.rootNode.getSuccessDisplayedLevel() != 0);
    }

    void displayReports(List reports) {
        assert (EventQueue.isDispatchThread());
        int count = reports.size();
        if (count == 0) {
            return;
        }
        if (count == 1) {
            this.displayReport((Report)reports.get(0));
        } else {
            this.rootNode.displayReports(reports);
        }
        this.btnFilter.setEnabled(this.rootNode.getSuccessDisplayedLevel() != 0);
    }

    void viewOpened() {
        assert (EventQueue.isDispatchThread());
    }

    void setFiltered(boolean filtered) {
        if (filtered == this.filtered) {
            return;
        }
        this.filtered = filtered;
        this.rootNode.setFiltered(filtered);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("selectedNodes".equals(e.getPropertyName())) {
            this.nodeSelectionChanged();
        }
    }

    private void nodeSelectionChanged() {
        assert (EventQueue.isDispatchThread());
        this.fireChange();
    }

    void setChangeListener(ChangeListener l) {
        assert (EventQueue.isDispatchThread());
        this.changeListener = l;
        if (this.changeListener == null) {
            this.changeEvent = null;
        } else if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
    }

    private void fireNodeSelectionChange() {
        this.fireChange();
    }

    private void fireChange() {
        assert (EventQueue.isDispatchThread());
        if (this.changeListener != null) {
            this.changeListener.stateChanged(this.changeEvent);
        }
    }

    Node[] getSelectedNodes() {
        return this.explorerManager.getSelectedNodes();
    }

    private void selectAndActivateNode(Node node) {
        Node[] nodeArray = new Node[]{node};
        try {
            this.explorerManager.setSelectedNodes(nodeArray);
            this.fireNodeSelectionChange();
        }
        catch (PropertyVetoException ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
            nodeArray = new Node[]{};
            try {
                this.explorerManager.setSelectedNodes(nodeArray);
                this.fireNodeSelectionChange();
            }
            catch (PropertyVetoException ex2) {
                ErrorManager.getDefault().notify(4096, (Throwable)ex2);
            }
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public boolean requestFocusInWindow() {
        return this.treeView.requestFocusInWindow();
    }
}

