/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasourceHelper {
    private DatasourceHelper() {
    }

    public static List<DatabaseConnection> findDatabaseConnections(Datasource datasource) {
        if (datasource == null) {
            throw new NullPointerException("The datasource parameter cannot be null.");
        }
        String databaseUrl = datasource.getUrl();
        String user = datasource.getUsername();
        if (databaseUrl == null || user == null) {
            return Collections.emptyList();
        }
        ArrayList<DatabaseConnection> result = new ArrayList<DatabaseConnection>();
        for (DatabaseConnection dbconn : ConnectionManager.getDefault().getConnections()) {
            if (!databaseUrl.equals(dbconn.getDatabaseURL()) || !user.equals(dbconn.getUser())) continue;
            result.add(dbconn);
        }
        if (result.size() > 0) {
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    public static Datasource findDatasource(J2eeModuleProvider provider, String jndiName) {
        if (provider == null) {
            throw new NullPointerException("The provider parameter cannot be null.");
        }
        if (jndiName == null) {
            throw new NullPointerException("The jndiName parameter cannot be null.");
        }
        for (Datasource datasource : provider.getServerDatasources()) {
            if (!jndiName.equals(datasource.getJndiName())) continue;
            return datasource;
        }
        for (Datasource datasource : provider.getModuleDatasources()) {
            if (!jndiName.equals(datasource.getJndiName())) continue;
            return datasource;
        }
        return null;
    }
}

