/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DatasourceCustomizer
extends JPanel {
    private final Color nbErrorForeground;
    private Dialog dialog = null;
    private DialogDescriptor descriptor = null;
    private boolean dialogOK = false;
    private HashMap<String, Datasource> datasources;
    private String jndiName;
    private String url;
    private String username;
    private String password;
    private String driverClassName;
    private JComboBox connCombo;
    private JLabel errorLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField jndiNameField;

    public DatasourceCustomizer(List<Datasource> datasources) {
        if (datasources != null) {
            this.datasources = new HashMap();
            for (Datasource ds : datasources) {
                if (ds.getJndiName() == null) continue;
                this.datasources.put(ds.getJndiName(), ds);
            }
        }
        this.initComponents();
        DatabaseExplorerUIs.connect((JComboBox)this.connCombo, (ConnectionManager)ConnectionManager.getDefault());
        this.connCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DatasourceCustomizer.this.verify();
            }
        });
        this.jndiNameField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                DatasourceCustomizer.this.verify();
            }

            public void insertUpdate(DocumentEvent e) {
                DatasourceCustomizer.this.verify();
            }

            public void removeUpdate(DocumentEvent e) {
                DatasourceCustomizer.this.verify();
            }
        });
        Color errorColor = UIManager.getColor("nb.errorForeground");
        if (errorColor == null) {
            errorColor = new Color(255, 0, 0);
        }
        this.nbErrorForeground = errorColor;
        this.errorLabel.setForeground(this.nbErrorForeground);
    }

    public boolean showDialog() {
        this.descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(DatasourceCustomizer.class, (String)"LBL_DatasourceCustomizer"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(DatasourceCustomizer.class), new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean close = true;
                if (DatasourceCustomizer.this.descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                    boolean valid;
                    close = valid = DatasourceCustomizer.this.handleConfirmation();
                    DatasourceCustomizer.this.dialogOK = valid;
                }
                if (close) {
                    DatasourceCustomizer.this.dialog.dispose();
                }
            }
        });
        this.descriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
        this.verify();
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        this.dialog.setVisible(true);
        this.repaint();
        return this.dialogOK;
    }

    private boolean handleConfirmation() {
        this.jndiName = this.jndiNameField.getText().trim();
        DatabaseConnection conn = (DatabaseConnection)this.connCombo.getSelectedItem();
        if (conn.getPassword() == null) {
            ConnectionManager.getDefault().showConnectionDialog(conn);
        }
        if (conn.getPassword() == null) {
            this.errorLabel.setText(NbBundle.getMessage(DatasourceCustomizer.class, (String)"ERR_NoPassword"));
            return false;
        }
        this.url = conn.getDatabaseURL();
        this.username = conn.getUser();
        this.password = conn.getPassword();
        this.driverClassName = conn.getDriverClass();
        return true;
    }

    private boolean verify() {
        boolean isValid = this.verifyJndiName();
        if (isValid) {
            isValid = this.verifyConnection();
        }
        return isValid;
    }

    private boolean verifyJndiName() {
        boolean valid = true;
        String jndiName = this.jndiNameField.getText().trim();
        if (jndiName.length() == 0) {
            this.errorLabel.setText(NbBundle.getMessage(DatasourceCustomizer.class, (String)"ERR_JNDI_NAME_EMPTY"));
            valid = false;
        } else if (this.datasourceAlreadyExists(jndiName)) {
            this.errorLabel.setText(NbBundle.getMessage(DatasourceCustomizer.class, (String)"ERR_DS_EXISTS"));
            valid = false;
        } else {
            this.errorLabel.setText("");
        }
        this.descriptor.setValid(valid);
        return valid;
    }

    private boolean verifyConnection() {
        boolean valid = true;
        if (!(this.connCombo.getSelectedItem() instanceof DatabaseConnection)) {
            this.errorLabel.setText(NbBundle.getMessage(DatasourceCustomizer.class, (String)"ERR_NO_CONN_SELECTED"));
            valid = false;
        } else {
            this.errorLabel.setText("");
        }
        this.descriptor.setValid(valid);
        return valid;
    }

    private boolean datasourceAlreadyExists(String jndiName) {
        return this.datasources.containsKey(jndiName);
    }

    String getJndiName() {
        return this.jndiName;
    }

    String getUrl() {
        return this.url;
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    String getDriverClassName() {
        return this.driverClassName;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jndiNameField = new JTextField();
        this.errorLabel = new JLabel();
        this.connCombo = new JComboBox();
        this.setForeground(new Color(255, 0, 0));
        this.jLabel1.setLabelFor(this.jndiNameField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DatasourceCustomizer.class, (String)"LBL_DSC_JndiName"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(DatasourceCustomizer.class, (String)"LBL_DSC_DbConn"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jndiNameField, -1, 359, Short.MAX_VALUE).addPreferredGap(0)).add((Component)this.connCombo, 0, 359, Short.MAX_VALUE))).add((Component)this.errorLabel)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jndiNameField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0, 39, Short.MAX_VALUE).add((Component)this.errorLabel)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.connCombo, -2, -1, -2).addContainerGap()))));
    }
}

