/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config;

import java.beans.PropertyChangeEvent;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.exceptions.BeanNotFoundException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.jboss4.config.JBossDatasource;
import org.netbeans.modules.j2ee.jboss4.config.gen.Datasources;
import org.netbeans.modules.j2ee.jboss4.config.gen.LocalTxDatasource;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JBDeploymentConfiguration
implements DeploymentConfiguration {
    protected static final String JBOSS4_DATASOURCE_JNDI_PREFIX = "java:";
    protected static final String JBOSS4_MAIL_SERVICE_JNDI_NAME = "java:Mail";
    protected static final String JBOSS4_CONN_FACTORY_JNDI_NAME = "ConnectionFactory";
    protected static final String JBOSS4_EJB_JNDI_PREFIX = "java:comp/env/";
    static final String JBOSS4_MSG_QUEUE_JNDI_PREFIX = "queue/";
    static final String JBOSS4_MSG_TOPIC_JNDI_PREFIX = "topic/";
    private static final String DS_RESOURCE_NAME = "jboss-ds.xml";
    protected DeployableObject deplObj;
    protected DataObject deploymentDescriptorDO;
    private File resourceDir;
    private Datasources datasources;
    private File datasourcesFile;
    private DataObject datasourcesDO;

    public JBDeploymentConfiguration(DeployableObject deplObj) {
        this.deplObj = deplObj;
    }

    protected void init(File resourceDir) {
        this.resourceDir = resourceDir;
        this.datasourcesFile = new File(resourceDir, DS_RESOURCE_NAME);
        if (this.datasourcesFile.exists()) {
            try {
                this.ensureDatasourcesDOExists();
            }
            catch (DataObjectNotFoundException donfe) {
                ErrorManager.getDefault().notify((Throwable)donfe);
            }
        }
    }

    public DeployableObject getDeployableObject() {
        return this.deplObj;
    }

    public DConfigBeanRoot getDConfigBeanRoot(DDBeanRoot dDBeanRoot) throws ConfigurationException {
        return null;
    }

    public void removeDConfigBean(DConfigBeanRoot dConfigBeanRoot) throws BeanNotFoundException {
        throw new BeanNotFoundException("bean not found " + dConfigBeanRoot);
    }

    public void restore(InputStream is) throws ConfigurationException {
    }

    public DConfigBeanRoot restoreDConfigBean(InputStream is, DDBeanRoot dDBeanRoot) throws ConfigurationException {
        return null;
    }

    public void saveDConfigBean(OutputStream os, DConfigBeanRoot dConfigBeanRoot) throws ConfigurationException {
    }

    protected void writefile(final File file, final BaseBean bean) throws ConfigurationException {
        try {
            FileObject cfolder = FileUtil.toFileObject((File)file.getParentFile());
            if (cfolder == null) {
                File parentFile = file.getParentFile();
                try {
                    cfolder = FileUtil.toFileObject((File)parentFile.getParentFile()).createFolder(parentFile.getName());
                }
                catch (IOException ioe) {
                    throw new ConfigurationException(NbBundle.getMessage(JBDeploymentConfiguration.class, (String)"MSG_FailedToCreateConfigFolder", (Object)parentFile.getAbsolutePath()));
                }
            }
            final FileObject folder = cfolder;
            FileSystem fs = folder.getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    OutputStream os = null;
                    FileLock lock = null;
                    try {
                        String name = file.getName();
                        FileObject configFO = folder.getFileObject(name);
                        if (configFO == null) {
                            configFO = folder.createData(name);
                        }
                        lock = configFO.lock();
                        os = new BufferedOutputStream(configFO.getOutputStream(lock), 4086);
                        if (bean != null) {
                            bean.write(os);
                        }
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getLocalizedMessage());
        }
    }

    protected Set<Datasource> getDatasources() {
        HashSet<Datasource> projectDS = new HashSet<Datasource>();
        Datasources dss = this.getDatasourcesGraph();
        if (dss != null) {
            LocalTxDatasource[] ltxds = this.datasources.getLocalTxDatasource();
            for (int i = 0; i < ltxds.length; ++i) {
                if (ltxds[i].getJndiName().length() <= 0) continue;
                projectDS.add(new JBossDatasource(ltxds[i].getJndiName(), ltxds[i].getConnectionUrl(), ltxds[i].getUserName(), ltxds[i].getPassword(), ltxds[i].getDriverClass()));
            }
        }
        return projectDS;
    }

    public JBossDatasource createDatasource(String jndiName, String url, String username, String password, String driver) throws OperationUnsupportedException, ConfigurationException, DatasourceAlreadyExistsException {
        JBossDatasource ds = this.modifyDSResource(new DSResourceModifier(jndiName, url, username, password, driver){

            JBossDatasource modify(Datasources datasources) throws DatasourceAlreadyExistsException {
                LocalTxDatasource[] ltxds = datasources.getLocalTxDatasource();
                for (int i = 0; i < ltxds.length; ++i) {
                    String jndiName = ltxds[i].getJndiName();
                    if (!this.jndiName.equals(jndiName)) continue;
                    JBossDatasource ds = new JBossDatasource(jndiName, ltxds[i].getConnectionUrl(), ltxds[i].getUserName(), ltxds[i].getPassword(), ltxds[i].getDriverClass());
                    throw new DatasourceAlreadyExistsException((Datasource)ds);
                }
                LocalTxDatasource lds = new LocalTxDatasource();
                lds.setJndiName(this.jndiName);
                lds.setConnectionUrl(this.url);
                lds.setDriverClass(this.driver);
                lds.setUserName(this.username);
                lds.setPassword(this.password);
                lds.setMinPoolSize("5");
                lds.setMaxPoolSize("20");
                lds.setIdleTimeoutMinutes("5");
                datasources.addLocalTxDatasource(lds);
                return new JBossDatasource(this.jndiName, this.url, this.username, this.password, this.driver);
            }
        });
        return ds;
    }

    private synchronized Datasources getDatasourcesGraph() {
        block7: {
            try {
                if (this.datasourcesFile.exists()) {
                    try {
                        if (this.datasources == null) {
                            this.datasources = Datasources.createGraph(this.datasourcesFile);
                        }
                        break block7;
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                    catch (RuntimeException re) {}
                    break block7;
                }
                this.datasources = new Datasources();
                this.writefile(this.datasourcesFile, this.datasources);
            }
            catch (ConfigurationException ce) {
                ErrorManager.getDefault().notify((Throwable)ce);
            }
        }
        return this.datasources;
    }

    private void ensureResourceDirExists() {
        if (!this.resourceDir.exists()) {
            this.resourceDir.mkdir();
        }
    }

    private void ensureDatasourcesFilesExists() {
        if (!this.datasourcesFile.exists()) {
            this.getDatasourcesGraph();
        }
    }

    private void ensureDatasourcesDOExists() throws DataObjectNotFoundException {
        if (this.datasourcesDO == null || !this.datasourcesDO.isValid()) {
            FileObject datasourcesFO = FileUtil.toFileObject((File)this.datasourcesFile);
            assert (datasourcesFO != null);
            this.datasourcesDO = DataObject.find((FileObject)datasourcesFO);
            this.datasourcesDO.getPrimaryFile().addFileChangeListener((FileChangeListener)new DatasourceFileListener());
        }
    }

    public synchronized void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "modified" && evt.getNewValue() == Boolean.FALSE && evt.getSource() == this.datasourcesDO) {
            this.datasources = null;
        }
    }

    private JBossDatasource modifyDSResource(DSResourceModifier modifier) throws ConfigurationException, DatasourceAlreadyExistsException {
        JBossDatasource ds = null;
        try {
            this.ensureResourceDirExists();
            this.ensureDatasourcesFilesExists();
            this.ensureDatasourcesDOExists();
            EditorCookie editor = (EditorCookie)this.datasourcesDO.getCookie(EditorCookie.class);
            StyledDocument doc = editor.getDocument();
            if (doc == null) {
                doc = editor.openDocument();
            }
            Datasources newDatasources = null;
            try {
                byte[] docString = doc.getText(0, doc.getLength()).getBytes();
                newDatasources = Datasources.createGraph(new ByteArrayInputStream(docString));
            }
            catch (RuntimeException e) {
                Datasources oldDatasources = this.getDatasourcesGraph();
                if (oldDatasources == null) {
                    throw new ConfigurationException(NbBundle.getMessage(JBDeploymentConfiguration.class, (String)"MSG_datasourcesXmlCannotParse", (Object)DS_RESOURCE_NAME));
                }
                NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JBDeploymentConfiguration.class, (String)"MSG_datasourcesXmlNotValid", (Object)DS_RESOURCE_NAME), 2);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                if (result == NotifyDescriptor.CANCEL_OPTION) {
                    return null;
                }
                newDatasources = oldDatasources;
            }
            ds = modifier.modify(newDatasources);
            boolean modified = this.datasourcesDO.isModified();
            this.replaceDocument(doc, newDatasources);
            if (!modified) {
                SaveCookie cookie = (SaveCookie)this.datasourcesDO.getCookie(SaveCookie.class);
                cookie.save();
            }
            this.datasources = newDatasources;
        }
        catch (DataObjectNotFoundException donfe) {
            ErrorManager.getDefault().notify((Throwable)donfe);
        }
        catch (BadLocationException ble) {
            throw (ConfigurationException)new ConfigurationException().initCause((Throwable)ble);
        }
        catch (IOException ioe) {
            throw (ConfigurationException)new ConfigurationException().initCause((Throwable)ioe);
        }
        return ds;
    }

    protected void replaceDocument(final StyledDocument doc, BaseBean graph) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            graph.write((OutputStream)out);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
        NbDocument.runAtomic((StyledDocument)doc, (Runnable)new Runnable(){

            public void run() {
                try {
                    doc.remove(0, doc.getLength());
                    doc.insertString(0, out.toString(), null);
                }
                catch (BadLocationException ble) {
                    ErrorManager.getDefault().notify((Throwable)ble);
                }
            }
        });
    }

    private class DatasourceFileListener
    extends FileChangeAdapter {
        private DatasourceFileListener() {
        }

        public void fileChanged(FileEvent fe) {
            assert (fe.getSource() == JBDeploymentConfiguration.this.datasourcesDO.getPrimaryFile());
            JBDeploymentConfiguration.this.datasources = null;
        }

        public void fileDeleted(FileEvent fe) {
            assert (fe.getSource() == JBDeploymentConfiguration.this.datasourcesDO.getPrimaryFile());
            JBDeploymentConfiguration.this.datasources = null;
        }
    }

    private abstract class DSResourceModifier {
        String jndiName;
        String url;
        String username;
        String password;
        String driver;

        DSResourceModifier(String jndiName, String url, String username, String password, String driver) {
            this.jndiName = jndiName;
            this.url = url;
            this.username = username;
            this.password = password;
            this.driver = driver;
        }

        abstract JBossDatasource modify(Datasources var1) throws DatasourceAlreadyExistsException;
    }
}

