/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.Utils;
import org.openide.util.Utilities;

public abstract class LinkButton
extends JButton
implements Constants,
MouseListener,
ActionListener,
FocusListener {
    private boolean underline = false;
    final ImageIcon BULLET_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/welcome/resources/bullet.png"));

    public LinkButton(String label, boolean showBullet) {
        super(label);
        this.setForeground(Utils.getColor("HeaderTextColor"));
        this.setFont(REGULAR_FONT);
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setHorizontalAlignment(2);
        this.addMouseListener(this);
        this.setFocusable(true);
        if (showBullet) {
            this.setIcon(this.BULLET_ICON);
        }
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
        this.addActionListener(this);
        this.addFocusListener(this);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.underline = true;
        this.setForeground(Utils.getColor("RssLinkColor"));
        this.repaint();
        this.onMouseEntered(e);
    }

    public void mouseExited(MouseEvent e) {
        this.underline = false;
        this.setForeground(Utils.getColor("HeaderTextColor"));
        this.repaint();
        this.onMouseExited(e);
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = Utils.prepareGraphics(g);
        super.paintComponent(g2);
        Dimension size = this.getSize();
        if (this.hasFocus()) {
            g2.setStroke(LINK_IN_FOCUS_STROKE);
            g2.setColor(Utils.getColor("LinkInFocusColor"));
            g2.drawRect(0, 0, size.width - 1, size.height - 1);
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public void focusGained(FocusEvent e) {
        Rectangle rect = this.getBounds();
        rect.grow(0, FONT_SIZE);
        this.scrollRectToVisible(rect);
    }

    protected void onMouseExited(MouseEvent e) {
    }

    protected void onMouseEntered(MouseEvent e) {
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.underline) {
            Font f = this.getFont();
            FontMetrics fm = this.getFontMetrics(f);
            int iconWidth = 0;
            if (null != this.getIcon()) {
                iconWidth = this.getIcon().getIconWidth() + this.getIconTextGap();
            }
            int x1 = iconWidth;
            int y1 = fm.getHeight();
            int x2 = fm.stringWidth(this.getText()) + iconWidth;
            if (this.getText().length() > 0) {
                g.drawLine(x1, y1, x2, y1);
            }
        }
    }
}

