/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.wizards;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.j2ee.earproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.j2ee.earproject.ui.wizards.SettingsPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

final class PanelProjectImportVisual
extends SettingsPanel
implements DocumentListener {
    private final PanelConfigureProject panel;
    private final String propNameIndex;
    private final ResourceBundle customBundle;
    private final boolean importStyle;
    private String lastComputedPrjName;
    private String lastComputedPrjFolder;
    private boolean ignoreEvent;
    private boolean firstTime = true;
    private JButton browseFolderButton;
    private JButton browseLocationButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JTextArea descriptionArea;
    private JLabel instructionLabel;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JPanel spaceFiller;

    public PanelProjectImportVisual(PanelConfigureProject panel, String propNameIndex, ResourceBundle customBundle, boolean importStyle) {
        this.customBundle = customBundle;
        this.initComponents();
        this.panel = panel;
        this.propNameIndex = propNameIndex;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.importStyle = importStyle;
        this.createdFolderTextField.setEditable(importStyle);
        if (importStyle) {
            this.createdFolderTextField.getDocument().addDocumentListener(this);
        }
        this.browseFolderButton.setVisible(importStyle);
    }

    void addNameListener(DocumentListener listener) {
        this.projectNameTextField.getDocument().addDocumentListener(listener);
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseLocationButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.browseFolderButton = new JButton();
        this.instructionLabel = new JLabel();
        this.descriptionArea = new JTextArea();
        this.spaceFiller = new JPanel();
        this.setLayout(new GridBagLayout());
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(PanelProjectImportVisual.class, (String)"LBL_NWP1_ProjectName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.add((Component)this.projectNameTextField, gridBagConstraints);
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectImportVisual.class, (String)"ACS_LBL_NWP1_ProjectName_A11YDesc"));
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(PanelProjectImportVisual.class, (String)"LBL_ImportLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.add((Component)this.projectLocationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.add((Component)this.projectLocationTextField, gridBagConstraints);
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectImportVisual.class, (String)"ACS_LBL_NPW1_ProjectLocation_A11YDesc"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseLocationButton, (String)NbBundle.getMessage(PanelProjectImportVisual.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.browseLocationButton.setActionCommand("BROWSE");
        this.browseLocationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelProjectImportVisual.this.browseLocationAction(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 0);
        this.add((Component)this.browseLocationButton, gridBagConstraints);
        this.browseLocationButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectImportVisual.class, (String)"ACS_LBL_NWP1_BrowseLocation_A11YDesc"));
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(PanelProjectImportVisual.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.createdFolderLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.createdFolderTextField, gridBagConstraints);
        this.createdFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectImportVisual.class, (String)"ACS_LBL_NWP1_CreatedProjectFolder_A11YDesc"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseFolderButton, (String)NbBundle.getMessage(PanelProjectImportVisual.class, (String)"LBL_NWP1_BrowseProjectFolder_Button"));
        this.browseFolderButton.setActionCommand("BROWSE");
        this.browseFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelProjectImportVisual.this.browseFolderAction(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.browseFolderButton, gridBagConstraints);
        this.browseFolderButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectImportVisual.class, (String)"ACSN_LBL_NWP1_BrowseProjectFolder_Button"));
        this.browseFolderButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectImportVisual.class, (String)"ACSD_LBL_NWP1_BrowseProjectFolder_Button"));
        this.instructionLabel.setBackground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)this.instructionLabel, (String)NbBundle.getMessage(PanelProjectImportVisual.class, (String)"LBL_ImportInstructions2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.instructionLabel, gridBagConstraints);
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setRows(2);
        this.descriptionArea.setText(NbBundle.getMessage(PanelProjectImportVisual.class, (String)"LBL_ImportInstructions1"));
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.descriptionArea, gridBagConstraints);
        this.descriptionArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectImportVisual.class, (String)"ACSN_LBL_ImportInstructions1"));
        this.descriptionArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectImportVisual.class, (String)"ACSD_LBL_ImportInstructions1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.spaceFiller, gridBagConstraints);
    }

    private void browseFolderAction(ActionEvent evt) {
        String command = evt.getActionCommand();
        if ("BROWSE".equals(command)) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(this.customBundle.getString("LBL_NWP1_BrowseProjectFolder"));
            chooser.setFileSelectionMode(1);
            String path = this.getCreatedFolderText();
            if (path.length() > 0) {
                File f = new File(path);
                if (f.exists()) {
                    chooser.setSelectedFile(f);
                }
            } else {
                chooser.setSelectedFile(ProjectChooser.getProjectsFolder());
            }
            if (0 == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                this.createdFolderTextField.setText(projectDir.getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    private void browseLocationAction(ActionEvent evt) {
        String command = evt.getActionCommand();
        if ("BROWSE".equals(command)) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(this.customBundle.getString("LBL_NWP1_SelectProjectLocation"));
            chooser.setFileSelectionMode(1);
            String path = this.projectLocationTextField.getText();
            if (path.length() > 0) {
                File f = new File(path);
                if (f.exists()) {
                    chooser.setSelectedFile(f);
                }
            } else {
                chooser.setSelectedFile(ProjectChooser.getProjectsFolder());
            }
            if (0 == chooser.showOpenDialog(this)) {
                File projectDir = chooser.getSelectedFile();
                this.projectLocationTextField.setText(projectDir.getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        String sourceLocationPath = this.projectLocationTextField.getText().trim();
        if (sourceLocationPath.length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)this.customBundle.getString("MSG_ProvideExistingSourcesLocation"));
            return false;
        }
        if (!SettingsPanel.isValidProjectName(this.projectNameTextField.getText())) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)this.customBundle.getString("MSG_IllegalProjectName"));
            return false;
        }
        if (this.importStyle && this.getCreatedFolderText().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)this.customBundle.getString("MSG_EmptyProjectFolder"));
            return false;
        }
        File destParent = SettingsPanel.findExistingParent(this.getCreatedFolderText());
        File destDir = new File(this.getCreatedFolderText());
        if (destDir.exists() && !destDir.isDirectory()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)MessageFormat.format(this.customBundle.getString("MSG_WillOverwrite"), destDir.getAbsolutePath()));
            return false;
        }
        File buildXml = new File(this.getCreatedFolderText() + File.separator + "build.xml");
        if (buildXml.exists()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)MessageFormat.format(this.customBundle.getString("MSG_WillOverwrite"), buildXml.getAbsolutePath()));
            return false;
        }
        File tFile = null;
        tFile = new File(this.getCreatedFolderText() + File.separator + "nbproject" + File.separator + "project.xml");
        if (tFile.exists()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)MessageFormat.format(this.customBundle.getString("MSG_AlreadyExixts"), tFile.getAbsolutePath()));
            return false;
        }
        tFile = new File(this.getCreatedFolderText() + File.separator + "nbproject" + File.separator + "project.properties");
        if (tFile.exists()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)MessageFormat.format(this.customBundle.getString("MSG_AlreadyExixts"), tFile.getAbsolutePath()));
            return false;
        }
        if (null != destParent && destParent.exists() && !destParent.canWrite()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)MessageFormat.format(this.customBundle.getString("MSG_ProjectLocationRO"), destParent.getAbsolutePath()));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    void store(WizardDescriptor d) {
        String name = this.projectNameTextField.getText().trim();
        d.putProperty("projdir", (Object)new File(this.getCreatedFolderText()));
        d.putProperty("name", (Object)name);
        File srcRoot = null;
        String srcPath = this.projectLocationTextField.getText();
        if (srcPath.length() > 0) {
            srcRoot = FileUtil.normalizeFile((File)new File(srcPath));
        }
        d.putProperty("sourceRoot", srcRoot);
    }

    void read(WizardDescriptor settings) {
        String projectName;
        if (!this.firstTime) {
            return;
        }
        this.firstTime = false;
        File projectLocation = PanelProjectImportVisual.getPreferredProjectLocation(settings);
        if (null != projectLocation && (projectName = (String)settings.getProperty("name")) == null) {
            int baseCount = 1;
            String formater = this.customBundle.getString("TXT_DefaultProjectName");
            while ((projectName = this.validFreeProjectName(projectLocation, formater, baseCount)) == null) {
                ++baseCount;
            }
            settings.putProperty(this.propNameIndex, (Object)baseCount);
        }
        this.projectNameTextField.selectAll();
    }

    private static File getPreferredProjectLocation(WizardDescriptor settings) {
        File projectLocation = null;
        FileObject existingSourcesFO = Templates.getExistingSourcesFolder((WizardDescriptor)settings);
        if (existingSourcesFO != null) {
            File existingSourcesFile = FileUtil.toFile((FileObject)existingSourcesFO);
            if (existingSourcesFile != null && existingSourcesFile.isDirectory()) {
                projectLocation = existingSourcesFile;
            }
        } else {
            projectLocation = (File)settings.getProperty("projdir");
            projectLocation = projectLocation == null ? ProjectChooser.getProjectsFolder() : projectLocation.getParentFile();
        }
        return projectLocation;
    }

    private String validFreeProjectName(File parentFolder, String formater, int index) {
        String name = MessageFormat.format(formater, index);
        File file = new File(parentFolder, name);
        return file.exists() ? null : name;
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateTexts(e);
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateTexts(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateTexts(e);
    }

    private void updateTexts(DocumentEvent e) {
        if (!this.importStyle) {
            this.createdFolderTextField.setText(this.getCreatedFolderPath());
        } else {
            if (this.ignoreEvent) {
                return;
            }
            this.ignoreEvent = true;
            if (e.getDocument() != this.projectNameTextField.getDocument()) {
                this.updateProjectName();
            }
            if (e.getDocument() != this.createdFolderTextField.getDocument()) {
                this.updateProjectFolder();
            }
            this.ignoreEvent = false;
        }
        this.panel.fireChangeEvent();
    }

    private void updateProjectName() {
        String prjName = this.computeProjectName();
        if (this.lastComputedPrjName != null && !this.lastComputedPrjName.equals(this.projectNameTextField.getText().trim())) {
            return;
        }
        this.lastComputedPrjName = prjName;
        if (prjName != null) {
            this.projectNameTextField.setText(prjName);
        }
    }

    private String computeProjectName() {
        String cPrjName = null;
        File f = FileUtil.normalizeFile((File)new File(this.projectLocationTextField.getText()));
        FileObject fo = FileUtil.toFileObject((File)f);
        if (fo != null) {
            cPrjName = fo.getName();
        }
        return cPrjName;
    }

    private void updateProjectFolder() {
        String prjFolder = this.computeProjectFolder();
        if (this.lastComputedPrjFolder != null && !this.lastComputedPrjFolder.equals(this.createdFolderTextField.getText().trim())) {
            return;
        }
        this.lastComputedPrjFolder = prjFolder;
        if (prjFolder != null) {
            this.createdFolderTextField.setText(prjFolder);
        } else {
            this.createdFolderTextField.setText("");
        }
    }

    private String computeProjectFolder() {
        return FileUtil.normalizeFile((File)new File(this.projectLocationTextField.getText())).getAbsolutePath();
    }

    private String getCreatedFolderPath() {
        StringBuffer folder = new StringBuffer(this.projectLocationTextField.getText().trim());
        if (!this.importStyle) {
            if (!this.projectLocationTextField.getText().endsWith(File.separator)) {
                folder.append(File.separatorChar);
            }
            folder.append(this.projectNameTextField.getText().trim());
        }
        return folder.toString();
    }

    private String getCreatedFolderText() {
        return this.createdFolderTextField.getText().trim();
    }
}

